"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeCommitSourceCodeProvider = exports.GitLabSourceCodeProvider = exports.GitHubSourceCodeProvider = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) GitHub source code provider.
 *
 * @experimental
 */
class GitHubSourceCodeProvider {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_GitHubSourceCodeProviderProps(props);
    }
    /**
     * (experimental) Binds the source code provider to an app.
     *
     * @experimental
     */
    bind(_app) {
        jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_App(_app);
        return {
            repository: `https://github.com/${this.props.owner}/${this.props.repository}`,
            oauthToken: this.props.oauthToken,
        };
    }
}
exports.GitHubSourceCodeProvider = GitHubSourceCodeProvider;
_a = JSII_RTTI_SYMBOL_1;
GitHubSourceCodeProvider[_a] = { fqn: "@aws-cdk/aws-amplify-alpha.GitHubSourceCodeProvider", version: "2.5.0-alpha.0" };
/**
 * (experimental) GitLab source code provider.
 *
 * @experimental
 */
class GitLabSourceCodeProvider {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_GitLabSourceCodeProviderProps(props);
    }
    /**
     * (experimental) Binds the source code provider to an app.
     *
     * @experimental
     */
    bind(_app) {
        jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_App(_app);
        return {
            repository: `https://gitlab.com/${this.props.owner}/${this.props.repository}`,
            oauthToken: this.props.oauthToken,
        };
    }
}
exports.GitLabSourceCodeProvider = GitLabSourceCodeProvider;
_b = JSII_RTTI_SYMBOL_1;
GitLabSourceCodeProvider[_b] = { fqn: "@aws-cdk/aws-amplify-alpha.GitLabSourceCodeProvider", version: "2.5.0-alpha.0" };
/**
 * (experimental) CodeCommit source code provider.
 *
 * @experimental
 */
class CodeCommitSourceCodeProvider {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_CodeCommitSourceCodeProviderProps(props);
    }
    /**
     * (experimental) Binds the source code provider to an app.
     *
     * @experimental
     */
    bind(app) {
        jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_App(app);
        this.props.repository.grantPull(app);
        return {
            repository: this.props.repository.repositoryCloneUrlHttp,
        };
    }
}
exports.CodeCommitSourceCodeProvider = CodeCommitSourceCodeProvider;
_c = JSII_RTTI_SYMBOL_1;
CodeCommitSourceCodeProvider[_c] = { fqn: "@aws-cdk/aws-amplify-alpha.CodeCommitSourceCodeProvider", version: "2.5.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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