# AUTOGENERATED! DO NOT EDIT! File to edit: compress.ipynb (unless otherwise specified).

__all__ = ['compressDict', 'decompressDict', 'compressString', 'decompressString']

# Cell
import gzip, zlib, base64, pickle
from typing import Callable, Optional, List, Dict
from beartype import beartype

# Cell
@beartype
def compressDict(data:(List,Dict),encoder:Callable= pickle.dumps,
                 compressor:Callable=zlib.compress,
                 stringifier:Callable = base64.b64encode)->bytes:
  compressedData =  compressor(encoder(data))
  return stringifier(compressedData)

# Cell
@beartype
def decompressDict( data:(bytes,str),
                   decoder = pickle.loads,
                   decompressor:Callable= zlib.decompress,
                   destringifier:Callable = base64.b64decode)->(List,Dict):
  compressedData = destringifier(data)
  return decoder(decompressor(compressedData))

# Cell
@beartype
def compressString(data:str ,
                 compressor:Callable=zlib.compress,
                 stringifier:Callable = base64.b64encode)->str:
  compressedData =  compressor(data.encode())
  return stringifier(compressedData).decode()

# Cell
@beartype
def decompressString(data:(bytes,str),
                   decompressor:Callable= zlib.decompress,
                   destringifier:Callable = base64.b64decode)->str:
  compressedData = destringifier(data)
  return decompressor(compressedData).decode()