# AUTOGENERATED! DO NOT EDIT! File to edit: github.ipynb (unless otherwise specified).

__all__ = ['githubGet', 'githubGetYaml']

# Cell
import requests
from requests import get, Response
from beartype import beartype

# Cell
@beartype
def githubGet(url:str, token:str)->Response:
  '''
    get request to github using token
    parameters:
      url:str: github raw file url
      token:str: your personal access token
    response:
      response: requests.Response: response object
  '''
  r = requests.get(url, headers = {"Authorization": f"token {token}"})
  return r

# Cell
@beartype
def githubGetYaml(url:str, token:str)->dict:
  '''
    get yaml dictionary from github using token
    parameters:
      url:str: github raw file url
      token:str: your personal access token
    response:
      response: dict: yaml dictionary
  '''
  import yaml
  r = githubGet(url, token)
  return yaml.load(r.text,Loader=yaml.FullLoader)
