# AUTOGENERATED! DO NOT EDIT! File to edit: Images.ipynb (unless otherwise specified).

__all__ = ['imageFromS3', 'imageFromUrl', 'imageToS3', 'resizeImage', 'showImgS3']

# Cell
from io import BytesIO
from PIL import Image
from s3bz.s3bz import S3
import requests

# Cell
def imageFromS3(bucket:str, key:str, **kwargs):
  '''
  obtain the image url from the S3 bucket and returns it \n
  bucket: str: the name of the bucket containing the image \n
  key: str: the key of the image
  '''
  url=S3.presign(key,bucket=bucket,expiry=10, **kwargs)
  return imageFromUrl(url)


# Cell
def imageFromUrl(url):
  '''
  returns the image from the inputted url \n
  url: str: the url of the image
  '''
  from io import BytesIO
  image = Image.open(BytesIO(requests.get(url).content))
  return image

# Cell
def imageToS3(image:Image, bucket:str, key:str):
  '''
  saves the image inputted to the S3 bucket \n
  image: Image: the image that is going to be saved \n
  bucket: str: the name of the bucket where the image will be saved \n,
  key: str: the key of the image
  '''
  path = '/tmp/tmpImage'
  print(f'saving image to {bucket}/{key}')
  image.save(path,format='png')
  S3.saveFile(key,path,bucket)
  return True

# Cell
def resizeImage(url:str,width:int):
  '''
  resize the image from the url to the width stated \n
  url: the url of the image \n
  width: int: the image will be resized to this width (measured in pixels)
  '''
  from resizeimage import resizeimage
  img = imageFromUrl(url)
  resizedImg = resizeimage.resize_width(img, 200)
  return resizedImg

# Cell
def showImgS3(bucket:str, key:str):
  '''
  show the image obtained from the S3 bucket \n
  bucket: str: the name of the bucket containing the image \n
  key: str: the key of the image
  '''
  from matplotlib.pyplot import imshow
  import time
  imageFound = False
  while imageFound == False:
    if S3.exist( key,bucket=bucket):
      url = S3.presign(key,expiry='10',bucket=bucket)
      img = imageFromUrl(url)
      imshow(img)
      imageFound = True
    else:
      print('conversion failed or didnt happen')
      time.sleep(1)