# AUTOGENERATED! DO NOT EDIT! File to edit: timer.ipynb (unless otherwise specified).

__all__ = ['logger', 'Timer', 'start_timer', 'reset_timer', 'print_time', 'print_reset', 'log_time', 'log_reset']

# Cell
from .wrappers import add_class_method,add_method,add_static_method
from datetime import datetime, timedelta
import logging
logger = logging.getLogger(name='timer')

# Cell
class Timer:
  '''
  This is the class that will be used for the timer
  '''
  def __init__(self):
    self.start_timer()
  pass


# Cell
@add_method(Timer)
def start_timer(self):
  '''
  this method sets the starting time t0 to the current time
  '''
  self.t0 = datetime.now()
@add_method(Timer)
def reset_timer(self):
  '''
  this method resets t0 to the current time
  '''
  self.t0 = datetime.now()

# Cell
@add_method(Timer)
def print_time(self, description = 'fuction took'):
  '''
  this method subtracts the current time by t0 and prints the value in seconds to find out time between start timer and this method \n
  description: str: this is the string to be added before the value of time taken, default = 'function took'
  '''
  t1:timedelta = datetime.now() - self.t0
  print(f'{description} :{t1.total_seconds()} s')
  return t1.total_seconds()

# Cell
@add_method(Timer)
def print_reset(self, description = 'function took'):
  '''
  print and reset timer \n
  description: str: description of the item to print
  '''

  r = self.print_time(description = description)
  self.reset_timer()
  return r

# Cell
@add_method(Timer)
def log_time(self, description = 'fuction took', logger = logger.debug):
  '''
  this method subtracts the current time by t0 and prints the value in seconds to find out time between start timer and this method \n
  parameters:
    description: str: this is the string to be added before the value of time taken, default = 'function took'
    logger: callable: a callable for logging, default: logging.debug
  response:
    time:float:: time in second
  '''
  t1:timedelta = datetime.now() - self.t0
  logger(f'{description} :{t1.total_seconds()} s')
  return t1.total_seconds()

# Cell
@add_method(Timer)
def log_reset(self, description = 'function took', logger = logger.debug):
  '''
  print and reset timer \n
  parameters:
    description:  str: description of the item to print
    logger: callable: a callable for logging, default: logging.debug
  response:
    time:float:: time in second

  '''

  r = self.log_time(description = description,logger=logger)
  self.reset_timer()
  return r