# mypy-boto3-comprehend

[![PyPI - mypy-boto3-comprehend](https://img.shields.io/pypi/v/mypy-boto3-comprehend.svg?color=blue)](https://pypi.org/project/mypy-boto3-comprehend)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-comprehend.svg?color=blue)](https://pypi.org/project/mypy-boto3-comprehend)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

- [mypy-boto3-comprehend](#mypy-boto3-comprehend)
  - [How to use](#how-to-use)
  - [Automated type discovery](#automated-type-discovery)


Type annotations for
[boto3.Comprehend 1.13.25](https://boto3.amazonaws.com/v1/documentation/api/1.13.25/reference/services/comprehend.html#Comprehend) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.0.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-comprehend](#mypy-boto3-comprehend)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `Comprehend` service.

```bash
python -m pip install boto3-stubs[comprehend]

# update installed packages index for automated type discovery
python -m mypy_boto3
```

Use `boto3` with `mypy_boto3_comprehend` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3_comprehend import ComprehendClient

# Now mypy can check if your code is valid.
client: ComprehendClient = boto3.client("comprehend")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ComprehendClient = session.client("comprehend")



# Annotated paginators are included as well

import mypy_boto3_comprehend.paginator as comprehend_paginators

list_document_classification_jobs_paginator: comprehend_paginators.ListDocumentClassificationJobsPaginator = client.get_paginator("list_document_classification_jobs")
list_document_classifiers_paginator: comprehend_paginators.ListDocumentClassifiersPaginator = client.get_paginator("list_document_classifiers")
list_dominant_language_detection_jobs_paginator: comprehend_paginators.ListDominantLanguageDetectionJobsPaginator = client.get_paginator("list_dominant_language_detection_jobs")
list_entities_detection_jobs_paginator: comprehend_paginators.ListEntitiesDetectionJobsPaginator = client.get_paginator("list_entities_detection_jobs")
list_entity_recognizers_paginator: comprehend_paginators.ListEntityRecognizersPaginator = client.get_paginator("list_entity_recognizers")
list_key_phrases_detection_jobs_paginator: comprehend_paginators.ListKeyPhrasesDetectionJobsPaginator = client.get_paginator("list_key_phrases_detection_jobs")
list_sentiment_detection_jobs_paginator: comprehend_paginators.ListSentimentDetectionJobsPaginator = client.get_paginator("list_sentiment_detection_jobs")
list_topics_detection_jobs_paginator: comprehend_paginators.ListTopicsDetectionJobsPaginator = client.get_paginator("list_topics_detection_jobs")
```

## Automated type discovery

`mypy_boto3` package can generate index for `mypy_boto3_comprehend` and other installed services.

```bash
# Run this command when you add or remove service packages
python -m mypy_boto3
```

Generated index provides overloads for `boto3.client` and `boto3.service`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully
- `VSCode` does not currently support function overloads

Also, generated index allows you to import types from `mypy_boto3`:

```python
# you can replace imports
import mypy_boto3_comprehend as comprehend
from mypy_boto3_comprehend import ComprehendClient

# with these
from mypy_boto3 import comprehend
from mypy_boto3.comprehend import ComprehendClient
```