# coding: utf-8

"""
    Data Repository API

    This document defines the REST API for Data Repository. **Status: design in progress** There are four top-level endpoints (besides some used by swagger):  * /swagger-ui.html - generated by swagger: swagger API page that provides this documentation and a live UI for      submitting REST requests  * /status - provides the operational status of the service  * /api    - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The overall API (/api) currently supports two interfaces:  * Repository - a general and default interface for initial setup, managing ingest and repository metadata  * Resource - an interface for managing billing accounts and resources  The API endpoints are organized by interface. Each interface is separately versioned. ## Notes on Naming All of the reference items are suffixed with \"Model\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. ## Editing and debugging I have found it best to edit this file directly to make changes and then use the swagger-editor to validate. The errors out of swagger-codegen are not that helpful. In the swagger-editor, it gives you nice errors and links to the place in the YAML where the errors are. But... the swagger-editor has been a bit of a pain for me to run. I tried the online website and was not able to load my YAML. Instead, I run it locally in a docker container, like this: ``` docker pull swaggerapi/swagger-editor docker run -p 9090:8080 swaggerapi/swagger-editor ``` Then navigate to localhost:9090 in your browser. I have not been able to get the file upload to work. It is a bit of a PITA, but I copy-paste the source code, replacing what is in the editor. Then make any fixes. Then copy-paste the resulting, valid file back into our source code. Not elegant, but easier than playing detective with the swagger-codegen errors. This might be something about my browser or environment, so give it a try yourself and see how it goes. ## Merging the DRS standard swagger into this swagger ## The merging is done in three sections:  1. Merging the security definitions into our security definitions  2. This section of paths. We make all paths explicit (prefixed with /ga4gh/drs/v1)     All standard DRS definitions and parameters are prefixed with 'DRS' to separate them     from our native definitions and parameters. We remove the x-swagger-router-controller lines.  3. A separate part of the definitions section for the DRS definitions  NOTE: the code here does not relect the DRS spec anymore. See DR-409.   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class BillingProfileRequestModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'billing_account_id': 'str',
        'profile_name': 'str',
        'biller': 'str',
        'description': 'str',
        'cloud_platform': 'CloudPlatform',
        'tenant_id': 'str',
        'subscription_id': 'str',
        'resource_group_name': 'str',
        'application_deployment_name': 'str'
    }

    attribute_map = {
        'id': 'id',
        'billing_account_id': 'billingAccountId',
        'profile_name': 'profileName',
        'biller': 'biller',
        'description': 'description',
        'cloud_platform': 'cloudPlatform',
        'tenant_id': 'tenantId',
        'subscription_id': 'subscriptionId',
        'resource_group_name': 'resourceGroupName',
        'application_deployment_name': 'applicationDeploymentName'
    }

    def __init__(self, id=None, billing_account_id=None, profile_name=None, biller=None, description=None, cloud_platform=None, tenant_id=None, subscription_id=None, resource_group_name=None, application_deployment_name=None, local_vars_configuration=None):  # noqa: E501
        """BillingProfileRequestModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._billing_account_id = None
        self._profile_name = None
        self._biller = None
        self._description = None
        self._cloud_platform = None
        self._tenant_id = None
        self._subscription_id = None
        self._resource_group_name = None
        self._application_deployment_name = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if billing_account_id is not None:
            self.billing_account_id = billing_account_id
        self.profile_name = profile_name
        self.biller = biller
        if description is not None:
            self.description = description
        if cloud_platform is not None:
            self.cloud_platform = cloud_platform
        if tenant_id is not None:
            self.tenant_id = tenant_id
        if subscription_id is not None:
            self.subscription_id = subscription_id
        if resource_group_name is not None:
            self.resource_group_name = resource_group_name
        if application_deployment_name is not None:
            self.application_deployment_name = application_deployment_name

    @property
    def id(self):
        """Gets the id of this BillingProfileRequestModel.  # noqa: E501

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :return: The id of this BillingProfileRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this BillingProfileRequestModel.

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :param id: The id of this BillingProfileRequestModel.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def billing_account_id(self):
        """Gets the billing_account_id of this BillingProfileRequestModel.  # noqa: E501

        unique identifier of the billing account from Google  # noqa: E501

        :return: The billing_account_id of this BillingProfileRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._billing_account_id

    @billing_account_id.setter
    def billing_account_id(self, billing_account_id):
        """Sets the billing_account_id of this BillingProfileRequestModel.

        unique identifier of the billing account from Google  # noqa: E501

        :param billing_account_id: The billing_account_id of this BillingProfileRequestModel.  # noqa: E501
        :type: str
        """

        self._billing_account_id = billing_account_id

    @property
    def profile_name(self):
        """Gets the profile_name of this BillingProfileRequestModel.  # noqa: E501

        display name to be used for the profile;  # noqa: E501

        :return: The profile_name of this BillingProfileRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._profile_name

    @profile_name.setter
    def profile_name(self, profile_name):
        """Sets the profile_name of this BillingProfileRequestModel.

        display name to be used for the profile;  # noqa: E501

        :param profile_name: The profile_name of this BillingProfileRequestModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and profile_name is None:  # noqa: E501
            raise ValueError("Invalid value for `profile_name`, must not be `None`")  # noqa: E501

        self._profile_name = profile_name

    @property
    def biller(self):
        """Gets the biller of this BillingProfileRequestModel.  # noqa: E501

        either “direct” or the reseller of the sub-account that sends the bill (like “on_spend”)  # noqa: E501

        :return: The biller of this BillingProfileRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._biller

    @biller.setter
    def biller(self, biller):
        """Sets the biller of this BillingProfileRequestModel.

        either “direct” or the reseller of the sub-account that sends the bill (like “on_spend”)  # noqa: E501

        :param biller: The biller of this BillingProfileRequestModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and biller is None:  # noqa: E501
            raise ValueError("Invalid value for `biller`, must not be `None`")  # noqa: E501

        self._biller = biller

    @property
    def description(self):
        """Gets the description of this BillingProfileRequestModel.  # noqa: E501

        Free text that describes the profile  # noqa: E501

        :return: The description of this BillingProfileRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this BillingProfileRequestModel.

        Free text that describes the profile  # noqa: E501

        :param description: The description of this BillingProfileRequestModel.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def cloud_platform(self):
        """Gets the cloud_platform of this BillingProfileRequestModel.  # noqa: E501


        :return: The cloud_platform of this BillingProfileRequestModel.  # noqa: E501
        :rtype: CloudPlatform
        """
        return self._cloud_platform

    @cloud_platform.setter
    def cloud_platform(self, cloud_platform):
        """Sets the cloud_platform of this BillingProfileRequestModel.


        :param cloud_platform: The cloud_platform of this BillingProfileRequestModel.  # noqa: E501
        :type: CloudPlatform
        """

        self._cloud_platform = cloud_platform

    @property
    def tenant_id(self):
        """Gets the tenant_id of this BillingProfileRequestModel.  # noqa: E501

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :return: The tenant_id of this BillingProfileRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """Sets the tenant_id of this BillingProfileRequestModel.

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :param tenant_id: The tenant_id of this BillingProfileRequestModel.  # noqa: E501
        :type: str
        """

        self._tenant_id = tenant_id

    @property
    def subscription_id(self):
        """Gets the subscription_id of this BillingProfileRequestModel.  # noqa: E501

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :return: The subscription_id of this BillingProfileRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._subscription_id

    @subscription_id.setter
    def subscription_id(self, subscription_id):
        """Sets the subscription_id of this BillingProfileRequestModel.

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :param subscription_id: The subscription_id of this BillingProfileRequestModel.  # noqa: E501
        :type: str
        """

        self._subscription_id = subscription_id

    @property
    def resource_group_name(self):
        """Gets the resource_group_name of this BillingProfileRequestModel.  # noqa: E501

        an optional resource group name for Azure  # noqa: E501

        :return: The resource_group_name of this BillingProfileRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._resource_group_name

    @resource_group_name.setter
    def resource_group_name(self, resource_group_name):
        """Sets the resource_group_name of this BillingProfileRequestModel.

        an optional resource group name for Azure  # noqa: E501

        :param resource_group_name: The resource_group_name of this BillingProfileRequestModel.  # noqa: E501
        :type: str
        """

        self._resource_group_name = resource_group_name

    @property
    def application_deployment_name(self):
        """Gets the application_deployment_name of this BillingProfileRequestModel.  # noqa: E501

        an optional name for an application deployment for Azure  # noqa: E501

        :return: The application_deployment_name of this BillingProfileRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._application_deployment_name

    @application_deployment_name.setter
    def application_deployment_name(self, application_deployment_name):
        """Sets the application_deployment_name of this BillingProfileRequestModel.

        an optional name for an application deployment for Azure  # noqa: E501

        :param application_deployment_name: The application_deployment_name of this BillingProfileRequestModel.  # noqa: E501
        :type: str
        """

        self._application_deployment_name = application_deployment_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BillingProfileRequestModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BillingProfileRequestModel):
            return True

        return self.to_dict() != other.to_dict()
