
[![PyPI](https://img.shields.io/pypi/v/geometric_algebra_attention.svg?style=flat)](https://pypi.org/project/geometric_algebra_attention/)
[![ReadTheDocs](https://img.shields.io/readthedocs/geometric_algebra_attention.svg?style=flat)](https://geometric_algebra_attention.readthedocs.io/en/latest/)

# Introduction

This is a library in development for implementing geometric algebra
attention mechanisms (as detailed in the paper [Geometric Algebra
Attention Networks for Small Point
Clouds](https://arxiv.org/abs/2110.02393) in tensorflow, keras,
pytorch, and jax.

# Installation

The latest tagged version of `geometric-algebra-attention` is
available on PyPI for installation via pip:

```
$ pip install geometric-algebra-attention
```

Alternatively, install the package from source:

```
$ git clone https://github.com/klarh/geometric_algebra_attention
$ pip install ./geometric_algebra_attention
```

# Documentation

The documentation is available as standard sphinx documentation:

```
$ cd doc
$ pip install -r requirements.txt
$ make html
```

Automatically-built documentation is available at
https://geometric-algebra-attention.readthedocs.io .

# Examples

Jupyter notebook examples for various backends are available in the
`examples` directory of the source repository.
