## ClimateDT dictionary of parameters
climateDT_params = [
    {
        'param': '78',
        'paramName': 'Total column cloud liquid water',
        'shortName': 'tclw',
        'unit': 'kg m**-2',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '79',
        'paramName': 'Total column cloud ice water',
        'shortName': 'tciw',
        'unit': 'kg m**-2',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '130',
        'paramName': 'Temperature',
        'shortName': 't',
        'unit': 'K',
        'encoding': 'instantaneous',
        'isNemo': '',
        'isIcon': 'ICON',
        'isFESOM': '',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '134',
        'paramName': 'Surface pressure',
        'shortName': 'sp',
        'unit': 'Pa',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '137',
        'paramName': 'Total column vertically-integrated water vapour',
        'shortName': 'tcwv',
        'unit': 'kg m**-2',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '141',
        'paramName': 'Snow depth',
        'shortName': 'sd',
        'unit': 'm of water equivalent',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': '',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '148',
        'paramName': 'Charnock',
        'shortName': 'chnk',
        'unit': 'Numeric',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': '',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '151',
        'paramName': 'Mean sea level pressure',
        'shortName': 'msl',
        'unit': 'Pa',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '159',
        'paramName': 'Boundary layer height',
        'shortName': 'blh',
        'unit': 'm',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': '',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '164',
        'paramName': 'Total cloud cover',
        'shortName': 'tcc',
        'unit': '(0 - 1)',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': '',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '165',
        'paramName': '10 metre U wind component',
        'shortName': '10u',
        'unit': 'm s**-1',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '166',
        'paramName': '10 metre V wind component',
        'shortName': '10v',
        'unit': 'm s**-1',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '167',
        'paramName': '2 metre temperature',
        'shortName': '2t',
        'unit': 'K',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '168',
        'paramName': '2 metre dewpoint temperature',
        'shortName': '2d',
        'unit': 'K',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '186',
        'paramName': 'Low cloud cover',
        'shortName': 'lcc',
        'unit': '(0 - 1)',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': '',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '187',
        'paramName': 'Medium cloud cover',
        'shortName': 'mcc',
        'unit': '(0 - 1)',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': '',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '188',
        'paramName': 'High cloud cover',
        'shortName': 'hcc',
        'unit': '(0 - 1)',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': '',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '235',
        'paramName': 'Skin temperature',
        'shortName': 'skt',
        'unit': 'K',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '228164',
        'paramName': 'Total cloud cover',
        'shortName': 'tcc',
        'unit': '%',
        'encoding': 'instantaneous',
        'isNemo': '',
        'isIcon': 'ICON',
        'isFESOM': '',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '260048',
        'paramName': 'Total precipitation rate',
        'shortName': 'tprate',
        'unit': 'kg m**-2 s**-1',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '129',
        'paramName': 'Geopotential',
        'shortName': 'z',
        'unit': 'm**2 s**-2',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': '',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Daily',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '172',
        'paramName': 'Land-sea mask',
        'shortName': 'lsm',
        'unit': '(0 - 1)',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': '',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Daily',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '60',
        'paramName': 'Potential vorticity',
        'shortName': 'pv',
        'unit': 'K m**2 kg**-1 s**-1',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': '',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'pl',
        'levelist': '1000/925/850/700/600/500/400/300/250/200/150/100/70/50/30/20/10/5/1'
    },
    {
        'param': '129',
        'paramName': 'Geopotential',
        'shortName': 'z',
        'unit': 'm**2 s**-2',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'pl',
        'levelist': '1000/925/850/700/600/500/400/300/250/200/150/100/70/50/30/20/10/5/1'
    },
    {
        'param': '130',
        'paramName': 'Temperature',
        'shortName': 't',
        'unit': 'K',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'pl',
        'levelist': '1000/925/850/700/600/500/400/300/250/200/150/100/70/50/30/20/10/5/1'
    },
    {
        'param': '131',
        'paramName': 'U component of wind',
        'shortName': 'u',
        'unit': 'm s**-1',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'pl',
        'levelist': '1000/925/850/700/600/500/400/300/250/200/150/100/70/50/30/20/10/5/1'
    },
    {
        'param': '132',
        'paramName': 'V component of wind',
        'shortName': 'v',
        'unit': 'm s**-1',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'pl',
        'levelist': '1000/925/850/700/600/500/400/300/250/200/150/100/70/50/30/20/10/5/1'
    },
    {
        'param': '133',
        'paramName': 'Specific humidity',
        'shortName': 'q',
        'unit': 'kg kg**-1',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'pl',
        'levelist': '1000/925/850/700/600/500/400/300/250/200/150/100/70/50/30/20/10/5/1'
    },
    {
        'param': '135',
        'paramName': 'Vertical velocity',
        'shortName': 'w',
        'unit': 'Pa s**-1',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'pl',
        'levelist': '1000/925/850/700/600/500/400/300/250/200/150/100/70/50/30/20/10/5/1'
    },
    {
        'param': '157',
        'paramName': 'Relative humidity',
        'shortName': 'r',
        'unit': '%',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'pl',
        'levelist': '1000/925/850/700/600/500/400/300/250/200/150/100/70/50/30/20/10/5/1'
    },
    {
        'param': '246',
        'paramName': 'Specific cloud liquid water content',
        'shortName': 'clwc',
        'unit': 'kg kg**-1',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'pl',
        'levelist': '1000/925/850/700/600/500/400/300/250/200/150/100/70/50/30/20/10/5/1'
    },
    {
        'param': '28141',
        'paramName': 'Snow depth water equivalent',
        'shortName': 'sd',
        'unit': 'kg m**-2',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': '',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sol',
        'levelist': '1/2/3/4/5'
    },
    {
        'param': '228246',
        'paramName': '100 metre U wind component',
        'shortName': '100u',
        'unit': 'm s**-1',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': '',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'hl',
        'levelist': '100'
    },
    {
        'param': '228247',
        'paramName': '100 metre V wind component',
        'shortName': '100v',
        'unit': 'm s**-1',
        'encoding': 'instantaneous',
        'isNemo': 'IFS-NEMO',
        'isIcon': '',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'hl',
        'levelist': '100'
    },
    {
        'param': '263000',
        'paramName': 'Time-mean sea ice thickness',
        'shortName': 'avg_sithick',
        'unit': 'm',
        'encoding': 'mean',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Daily',
        'levtype': 'o2d',
        'levelist': ''
    },
    {
        'param': '263001',
        'paramName': 'Time-mean sea ice area fraction',
        'shortName': 'avg_siconc',
        'unit': 'Fraction',
        'encoding': 'mean',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Daily',
        'levtype': 'o2d',
        'levelist': ''
    },
    {
        'param': '263003',
        'paramName': 'Time-mean eastward sea ice velocity',
        'shortName': 'avg_siue',
        'unit': 'm s**-1',
        'encoding': 'mean',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Daily',
        'levtype': 'o2d',
        'levelist': ''
    },
    {
        'param': '263004',
        'paramName': 'Time-mean northward sea ice velocity',
        'shortName': 'avg_sivn',
        'unit': 'm s**-1',
        'encoding': 'mean',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Daily',
        'levtype': 'o2d',
        'levelist': ''
    },
    {
        'param': '263008',
        'paramName': 'Time-mean sea ice volume per unit area',
        'shortName': 'avg_sivol',
        'unit': 'm**3 m**-2',
        'encoding': 'mean',
        'isNemo': 'IFS-NEMO',
        'isIcon': '',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Daily',
        'levtype': 'o2d',
        'levelist': ''
    },
    {
        'param': '263009',
        'paramName': 'Time-mean snow volume over sea ice per unit area',
        'shortName': 'avg_snvol',
        'unit': 'm**3 m**-2',
        'encoding': 'mean',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Daily',
        'levtype': 'o2d',
        'levelist': ''
    },
    {
        'param': '263021',
        'paramName': 'Time-mean X-component of sea ice velocity',
        'shortName': 'avg_six',
        'unit': 'm s**-1',
        'encoding': 'mean',
        'isNemo': 'IFS-NEMO',
        'isIcon': '',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Daily',
        'levtype': 'o2d',
        'levelist': ''
    },
    {
        'param': '263022',
        'paramName': 'Time-mean Y-component of sea ice velocity',
        'shortName': 'avg_siy',
        'unit': 'm s**-1',
        'encoding': 'mean',
        'isNemo': 'IFS-NEMO',
        'isIcon': '',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Daily',
        'levtype': 'o2d',
        'levelist': ''
    },
    {
        'param': '263100',
        'paramName': 'Time-mean sea surface practical salinity',
        'shortName': 'avg_sos',
        'unit': 'g kg**-1',
        'encoding': 'mean',
        'isNemo': 'IFS-NEMO',
        'isIcon': '',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Daily',
        'levtype': 'o2d',
        'levelist': ''
    },
    {
        'param': '263101',
        'paramName': 'Time-mean sea surface temperature',
        'shortName': 'avg_tos',
        'unit': 'K',
        'encoding': 'mean',
        'isNemo': 'IFS-NEMO',
        'isIcon': '',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Daily',
        'levtype': 'o2d',
        'levelist': ''
    },
    {
        'param': '263114',
        'paramName': 'Time-mean ocean mixed layer depth defined by sigma theta 0.03 kg m-3',
        'shortName': 'avg_mlotst030',
        'unit': 'm',
        'encoding': 'mean',
        'isNemo': '',
        'isIcon': 'ICON',
        'isFESOM': '',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Daily',
        'levtype': 'o2d',
        'levelist': ''
    },
    {
        'param': '263121',
        'paramName': 'Time-mean vertically-integrated heat content in the upper 300 m',
        'shortName': 'avg_hc300m',
        'unit': 'J m**-2',
        'encoding': 'mean',
        'isNemo': 'IFS-NEMO',
        'isIcon': '',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Daily',
        'levtype': 'o2d',
        'levelist': ''
    },
    {
        'param': '263122',
        'paramName': 'Time-mean vertically-integrated heat content in the upper 700 m',
        'shortName': 'avg_hc700m',
        'unit': 'J m**-2',
        'encoding': 'mean',
        'isNemo': 'IFS-NEMO',
        'isIcon': '',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Daily',
        'levtype': 'o2d',
        'levelist': ''
    },
    {
        'param': '263124',
        'paramName': 'Time-mean sea surface height',
        'shortName': 'avg_zos',
        'unit': 'm',
        'encoding': 'mean',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Daily',
        'levtype': 'o2d',
        'levelist': ''
    },
    {
        'param': '263500',
        'paramName': 'Time-mean sea water practical salinity',
        'shortName': 'avg_so',
        'unit': 'g kg**-1',
        'encoding': 'mean',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Daily',
        'levtype': 'o3d',
        'levelist': '1/2/3/4/5/6/7/8/9/10/11/12/13/14/15/16/17/18/19/20/21/22/23/24/25/26/27/28/29/30/31/32/33/34/35/36/37/38/39/40/41/42/43/44/45/46/47/48/49/50/51/52/53/54/55/56/57/58/59/60/61/62/63/64/65/66/67/68/69/70/71/72'
    },
    {
        'param': '263501',
        'paramName': 'Time-mean sea water potential temperature',
        'shortName': 'avg_thetao',
        'unit': 'K',
        'encoding': 'mean',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Daily',
        'levtype': 'o3d',
        'levelist': '1/2/3/4/5/6/7/8/9/10/11/12/13/14/15/16/17/18/19/20/21/22/23/24/25/26/27/28/29/30/31/32/33/34/35/36/37/38/39/40/41/42/43/44/45/46/47/48/49/50/51/52/53/54/55/56/57/58/59/60/61/62/63/64/65/66/67/68/69/70/71/72'
    },
    {
        'param': '263505',
        'paramName': 'Time-mean northward sea water velocity',
        'shortName': 'avg_von',
        'unit': 'm s**-1',
        'encoding': 'mean',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Daily',
        'levtype': 'o3d',
        'levelist': '1/2/3/4/5/6/7/8/9/10/11/12/13/14/15/16/17/18/19/20/21/22/23/24/25/26/27/28/29/30/31/32/33/34/35/36/37/38/39/40/41/42/43/44/45/46/47/48/49/50/51/52/53/54/55/56/57/58/59/60/61/62/63/64/65/66/67/68/69/70/71/72'
    },
    {
        'param': '263506',
        'paramName': 'Time-mean eastward sea water velocity',
        'shortName': 'avg_uoe',
        'unit': 'm s**-1',
        'encoding': 'mean',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Daily',
        'levtype': 'o3d',
        'levelist': '1/2/3/4/5/6/7/8/9/10/11/12/13/14/15/16/17/18/19/20/21/22/23/24/25/26/27/28/29/30/31/32/33/34/35/36/37/38/39/40/41/42/43/44/45/46/47/48/49/50/51/52/53/54/55/56/57/58/59/60/61/62/63/64/65/66/67/68/69/70/71/72'
    },
    {
        'param': '263507',
        'paramName': 'Time-mean upward sea water velocity',
        'shortName': 'avg_wo',
        'unit': 'm s**-1',
        'encoding': 'mean',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Daily',
        'levtype': 'o3d',
        'levelist':'1/2/3/4/5/6/7/8/9/10/11/12/13/14/15/16/17/18/19/20/21/22/23/24/25/26/27/28/29/30/31/32/33/34/35/36/37/38/39/40/41/42/43/44/45/46/47/48/49/50/51/52/53/54/55/56/57/58/59/60/61/62/63/64/65/66/67/68/69/70/71/72'
    },
    {
        'param': '8',
        'paramName': 'Surface runoff',
        'shortName': 'sro',
        'unit': 'm',
        'encoding': 'accumulated',
        'isNemo': 'IFS-NEMO',
        'isIcon': '',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '9',
        'paramName': 'Sub-surface runoff',
        'shortName': 'ssro',
        'unit': 'm',
        'encoding': 'accumulated',
        'isNemo': 'IFS-NEMO',
        'isIcon': '',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '144',
        'paramName': 'Snowfall',
        'shortName': 'sf',
        'unit': 'm of water equivalent',
        'encoding': 'accumulated',
        'isNemo': 'IFS-NEMO',
        'isIcon': '',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '146',
        'paramName': 'Surface sensible heat flux',
        'shortName': 'sshf',
        'unit': 'J m**-2',
        'encoding': 'accumulated',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '147',
        'paramName': 'Surface latent heat flux',
        'shortName': 'slhf',
        'unit': 'J m**-2',
        'encoding': 'accumulated',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '169',
        'paramName': 'Surface short-wave (solar) radiation downwards',
        'shortName': 'ssrd',
        'unit': 'J m**-2',
        'encoding': 'accumulated',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '175',
        'paramName': 'Surface long-wave (thermal) radiation downwards',
        'shortName': 'strd',
        'unit': 'J m**-2',
        'encoding': 'accumulated',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '176',
        'paramName': 'Surface net short-wave (solar) radiation',
        'shortName': 'ssr',
        'unit': 'J m**-2',
        'encoding': 'accumulated',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '177',
        'paramName': 'Surface net long-wave (thermal) radiation',
        'shortName': 'str',
        'unit': 'J m**-2',
        'encoding': 'accumulated',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '178',
        'paramName': 'Top net short-wave (solar) radiation',
        'shortName': 'tsr',
        'unit': 'J m**-2',
        'encoding': 'accumulated',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '179',
        'paramName': 'Top net long-wave (thermal) radiation',
        'shortName': 'ttr',
        'unit': 'J m**-2',
        'encoding': 'accumulated',
        'isNemo': 'IFS-NEMO',
        'isIcon': 'ICON',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '180',
        'paramName': 'Time-integrated eastward turbulent surface stress',
        'shortName': 'ewss',
        'unit': 'N m**-2 s',
        'encoding': 'accumulated',
        'isNemo': 'IFS-NEMO',
        'isIcon': '',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '181',
        'paramName': 'Time-integrated northward turbulent surface stress',
        'shortName': 'nsss',
        'unit': 'N m**-2 s',
        'encoding': 'accumulated',
        'isNemo': 'IFS-NEMO',
        'isIcon': '',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '182',
        'paramName': 'Evaporation',
        'shortName': 'e',
        'unit': 'm of water equivalent',
        'encoding': 'accumulated',
        'isNemo': 'IFS-NEMO',
        'isIcon': '',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '212',
        'paramName': 'TOA incident short-wave (solar) radiation',
        'shortName': 'tisr',
        'unit': 'J m**-2',
        'encoding': 'accumulated',
        'isNemo': 'IFS-NEMO',
        'isIcon': '',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '228',
        'paramName': 'Total precipitation',
        'shortName': 'tp',
        'unit': 'm',
        'encoding': 'accumulated',
        'isNemo': 'IFS-NEMO',
        'isIcon': '',
        'isFESOM': 'IFS-FESOM',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '260654',
        'paramName': 'Time-integrated eastward turbulent surface stress due to surface roughness',
        'shortName': 'etsssr',
        'unit': 'N m**-2\u00a0s',
        'encoding': 'accumulated',
        'isNemo': '',
        'isIcon': 'ICON',
        'isFESOM': '',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    },
    {
        'param': '260655',
        'paramName': 'Time-integrated northward turbulent surface stress due to surface roughness',
        'shortName': 'ntsssr',
        'unit': 'N m**-2\u00a0s',
        'encoding': 'accumulated',
        'isNemo': '',
        'isIcon': 'ICON',
        'isFESOM': '',
        'stream': 'clte',
        'type': 'fc',
        'time': 'Hourly',
        'levtype': 'sfc',
        'levelist': ''
    }
]


## Climate DT scenarios to choose from (mm/dd/yyyy)

climateDT_scenario = [
{
  'activity': 'ScenarioMIP',
  'experiment': 'ssp3-7.0',
  'model': 'IFS-NEMO',
  'resolution': ["high","standard"],
  'dateFrom': '01/01/2020',
  'dateTo': '12/30/2039'
},
{
  'activity': 'ScenarioMIP',
  'experiment': 'ssp3-7.0',
  'model': 'ICON',
  'resolution': ["high"],
  'dateFrom': '01/01/2020',
  'dateTo': '09/30/2033'
},
{
  'activity': 'CMIP6',
  'experiment': 'hist',
  'model': 'IFS-NEMO',
  'resolution': ["high","standard"],
  'dateFrom': '01/01/1990',
  'dateTo': '12/31/1996'
},
{
  'activity': 'CMIP6',
  'experiment': 'hist',
  'model': 'ICON',
  'resolution': ["high"],
  'dateFrom': '01/03/1991',
  'dateTo': '10/30/2005'
},
{
  'activity': 'story-nudging',
  'experiment': 'hist',
  'model': 'IFS-FESOM',
  'resolution': ["high","standard"],
  'dateFrom': '01/01/2017',
  'dateTo': '12/31/2023'
},
{
  'activity': 'story-nudging',
  'experiment': 'cont',
  'model': 'IFS-FESOM',
  'resolution': ["high","standard"],
  'dateFrom': '01/01/2017',
  'dateTo': '12/31/2023'
},
{
  'activity': 'story-nudging',
  'experiment': 'Tplus2.0K',
  'model': 'IFS-FESOM',
  'resolution': ["high","standard"],
  'dateFrom': '01/01/2017',
  'dateTo': '12/31/2023'
}
]