# Generated by Django 2.2.10 on 2020-02-24 12:30

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="FileStorage",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        auto_now_add=True, default=django.utils.timezone.now
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="StorageLocation",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("url", models.CharField(max_length=60, null=False, blank=False)),
                (
                    "connector_name",
                    models.CharField(blank=False, max_length=30, null=False),
                ),
                (
                    "file_storage",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="storage_locations",
                        to="storage.FileStorage",
                    ),
                ),
                ("last_update", models.DateTimeField(auto_now=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("PR", "Preparing"),
                            ("UP", "Uploading"),
                            ("OK", "Done"),
                            ("DE", "Deleting"),
                        ],
                        default="PR",
                        max_length=2,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="AccessLog",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("started", models.DateTimeField(auto_now_add=True)),
                ("finished", models.DateTimeField(blank=True, null=True)),
                ("reason", models.CharField(max_length=120)),
                (
                    "storage_location",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="access_logs",
                        to="storage.StorageLocation",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ReferencedPath",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("path", models.TextField(db_index=True)),
                (
                    "file_storage",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="files",
                        to="storage.FileStorage",
                    ),
                ),
                ("size", models.BigIntegerField(default=-1)),
            ],
        ),
        migrations.AlterField(
            model_name="filestorage",
            name="created",
            field=models.DateTimeField(auto_now_add=True),
        ),
        migrations.AlterUniqueTogether(
            name="storagelocation", unique_together={("url", "connector_name")},
        ),
        migrations.AlterModelManagers(
            name="storagelocation",
            managers=[("all_objects", django.db.models.manager.Manager()),],
        ),
    ]
