#!python
# coding=utf-8
"""Setup for testing, building, distributing and installing the 'EMPyRe'-package"""


import os
import subprocess
from setuptools import setup, config


# Read version from setup.py:
version = config.read_configuration('setup.cfg')['metadata']['version']
# Get current git revision:
try:
    git_rev = subprocess.check_output(['git', 'rev-parse', 'HEAD']).strip().decode()
except Exception:
    git_rev = "???"
# Write both to version.py:
print(R'writing src\empyre\version.py')
with open(os.path.join(os.path.dirname(__file__), 'src', 'empyre', 'version.py'), 'w') as vfile:
    vfile.write('# -*- coding: utf-8 -*-\n' +
                '""""This file was automatically generated by `setup.py`"""\n' +
                f'version = "{version}"\n' +
                f'git_revision = "{git_rev}"\n')

# Run setup (reads metadata & options from setup.cfg):
print(R'running setup.py')
setup()
