# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['arthur', 'arthur.bin', 'tests']

package_data = \
{'': ['*'], 'tests': ['data/*', 'data/redmine/*']}

install_requires = \
['CherryPy>=17.4.2',
 'cheroot>=8.2.1',
 'grimoirelab-toolkit>=0.3',
 'perceval>=0.19',
 'python-dateutil>=2.8.0',
 'redis==3.0.0',
 'rq==1.0.0']

entry_points = \
{'console_scripts': ['arthurd = arthur.bin.arthurd:main',
                     'arthurw = arthur.bin.arthurw:main']}

setup_kwargs = {
    'name': 'kingarthur',
    'version': '0.2.2rc6',
    'description': 'Distributed job queue platform for scheduling Perceval jobs',
    'long_description': '# Arthur [![Build Status](https://github.com/chaoss/grimoirelab-kingarthur/workflows/tests/badge.svg)](https://github.com/chaoss/grimoirelab-kingarthur/actions?query=workflow:tests+branch:master+event:push) [![Coverage Status](https://coveralls.io/repos/github/chaoss/grimoirelab-kingarthur/badge.svg?branch=master)](https://coveralls.io/github/chaoss/grimoirelab-kingarthur?branch=master)\n\nKing Arthur commands his loyal knight Perceval on the quest to fetch\ndata from software repositories.\n\nArthur is a distributed job queue platform that schedules and executes\nPerceval. The platform is composed by two components: `arthurd`, the server\nthat schedules the jobs and one or more instances of `arthurw`, the work horses\nthat will run each Perceval job.\n\nThe repositories whose data will be fetched are added to the\nplatform using a REST API. Then, the server transforms these repositories into\nPerceval jobs and schedules them between its job queues.\n\nWorkers are waiting for new jobs checking these queues. Workers only execute\na job at a time. When a new job arrives, an idle worker will take and run\nit. Once a job is finished, if the result is successful, the server will\nre-schedule it to retrieve new data.\n\nBy default, items fetched by each job will be published using a Redis queue.\nAdditionally, they can be written to an Elastic Search index.\n\n\n## Usage\n\n### arthurd\n```\nusage: arthurd [-c <file>] [-g] [-h <host>] [-p <port>] [-d <database>]\n               [--es-index <index>] [--log-path <path>] [--archive-path <cpath>]\n               [--no-archive] [--no-daemon] | --help\n\nKing Arthur commands his loyal knight Perceval on the quest\nto retrieve data from software repositories.\n\nThis command runs an Arthur daemon that waits for HTTP requests\non port 8080. Repositories to analyze are added using an REST API.\nRepositories are transformed into Perceval jobs that will be\nscheduled and run using a distributed job queue platform.\n\noptional arguments:\n  -?, --help            show this help message and exit\n  -c FILE, --config FILE\n                        set configuration file\n  -g, --debug           set debug mode on\n  -h, --host            set the host name or IP address on which to listen for connections\n  -p, --port            set listening TCP port (default: 8080)\n  -d, --database        URL database connection (default: \'redis://localhost/8\')\n  -s, --sync            work in synchronous mode (without workers)\n  --es-index            output ElasticSearch server index\n  --log-path            path where logs are stored\n  --archive-path        path to archive manager directory\n  --no-archive          do not archive fetched raw data\n  --no-daemon           do not run arthur in daemon mode\n```\n\n#### arthurd configuration file\n\nTo run `arthurd` using a configuration file:\n\n```\n$ arthurd [-c <file>]\n```\n\nWhere `<file>` is the path to an `ini` file which uses the same parameters as in command line, but replacing underscores by hyphens. This configuration file has the following structure:\n\n```\n[arthur]\narchive_path=/tmp/.arthur/archive\ndebug=True\nlog_path=/tmp/logs/arthurd\nno_archive=True\nsync_mode=True\n\n[connection]\nhost=127.0.0.1\nport=8080\n\n[elasticsearch]\nes_index=http://localhost:9200/items\n\n[redis]\ndatabase=redis://localhost/8\n```\n\n### arthurw\n```\nusage: arthurw [-g] [-d <database>] [--burst] [<queue1>...<queueN>] | --help\n\nKing Arthur\'s worker. It will run Perceval jobs on the quest\nto retrieve data from software repositories.\n\npositional arguments:\n   queues               list of queues this worker will listen for\n                        (\'create\' and \'update\', by default)\n\noptional arguments:\n  -?, --help            show this help message and exit\n  -g, --debug           set debug mode on\n  -d, --database        URL database connection (default: \'redis://localhost/8\')\n  -b, --burst           Run in burst mode (quit after all work is done)\n```\n\n## Requirements\n\nKing Arthur requires Python 3.7 or later plus\n[Perceval](https://github.com/chaoss/grimoirelab-perceval/ to run.\nFor other Python dependencies, please check the `pyproject.toml`\nfile included on this repository.\n\nRedis (>= 2.3 and < 3.0) database will also be needed to schedule\nand execute Perceval jobs.\n\n## Installation\n\n```\n$ pip3 install -r requirements.txt\n$ python3 setup.py install\n```\n\n## How to run it\n\nThe first step is to run a Redis server that will be used for communicating\nArthur\'s components. Moreover, an Elastic Search server can be used to store\nthe items generated by jobs. Please refer to their documentation to know how to\ninstall and run them both.\n\nTo run Arthur server:\n```\n$ arthurd -g -d redis://localhost/8 --es-index http://localhost:9200/items --log-path /tmp/logs/arthud --no-archive\n```\n\nTo run a worker:\n\n```\n$ arthurw -d redis://localhost/8\n```\n\n## Adding tasks\n\nTo add tasks to Arthur, create a JSON object containing the tasks needed\nto fetch data from a set of repositories. Each task will run a Perceval\nbackend, thus, backend parameters will also needed for each task.\n\n```\n$ cat tasks.json\n{\n    "tasks": [\n        {\n            "task_id": "arthur.git",\n            "backend": "git",\n            "backend_args": {\n                "gitpath": "/tmp/git/arthur.git/",\n                "uri": "https://github.com/chaoss/grimoirelab-kingarthur.git",\n                "from_date": "2015-03-01"\n            },\n            "category": "commit",\n            "scheduler": {\n                "delay": 10\n            }\n        },\n        {\n            "task_id": "bugzilla_mozilla",\n            "backend": "bugzillarest",\n            "backend_args": {\n                "url": "https://bugzilla.mozilla.org/",\n                "from_date": "2016-09-19"\n            },\n            "category": "bug",\n            "archive": {\n                "fetch_from_archive": true,\n                "archived_after": "2018-02-26 09:00"\n            },\n            "scheduler": {\n                "delay": 60,\n                "max_retries": 5\n            }\n        }\n    ]\n}\n```\n\nThen, send this JSON stream to the server calling `add` method.\n\n```\n$ curl -H "Content-Type: application/json" --data @tasks.json http://127.0.0.1:8080/add\n```\n\nFor this example, items will be stored in the `items` index on the\nElastic Search server (http://localhost:9200/items).\n\n## Listing tasks\n\nThe list of tasks currently scheduled can be obtained using the method `tasks`.\n\n```\n$ curl http://127.0.0.1:8080/tasks\n\n{\n    "tasks": [\n        {\n            "backend_args": {\n                "from_date": "2015-03-01T00:00:00+00:00",\n                "uri": "https://github.com/chaoss/grimoirelab-kingarthur.git",\n                "gitpath": "/tmp/santi/"\n            },\n            "backend": "git",\n            "category": "commit",\n            "created_on": 1480531707.810326,\n            "task_id": "arthur.git",\n            "scheduler": {\n                "max_retries": 3,\n                "delay": 10\n            }\n        }\n    ]\n}\n```\n\n## Removing tasks\n\nScheduled tasks can also be removed calling to the server using the `remove`\nmethod. A JSON stream must be provided setting the identifiers of the\ntasks to be removed.\n\n```\n$ cat tasks_to_remove.json\n\n{\n    "tasks": [\n        {\n            "task_id": "bugzilla_mozilla"\n        },\n        {\n            "task_id": "arthur.git"\n        }\n    ]\n}\n\n$ curl -H "Content-Type: application/json" --data @tasks_to_remove.json http://127.0.0.1:8080/remove\n```\n\n## License\n\nLicensed under GNU General Public License (GPL), version 3 or later.\n',
    'author': 'GrimoireLab Developers',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://chaoss.github.io/grimoirelab/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
