import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [cognito-identity](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncognitoidentity.html).
 *
 * @experimental
 */
export declare class CognitoIdentity extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to create a new identity pool.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_CreateIdentityPool.html
     *
     * @experimental
     */
    toCreateIdentityPool(): this;
    /**
     * (experimental) Grants permission to delete identities from an identity pool.
     *
     * You can specify a list of 1-60 identities that you want to delete
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_DeleteIdentities.html
     *
     * @experimental
     */
    toDeleteIdentities(): this;
    /**
     * (experimental) Grants permission to delete a user pool.
     *
     * Once a pool is deleted, users will not be able to authenticate with the pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_DeleteIdentityPool.html
     *
     * @experimental
     */
    toDeleteIdentityPool(): this;
    /**
     * (experimental) Grants permission to return metadata related to the given identity, including when the identity was created and any associated linked logins.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_DescribeIdentity.html
     *
     * @experimental
     */
    toDescribeIdentity(): this;
    /**
     * (experimental) Grants permission to get details about a particular identity pool, including the pool name, ID description, creation date, and current number of users.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_DescribeIdentityPool.html
     *
     * @experimental
     */
    toDescribeIdentityPool(): this;
    /**
     * (experimental) Grants permission to return credentials for the provided identity ID.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetCredentialsForIdentity.html
     *
     * @experimental
     */
    toGetCredentialsForIdentity(): this;
    /**
     * (experimental) Grants permission to generate (or retrieve) a Cognito ID. Supplying multiple logins will create an implicit linked account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetId.html
     *
     * @experimental
     */
    toGetId(): this;
    /**
     * (experimental) Grants permission to get the roles for an identity pool.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetIdentityPoolRoles.html
     *
     * @experimental
     */
    toGetIdentityPoolRoles(): this;
    /**
     * (experimental) Grants permission to get an OpenID token, using a known Cognito ID.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetOpenIdToken.html
     *
     * @experimental
     */
    toGetOpenIdToken(): this;
    /**
     * (experimental) Grants permission to register (or retrieve) a Cognito IdentityId and an OpenID Connect token for a user authenticated by your backend authentication process.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetOpenIdTokenForDeveloperIdentity.html
     *
     * @experimental
     */
    toGetOpenIdTokenForDeveloperIdentity(): this;
    /**
     * (experimental) Grants permission to get the principal tags for an identity pool and provider.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetPrincipalTagAttributeMap.html
     *
     * @experimental
     */
    toGetPrincipalTagAttributeMap(): this;
    /**
     * (experimental) Grants permission to list the identities in an identity pool.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_ListIdentities.html
     *
     * @experimental
     */
    toListIdentities(): this;
    /**
     * (experimental) Grants permission to list all of the Cognito identity pools registered for your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_ListIdentityPools.html
     *
     * @experimental
     */
    toListIdentityPools(): this;
    /**
     * (experimental) Grants permission to list the tags that are assigned to an Amazon Cognito identity pool.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to retrieve the IdentityId associated with a DeveloperUserIdentifier or the list of DeveloperUserIdentifiers associated with an IdentityId for an existing identity.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_LookupDeveloperIdentity.html
     *
     * @experimental
     */
    toLookupDeveloperIdentity(): this;
    /**
     * (experimental) Grants permission to merge two users having different IdentityIds, existing in the same identity pool, and identified by the same developer provider.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_MergeDeveloperIdentities.html
     *
     * @experimental
     */
    toMergeDeveloperIdentities(): this;
    /**
     * (experimental) Grants permission to set the roles for an identity pool.
     *
     * These roles are used when making calls to GetCredentialsForIdentity action
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_SetIdentityPoolRoles.html
     *
     * @experimental
     */
    toSetIdentityPoolRoles(): this;
    /**
     * (experimental) Grants permission to set the principal tags for an identity pool and provider.
     *
     * These tags are used when making calls to GetOpenIdToken action
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_SetPrincipalTagAttributeMap.html
     *
     * @experimental
     */
    toSetPrincipalTagAttributeMap(): this;
    /**
     * (experimental) Grants permission to assign a set of tags to an Amazon Cognito identity pool.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to unlink a DeveloperUserIdentifier from an existing identity.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_UnlinkDeveloperIdentity.html
     *
     * @experimental
     */
    toUnlinkDeveloperIdentity(): this;
    /**
     * (experimental) Grants permission to unlink a federated identity from an existing account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_UnlinkIdentity.html
     *
     * @experimental
     */
    toUnlinkIdentity(): this;
    /**
     * (experimental) Grants permission to remove the specified tags from an Amazon Cognito identity pool.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update an identity pool.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_UpdateIdentityPool.html
     *
     * @experimental
     */
    toUpdateIdentityPool(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type identitypool to the statement.
     *
     * https://docs.aws.amazon.com/cognito/latest/developerguide/identity-pools.html
     *
     * @param identityPoolId - Identifier for the identityPoolId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onIdentitypool(identityPoolId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [cognito-identity](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncognitoidentity.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
