"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotDeviceTester = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [iot-device-tester](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotdevicetester.html).
 *
 * @experimental
 */
class IotDeviceTester extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [iot-device-tester](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotdevicetester.html).
     *
     * @experimental
     */
    constructor(props) {
        super(props);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'iot-device-tester';
        /**
         * @experimental
         */
        this.accessLevelList = {
            Read: [
                'CheckVersion',
                'DownloadTestSuite',
                'LatestIdt',
                'SupportedVersion'
            ],
            Write: [
                'SendMetrics'
            ]
        };
    }
    /**
     * (experimental) Grants permission for IoT Device Tester to check if a given set of product, test suite and device tester version are compatible.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     *
     * @experimental
     */
    toCheckVersion() {
        return this.to('CheckVersion');
    }
    /**
     * (experimental) Grants permission for IoT Device Tester to download compatible test suite versions.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     *
     * @experimental
     */
    toDownloadTestSuite() {
        return this.to('DownloadTestSuite');
    }
    /**
     * (experimental) Grants permission for IoT Device Tester to get information on latest version of device tester available.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     *
     * @experimental
     */
    toLatestIdt() {
        return this.to('LatestIdt');
    }
    /**
     * (experimental) Grants permissions for IoT Device Tester to send usage metrics on your behalf.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     *
     * @experimental
     */
    toSendMetrics() {
        return this.to('SendMetrics');
    }
    /**
     * (experimental) Grants permission for IoT Device Tester to get list of supported products and test suite versions.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     *
     * @experimental
     */
    toSupportedVersion() {
        return this.to('SupportedVersion');
    }
}
exports.IotDeviceTester = IotDeviceTester;
_a = JSII_RTTI_SYMBOL_1;
IotDeviceTester[_a] = { fqn: "cdk-iam-floyd.IotDeviceTester", version: "0.300.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW90ZGV2aWNldGVzdGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW90ZGV2aWNldGVzdGVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQ0Esc0NBQTRDOzs7Ozs7QUFJNUMsTUFBYSxlQUFnQixTQUFRLHdCQUFlOzs7Ozs7SUF5Q2xELFlBQVksS0FBZ0M7UUFDMUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDOzs7Ozs7UUF6Q1Isa0JBQWEsR0FBRyxtQkFBbUIsQ0FBQzs7OztRQTJCakMsb0JBQWUsR0FBb0I7WUFDM0MsSUFBSSxFQUFFO2dCQUNKLGNBQWM7Z0JBQ2QsbUJBQW1CO2dCQUNuQixXQUFXO2dCQUNYLGtCQUFrQjthQUNuQjtZQUNELEtBQUssRUFBRTtnQkFDTCxhQUFhO2FBQ2Q7U0FDRixDQUFDO0lBS0YsQ0FBQzs7Ozs7Ozs7OztJQXZDTSxjQUFjO1FBQ25CLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNqQyxDQUFDOzs7Ozs7Ozs7O0lBR00sbUJBQW1CO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO0lBQ3RDLENBQUM7Ozs7Ozs7Ozs7SUFHTSxXQUFXO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxXQUFXLENBQUMsQ0FBQztJQUM5QixDQUFDOzs7Ozs7Ozs7O0lBR00sYUFBYTtRQUNsQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsYUFBYSxDQUFDLENBQUM7SUFDaEMsQ0FBQzs7Ozs7Ozs7OztJQUdNLGtCQUFrQjtRQUN2QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsa0JBQWtCLENBQUMsQ0FBQztJQUNyQyxDQUFDOztBQTFCSCwwQ0E0Q0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBY2Nlc3NMZXZlbExpc3QgfSBmcm9tICcuLi9zaGFyZWQvYWNjZXNzLWxldmVsJztcbmltcG9ydCB7IFBvbGljeVN0YXRlbWVudCB9IGZyb20gJy4uL3NoYXJlZCc7XG5pbXBvcnQgeyBhd3NfaWFtIGFzIGlhbSB9IGZyb20gXCJhd3MtY2RrLWxpYlwiO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgSW90RGV2aWNlVGVzdGVyIGV4dGVuZHMgUG9saWN5U3RhdGVtZW50IHtcbiAgcHVibGljIHNlcnZpY2VQcmVmaXggPSAnaW90LWRldmljZS10ZXN0ZXInO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvQ2hlY2tWZXJzaW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDaGVja1ZlcnNpb24nKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvRG93bmxvYWRUZXN0U3VpdGUoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rvd25sb2FkVGVzdFN1aXRlJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0xhdGVzdElkdCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGF0ZXN0SWR0Jyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvU2VuZE1ldHJpY3MoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1NlbmRNZXRyaWNzJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b1N1cHBvcnRlZFZlcnNpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1N1cHBvcnRlZFZlcnNpb24nKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBhY2Nlc3NMZXZlbExpc3Q6IEFjY2Vzc0xldmVsTGlzdCA9IHtcbiAgICBSZWFkOiBbXG4gICAgICAnQ2hlY2tWZXJzaW9uJyxcbiAgICAgICdEb3dubG9hZFRlc3RTdWl0ZScsXG4gICAgICAnTGF0ZXN0SWR0JyxcbiAgICAgICdTdXBwb3J0ZWRWZXJzaW9uJ1xuICAgIF0sXG4gICAgV3JpdGU6IFtcbiAgICAgICdTZW5kTWV0cmljcydcbiAgICBdXG4gIH07XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIGNvbnN0cnVjdG9yKHByb3BzPzogaWFtLlBvbGljeVN0YXRlbWVudFByb3BzKSB7XG4gICAgc3VwZXIocHJvcHMpO1xuICB9XG59XG4iXX0=