import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [macie2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmacie.html).
 *
 * @experimental
 */
export declare class Macie2 extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to accept an Amazon Macie membership invitation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/invitations-accept.html
     *
     * @experimental
     */
    toAcceptInvitation(): this;
    /**
     * (experimental) Grants permission to retrieve information about one or more custom data identifiers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/custom-data-identifiers-get.html
     *
     * @experimental
     */
    toBatchGetCustomDataIdentifiers(): this;
    /**
     * (experimental) Grants permission to create and define the settings for a sensitive data discovery job.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html
     *
     * @experimental
     */
    toCreateClassificationJob(): this;
    /**
     * (experimental) Grants permission to create and define the settings for a custom data identifier.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/custom-data-identifiers.html
     *
     * @experimental
     */
    toCreateCustomDataIdentifier(): this;
    /**
     * (experimental) Grants permission to create and define the settings for a findings filter.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findingsfilters.html
     *
     * @experimental
     */
    toCreateFindingsFilter(): this;
    /**
     * (experimental) Grants permission to send an Amazon Macie membership invitation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/invitations.html
     *
     * @experimental
     */
    toCreateInvitations(): this;
    /**
     * (experimental) Grants permission to associate an account with an Amazon Macie administrator account.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/members.html
     *
     * @experimental
     */
    toCreateMember(): this;
    /**
     * (experimental) Grants permission to create sample findings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findings-sample.html
     *
     * @experimental
     */
    toCreateSampleFindings(): this;
    /**
     * (experimental) Grants permission to decline Amazon Macie membership invitations.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/invitations-decline.html
     *
     * @experimental
     */
    toDeclineInvitations(): this;
    /**
     * (experimental) Grants permission to delete a custom data identifier.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/custom-data-identifiers-id.html
     *
     * @experimental
     */
    toDeleteCustomDataIdentifier(): this;
    /**
     * (experimental) Grants permission to delete a findings filter.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findingsfilters-id.html
     *
     * @experimental
     */
    toDeleteFindingsFilter(): this;
    /**
     * (experimental) Grants permission to delete Amazon Macie membership invitations.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/invitations-delete.html
     *
     * @experimental
     */
    toDeleteInvitations(): this;
    /**
     * (experimental) Grants permission to delete the association between an Amazon Macie administrator account and an account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/members-id.html
     *
     * @experimental
     */
    toDeleteMember(): this;
    /**
     * (experimental) Grants permission to retrieve statistical data and other information about S3 buckets that Amazon Macie monitors and analyzes.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html
     *
     * @experimental
     */
    toDescribeBuckets(): this;
    /**
     * (experimental) Grants permission to retrieve information about the status and settings for a sensitive data discovery job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/jobs-jobid.html
     *
     * @experimental
     */
    toDescribeClassificationJob(): this;
    /**
     * (experimental) Grants permission to retrieve information about the Amazon Macie configuration settings for an AWS organization.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/admin-configuration.html
     *
     * @experimental
     */
    toDescribeOrganizationConfiguration(): this;
    /**
     * (experimental) Grants permission to disable an Amazon Macie account, which also deletes Macie resources for the account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/macie.html
     *
     * @experimental
     */
    toDisableMacie(): this;
    /**
     * (experimental) Grants permission to disable an account as the delegated Amazon Macie administrator account for an AWS organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/admin.html
     *
     * @experimental
     */
    toDisableOrganizationAdminAccount(): this;
    /**
     * (experimental) Grants an Amazon Macie member account with permission to disassociate from its Macie administrator account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/administrator-disassociate.html
     *
     * @experimental
     */
    toDisassociateFromAdministratorAccount(): this;
    /**
     * (experimental) (Deprecated) Grants an Amazon Macie member account with permission to disassociate from its Macie administrator account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/master-disassociate.html
     *
     * @experimental
     */
    toDisassociateFromMasterAccount(): this;
    /**
     * (experimental) Grants an Amazon Macie administrator account with permission to disassociate from a Macie member account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/members-disassociate-id.html
     *
     * @experimental
     */
    toDisassociateMember(): this;
    /**
     * (experimental) Grants permission to enable and specify the configuration settings for a new Amazon Macie account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/macie.html
     *
     * @experimental
     */
    toEnableMacie(): this;
    /**
     * (experimental) Grants permission to enable an account as the delegated Amazon Macie administrator account for an AWS organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/admin.html
     *
     * @experimental
     */
    toEnableOrganizationAdminAccount(): this;
    /**
     * (experimental) Grants permission to retrieve information about the Amazon Macie administrator account for an account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/administrator.html
     *
     * @experimental
     */
    toGetAdministratorAccount(): this;
    /**
     * (experimental) Grants permission to retrieve aggregated statistical data for all the S3 buckets that Amazon Macie monitors and analyzes.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3-statistics.html
     *
     * @experimental
     */
    toGetBucketStatistics(): this;
    /**
     * (experimental) Grants permission to retrieve the settings for exporting sensitive data discovery results.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/classification-export-configuration.html
     *
     * @experimental
     */
    toGetClassificationExportConfiguration(): this;
    /**
     * (experimental) Grants permission to retrieve information about the settings for a custom data identifier.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/custom-data-identifiers-id.html
     *
     * @experimental
     */
    toGetCustomDataIdentifier(): this;
    /**
     * (experimental) Grants permission to retrieve aggregated statistical data about findings.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findings-statistics.html
     *
     * @experimental
     */
    toGetFindingStatistics(): this;
    /**
     * (experimental) Grants permission to retrieve the details of one or more findings.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findings-describe.html
     *
     * @experimental
     */
    toGetFindings(): this;
    /**
     * (experimental) Grants permission to retrieve information about the settings for a findings filter.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findingsfilters-id.html
     *
     * @experimental
     */
    toGetFindingsFilter(): this;
    /**
     * (experimental) Grants permission to retrieve the configuration settings for publishing findings to AWS Security Hub.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findings-publication-configuration.html
     *
     * @experimental
     */
    toGetFindingsPublicationConfiguration(): this;
    /**
     * (experimental) Grants permission to retrieve the count of Amazon Macie membership invitations that were received by an account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/invitations-count.html
     *
     * @experimental
     */
    toGetInvitationsCount(): this;
    /**
     * (experimental) Grants permission to retrieve information about the status and configuration settings for an Amazon Macie account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/macie.html
     *
     * @experimental
     */
    toGetMacieSession(): this;
    /**
     * (experimental) (Deprecated) Grants permission to retrieve information about the Amazon Macie administrator account for an account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/master.html
     *
     * @experimental
     */
    toGetMasterAccount(): this;
    /**
     * (experimental) Grants permission to retrieve information about an account that's associated with an Amazon Macie administrator account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/members-id.html
     *
     * @experimental
     */
    toGetMember(): this;
    /**
     * (experimental) Grants permission to retrieve quotas and aggregated usage data for one or more accounts.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/usage-statistics.html
     *
     * @experimental
     */
    toGetUsageStatistics(): this;
    /**
     * (experimental) Grants permission to retrieve aggregated usage data for an account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/usage.html
     *
     * @experimental
     */
    toGetUsageTotals(): this;
    /**
     * (experimental) Grants permission to retrieve a subset of information about the status and settings for one or more sensitive data discovery jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/jobs-list.html
     *
     * @experimental
     */
    toListClassificationJobs(): this;
    /**
     * (experimental) Grants permission to retrieve information about all custom data identifiers.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/custom-data-identifiers-list.html
     *
     * @experimental
     */
    toListCustomDataIdentifiers(): this;
    /**
     * (experimental) Grants permission to retrieve a subset of information about one or more findings.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findings.html
     *
     * @experimental
     */
    toListFindings(): this;
    /**
     * (experimental) Grants permission to retrieve information about all findings filters.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findingsfilters.html
     *
     * @experimental
     */
    toListFindingsFilters(): this;
    /**
     * (experimental) Grants permission to retrieve information about all the Amazon Macie membership invitations that were received by an account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/invitations.html
     *
     * @experimental
     */
    toListInvitations(): this;
    /**
     * (experimental) Grants permission to retrieve information about managed data identifiers.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/managed-data-identifiers-list.html
     *
     * @experimental
     */
    toListManagedDataIdentifiers(): this;
    /**
     * (experimental) Grants permission to retrieve information about the Amazon Macie member accounts that are associated with a Macie administrator account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/members.html
     *
     * @experimental
     */
    toListMembers(): this;
    /**
     * (experimental) Grants permission to retrieve information about the delegated, Amazon Macie administrator account for an AWS organization.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/admin.html
     *
     * @experimental
     */
    toListOrganizationAdminAccounts(): this;
    /**
     * (experimental) Grants permission to retrieve the tags for an Amazon Macie resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/tags-resourcearn.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to create or update the settings for storing sensitive data discovery results.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/classification-export-configuration.html
     *
     * @experimental
     */
    toPutClassificationExportConfiguration(): this;
    /**
     * (experimental) Grants permission to update the configuration settings for publishing findings to AWS Security Hub.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findings-publication-configuration.html
     *
     * @experimental
     */
    toPutFindingsPublicationConfiguration(): this;
    /**
     * (experimental) Grants permission to retrieve statistical data and other information about AWS resources that Amazon Macie monitors and analyzes.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/datasources-search-resources.html
     *
     * @experimental
     */
    toSearchResources(): this;
    /**
     * (experimental) Grants permission to add or update the tags for an Amazon Macie resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/tags-resourcearn.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to test a custom data identifier.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/custom-data-identifiers-test.html
     *
     * @experimental
     */
    toTestCustomDataIdentifier(): this;
    /**
     * (experimental) Grants permission to remove tags from an Amazon Macie resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/tags-resourcearn.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to change the status of a sensitive data discovery job.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/jobs-jobid.html
     *
     * @experimental
     */
    toUpdateClassificationJob(): this;
    /**
     * (experimental) Grants permission to update the settings for a findings filter.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/findingsfilters-id.html
     *
     * @experimental
     */
    toUpdateFindingsFilter(): this;
    /**
     * (experimental) Grants permission to suspend or re-enable an Amazon Macie account, or update the configuration settings for a Macie account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/macie.html
     *
     * @experimental
     */
    toUpdateMacieSession(): this;
    /**
     * (experimental) Grants an Amazon Macie administrator account with permission to suspend or re-enable a Macie member account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/macie-members-id.html
     *
     * @experimental
     */
    toUpdateMemberSession(): this;
    /**
     * (experimental) Grants permission to update Amazon Macie configuration settings for an AWS organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/latest/APIReference/admin-configuration.html
     *
     * @experimental
     */
    toUpdateOrganizationConfiguration(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type ClassificationJob to the statement.
     *
     * https://docs.aws.amazon.com/macie/latest/user/what-is-macie.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onClassificationJob(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type CustomDataIdentifier to the statement.
     *
     * https://docs.aws.amazon.com/macie/latest/user/what-is-macie.html.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onCustomDataIdentifier(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type FindingsFilter to the statement.
     *
     * https://docs.aws.amazon.com/macie/latest/user/what-is-macie.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onFindingsFilter(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type Member to the statement.
     *
     * https://docs.aws.amazon.com/macie/latest/user/what-is-macie.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onMember(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [macie2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmacie.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
