# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables


class OrganizationSecurityPolicyRule(pulumi.CustomResource):
    action: pulumi.Output[str]
    """
    The Action to perform when the client connection triggers the rule. Can currently be either
    "allow", "deny" or "goto_next".
    """
    description: pulumi.Output[str]
    """
    A description of the rule.
    """
    direction: pulumi.Output[str]
    """
    The direction in which this rule applies. If unspecified an INGRESS rule is created.
    Possible values are `INGRESS` and `EGRESS`.
    """
    enable_logging: pulumi.Output[bool]
    """
    Denotes whether to enable logging for a particular rule.
    If logging is enabled, logs will be exported to the
    configured export destination in Stackdriver.
    """
    match: pulumi.Output[dict]
    """
    A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
    Structure is documented below.

      * `config` (`dict`) - The configuration options for matching the rule.
        Structure is documented below.
        * `destIpRanges` (`list`) - Destination IP address range in CIDR format. Required for
          EGRESS rules.
        * `layer4Configs` (`list`) - Pairs of IP protocols and ports that the rule should match.
          Structure is documented below.
          * `ip_protocol` (`str`) - The IP protocol to which this rule applies. The protocol
            type is required when creating a firewall rule.
            This value can either be one of the following well
            known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp),
            or the IP protocol number.
          * `ports` (`list`) - An optional list of ports to which this rule applies. This field
            is only applicable for UDP or TCP protocol. Each entry must be
            either an integer or a range. If not specified, this rule
            applies to connections through any port.
            Example inputs include: ["22"], ["80","443"], and
            ["12345-12349"].

        * `srcIpRanges` (`list`) - Source IP address range in CIDR format. Required for
          INGRESS rules.

      * `description` (`str`) - A description of the rule.
      * `versionedExpr` (`str`) - Preconfigured versioned expression. For organization security policy rules,
        the only supported type is "FIREWALL".
        Default value is `FIREWALL`.
        Possible values are `FIREWALL`.
    """
    policy_id: pulumi.Output[str]
    """
    The ID of the OrganizationSecurityPolicy this rule applies to.
    """
    preview: pulumi.Output[bool]
    """
    If set to true, the specified action is not enforced.
    """
    priority: pulumi.Output[float]
    """
    An integer indicating the priority of a rule in the list. The priority must be a value
    between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the
    highest priority and 2147483647 is the lowest prority.
    """
    target_resources: pulumi.Output[list]
    """
    A list of network resource URLs to which this rule applies.
    This field allows you to control which network's VMs get
    this rule. If this field is left blank, all VMs
    within the organization will receive the rule.
    """
    target_service_accounts: pulumi.Output[list]
    """
    A list of service accounts indicating the sets of
    instances that are applied with this rule.
    """
    def __init__(__self__, resource_name, opts=None, action=None, description=None, direction=None, enable_logging=None, match=None, policy_id=None, preview=None, priority=None, target_resources=None, target_service_accounts=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a OrganizationSecurityPolicyRule resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: The Action to perform when the client connection triggers the rule. Can currently be either
               "allow", "deny" or "goto_next".
        :param pulumi.Input[str] description: A description of the rule.
        :param pulumi.Input[str] direction: The direction in which this rule applies. If unspecified an INGRESS rule is created.
               Possible values are `INGRESS` and `EGRESS`.
        :param pulumi.Input[bool] enable_logging: Denotes whether to enable logging for a particular rule.
               If logging is enabled, logs will be exported to the
               configured export destination in Stackdriver.
        :param pulumi.Input[dict] match: A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
               Structure is documented below.
        :param pulumi.Input[str] policy_id: The ID of the OrganizationSecurityPolicy this rule applies to.
        :param pulumi.Input[bool] preview: If set to true, the specified action is not enforced.
        :param pulumi.Input[float] priority: An integer indicating the priority of a rule in the list. The priority must be a value
               between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the
               highest priority and 2147483647 is the lowest prority.
        :param pulumi.Input[list] target_resources: A list of network resource URLs to which this rule applies.
               This field allows you to control which network's VMs get
               this rule. If this field is left blank, all VMs
               within the organization will receive the rule.
        :param pulumi.Input[list] target_service_accounts: A list of service accounts indicating the sets of
               instances that are applied with this rule.

        The **match** object supports the following:

          * `config` (`pulumi.Input[dict]`) - The configuration options for matching the rule.
            Structure is documented below.
            * `destIpRanges` (`pulumi.Input[list]`) - Destination IP address range in CIDR format. Required for
              EGRESS rules.
            * `layer4Configs` (`pulumi.Input[list]`) - Pairs of IP protocols and ports that the rule should match.
              Structure is documented below.
              * `ip_protocol` (`pulumi.Input[str]`) - The IP protocol to which this rule applies. The protocol
                type is required when creating a firewall rule.
                This value can either be one of the following well
                known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp),
                or the IP protocol number.
              * `ports` (`pulumi.Input[list]`) - An optional list of ports to which this rule applies. This field
                is only applicable for UDP or TCP protocol. Each entry must be
                either an integer or a range. If not specified, this rule
                applies to connections through any port.
                Example inputs include: ["22"], ["80","443"], and
                ["12345-12349"].

            * `srcIpRanges` (`pulumi.Input[list]`) - Source IP address range in CIDR format. Required for
              INGRESS rules.

          * `description` (`pulumi.Input[str]`) - A description of the rule.
          * `versionedExpr` (`pulumi.Input[str]`) - Preconfigured versioned expression. For organization security policy rules,
            the only supported type is "FIREWALL".
            Default value is `FIREWALL`.
            Possible values are `FIREWALL`.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if action is None:
                raise TypeError("Missing required property 'action'")
            __props__['action'] = action
            __props__['description'] = description
            __props__['direction'] = direction
            __props__['enable_logging'] = enable_logging
            if match is None:
                raise TypeError("Missing required property 'match'")
            __props__['match'] = match
            if policy_id is None:
                raise TypeError("Missing required property 'policy_id'")
            __props__['policy_id'] = policy_id
            __props__['preview'] = preview
            if priority is None:
                raise TypeError("Missing required property 'priority'")
            __props__['priority'] = priority
            __props__['target_resources'] = target_resources
            __props__['target_service_accounts'] = target_service_accounts
        super(OrganizationSecurityPolicyRule, __self__).__init__(
            'gcp:compute/organizationSecurityPolicyRule:OrganizationSecurityPolicyRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, action=None, description=None, direction=None, enable_logging=None, match=None, policy_id=None, preview=None, priority=None, target_resources=None, target_service_accounts=None):
        """
        Get an existing OrganizationSecurityPolicyRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: The Action to perform when the client connection triggers the rule. Can currently be either
               "allow", "deny" or "goto_next".
        :param pulumi.Input[str] description: A description of the rule.
        :param pulumi.Input[str] direction: The direction in which this rule applies. If unspecified an INGRESS rule is created.
               Possible values are `INGRESS` and `EGRESS`.
        :param pulumi.Input[bool] enable_logging: Denotes whether to enable logging for a particular rule.
               If logging is enabled, logs will be exported to the
               configured export destination in Stackdriver.
        :param pulumi.Input[dict] match: A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
               Structure is documented below.
        :param pulumi.Input[str] policy_id: The ID of the OrganizationSecurityPolicy this rule applies to.
        :param pulumi.Input[bool] preview: If set to true, the specified action is not enforced.
        :param pulumi.Input[float] priority: An integer indicating the priority of a rule in the list. The priority must be a value
               between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the
               highest priority and 2147483647 is the lowest prority.
        :param pulumi.Input[list] target_resources: A list of network resource URLs to which this rule applies.
               This field allows you to control which network's VMs get
               this rule. If this field is left blank, all VMs
               within the organization will receive the rule.
        :param pulumi.Input[list] target_service_accounts: A list of service accounts indicating the sets of
               instances that are applied with this rule.

        The **match** object supports the following:

          * `config` (`pulumi.Input[dict]`) - The configuration options for matching the rule.
            Structure is documented below.
            * `destIpRanges` (`pulumi.Input[list]`) - Destination IP address range in CIDR format. Required for
              EGRESS rules.
            * `layer4Configs` (`pulumi.Input[list]`) - Pairs of IP protocols and ports that the rule should match.
              Structure is documented below.
              * `ip_protocol` (`pulumi.Input[str]`) - The IP protocol to which this rule applies. The protocol
                type is required when creating a firewall rule.
                This value can either be one of the following well
                known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp),
                or the IP protocol number.
              * `ports` (`pulumi.Input[list]`) - An optional list of ports to which this rule applies. This field
                is only applicable for UDP or TCP protocol. Each entry must be
                either an integer or a range. If not specified, this rule
                applies to connections through any port.
                Example inputs include: ["22"], ["80","443"], and
                ["12345-12349"].

            * `srcIpRanges` (`pulumi.Input[list]`) - Source IP address range in CIDR format. Required for
              INGRESS rules.

          * `description` (`pulumi.Input[str]`) - A description of the rule.
          * `versionedExpr` (`pulumi.Input[str]`) - Preconfigured versioned expression. For organization security policy rules,
            the only supported type is "FIREWALL".
            Default value is `FIREWALL`.
            Possible values are `FIREWALL`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["action"] = action
        __props__["description"] = description
        __props__["direction"] = direction
        __props__["enable_logging"] = enable_logging
        __props__["match"] = match
        __props__["policy_id"] = policy_id
        __props__["preview"] = preview
        __props__["priority"] = priority
        __props__["target_resources"] = target_resources
        __props__["target_service_accounts"] = target_service_accounts
        return OrganizationSecurityPolicyRule(resource_name, opts=opts, __props__=__props__)

    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop
