# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables


class Registry(pulumi.CustomResource):
    credentials: pulumi.Output[list]
    """
    List of public key certificates to authenticate devices.
    The structure is documented below.

      * `publicKeyCertificate` (`dict`) - A public key certificate format and data.
        * `certificate` (`str`) - The certificate data.
        * `format` (`str`) - The field allows only `X509_CERTIFICATE_PEM`.
    """
    event_notification_configs: pulumi.Output[list]
    """
    List of configurations for event notifications, such as PubSub topics
    to publish device events to.
    Structure is documented below.

      * `pubsub_topic_name` (`str`) - PubSub topic name to publish device events.
      * `subfolderMatches` (`str`) - If the subfolder name matches this string exactly, this
        configuration will be used. The string must not include the
        leading '/' character. If empty, all strings are matched. Empty
        value can only be used for the last `event_notification_configs`
        item.
    """
    http_config: pulumi.Output[dict]
    """
    Activate or deactivate HTTP.
    The structure is documented below.

      * `http_enabled_state` (`str`) - The field allows `HTTP_ENABLED` or `HTTP_DISABLED`.
    """
    log_level: pulumi.Output[str]
    """
    The default logging verbosity for activity from devices in this
    registry. Specifies which events should be written to logs. For
    example, if the LogLevel is ERROR, only events that terminate in
    errors will be logged. LogLevel is inclusive; enabling INFO logging
    will also enable ERROR logging.
    Default value is `NONE`.
    Possible values are `NONE`, `ERROR`, `INFO`, and `DEBUG`.
    """
    mqtt_config: pulumi.Output[dict]
    """
    Activate or deactivate MQTT.
    The structure is documented below.

      * `mqtt_enabled_state` (`str`) - The field allows `MQTT_ENABLED` or `MQTT_DISABLED`.
    """
    name: pulumi.Output[str]
    """
    A unique name for the resource, required by device registry.
    """
    project: pulumi.Output[str]
    """
    The ID of the project in which the resource belongs.
    If it is not provided, the provider project is used.
    """
    region: pulumi.Output[str]
    """
    The region in which the created registry should reside.
    If it is not provided, the provider region is used.
    """
    state_notification_config: pulumi.Output[dict]
    """
    A PubSub topic to publish device state updates.
    The structure is documented below.

      * `pubsub_topic_name` (`str`) - PubSub topic name to publish device events.
    """
    def __init__(__self__, resource_name, opts=None, credentials=None, event_notification_configs=None, http_config=None, log_level=None, mqtt_config=None, name=None, project=None, region=None, state_notification_config=None, __props__=None, __name__=None, __opts__=None):
        """
        A Google Cloud IoT Core device registry.

        To get more information about DeviceRegistry, see:

        * [API documentation](https://cloud.google.com/iot/docs/reference/cloudiot/rest/)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/iot/docs/)

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] credentials: List of public key certificates to authenticate devices.
               The structure is documented below.
        :param pulumi.Input[list] event_notification_configs: List of configurations for event notifications, such as PubSub topics
               to publish device events to.
               Structure is documented below.
        :param pulumi.Input[dict] http_config: Activate or deactivate HTTP.
               The structure is documented below.
        :param pulumi.Input[str] log_level: The default logging verbosity for activity from devices in this
               registry. Specifies which events should be written to logs. For
               example, if the LogLevel is ERROR, only events that terminate in
               errors will be logged. LogLevel is inclusive; enabling INFO logging
               will also enable ERROR logging.
               Default value is `NONE`.
               Possible values are `NONE`, `ERROR`, `INFO`, and `DEBUG`.
        :param pulumi.Input[dict] mqtt_config: Activate or deactivate MQTT.
               The structure is documented below.
        :param pulumi.Input[str] name: A unique name for the resource, required by device registry.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: The region in which the created registry should reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[dict] state_notification_config: A PubSub topic to publish device state updates.
               The structure is documented below.

        The **credentials** object supports the following:

          * `publicKeyCertificate` (`pulumi.Input[dict]`) - A public key certificate format and data.
            * `certificate` (`pulumi.Input[str]`) - The certificate data.
            * `format` (`pulumi.Input[str]`) - The field allows only `X509_CERTIFICATE_PEM`.

        The **event_notification_configs** object supports the following:

          * `pubsub_topic_name` (`pulumi.Input[str]`) - PubSub topic name to publish device events.
          * `subfolderMatches` (`pulumi.Input[str]`) - If the subfolder name matches this string exactly, this
            configuration will be used. The string must not include the
            leading '/' character. If empty, all strings are matched. Empty
            value can only be used for the last `event_notification_configs`
            item.

        The **http_config** object supports the following:

          * `http_enabled_state` (`pulumi.Input[str]`) - The field allows `HTTP_ENABLED` or `HTTP_DISABLED`.

        The **mqtt_config** object supports the following:

          * `mqtt_enabled_state` (`pulumi.Input[str]`) - The field allows `MQTT_ENABLED` or `MQTT_DISABLED`.

        The **state_notification_config** object supports the following:

          * `pubsub_topic_name` (`pulumi.Input[str]`) - PubSub topic name to publish device events.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['credentials'] = credentials
            __props__['event_notification_configs'] = event_notification_configs
            __props__['http_config'] = http_config
            __props__['log_level'] = log_level
            __props__['mqtt_config'] = mqtt_config
            __props__['name'] = name
            __props__['project'] = project
            __props__['region'] = region
            __props__['state_notification_config'] = state_notification_config
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="gcp:kms/registry:Registry")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Registry, __self__).__init__(
            'gcp:iot/registry:Registry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, credentials=None, event_notification_configs=None, http_config=None, log_level=None, mqtt_config=None, name=None, project=None, region=None, state_notification_config=None):
        """
        Get an existing Registry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] credentials: List of public key certificates to authenticate devices.
               The structure is documented below.
        :param pulumi.Input[list] event_notification_configs: List of configurations for event notifications, such as PubSub topics
               to publish device events to.
               Structure is documented below.
        :param pulumi.Input[dict] http_config: Activate or deactivate HTTP.
               The structure is documented below.
        :param pulumi.Input[str] log_level: The default logging verbosity for activity from devices in this
               registry. Specifies which events should be written to logs. For
               example, if the LogLevel is ERROR, only events that terminate in
               errors will be logged. LogLevel is inclusive; enabling INFO logging
               will also enable ERROR logging.
               Default value is `NONE`.
               Possible values are `NONE`, `ERROR`, `INFO`, and `DEBUG`.
        :param pulumi.Input[dict] mqtt_config: Activate or deactivate MQTT.
               The structure is documented below.
        :param pulumi.Input[str] name: A unique name for the resource, required by device registry.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: The region in which the created registry should reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[dict] state_notification_config: A PubSub topic to publish device state updates.
               The structure is documented below.

        The **credentials** object supports the following:

          * `publicKeyCertificate` (`pulumi.Input[dict]`) - A public key certificate format and data.
            * `certificate` (`pulumi.Input[str]`) - The certificate data.
            * `format` (`pulumi.Input[str]`) - The field allows only `X509_CERTIFICATE_PEM`.

        The **event_notification_configs** object supports the following:

          * `pubsub_topic_name` (`pulumi.Input[str]`) - PubSub topic name to publish device events.
          * `subfolderMatches` (`pulumi.Input[str]`) - If the subfolder name matches this string exactly, this
            configuration will be used. The string must not include the
            leading '/' character. If empty, all strings are matched. Empty
            value can only be used for the last `event_notification_configs`
            item.

        The **http_config** object supports the following:

          * `http_enabled_state` (`pulumi.Input[str]`) - The field allows `HTTP_ENABLED` or `HTTP_DISABLED`.

        The **mqtt_config** object supports the following:

          * `mqtt_enabled_state` (`pulumi.Input[str]`) - The field allows `MQTT_ENABLED` or `MQTT_DISABLED`.

        The **state_notification_config** object supports the following:

          * `pubsub_topic_name` (`pulumi.Input[str]`) - PubSub topic name to publish device events.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["credentials"] = credentials
        __props__["event_notification_configs"] = event_notification_configs
        __props__["http_config"] = http_config
        __props__["log_level"] = log_level
        __props__["mqtt_config"] = mqtt_config
        __props__["name"] = name
        __props__["project"] = project
        __props__["region"] = region
        __props__["state_notification_config"] = state_notification_config
        return Registry(resource_name, opts=opts, __props__=__props__)

    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop
