/*
    Resiliparse fast language detection profiles.
    Generated automatically, do not modify.
*/

#ifndef RESILIPARSE_LANG_PROFILES_H
#define RESILIPARSE_LANG_PROFILES_H

#include <stdint.h>

#define LANG_VEC_SIZE 256
typedef const uint8_t lang_vec_t[LANG_VEC_SIZE];

typedef struct lang {
    const char* lang;
    const lang_vec_t vec;
} lang_t;

/* Sorted by number of Wikipedia users */
static const lang_t LANGS[] = {
    {"en", {2, 4, 2, 3, 4, 36, 6, 2, 3, 5, 5, 3, 2, 3, 2, 5, 2, 1, 3, 3, 8, 2, 4, 4, 1, 2, 2, 3, 2, 1, 2, 4, 8, 2, 3, 2, 2, 5, 3, 3, 1, 2, 1, 2, 11, 3, 2, 4, 2, 3, 2, 2, 1, 6, 2, 2, 2, 2, 13, 2, 3, 3, 3, 2, 2, 5, 4, 2, 2, 2, 2, 3, 3, 3, 3, 2, 2, 3, 2, 2, 2, 4, 15, 2, 5, 7, 1, 16, 3, 2, 2, 3, 3, 4, 4, 2, 14, 2, 1, 2, 4, 2, 3, 6, 2, 3, 1, 2, 7, 2, 3, 5, 3, 3, 2, 2, 3, 2, 6, 5, 7, 4, 3, 3, 3, 2, 10, 8, 2, 2, 1, 2, 2, 1, 2, 6, 3, 3, 3, 3, 4, 2, 2, 3, 4, 2, 3, 2, 5, 4, 1, 3, 8, 4, 4, 2, 1, 7, 20, 3, 2, 3, 3, 3, 2, 3, 4, 2, 1, 5, 3, 5, 22, 6, 8, 3, 1, 4, 2, 4, 3, 2, 3, 3, 2, 2, 7, 2, 3, 8, 6, 2, 1, 3, 27, 2, 2, 2, 5, 16, 5, 2, 4, 5, 2, 3, 2, 2, 3, 3, 3, 3, 3, 3, 4, 10, 2, 1, 2, 2, 1, 3, 2, 4, 6, 3, 2, 2, 8, 3, 2, 3, 3, 2, 2, 4, 5, 5, 3, 4, 45, 17, 2, 2, 11, 2, 2, 2, 2, 2, 4, 4, 2, 2, 2, 5}},
    {"es", {3, 2, 1, 5, 5, 42, 5, 3, 1, 2, 3, 2, 3, 4, 2, 5, 1, 1, 5, 4, 5, 3, 2, 6, 1, 2, 2, 3, 1, 1, 5, 3, 7, 3, 3, 1, 3, 4, 2, 3, 3, 2, 1, 2, 12, 2, 2, 4, 2, 3, 3, 2, 1, 8, 3, 2, 3, 2, 16, 1, 8, 4, 2, 3, 2, 5, 2, 1, 2, 3, 2, 4, 3, 3, 4, 3, 2, 3, 2, 2, 3, 2, 16, 5, 4, 3, 2, 20, 2, 1, 3, 2, 2, 5, 3, 2, 6, 2, 1, 2, 2, 2, 2, 3, 2, 3, 3, 2, 9, 3, 1, 4, 3, 3, 2, 2, 2, 2, 4, 3, 1, 11, 3, 1, 2, 2, 14, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 4, 4, 5, 2, 2, 3, 5, 2, 6, 2, 5, 4, 2, 2, 9, 3, 3, 2, 2, 3, 13, 2, 2, 3, 3, 5, 5, 2, 3, 2, 2, 8, 2, 8, 26, 8, 4, 4, 5, 5, 2, 2, 1, 2, 2, 1, 2, 2, 5, 1, 4, 8, 4, 2, 1, 2, 29, 2, 3, 1, 8, 22, 4, 2, 2, 5, 4, 4, 2, 2, 2, 2, 4, 6, 3, 2, 5, 9, 1, 2, 3, 2, 2, 4, 1, 3, 2, 4, 5, 1, 7, 4, 2, 4, 3, 3, 2, 2, 2, 2, 3, 6, 46, 15, 1, 3, 9, 1, 3, 1, 1, 1, 4, 9, 2, 3, 4, 5}},
    {"fr", {3, 2, 3, 4, 7, 34, 4, 3, 2, 2, 4, 2, 4, 3, 2, 6, 2, 2, 3, 3, 5, 2, 2, 5, 2, 2, 2, 3, 2, 1, 4, 4, 7, 3, 2, 2, 2, 5, 2, 3, 7, 4, 2, 3, 15, 2, 2, 4, 1, 3, 2, 3, 2, 5, 2, 2, 4, 3, 15, 1, 4, 2, 3, 4, 1, 2, 3, 2, 2, 2, 2, 2, 4, 3, 3, 3, 2, 3, 3, 2, 3, 3, 16, 4, 3, 4, 1, 18, 3, 2, 3, 3, 3, 6, 4, 2, 6, 2, 1, 3, 2, 2, 4, 3, 4, 2, 2, 1, 8, 2, 1, 5, 2, 2, 2, 1, 1, 3, 3, 7, 2, 5, 2, 1, 2, 3, 9, 4, 2, 2, 2, 2, 2, 3, 3, 3, 3, 5, 3, 3, 5, 3, 2, 4, 3, 2, 5, 2, 5, 3, 2, 2, 11, 3, 4, 2, 2, 5, 17, 2, 2, 2, 2, 3, 2, 3, 3, 2, 2, 7, 1, 5, 19, 7, 4, 4, 4, 3, 2, 3, 2, 3, 3, 3, 2, 3, 6, 1, 3, 5, 4, 2, 2, 4, 33, 1, 2, 1, 9, 23, 4, 2, 2, 5, 2, 3, 2, 2, 4, 2, 3, 7, 3, 2, 7, 7, 1, 2, 2, 2, 2, 2, 2, 3, 3, 3, 6, 2, 6, 6, 2, 4, 3, 1, 2, 2, 7, 2, 3, 5, 46, 17, 1, 3, 15, 2, 2, 3, 2, 1, 6, 4, 2, 3, 2, 8}},
    {"de", {3, 4, 3, 3, 5, 36, 5, 3, 1, 5, 5, 2, 3, 1, 2, 4, 3, 2, 3, 3, 5, 2, 3, 4, 2, 3, 2, 2, 2, 2, 2, 6, 11, 3, 2, 2, 3, 3, 3, 4, 2, 2, 2, 1, 11, 3, 2, 6, 3, 3, 3, 3, 2, 11, 3, 3, 2, 2, 12, 3, 3, 2, 4, 2, 3, 2, 3, 4, 2, 2, 1, 4, 3, 3, 3, 3, 2, 3, 4, 3, 2, 2, 18, 2, 2, 6, 1, 17, 2, 2, 2, 3, 3, 3, 4, 2, 15, 3, 1, 4, 2, 2, 2, 3, 2, 2, 2, 2, 8, 3, 1, 5, 3, 2, 2, 2, 1, 2, 4, 7, 2, 3, 3, 2, 3, 3, 8, 2, 2, 1, 3, 2, 2, 3, 2, 4, 3, 3, 2, 3, 7, 2, 2, 2, 5, 2, 4, 3, 10, 4, 2, 2, 6, 2, 4, 3, 2, 4, 16, 3, 2, 3, 3, 2, 2, 3, 4, 2, 1, 6, 3, 4, 10, 4, 5, 4, 2, 4, 2, 3, 6, 2, 4, 2, 3, 3, 3, 1, 3, 10, 4, 2, 2, 2, 37, 2, 3, 1, 7, 17, 5, 3, 2, 5, 2, 3, 1, 1, 4, 7, 5, 2, 3, 3, 3, 5, 2, 2, 2, 3, 2, 3, 1, 4, 2, 6, 2, 2, 7, 3, 3, 3, 3, 3, 2, 2, 6, 3, 4, 11, 39, 18, 2, 3, 8, 3, 7, 2, 2, 2, 4, 7, 3, 1, 6, 4}},
    {"zh", {3, 4, 4, 3, 13, 5, 4, 3, 5, 3, 3, 3, 5, 3, 3, 5, 4, 3, 4, 4, 4, 4, 4, 3, 4, 3, 4, 3, 4, 6, 4, 5, 3, 4, 3, 3, 4, 5, 4, 4, 4, 6, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 3, 3, 5, 4, 4, 4, 4, 5, 4, 4, 4, 3, 6, 4, 4, 3, 4, 4, 4, 3, 4, 3, 3, 4, 4, 6, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 4, 6, 4, 3, 4, 4, 5, 4, 6, 3, 4, 5, 4, 4, 4, 4, 4, 4, 4, 4, 5, 4, 4, 4, 4, 4, 3, 5, 4, 4, 4, 4, 3, 4, 4, 4, 3, 4, 4, 4, 4, 5, 4, 3, 4, 4, 4, 3, 3, 4, 4, 4, 4, 4, 4, 4, 3, 5, 5, 3, 4, 3, 4, 4, 4, 4, 4, 4, 4, 5, 3, 4, 4, 3, 3, 4, 3, 4, 4, 4, 7, 4, 5, 4, 4, 5, 5, 4, 4, 3, 4, 3, 4, 3, 4, 4, 3, 4, 4, 4, 4, 5, 5, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 6, 5, 3, 4, 4, 4, 4, 4, 5, 3, 4, 3, 4, 3, 4, 4, 3, 4, 3, 4, 3, 4, 4, 4, 4, 4, 4, 4, 7, 3, 3, 4, 3, 6, 7, 4, 5, 5, 4, 4, 4, 4, 5, 4, 3, 4, 3, 3, 4}},
    {"ru", {6, 17, 2, 3, 2, 3, 3, 3, 2, 16, 2, 3, 2, 2, 2, 2, 2, 3, 2, 1, 2, 3, 3, 4, 2, 6, 3, 2, 7, 3, 2, 2, 1, 2, 2, 2, 5, 4, 3, 4, 4, 2, 14, 2, 2, 4, 21, 6, 7, 3, 1, 2, 4, 8, 5, 3, 3, 2, 3, 4, 4, 3, 2, 9, 2, 4, 2, 8, 3, 4, 2, 28, 3, 2, 3, 5, 3, 2, 2, 4, 2, 3, 3, 2, 4, 3, 5, 3, 5, 3, 2, 3, 3, 3, 3, 10, 2, 3, 4, 2, 5, 7, 15, 2, 6, 2, 2, 3, 4, 4, 2, 2, 2, 2, 4, 4, 3, 2, 3, 2, 3, 3, 3, 2, 5, 5, 4, 2, 4, 4, 2, 3, 19, 4, 2, 2, 1, 2, 19, 2, 7, 3, 2, 2, 6, 2, 3, 6, 3, 3, 3, 6, 2, 8, 2, 5, 3, 2, 3, 3, 2, 9, 5, 6, 2, 3, 3, 3, 9, 3, 2, 2, 2, 3, 2, 2, 12, 4, 2, 4, 3, 3, 2, 3, 2, 3, 3, 5, 3, 2, 2, 3, 5, 3, 3, 3, 3, 2, 2, 3, 6, 2, 2, 4, 3, 3, 2, 3, 3, 2, 3, 7, 3, 3, 3, 3, 1, 2, 3, 3, 2, 3, 4, 2, 2, 2, 2, 2, 5, 2, 3, 3, 2, 5, 8, 4, 3, 2, 2, 2, 39, 5, 4, 31, 3, 5, 3, 3, 3, 3, 3, 2, 3, 5, 2, 3}},
    {"pt", {2, 2, 2, 4, 5, 39, 5, 3, 2, 2, 4, 2, 2, 4, 2, 8, 2, 1, 5, 4, 5, 2, 2, 4, 2, 2, 2, 3, 2, 1, 4, 3, 5, 3, 3, 1, 3, 4, 3, 4, 3, 2, 1, 3, 9, 2, 2, 4, 2, 4, 3, 2, 1, 3, 3, 2, 2, 2, 11, 1, 6, 4, 2, 3, 2, 3, 2, 1, 2, 2, 2, 3, 2, 3, 2, 3, 2, 3, 2, 2, 2, 3, 16, 4, 4, 3, 1, 24, 2, 1, 2, 3, 2, 5, 5, 2, 5, 1, 1, 3, 2, 2, 3, 4, 3, 3, 3, 1, 9, 3, 1, 5, 4, 3, 2, 3, 2, 2, 6, 3, 2, 12, 3, 2, 3, 2, 11, 6, 2, 2, 1, 2, 3, 4, 2, 2, 3, 4, 4, 3, 6, 4, 2, 2, 5, 4, 6, 3, 5, 5, 2, 2, 9, 2, 4, 2, 1, 4, 15, 2, 2, 3, 4, 5, 5, 2, 2, 3, 2, 9, 2, 6, 30, 8, 4, 4, 7, 4, 1, 2, 2, 2, 3, 1, 1, 3, 4, 2, 4, 5, 3, 2, 1, 1, 27, 2, 2, 1, 9, 21, 3, 2, 2, 4, 6, 5, 2, 2, 3, 2, 3, 3, 3, 2, 5, 7, 1, 2, 4, 3, 2, 3, 1, 3, 1, 4, 4, 1, 7, 3, 2, 5, 4, 2, 3, 2, 2, 3, 3, 4, 45, 16, 1, 3, 10, 1, 3, 2, 1, 2, 3, 12, 2, 3, 3, 5}},
    {"it", {3, 2, 2, 4, 4, 41, 5, 2, 1, 2, 7, 2, 2, 4, 2, 5, 2, 1, 5, 6, 5, 3, 2, 6, 2, 2, 1, 4, 2, 2, 3, 3, 8, 2, 3, 2, 3, 4, 2, 2, 2, 2, 1, 2, 10, 3, 2, 5, 1, 3, 3, 2, 1, 4, 3, 1, 3, 9, 21, 2, 5, 5, 3, 2, 2, 3, 2, 2, 2, 2, 2, 3, 2, 3, 5, 3, 2, 4, 2, 2, 2, 4, 15, 4, 3, 5, 2, 18, 3, 1, 2, 2, 4, 5, 4, 2, 6, 1, 1, 2, 1, 2, 3, 4, 3, 2, 2, 2, 8, 3, 1, 5, 3, 2, 2, 2, 1, 2, 4, 2, 2, 11, 2, 1, 3, 4, 12, 4, 3, 1, 1, 2, 3, 3, 3, 2, 2, 4, 4, 3, 5, 3, 3, 3, 4, 2, 4, 3, 4, 4, 2, 2, 3, 2, 4, 2, 1, 6, 17, 2, 1, 2, 2, 5, 3, 3, 3, 2, 2, 9, 2, 4, 28, 4, 4, 3, 2, 2, 2, 2, 2, 3, 3, 1, 2, 2, 4, 1, 5, 7, 5, 2, 2, 2, 27, 2, 5, 1, 8, 15, 3, 2, 3, 6, 4, 4, 3, 2, 3, 3, 3, 3, 4, 1, 3, 9, 1, 1, 2, 2, 2, 4, 2, 3, 4, 4, 2, 1, 7, 4, 1, 4, 2, 2, 3, 2, 2, 3, 4, 4, 42, 25, 2, 3, 12, 2, 4, 3, 1, 2, 5, 12, 2, 3, 5, 6}},
    {"ar", {3, 2, 3, 2, 2, 4, 3, 1, 4, 4, 3, 3, 2, 2, 3, 3, 2, 3, 3, 3, 2, 1, 3, 2, 2, 4, 2, 2, 7, 2, 1, 6, 3, 11, 2, 4, 2, 4, 1, 4, 3, 15, 2, 7, 2, 4, 3, 9, 4, 3, 3, 2, 3, 3, 3, 2, 2, 8, 7, 3, 3, 6, 2, 7, 3, 3, 4, 2, 11, 3, 5, 1, 6, 1, 16, 3, 3, 2, 2, 5, 8, 2, 2, 3, 4, 2, 5, 2, 2, 3, 2, 2, 2, 2, 5, 7, 1, 10, 2, 2, 3, 2, 2, 3, 4, 3, 3, 9, 2, 2, 3, 3, 2, 3, 2, 3, 2, 6, 2, 1, 3, 6, 2, 4, 3, 3, 3, 2, 2, 3, 2, 4, 3, 3, 4, 3, 2, 3, 4, 6, 2, 4, 2, 4, 1, 4, 3, 3, 8, 2, 6, 2, 2, 3, 3, 2, 2, 12, 3, 3, 3, 4, 33, 3, 5, 2, 3, 1, 2, 2, 5, 2, 4, 3, 13, 4, 2, 2, 9, 2, 16, 2, 3, 3, 4, 5, 3, 3, 2, 16, 3, 3, 2, 3, 2, 2, 6, 3, 10, 3, 3, 2, 2, 2, 3, 1, 2, 4, 2, 4, 2, 2, 2, 2, 2, 3, 3, 4, 2, 1, 2, 5, 2, 26, 3, 4, 2, 3, 2, 3, 4, 5, 3, 6, 2, 2, 3, 3, 4, 5, 56, 2, 3, 4, 2, 2, 14, 1, 2, 2, 2, 2, 2, 3, 3, 22}},
    {"ja", {4, 4, 3, 5, 4, 4, 4, 3, 3, 3, 3, 7, 3, 5, 7, 4, 4, 3, 4, 4, 4, 3, 3, 7, 3, 4, 4, 8, 7, 5, 3, 4, 3, 3, 6, 4, 3, 4, 3, 10, 3, 4, 8, 4, 3, 4, 5, 4, 8, 7, 3, 4, 4, 4, 4, 4, 3, 4, 4, 4, 3, 3, 3, 4, 5, 3, 4, 3, 3, 3, 3, 3, 4, 3, 4, 3, 4, 4, 4, 3, 7, 3, 4, 3, 3, 14, 3, 4, 3, 3, 3, 3, 5, 5, 3, 3, 3, 5, 4, 4, 4, 4, 3, 6, 3, 4, 6, 4, 4, 4, 3, 5, 4, 3, 3, 4, 3, 3, 3, 4, 3, 4, 3, 4, 6, 4, 3, 3, 3, 3, 10, 3, 3, 8, 4, 3, 3, 6, 3, 4, 3, 4, 6, 3, 3, 4, 3, 3, 3, 4, 3, 3, 4, 3, 3, 3, 3, 5, 3, 3, 4, 5, 3, 3, 4, 3, 3, 3, 3, 4, 4, 3, 6, 3, 8, 3, 3, 4, 5, 4, 3, 4, 4, 3, 3, 3, 4, 3, 6, 3, 4, 4, 3, 4, 3, 4, 3, 3, 4, 3, 3, 3, 4, 4, 4, 3, 9, 4, 3, 3, 4, 4, 3, 3, 3, 3, 7, 3, 4, 4, 5, 3, 3, 3, 4, 3, 4, 3, 4, 4, 3, 6, 3, 5, 8, 4, 3, 3, 4, 3, 6, 6, 3, 4, 4, 6, 4, 4, 4, 4, 4, 4, 8, 4, 3, 3}},
    {"tr", {4, 3, 2, 4, 4, 44, 7, 3, 12, 3, 4, 3, 2, 2, 2, 7, 2, 2, 3, 2, 7, 2, 3, 7, 3, 3, 2, 2, 3, 2, 2, 3, 6, 2, 2, 2, 4, 4, 2, 2, 2, 2, 2, 2, 8, 2, 3, 6, 4, 3, 3, 1, 2, 7, 2, 3, 2, 5, 19, 9, 3, 3, 3, 5, 5, 3, 2, 2, 2, 2, 3, 3, 3, 4, 3, 3, 2, 3, 2, 3, 3, 3, 18, 4, 4, 3, 1, 18, 2, 4, 2, 3, 4, 3, 4, 3, 6, 1, 3, 2, 2, 2, 3, 3, 2, 2, 3, 2, 5, 2, 2, 5, 3, 2, 3, 2, 2, 3, 3, 6, 2, 6, 3, 2, 4, 2, 5, 6, 3, 2, 1, 2, 2, 2, 2, 2, 4, 5, 3, 2, 4, 3, 2, 3, 3, 2, 3, 2, 5, 3, 3, 4, 3, 2, 4, 5, 2, 5, 13, 4, 3, 2, 2, 1, 4, 5, 3, 2, 2, 5, 2, 4, 11, 5, 8, 3, 3, 3, 2, 2, 3, 2, 3, 2, 2, 2, 10, 1, 4, 7, 3, 4, 1, 3, 21, 3, 3, 3, 7, 11, 6, 2, 2, 3, 2, 2, 3, 3, 3, 3, 12, 4, 4, 2, 3, 6, 2, 2, 4, 2, 3, 3, 2, 3, 2, 4, 1, 1, 10, 3, 3, 4, 6, 2, 2, 2, 4, 6, 5, 3, 39, 20, 2, 2, 7, 2, 2, 3, 3, 2, 6, 4, 2, 1, 5, 5}},
    {"id", {3, 8, 2, 3, 6, 64, 5, 3, 2, 3, 5, 3, 2, 2, 2, 5, 2, 2, 4, 3, 13, 3, 1, 5, 3, 2, 1, 1, 2, 2, 2, 4, 11, 2, 2, 2, 2, 4, 2, 3, 1, 2, 3, 3, 12, 2, 2, 6, 2, 5, 2, 2, 1, 9, 1, 2, 1, 6, 13, 5, 3, 5, 2, 5, 4, 2, 4, 2, 2, 2, 1, 5, 3, 3, 3, 4, 4, 2, 3, 3, 1, 5, 14, 2, 4, 3, 1, 20, 1, 1, 1, 2, 2, 3, 5, 1, 9, 1, 1, 3, 2, 2, 2, 4, 3, 1, 6, 2, 6, 1, 4, 7, 3, 2, 2, 2, 2, 2, 4, 3, 2, 9, 3, 1, 3, 2, 4, 5, 3, 1, 1, 2, 2, 4, 2, 2, 5, 2, 2, 2, 5, 5, 3, 2, 2, 2, 4, 1, 7, 2, 2, 3, 4, 2, 3, 4, 1, 4, 18, 7, 1, 3, 5, 2, 4, 4, 5, 2, 1, 6, 3, 2, 15, 5, 2, 3, 2, 2, 2, 2, 3, 4, 4, 2, 2, 3, 6, 2, 7, 7, 2, 2, 2, 2, 20, 3, 2, 2, 8, 12, 7, 4, 1, 5, 3, 4, 1, 3, 2, 3, 14, 5, 3, 3, 2, 6, 3, 2, 2, 4, 2, 3, 2, 5, 3, 4, 3, 1, 8, 2, 1, 4, 3, 1, 2, 4, 3, 4, 4, 5, 39, 20, 2, 2, 4, 2, 2, 1, 2, 2, 5, 4, 2, 2, 2, 6}},
    {"nl", {6, 3, 2, 2, 3, 39, 7, 2, 6, 5, 6, 2, 2, 2, 3, 3, 3, 2, 2, 3, 9, 2, 2, 4, 1, 2, 2, 3, 1, 2, 2, 4, 12, 2, 2, 3, 3, 3, 3, 3, 2, 2, 2, 2, 6, 3, 2, 4, 2, 3, 2, 5, 2, 14, 2, 2, 2, 1, 12, 2, 3, 2, 3, 3, 3, 1, 3, 4, 2, 1, 2, 5, 2, 3, 3, 2, 2, 2, 3, 2, 2, 4, 18, 5, 3, 4, 1, 19, 4, 2, 2, 4, 3, 2, 3, 2, 10, 3, 1, 4, 2, 2, 2, 4, 5, 3, 4, 2, 10, 2, 3, 6, 2, 2, 2, 2, 3, 2, 3, 6, 2, 3, 2, 2, 3, 2, 6, 3, 2, 1, 2, 2, 2, 3, 3, 4, 3, 6, 4, 4, 5, 3, 2, 2, 3, 3, 5, 2, 10, 4, 2, 3, 5, 2, 4, 3, 1, 4, 18, 4, 2, 5, 3, 2, 2, 2, 4, 1, 3, 4, 2, 5, 18, 6, 4, 3, 7, 5, 2, 2, 5, 2, 3, 2, 2, 3, 3, 2, 4, 9, 3, 3, 2, 2, 40, 2, 3, 2, 7, 14, 5, 3, 2, 3, 3, 2, 2, 2, 4, 3, 7, 3, 2, 3, 5, 5, 2, 2, 1, 2, 1, 3, 1, 4, 3, 5, 1, 1, 6, 3, 2, 3, 3, 2, 2, 2, 8, 5, 3, 10, 42, 16, 1, 3, 10, 2, 3, 2, 2, 1, 4, 4, 4, 1, 6, 4}},
    {"pl", {2, 2, 3, 3, 6, 35, 6, 2, 3, 12, 2, 2, 2, 2, 2, 4, 3, 3, 4, 3, 5, 4, 2, 3, 2, 3, 1, 3, 3, 2, 2, 6, 5, 2, 3, 2, 3, 3, 2, 2, 2, 3, 2, 2, 8, 3, 2, 6, 1, 4, 3, 2, 2, 2, 3, 3, 2, 6, 8, 4, 4, 4, 3, 4, 6, 4, 2, 2, 2, 2, 3, 7, 2, 2, 4, 2, 2, 3, 2, 4, 3, 3, 13, 2, 2, 4, 2, 16, 3, 2, 4, 2, 3, 4, 4, 4, 8, 4, 2, 3, 2, 3, 3, 3, 2, 3, 2, 3, 4, 4, 3, 4, 5, 3, 2, 2, 2, 2, 3, 1, 4, 6, 4, 2, 2, 3, 13, 4, 3, 2, 4, 3, 4, 3, 3, 4, 2, 2, 2, 4, 6, 2, 2, 3, 3, 4, 4, 2, 3, 4, 2, 3, 3, 2, 4, 3, 2, 4, 12, 2, 2, 3, 3, 4, 4, 2, 4, 2, 2, 8, 3, 4, 25, 4, 3, 2, 2, 7, 2, 2, 3, 3, 3, 3, 2, 3, 13, 3, 3, 5, 3, 2, 1, 2, 20, 3, 3, 2, 5, 11, 4, 1, 3, 6, 4, 4, 6, 4, 6, 5, 10, 5, 4, 1, 2, 3, 2, 2, 3, 2, 3, 3, 2, 3, 1, 4, 2, 2, 4, 4, 2, 3, 3, 2, 2, 3, 2, 10, 5, 5, 39, 19, 4, 2, 8, 2, 3, 2, 2, 3, 3, 8, 2, 2, 13, 4}},
    {"fa", {6, 3, 2, 2, 2, 9, 3, 2, 2, 2, 3, 4, 2, 3, 3, 7, 2, 2, 2, 3, 2, 1, 3, 3, 2, 6, 3, 2, 4, 2, 4, 10, 3, 3, 2, 3, 21, 2, 2, 3, 2, 14, 2, 4, 2, 4, 2, 20, 3, 3, 2, 3, 2, 5, 3, 2, 2, 4, 3, 2, 3, 6, 1, 8, 5, 4, 2, 5, 12, 1, 4, 2, 7, 2, 15, 3, 3, 2, 2, 6, 9, 3, 2, 3, 5, 2, 4, 3, 2, 3, 5, 2, 3, 2, 3, 7, 2, 11, 2, 3, 4, 4, 1, 2, 6, 3, 5, 16, 2, 2, 1, 2, 2, 2, 2, 3, 2, 3, 3, 2, 5, 5, 2, 9, 2, 5, 3, 3, 2, 2, 3, 4, 3, 3, 5, 2, 2, 1, 2, 3, 1, 4, 3, 7, 2, 1, 2, 4, 5, 2, 4, 4, 2, 4, 2, 2, 3, 19, 2, 3, 3, 2, 31, 3, 4, 2, 2, 3, 2, 3, 3, 2, 3, 2, 2, 9, 2, 5, 3, 1, 4, 2, 2, 2, 3, 6, 3, 3, 4, 10, 5, 5, 2, 2, 2, 1, 6, 3, 15, 3, 2, 4, 2, 3, 2, 2, 2, 4, 5, 3, 2, 1, 4, 2, 3, 4, 7, 4, 4, 2, 2, 4, 2, 8, 3, 2, 2, 1, 2, 2, 2, 2, 2, 3, 3, 6, 3, 3, 2, 3, 53, 5, 2, 7, 3, 3, 16, 2, 2, 1, 2, 4, 2, 3, 2, 12}},
    {"he", {2, 2, 2, 3, 2, 8, 2, 4, 6, 2, 3, 2, 5, 2, 2, 2, 4, 5, 5, 3, 3, 3, 2, 2, 3, 3, 2, 14, 3, 2, 2, 2, 3, 2, 2, 2, 3, 2, 2, 2, 3, 2, 2, 3, 10, 3, 2, 2, 3, 5, 7, 3, 15, 3, 5, 3, 4, 1, 3, 4, 8, 3, 4, 3, 3, 2, 2, 3, 2, 3, 2, 2, 7, 2, 3, 2, 3, 6, 2, 4, 3, 28, 6, 3, 3, 2, 3, 4, 2, 18, 3, 5, 2, 2, 3, 2, 27, 3, 2, 3, 2, 2, 15, 3, 2, 4, 3, 3, 17, 4, 2, 1, 2, 3, 3, 2, 6, 6, 3, 2, 2, 10, 12, 2, 3, 2, 3, 4, 2, 2, 5, 2, 3, 3, 3, 3, 9, 3, 2, 1, 5, 2, 3, 2, 3, 3, 4, 1, 2, 2, 1, 2, 4, 2, 1, 4, 2, 2, 6, 2, 2, 22, 4, 3, 1, 13, 2, 7, 4, 3, 2, 5, 2, 2, 2, 3, 2, 2, 3, 2, 2, 3, 4, 4, 3, 2, 2, 1, 2, 9, 3, 4, 3, 4, 4, 4, 3, 2, 2, 2, 9, 11, 3, 3, 3, 2, 2, 1, 2, 2, 6, 2, 2, 2, 2, 5, 3, 4, 2, 7, 4, 1, 6, 7, 7, 3, 3, 3, 3, 5, 2, 2, 2, 1, 2, 2, 2, 7, 3, 3, 48, 2, 10, 13, 2, 3, 4, 2, 3, 2, 3, 6, 6, 5, 2, 2}},
    {"vi", {6, 13, 2, 2, 3, 35, 3, 3, 2, 2, 2, 4, 4, 2, 1, 6, 1, 3, 2, 3, 3, 2, 1, 3, 2, 3, 3, 2, 1, 6, 3, 2, 11, 1, 4, 2, 3, 2, 3, 2, 3, 2, 2, 2, 9, 3, 6, 6, 3, 4, 3, 2, 2, 9, 2, 3, 1, 8, 7, 3, 3, 5, 3, 4, 4, 1, 2, 2, 1, 5, 4, 2, 4, 2, 1, 3, 4, 2, 2, 1, 2, 2, 9, 5, 2, 4, 3, 10, 2, 3, 2, 3, 2, 13, 7, 2, 19, 4, 2, 6, 3, 3, 2, 3, 3, 2, 3, 2, 5, 2, 2, 3, 3, 5, 2, 9, 5, 3, 3, 5, 5, 5, 3, 2, 4, 2, 15, 10, 2, 6, 1, 2, 3, 3, 2, 2, 3, 6, 4, 4, 4, 4, 3, 2, 2, 1, 2, 4, 3, 4, 4, 1, 3, 2, 5, 4, 3, 3, 15, 3, 2, 3, 2, 2, 3, 3, 10, 3, 3, 4, 2, 4, 11, 4, 1, 2, 2, 4, 3, 2, 3, 2, 3, 2, 5, 2, 7, 4, 2, 4, 2, 2, 2, 3, 4, 3, 2, 2, 4, 5, 6, 3, 3, 3, 3, 3, 2, 2, 4, 5, 5, 7, 2, 2, 4, 6, 2, 2, 2, 3, 2, 5, 2, 10, 2, 2, 2, 2, 3, 3, 2, 3, 4, 4, 3, 2, 6, 4, 4, 5, 61, 14, 4, 6, 7, 5, 2, 4, 2, 2, 3, 4, 2, 3, 3, 4}},
    {"sv", {3, 4, 2, 4, 3, 42, 7, 3, 3, 2, 3, 2, 2, 2, 2, 4, 3, 2, 3, 3, 7, 3, 3, 4, 2, 2, 2, 3, 3, 1, 2, 4, 10, 2, 2, 3, 2, 4, 3, 5, 3, 2, 2, 3, 8, 4, 2, 3, 2, 3, 3, 2, 2, 8, 2, 2, 2, 6, 14, 3, 3, 3, 7, 3, 3, 3, 3, 2, 1, 1, 2, 4, 2, 3, 2, 2, 3, 2, 2, 2, 3, 4, 19, 3, 2, 4, 1, 19, 2, 2, 2, 4, 2, 4, 4, 4, 9, 3, 1, 3, 3, 2, 2, 3, 3, 3, 3, 2, 8, 2, 3, 6, 3, 4, 2, 2, 2, 2, 3, 7, 3, 7, 2, 2, 3, 3, 5, 5, 2, 2, 3, 2, 2, 2, 2, 4, 3, 6, 2, 3, 5, 3, 2, 2, 4, 2, 5, 2, 6, 4, 2, 2, 5, 3, 3, 3, 3, 5, 20, 3, 2, 3, 3, 2, 4, 4, 4, 2, 3, 9, 3, 4, 16, 4, 6, 3, 4, 3, 2, 2, 3, 3, 4, 2, 2, 3, 5, 2, 3, 9, 5, 5, 1, 2, 25, 2, 3, 2, 6, 17, 5, 2, 2, 6, 3, 4, 1, 2, 5, 4, 8, 4, 4, 2, 3, 5, 1, 2, 1, 2, 2, 3, 2, 3, 4, 4, 2, 2, 7, 4, 1, 3, 4, 2, 3, 3, 7, 5, 4, 6, 41, 14, 1, 4, 5, 2, 3, 3, 2, 3, 4, 3, 2, 2, 3, 5}},
    {"ko", {4, 4, 3, 3, 4, 4, 3, 3, 2, 4, 3, 3, 4, 4, 5, 4, 4, 3, 3, 3, 4, 3, 3, 4, 5, 3, 5, 3, 4, 3, 3, 3, 5, 3, 3, 3, 3, 4, 3, 4, 3, 3, 3, 3, 4, 4, 4, 4, 3, 3, 4, 3, 4, 4, 3, 4, 5, 3, 3, 3, 4, 3, 3, 4, 4, 4, 3, 6, 3, 3, 6, 5, 4, 3, 4, 3, 3, 4, 3, 3, 4, 3, 3, 5, 4, 3, 3, 3, 3, 5, 5, 2, 3, 3, 3, 3, 3, 4, 6, 6, 3, 6, 6, 9, 8, 4, 7, 3, 3, 4, 4, 3, 3, 2, 3, 3, 4, 2, 4, 2, 3, 3, 4, 4, 3, 3, 4, 3, 4, 4, 12, 3, 3, 3, 4, 4, 3, 2, 4, 3, 3, 3, 5, 4, 4, 4, 4, 7, 3, 3, 4, 3, 3, 3, 3, 3, 5, 3, 5, 4, 3, 3, 4, 3, 3, 3, 8, 3, 3, 9, 3, 3, 3, 7, 4, 3, 3, 3, 5, 3, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 5, 3, 3, 6, 8, 2, 3, 3, 4, 3, 4, 3, 2, 3, 4, 5, 7, 4, 4, 4, 3, 3, 3, 4, 4, 3, 4, 5, 3, 3, 3, 3, 4, 5, 3, 3, 3, 3, 3, 4, 3, 2, 3, 5, 4, 4, 3, 4, 5, 65, 3, 3, 4, 10, 8, 3, 5, 5, 3, 3, 3, 6, 3, 3, 7}},
    {"hi", {2, 3, 2, 3, 2, 2, 14, 2, 1, 2, 4, 2, 2, 10, 3, 2, 2, 4, 2, 3, 2, 1, 3, 3, 5, 4, 3, 3, 3, 4, 2, 1, 3, 3, 4, 3, 3, 1, 2, 3, 4, 2, 2, 3, 3, 3, 2, 2, 3, 2, 11, 24, 3, 2, 3, 1, 7, 2, 2, 2, 12, 2, 3, 4, 3, 2, 2, 2, 1, 4, 18, 2, 2, 9, 2, 4, 2, 2, 2, 2, 3, 4, 8, 3, 6, 9, 5, 3, 2, 2, 4, 2, 5, 2, 3, 3, 4, 3, 3, 2, 4, 5, 15, 3, 3, 4, 8, 2, 2, 13, 3, 3, 2, 3, 5, 2, 4, 3, 2, 2, 4, 2, 6, 1, 3, 5, 3, 3, 3, 2, 1, 2, 3, 2, 7, 2, 2, 2, 4, 2, 2, 2, 5, 6, 7, 2, 3, 2, 2, 4, 2, 1, 2, 5, 2, 4, 14, 3, 3, 3, 3, 7, 2, 3, 8, 10, 3, 3, 3, 3, 4, 1, 13, 2, 6, 2, 2, 3, 2, 3, 2, 11, 3, 2, 7, 2, 3, 3, 6, 5, 2, 3, 3, 2, 3, 2, 2, 7, 2, 5, 3, 2, 7, 3, 3, 15, 3, 2, 5, 3, 23, 2, 3, 2, 2, 4, 5, 3, 2, 2, 3, 4, 2, 4, 2, 2, 2, 7, 2, 3, 2, 5, 2, 2, 2, 4, 2, 2, 2, 2, 75, 4, 8, 5, 3, 2, 3, 2, 3, 1, 3, 1, 10, 2, 8, 2}},
    {"uk", {7, 16, 2, 2, 2, 3, 5, 3, 3, 18, 3, 3, 2, 2, 2, 2, 2, 3, 2, 1, 1, 3, 6, 4, 2, 7, 4, 3, 6, 2, 2, 2, 2, 2, 2, 3, 5, 6, 3, 3, 3, 3, 13, 3, 2, 4, 16, 3, 3, 2, 2, 7, 5, 8, 6, 5, 2, 2, 3, 3, 3, 4, 2, 7, 3, 3, 3, 7, 4, 4, 2, 24, 3, 3, 3, 5, 3, 3, 2, 4, 3, 4, 4, 2, 4, 3, 5, 3, 5, 4, 3, 3, 3, 3, 3, 11, 2, 2, 5, 2, 5, 4, 12, 1, 6, 2, 2, 2, 3, 4, 2, 2, 2, 2, 4, 4, 2, 2, 2, 3, 3, 4, 2, 2, 5, 5, 4, 3, 3, 4, 2, 2, 11, 2, 2, 3, 1, 3, 21, 1, 8, 3, 3, 2, 6, 2, 2, 5, 3, 2, 4, 4, 2, 8, 3, 5, 3, 2, 2, 4, 2, 11, 5, 6, 2, 3, 3, 3, 8, 2, 2, 16, 2, 4, 2, 3, 10, 5, 3, 3, 3, 3, 2, 2, 3, 2, 3, 4, 3, 3, 3, 3, 4, 3, 3, 3, 3, 2, 2, 3, 6, 3, 3, 3, 2, 2, 3, 4, 3, 3, 3, 6, 3, 4, 4, 2, 2, 2, 3, 3, 2, 3, 4, 3, 1, 3, 2, 3, 4, 2, 1, 4, 2, 4, 9, 3, 3, 2, 2, 2, 40, 5, 3, 31, 3, 7, 2, 3, 3, 3, 4, 2, 4, 4, 2, 3}},
    {"ro", {3, 3, 2, 5, 4, 40, 4, 3, 1, 2, 4, 4, 2, 2, 4, 5, 3, 1, 3, 3, 5, 2, 3, 5, 2, 2, 1, 2, 2, 1, 1, 4, 6, 2, 3, 2, 2, 6, 2, 2, 3, 2, 2, 3, 16, 3, 1, 6, 5, 4, 4, 2, 1, 5, 2, 3, 2, 7, 15, 1, 4, 5, 2, 3, 2, 3, 7, 2, 1, 2, 2, 3, 3, 6, 3, 4, 3, 2, 2, 2, 2, 3, 20, 4, 2, 4, 1, 16, 3, 2, 3, 2, 3, 6, 3, 3, 7, 2, 1, 3, 2, 2, 3, 3, 2, 3, 2, 2, 8, 4, 2, 5, 3, 2, 2, 1, 2, 3, 6, 3, 2, 14, 2, 1, 4, 2, 13, 4, 2, 3, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 6, 2, 2, 4, 4, 3, 5, 3, 4, 4, 2, 2, 3, 2, 5, 2, 2, 5, 17, 1, 5, 3, 2, 3, 2, 2, 4, 2, 2, 8, 3, 4, 19, 5, 4, 3, 4, 3, 2, 3, 3, 2, 2, 2, 2, 4, 4, 1, 5, 6, 5, 2, 1, 3, 26, 2, 3, 1, 6, 14, 5, 2, 4, 6, 2, 4, 2, 2, 5, 2, 3, 4, 5, 3, 4, 8, 2, 1, 2, 5, 2, 4, 2, 2, 2, 3, 2, 2, 10, 3, 2, 4, 2, 1, 3, 2, 5, 2, 4, 4, 43, 24, 2, 4, 11, 1, 4, 2, 2, 2, 5, 5, 2, 3, 4, 5}},
    {"cs", {5, 3, 2, 4, 3, 33, 5, 3, 2, 2, 4, 3, 2, 3, 2, 6, 2, 2, 5, 3, 4, 3, 4, 4, 2, 3, 2, 5, 2, 5, 2, 3, 3, 2, 3, 3, 4, 3, 3, 2, 5, 2, 3, 2, 9, 2, 2, 7, 2, 4, 2, 2, 2, 3, 2, 2, 3, 4, 13, 2, 3, 3, 3, 4, 4, 3, 2, 1, 2, 2, 3, 6, 2, 3, 2, 3, 3, 2, 3, 2, 3, 3, 11, 3, 3, 3, 2, 19, 3, 2, 3, 5, 3, 2, 5, 2, 10, 4, 4, 2, 2, 3, 3, 3, 2, 3, 1, 2, 4, 3, 2, 5, 3, 3, 2, 2, 2, 2, 4, 2, 4, 6, 2, 2, 3, 2, 9, 4, 3, 1, 2, 3, 3, 2, 3, 3, 3, 11, 2, 7, 4, 3, 3, 2, 4, 3, 4, 3, 4, 5, 2, 3, 4, 4, 4, 4, 2, 9, 15, 3, 2, 3, 2, 3, 3, 3, 4, 2, 2, 8, 2, 5, 27, 4, 3, 4, 3, 4, 2, 3, 2, 2, 3, 2, 2, 3, 8, 4, 3, 5, 3, 2, 2, 2, 21, 2, 3, 4, 5, 12, 6, 2, 3, 6, 4, 5, 3, 2, 5, 4, 11, 4, 3, 1, 4, 4, 3, 2, 3, 5, 3, 3, 2, 2, 2, 4, 1, 2, 5, 5, 2, 3, 2, 2, 3, 2, 3, 3, 3, 4, 43, 12, 3, 7, 9, 3, 3, 2, 2, 2, 4, 8, 2, 2, 6, 3}},
    {"no", {4, 3, 2, 3, 4, 34, 7, 3, 2, 2, 4, 2, 2, 2, 2, 5, 2, 2, 3, 3, 7, 2, 1, 5, 2, 3, 2, 3, 2, 1, 2, 5, 11, 2, 2, 2, 2, 5, 2, 5, 2, 2, 2, 2, 8, 3, 2, 3, 2, 3, 3, 2, 2, 8, 2, 2, 2, 6, 13, 2, 4, 3, 3, 3, 3, 2, 3, 3, 1, 2, 2, 4, 2, 3, 3, 2, 2, 2, 3, 2, 3, 3, 19, 3, 3, 4, 1, 18, 3, 2, 2, 3, 4, 4, 4, 5, 8, 3, 2, 3, 3, 2, 2, 3, 3, 3, 2, 2, 7, 2, 3, 6, 4, 3, 2, 2, 3, 2, 3, 7, 3, 3, 2, 2, 3, 3, 3, 6, 3, 2, 2, 2, 2, 3, 2, 3, 3, 7, 3, 2, 7, 3, 1, 3, 3, 2, 7, 2, 7, 4, 2, 2, 5, 3, 3, 3, 3, 5, 20, 2, 2, 3, 2, 2, 3, 4, 4, 1, 1, 6, 4, 5, 17, 4, 4, 4, 3, 3, 2, 2, 4, 3, 6, 2, 2, 2, 5, 2, 3, 10, 5, 5, 1, 2, 35, 2, 3, 2, 8, 17, 5, 2, 2, 6, 3, 2, 2, 2, 4, 2, 10, 3, 3, 2, 3, 5, 2, 2, 2, 3, 1, 3, 2, 5, 4, 5, 2, 2, 6, 4, 2, 3, 3, 2, 4, 3, 8, 6, 4, 7, 44, 15, 1, 3, 9, 2, 3, 3, 2, 3, 5, 3, 3, 2, 2, 5}},
    {"fi", {4, 3, 2, 3, 5, 50, 8, 3, 4, 2, 3, 2, 3, 1, 2, 3, 1, 3, 4, 3, 7, 3, 1, 4, 2, 2, 2, 3, 2, 1, 3, 2, 4, 1, 2, 4, 2, 3, 2, 3, 3, 1, 2, 3, 16, 3, 1, 5, 2, 5, 3, 5, 2, 11, 2, 1, 2, 5, 15, 3, 4, 3, 4, 4, 4, 1, 3, 2, 1, 2, 3, 8, 3, 4, 1, 2, 2, 2, 2, 2, 2, 3, 9, 3, 2, 4, 2, 11, 2, 1, 2, 4, 3, 4, 6, 2, 10, 3, 1, 3, 2, 1, 3, 4, 5, 1, 4, 2, 6, 3, 4, 7, 3, 4, 3, 2, 2, 1, 3, 3, 3, 12, 2, 2, 2, 4, 3, 4, 2, 1, 3, 4, 2, 2, 3, 2, 2, 7, 2, 3, 5, 3, 2, 2, 3, 2, 4, 2, 9, 3, 3, 3, 4, 2, 7, 2, 1, 4, 21, 3, 2, 3, 3, 2, 5, 3, 5, 1, 2, 13, 1, 3, 20, 4, 2, 5, 3, 4, 2, 4, 2, 5, 2, 3, 3, 4, 7, 2, 4, 3, 3, 2, 2, 3, 20, 4, 3, 2, 3, 20, 3, 1, 3, 4, 3, 3, 2, 4, 3, 3, 14, 7, 4, 2, 6, 5, 1, 2, 2, 2, 2, 2, 2, 2, 4, 6, 1, 2, 7, 4, 2, 3, 2, 2, 2, 3, 3, 3, 3, 8, 33, 26, 2, 2, 3, 2, 4, 2, 2, 2, 3, 5, 2, 3, 3, 6}},
    {"hu", {3, 3, 2, 3, 4, 34, 7, 4, 2, 3, 4, 3, 3, 2, 3, 3, 3, 2, 3, 2, 5, 4, 3, 4, 3, 2, 2, 3, 2, 2, 1, 4, 10, 2, 6, 2, 4, 5, 2, 3, 10, 3, 2, 3, 6, 2, 2, 4, 2, 5, 3, 2, 2, 5, 3, 2, 2, 4, 17, 5, 4, 3, 5, 4, 5, 2, 2, 2, 2, 3, 2, 5, 2, 2, 2, 2, 2, 6, 3, 3, 3, 4, 12, 2, 2, 3, 1, 14, 4, 2, 2, 4, 3, 4, 4, 3, 6, 2, 2, 2, 2, 2, 3, 3, 3, 2, 2, 2, 5, 2, 2, 6, 4, 4, 2, 2, 6, 3, 6, 3, 3, 8, 2, 1, 2, 2, 6, 5, 4, 2, 1, 3, 3, 1, 2, 3, 3, 8, 3, 3, 5, 3, 3, 2, 3, 2, 6, 2, 5, 4, 3, 2, 7, 2, 4, 6, 2, 5, 20, 3, 2, 2, 3, 2, 2, 2, 4, 3, 2, 4, 3, 5, 14, 4, 3, 3, 4, 4, 3, 2, 3, 2, 2, 2, 2, 2, 8, 2, 3, 6, 4, 3, 2, 2, 24, 2, 3, 2, 3, 16, 8, 3, 2, 4, 2, 4, 3, 5, 3, 2, 13, 4, 5, 2, 3, 6, 2, 2, 3, 2, 1, 3, 2, 5, 3, 4, 2, 2, 5, 3, 3, 3, 3, 2, 2, 2, 8, 4, 3, 5, 39, 11, 2, 11, 4, 2, 2, 4, 3, 2, 4, 4, 3, 2, 11, 4}},
    {"da", {4, 3, 2, 3, 4, 33, 7, 2, 2, 2, 4, 2, 2, 1, 2, 5, 2, 2, 3, 3, 7, 2, 2, 4, 2, 3, 2, 3, 2, 2, 1, 5, 13, 2, 2, 2, 3, 5, 3, 4, 2, 1, 1, 1, 7, 3, 2, 3, 3, 3, 3, 2, 1, 8, 2, 2, 2, 5, 13, 2, 3, 3, 3, 3, 4, 2, 3, 3, 2, 2, 1, 5, 2, 3, 3, 2, 2, 2, 3, 2, 3, 3, 19, 3, 3, 3, 1, 21, 3, 2, 2, 3, 4, 3, 4, 5, 8, 3, 2, 2, 3, 2, 2, 3, 2, 3, 2, 2, 9, 2, 3, 6, 4, 2, 2, 2, 3, 2, 4, 8, 3, 3, 2, 2, 3, 2, 3, 6, 3, 3, 2, 2, 2, 2, 3, 3, 3, 6, 2, 3, 6, 3, 2, 3, 4, 2, 7, 2, 6, 4, 2, 3, 5, 4, 3, 3, 2, 5, 18, 2, 2, 3, 2, 2, 3, 4, 4, 2, 1, 5, 4, 5, 17, 4, 5, 4, 4, 3, 2, 3, 4, 3, 6, 2, 2, 2, 5, 2, 3, 10, 6, 3, 1, 2, 35, 2, 3, 2, 8, 17, 6, 2, 3, 5, 3, 2, 1, 2, 4, 2, 9, 4, 4, 2, 3, 5, 2, 2, 1, 3, 1, 3, 2, 5, 5, 5, 2, 2, 6, 4, 2, 3, 3, 2, 4, 3, 7, 5, 4, 7, 44, 15, 1, 3, 10, 2, 3, 3, 2, 2, 6, 3, 2, 2, 2, 4}},
    {"th", {6, 3, 3, 4, 2, 4, 2, 4, 4, 4, 10, 2, 4, 2, 4, 4, 2, 17, 2, 2, 2, 3, 3, 4, 3, 2, 4, 2, 8, 2, 3, 2, 3, 3, 2, 14, 2, 11, 4, 6, 2, 2, 4, 3, 3, 2, 3, 2, 3, 4, 3, 4, 3, 5, 2, 3, 25, 2, 4, 2, 3, 2, 2, 5, 3, 3, 3, 3, 2, 8, 6, 3, 2, 2, 3, 10, 2, 2, 3, 2, 3, 2, 3, 3, 2, 4, 3, 4, 3, 4, 2, 5, 5, 2, 2, 3, 2, 2, 3, 3, 2, 15, 3, 5, 3, 10, 2, 3, 2, 2, 3, 2, 3, 11, 2, 6, 4, 7, 2, 4, 3, 4, 2, 3, 4, 3, 4, 4, 4, 3, 3, 4, 3, 2, 3, 3, 2, 2, 3, 2, 3, 3, 6, 2, 4, 3, 3, 3, 2, 3, 2, 22, 3, 2, 4, 3, 4, 2, 6, 2, 3, 4, 4, 2, 2, 3, 2, 2, 2, 3, 5, 4, 4, 2, 5, 3, 2, 11, 3, 3, 3, 3, 3, 4, 5, 3, 3, 5, 8, 3, 5, 2, 9, 19, 4, 2, 4, 10, 2, 4, 5, 9, 3, 4, 4, 2, 2, 4, 3, 3, 3, 3, 3, 4, 2, 4, 2, 2, 5, 2, 9, 2, 3, 4, 3, 3, 2, 3, 2, 4, 2, 8, 2, 2, 2, 2, 3, 3, 18, 2, 19, 3, 4, 4, 8, 3, 2, 3, 3, 3, 4, 3, 15, 2, 3, 2}},
    {"ca", {5, 2, 3, 4, 7, 41, 6, 3, 2, 2, 5, 3, 2, 4, 3, 5, 2, 1, 5, 3, 5, 2, 2, 5, 2, 2, 2, 3, 1, 1, 5, 3, 7, 3, 3, 1, 3, 5, 2, 2, 4, 4, 1, 2, 10, 2, 2, 4, 2, 3, 2, 2, 1, 5, 2, 3, 2, 5, 18, 1, 5, 5, 3, 4, 2, 4, 2, 1, 2, 2, 2, 4, 2, 3, 3, 2, 2, 2, 2, 2, 3, 3, 17, 4, 2, 3, 2, 19, 1, 1, 3, 3, 2, 5, 5, 4, 6, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 2, 9, 2, 1, 5, 4, 3, 2, 2, 1, 3, 5, 5, 2, 12, 3, 1, 2, 2, 12, 4, 2, 3, 2, 2, 3, 2, 3, 2, 3, 4, 3, 3, 5, 3, 2, 3, 4, 2, 4, 2, 5, 4, 2, 2, 10, 2, 3, 2, 1, 6, 16, 3, 2, 3, 3, 3, 3, 3, 2, 2, 2, 7, 2, 6, 18, 6, 3, 4, 6, 4, 1, 2, 2, 2, 4, 2, 1, 2, 5, 1, 3, 8, 4, 3, 1, 2, 28, 2, 3, 2, 9, 23, 4, 2, 2, 5, 3, 5, 2, 3, 2, 2, 3, 6, 4, 2, 5, 9, 1, 2, 3, 3, 1, 4, 2, 2, 2, 4, 6, 1, 7, 4, 2, 4, 3, 2, 3, 2, 5, 2, 4, 6, 48, 17, 2, 3, 7, 1, 3, 2, 2, 1, 4, 4, 2, 2, 3, 5}},
    {"bn", {5, 2, 3, 2, 3, 3, 4, 13, 2, 2, 1, 2, 2, 2, 15, 2, 10, 3, 2, 4, 5, 2, 2, 15, 2, 2, 2, 2, 8, 3, 2, 1, 3, 2, 3, 2, 2, 2, 3, 21, 5, 3, 3, 3, 3, 6, 2, 3, 18, 4, 2, 2, 2, 2, 3, 5, 4, 2, 4, 3, 7, 4, 2, 5, 3, 3, 3, 3, 2, 4, 4, 3, 3, 4, 1, 2, 3, 6, 11, 7, 2, 4, 3, 3, 2, 4, 3, 2, 3, 3, 3, 3, 3, 2, 5, 1, 3, 3, 2, 3, 1, 5, 2, 4, 3, 4, 7, 6, 3, 2, 7, 2, 2, 1, 3, 4, 6, 4, 2, 4, 3, 2, 4, 2, 15, 3, 3, 2, 2, 2, 4, 5, 5, 5, 2, 3, 3, 16, 6, 10, 2, 2, 2, 2, 2, 2, 6, 6, 2, 4, 2, 2, 2, 2, 4, 32, 2, 2, 2, 2, 5, 2, 3, 2, 3, 2, 3, 2, 2, 2, 3, 3, 3, 3, 2, 2, 5, 3, 7, 4, 2, 3, 5, 3, 7, 3, 2, 6, 2, 3, 2, 4, 2, 3, 2, 2, 2, 2, 3, 4, 3, 3, 3, 2, 2, 2, 2, 2, 6, 2, 2, 2, 2, 11, 3, 5, 2, 4, 7, 3, 4, 2, 2, 4, 2, 5, 15, 3, 2, 3, 2, 2, 3, 3, 16, 2, 3, 3, 16, 3, 61, 4, 2, 4, 3, 7, 4, 2, 3, 2, 3, 4, 2, 4, 4, 2}},
    {"el", {4, 3, 3, 9, 2, 3, 5, 5, 3, 2, 3, 4, 2, 1, 2, 2, 2, 2, 3, 6, 6, 3, 4, 3, 3, 5, 2, 12, 2, 2, 9, 1, 5, 2, 2, 4, 7, 2, 3, 2, 23, 3, 3, 6, 3, 3, 2, 3, 3, 4, 3, 2, 4, 2, 4, 4, 3, 2, 16, 2, 6, 5, 2, 5, 2, 2, 3, 2, 3, 2, 7, 5, 2, 15, 1, 2, 6, 4, 1, 2, 3, 3, 3, 3, 3, 3, 4, 2, 2, 4, 2, 7, 2, 4, 4, 6, 5, 2, 2, 2, 4, 2, 13, 2, 3, 3, 3, 3, 12, 2, 2, 4, 3, 2, 8, 1, 21, 3, 3, 3, 2, 2, 2, 3, 7, 2, 2, 5, 2, 3, 2, 6, 2, 4, 3, 2, 5, 2, 2, 3, 12, 4, 4, 2, 2, 2, 1, 3, 3, 3, 2, 2, 2, 3, 7, 4, 2, 3, 14, 2, 4, 3, 3, 2, 2, 3, 3, 2, 3, 7, 2, 2, 3, 3, 2, 5, 4, 15, 3, 5, 3, 2, 3, 2, 5, 5, 10, 2, 2, 2, 8, 2, 11, 2, 5, 3, 3, 3, 2, 5, 3, 2, 3, 3, 2, 1, 3, 6, 3, 2, 3, 3, 2, 4, 2, 4, 3, 2, 9, 2, 5, 4, 5, 2, 2, 3, 7, 7, 2, 7, 4, 2, 2, 3, 2, 8, 20, 2, 3, 2, 42, 2, 2, 4, 4, 3, 3, 3, 2, 2, 3, 2, 3, 2, 4, 2}},
    {"bg", {6, 19, 2, 3, 3, 3, 2, 3, 5, 17, 2, 4, 2, 2, 2, 2, 2, 3, 3, 1, 2, 2, 2, 4, 1, 3, 4, 2, 6, 3, 2, 2, 1, 2, 2, 2, 3, 3, 6, 3, 3, 2, 17, 2, 3, 5, 22, 4, 3, 3, 1, 2, 3, 8, 7, 3, 4, 3, 2, 6, 2, 3, 3, 10, 3, 5, 2, 6, 3, 3, 2, 22, 4, 2, 3, 3, 2, 3, 2, 4, 2, 3, 4, 2, 4, 2, 7, 4, 4, 3, 2, 2, 2, 4, 4, 6, 2, 2, 3, 1, 4, 7, 14, 3, 7, 2, 2, 3, 4, 4, 2, 2, 4, 2, 4, 3, 3, 2, 4, 3, 3, 3, 3, 1, 4, 5, 3, 2, 4, 3, 2, 2, 19, 5, 1, 2, 1, 2, 17, 2, 7, 2, 2, 1, 6, 2, 2, 4, 2, 3, 3, 6, 2, 6, 3, 5, 3, 2, 4, 2, 3, 14, 6, 5, 2, 3, 1, 4, 16, 2, 2, 2, 2, 2, 2, 2, 10, 4, 3, 4, 3, 4, 2, 3, 2, 3, 4, 5, 3, 2, 1, 3, 6, 3, 3, 3, 4, 1, 2, 2, 9, 1, 3, 7, 2, 2, 1, 2, 3, 2, 3, 5, 2, 3, 4, 2, 2, 2, 3, 5, 2, 3, 6, 3, 1, 2, 3, 2, 5, 2, 2, 5, 3, 5, 10, 3, 3, 3, 2, 2, 45, 3, 3, 40, 2, 5, 3, 2, 2, 3, 3, 2, 3, 3, 2, 3}},
    {"sr", {5, 15, 3, 2, 3, 8, 3, 3, 3, 13, 4, 3, 2, 2, 2, 3, 3, 2, 2, 2, 2, 3, 2, 5, 2, 3, 3, 3, 6, 2, 2, 2, 2, 2, 2, 2, 3, 4, 4, 4, 3, 2, 10, 2, 3, 4, 21, 6, 3, 3, 1, 3, 3, 8, 4, 6, 2, 3, 4, 2, 3, 4, 2, 7, 4, 3, 2, 6, 3, 3, 3, 22, 3, 2, 2, 3, 2, 2, 2, 4, 2, 6, 5, 3, 4, 2, 5, 6, 7, 3, 1, 4, 3, 2, 4, 13, 3, 2, 2, 2, 3, 9, 12, 2, 7, 4, 2, 5, 3, 3, 3, 3, 2, 2, 3, 3, 2, 2, 3, 3, 3, 3, 3, 2, 4, 4, 3, 4, 3, 2, 2, 2, 18, 5, 2, 2, 2, 3, 11, 2, 6, 2, 2, 2, 6, 2, 3, 5, 3, 3, 3, 4, 3, 8, 3, 4, 3, 3, 5, 2, 2, 7, 5, 4, 3, 2, 3, 3, 16, 3, 3, 2, 5, 2, 2, 2, 8, 2, 3, 4, 3, 4, 2, 2, 3, 2, 5, 5, 3, 3, 2, 3, 5, 3, 6, 3, 4, 1, 2, 3, 7, 2, 3, 7, 4, 2, 3, 3, 3, 2, 4, 2, 3, 3, 4, 3, 1, 3, 3, 3, 2, 4, 4, 3, 2, 2, 2, 2, 6, 3, 2, 4, 2, 4, 8, 3, 3, 3, 2, 2, 44, 4, 3, 35, 3, 11, 4, 2, 3, 4, 3, 2, 2, 4, 2, 3}},
    {"hr", {3, 2, 2, 3, 3, 42, 6, 4, 3, 2, 3, 2, 2, 2, 2, 5, 2, 3, 4, 3, 6, 2, 4, 5, 2, 3, 1, 5, 2, 2, 2, 2, 6, 2, 2, 2, 2, 3, 2, 2, 2, 2, 5, 2, 11, 2, 3, 8, 1, 5, 2, 2, 2, 4, 2, 2, 2, 7, 12, 2, 4, 4, 3, 4, 4, 3, 3, 2, 1, 1, 3, 13, 3, 2, 2, 3, 2, 2, 6, 3, 2, 4, 13, 3, 3, 3, 2, 16, 4, 2, 2, 3, 4, 3, 4, 4, 6, 2, 2, 2, 2, 2, 3, 3, 2, 3, 4, 3, 4, 2, 3, 5, 3, 3, 3, 2, 2, 2, 2, 2, 4, 10, 2, 2, 4, 2, 5, 5, 2, 1, 2, 3, 2, 2, 4, 4, 3, 9, 3, 3, 5, 3, 2, 1, 3, 2, 6, 3, 4, 7, 2, 3, 3, 3, 3, 3, 2, 5, 15, 2, 2, 3, 3, 3, 4, 3, 5, 2, 1, 9, 2, 3, 28, 4, 4, 3, 3, 4, 2, 3, 2, 3, 4, 1, 3, 4, 5, 8, 4, 6, 2, 3, 2, 2, 23, 3, 3, 1, 6, 12, 5, 2, 3, 7, 3, 3, 3, 3, 4, 2, 10, 5, 3, 1, 3, 4, 2, 1, 2, 3, 2, 3, 2, 3, 2, 4, 2, 1, 6, 3, 2, 5, 2, 2, 3, 2, 2, 4, 4, 3, 42, 23, 2, 4, 12, 2, 4, 2, 2, 2, 3, 8, 2, 2, 5, 5}},
    {"az", {4, 3, 2, 3, 4, 41, 5, 2, 10, 2, 6, 3, 2, 3, 3, 8, 3, 2, 3, 3, 6, 2, 2, 5, 3, 3, 3, 2, 3, 3, 5, 4, 3, 2, 2, 3, 4, 3, 2, 2, 2, 2, 2, 2, 7, 2, 3, 5, 3, 3, 3, 2, 2, 9, 2, 2, 3, 7, 19, 9, 3, 3, 3, 4, 4, 4, 6, 3, 2, 2, 3, 5, 4, 3, 3, 3, 3, 3, 2, 3, 3, 5, 18, 4, 3, 3, 2, 21, 2, 4, 2, 3, 2, 8, 3, 2, 7, 1, 2, 2, 2, 3, 3, 3, 2, 2, 3, 1, 3, 2, 3, 6, 2, 2, 2, 2, 3, 2, 3, 6, 3, 6, 4, 2, 4, 2, 5, 5, 3, 2, 1, 2, 2, 3, 2, 3, 4, 5, 3, 2, 3, 2, 2, 4, 3, 3, 3, 1, 5, 5, 3, 3, 3, 3, 4, 3, 1, 7, 11, 3, 3, 3, 2, 2, 4, 4, 3, 2, 2, 4, 2, 3, 9, 5, 7, 2, 3, 2, 3, 2, 3, 2, 3, 2, 2, 2, 10, 2, 4, 5, 3, 4, 2, 1, 7, 3, 3, 3, 7, 11, 7, 1, 2, 4, 2, 2, 3, 4, 3, 2, 8, 3, 4, 2, 21, 6, 2, 2, 3, 2, 7, 3, 3, 3, 4, 6, 2, 2, 9, 3, 5, 5, 6, 2, 2, 2, 4, 4, 5, 2, 38, 24, 2, 3, 3, 2, 2, 3, 3, 4, 3, 4, 2, 2, 5, 4}},
    {"sk", {5, 2, 2, 3, 3, 36, 5, 3, 2, 2, 4, 3, 2, 3, 2, 5, 2, 2, 3, 3, 5, 3, 5, 3, 3, 2, 1, 6, 3, 2, 2, 4, 3, 2, 4, 3, 3, 4, 3, 2, 4, 2, 2, 2, 8, 3, 2, 7, 2, 4, 2, 2, 2, 3, 2, 2, 2, 5, 12, 2, 3, 3, 4, 5, 4, 3, 3, 2, 2, 2, 3, 6, 2, 2, 3, 3, 2, 2, 3, 2, 3, 3, 14, 3, 3, 3, 3, 19, 3, 2, 2, 3, 4, 3, 3, 2, 10, 4, 2, 3, 2, 2, 3, 3, 2, 3, 2, 2, 5, 3, 2, 6, 2, 3, 2, 2, 2, 2, 4, 2, 3, 9, 2, 2, 2, 2, 8, 4, 3, 2, 2, 3, 3, 2, 3, 4, 2, 12, 2, 4, 3, 3, 3, 2, 4, 3, 4, 4, 3, 5, 2, 3, 4, 3, 3, 3, 2, 5, 14, 3, 2, 3, 2, 2, 4, 3, 5, 4, 2, 8, 3, 4, 29, 4, 4, 3, 3, 4, 2, 3, 2, 3, 3, 2, 2, 3, 8, 4, 4, 6, 3, 2, 2, 3, 21, 3, 3, 4, 5, 12, 6, 2, 3, 6, 3, 5, 4, 2, 4, 5, 11, 4, 3, 1, 3, 4, 2, 2, 3, 4, 2, 2, 2, 2, 2, 4, 2, 2, 5, 6, 2, 4, 2, 2, 3, 2, 3, 5, 3, 3, 42, 14, 2, 7, 9, 2, 3, 2, 2, 2, 3, 9, 3, 2, 6, 3}},
    {"sl", {5, 2, 2, 3, 3, 41, 7, 4, 3, 2, 3, 2, 1, 2, 2, 5, 2, 2, 4, 3, 6, 2, 5, 4, 2, 3, 1, 5, 2, 2, 2, 2, 6, 2, 3, 4, 2, 4, 2, 2, 2, 1, 4, 3, 7, 3, 2, 6, 2, 5, 3, 2, 2, 4, 2, 3, 2, 7, 15, 2, 4, 4, 3, 4, 4, 3, 3, 2, 1, 2, 2, 12, 2, 2, 4, 2, 2, 2, 6, 2, 3, 4, 13, 3, 3, 4, 2, 17, 3, 2, 2, 3, 4, 3, 4, 3, 7, 3, 2, 3, 2, 2, 2, 3, 2, 4, 3, 2, 5, 2, 3, 4, 3, 3, 2, 2, 1, 2, 2, 2, 4, 9, 2, 2, 5, 2, 5, 5, 3, 1, 2, 4, 2, 2, 3, 3, 3, 11, 2, 3, 5, 3, 3, 2, 2, 2, 5, 4, 5, 7, 2, 3, 4, 4, 3, 2, 2, 4, 15, 2, 1, 3, 2, 3, 4, 3, 4, 2, 1, 9, 2, 3, 29, 3, 4, 3, 3, 4, 2, 3, 1, 3, 4, 2, 3, 4, 5, 6, 4, 5, 2, 3, 2, 3, 27, 3, 4, 1, 6, 12, 6, 2, 3, 7, 3, 3, 3, 4, 4, 2, 10, 5, 3, 1, 3, 5, 2, 2, 2, 3, 2, 2, 2, 3, 1, 4, 2, 1, 6, 5, 1, 4, 2, 2, 3, 1, 2, 4, 5, 3, 43, 21, 2, 3, 12, 2, 3, 2, 3, 2, 4, 11, 2, 2, 6, 4}},
    {"ta", {2, 17, 2, 2, 3, 3, 1, 4, 4, 26, 2, 3, 5, 4, 3, 3, 1, 2, 2, 2, 2, 2, 19, 4, 2, 11, 2, 2, 9, 3, 5, 3, 3, 3, 3, 2, 4, 4, 3, 3, 1, 2, 2, 4, 3, 3, 2, 3, 6, 2, 3, 2, 2, 4, 2, 5, 2, 2, 13, 2, 2, 4, 2, 3, 4, 4, 2, 1, 11, 2, 5, 2, 2, 3, 3, 8, 4, 2, 2, 3, 7, 3, 3, 3, 7, 3, 4, 2, 2, 2, 12, 4, 2, 2, 3, 2, 2, 3, 6, 3, 4, 8, 3, 3, 3, 5, 4, 5, 1, 19, 1, 32, 6, 2, 3, 3, 3, 4, 2, 3, 2, 2, 2, 2, 3, 3, 5, 2, 5, 2, 12, 2, 2, 4, 2, 4, 14, 4, 2, 4, 5, 3, 3, 1, 4, 3, 3, 3, 2, 2, 2, 1, 2, 3, 3, 2, 3, 2, 2, 2, 4, 3, 5, 2, 2, 2, 2, 3, 4, 3, 2, 3, 4, 2, 2, 3, 7, 2, 2, 4, 2, 4, 2, 3, 3, 3, 2, 17, 3, 4, 3, 2, 2, 3, 4, 2, 2, 2, 2, 2, 12, 2, 3, 2, 2, 2, 3, 4, 6, 3, 2, 2, 3, 3, 3, 4, 6, 2, 3, 7, 8, 3, 4, 3, 2, 3, 5, 2, 6, 6, 2, 3, 3, 4, 3, 4, 3, 2, 2, 2, 53, 2, 10, 2, 1, 17, 1, 6, 4, 3, 2, 2, 2, 2, 8, 4}},
    {"eo", {3, 3, 3, 2, 4, 44, 6, 4, 2, 2, 3, 2, 2, 4, 3, 3, 2, 1, 4, 2, 9, 3, 1, 8, 2, 2, 2, 4, 2, 2, 3, 5, 8, 3, 2, 1, 2, 3, 2, 4, 2, 2, 4, 1, 12, 3, 3, 5, 2, 3, 2, 1, 1, 7, 2, 2, 2, 3, 16, 2, 7, 4, 2, 4, 5, 6, 2, 1, 2, 2, 3, 9, 3, 3, 4, 2, 2, 4, 2, 2, 2, 2, 15, 4, 3, 5, 2, 16, 3, 3, 2, 2, 2, 2, 5, 2, 6, 1, 1, 4, 1, 2, 3, 3, 2, 4, 2, 2, 8, 2, 2, 4, 3, 3, 2, 3, 2, 2, 4, 2, 3, 11, 2, 1, 2, 2, 5, 4, 2, 2, 2, 2, 2, 2, 2, 6, 2, 4, 2, 4, 5, 4, 3, 3, 3, 2, 5, 2, 6, 5, 3, 3, 6, 2, 7, 2, 2, 3, 16, 3, 2, 3, 3, 3, 4, 2, 5, 2, 1, 6, 3, 6, 28, 6, 4, 2, 5, 5, 2, 2, 2, 3, 2, 2, 2, 2, 5, 1, 5, 6, 4, 1, 2, 2, 22, 2, 2, 1, 7, 17, 3, 2, 2, 7, 4, 4, 2, 3, 2, 3, 11, 9, 2, 2, 4, 5, 2, 1, 2, 2, 2, 2, 3, 2, 3, 4, 1, 1, 7, 4, 2, 3, 3, 2, 3, 2, 2, 3, 3, 5, 44, 20, 2, 4, 7, 1, 3, 2, 1, 2, 3, 12, 2, 2, 4, 6}},
    {"lt", {4, 3, 2, 3, 4, 37, 4, 3, 2, 3, 4, 2, 4, 2, 3, 5, 2, 3, 4, 4, 5, 2, 3, 3, 2, 2, 3, 3, 2, 2, 2, 6, 7, 2, 2, 2, 4, 3, 3, 5, 2, 2, 3, 2, 12, 3, 2, 6, 5, 4, 2, 5, 2, 4, 3, 2, 1, 5, 11, 2, 7, 3, 2, 5, 5, 2, 3, 2, 2, 2, 3, 8, 8, 3, 2, 3, 3, 5, 3, 3, 2, 3, 14, 2, 3, 3, 2, 16, 2, 1, 3, 3, 3, 3, 5, 2, 5, 2, 2, 2, 2, 2, 3, 4, 6, 3, 4, 3, 4, 2, 3, 6, 4, 2, 3, 2, 2, 2, 4, 3, 4, 5, 3, 1, 2, 3, 3, 4, 2, 2, 3, 3, 2, 3, 2, 2, 2, 7, 4, 3, 4, 4, 3, 1, 3, 3, 7, 2, 4, 4, 2, 3, 12, 2, 4, 3, 2, 6, 16, 2, 3, 3, 4, 1, 4, 2, 3, 2, 2, 7, 2, 3, 24, 6, 3, 2, 4, 3, 3, 2, 3, 3, 5, 2, 2, 4, 10, 3, 5, 4, 2, 2, 2, 2, 15, 3, 2, 2, 4, 20, 5, 2, 2, 5, 3, 4, 2, 3, 3, 2, 12, 5, 3, 3, 6, 3, 2, 2, 2, 3, 3, 3, 1, 3, 2, 5, 2, 2, 8, 3, 2, 4, 2, 4, 3, 2, 3, 3, 5, 4, 40, 29, 2, 2, 5, 2, 4, 3, 2, 2, 2, 9, 2, 2, 3, 5}},
    {"et", {4, 2, 2, 3, 5, 41, 8, 3, 4, 2, 2, 2, 2, 2, 2, 4, 2, 2, 5, 3, 5, 3, 2, 4, 2, 3, 2, 2, 3, 1, 1, 3, 7, 2, 2, 1, 3, 3, 2, 3, 3, 1, 3, 3, 15, 3, 3, 5, 3, 5, 2, 4, 1, 4, 2, 3, 2, 6, 17, 3, 3, 4, 4, 4, 6, 2, 3, 3, 2, 2, 3, 6, 3, 3, 2, 3, 3, 2, 2, 2, 2, 3, 12, 2, 2, 3, 2, 18, 3, 1, 2, 3, 3, 3, 5, 2, 10, 2, 1, 3, 2, 2, 3, 3, 3, 2, 4, 2, 5, 3, 4, 6, 2, 3, 4, 1, 2, 2, 4, 2, 3, 8, 2, 2, 3, 3, 3, 6, 3, 1, 1, 4, 3, 2, 2, 5, 2, 7, 3, 2, 6, 3, 3, 2, 3, 3, 4, 2, 5, 3, 2, 2, 7, 3, 7, 2, 2, 5, 19, 2, 2, 3, 3, 2, 5, 3, 6, 2, 2, 9, 3, 3, 16, 5, 3, 5, 4, 4, 2, 3, 3, 4, 4, 2, 3, 3, 3, 2, 4, 4, 2, 2, 2, 2, 25, 3, 3, 2, 3, 22, 5, 2, 2, 4, 2, 3, 2, 3, 5, 3, 12, 5, 5, 2, 5, 5, 2, 2, 2, 2, 2, 2, 2, 4, 3, 4, 5, 2, 6, 5, 2, 4, 3, 2, 2, 2, 5, 3, 4, 3, 36, 24, 2, 2, 7, 2, 4, 2, 3, 2, 5, 4, 2, 3, 2, 7}},
    {"ml", {7, 3, 8, 2, 2, 2, 2, 3, 8, 2, 2, 1, 3, 4, 4, 3, 2, 5, 2, 4, 2, 13, 2, 3, 2, 5, 3, 5, 2, 2, 3, 3, 2, 19, 5, 2, 4, 4, 4, 2, 5, 12, 2, 2, 12, 2, 3, 2, 4, 2, 25, 3, 5, 2, 2, 2, 3, 2, 3, 2, 2, 4, 4, 5, 2, 2, 3, 3, 4, 2, 4, 2, 4, 4, 2, 3, 6, 2, 2, 2, 3, 3, 5, 2, 3, 3, 6, 2, 2, 2, 3, 3, 3, 3, 6, 2, 2, 2, 2, 2, 5, 3, 3, 3, 6, 2, 2, 4, 5, 3, 3, 2, 2, 7, 3, 2, 4, 2, 10, 3, 3, 13, 3, 3, 7, 4, 19, 5, 2, 4, 4, 3, 2, 3, 3, 23, 5, 2, 7, 3, 3, 4, 3, 2, 5, 3, 6, 2, 2, 2, 2, 2, 3, 4, 10, 2, 2, 3, 19, 2, 3, 3, 5, 2, 2, 5, 5, 5, 3, 3, 2, 3, 3, 3, 7, 2, 3, 2, 2, 3, 4, 4, 3, 4, 2, 2, 4, 4, 3, 2, 3, 2, 2, 7, 2, 3, 7, 2, 2, 2, 2, 3, 2, 2, 2, 3, 2, 1, 14, 3, 5, 7, 3, 8, 2, 3, 3, 2, 5, 7, 3, 3, 2, 2, 3, 11, 2, 2, 6, 2, 2, 2, 6, 2, 4, 3, 3, 4, 1, 2, 44, 2, 5, 3, 2, 2, 3, 2, 4, 10, 4, 4, 2, 2, 2, 2}},
    {"la", {2, 3, 2, 4, 4, 38, 4, 2, 1, 2, 4, 3, 2, 3, 2, 9, 2, 3, 3, 3, 6, 2, 4, 5, 1, 2, 2, 3, 2, 1, 4, 6, 5, 2, 2, 2, 2, 3, 4, 3, 2, 2, 2, 2, 16, 3, 1, 4, 2, 2, 3, 2, 1, 3, 5, 2, 2, 4, 13, 1, 3, 4, 2, 4, 2, 4, 4, 2, 3, 2, 2, 3, 4, 3, 3, 3, 3, 3, 2, 2, 3, 2, 16, 2, 3, 3, 2, 19, 2, 2, 2, 2, 3, 4, 6, 2, 7, 2, 1, 3, 2, 2, 3, 5, 3, 3, 3, 2, 5, 2, 2, 5, 3, 2, 2, 1, 2, 2, 5, 4, 2, 6, 3, 1, 4, 2, 11, 4, 3, 2, 2, 3, 2, 1, 2, 3, 3, 4, 3, 3, 5, 3, 3, 2, 4, 2, 5, 2, 7, 5, 2, 2, 10, 2, 6, 2, 2, 7, 21, 2, 1, 3, 3, 3, 3, 4, 2, 2, 2, 5, 3, 5, 20, 6, 3, 3, 2, 4, 2, 2, 2, 5, 3, 2, 1, 2, 6, 1, 5, 7, 3, 2, 2, 2, 24, 2, 3, 2, 6, 18, 5, 2, 2, 4, 3, 5, 1, 2, 3, 3, 2, 3, 5, 3, 6, 6, 2, 1, 3, 3, 3, 4, 2, 5, 2, 5, 3, 2, 9, 3, 2, 5, 2, 2, 3, 2, 6, 2, 5, 4, 38, 26, 2, 2, 7, 2, 3, 2, 1, 2, 3, 6, 2, 3, 2, 8}},
    {"af", {5, 3, 5, 2, 4, 36, 7, 2, 4, 5, 6, 2, 2, 2, 1, 3, 3, 2, 3, 2, 8, 2, 2, 4, 1, 2, 2, 2, 2, 2, 2, 9, 12, 2, 2, 3, 3, 3, 3, 4, 2, 2, 2, 2, 6, 2, 2, 11, 2, 3, 1, 5, 2, 9, 2, 2, 2, 2, 15, 1, 3, 2, 3, 3, 3, 2, 3, 3, 2, 2, 2, 6, 2, 3, 3, 2, 3, 2, 4, 2, 4, 2, 17, 3, 2, 4, 1, 18, 3, 2, 1, 4, 2, 2, 3, 3, 8, 2, 1, 3, 2, 1, 1, 4, 4, 2, 2, 2, 6, 1, 2, 5, 3, 2, 2, 1, 3, 3, 4, 5, 3, 3, 3, 2, 4, 2, 3, 3, 2, 1, 1, 2, 2, 2, 3, 4, 2, 6, 4, 4, 6, 3, 1, 2, 3, 3, 4, 2, 5, 4, 2, 3, 7, 3, 5, 3, 1, 5, 15, 4, 2, 3, 2, 3, 2, 3, 4, 1, 2, 5, 2, 5, 18, 6, 4, 3, 5, 5, 1, 3, 5, 2, 4, 2, 2, 3, 4, 2, 3, 8, 3, 3, 1, 2, 38, 3, 3, 2, 8, 16, 5, 2, 2, 4, 2, 2, 2, 2, 4, 2, 8, 4, 3, 2, 4, 4, 2, 1, 2, 3, 2, 2, 2, 4, 4, 6, 2, 1, 7, 4, 2, 3, 3, 3, 3, 2, 7, 5, 4, 5, 46, 19, 2, 3, 15, 1, 3, 2, 2, 1, 4, 3, 4, 2, 6, 5}},
    {"mr", {2, 3, 2, 4, 4, 3, 5, 2, 2, 2, 3, 2, 2, 4, 3, 2, 3, 3, 2, 4, 2, 2, 3, 3, 6, 3, 4, 4, 4, 3, 2, 1, 4, 3, 4, 2, 3, 1, 2, 2, 3, 3, 2, 2, 4, 3, 3, 2, 4, 2, 18, 15, 3, 4, 3, 2, 7, 2, 3, 2, 11, 5, 3, 4, 4, 2, 2, 3, 5, 5, 8, 2, 3, 10, 2, 3, 2, 3, 2, 2, 6, 5, 6, 3, 4, 13, 12, 4, 2, 2, 4, 2, 4, 3, 3, 4, 3, 4, 2, 2, 3, 6, 15, 4, 3, 3, 6, 2, 3, 18, 2, 3, 2, 3, 4, 4, 8, 3, 3, 3, 4, 2, 4, 2, 3, 5, 4, 2, 3, 3, 1, 2, 3, 2, 6, 2, 2, 2, 2, 2, 3, 2, 6, 7, 8, 2, 4, 1, 3, 3, 3, 2, 2, 7, 3, 2, 11, 2, 4, 5, 2, 6, 2, 3, 6, 13, 2, 4, 4, 3, 3, 2, 11, 2, 8, 2, 3, 4, 2, 3, 3, 9, 2, 2, 6, 2, 4, 4, 4, 3, 2, 2, 5, 3, 5, 3, 3, 4, 2, 3, 3, 2, 7, 6, 3, 16, 3, 3, 6, 1, 22, 4, 2, 2, 2, 6, 5, 2, 3, 2, 2, 4, 3, 4, 3, 3, 2, 4, 2, 4, 1, 3, 2, 2, 2, 2, 2, 2, 2, 3, 59, 3, 6, 5, 3, 2, 2, 2, 2, 2, 3, 2, 7, 3, 10, 3}},
    {"sq", {3, 3, 2, 3, 3, 49, 3, 2, 2, 2, 3, 3, 4, 3, 3, 5, 2, 2, 3, 3, 4, 4, 2, 3, 3, 3, 1, 3, 2, 4, 3, 2, 10, 2, 2, 3, 1, 3, 3, 2, 1, 2, 5, 4, 9, 3, 2, 3, 2, 3, 2, 4, 2, 5, 1, 2, 3, 6, 9, 2, 4, 3, 3, 3, 7, 2, 4, 2, 2, 2, 2, 8, 4, 2, 2, 4, 6, 3, 2, 12, 2, 7, 17, 3, 2, 8, 2, 19, 2, 2, 2, 2, 3, 2, 4, 3, 13, 2, 1, 3, 3, 2, 3, 4, 2, 3, 2, 2, 5, 2, 3, 6, 2, 3, 3, 2, 1, 4, 4, 6, 3, 5, 2, 2, 2, 2, 4, 7, 2, 2, 2, 2, 2, 2, 2, 4, 2, 5, 3, 2, 6, 4, 3, 3, 2, 2, 4, 2, 6, 2, 2, 3, 4, 2, 4, 2, 2, 4, 21, 3, 2, 3, 2, 1, 4, 2, 3, 3, 2, 9, 4, 5, 16, 4, 4, 2, 3, 2, 3, 2, 3, 4, 2, 3, 2, 2, 5, 4, 5, 7, 3, 4, 1, 3, 23, 2, 3, 2, 6, 14, 3, 2, 2, 6, 3, 3, 2, 2, 4, 2, 9, 5, 4, 3, 3, 5, 1, 1, 2, 2, 2, 3, 2, 2, 2, 4, 3, 2, 8, 3, 2, 4, 2, 1, 2, 2, 5, 3, 3, 3, 46, 19, 1, 2, 15, 2, 2, 3, 3, 2, 3, 3, 2, 2, 4, 5}},
    {"ur", {3, 2, 6, 2, 2, 7, 2, 3, 2, 2, 3, 4, 2, 3, 4, 5, 11, 2, 2, 4, 3, 1, 2, 2, 2, 14, 3, 2, 4, 1, 2, 6, 4, 1, 3, 2, 22, 7, 1, 2, 3, 14, 2, 4, 3, 5, 2, 9, 3, 3, 2, 2, 2, 2, 2, 3, 4, 4, 3, 3, 2, 5, 3, 11, 2, 3, 3, 4, 11, 4, 6, 3, 9, 4, 13, 12, 7, 3, 2, 2, 8, 3, 2, 3, 4, 2, 3, 3, 4, 2, 2, 2, 2, 2, 4, 5, 2, 8, 3, 4, 4, 2, 2, 2, 4, 2, 5, 2, 3, 2, 2, 11, 5, 2, 3, 3, 2, 2, 2, 4, 5, 4, 3, 3, 1, 2, 3, 2, 3, 2, 4, 3, 4, 3, 6, 1, 2, 1, 2, 3, 3, 5, 2, 5, 1, 1, 3, 3, 4, 3, 4, 3, 3, 3, 2, 3, 2, 16, 3, 2, 4, 4, 27, 2, 6, 2, 1, 3, 2, 2, 3, 5, 3, 7, 2, 16, 3, 2, 2, 3, 4, 2, 2, 4, 3, 5, 3, 2, 4, 10, 2, 5, 3, 2, 2, 1, 10, 6, 12, 3, 2, 3, 1, 2, 6, 2, 2, 3, 3, 2, 2, 1, 2, 4, 2, 4, 4, 5, 3, 1, 5, 3, 2, 10, 3, 4, 2, 3, 2, 5, 2, 3, 2, 2, 3, 3, 3, 2, 2, 4, 58, 3, 2, 5, 3, 1, 12, 2, 3, 2, 2, 5, 2, 3, 2, 13}},
    {"ka", {3, 2, 2, 1, 2, 11, 3, 2, 2, 2, 7, 2, 3, 2, 18, 2, 2, 3, 2, 2, 3, 3, 2, 32, 2, 3, 3, 2, 14, 4, 3, 2, 9, 4, 2, 3, 3, 3, 4, 4, 2, 2, 2, 1, 4, 6, 7, 1, 3, 2, 2, 3, 1, 4, 4, 7, 3, 4, 4, 1, 4, 3, 3, 5, 2, 3, 4, 3, 4, 17, 2, 2, 1, 4, 4, 3, 3, 3, 5, 2, 3, 7, 4, 2, 3, 6, 5, 2, 6, 6, 3, 2, 2, 3, 2, 2, 3, 2, 7, 9, 3, 3, 2, 6, 2, 2, 10, 4, 2, 3, 2, 1, 4, 3, 3, 4, 4, 1, 3, 3, 9, 3, 3, 3, 1, 2, 2, 5, 2, 3, 3, 46, 2, 2, 2, 2, 3, 2, 4, 5, 2, 3, 4, 5, 3, 1, 2, 2, 3, 4, 2, 2, 2, 2, 2, 2, 3, 2, 5, 5, 4, 2, 2, 4, 4, 3, 4, 2, 7, 2, 3, 5, 3, 3, 3, 3, 2, 3, 1, 2, 3, 3, 4, 2, 2, 8, 3, 12, 4, 13, 3, 2, 4, 3, 4, 1, 5, 1, 4, 3, 3, 4, 3, 2, 8, 7, 3, 2, 3, 3, 23, 4, 14, 2, 3, 3, 2, 4, 4, 2, 2, 2, 2, 2, 8, 6, 2, 2, 2, 3, 1, 3, 3, 2, 16, 1, 9, 2, 3, 3, 35, 4, 1, 2, 5, 2, 3, 3, 4, 7, 2, 5, 3, 4, 2, 5}},
    {"eu", {3, 3, 3, 3, 3, 53, 6, 5, 2, 2, 6, 3, 2, 2, 3, 5, 2, 1, 3, 2, 8, 3, 2, 4, 1, 2, 3, 2, 2, 1, 2, 3, 8, 2, 3, 2, 2, 7, 3, 2, 2, 2, 3, 2, 12, 1, 1, 7, 2, 2, 1, 2, 1, 11, 2, 2, 2, 2, 10, 4, 4, 4, 3, 9, 3, 2, 6, 3, 2, 1, 1, 4, 5, 3, 2, 2, 4, 2, 3, 2, 2, 7, 20, 2, 2, 3, 1, 11, 1, 1, 2, 2, 3, 2, 7, 3, 6, 1, 1, 2, 2, 3, 2, 3, 6, 1, 3, 2, 5, 1, 1, 4, 4, 2, 2, 1, 3, 1, 4, 2, 2, 11, 2, 1, 2, 3, 3, 3, 3, 2, 1, 2, 2, 2, 2, 2, 3, 4, 3, 3, 5, 3, 3, 2, 3, 2, 6, 2, 11, 6, 3, 2, 2, 2, 3, 6, 2, 6, 22, 4, 2, 2, 2, 2, 4, 3, 6, 3, 2, 5, 2, 7, 19, 4, 3, 2, 2, 4, 2, 2, 2, 4, 2, 2, 1, 3, 3, 1, 5, 6, 3, 4, 1, 1, 29, 1, 2, 2, 5, 14, 7, 3, 1, 2, 2, 4, 3, 4, 2, 2, 15, 4, 3, 2, 3, 7, 2, 0, 2, 2, 1, 3, 2, 3, 2, 3, 1, 1, 8, 2, 2, 5, 2, 2, 3, 3, 2, 5, 4, 9, 38, 20, 2, 3, 3, 3, 3, 2, 2, 3, 3, 12, 2, 1, 13, 8}},
    {"gl", {3, 2, 2, 4, 5, 42, 5, 3, 2, 2, 3, 2, 3, 4, 2, 6, 1, 1, 5, 4, 6, 3, 2, 4, 2, 2, 2, 3, 2, 1, 5, 3, 5, 2, 3, 1, 3, 4, 2, 4, 3, 2, 2, 3, 9, 3, 1, 4, 2, 3, 3, 2, 1, 7, 3, 2, 2, 3, 12, 2, 6, 4, 3, 3, 2, 4, 2, 1, 2, 2, 2, 3, 3, 3, 2, 3, 2, 3, 2, 2, 3, 2, 16, 5, 3, 3, 2, 20, 3, 1, 3, 2, 2, 6, 3, 2, 7, 1, 2, 2, 2, 2, 2, 4, 3, 3, 3, 2, 9, 3, 2, 5, 4, 3, 2, 3, 2, 3, 6, 3, 2, 11, 2, 1, 3, 3, 14, 4, 2, 2, 1, 2, 2, 4, 2, 2, 3, 3, 4, 5, 6, 3, 2, 2, 4, 3, 6, 3, 5, 5, 2, 2, 9, 2, 4, 2, 2, 4, 15, 2, 2, 3, 3, 5, 5, 2, 3, 3, 2, 9, 3, 6, 30, 9, 5, 4, 5, 3, 2, 3, 1, 2, 3, 1, 1, 2, 4, 1, 3, 5, 4, 2, 1, 1, 27, 2, 2, 1, 8, 20, 4, 2, 2, 4, 5, 4, 3, 2, 3, 2, 3, 3, 3, 2, 6, 7, 1, 2, 4, 3, 2, 4, 1, 2, 2, 4, 4, 1, 7, 3, 2, 4, 3, 2, 3, 2, 2, 3, 3, 5, 46, 16, 1, 4, 11, 1, 3, 2, 1, 1, 3, 11, 2, 3, 3, 5}},
    {"tl", {2, 14, 2, 3, 2, 76, 3, 3, 3, 5, 2, 3, 2, 1, 4, 3, 4, 2, 6, 2, 15, 3, 2, 6, 3, 3, 3, 2, 2, 1, 2, 2, 21, 4, 1, 5, 2, 3, 3, 4, 2, 1, 2, 4, 8, 3, 1, 5, 2, 3, 2, 3, 1, 6, 1, 2, 1, 2, 13, 3, 3, 3, 3, 4, 5, 3, 2, 1, 1, 2, 2, 3, 2, 3, 1, 3, 2, 2, 2, 3, 1, 5, 8, 3, 3, 5, 2, 13, 2, 1, 2, 2, 2, 7, 5, 1, 6, 1, 1, 2, 2, 2, 2, 4, 1, 1, 9, 2, 5, 1, 3, 7, 4, 5, 2, 2, 4, 4, 5, 3, 1, 12, 3, 1, 4, 2, 5, 5, 1, 1, 1, 1, 3, 2, 1, 3, 2, 1, 1, 2, 3, 2, 3, 1, 3, 5, 6, 2, 4, 6, 2, 3, 4, 1, 3, 2, 2, 6, 13, 4, 2, 4, 3, 2, 3, 2, 14, 3, 1, 11, 1, 4, 19, 4, 4, 2, 2, 3, 2, 2, 1, 2, 3, 2, 2, 3, 8, 4, 4, 4, 2, 2, 1, 1, 8, 2, 2, 1, 6, 13, 6, 2, 1, 6, 2, 2, 1, 3, 2, 2, 16, 5, 4, 3, 2, 5, 2, 1, 2, 1, 3, 3, 2, 15, 3, 3, 2, 1, 8, 5, 2, 3, 4, 2, 4, 2, 3, 3, 4, 2, 45, 19, 2, 3, 11, 1, 2, 2, 1, 1, 3, 6, 5, 2, 2, 6}},
    {"hy", {3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 5, 4, 2, 12, 2, 2, 2, 2, 4, 2, 5, 2, 5, 2, 2, 2, 4, 2, 5, 5, 2, 4, 3, 5, 2, 4, 3, 2, 4, 3, 3, 19, 4, 2, 1, 2, 3, 3, 3, 1, 2, 4, 5, 2, 2, 3, 3, 3, 3, 2, 3, 6, 3, 4, 2, 2, 10, 2, 3, 3, 4, 3, 4, 6, 4, 7, 2, 1, 3, 3, 3, 2, 5, 1, 4, 8, 2, 7, 2, 2, 1, 4, 2, 5, 2, 2, 2, 2, 8, 2, 36, 7, 3, 5, 4, 2, 4, 4, 4, 5, 3, 4, 14, 2, 4, 2, 4, 1, 2, 4, 2, 3, 10, 5, 7, 3, 5, 2, 2, 2, 4, 2, 4, 2, 5, 3, 4, 8, 3, 2, 2, 2, 3, 2, 6, 5, 1, 2, 3, 3, 2, 4, 2, 3, 1, 3, 6, 2, 2, 2, 12, 20, 3, 3, 7, 1, 23, 2, 2, 9, 3, 4, 1, 7, 4, 2, 3, 16, 3, 2, 4, 5, 2, 2, 3, 3, 2, 2, 4, 8, 1, 8, 3, 5, 2, 3, 3, 2, 8, 2, 5, 2, 5, 10, 3, 3, 2, 4, 5, 2, 2, 3, 4, 2, 3, 4, 6, 1, 2, 3, 3, 2, 2, 2, 2, 2, 2, 3, 2, 2, 7, 9, 8, 3, 1, 5, 2, 4, 36, 6, 7, 1, 1, 2, 18, 3, 2, 2, 2, 4, 2, 14, 2, 2}},
    {"kk", {6, 9, 3, 3, 3, 5, 4, 2, 3, 16, 4, 3, 3, 4, 3, 3, 4, 2, 3, 3, 4, 3, 2, 3, 3, 3, 3, 2, 5, 3, 2, 2, 3, 2, 3, 2, 3, 3, 2, 3, 2, 2, 15, 2, 2, 3, 6, 9, 19, 5, 2, 4, 2, 11, 5, 3, 2, 2, 3, 5, 3, 6, 4, 8, 3, 3, 3, 5, 4, 3, 2, 18, 3, 2, 3, 2, 3, 4, 2, 4, 3, 3, 3, 2, 6, 3, 6, 3, 5, 4, 3, 5, 2, 2, 3, 9, 1, 2, 5, 2, 6, 6, 13, 2, 6, 2, 2, 3, 3, 3, 2, 2, 3, 3, 5, 2, 2, 2, 2, 3, 3, 3, 2, 1, 8, 3, 3, 3, 4, 5, 4, 2, 18, 2, 2, 3, 1, 2, 7, 2, 6, 2, 2, 6, 5, 3, 4, 5, 8, 3, 3, 4, 3, 9, 3, 4, 4, 3, 3, 4, 1, 6, 7, 3, 3, 3, 1, 3, 10, 4, 2, 12, 5, 3, 2, 3, 13, 4, 4, 2, 3, 4, 2, 3, 2, 2, 3, 6, 4, 3, 3, 3, 5, 3, 3, 3, 5, 2, 2, 2, 4, 3, 4, 3, 2, 2, 2, 2, 5, 3, 2, 6, 2, 2, 3, 2, 2, 3, 4, 5, 4, 2, 3, 2, 3, 2, 2, 2, 2, 4, 3, 4, 2, 6, 6, 4, 2, 2, 1, 3, 38, 2, 3, 41, 2, 3, 4, 4, 2, 3, 3, 2, 3, 3, 3, 4}},
    {"be", {2, 18, 2, 2, 2, 2, 5, 2, 3, 17, 3, 3, 2, 2, 2, 2, 4, 3, 2, 1, 2, 3, 3, 5, 2, 6, 4, 3, 7, 2, 3, 1, 3, 3, 3, 1, 5, 3, 3, 3, 3, 3, 9, 2, 2, 7, 3, 7, 12, 4, 2, 6, 4, 9, 4, 4, 2, 3, 3, 2, 2, 5, 2, 8, 3, 3, 3, 5, 4, 3, 2, 14, 4, 2, 3, 3, 4, 3, 2, 5, 3, 5, 3, 2, 6, 2, 5, 3, 6, 2, 2, 5, 3, 3, 3, 11, 3, 3, 5, 1, 3, 6, 12, 1, 5, 1, 2, 3, 3, 3, 2, 2, 2, 1, 3, 2, 3, 2, 2, 3, 3, 3, 2, 2, 5, 5, 3, 3, 3, 4, 2, 3, 10, 2, 2, 3, 3, 2, 17, 2, 6, 3, 3, 2, 8, 3, 3, 4, 3, 2, 2, 2, 2, 8, 4, 7, 2, 3, 2, 3, 2, 8, 6, 4, 2, 2, 4, 5, 11, 5, 2, 14, 3, 3, 3, 3, 10, 6, 3, 4, 3, 4, 1, 3, 2, 4, 3, 5, 2, 2, 3, 2, 2, 3, 4, 2, 4, 2, 2, 3, 3, 3, 2, 3, 2, 3, 7, 3, 3, 2, 2, 6, 2, 2, 5, 2, 2, 2, 3, 3, 2, 2, 3, 2, 3, 4, 2, 5, 2, 2, 2, 3, 2, 4, 8, 5, 3, 2, 3, 2, 41, 4, 2, 49, 3, 7, 3, 4, 3, 2, 4, 2, 3, 4, 2, 2}},
    {"te", {2, 8, 3, 7, 3, 2, 2, 2, 3, 2, 3, 3, 3, 6, 2, 3, 2, 2, 21, 5, 2, 2, 1, 2, 3, 2, 4, 12, 2, 4, 2, 2, 2, 2, 2, 3, 3, 2, 2, 3, 4, 5, 2, 1, 3, 2, 2, 1, 5, 4, 5, 3, 5, 5, 2, 2, 4, 2, 1, 4, 2, 3, 2, 5, 2, 3, 2, 2, 2, 20, 3, 1, 4, 3, 6, 6, 2, 5, 2, 2, 2, 6, 2, 4, 2, 2, 4, 3, 5, 4, 3, 2, 2, 3, 9, 3, 3, 1, 2, 3, 5, 2, 4, 3, 6, 11, 1, 33, 12, 6, 2, 5, 8, 10, 2, 2, 1, 3, 2, 2, 3, 3, 6, 3, 2, 2, 2, 3, 3, 3, 1, 2, 2, 4, 13, 2, 4, 3, 2, 2, 6, 2, 5, 6, 3, 2, 4, 3, 2, 3, 23, 4, 4, 3, 4, 2, 3, 2, 3, 5, 5, 3, 3, 3, 5, 2, 5, 2, 1, 3, 4, 4, 4, 1, 2, 26, 4, 2, 2, 2, 9, 4, 5, 2, 4, 2, 2, 2, 3, 3, 2, 5, 2, 3, 3, 2, 1, 3, 2, 5, 3, 2, 2, 2, 3, 1, 4, 1, 4, 5, 3, 6, 1, 6, 2, 3, 3, 3, 4, 2, 4, 2, 5, 1, 4, 2, 3, 1, 3, 3, 3, 2, 6, 1, 3, 2, 3, 13, 2, 2, 59, 11, 3, 2, 2, 2, 2, 5, 4, 3, 17, 2, 3, 3, 2, 3}},
    {"lv", {5, 2, 2, 2, 6, 37, 7, 2, 2, 4, 3, 2, 3, 2, 2, 6, 2, 3, 3, 3, 4, 2, 3, 3, 2, 3, 3, 3, 2, 2, 2, 8, 8, 3, 5, 4, 3, 3, 2, 6, 2, 2, 3, 2, 14, 3, 2, 7, 2, 3, 2, 2, 1, 3, 2, 3, 2, 4, 11, 2, 4, 2, 3, 4, 6, 4, 2, 2, 11, 2, 2, 7, 4, 3, 2, 3, 2, 3, 3, 3, 2, 6, 14, 4, 2, 3, 2, 16, 2, 2, 2, 5, 2, 4, 5, 2, 6, 2, 1, 2, 2, 2, 4, 4, 4, 2, 4, 2, 3, 3, 4, 4, 2, 3, 2, 1, 2, 4, 4, 3, 3, 8, 3, 2, 3, 3, 5, 5, 2, 2, 2, 3, 3, 2, 2, 2, 2, 7, 4, 4, 3, 2, 3, 1, 4, 3, 5, 2, 4, 4, 4, 2, 13, 3, 4, 2, 2, 5, 16, 3, 5, 3, 3, 2, 5, 2, 3, 2, 2, 7, 2, 3, 18, 8, 2, 2, 4, 4, 3, 3, 2, 3, 3, 3, 2, 4, 5, 1, 3, 5, 4, 3, 3, 1, 17, 3, 3, 2, 4, 20, 7, 2, 2, 5, 3, 2, 2, 3, 3, 2, 11, 5, 4, 3, 3, 3, 2, 2, 3, 2, 2, 3, 2, 2, 4, 4, 2, 2, 6, 3, 3, 3, 2, 3, 3, 1, 3, 4, 3, 3, 40, 21, 2, 4, 5, 2, 3, 2, 3, 2, 3, 7, 2, 2, 6, 5}},
    {"mk", {9, 19, 3, 3, 2, 3, 2, 3, 4, 16, 3, 5, 2, 2, 2, 3, 3, 3, 1, 1, 2, 2, 2, 4, 2, 3, 4, 2, 6, 3, 2, 1, 1, 2, 2, 2, 2, 4, 6, 4, 4, 1, 17, 2, 3, 5, 23, 5, 2, 3, 1, 4, 3, 9, 7, 2, 4, 3, 3, 4, 2, 4, 3, 9, 3, 6, 2, 7, 2, 3, 2, 27, 5, 2, 2, 3, 2, 2, 1, 4, 2, 3, 4, 3, 4, 2, 6, 4, 3, 2, 1, 2, 2, 4, 4, 7, 2, 2, 3, 1, 4, 7, 13, 2, 9, 2, 1, 3, 3, 4, 3, 3, 3, 1, 4, 3, 2, 2, 3, 2, 3, 3, 2, 2, 6, 4, 3, 3, 4, 3, 2, 2, 19, 5, 1, 2, 2, 1, 14, 2, 7, 2, 2, 1, 7, 2, 2, 6, 3, 3, 2, 4, 3, 7, 3, 5, 4, 2, 3, 3, 2, 8, 7, 5, 3, 2, 2, 3, 18, 2, 2, 2, 2, 2, 1, 1, 9, 2, 4, 4, 3, 5, 2, 3, 2, 3, 4, 5, 2, 2, 1, 3, 6, 3, 2, 3, 4, 2, 3, 2, 8, 2, 3, 7, 2, 2, 3, 3, 2, 2, 2, 2, 2, 3, 3, 2, 1, 3, 3, 5, 2, 3, 6, 2, 1, 2, 2, 2, 5, 2, 1, 5, 2, 5, 9, 3, 3, 3, 2, 3, 45, 2, 3, 42, 2, 8, 3, 3, 2, 3, 3, 2, 2, 5, 2, 4}},
    {"my", {3, 2, 2, 3, 2, 21, 2, 2, 2, 17, 3, 3, 2, 4, 4, 2, 3, 2, 3, 3, 4, 2, 4, 8, 2, 2, 5, 2, 3, 2, 2, 3, 4, 4, 3, 2, 3, 3, 3, 3, 3, 2, 3, 2, 2, 4, 18, 2, 2, 4, 21, 3, 2, 3, 3, 2, 2, 3, 3, 3, 5, 2, 3, 6, 2, 4, 2, 20, 4, 11, 5, 2, 3, 6, 2, 2, 3, 5, 16, 2, 3, 3, 2, 2, 3, 2, 4, 4, 2, 1, 2, 5, 2, 10, 2, 2, 4, 2, 3, 2, 4, 14, 2, 6, 2, 3, 6, 3, 3, 3, 5, 2, 3, 2, 2, 3, 3, 3, 5, 6, 2, 2, 4, 5, 1, 2, 3, 6, 3, 2, 3, 6, 4, 3, 6, 2, 5, 2, 4, 5, 4, 2, 17, 2, 2, 2, 2, 4, 2, 2, 3, 3, 4, 9, 3, 3, 2, 2, 3, 3, 3, 2, 2, 4, 2, 6, 2, 9, 3, 1, 4, 2, 3, 2, 2, 5, 6, 12, 5, 2, 2, 5, 2, 2, 1, 6, 3, 3, 4, 3, 2, 3, 3, 4, 6, 1, 2, 5, 2, 2, 2, 9, 3, 2, 2, 2, 2, 3, 7, 2, 2, 2, 2, 4, 3, 11, 2, 9, 5, 1, 2, 3, 1, 1, 4, 13, 3, 3, 4, 1, 2, 4, 1, 5, 2, 4, 2, 3, 3, 3, 45, 3, 2, 5, 2, 22, 4, 2, 8, 5, 4, 5, 1, 2, 4, 2}},
    {"is", {5, 3, 2, 2, 3, 40, 5, 2, 2, 2, 3, 2, 3, 3, 2, 8, 2, 2, 2, 2, 6, 10, 2, 4, 2, 2, 2, 2, 4, 2, 2, 5, 12, 2, 2, 3, 2, 2, 2, 5, 2, 1, 2, 2, 13, 2, 4, 6, 2, 3, 2, 3, 2, 6, 4, 2, 4, 5, 12, 3, 4, 4, 4, 3, 3, 3, 3, 3, 2, 2, 2, 6, 5, 3, 3, 4, 2, 1, 2, 2, 2, 3, 22, 3, 3, 4, 2, 15, 2, 3, 2, 6, 2, 2, 4, 3, 10, 2, 3, 3, 3, 3, 3, 4, 2, 3, 2, 2, 3, 2, 4, 6, 2, 2, 2, 2, 6, 2, 4, 8, 3, 6, 2, 3, 3, 2, 5, 6, 2, 3, 3, 3, 2, 2, 2, 2, 2, 7, 2, 3, 3, 3, 3, 2, 3, 3, 4, 3, 5, 3, 2, 3, 4, 2, 3, 3, 2, 5, 15, 2, 2, 3, 3, 2, 5, 4, 3, 4, 2, 5, 3, 5, 10, 3, 4, 5, 3, 5, 3, 3, 4, 4, 3, 2, 2, 2, 6, 2, 4, 6, 7, 5, 2, 2, 17, 2, 3, 2, 5, 15, 5, 2, 2, 6, 3, 3, 2, 3, 2, 3, 9, 4, 6, 2, 3, 8, 3, 2, 2, 3, 2, 3, 3, 5, 5, 4, 2, 1, 10, 3, 2, 4, 3, 2, 4, 4, 4, 3, 4, 4, 45, 18, 1, 6, 3, 2, 5, 4, 2, 2, 3, 4, 4, 2, 3, 5}},
    {"mn", {3, 7, 3, 2, 3, 3, 5, 6, 2, 21, 3, 3, 2, 2, 2, 3, 4, 3, 2, 2, 3, 4, 5, 6, 2, 4, 3, 6, 15, 2, 3, 2, 2, 2, 2, 2, 10, 1, 3, 2, 4, 3, 11, 2, 4, 2, 13, 5, 5, 4, 3, 2, 4, 11, 5, 3, 1, 2, 2, 5, 3, 6, 3, 7, 3, 2, 2, 2, 4, 5, 2, 20, 2, 2, 2, 3, 2, 3, 3, 4, 2, 7, 3, 2, 3, 3, 7, 2, 6, 2, 2, 5, 3, 3, 2, 18, 3, 3, 6, 2, 9, 3, 15, 2, 6, 2, 3, 2, 2, 4, 3, 2, 3, 2, 2, 3, 3, 2, 4, 2, 2, 3, 1, 2, 12, 3, 3, 1, 5, 7, 4, 3, 4, 2, 2, 3, 1, 2, 7, 4, 6, 3, 2, 2, 5, 2, 2, 2, 3, 4, 4, 2, 5, 8, 2, 5, 2, 3, 3, 2, 1, 5, 5, 5, 3, 3, 4, 4, 5, 17, 2, 2, 2, 2, 2, 3, 15, 2, 5, 3, 2, 3, 2, 2, 2, 2, 2, 9, 1, 2, 3, 2, 3, 4, 5, 2, 3, 1, 2, 5, 3, 2, 1, 2, 3, 2, 4, 6, 6, 4, 5, 12, 3, 2, 3, 2, 2, 4, 2, 2, 3, 2, 6, 2, 3, 2, 2, 2, 4, 4, 4, 2, 2, 5, 3, 3, 3, 3, 2, 2, 41, 6, 3, 39, 1, 2, 2, 1, 4, 2, 2, 2, 2, 3, 3, 2}},
    {"kn", {3, 4, 2, 3, 5, 3, 4, 21, 2, 2, 3, 2, 3, 2, 3, 3, 3, 3, 2, 2, 2, 4, 3, 2, 2, 3, 3, 2, 2, 3, 6, 4, 2, 2, 2, 3, 2, 2, 3, 3, 3, 2, 2, 1, 5, 3, 3, 2, 17, 3, 7, 3, 3, 4, 3, 17, 2, 3, 3, 4, 2, 3, 10, 4, 2, 4, 3, 2, 2, 2, 2, 3, 4, 2, 3, 2, 13, 3, 2, 5, 3, 3, 2, 2, 2, 5, 3, 2, 2, 3, 3, 1, 3, 2, 5, 2, 2, 3, 3, 2, 7, 2, 3, 6, 18, 4, 2, 2, 3, 4, 4, 2, 4, 4, 3, 3, 2, 4, 3, 3, 2, 18, 3, 1, 2, 3, 7, 2, 6, 6, 3, 2, 3, 2, 1, 2, 5, 1, 3, 3, 7, 3, 2, 4, 2, 2, 3, 2, 3, 2, 3, 3, 2, 4, 12, 5, 3, 2, 4, 3, 3, 2, 2, 21, 3, 7, 2, 2, 4, 5, 3, 16, 8, 3, 2, 2, 5, 3, 3, 4, 2, 3, 2, 2, 2, 3, 3, 3, 2, 7, 2, 2, 14, 5, 5, 3, 6, 3, 4, 7, 3, 3, 2, 2, 2, 2, 1, 2, 2, 4, 14, 4, 26, 5, 2, 4, 2, 1, 2, 6, 2, 1, 3, 9, 2, 2, 3, 7, 2, 2, 1, 4, 5, 1, 2, 2, 2, 3, 2, 3, 50, 6, 3, 4, 2, 2, 4, 8, 4, 3, 11, 3, 3, 3, 6, 1}},
    {"cy", {2, 3, 2, 3, 3, 42, 7, 2, 2, 9, 2, 4, 3, 2, 3, 5, 2, 2, 2, 3, 6, 3, 5, 4, 1, 3, 1, 2, 4, 2, 2, 4, 11, 2, 4, 3, 2, 3, 2, 2, 2, 2, 1, 3, 8, 2, 2, 4, 2, 2, 2, 3, 2, 9, 3, 2, 2, 4, 15, 2, 3, 3, 3, 3, 3, 3, 2, 2, 2, 4, 2, 3, 4, 2, 2, 2, 3, 4, 3, 2, 2, 3, 17, 3, 7, 4, 2, 25, 2, 1, 2, 2, 3, 4, 3, 3, 12, 3, 1, 2, 2, 3, 2, 2, 4, 2, 2, 2, 4, 3, 3, 3, 4, 2, 1, 3, 4, 1, 6, 8, 3, 5, 3, 2, 3, 2, 8, 3, 3, 3, 2, 2, 3, 2, 2, 7, 2, 2, 6, 4, 3, 4, 2, 3, 3, 2, 3, 2, 5, 4, 2, 2, 4, 4, 2, 3, 2, 3, 13, 3, 2, 5, 3, 2, 7, 2, 3, 2, 3, 4, 3, 5, 16, 6, 2, 3, 1, 4, 3, 4, 2, 2, 3, 3, 2, 2, 19, 1, 4, 5, 8, 4, 2, 3, 19, 2, 4, 3, 6, 8, 4, 2, 2, 3, 4, 4, 2, 2, 4, 4, 8, 3, 4, 2, 3, 7, 2, 2, 2, 2, 2, 4, 2, 5, 3, 3, 2, 2, 9, 8, 2, 2, 4, 2, 5, 3, 3, 4, 4, 4, 47, 15, 2, 1, 6, 2, 4, 5, 2, 2, 4, 5, 3, 2, 3, 4}},
    {"br", {3, 4, 3, 4, 3, 45, 7, 2, 1, 3, 6, 4, 2, 3, 3, 3, 3, 2, 3, 3, 9, 3, 5, 4, 2, 2, 1, 2, 2, 2, 3, 3, 9, 2, 4, 4, 2, 4, 2, 3, 2, 4, 3, 3, 10, 2, 2, 4, 3, 3, 1, 2, 1, 7, 2, 2, 3, 2, 13, 2, 3, 3, 2, 3, 3, 2, 2, 2, 1, 2, 2, 3, 4, 2, 2, 2, 3, 4, 2, 2, 4, 4, 18, 4, 3, 5, 1, 16, 2, 2, 2, 3, 4, 4, 3, 2, 12, 1, 2, 2, 2, 1, 1, 4, 3, 3, 2, 2, 5, 2, 1, 5, 4, 4, 2, 2, 3, 2, 9, 7, 2, 8, 3, 2, 3, 3, 5, 3, 3, 1, 2, 3, 2, 3, 3, 4, 3, 8, 5, 3, 3, 4, 2, 2, 2, 3, 7, 2, 4, 3, 2, 2, 4, 3, 3, 3, 2, 3, 15, 4, 1, 3, 2, 2, 6, 3, 3, 1, 3, 7, 2, 8, 18, 4, 3, 2, 3, 4, 2, 3, 3, 3, 4, 2, 2, 2, 3, 1, 5, 6, 3, 4, 6, 2, 31, 3, 3, 2, 8, 10, 5, 3, 2, 3, 3, 3, 2, 2, 5, 4, 6, 4, 3, 2, 5, 6, 2, 2, 2, 2, 1, 3, 2, 5, 3, 3, 2, 1, 7, 3, 2, 4, 5, 2, 2, 3, 7, 4, 3, 6, 50, 13, 2, 2, 8, 1, 2, 2, 2, 3, 3, 6, 4, 2, 9, 5}},
    {"uz", {3, 4, 2, 5, 3, 50, 5, 2, 3, 3, 2, 3, 2, 3, 3, 6, 3, 3, 5, 2, 8, 2, 2, 7, 3, 2, 2, 3, 3, 1, 6, 4, 9, 2, 2, 3, 2, 3, 5, 3, 3, 2, 3, 2, 9, 3, 2, 4, 2, 3, 2, 2, 1, 6, 2, 2, 2, 12, 18, 4, 5, 4, 3, 5, 4, 4, 2, 3, 2, 2, 2, 4, 5, 7, 3, 3, 3, 2, 2, 2, 2, 10, 16, 4, 3, 2, 2, 16, 3, 1, 2, 3, 2, 3, 4, 2, 13, 2, 1, 2, 3, 2, 3, 4, 2, 1, 2, 2, 5, 2, 4, 4, 3, 2, 2, 1, 3, 2, 3, 5, 3, 8, 3, 2, 3, 3, 5, 6, 4, 2, 1, 2, 3, 2, 4, 3, 3, 5, 3, 2, 3, 2, 4, 2, 3, 2, 3, 2, 3, 4, 2, 3, 3, 2, 5, 3, 1, 5, 15, 4, 2, 2, 3, 2, 4, 2, 5, 2, 3, 3, 3, 5, 19, 6, 3, 1, 4, 3, 3, 1, 2, 3, 3, 3, 1, 2, 12, 1, 5, 8, 3, 4, 2, 1, 7, 2, 3, 2, 4, 13, 7, 2, 2, 3, 2, 3, 2, 4, 2, 4, 9, 3, 3, 2, 2, 6, 2, 2, 2, 1, 3, 2, 2, 5, 2, 3, 3, 1, 11, 2, 3, 4, 4, 2, 3, 2, 3, 5, 7, 2, 37, 30, 2, 2, 2, 4, 3, 2, 3, 1, 2, 6, 2, 3, 4, 6}},
    {"gu", {2, 2, 1, 3, 2, 3, 3, 2, 5, 5, 6, 3, 3, 1, 2, 2, 4, 5, 3, 2, 4, 1, 3, 2, 2, 2, 2, 4, 2, 7, 4, 1, 8, 2, 4, 4, 5, 9, 2, 6, 5, 7, 2, 4, 16, 2, 3, 4, 4, 3, 2, 7, 5, 15, 2, 2, 1, 2, 3, 2, 2, 4, 5, 6, 2, 3, 20, 2, 5, 3, 3, 4, 4, 3, 3, 3, 8, 2, 5, 4, 1, 1, 3, 2, 4, 17, 2, 6, 3, 3, 10, 2, 2, 2, 3, 2, 3, 3, 5, 6, 3, 9, 5, 8, 1, 4, 2, 2, 7, 2, 4, 4, 4, 2, 3, 2, 2, 2, 6, 8, 3, 5, 3, 3, 4, 3, 2, 3, 3, 5, 3, 2, 3, 10, 1, 2, 4, 6, 1, 4, 3, 6, 2, 2, 2, 7, 2, 1, 2, 3, 4, 3, 3, 4, 4, 2, 1, 6, 4, 2, 3, 1, 2, 3, 3, 2, 2, 3, 2, 2, 1, 6, 4, 2, 2, 2, 4, 2, 6, 2, 2, 2, 3, 3, 4, 3, 3, 3, 5, 4, 11, 2, 2, 4, 14, 2, 4, 5, 4, 8, 3, 3, 2, 2, 2, 2, 2, 2, 5, 5, 2, 4, 1, 1, 2, 2, 4, 6, 4, 4, 2, 7, 10, 2, 5, 8, 3, 4, 3, 4, 3, 3, 5, 2, 2, 2, 6, 1, 2, 2, 67, 3, 2, 2, 4, 2, 1, 20, 3, 3, 2, 1, 2, 2, 16, 6}},
    {"ne", {2, 3, 3, 3, 2, 2, 14, 3, 2, 3, 4, 2, 2, 5, 5, 2, 2, 3, 2, 2, 3, 2, 4, 3, 4, 5, 3, 4, 5, 4, 3, 1, 3, 2, 3, 4, 3, 2, 2, 1, 3, 3, 2, 1, 2, 6, 4, 3, 6, 2, 13, 23, 3, 2, 3, 2, 8, 2, 3, 2, 10, 2, 3, 6, 4, 2, 2, 3, 2, 3, 7, 1, 2, 10, 2, 4, 2, 2, 3, 3, 2, 6, 5, 4, 5, 13, 5, 2, 2, 2, 4, 2, 4, 2, 2, 3, 2, 4, 3, 2, 3, 6, 20, 4, 3, 4, 5, 2, 3, 12, 2, 3, 2, 3, 5, 3, 5, 2, 2, 3, 3, 3, 3, 2, 3, 6, 3, 3, 4, 2, 1, 2, 3, 2, 5, 2, 3, 3, 2, 1, 3, 2, 5, 5, 6, 2, 3, 3, 3, 4, 3, 1, 2, 6, 4, 3, 15, 3, 3, 4, 2, 7, 2, 3, 7, 8, 3, 3, 3, 3, 3, 2, 13, 3, 6, 2, 3, 3, 2, 3, 3, 10, 2, 2, 7, 2, 3, 3, 5, 3, 2, 2, 3, 2, 4, 2, 2, 3, 3, 5, 2, 3, 7, 3, 4, 15, 2, 2, 8, 3, 26, 2, 2, 2, 2, 3, 6, 2, 2, 3, 3, 5, 2, 4, 2, 3, 2, 10, 2, 3, 2, 4, 3, 2, 3, 3, 3, 2, 3, 2, 63, 2, 6, 6, 3, 3, 2, 3, 3, 2, 4, 2, 7, 2, 6, 2}},
    {"si", {3, 2, 2, 3, 3, 6, 4, 4, 5, 3, 4, 2, 9, 2, 3, 2, 2, 3, 3, 4, 3, 3, 2, 2, 3, 2, 2, 3, 2, 2, 1, 2, 10, 3, 11, 4, 3, 3, 3, 8, 2, 3, 2, 4, 16, 4, 4, 2, 3, 3, 3, 3, 2, 3, 3, 2, 2, 8, 4, 3, 2, 3, 2, 3, 2, 2, 3, 2, 3, 2, 3, 6, 2, 2, 6, 3, 3, 11, 4, 3, 2, 5, 5, 2, 3, 3, 4, 3, 3, 2, 2, 3, 2, 2, 5, 2, 4, 4, 4, 3, 5, 2, 3, 3, 20, 2, 3, 3, 5, 2, 2, 3, 2, 8, 2, 2, 7, 5, 2, 8, 2, 3, 2, 3, 3, 3, 4, 10, 3, 2, 9, 4, 11, 2, 2, 2, 11, 4, 2, 3, 9, 3, 3, 4, 3, 3, 2, 4, 2, 2, 2, 2, 2, 2, 22, 2, 4, 5, 3, 3, 5, 6, 6, 2, 3, 2, 3, 2, 2, 3, 3, 3, 4, 4, 2, 6, 4, 4, 3, 15, 2, 2, 5, 2, 3, 2, 3, 2, 3, 3, 4, 2, 2, 2, 5, 5, 3, 2, 3, 3, 17, 2, 4, 18, 2, 2, 2, 3, 7, 1, 2, 2, 5, 3, 3, 5, 3, 3, 2, 3, 2, 2, 1, 3, 2, 3, 2, 2, 3, 4, 6, 3, 2, 2, 3, 14, 2, 2, 4, 3, 60, 4, 2, 3, 3, 3, 4, 3, 8, 2, 23, 2, 2, 3, 3, 3}},
    {"lb", {5, 4, 2, 4, 4, 37, 5, 3, 5, 4, 3, 2, 3, 2, 3, 6, 3, 2, 4, 4, 8, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 5, 9, 2, 4, 3, 3, 3, 4, 3, 5, 2, 1, 2, 12, 2, 3, 4, 4, 4, 3, 2, 2, 10, 3, 3, 3, 4, 11, 3, 3, 2, 3, 3, 3, 2, 2, 3, 2, 2, 1, 3, 3, 2, 2, 2, 4, 3, 4, 2, 2, 3, 17, 2, 2, 5, 1, 17, 2, 2, 2, 3, 3, 2, 4, 2, 13, 2, 1, 5, 2, 2, 2, 3, 3, 2, 3, 2, 7, 4, 2, 5, 2, 2, 2, 2, 2, 2, 5, 7, 2, 5, 3, 1, 2, 2, 9, 2, 2, 2, 2, 2, 3, 3, 4, 2, 3, 4, 4, 3, 5, 2, 2, 3, 4, 2, 4, 3, 8, 3, 4, 1, 5, 3, 4, 3, 2, 6, 15, 3, 2, 5, 3, 1, 3, 2, 4, 2, 2, 5, 2, 4, 13, 6, 3, 4, 3, 4, 2, 3, 5, 3, 5, 2, 2, 2, 3, 1, 3, 10, 6, 2, 2, 2, 33, 2, 3, 2, 8, 17, 5, 2, 2, 3, 3, 4, 2, 2, 5, 6, 5, 3, 3, 3, 6, 6, 2, 3, 2, 3, 2, 2, 1, 4, 2, 6, 2, 1, 5, 5, 3, 3, 3, 2, 2, 2, 8, 3, 3, 8, 44, 14, 1, 2, 6, 2, 2, 2, 3, 3, 3, 4, 3, 2, 5, 4}},
    {"jv", {3, 11, 3, 3, 3, 68, 5, 3, 2, 6, 4, 2, 2, 2, 2, 4, 2, 2, 3, 2, 14, 4, 1, 5, 2, 2, 2, 2, 1, 1, 1, 3, 15, 2, 2, 2, 2, 4, 5, 2, 5, 2, 4, 2, 13, 2, 2, 6, 2, 3, 2, 3, 1, 8, 2, 2, 2, 5, 12, 3, 5, 4, 2, 6, 8, 2, 3, 2, 2, 2, 2, 4, 3, 2, 4, 2, 3, 1, 2, 3, 2, 4, 11, 2, 2, 4, 1, 16, 2, 2, 2, 4, 2, 5, 5, 2, 10, 1, 1, 3, 2, 2, 2, 5, 3, 2, 5, 3, 4, 2, 7, 6, 3, 4, 2, 1, 2, 3, 3, 3, 1, 8, 3, 2, 4, 2, 5, 5, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 3, 4, 2, 3, 2, 4, 3, 4, 2, 4, 3, 2, 2, 4, 2, 3, 3, 2, 5, 12, 5, 3, 3, 4, 2, 4, 3, 8, 3, 1, 7, 2, 2, 14, 6, 2, 2, 2, 3, 2, 2, 2, 3, 3, 2, 2, 4, 6, 2, 4, 4, 2, 2, 1, 2, 14, 2, 2, 2, 6, 12, 6, 1, 2, 5, 3, 5, 1, 4, 2, 2, 17, 9, 3, 3, 3, 6, 2, 2, 3, 2, 2, 2, 2, 8, 1, 4, 3, 1, 10, 3, 1, 5, 3, 1, 4, 2, 3, 3, 6, 5, 41, 21, 2, 2, 4, 2, 3, 2, 2, 1, 3, 4, 2, 2, 2, 8}},
    {"sw", {2, 4, 1, 2, 2, 61, 7, 3, 2, 12, 1, 2, 1, 1, 1, 4, 2, 5, 12, 2, 6, 6, 2, 3, 4, 2, 2, 2, 1, 2, 2, 2, 6, 1, 1, 1, 1, 2, 3, 2, 3, 1, 3, 2, 14, 2, 2, 6, 3, 3, 2, 4, 1, 3, 1, 2, 2, 11, 12, 6, 4, 4, 4, 5, 16, 3, 5, 2, 2, 1, 1, 5, 4, 4, 3, 2, 4, 1, 2, 3, 1, 5, 6, 1, 5, 5, 1, 14, 3, 2, 2, 2, 3, 4, 3, 2, 10, 1, 2, 2, 2, 2, 3, 5, 3, 2, 4, 3, 5, 1, 3, 11, 3, 6, 3, 2, 3, 2, 3, 3, 1, 24, 2, 2, 2, 3, 6, 5, 2, 2, 1, 4, 2, 1, 1, 2, 2, 3, 2, 1, 5, 3, 4, 1, 3, 2, 5, 4, 4, 2, 4, 2, 3, 2, 6, 2, 1, 4, 11, 1, 2, 2, 4, 2, 3, 3, 3, 2, 2, 10, 2, 2, 14, 4, 3, 2, 2, 5, 3, 2, 2, 3, 4, 2, 1, 3, 9, 2, 5, 4, 5, 3, 1, 1, 15, 2, 1, 2, 4, 7, 7, 1, 2, 5, 3, 4, 3, 4, 3, 3, 17, 7, 4, 1, 3, 3, 2, 1, 3, 1, 1, 3, 1, 2, 2, 3, 5, 1, 6, 6, 2, 3, 3, 6, 2, 2, 2, 3, 4, 3, 43, 29, 2, 3, 7, 2, 2, 1, 2, 1, 2, 10, 1, 2, 5, 7}},
    {"ga", {2, 3, 2, 3, 2, 58, 2, 3, 3, 3, 1, 3, 2, 5, 2, 9, 4, 1, 4, 2, 9, 2, 2, 4, 2, 2, 1, 2, 2, 2, 3, 4, 10, 2, 3, 5, 3, 4, 4, 3, 4, 2, 1, 2, 7, 2, 2, 2, 3, 3, 2, 4, 1, 8, 3, 4, 2, 2, 12, 2, 3, 2, 2, 3, 1, 3, 6, 3, 1, 2, 2, 3, 4, 3, 3, 5, 3, 3, 3, 2, 1, 4, 14, 3, 2, 5, 1, 16, 2, 4, 5, 4, 4, 7, 5, 2, 19, 1, 1, 2, 2, 2, 2, 4, 7, 2, 3, 4, 4, 2, 2, 4, 3, 2, 3, 2, 2, 3, 9, 8, 3, 10, 3, 2, 3, 2, 14, 4, 2, 2, 2, 3, 2, 2, 2, 3, 2, 2, 5, 2, 3, 4, 3, 3, 2, 3, 4, 2, 3, 2, 1, 1, 7, 2, 6, 2, 1, 11, 12, 4, 2, 3, 4, 2, 5, 3, 2, 5, 3, 6, 1, 3, 12, 4, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 1, 3, 2, 4, 4, 1, 3, 14, 2, 2, 3, 5, 14, 6, 2, 1, 5, 4, 4, 1, 3, 5, 7, 2, 4, 5, 4, 3, 7, 2, 2, 3, 2, 3, 4, 2, 4, 3, 3, 2, 1, 10, 5, 3, 4, 5, 1, 2, 2, 3, 4, 3, 4, 50, 22, 2, 5, 7, 1, 5, 2, 2, 3, 4, 4, 4, 2, 2, 3}},
    {"ku", {2, 2, 2, 2, 3, 40, 5, 3, 1, 6, 5, 3, 2, 3, 2, 6, 2, 3, 8, 3, 9, 2, 2, 3, 2, 2, 2, 2, 2, 1, 2, 4, 9, 2, 2, 3, 3, 3, 3, 1, 3, 3, 2, 2, 4, 3, 2, 4, 3, 4, 2, 2, 2, 8, 3, 2, 4, 7, 11, 6, 3, 3, 3, 3, 5, 2, 3, 3, 2, 2, 2, 5, 3, 3, 3, 1, 8, 2, 2, 3, 3, 2, 15, 2, 4, 4, 1, 16, 2, 1, 2, 3, 6, 3, 6, 2, 7, 1, 3, 2, 2, 3, 2, 3, 2, 3, 3, 2, 5, 3, 3, 4, 3, 3, 2, 4, 4, 2, 3, 3, 2, 8, 3, 1, 2, 2, 3, 5, 2, 5, 1, 2, 3, 2, 3, 2, 6, 6, 3, 2, 5, 13, 2, 3, 4, 2, 4, 2, 4, 4, 2, 3, 4, 2, 4, 3, 2, 3, 10, 4, 3, 3, 2, 2, 3, 2, 4, 2, 3, 8, 2, 3, 9, 5, 3, 3, 4, 5, 2, 2, 3, 3, 4, 2, 2, 4, 10, 2, 4, 6, 3, 3, 2, 1, 24, 4, 2, 2, 10, 9, 8, 2, 2, 4, 3, 3, 2, 3, 3, 2, 12, 4, 2, 2, 3, 6, 2, 2, 3, 10, 2, 3, 2, 3, 2, 4, 2, 2, 8, 4, 3, 4, 5, 2, 2, 3, 5, 7, 4, 3, 49, 20, 4, 3, 10, 2, 2, 2, 2, 2, 3, 5, 2, 2, 4, 5}},
    {"yi", {3, 2, 2, 3, 2, 5, 3, 4, 8, 2, 2, 4, 4, 3, 3, 3, 2, 6, 9, 3, 2, 3, 3, 3, 1, 6, 1, 7, 2, 3, 1, 3, 3, 1, 2, 7, 3, 1, 2, 1, 4, 3, 2, 1, 18, 2, 2, 2, 1, 6, 2, 6, 8, 2, 5, 2, 6, 1, 4, 4, 5, 3, 4, 4, 2, 4, 2, 5, 2, 3, 2, 3, 5, 2, 4, 2, 2, 3, 4, 2, 3, 23, 2, 1, 5, 3, 2, 4, 2, 24, 2, 5, 1, 2, 5, 2, 29, 3, 1, 2, 2, 3, 29, 1, 2, 3, 5, 4, 4, 2, 2, 1, 2, 2, 4, 2, 3, 7, 2, 2, 1, 4, 4, 1, 4, 2, 2, 4, 2, 2, 3, 2, 4, 3, 7, 3, 14, 3, 2, 1, 8, 1, 1, 1, 3, 2, 6, 1, 2, 3, 1, 2, 3, 6, 3, 4, 3, 2, 15, 2, 2, 6, 2, 3, 2, 6, 1, 3, 3, 3, 8, 9, 3, 2, 1, 3, 2, 3, 2, 6, 1, 3, 5, 2, 3, 2, 3, 2, 4, 10, 5, 3, 3, 2, 6, 4, 2, 2, 2, 2, 11, 7, 5, 3, 7, 3, 2, 1, 3, 2, 13, 1, 1, 4, 3, 5, 3, 8, 2, 10, 1, 4, 14, 6, 24, 8, 2, 3, 5, 2, 2, 2, 6, 1, 3, 1, 1, 4, 2, 1, 48, 2, 4, 7, 4, 3, 2, 2, 2, 3, 1, 7, 5, 3, 3, 2}},
    {"fy", {2, 4, 2, 3, 3, 40, 6, 2, 3, 5, 3, 2, 1, 2, 3, 3, 2, 3, 4, 3, 9, 2, 1, 4, 2, 4, 2, 2, 2, 2, 1, 8, 8, 1, 3, 3, 2, 4, 4, 4, 3, 4, 3, 3, 7, 2, 2, 4, 3, 3, 2, 4, 2, 13, 1, 4, 3, 2, 10, 2, 3, 2, 3, 3, 3, 1, 4, 2, 1, 3, 1, 5, 3, 2, 2, 1, 2, 2, 4, 2, 1, 2, 16, 4, 3, 3, 1, 17, 2, 2, 2, 2, 4, 2, 3, 3, 9, 2, 2, 3, 2, 3, 2, 3, 3, 2, 2, 2, 8, 2, 2, 4, 4, 3, 2, 1, 2, 3, 3, 5, 2, 3, 2, 2, 3, 2, 4, 4, 2, 2, 2, 3, 3, 2, 4, 4, 5, 3, 3, 3, 6, 3, 1, 3, 4, 3, 3, 2, 9, 4, 2, 2, 5, 4, 4, 4, 2, 6, 19, 6, 2, 4, 3, 2, 3, 3, 4, 2, 3, 5, 3, 6, 15, 4, 3, 3, 4, 5, 2, 2, 3, 2, 3, 1, 2, 3, 7, 3, 3, 8, 7, 2, 2, 2, 34, 2, 2, 2, 9, 16, 5, 3, 1, 5, 3, 3, 1, 2, 3, 5, 10, 4, 2, 3, 5, 4, 2, 2, 2, 2, 2, 2, 2, 3, 3, 4, 1, 2, 9, 3, 2, 2, 3, 2, 4, 3, 8, 4, 4, 8, 46, 17, 2, 2, 12, 2, 4, 4, 2, 2, 5, 3, 2, 3, 3, 4}},
    {"tt", {2, 18, 3, 2, 4, 3, 4, 3, 3, 18, 3, 4, 2, 3, 4, 3, 4, 3, 3, 14, 3, 4, 2, 5, 2, 4, 2, 3, 8, 2, 2, 1, 3, 4, 3, 2, 4, 2, 2, 4, 3, 2, 13, 2, 3, 5, 11, 7, 14, 4, 2, 2, 2, 8, 5, 3, 2, 3, 3, 6, 3, 6, 5, 8, 3, 4, 2, 4, 2, 2, 3, 15, 3, 2, 4, 3, 2, 4, 2, 7, 2, 3, 3, 2, 4, 2, 6, 2, 6, 3, 2, 4, 2, 3, 4, 12, 2, 2, 4, 2, 6, 6, 12, 1, 5, 2, 2, 3, 3, 4, 3, 2, 3, 2, 7, 3, 3, 3, 3, 2, 2, 3, 2, 2, 7, 2, 2, 2, 3, 5, 2, 4, 17, 3, 2, 3, 1, 3, 12, 2, 6, 2, 2, 4, 7, 3, 3, 4, 3, 2, 3, 7, 3, 8, 2, 4, 4, 2, 3, 5, 1, 6, 7, 4, 2, 3, 2, 3, 9, 4, 3, 2, 4, 2, 1, 2, 15, 2, 2, 2, 5, 5, 3, 2, 3, 3, 3, 6, 2, 3, 3, 3, 5, 3, 4, 3, 6, 2, 1, 2, 3, 2, 3, 3, 3, 2, 2, 2, 2, 3, 3, 6, 2, 2, 3, 4, 2, 3, 3, 3, 3, 2, 2, 3, 2, 2, 2, 2, 3, 2, 2, 3, 2, 7, 5, 5, 2, 2, 3, 2, 39, 3, 3, 40, 4, 2, 3, 2, 2, 3, 3, 3, 2, 4, 2, 4}},
    {"pa", {2, 2, 4, 2, 19, 2, 2, 1, 3, 4, 2, 9, 4, 5, 4, 3, 8, 6, 8, 2, 2, 6, 4, 4, 5, 6, 4, 2, 2, 2, 7, 2, 3, 3, 6, 6, 14, 2, 2, 2, 4, 2, 2, 6, 4, 3, 2, 3, 4, 2, 2, 3, 2, 2, 2, 3, 3, 2, 4, 5, 2, 15, 6, 4, 4, 2, 3, 15, 3, 3, 4, 3, 5, 2, 2, 3, 2, 2, 2, 6, 2, 3, 6, 3, 5, 2, 4, 3, 2, 2, 2, 2, 1, 4, 2, 5, 2, 5, 2, 2, 2, 1, 6, 2, 2, 6, 2, 2, 2, 3, 2, 3, 2, 3, 2, 3, 2, 1, 2, 3, 3, 2, 3, 3, 2, 3, 6, 2, 6, 4, 2, 3, 2, 7, 4, 2, 2, 2, 2, 4, 15, 2, 2, 3, 2, 9, 3, 6, 2, 3, 2, 2, 2, 20, 2, 2, 2, 2, 3, 3, 4, 3, 3, 7, 2, 2, 3, 2, 3, 2, 2, 2, 8, 9, 4, 4, 2, 2, 1, 2, 3, 3, 3, 1, 2, 3, 4, 12, 3, 2, 2, 2, 4, 6, 3, 3, 1, 3, 3, 8, 2, 3, 3, 2, 3, 4, 1, 1, 2, 3, 6, 2, 3, 2, 2, 18, 2, 2, 4, 8, 2, 1, 3, 3, 2, 9, 2, 2, 4, 2, 3, 2, 7, 3, 2, 4, 11, 2, 3, 3, 84, 5, 1, 6, 3, 13, 3, 4, 3, 2, 3, 3, 2, 3, 17, 7}},
    {"km", {4, 3, 2, 2, 2, 6, 3, 3, 4, 2, 4, 3, 5, 2, 3, 2, 2, 6, 6, 3, 5, 3, 4, 3, 2, 2, 11, 3, 4, 2, 3, 4, 3, 2, 3, 7, 2, 3, 2, 3, 3, 2, 2, 13, 3, 2, 3, 4, 3, 2, 2, 6, 2, 18, 3, 4, 2, 2, 3, 4, 5, 3, 17, 9, 3, 3, 2, 8, 3, 3, 2, 3, 4, 2, 3, 3, 3, 2, 2, 3, 2, 5, 3, 2, 3, 3, 3, 4, 3, 4, 2, 3, 2, 3, 22, 2, 6, 2, 9, 3, 2, 17, 4, 3, 8, 10, 2, 3, 3, 2, 4, 2, 2, 5, 4, 1, 4, 4, 3, 3, 2, 4, 3, 2, 3, 6, 3, 2, 3, 3, 4, 3, 3, 3, 4, 6, 3, 2, 4, 2, 6, 2, 2, 3, 4, 3, 3, 3, 4, 2, 2, 4, 3, 3, 3, 3, 3, 4, 8, 3, 3, 4, 4, 5, 3, 8, 3, 25, 2, 6, 3, 3, 6, 3, 2, 2, 3, 4, 3, 3, 4, 2, 3, 16, 2, 2, 3, 3, 2, 4, 3, 3, 3, 4, 4, 2, 3, 7, 3, 4, 3, 6, 3, 3, 14, 3, 3, 4, 2, 8, 3, 2, 2, 4, 4, 5, 3, 6, 2, 2, 2, 2, 5, 3, 4, 3, 3, 3, 4, 3, 3, 9, 8, 2, 2, 2, 4, 3, 4, 2, 24, 4, 2, 2, 3, 3, 3, 15, 4, 2, 3, 2, 2, 2, 12, 3}},
    {"tg", {5, 9, 2, 4, 3, 3, 3, 2, 4, 13, 2, 4, 1, 2, 2, 2, 4, 3, 3, 2, 2, 3, 3, 3, 2, 2, 2, 5, 6, 3, 1, 2, 1, 2, 2, 2, 5, 2, 3, 3, 3, 1, 12, 1, 3, 4, 26, 2, 2, 6, 2, 2, 2, 14, 7, 2, 3, 2, 3, 4, 2, 9, 3, 12, 5, 3, 3, 10, 4, 3, 2, 26, 3, 2, 2, 3, 3, 2, 2, 6, 3, 5, 3, 3, 5, 2, 13, 3, 6, 3, 2, 4, 2, 2, 3, 14, 3, 2, 3, 3, 4, 3, 18, 1, 7, 2, 2, 3, 1, 4, 2, 2, 2, 3, 3, 4, 2, 2, 3, 2, 2, 2, 4, 2, 5, 5, 3, 3, 3, 5, 1, 2, 6, 3, 2, 2, 3, 1, 11, 3, 7, 3, 4, 3, 4, 2, 2, 4, 6, 3, 7, 2, 1, 10, 1, 4, 3, 2, 3, 3, 3, 7, 6, 5, 3, 2, 3, 5, 8, 3, 2, 3, 2, 3, 2, 2, 8, 2, 6, 4, 2, 6, 3, 3, 2, 2, 3, 6, 2, 2, 2, 2, 5, 3, 3, 3, 5, 2, 1, 2, 13, 5, 3, 2, 3, 2, 2, 4, 3, 3, 3, 3, 2, 3, 5, 3, 2, 3, 4, 3, 2, 3, 3, 2, 2, 2, 1, 2, 6, 2, 2, 5, 5, 4, 4, 2, 3, 3, 3, 2, 46, 2, 3, 46, 3, 2, 3, 3, 4, 5, 2, 2, 2, 4, 2, 2}},
    {"sa", {2, 3, 4, 3, 2, 3, 3, 2, 2, 2, 3, 5, 2, 6, 2, 2, 3, 3, 2, 3, 3, 2, 4, 2, 5, 4, 7, 3, 4, 3, 2, 2, 4, 2, 4, 2, 3, 2, 2, 1, 4, 4, 3, 2, 4, 2, 3, 3, 5, 2, 19, 13, 3, 4, 2, 2, 10, 3, 4, 2, 6, 3, 4, 8, 5, 2, 2, 4, 3, 2, 7, 2, 2, 11, 1, 4, 2, 2, 3, 2, 3, 7, 3, 3, 4, 6, 7, 4, 2, 2, 4, 2, 3, 3, 3, 3, 3, 3, 2, 2, 6, 5, 20, 3, 3, 3, 7, 2, 2, 26, 3, 4, 2, 4, 3, 3, 8, 3, 2, 2, 4, 2, 3, 2, 2, 4, 4, 2, 4, 2, 2, 2, 2, 4, 7, 3, 2, 2, 2, 2, 4, 2, 8, 6, 9, 2, 4, 2, 3, 5, 3, 2, 3, 6, 4, 2, 14, 2, 4, 4, 3, 4, 2, 2, 6, 15, 3, 5, 4, 2, 2, 1, 12, 3, 3, 2, 3, 5, 2, 3, 3, 6, 2, 2, 7, 2, 3, 3, 6, 3, 2, 2, 5, 2, 3, 4, 2, 2, 2, 3, 3, 3, 5, 4, 5, 18, 4, 2, 6, 2, 25, 2, 2, 3, 2, 3, 5, 3, 4, 3, 2, 4, 2, 4, 3, 2, 2, 6, 2, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 52, 2, 5, 7, 3, 4, 2, 3, 2, 2, 3, 2, 4, 2, 12, 3}},
    {"ba", {5, 12, 3, 2, 4, 5, 2, 4, 3, 16, 3, 4, 3, 3, 3, 3, 5, 4, 3, 14, 8, 4, 2, 3, 2, 4, 4, 3, 5, 3, 2, 1, 2, 3, 2, 2, 4, 2, 1, 3, 3, 2, 14, 2, 4, 3, 11, 8, 16, 4, 2, 2, 2, 7, 6, 2, 2, 3, 2, 4, 3, 8, 4, 7, 3, 3, 2, 4, 2, 2, 3, 16, 3, 3, 3, 2, 2, 4, 2, 7, 2, 2, 2, 1, 4, 2, 6, 2, 4, 4, 2, 6, 2, 2, 3, 12, 2, 3, 4, 2, 6, 6, 11, 2, 5, 2, 1, 2, 2, 4, 3, 2, 3, 2, 6, 2, 2, 2, 2, 3, 3, 3, 3, 1, 7, 2, 3, 3, 4, 5, 2, 4, 15, 3, 2, 2, 2, 3, 12, 2, 7, 2, 3, 6, 5, 2, 3, 5, 3, 2, 3, 6, 2, 8, 2, 4, 5, 2, 3, 4, 2, 5, 7, 5, 2, 3, 2, 3, 9, 4, 3, 2, 4, 3, 1, 2, 14, 2, 2, 2, 5, 5, 3, 3, 3, 2, 2, 6, 2, 3, 4, 6, 4, 3, 4, 2, 6, 2, 1, 2, 3, 3, 4, 3, 2, 2, 2, 3, 2, 3, 2, 8, 2, 2, 2, 4, 2, 2, 3, 4, 2, 2, 3, 2, 2, 3, 3, 2, 5, 2, 2, 4, 2, 5, 5, 6, 3, 2, 2, 2, 38, 3, 4, 40, 3, 2, 2, 2, 2, 3, 3, 6, 3, 3, 2, 4}},
    {"io", {3, 2, 4, 5, 7, 40, 6, 3, 1, 1, 5, 2, 2, 3, 1, 4, 1, 1, 4, 5, 6, 2, 2, 10, 1, 3, 2, 3, 2, 2, 2, 6, 9, 3, 1, 1, 3, 4, 1, 5, 2, 2, 0, 2, 11, 3, 2, 4, 4, 3, 2, 3, 1, 5, 2, 1, 1, 10, 15, 3, 8, 4, 2, 8, 4, 3, 2, 1, 2, 2, 4, 4, 4, 3, 3, 5, 2, 3, 3, 2, 2, 2, 15, 4, 4, 6, 3, 18, 3, 1, 4, 3, 3, 2, 4, 2, 5, 2, 0, 3, 1, 2, 1, 3, 2, 2, 2, 2, 6, 3, 2, 7, 4, 2, 1, 1, 5, 3, 2, 3, 2, 11, 2, 1, 1, 2, 6, 3, 2, 3, 2, 3, 1, 2, 1, 1, 2, 6, 3, 3, 5, 4, 4, 2, 4, 2, 3, 2, 6, 7, 1, 4, 7, 2, 6, 4, 2, 4, 12, 1, 3, 5, 2, 2, 4, 2, 4, 2, 1, 8, 4, 9, 24, 6, 4, 3, 4, 5, 1, 3, 2, 2, 2, 2, 3, 2, 7, 1, 6, 6, 3, 1, 3, 2, 24, 3, 2, 2, 9, 17, 4, 2, 3, 5, 4, 3, 1, 2, 2, 2, 8, 8, 4, 3, 4, 7, 1, 1, 2, 1, 2, 2, 2, 2, 1, 6, 2, 2, 7, 2, 2, 5, 5, 3, 2, 4, 2, 2, 3, 4, 51, 26, 3, 4, 7, 2, 2, 2, 1, 1, 2, 12, 1, 4, 4, 4}},
    {"as", {3, 3, 2, 2, 3, 4, 3, 8, 3, 3, 2, 3, 2, 2, 13, 2, 7, 3, 2, 3, 5, 2, 2, 15, 2, 2, 2, 2, 10, 4, 3, 2, 33, 4, 2, 2, 2, 7, 4, 24, 4, 5, 2, 3, 3, 5, 3, 2, 16, 5, 2, 2, 2, 3, 2, 4, 4, 4, 4, 3, 8, 2, 2, 4, 2, 2, 5, 3, 2, 3, 3, 3, 3, 3, 3, 1, 3, 3, 9, 7, 6, 3, 3, 2, 3, 3, 3, 3, 2, 3, 4, 3, 2, 2, 4, 1, 3, 3, 2, 2, 2, 3, 3, 6, 5, 3, 4, 6, 2, 2, 7, 2, 4, 3, 3, 4, 2, 6, 3, 5, 2, 3, 3, 2, 12, 3, 4, 3, 2, 2, 6, 4, 17, 5, 2, 4, 4, 15, 9, 10, 2, 1, 4, 2, 2, 6, 2, 6, 2, 3, 2, 2, 4, 2, 4, 5, 2, 4, 2, 2, 4, 3, 4, 2, 3, 2, 3, 4, 2, 3, 4, 2, 2, 3, 2, 2, 5, 3, 7, 3, 3, 2, 2, 2, 6, 2, 2, 5, 2, 4, 3, 4, 2, 3, 4, 2, 3, 3, 3, 4, 3, 2, 3, 3, 2, 2, 3, 3, 4, 2, 2, 2, 2, 11, 3, 5, 2, 4, 3, 2, 4, 2, 1, 3, 3, 5, 15, 3, 1, 3, 2, 2, 4, 7, 12, 2, 4, 3, 3, 3, 59, 3, 3, 2, 3, 6, 3, 2, 3, 2, 3, 2, 2, 2, 3, 4}},
    {"vo", {5, 1, 6, 5, 5, 37, 8, 3, 2, 2, 2, 4, 0, 2, 0, 3, 9, 5, 1, 4, 5, 4, 1, 7, 1, 1, 1, 2, 1, 0, 1, 7, 2, 2, 2, 4, 2, 2, 1, 12, 5, 2, 2, 2, 6, 2, 4, 3, 1, 4, 1, 3, 1, 3, 1, 2, 1, 5, 26, 7, 3, 2, 9, 13, 3, 3, 2, 2, 1, 4, 1, 6, 1, 0, 2, 5, 3, 4, 1, 3, 1, 3, 3, 1, 4, 3, 4, 23, 1, 5, 2, 2, 6, 3, 5, 5, 4, 1, 1, 1, 5, 1, 5, 2, 5, 1, 0, 0, 6, 1, 0, 7, 1, 2, 1, 3, 1, 4, 3, 2, 5, 5, 1, 1, 2, 3, 2, 3, 3, 1, 1, 4, 3, 2, 3, 6, 1, 2, 1, 2, 2, 7, 1, 1, 2, 1, 6, 2, 2, 3, 2, 4, 16, 3, 1, 4, 0, 6, 13, 2, 3, 0, 5, 3, 4, 8, 4, 2, 1, 19, 4, 6, 24, 6, 1, 3, 4, 8, 0, 4, 0, 2, 3, 2, 1, 5, 10, 2, 1, 6, 6, 3, 3, 4, 21, 4, 2, 1, 2, 17, 15, 6, 1, 2, 6, 2, 4, 4, 2, 5, 8, 10, 2, 2, 0, 7, 1, 3, 2, 4, 0, 2, 0, 3, 0, 3, 4, 0, 6, 5, 1, 1, 3, 7, 4, 2, 1, 9, 2, 2, 55, 15, 2, 2, 6, 2, 3, 1, 1, 1, 1, 9, 2, 4, 1, 11}},
    {"ky", {2, 20, 2, 2, 3, 2, 3, 3, 3, 19, 3, 3, 2, 2, 2, 2, 5, 3, 2, 1, 2, 3, 2, 5, 2, 4, 2, 3, 9, 2, 2, 2, 2, 3, 2, 1, 3, 2, 3, 3, 3, 2, 15, 2, 3, 5, 13, 8, 14, 6, 2, 2, 3, 10, 5, 4, 1, 3, 3, 4, 3, 7, 4, 9, 3, 3, 3, 4, 3, 2, 2, 18, 3, 3, 4, 3, 2, 3, 2, 6, 3, 4, 2, 4, 4, 3, 7, 3, 5, 4, 2, 5, 3, 2, 2, 20, 2, 2, 4, 2, 9, 4, 10, 2, 5, 2, 2, 2, 2, 4, 2, 2, 2, 3, 4, 3, 2, 2, 2, 2, 3, 3, 2, 1, 10, 3, 3, 2, 3, 6, 4, 3, 12, 3, 1, 3, 1, 2, 6, 3, 7, 3, 3, 3, 5, 4, 2, 4, 2, 2, 4, 5, 2, 8, 2, 4, 4, 4, 3, 4, 2, 5, 9, 4, 2, 2, 2, 5, 11, 6, 2, 3, 3, 2, 2, 2, 13, 3, 3, 3, 4, 4, 2, 2, 2, 4, 2, 8, 3, 3, 2, 2, 4, 4, 4, 3, 5, 2, 2, 3, 4, 2, 3, 4, 2, 3, 3, 3, 6, 3, 2, 5, 2, 2, 3, 3, 3, 2, 3, 3, 4, 3, 2, 3, 1, 4, 2, 2, 4, 2, 2, 3, 2, 5, 6, 4, 2, 2, 2, 2, 37, 3, 3, 43, 2, 2, 3, 2, 3, 4, 3, 2, 3, 3, 3, 4}},
    {"so", {1, 2, 1, 3, 2, 68, 7, 3, 5, 6, 2, 4, 2, 1, 2, 4, 3, 2, 4, 3, 6, 3, 2, 5, 3, 2, 3, 2, 2, 3, 5, 4, 8, 1, 3, 3, 2, 3, 3, 4, 4, 2, 2, 4, 11, 3, 2, 8, 2, 4, 3, 14, 2, 5, 1, 2, 2, 5, 12, 5, 3, 3, 1, 2, 8, 3, 2, 2, 2, 4, 2, 3, 6, 3, 2, 2, 3, 3, 3, 3, 1, 7, 13, 4, 2, 4, 1, 21, 2, 1, 2, 2, 2, 5, 3, 1, 10, 1, 3, 2, 1, 2, 3, 5, 2, 1, 5, 1, 4, 2, 2, 5, 3, 2, 2, 3, 3, 2, 5, 3, 2, 16, 4, 2, 3, 1, 6, 5, 2, 2, 1, 2, 3, 3, 2, 4, 3, 2, 4, 3, 3, 3, 4, 1, 3, 2, 5, 2, 2, 7, 2, 2, 3, 2, 6, 2, 1, 4, 10, 4, 2, 3, 3, 2, 8, 2, 3, 2, 2, 4, 2, 6, 17, 5, 2, 2, 2, 5, 2, 1, 2, 2, 5, 2, 2, 2, 12, 3, 4, 3, 5, 4, 2, 2, 17, 4, 2, 2, 6, 10, 7, 2, 2, 4, 4, 3, 2, 3, 3, 2, 10, 8, 3, 2, 2, 7, 2, 2, 1, 1, 2, 4, 2, 7, 2, 4, 3, 1, 7, 4, 3, 3, 5, 4, 2, 2, 2, 5, 3, 2, 42, 18, 1, 2, 3, 4, 3, 2, 3, 1, 5, 7, 2, 3, 2, 4}},
    {"cv", {2, 15, 3, 2, 3, 3, 5, 3, 3, 20, 3, 5, 2, 3, 2, 2, 3, 3, 1, 2, 3, 3, 2, 3, 2, 5, 2, 3, 6, 3, 2, 2, 2, 2, 2, 6, 8, 2, 3, 6, 2, 2, 16, 2, 4, 5, 13, 3, 7, 2, 2, 2, 2, 4, 6, 3, 2, 2, 2, 3, 2, 5, 2, 9, 3, 3, 3, 4, 5, 2, 2, 8, 3, 2, 2, 3, 2, 3, 3, 6, 3, 5, 2, 2, 3, 2, 6, 3, 5, 4, 1, 3, 2, 4, 3, 11, 2, 2, 4, 2, 3, 8, 12, 2, 5, 2, 2, 2, 3, 3, 4, 2, 2, 2, 5, 2, 2, 2, 2, 4, 3, 12, 3, 2, 8, 4, 3, 3, 3, 2, 2, 2, 17, 4, 2, 2, 2, 2, 12, 2, 6, 3, 2, 4, 5, 3, 3, 5, 3, 3, 3, 3, 2, 8, 2, 5, 3, 2, 3, 3, 3, 7, 8, 5, 2, 3, 2, 4, 8, 5, 3, 14, 2, 3, 1, 4, 12, 4, 3, 3, 4, 7, 3, 2, 2, 5, 2, 7, 3, 2, 3, 2, 6, 3, 3, 2, 4, 2, 1, 2, 7, 2, 3, 4, 3, 2, 5, 3, 2, 2, 3, 5, 5, 3, 4, 2, 2, 2, 8, 2, 2, 3, 2, 3, 1, 2, 2, 3, 4, 4, 1, 4, 2, 4, 11, 3, 2, 3, 3, 2, 41, 3, 4, 37, 2, 5, 4, 3, 3, 3, 3, 2, 2, 3, 2, 2}},
    {"or", {7, 2, 2, 1, 4, 4, 4, 2, 3, 2, 3, 2, 30, 3, 2, 2, 5, 4, 3, 3, 1, 5, 2, 3, 3, 17, 10, 2, 2, 2, 2, 4, 6, 2, 8, 3, 4, 3, 3, 2, 4, 6, 2, 3, 6, 2, 4, 2, 5, 3, 4, 2, 3, 6, 4, 2, 9, 2, 2, 2, 6, 2, 2, 9, 2, 3, 4, 8, 2, 4, 4, 7, 2, 4, 2, 2, 2, 3, 2, 3, 4, 2, 6, 2, 3, 2, 4, 6, 3, 3, 3, 16, 4, 3, 4, 2, 2, 4, 12, 2, 4, 2, 3, 15, 5, 3, 6, 2, 2, 1, 3, 4, 4, 3, 5, 8, 3, 1, 2, 3, 3, 4, 10, 2, 6, 4, 2, 3, 14, 2, 5, 3, 3, 2, 2, 2, 4, 2, 2, 2, 6, 2, 2, 2, 4, 3, 4, 3, 2, 2, 2, 4, 4, 2, 3, 4, 3, 3, 15, 2, 3, 9, 3, 2, 5, 4, 2, 10, 2, 3, 2, 3, 8, 7, 3, 2, 2, 5, 3, 3, 3, 2, 3, 16, 3, 3, 2, 2, 2, 3, 4, 2, 3, 4, 3, 3, 2, 2, 2, 3, 6, 2, 2, 2, 5, 2, 1, 3, 6, 2, 3, 1, 3, 3, 3, 3, 2, 3, 4, 3, 2, 1, 8, 2, 1, 3, 2, 3, 2, 2, 2, 10, 5, 2, 2, 3, 6, 2, 4, 3, 64, 4, 2, 2, 3, 3, 4, 12, 2, 2, 5, 1, 3, 2, 7, 3}},
    {"ce", {3, 17, 3, 2, 2, 7, 3, 4, 2, 17, 2, 3, 3, 3, 4, 3, 5, 3, 1, 2, 2, 3, 2, 7, 2, 11, 1, 4, 6, 2, 3, 2, 1, 2, 3, 2, 14, 2, 2, 4, 3, 2, 11, 3, 4, 5, 15, 3, 4, 4, 2, 1, 2, 6, 3, 5, 2, 3, 2, 3, 6, 11, 3, 6, 3, 3, 3, 5, 3, 3, 3, 17, 3, 1, 2, 3, 2, 3, 3, 7, 2, 4, 3, 3, 3, 6, 9, 3, 7, 4, 2, 3, 2, 3, 3, 10, 2, 2, 6, 2, 5, 4, 10, 2, 5, 2, 2, 2, 2, 3, 3, 2, 2, 2, 3, 3, 3, 1, 2, 3, 3, 3, 2, 2, 10, 2, 4, 2, 5, 4, 3, 3, 13, 3, 3, 2, 2, 1, 7, 2, 8, 3, 2, 4, 10, 3, 2, 3, 2, 3, 4, 2, 3, 7, 2, 7, 3, 2, 4, 4, 2, 7, 6, 4, 2, 4, 4, 5, 14, 4, 2, 2, 3, 3, 1, 2, 13, 2, 3, 2, 3, 7, 2, 4, 2, 2, 2, 8, 3, 3, 2, 3, 4, 6, 3, 2, 6, 1, 2, 2, 3, 3, 3, 4, 2, 3, 2, 3, 3, 2, 2, 7, 2, 3, 2, 2, 3, 3, 3, 2, 4, 3, 2, 2, 2, 2, 2, 3, 3, 4, 3, 4, 3, 3, 5, 3, 3, 3, 3, 1, 40, 3, 3, 52, 3, 2, 2, 2, 2, 3, 2, 2, 3, 2, 2, 2}},
    {"mg", {4, 3, 2, 3, 1, 82, 4, 2, 1, 1, 5, 5, 1, 2, 2, 3, 2, 0, 9, 1, 12, 9, 3, 4, 2, 4, 2, 14, 1, 3, 1, 3, 3, 1, 1, 1, 4, 4, 3, 1, 0, 1, 4, 0, 4, 1, 0, 5, 2, 2, 3, 2, 1, 1, 2, 1, 0, 2, 10, 3, 5, 8, 8, 5, 1, 2, 4, 5, 1, 1, 2, 5, 2, 4, 2, 2, 3, 4, 2, 7, 1, 3, 15, 3, 0, 3, 0, 21, 2, 5, 1, 4, 1, 1, 6, 0, 10, 0, 0, 1, 2, 2, 2, 4, 1, 1, 0, 2, 6, 1, 2, 4, 5, 0, 1, 2, 3, 2, 7, 5, 2, 16, 4, 2, 2, 1, 1, 9, 8, 2, 0, 3, 5, 0, 1, 1, 1, 3, 3, 2, 2, 4, 1, 0, 4, 5, 2, 1, 3, 5, 1, 3, 1, 1, 3, 3, 3, 7, 12, 1, 3, 1, 7, 6, 3, 3, 1, 6, 0, 9, 3, 16, 19, 3, 4, 1, 3, 2, 2, 2, 0, 1, 5, 3, 1, 2, 16, 0, 6, 6, 8, 2, 1, 1, 11, 1, 1, 3, 5, 10, 3, 0, 6, 6, 3, 5, 1, 1, 4, 3, 5, 5, 5, 0, 1, 4, 2, 2, 2, 1, 2, 1, 2, 2, 1, 4, 2, 3, 15, 3, 3, 9, 4, 2, 5, 3, 5, 5, 6, 3, 44, 25, 2, 1, 6, 4, 1, 2, 1, 1, 2, 4, 3, 1, 1, 8}},
    {"ps", {4, 2, 2, 2, 1, 6, 2, 2, 2, 3, 2, 3, 2, 3, 2, 3, 4, 2, 3, 4, 2, 2, 3, 2, 3, 8, 2, 5, 3, 2, 2, 7, 3, 8, 2, 6, 8, 3, 1, 2, 2, 24, 3, 5, 2, 11, 2, 15, 4, 2, 9, 2, 2, 3, 2, 5, 3, 3, 4, 2, 3, 6, 2, 9, 2, 3, 2, 3, 9, 2, 9, 2, 6, 2, 10, 3, 2, 2, 2, 6, 5, 2, 2, 3, 4, 3, 3, 5, 2, 4, 3, 2, 2, 2, 3, 4, 4, 7, 3, 3, 3, 3, 3, 2, 5, 3, 4, 18, 3, 2, 3, 2, 2, 2, 4, 2, 2, 3, 2, 2, 3, 4, 1, 16, 2, 2, 3, 2, 2, 2, 2, 5, 4, 2, 4, 3, 2, 2, 3, 2, 3, 5, 2, 7, 2, 3, 2, 4, 6, 3, 3, 3, 2, 4, 2, 3, 2, 15, 2, 5, 2, 2, 21, 3, 3, 4, 2, 3, 2, 4, 4, 2, 3, 2, 4, 12, 2, 2, 2, 2, 4, 4, 4, 3, 3, 9, 3, 3, 2, 10, 5, 5, 3, 2, 3, 2, 5, 2, 10, 2, 3, 4, 3, 2, 7, 2, 2, 3, 2, 2, 2, 1, 4, 2, 2, 3, 10, 3, 2, 2, 3, 2, 2, 14, 3, 2, 3, 2, 2, 3, 5, 2, 4, 2, 5, 2, 3, 4, 3, 3, 58, 3, 3, 7, 3, 3, 12, 2, 2, 2, 2, 3, 6, 4, 3, 22}},
    {"fo", {5, 3, 2, 2, 3, 39, 5, 2, 2, 2, 3, 3, 2, 3, 2, 8, 2, 3, 3, 2, 6, 8, 2, 4, 2, 2, 2, 2, 5, 2, 1, 5, 11, 1, 2, 4, 2, 3, 2, 6, 2, 1, 2, 3, 14, 3, 3, 5, 2, 3, 2, 3, 2, 7, 5, 2, 3, 5, 12, 2, 5, 4, 3, 4, 3, 2, 2, 2, 1, 2, 2, 5, 6, 3, 3, 5, 2, 2, 2, 2, 2, 3, 22, 2, 3, 5, 1, 15, 2, 3, 2, 7, 2, 3, 4, 2, 9, 2, 1, 2, 3, 4, 3, 4, 2, 3, 2, 2, 4, 2, 4, 6, 2, 2, 2, 2, 5, 2, 4, 8, 4, 5, 2, 2, 3, 2, 5, 6, 4, 2, 3, 2, 3, 2, 2, 2, 2, 9, 2, 3, 4, 2, 3, 2, 3, 2, 4, 3, 3, 4, 2, 2, 2, 2, 3, 2, 3, 6, 17, 2, 2, 2, 3, 2, 4, 3, 3, 3, 2, 4, 2, 6, 12, 3, 4, 3, 3, 4, 2, 2, 4, 3, 4, 3, 3, 3, 6, 1, 4, 6, 5, 5, 2, 2, 16, 2, 2, 2, 6, 14, 5, 2, 3, 6, 3, 3, 2, 3, 2, 3, 10, 4, 7, 3, 2, 7, 3, 2, 2, 2, 2, 3, 2, 4, 4, 4, 2, 2, 11, 3, 2, 4, 3, 1, 4, 5, 5, 3, 5, 3, 46, 21, 2, 5, 3, 1, 6, 3, 3, 2, 3, 3, 3, 2, 3, 7}},
    {"bo", {3, 3, 4, 3, 2, 2, 2, 5, 6, 4, 3, 2, 4, 5, 2, 2, 3, 4, 4, 3, 3, 2, 5, 3, 4, 5, 2, 1, 2, 3, 3, 4, 3, 4, 3, 3, 2, 2, 4, 2, 2, 2, 3, 2, 3, 2, 6, 26, 4, 2, 5, 2, 2, 2, 2, 4, 3, 21, 1, 3, 2, 7, 6, 7, 2, 6, 26, 2, 2, 3, 2, 2, 2, 2, 2, 4, 2, 3, 4, 42, 2, 3, 2, 2, 2, 4, 2, 3, 3, 2, 3, 2, 2, 3, 2, 4, 2, 2, 2, 2, 2, 4, 15, 3, 3, 5, 6, 3, 6, 2, 4, 3, 2, 2, 2, 2, 3, 3, 2, 2, 4, 4, 4, 3, 3, 11, 2, 2, 3, 3, 2, 2, 2, 3, 2, 4, 2, 16, 4, 5, 2, 5, 4, 3, 2, 5, 3, 2, 3, 3, 3, 3, 2, 3, 2, 4, 4, 9, 2, 5, 6, 2, 5, 3, 3, 3, 6, 2, 3, 2, 4, 4, 3, 3, 2, 2, 4, 2, 22, 3, 3, 2, 3, 4, 2, 3, 3, 2, 3, 4, 1, 2, 2, 3, 2, 2, 2, 4, 2, 2, 2, 5, 5, 7, 2, 1, 3, 2, 7, 6, 3, 5, 25, 5, 5, 3, 3, 3, 3, 3, 2, 4, 2, 3, 18, 2, 3, 2, 5, 3, 2, 4, 2, 2, 18, 3, 2, 5, 2, 2, 12, 3, 4, 2, 7, 2, 2, 2, 7, 13, 3, 6, 3, 4, 3, 3}},
    {"gd", {2, 2, 1, 3, 2, 66, 3, 3, 2, 2, 2, 3, 2, 3, 2, 10, 3, 2, 4, 2, 15, 5, 2, 3, 2, 1, 1, 2, 1, 1, 3, 4, 10, 2, 4, 2, 1, 5, 3, 4, 2, 1, 1, 2, 8, 2, 3, 3, 4, 3, 1, 4, 1, 11, 2, 4, 2, 1, 11, 2, 2, 2, 2, 3, 1, 4, 7, 4, 1, 2, 2, 5, 4, 3, 1, 4, 3, 4, 5, 2, 1, 3, 13, 3, 3, 6, 1, 20, 2, 3, 4, 2, 4, 8, 5, 2, 22, 1, 1, 2, 2, 2, 1, 4, 9, 2, 3, 3, 4, 1, 1, 8, 3, 3, 2, 3, 1, 3, 13, 8, 3, 13, 3, 3, 3, 2, 11, 5, 3, 2, 2, 3, 2, 2, 2, 3, 2, 2, 4, 3, 2, 3, 3, 3, 3, 3, 4, 1, 3, 3, 2, 2, 7, 1, 5, 2, 2, 5, 10, 6, 2, 2, 4, 2, 6, 2, 2, 2, 2, 7, 1, 4, 13, 4, 2, 2, 2, 2, 1, 3, 3, 2, 2, 2, 2, 2, 3, 1, 3, 3, 3, 2, 2, 3, 15, 2, 2, 2, 4, 11, 7, 2, 2, 3, 3, 3, 1, 2, 4, 7, 4, 3, 5, 3, 2, 6, 3, 3, 3, 2, 3, 3, 2, 4, 2, 3, 1, 1, 8, 4, 2, 4, 9, 1, 2, 3, 2, 4, 4, 3, 51, 20, 1, 2, 8, 1, 6, 2, 2, 2, 3, 4, 5, 2, 2, 3}},
    {"tk", {2, 4, 3, 2, 4, 46, 5, 3, 3, 6, 4, 5, 2, 2, 2, 5, 3, 2, 2, 3, 7, 5, 2, 6, 3, 3, 2, 2, 2, 2, 2, 2, 10, 1, 2, 4, 2, 4, 2, 2, 2, 2, 2, 2, 7, 3, 4, 4, 3, 4, 2, 2, 1, 6, 2, 3, 1, 5, 20, 5, 2, 3, 4, 5, 6, 3, 3, 2, 2, 1, 2, 5, 3, 3, 3, 2, 3, 3, 2, 4, 2, 6, 18, 4, 3, 3, 1, 26, 2, 2, 2, 3, 2, 3, 5, 3, 7, 2, 2, 3, 2, 2, 3, 3, 2, 2, 4, 4, 5, 2, 3, 4, 5, 3, 3, 4, 3, 1, 3, 5, 2, 6, 3, 3, 2, 2, 3, 5, 3, 2, 3, 2, 2, 2, 7, 2, 3, 3, 4, 2, 3, 4, 3, 3, 5, 3, 3, 3, 6, 3, 2, 2, 3, 3, 3, 4, 1, 4, 12, 4, 4, 3, 2, 1, 5, 4, 3, 2, 2, 6, 2, 9, 11, 4, 4, 2, 3, 4, 2, 2, 5, 3, 3, 2, 2, 2, 17, 2, 4, 10, 2, 5, 2, 1, 18, 2, 4, 1, 4, 9, 7, 3, 2, 3, 2, 2, 2, 3, 2, 3, 11, 3, 3, 3, 2, 8, 4, 3, 3, 3, 3, 2, 2, 2, 3, 2, 2, 2, 11, 3, 2, 3, 7, 2, 2, 3, 3, 5, 4, 5, 37, 18, 2, 3, 6, 1, 2, 2, 4, 2, 5, 4, 2, 2, 4, 4}},
    {"dv", {3, 4, 2, 3, 2, 3, 2, 3, 2, 4, 3, 11, 2, 3, 3, 2, 4, 2, 4, 2, 2, 3, 3, 2, 25, 3, 9, 3, 4, 3, 2, 4, 3, 3, 11, 3, 3, 3, 4, 1, 1, 4, 3, 3, 3, 2, 3, 2, 12, 2, 3, 32, 8, 2, 9, 2, 3, 4, 1, 2, 12, 2, 2, 6, 4, 17, 3, 3, 3, 11, 2, 3, 2, 5, 3, 3, 2, 2, 5, 3, 2, 2, 4, 3, 3, 3, 3, 3, 5, 3, 4, 2, 2, 2, 3, 5, 1, 2, 4, 4, 7, 3, 3, 5, 2, 7, 3, 2, 2, 3, 5, 2, 4, 3, 2, 3, 3, 2, 3, 5, 3, 2, 2, 3, 3, 3, 1, 2, 3, 4, 8, 3, 7, 4, 3, 14, 3, 2, 2, 2, 2, 4, 5, 2, 4, 2, 2, 2, 3, 2, 2, 5, 2, 2, 2, 2, 2, 4, 3, 2, 2, 2, 3, 3, 7, 2, 1, 2, 3, 3, 3, 3, 1, 3, 16, 2, 4, 2, 2, 3, 2, 5, 4, 9, 2, 2, 3, 3, 3, 4, 2, 1, 1, 1, 3, 3, 6, 2, 4, 5, 2, 2, 3, 3, 2, 2, 5, 2, 18, 3, 1, 3, 2, 10, 3, 4, 1, 8, 4, 2, 1, 2, 2, 3, 2, 4, 4, 2, 5, 2, 3, 3, 3, 2, 2, 3, 5, 3, 18, 2, 58, 2, 3, 2, 2, 16, 17, 3, 2, 5, 2, 4, 10, 3, 3, 2}},
    {"sc", {2, 2, 2, 3, 5, 43, 4, 3, 1, 2, 3, 2, 1, 4, 2, 3, 2, 2, 4, 3, 5, 2, 2, 7, 2, 2, 1, 3, 1, 1, 2, 4, 6, 2, 3, 2, 2, 4, 3, 4, 2, 2, 1, 3, 16, 4, 2, 11, 3, 5, 2, 2, 1, 7, 2, 1, 2, 3, 9, 2, 6, 3, 2, 2, 3, 2, 2, 1, 2, 2, 2, 4, 3, 2, 4, 4, 2, 2, 2, 2, 1, 4, 15, 4, 2, 3, 2, 21, 2, 1, 2, 2, 3, 8, 5, 3, 8, 2, 1, 2, 1, 1, 5, 3, 3, 3, 4, 2, 9, 2, 1, 6, 4, 4, 3, 1, 1, 4, 5, 1, 2, 12, 2, 1, 4, 3, 9, 4, 2, 2, 1, 2, 2, 2, 2, 1, 2, 3, 3, 4, 5, 2, 2, 3, 4, 4, 6, 2, 3, 3, 2, 2, 8, 2, 5, 1, 1, 7, 18, 2, 1, 3, 5, 2, 4, 2, 3, 2, 3, 8, 2, 4, 18, 6, 3, 3, 6, 3, 2, 2, 2, 3, 2, 1, 1, 2, 4, 1, 4, 5, 6, 3, 2, 3, 23, 1, 3, 1, 7, 31, 4, 2, 1, 10, 3, 4, 2, 2, 2, 3, 3, 3, 3, 2, 7, 6, 1, 2, 2, 2, 2, 4, 3, 3, 3, 4, 2, 1, 9, 6, 1, 4, 2, 1, 2, 2, 6, 2, 4, 4, 46, 20, 1, 2, 12, 2, 6, 2, 1, 2, 4, 5, 3, 2, 4, 5}},
    {"mt", {3, 3, 2, 2, 4, 41, 5, 2, 3, 5, 4, 2, 2, 2, 3, 6, 2, 4, 4, 4, 5, 3, 4, 4, 2, 2, 2, 4, 1, 1, 4, 7, 6, 2, 2, 2, 2, 6, 3, 3, 2, 2, 2, 2, 12, 2, 3, 10, 2, 8, 2, 4, 1, 5, 2, 2, 2, 7, 20, 3, 5, 4, 5, 3, 4, 3, 3, 2, 1, 3, 2, 9, 3, 3, 3, 2, 3, 1, 2, 2, 2, 4, 14, 3, 3, 6, 1, 16, 2, 2, 2, 3, 3, 3, 8, 2, 6, 3, 1, 2, 2, 2, 3, 4, 2, 2, 3, 4, 4, 2, 4, 6, 3, 2, 3, 2, 3, 2, 3, 4, 2, 12, 2, 2, 3, 2, 4, 8, 2, 2, 2, 4, 3, 2, 3, 2, 2, 4, 3, 3, 5, 3, 3, 2, 2, 3, 6, 2, 5, 3, 3, 3, 3, 3, 6, 3, 3, 6, 21, 3, 2, 2, 2, 2, 5, 3, 4, 3, 2, 4, 2, 3, 14, 3, 3, 3, 2, 3, 2, 3, 2, 5, 3, 1, 2, 4, 5, 2, 4, 5, 6, 3, 2, 2, 18, 2, 3, 1, 5, 10, 6, 3, 2, 4, 5, 2, 2, 4, 4, 2, 9, 7, 5, 2, 2, 9, 1, 2, 2, 2, 2, 3, 2, 2, 3, 3, 2, 2, 7, 4, 2, 5, 3, 2, 3, 2, 5, 4, 4, 4, 38, 27, 2, 3, 3, 2, 2, 2, 2, 2, 4, 7, 3, 2, 4, 6}},
    {"ug", {3, 2, 1, 2, 1, 5, 2, 4, 2, 6, 2, 6, 4, 1, 5, 5, 2, 2, 3, 4, 4, 5, 2, 2, 2, 4, 2, 3, 5, 4, 2, 10, 3, 8, 10, 2, 2, 8, 5, 3, 2, 7, 17, 2, 9, 7, 6, 12, 3, 3, 2, 3, 5, 2, 2, 4, 2, 3, 3, 3, 2, 3, 2, 14, 2, 2, 3, 3, 11, 3, 7, 2, 4, 2, 9, 8, 6, 2, 6, 2, 12, 2, 2, 4, 3, 2, 4, 4, 3, 3, 2, 2, 3, 2, 8, 6, 4, 8, 8, 6, 4, 3, 3, 1, 5, 2, 3, 3, 2, 2, 3, 2, 7, 2, 3, 2, 2, 2, 2, 2, 4, 4, 2, 2, 3, 4, 3, 5, 2, 2, 2, 5, 3, 2, 6, 5, 1, 5, 2, 2, 3, 3, 2, 5, 2, 5, 2, 8, 1, 1, 6, 3, 5, 3, 3, 4, 2, 13, 3, 2, 2, 2, 21, 1, 3, 2, 2, 2, 2, 3, 2, 2, 4, 2, 4, 2, 2, 3, 4, 2, 4, 2, 2, 2, 2, 35, 3, 3, 8, 2, 3, 3, 3, 3, 2, 1, 5, 4, 12, 2, 4, 5, 2, 2, 2, 3, 3, 4, 3, 4, 3, 2, 3, 3, 3, 2, 3, 4, 3, 3, 3, 2, 3, 16, 2, 3, 2, 3, 4, 3, 4, 4, 3, 4, 2, 2, 2, 3, 3, 2, 35, 5, 3, 2, 2, 4, 14, 3, 3, 3, 3, 3, 1, 2, 5, 14}},
    {"rm", {5, 3, 2, 3, 3, 51, 4, 2, 2, 3, 5, 2, 2, 3, 3, 5, 2, 1, 4, 2, 5, 3, 3, 6, 2, 2, 1, 3, 2, 1, 3, 4, 9, 3, 2, 2, 2, 3, 3, 6, 3, 2, 1, 3, 15, 4, 3, 5, 2, 3, 4, 2, 1, 8, 2, 3, 2, 3, 17, 3, 6, 6, 3, 2, 1, 3, 2, 2, 1, 2, 3, 3, 3, 2, 3, 3, 2, 1, 2, 2, 2, 4, 16, 6, 3, 4, 1, 20, 1, 2, 1, 2, 2, 7, 5, 2, 9, 1, 1, 4, 1, 1, 2, 3, 3, 4, 2, 2, 4, 2, 2, 4, 5, 3, 1, 2, 2, 2, 3, 5, 2, 15, 2, 1, 3, 4, 13, 5, 2, 2, 2, 1, 2, 6, 2, 3, 6, 5, 3, 2, 4, 2, 2, 3, 3, 3, 3, 2, 5, 4, 3, 2, 9, 2, 4, 2, 2, 5, 20, 4, 2, 3, 2, 3, 5, 3, 2, 2, 1, 8, 2, 5, 14, 7, 3, 2, 2, 3, 2, 2, 2, 3, 4, 2, 2, 2, 4, 1, 3, 7, 5, 3, 1, 1, 19, 1, 2, 2, 8, 20, 4, 2, 2, 6, 3, 4, 2, 2, 2, 4, 3, 7, 3, 3, 2, 10, 2, 1, 2, 2, 2, 3, 1, 3, 2, 4, 2, 1, 8, 4, 1, 4, 4, 2, 3, 2, 4, 2, 4, 5, 46, 20, 2, 3, 3, 1, 3, 2, 1, 1, 3, 4, 3, 2, 5, 4}},
    {"ha", {2, 4, 2, 2, 3, 73, 6, 4, 3, 7, 2, 3, 2, 2, 2, 4, 3, 2, 7, 1, 11, 3, 2, 3, 3, 2, 1, 1, 1, 1, 2, 4, 5, 1, 4, 6, 1, 5, 3, 2, 1, 2, 2, 2, 10, 1, 2, 6, 4, 4, 3, 3, 1, 11, 2, 2, 2, 6, 9, 7, 3, 4, 4, 6, 9, 4, 2, 1, 1, 1, 3, 4, 3, 3, 2, 3, 3, 1, 2, 4, 2, 6, 13, 6, 4, 4, 1, 19, 3, 1, 1, 2, 3, 6, 7, 1, 8, 0, 1, 1, 2, 2, 3, 5, 5, 1, 3, 1, 4, 2, 3, 6, 3, 3, 2, 1, 2, 3, 6, 6, 1, 21, 2, 2, 3, 2, 7, 9, 1, 2, 1, 3, 3, 5, 2, 3, 6, 2, 4, 2, 3, 3, 3, 3, 2, 3, 3, 2, 4, 2, 1, 2, 3, 2, 3, 2, 1, 3, 14, 4, 3, 3, 5, 2, 5, 3, 3, 3, 3, 6, 1, 2, 9, 5, 3, 1, 1, 3, 2, 2, 2, 3, 3, 3, 1, 5, 9, 2, 4, 4, 4, 6, 2, 1, 11, 2, 2, 1, 7, 11, 6, 2, 2, 6, 4, 3, 2, 5, 2, 2, 11, 6, 2, 2, 2, 4, 3, 1, 3, 2, 3, 3, 2, 3, 2, 2, 3, 2, 15, 4, 3, 4, 3, 3, 2, 3, 2, 4, 4, 2, 50, 19, 1, 1, 6, 1, 3, 2, 2, 1, 2, 5, 2, 1, 3, 5}},
    {"sd", {3, 2, 2, 1, 2, 9, 4, 2, 2, 4, 2, 5, 3, 2, 4, 3, 2, 2, 10, 3, 4, 2, 3, 2, 3, 5, 3, 6, 3, 2, 2, 7, 8, 17, 2, 3, 2, 2, 1, 3, 2, 17, 3, 7, 2, 4, 2, 10, 3, 3, 2, 2, 2, 3, 4, 3, 2, 4, 5, 2, 2, 4, 3, 13, 2, 2, 3, 5, 8, 3, 6, 2, 5, 2, 10, 3, 3, 2, 2, 6, 5, 4, 3, 5, 3, 2, 3, 3, 3, 2, 6, 2, 2, 2, 3, 11, 2, 7, 4, 5, 2, 3, 3, 2, 4, 4, 3, 13, 1, 3, 4, 4, 2, 3, 2, 3, 2, 4, 2, 2, 5, 4, 2, 4, 2, 2, 3, 2, 4, 3, 2, 4, 7, 2, 6, 5, 2, 3, 5, 4, 3, 4, 3, 6, 2, 3, 2, 4, 4, 2, 3, 3, 3, 2, 2, 3, 2, 15, 2, 4, 2, 1, 24, 2, 9, 2, 2, 2, 1, 2, 3, 3, 5, 4, 2, 4, 2, 3, 1, 2, 5, 6, 3, 3, 3, 7, 3, 6, 2, 8, 5, 3, 2, 2, 3, 2, 5, 3, 9, 3, 2, 7, 2, 3, 3, 3, 2, 3, 2, 2, 3, 2, 5, 3, 2, 3, 3, 4, 3, 1, 2, 3, 2, 10, 3, 2, 1, 1, 2, 3, 2, 3, 2, 2, 2, 3, 3, 2, 3, 5, 59, 3, 3, 3, 3, 2, 20, 2, 3, 3, 2, 3, 2, 4, 2, 31}}
};

#define N_LANGS sizeof(LANGS) / sizeof(lang_t)

#endif  // RESILIPARSE_LANG_PROFILES_H
