# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AnalyzeOperationResult(msrest.serialization.Model):
    """Status and result of the queued analyze operation.

    All required parameters must be populated in order to send to Azure.

    :ivar status: Required. Operation status. Possible values include: "notStarted", "running",
     "succeeded", "failed".
    :vartype status: str or ~azure.ai.formrecognizer.v2_0.models.OperationStatus
    :ivar created_date_time: Required. Date and time (UTC) when the analyze operation was
     submitted.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_updated_date_time: Required. Date and time (UTC) when the status was last updated.
    :vartype last_updated_date_time: ~datetime.datetime
    :ivar analyze_result: Results of the analyze operation.
    :vartype analyze_result: ~azure.ai.formrecognizer.v2_0.models.AnalyzeResult
    """

    _validation = {
        'status': {'required': True},
        'created_date_time': {'required': True},
        'last_updated_date_time': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_updated_date_time': {'key': 'lastUpdatedDateTime', 'type': 'iso-8601'},
        'analyze_result': {'key': 'analyzeResult', 'type': 'AnalyzeResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword status: Required. Operation status. Possible values include: "notStarted", "running",
         "succeeded", "failed".
        :paramtype status: str or ~azure.ai.formrecognizer.v2_0.models.OperationStatus
        :keyword created_date_time: Required. Date and time (UTC) when the analyze operation was
         submitted.
        :paramtype created_date_time: ~datetime.datetime
        :keyword last_updated_date_time: Required. Date and time (UTC) when the status was last
         updated.
        :paramtype last_updated_date_time: ~datetime.datetime
        :keyword analyze_result: Results of the analyze operation.
        :paramtype analyze_result: ~azure.ai.formrecognizer.v2_0.models.AnalyzeResult
        """
        super(AnalyzeOperationResult, self).__init__(**kwargs)
        self.status = kwargs['status']
        self.created_date_time = kwargs['created_date_time']
        self.last_updated_date_time = kwargs['last_updated_date_time']
        self.analyze_result = kwargs.get('analyze_result', None)


class AnalyzeResult(msrest.serialization.Model):
    """Analyze operation result.

    All required parameters must be populated in order to send to Azure.

    :ivar version: Required. Version of schema used for this result.
    :vartype version: str
    :ivar read_results: Required. Text extracted from the input.
    :vartype read_results: list[~azure.ai.formrecognizer.v2_0.models.ReadResult]
    :ivar page_results: Page-level information extracted from the input.
    :vartype page_results: list[~azure.ai.formrecognizer.v2_0.models.PageResult]
    :ivar document_results: Document-level information extracted from the input.
    :vartype document_results: list[~azure.ai.formrecognizer.v2_0.models.DocumentResult]
    :ivar errors: List of errors reported during the analyze operation.
    :vartype errors: list[~azure.ai.formrecognizer.v2_0.models.ErrorInformation]
    """

    _validation = {
        'version': {'required': True},
        'read_results': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'read_results': {'key': 'readResults', 'type': '[ReadResult]'},
        'page_results': {'key': 'pageResults', 'type': '[PageResult]'},
        'document_results': {'key': 'documentResults', 'type': '[DocumentResult]'},
        'errors': {'key': 'errors', 'type': '[ErrorInformation]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword version: Required. Version of schema used for this result.
        :paramtype version: str
        :keyword read_results: Required. Text extracted from the input.
        :paramtype read_results: list[~azure.ai.formrecognizer.v2_0.models.ReadResult]
        :keyword page_results: Page-level information extracted from the input.
        :paramtype page_results: list[~azure.ai.formrecognizer.v2_0.models.PageResult]
        :keyword document_results: Document-level information extracted from the input.
        :paramtype document_results: list[~azure.ai.formrecognizer.v2_0.models.DocumentResult]
        :keyword errors: List of errors reported during the analyze operation.
        :paramtype errors: list[~azure.ai.formrecognizer.v2_0.models.ErrorInformation]
        """
        super(AnalyzeResult, self).__init__(**kwargs)
        self.version = kwargs['version']
        self.read_results = kwargs['read_results']
        self.page_results = kwargs.get('page_results', None)
        self.document_results = kwargs.get('document_results', None)
        self.errors = kwargs.get('errors', None)


class CopyAuthorizationResult(msrest.serialization.Model):
    """Request parameter that contains authorization claims for copy operation.

    All required parameters must be populated in order to send to Azure.

    :ivar model_id: Required. Model identifier.
    :vartype model_id: str
    :ivar access_token: Required. Token claim used to authorize the request.
    :vartype access_token: str
    :ivar expiration_date_time_ticks: Required. The time when the access token expires. The date is
     represented as the number of seconds from 1970-01-01T0:0:0Z UTC until the expiration time.
    :vartype expiration_date_time_ticks: long
    """

    _validation = {
        'model_id': {'required': True},
        'access_token': {'required': True},
        'expiration_date_time_ticks': {'required': True},
    }

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
        'access_token': {'key': 'accessToken', 'type': 'str'},
        'expiration_date_time_ticks': {'key': 'expirationDateTimeTicks', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword model_id: Required. Model identifier.
        :paramtype model_id: str
        :keyword access_token: Required. Token claim used to authorize the request.
        :paramtype access_token: str
        :keyword expiration_date_time_ticks: Required. The time when the access token expires. The date
         is represented as the number of seconds from 1970-01-01T0:0:0Z UTC until the expiration time.
        :paramtype expiration_date_time_ticks: long
        """
        super(CopyAuthorizationResult, self).__init__(**kwargs)
        self.model_id = kwargs['model_id']
        self.access_token = kwargs['access_token']
        self.expiration_date_time_ticks = kwargs['expiration_date_time_ticks']


class CopyOperationResult(msrest.serialization.Model):
    """Status and result of the queued copy operation.

    All required parameters must be populated in order to send to Azure.

    :ivar status: Required. Operation status. Possible values include: "notStarted", "running",
     "succeeded", "failed".
    :vartype status: str or ~azure.ai.formrecognizer.v2_0.models.OperationStatus
    :ivar created_date_time: Required. Date and time (UTC) when the copy operation was submitted.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_updated_date_time: Required. Date and time (UTC) when the status was last updated.
    :vartype last_updated_date_time: ~datetime.datetime
    :ivar copy_result: Results of the copy operation.
    :vartype copy_result: ~azure.ai.formrecognizer.v2_0.models.CopyResult
    """

    _validation = {
        'status': {'required': True},
        'created_date_time': {'required': True},
        'last_updated_date_time': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_updated_date_time': {'key': 'lastUpdatedDateTime', 'type': 'iso-8601'},
        'copy_result': {'key': 'copyResult', 'type': 'CopyResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword status: Required. Operation status. Possible values include: "notStarted", "running",
         "succeeded", "failed".
        :paramtype status: str or ~azure.ai.formrecognizer.v2_0.models.OperationStatus
        :keyword created_date_time: Required. Date and time (UTC) when the copy operation was
         submitted.
        :paramtype created_date_time: ~datetime.datetime
        :keyword last_updated_date_time: Required. Date and time (UTC) when the status was last
         updated.
        :paramtype last_updated_date_time: ~datetime.datetime
        :keyword copy_result: Results of the copy operation.
        :paramtype copy_result: ~azure.ai.formrecognizer.v2_0.models.CopyResult
        """
        super(CopyOperationResult, self).__init__(**kwargs)
        self.status = kwargs['status']
        self.created_date_time = kwargs['created_date_time']
        self.last_updated_date_time = kwargs['last_updated_date_time']
        self.copy_result = kwargs.get('copy_result', None)


class CopyRequest(msrest.serialization.Model):
    """Request parameter to copy an existing custom model from the source resource to a target resource referenced by the resource ID.

    All required parameters must be populated in order to send to Azure.

    :ivar target_resource_id: Required. Azure Resource Id of the target Form Recognizer resource
     where the model is copied to.
    :vartype target_resource_id: str
    :ivar target_resource_region: Required. Location of the target Azure resource. A valid Azure
     region name supported by Cognitive Services.
    :vartype target_resource_region: str
    :ivar copy_authorization: Required. Entity that encodes claims to authorize the copy request.
    :vartype copy_authorization: ~azure.ai.formrecognizer.v2_0.models.CopyAuthorizationResult
    """

    _validation = {
        'target_resource_id': {'required': True, 'max_length': 1024, 'min_length': 0, 'pattern': r'^/subscriptions/[^/]*/resourceGroups/[^/]*/providers/Microsoft.CognitiveServices/accounts/[^/]*$'},
        'target_resource_region': {'required': True, 'max_length': 24, 'min_length': 1, 'pattern': r'^[a-z0-9]+$'},
        'copy_authorization': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
        'target_resource_region': {'key': 'targetResourceRegion', 'type': 'str'},
        'copy_authorization': {'key': 'copyAuthorization', 'type': 'CopyAuthorizationResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword target_resource_id: Required. Azure Resource Id of the target Form Recognizer resource
         where the model is copied to.
        :paramtype target_resource_id: str
        :keyword target_resource_region: Required. Location of the target Azure resource. A valid Azure
         region name supported by Cognitive Services.
        :paramtype target_resource_region: str
        :keyword copy_authorization: Required. Entity that encodes claims to authorize the copy
         request.
        :paramtype copy_authorization: ~azure.ai.formrecognizer.v2_0.models.CopyAuthorizationResult
        """
        super(CopyRequest, self).__init__(**kwargs)
        self.target_resource_id = kwargs['target_resource_id']
        self.target_resource_region = kwargs['target_resource_region']
        self.copy_authorization = kwargs['copy_authorization']


class CopyResult(msrest.serialization.Model):
    """Custom model copy result.

    All required parameters must be populated in order to send to Azure.

    :ivar model_id: Required. Identifier of the target model.
    :vartype model_id: str
    :ivar errors: Errors returned during the copy operation.
    :vartype errors: list[~azure.ai.formrecognizer.v2_0.models.ErrorInformation]
    """

    _validation = {
        'model_id': {'required': True},
    }

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ErrorInformation]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword model_id: Required. Identifier of the target model.
        :paramtype model_id: str
        :keyword errors: Errors returned during the copy operation.
        :paramtype errors: list[~azure.ai.formrecognizer.v2_0.models.ErrorInformation]
        """
        super(CopyResult, self).__init__(**kwargs)
        self.model_id = kwargs['model_id']
        self.errors = kwargs.get('errors', None)


class DataTable(msrest.serialization.Model):
    """Information about the extracted table contained in a page.

    All required parameters must be populated in order to send to Azure.

    :ivar rows: Required. Number of rows.
    :vartype rows: int
    :ivar columns: Required. Number of columns.
    :vartype columns: int
    :ivar cells: Required. List of cells contained in the table.
    :vartype cells: list[~azure.ai.formrecognizer.v2_0.models.DataTableCell]
    """

    _validation = {
        'rows': {'required': True, 'minimum': 1},
        'columns': {'required': True, 'minimum': 1},
        'cells': {'required': True},
    }

    _attribute_map = {
        'rows': {'key': 'rows', 'type': 'int'},
        'columns': {'key': 'columns', 'type': 'int'},
        'cells': {'key': 'cells', 'type': '[DataTableCell]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword rows: Required. Number of rows.
        :paramtype rows: int
        :keyword columns: Required. Number of columns.
        :paramtype columns: int
        :keyword cells: Required. List of cells contained in the table.
        :paramtype cells: list[~azure.ai.formrecognizer.v2_0.models.DataTableCell]
        """
        super(DataTable, self).__init__(**kwargs)
        self.rows = kwargs['rows']
        self.columns = kwargs['columns']
        self.cells = kwargs['cells']


class DataTableCell(msrest.serialization.Model):
    """Information about the extracted cell in a table.

    All required parameters must be populated in order to send to Azure.

    :ivar row_index: Required. Row index of the cell.
    :vartype row_index: int
    :ivar column_index: Required. Column index of the cell.
    :vartype column_index: int
    :ivar row_span: Number of rows spanned by this cell.
    :vartype row_span: int
    :ivar column_span: Number of columns spanned by this cell.
    :vartype column_span: int
    :ivar text: Required. Text content of the cell.
    :vartype text: str
    :ivar bounding_box: Required. Bounding box of the cell.
    :vartype bounding_box: list[float]
    :ivar confidence: Required. Confidence value.
    :vartype confidence: float
    :ivar elements: When includeTextDetails is set to true, a list of references to the text
     elements constituting this table cell.
    :vartype elements: list[str]
    :ivar is_header: Is the current cell a header cell?.
    :vartype is_header: bool
    :ivar is_footer: Is the current cell a footer cell?.
    :vartype is_footer: bool
    """

    _validation = {
        'row_index': {'required': True, 'minimum': 0},
        'column_index': {'required': True, 'minimum': 0},
        'row_span': {'minimum': 1},
        'column_span': {'minimum': 1},
        'text': {'required': True},
        'bounding_box': {'required': True, 'max_items': 8, 'min_items': 8},
        'confidence': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'row_index': {'key': 'rowIndex', 'type': 'int'},
        'column_index': {'key': 'columnIndex', 'type': 'int'},
        'row_span': {'key': 'rowSpan', 'type': 'int'},
        'column_span': {'key': 'columnSpan', 'type': 'int'},
        'text': {'key': 'text', 'type': 'str'},
        'bounding_box': {'key': 'boundingBox', 'type': '[float]'},
        'confidence': {'key': 'confidence', 'type': 'float'},
        'elements': {'key': 'elements', 'type': '[str]'},
        'is_header': {'key': 'isHeader', 'type': 'bool'},
        'is_footer': {'key': 'isFooter', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword row_index: Required. Row index of the cell.
        :paramtype row_index: int
        :keyword column_index: Required. Column index of the cell.
        :paramtype column_index: int
        :keyword row_span: Number of rows spanned by this cell.
        :paramtype row_span: int
        :keyword column_span: Number of columns spanned by this cell.
        :paramtype column_span: int
        :keyword text: Required. Text content of the cell.
        :paramtype text: str
        :keyword bounding_box: Required. Bounding box of the cell.
        :paramtype bounding_box: list[float]
        :keyword confidence: Required. Confidence value.
        :paramtype confidence: float
        :keyword elements: When includeTextDetails is set to true, a list of references to the text
         elements constituting this table cell.
        :paramtype elements: list[str]
        :keyword is_header: Is the current cell a header cell?.
        :paramtype is_header: bool
        :keyword is_footer: Is the current cell a footer cell?.
        :paramtype is_footer: bool
        """
        super(DataTableCell, self).__init__(**kwargs)
        self.row_index = kwargs['row_index']
        self.column_index = kwargs['column_index']
        self.row_span = kwargs.get('row_span', 1)
        self.column_span = kwargs.get('column_span', 1)
        self.text = kwargs['text']
        self.bounding_box = kwargs['bounding_box']
        self.confidence = kwargs['confidence']
        self.elements = kwargs.get('elements', None)
        self.is_header = kwargs.get('is_header', False)
        self.is_footer = kwargs.get('is_footer', False)


class DocumentResult(msrest.serialization.Model):
    """A set of extracted fields corresponding to the input document.

    All required parameters must be populated in order to send to Azure.

    :ivar doc_type: Required. Document type.
    :vartype doc_type: str
    :ivar page_range: Required. First and last page number where the document is found.
    :vartype page_range: list[int]
    :ivar fields: Required. Dictionary of named field values.
    :vartype fields: dict[str, ~azure.ai.formrecognizer.v2_0.models.FieldValue]
    """

    _validation = {
        'doc_type': {'required': True},
        'page_range': {'required': True, 'max_items': 2, 'min_items': 2},
        'fields': {'required': True},
    }

    _attribute_map = {
        'doc_type': {'key': 'docType', 'type': 'str'},
        'page_range': {'key': 'pageRange', 'type': '[int]'},
        'fields': {'key': 'fields', 'type': '{FieldValue}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword doc_type: Required. Document type.
        :paramtype doc_type: str
        :keyword page_range: Required. First and last page number where the document is found.
        :paramtype page_range: list[int]
        :keyword fields: Required. Dictionary of named field values.
        :paramtype fields: dict[str, ~azure.ai.formrecognizer.v2_0.models.FieldValue]
        """
        super(DocumentResult, self).__init__(**kwargs)
        self.doc_type = kwargs['doc_type']
        self.page_range = kwargs['page_range']
        self.fields = kwargs['fields']


class ErrorInformation(msrest.serialization.Model):
    """ErrorInformation.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required.
    :vartype code: str
    :ivar message: Required.
    :vartype message: str
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword code: Required.
        :paramtype code: str
        :keyword message: Required.
        :paramtype message: str
        """
        super(ErrorInformation, self).__init__(**kwargs)
        self.code = kwargs['code']
        self.message = kwargs['message']


class ErrorResponse(msrest.serialization.Model):
    """ErrorResponse.

    All required parameters must be populated in order to send to Azure.

    :ivar error: Required.
    :vartype error: ~azure.ai.formrecognizer.v2_0.models.ErrorInformation
    """

    _validation = {
        'error': {'required': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorInformation'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword error: Required.
        :paramtype error: ~azure.ai.formrecognizer.v2_0.models.ErrorInformation
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs['error']


class FieldValue(msrest.serialization.Model):
    """Recognized field value.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. Type of field value. Possible values include: "string", "date", "time",
     "phoneNumber", "number", "integer", "array", "object".
    :vartype type: str or ~azure.ai.formrecognizer.v2_0.models.FieldValueType
    :ivar value_string: String value.
    :vartype value_string: str
    :ivar value_date: Date value.
    :vartype value_date: ~datetime.date
    :ivar value_time: Time value.
    :vartype value_time: ~datetime.time
    :ivar value_phone_number: Phone number value.
    :vartype value_phone_number: str
    :ivar value_number: Floating point value.
    :vartype value_number: float
    :ivar value_integer: Integer value.
    :vartype value_integer: int
    :ivar value_array: Array of field values.
    :vartype value_array: list[~azure.ai.formrecognizer.v2_0.models.FieldValue]
    :ivar value_object: Dictionary of named field values.
    :vartype value_object: dict[str, ~azure.ai.formrecognizer.v2_0.models.FieldValue]
    :ivar text: Text content of the extracted field.
    :vartype text: str
    :ivar bounding_box: Bounding box of the field value, if appropriate.
    :vartype bounding_box: list[float]
    :ivar confidence: Confidence score.
    :vartype confidence: float
    :ivar elements: When includeTextDetails is set to true, a list of references to the text
     elements constituting this field.
    :vartype elements: list[str]
    :ivar page: The 1-based page number in the input document.
    :vartype page: int
    """

    _validation = {
        'type': {'required': True},
        'bounding_box': {'max_items': 8, 'min_items': 8},
        'confidence': {'maximum': 1, 'minimum': 0},
        'page': {'minimum': 1},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'value_string': {'key': 'valueString', 'type': 'str'},
        'value_date': {'key': 'valueDate', 'type': 'date'},
        'value_time': {'key': 'valueTime', 'type': 'time'},
        'value_phone_number': {'key': 'valuePhoneNumber', 'type': 'str'},
        'value_number': {'key': 'valueNumber', 'type': 'float'},
        'value_integer': {'key': 'valueInteger', 'type': 'int'},
        'value_array': {'key': 'valueArray', 'type': '[FieldValue]'},
        'value_object': {'key': 'valueObject', 'type': '{FieldValue}'},
        'text': {'key': 'text', 'type': 'str'},
        'bounding_box': {'key': 'boundingBox', 'type': '[float]'},
        'confidence': {'key': 'confidence', 'type': 'float'},
        'elements': {'key': 'elements', 'type': '[str]'},
        'page': {'key': 'page', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword type: Required. Type of field value. Possible values include: "string", "date",
         "time", "phoneNumber", "number", "integer", "array", "object".
        :paramtype type: str or ~azure.ai.formrecognizer.v2_0.models.FieldValueType
        :keyword value_string: String value.
        :paramtype value_string: str
        :keyword value_date: Date value.
        :paramtype value_date: ~datetime.date
        :keyword value_time: Time value.
        :paramtype value_time: ~datetime.time
        :keyword value_phone_number: Phone number value.
        :paramtype value_phone_number: str
        :keyword value_number: Floating point value.
        :paramtype value_number: float
        :keyword value_integer: Integer value.
        :paramtype value_integer: int
        :keyword value_array: Array of field values.
        :paramtype value_array: list[~azure.ai.formrecognizer.v2_0.models.FieldValue]
        :keyword value_object: Dictionary of named field values.
        :paramtype value_object: dict[str, ~azure.ai.formrecognizer.v2_0.models.FieldValue]
        :keyword text: Text content of the extracted field.
        :paramtype text: str
        :keyword bounding_box: Bounding box of the field value, if appropriate.
        :paramtype bounding_box: list[float]
        :keyword confidence: Confidence score.
        :paramtype confidence: float
        :keyword elements: When includeTextDetails is set to true, a list of references to the text
         elements constituting this field.
        :paramtype elements: list[str]
        :keyword page: The 1-based page number in the input document.
        :paramtype page: int
        """
        super(FieldValue, self).__init__(**kwargs)
        self.type = kwargs['type']
        self.value_string = kwargs.get('value_string', None)
        self.value_date = kwargs.get('value_date', None)
        self.value_time = kwargs.get('value_time', None)
        self.value_phone_number = kwargs.get('value_phone_number', None)
        self.value_number = kwargs.get('value_number', None)
        self.value_integer = kwargs.get('value_integer', None)
        self.value_array = kwargs.get('value_array', None)
        self.value_object = kwargs.get('value_object', None)
        self.text = kwargs.get('text', None)
        self.bounding_box = kwargs.get('bounding_box', None)
        self.confidence = kwargs.get('confidence', None)
        self.elements = kwargs.get('elements', None)
        self.page = kwargs.get('page', None)


class FormFieldsReport(msrest.serialization.Model):
    """Report for a custom model training field.

    All required parameters must be populated in order to send to Azure.

    :ivar field_name: Required. Training field name.
    :vartype field_name: str
    :ivar accuracy: Required. Estimated extraction accuracy for this field.
    :vartype accuracy: float
    """

    _validation = {
        'field_name': {'required': True},
        'accuracy': {'required': True},
    }

    _attribute_map = {
        'field_name': {'key': 'fieldName', 'type': 'str'},
        'accuracy': {'key': 'accuracy', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword field_name: Required. Training field name.
        :paramtype field_name: str
        :keyword accuracy: Required. Estimated extraction accuracy for this field.
        :paramtype accuracy: float
        """
        super(FormFieldsReport, self).__init__(**kwargs)
        self.field_name = kwargs['field_name']
        self.accuracy = kwargs['accuracy']


class KeysResult(msrest.serialization.Model):
    """Keys extracted by the custom model.

    All required parameters must be populated in order to send to Azure.

    :ivar clusters: Required. Object mapping clusterIds to a list of keys.
    :vartype clusters: dict[str, list[str]]
    """

    _validation = {
        'clusters': {'required': True},
    }

    _attribute_map = {
        'clusters': {'key': 'clusters', 'type': '{[str]}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword clusters: Required. Object mapping clusterIds to a list of keys.
        :paramtype clusters: dict[str, list[str]]
        """
        super(KeysResult, self).__init__(**kwargs)
        self.clusters = kwargs['clusters']


class KeyValueElement(msrest.serialization.Model):
    """Information about the extracted key or value in a key-value pair.

    All required parameters must be populated in order to send to Azure.

    :ivar text: Required. The text content of the key or value.
    :vartype text: str
    :ivar bounding_box: Bounding box of the key or value.
    :vartype bounding_box: list[float]
    :ivar elements: When includeTextDetails is set to true, a list of references to the text
     elements constituting this key or value.
    :vartype elements: list[str]
    """

    _validation = {
        'text': {'required': True},
        'bounding_box': {'max_items': 8, 'min_items': 8},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'bounding_box': {'key': 'boundingBox', 'type': '[float]'},
        'elements': {'key': 'elements', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword text: Required. The text content of the key or value.
        :paramtype text: str
        :keyword bounding_box: Bounding box of the key or value.
        :paramtype bounding_box: list[float]
        :keyword elements: When includeTextDetails is set to true, a list of references to the text
         elements constituting this key or value.
        :paramtype elements: list[str]
        """
        super(KeyValueElement, self).__init__(**kwargs)
        self.text = kwargs['text']
        self.bounding_box = kwargs.get('bounding_box', None)
        self.elements = kwargs.get('elements', None)


class KeyValuePair(msrest.serialization.Model):
    """Information about the extracted key-value pair.

    All required parameters must be populated in order to send to Azure.

    :ivar label: A user defined label for the key/value pair entry.
    :vartype label: str
    :ivar key: Required. Information about the extracted key in a key-value pair.
    :vartype key: ~azure.ai.formrecognizer.v2_0.models.KeyValueElement
    :ivar value: Required. Information about the extracted value in a key-value pair.
    :vartype value: ~azure.ai.formrecognizer.v2_0.models.KeyValueElement
    :ivar confidence: Required. Confidence value.
    :vartype confidence: float
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
        'confidence': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'label': {'key': 'label', 'type': 'str'},
        'key': {'key': 'key', 'type': 'KeyValueElement'},
        'value': {'key': 'value', 'type': 'KeyValueElement'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword label: A user defined label for the key/value pair entry.
        :paramtype label: str
        :keyword key: Required. Information about the extracted key in a key-value pair.
        :paramtype key: ~azure.ai.formrecognizer.v2_0.models.KeyValueElement
        :keyword value: Required. Information about the extracted value in a key-value pair.
        :paramtype value: ~azure.ai.formrecognizer.v2_0.models.KeyValueElement
        :keyword confidence: Required. Confidence value.
        :paramtype confidence: float
        """
        super(KeyValuePair, self).__init__(**kwargs)
        self.label = kwargs.get('label', None)
        self.key = kwargs['key']
        self.value = kwargs['value']
        self.confidence = kwargs['confidence']


class Model(msrest.serialization.Model):
    """Response to the get custom model operation.

    All required parameters must be populated in order to send to Azure.

    :ivar model_info: Required. Basic custom model information.
    :vartype model_info: ~azure.ai.formrecognizer.v2_0.models.ModelInfo
    :ivar keys: Keys extracted by the custom model.
    :vartype keys: ~azure.ai.formrecognizer.v2_0.models.KeysResult
    :ivar train_result: Custom model training result.
    :vartype train_result: ~azure.ai.formrecognizer.v2_0.models.TrainResult
    """

    _validation = {
        'model_info': {'required': True},
    }

    _attribute_map = {
        'model_info': {'key': 'modelInfo', 'type': 'ModelInfo'},
        'keys': {'key': 'keys', 'type': 'KeysResult'},
        'train_result': {'key': 'trainResult', 'type': 'TrainResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword model_info: Required. Basic custom model information.
        :paramtype model_info: ~azure.ai.formrecognizer.v2_0.models.ModelInfo
        :keyword keys: Keys extracted by the custom model.
        :paramtype keys: ~azure.ai.formrecognizer.v2_0.models.KeysResult
        :keyword train_result: Custom model training result.
        :paramtype train_result: ~azure.ai.formrecognizer.v2_0.models.TrainResult
        """
        super(Model, self).__init__(**kwargs)
        self.model_info = kwargs['model_info']
        self.keys = kwargs.get('keys', None)
        self.train_result = kwargs.get('train_result', None)


class ModelInfo(msrest.serialization.Model):
    """Basic custom model information.

    All required parameters must be populated in order to send to Azure.

    :ivar model_id: Required. Model identifier.
    :vartype model_id: str
    :ivar status: Required. Status of the model. Possible values include: "creating", "ready",
     "invalid".
    :vartype status: str or ~azure.ai.formrecognizer.v2_0.models.ModelStatus
    :ivar created_date_time: Required. Date and time (UTC) when the model was created.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_updated_date_time: Required. Date and time (UTC) when the status was last updated.
    :vartype last_updated_date_time: ~datetime.datetime
    """

    _validation = {
        'model_id': {'required': True},
        'status': {'required': True},
        'created_date_time': {'required': True},
        'last_updated_date_time': {'required': True},
    }

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_updated_date_time': {'key': 'lastUpdatedDateTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword model_id: Required. Model identifier.
        :paramtype model_id: str
        :keyword status: Required. Status of the model. Possible values include: "creating", "ready",
         "invalid".
        :paramtype status: str or ~azure.ai.formrecognizer.v2_0.models.ModelStatus
        :keyword created_date_time: Required. Date and time (UTC) when the model was created.
        :paramtype created_date_time: ~datetime.datetime
        :keyword last_updated_date_time: Required. Date and time (UTC) when the status was last
         updated.
        :paramtype last_updated_date_time: ~datetime.datetime
        """
        super(ModelInfo, self).__init__(**kwargs)
        self.model_id = kwargs['model_id']
        self.status = kwargs['status']
        self.created_date_time = kwargs['created_date_time']
        self.last_updated_date_time = kwargs['last_updated_date_time']


class Models(msrest.serialization.Model):
    """Response to the list custom models operation.

    :ivar summary: Summary of all trained custom models.
    :vartype summary: ~azure.ai.formrecognizer.v2_0.models.ModelsSummary
    :ivar model_list: Collection of trained custom models.
    :vartype model_list: list[~azure.ai.formrecognizer.v2_0.models.ModelInfo]
    :ivar next_link: Link to the next page of custom models.
    :vartype next_link: str
    """

    _attribute_map = {
        'summary': {'key': 'summary', 'type': 'ModelsSummary'},
        'model_list': {'key': 'modelList', 'type': '[ModelInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword summary: Summary of all trained custom models.
        :paramtype summary: ~azure.ai.formrecognizer.v2_0.models.ModelsSummary
        :keyword model_list: Collection of trained custom models.
        :paramtype model_list: list[~azure.ai.formrecognizer.v2_0.models.ModelInfo]
        :keyword next_link: Link to the next page of custom models.
        :paramtype next_link: str
        """
        super(Models, self).__init__(**kwargs)
        self.summary = kwargs.get('summary', None)
        self.model_list = kwargs.get('model_list', None)
        self.next_link = kwargs.get('next_link', None)


class ModelsSummary(msrest.serialization.Model):
    """Summary of all trained custom models.

    All required parameters must be populated in order to send to Azure.

    :ivar count: Required. Current count of trained custom models.
    :vartype count: int
    :ivar limit: Required. Max number of models that can be trained for this account.
    :vartype limit: int
    :ivar last_updated_date_time: Required. Date and time (UTC) when the summary was last updated.
    :vartype last_updated_date_time: ~datetime.datetime
    """

    _validation = {
        'count': {'required': True},
        'limit': {'required': True},
        'last_updated_date_time': {'required': True},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'limit': {'key': 'limit', 'type': 'int'},
        'last_updated_date_time': {'key': 'lastUpdatedDateTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword count: Required. Current count of trained custom models.
        :paramtype count: int
        :keyword limit: Required. Max number of models that can be trained for this account.
        :paramtype limit: int
        :keyword last_updated_date_time: Required. Date and time (UTC) when the summary was last
         updated.
        :paramtype last_updated_date_time: ~datetime.datetime
        """
        super(ModelsSummary, self).__init__(**kwargs)
        self.count = kwargs['count']
        self.limit = kwargs['limit']
        self.last_updated_date_time = kwargs['last_updated_date_time']


class PageResult(msrest.serialization.Model):
    """Extracted information from a single page.

    All required parameters must be populated in order to send to Azure.

    :ivar page: Required. Page number.
    :vartype page: int
    :ivar cluster_id: Cluster identifier.
    :vartype cluster_id: int
    :ivar key_value_pairs: List of key-value pairs extracted from the page.
    :vartype key_value_pairs: list[~azure.ai.formrecognizer.v2_0.models.KeyValuePair]
    :ivar tables: List of data tables extracted from the page.
    :vartype tables: list[~azure.ai.formrecognizer.v2_0.models.DataTable]
    """

    _validation = {
        'page': {'required': True, 'minimum': 1},
        'cluster_id': {'minimum': 0},
    }

    _attribute_map = {
        'page': {'key': 'page', 'type': 'int'},
        'cluster_id': {'key': 'clusterId', 'type': 'int'},
        'key_value_pairs': {'key': 'keyValuePairs', 'type': '[KeyValuePair]'},
        'tables': {'key': 'tables', 'type': '[DataTable]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword page: Required. Page number.
        :paramtype page: int
        :keyword cluster_id: Cluster identifier.
        :paramtype cluster_id: int
        :keyword key_value_pairs: List of key-value pairs extracted from the page.
        :paramtype key_value_pairs: list[~azure.ai.formrecognizer.v2_0.models.KeyValuePair]
        :keyword tables: List of data tables extracted from the page.
        :paramtype tables: list[~azure.ai.formrecognizer.v2_0.models.DataTable]
        """
        super(PageResult, self).__init__(**kwargs)
        self.page = kwargs['page']
        self.cluster_id = kwargs.get('cluster_id', None)
        self.key_value_pairs = kwargs.get('key_value_pairs', None)
        self.tables = kwargs.get('tables', None)


class ReadResult(msrest.serialization.Model):
    """Text extracted from a page in the input document.

    All required parameters must be populated in order to send to Azure.

    :ivar page: Required. The 1-based page number in the input document.
    :vartype page: int
    :ivar angle: Required. The general orientation of the text in clockwise direction, measured in
     degrees between (-180, 180].
    :vartype angle: float
    :ivar width: Required. The width of the image/PDF in pixels/inches, respectively.
    :vartype width: float
    :ivar height: Required. The height of the image/PDF in pixels/inches, respectively.
    :vartype height: float
    :ivar unit: Required. The unit used by the width, height and boundingBox properties. For
     images, the unit is "pixel". For PDF, the unit is "inch". Possible values include: "pixel",
     "inch".
    :vartype unit: str or ~azure.ai.formrecognizer.v2_0.models.LengthUnit
    :ivar language: The detected language on the page overall. Possible values include: "en", "es".
    :vartype language: str or ~azure.ai.formrecognizer.v2_0.models.Language
    :ivar lines: When includeTextDetails is set to true, a list of recognized text lines. The
     maximum number of lines returned is 300 per page. The lines are sorted top to bottom, left to
     right, although in certain cases proximity is treated with higher priority. As the sorting
     order depends on the detected text, it may change across images and OCR version updates. Thus,
     business logic should be built upon the actual line location instead of order.
    :vartype lines: list[~azure.ai.formrecognizer.v2_0.models.TextLine]
    """

    _validation = {
        'page': {'required': True, 'minimum': 1},
        'angle': {'required': True, 'maximum': 180, 'minimum_ex': -180},
        'width': {'required': True, 'minimum': 0},
        'height': {'required': True, 'minimum': 0},
        'unit': {'required': True},
    }

    _attribute_map = {
        'page': {'key': 'page', 'type': 'int'},
        'angle': {'key': 'angle', 'type': 'float'},
        'width': {'key': 'width', 'type': 'float'},
        'height': {'key': 'height', 'type': 'float'},
        'unit': {'key': 'unit', 'type': 'str'},
        'language': {'key': 'language', 'type': 'str'},
        'lines': {'key': 'lines', 'type': '[TextLine]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword page: Required. The 1-based page number in the input document.
        :paramtype page: int
        :keyword angle: Required. The general orientation of the text in clockwise direction, measured
         in degrees between (-180, 180].
        :paramtype angle: float
        :keyword width: Required. The width of the image/PDF in pixels/inches, respectively.
        :paramtype width: float
        :keyword height: Required. The height of the image/PDF in pixels/inches, respectively.
        :paramtype height: float
        :keyword unit: Required. The unit used by the width, height and boundingBox properties. For
         images, the unit is "pixel". For PDF, the unit is "inch". Possible values include: "pixel",
         "inch".
        :paramtype unit: str or ~azure.ai.formrecognizer.v2_0.models.LengthUnit
        :keyword language: The detected language on the page overall. Possible values include: "en",
         "es".
        :paramtype language: str or ~azure.ai.formrecognizer.v2_0.models.Language
        :keyword lines: When includeTextDetails is set to true, a list of recognized text lines. The
         maximum number of lines returned is 300 per page. The lines are sorted top to bottom, left to
         right, although in certain cases proximity is treated with higher priority. As the sorting
         order depends on the detected text, it may change across images and OCR version updates. Thus,
         business logic should be built upon the actual line location instead of order.
        :paramtype lines: list[~azure.ai.formrecognizer.v2_0.models.TextLine]
        """
        super(ReadResult, self).__init__(**kwargs)
        self.page = kwargs['page']
        self.angle = kwargs['angle']
        self.width = kwargs['width']
        self.height = kwargs['height']
        self.unit = kwargs['unit']
        self.language = kwargs.get('language', None)
        self.lines = kwargs.get('lines', None)


class SourcePath(msrest.serialization.Model):
    """Uri or local path to source data.

    :ivar source: File source path.
    :vartype source: str
    """

    _validation = {
        'source': {'max_length': 2048, 'min_length': 0},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword source: File source path.
        :paramtype source: str
        """
        super(SourcePath, self).__init__(**kwargs)
        self.source = kwargs.get('source', None)


class TextLine(msrest.serialization.Model):
    """An object representing an extracted text line.

    All required parameters must be populated in order to send to Azure.

    :ivar text: Required. The text content of the line.
    :vartype text: str
    :ivar bounding_box: Required. Bounding box of an extracted line.
    :vartype bounding_box: list[float]
    :ivar language: The detected language of this line, if different from the overall page
     language. Possible values include: "en", "es".
    :vartype language: str or ~azure.ai.formrecognizer.v2_0.models.Language
    :ivar words: Required. List of words in the text line.
    :vartype words: list[~azure.ai.formrecognizer.v2_0.models.TextWord]
    """

    _validation = {
        'text': {'required': True},
        'bounding_box': {'required': True, 'max_items': 8, 'min_items': 8},
        'words': {'required': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'bounding_box': {'key': 'boundingBox', 'type': '[float]'},
        'language': {'key': 'language', 'type': 'str'},
        'words': {'key': 'words', 'type': '[TextWord]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword text: Required. The text content of the line.
        :paramtype text: str
        :keyword bounding_box: Required. Bounding box of an extracted line.
        :paramtype bounding_box: list[float]
        :keyword language: The detected language of this line, if different from the overall page
         language. Possible values include: "en", "es".
        :paramtype language: str or ~azure.ai.formrecognizer.v2_0.models.Language
        :keyword words: Required. List of words in the text line.
        :paramtype words: list[~azure.ai.formrecognizer.v2_0.models.TextWord]
        """
        super(TextLine, self).__init__(**kwargs)
        self.text = kwargs['text']
        self.bounding_box = kwargs['bounding_box']
        self.language = kwargs.get('language', None)
        self.words = kwargs['words']


class TextWord(msrest.serialization.Model):
    """An object representing a word.

    All required parameters must be populated in order to send to Azure.

    :ivar text: Required. The text content of the word.
    :vartype text: str
    :ivar bounding_box: Required. Bounding box of an extracted word.
    :vartype bounding_box: list[float]
    :ivar confidence: Confidence value.
    :vartype confidence: float
    """

    _validation = {
        'text': {'required': True},
        'bounding_box': {'required': True, 'max_items': 8, 'min_items': 8},
        'confidence': {'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'bounding_box': {'key': 'boundingBox', 'type': '[float]'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword text: Required. The text content of the word.
        :paramtype text: str
        :keyword bounding_box: Required. Bounding box of an extracted word.
        :paramtype bounding_box: list[float]
        :keyword confidence: Confidence value.
        :paramtype confidence: float
        """
        super(TextWord, self).__init__(**kwargs)
        self.text = kwargs['text']
        self.bounding_box = kwargs['bounding_box']
        self.confidence = kwargs.get('confidence', None)


class TrainingDocumentInfo(msrest.serialization.Model):
    """Report for a custom model training document.

    All required parameters must be populated in order to send to Azure.

    :ivar document_name: Required. Training document name.
    :vartype document_name: str
    :ivar pages: Required. Total number of pages trained.
    :vartype pages: int
    :ivar errors: Required. List of errors.
    :vartype errors: list[~azure.ai.formrecognizer.v2_0.models.ErrorInformation]
    :ivar status: Required. Status of the training operation. Possible values include: "succeeded",
     "partiallySucceeded", "failed".
    :vartype status: str or ~azure.ai.formrecognizer.v2_0.models.TrainStatus
    """

    _validation = {
        'document_name': {'required': True},
        'pages': {'required': True},
        'errors': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'document_name': {'key': 'documentName', 'type': 'str'},
        'pages': {'key': 'pages', 'type': 'int'},
        'errors': {'key': 'errors', 'type': '[ErrorInformation]'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword document_name: Required. Training document name.
        :paramtype document_name: str
        :keyword pages: Required. Total number of pages trained.
        :paramtype pages: int
        :keyword errors: Required. List of errors.
        :paramtype errors: list[~azure.ai.formrecognizer.v2_0.models.ErrorInformation]
        :keyword status: Required. Status of the training operation. Possible values include:
         "succeeded", "partiallySucceeded", "failed".
        :paramtype status: str or ~azure.ai.formrecognizer.v2_0.models.TrainStatus
        """
        super(TrainingDocumentInfo, self).__init__(**kwargs)
        self.document_name = kwargs['document_name']
        self.pages = kwargs['pages']
        self.errors = kwargs['errors']
        self.status = kwargs['status']


class TrainRequest(msrest.serialization.Model):
    """Request parameter to train a new custom model.

    All required parameters must be populated in order to send to Azure.

    :ivar source: Required. Source path containing the training documents.
    :vartype source: str
    :ivar source_filter: Filter to apply to the documents in the source path for training.
    :vartype source_filter: ~azure.ai.formrecognizer.v2_0.models.TrainSourceFilter
    :ivar use_label_file: Use label file for training a model.
    :vartype use_label_file: bool
    """

    _validation = {
        'source': {'required': True, 'max_length': 2048, 'min_length': 0},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'str'},
        'source_filter': {'key': 'sourceFilter', 'type': 'TrainSourceFilter'},
        'use_label_file': {'key': 'useLabelFile', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword source: Required. Source path containing the training documents.
        :paramtype source: str
        :keyword source_filter: Filter to apply to the documents in the source path for training.
        :paramtype source_filter: ~azure.ai.formrecognizer.v2_0.models.TrainSourceFilter
        :keyword use_label_file: Use label file for training a model.
        :paramtype use_label_file: bool
        """
        super(TrainRequest, self).__init__(**kwargs)
        self.source = kwargs['source']
        self.source_filter = kwargs.get('source_filter', None)
        self.use_label_file = kwargs.get('use_label_file', False)


class TrainResult(msrest.serialization.Model):
    """Custom model training result.

    All required parameters must be populated in order to send to Azure.

    :ivar training_documents: Required. List of the documents used to train the model and any
     errors reported in each document.
    :vartype training_documents: list[~azure.ai.formrecognizer.v2_0.models.TrainingDocumentInfo]
    :ivar fields: List of fields used to train the model and the train operation error reported by
     each.
    :vartype fields: list[~azure.ai.formrecognizer.v2_0.models.FormFieldsReport]
    :ivar average_model_accuracy: Average accuracy.
    :vartype average_model_accuracy: float
    :ivar errors: Errors returned during the training operation.
    :vartype errors: list[~azure.ai.formrecognizer.v2_0.models.ErrorInformation]
    """

    _validation = {
        'training_documents': {'required': True},
    }

    _attribute_map = {
        'training_documents': {'key': 'trainingDocuments', 'type': '[TrainingDocumentInfo]'},
        'fields': {'key': 'fields', 'type': '[FormFieldsReport]'},
        'average_model_accuracy': {'key': 'averageModelAccuracy', 'type': 'float'},
        'errors': {'key': 'errors', 'type': '[ErrorInformation]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword training_documents: Required. List of the documents used to train the model and any
         errors reported in each document.
        :paramtype training_documents: list[~azure.ai.formrecognizer.v2_0.models.TrainingDocumentInfo]
        :keyword fields: List of fields used to train the model and the train operation error reported
         by each.
        :paramtype fields: list[~azure.ai.formrecognizer.v2_0.models.FormFieldsReport]
        :keyword average_model_accuracy: Average accuracy.
        :paramtype average_model_accuracy: float
        :keyword errors: Errors returned during the training operation.
        :paramtype errors: list[~azure.ai.formrecognizer.v2_0.models.ErrorInformation]
        """
        super(TrainResult, self).__init__(**kwargs)
        self.training_documents = kwargs['training_documents']
        self.fields = kwargs.get('fields', None)
        self.average_model_accuracy = kwargs.get('average_model_accuracy', None)
        self.errors = kwargs.get('errors', None)


class TrainSourceFilter(msrest.serialization.Model):
    """Filter to apply to the documents in the source path for training.

    :ivar prefix: A case-sensitive prefix string to filter documents in the source path for
     training. For example, when using a Azure storage blob Uri, use the prefix to restrict sub
     folders for training.
    :vartype prefix: str
    :ivar include_sub_folders: A flag to indicate if sub folders within the set of prefix folders
     will also need to be included when searching for content to be preprocessed.
    :vartype include_sub_folders: bool
    """

    _validation = {
        'prefix': {'max_length': 1024, 'min_length': 0},
    }

    _attribute_map = {
        'prefix': {'key': 'prefix', 'type': 'str'},
        'include_sub_folders': {'key': 'includeSubFolders', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword prefix: A case-sensitive prefix string to filter documents in the source path for
         training. For example, when using a Azure storage blob Uri, use the prefix to restrict sub
         folders for training.
        :paramtype prefix: str
        :keyword include_sub_folders: A flag to indicate if sub folders within the set of prefix
         folders will also need to be included when searching for content to be preprocessed.
        :paramtype include_sub_folders: bool
        """
        super(TrainSourceFilter, self).__init__(**kwargs)
        self.prefix = kwargs.get('prefix', None)
        self.include_sub_folders = kwargs.get('include_sub_folders', False)
