[![build](https://github.com/IMMM-SFA/tell/actions/workflows/build.yml/badge.svg)](https://github.com/IMMM-SFA/tell/actions/workflows/build.yml) [![DOI](https://zenodo.org/badge/305802399.svg)](https://zenodo.org/badge/latestdoi/305802399)


## tell

#### `tell` is an open-source Python package to model future hourly total electricity loads.

### Purpose
`tell` was created to:

  - Project the short- and long-term evolution of hourly electricity demand in response to changes in weather and climate.

  - Work at a spatial resolution adequate for input to a unit commitment/economic dispatch (UC/ED) model.

  - Maintain consistency with the long-term growth and evolution of annual state-level electricity demand projected by an economically driven human-Earth system model.

### Install `tell`

`tell` is available via GitHub repository by using the pip install functionality. `tell` requires a Python version between 3.8 and 4.0 as well as a pip install to import the package. `tell` has been tested on
Windows and Mac platforms.

```bash
pip install tell
```

### Check out a quickstarter tutorial to run `tell`

Run `tell` using the quickstarter tutorial: [Quickstarter](https://immm-sfa.github.io/tell/tell_quickstarter.html).

### Getting started

New to `tell`?  Get familiar with what `tell` is all about in our [Getting Started](https://immm-sfa.github.io/tell/index.html#) documentation.

### User guide

Our [User Guide](https://immm-sfa.github.io/tell/user_guide.html) provides in-depth information on the key concepts of `tell` and how the model works. 

### Contributing to `tell`

Whether you find a typo in the documentation, find a bug, or want to develop functionality that you think will make `tell` more robust, you are welcome to contribute. Please see our [Contribution Guidelines](https://immm-sfa.github.io/tell/contributing.html) for more details.

### API reference
The [API Reference](https://immm-sfa.github.io/tell/modules.html) contains a detailed description of the `tell` API. The reference describes how the methods work and which parameters can be used. It assumes that you have an understanding of the key concepts.

### Contact/Help
Need help with `tell` or have a comment? Please open a [new Issue](https://github.com/IMMM-SFA/tell/issues/new/choose) with your question/comments. 
