import * as cdk from '@aws-cdk/core';
import * as ec2 from '@aws-cdk/aws-ec2';
export interface ClusterProps {
    /**
     * VPC
     */
    readonly vpc?: ec2.IVpc;
    /**
     * Run worker nodes as EC2 Spot
     */
    readonly spotWorkerNodes?: boolean;
    /**
     * control plane node ec2 instance type
     */
    readonly controlPlaneInstanceType?: ec2.InstanceType;
    /**
     * worker node instance type
     */
    readonly workerInstanceType?: ec2.InstanceType;
    /**
     * minimal number of worker nodes
     *
     * @default 3
     */
    readonly workerMinCapacity?: number;
}
/**
 * Represents the k3sCluster construct
 */
export declare class Cluster extends cdk.Construct {
    /**
     * The instance type of the control plane
     */
    readonly controlPlaneInstanceType: ec2.InstanceType;
    /**
     * The instance type of the worker node
     */
    readonly workerInstanceType: ec2.InstanceType;
    /**
     * The endpoint URL of the control plan
     */
    readonly endpointUri: string;
    constructor(scope: cdk.Construct, id: string, props?: ClusterProps);
}
/**
 * The AMI provider to get the latest Amazon Linux 2 AMI for ARM64
 */
export declare class AmiProvider {
    get amiId(): ec2.IMachineImage;
}
/**
 * The VPC provider to create or import the VPC
 */
export declare class VpcProvider {
    static getOrCreate(scope: cdk.Construct): ec2.IVpc;
}
