"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTestingExistingVpcSubnets = exports.IntegTesting = void 0;
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const index_1 = require("./index");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION || 'us-east-1',
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new cdk.Stack(app, 'keycloak-demo', { env });
        // create a default keycloak workload with minimal required props
        new index_1.KeyCloak(stack, 'KeyCloak', {
            certificateArn: stack.node.tryGetContext('ACM_CERT_ARN') || 'MOCK_ARN',
            auroraServerless: true,
            nodeCount: 2,
            autoScaleTask: {
                min: 2,
                max: 10,
                targetCpuUtilization: 60,
            },
        });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
class IntegTestingExistingVpcSubnets {
    constructor() {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new cdk.Stack(app, 'keycloak-demo', { env });
        new index_1.KeyCloak(stack, 'KeyCloak', {
            certificateArn: stack.node.tryGetContext('ACM_CERT_ARN') || 'MOCK_ARN',
            vpc: ec2.Vpc.fromLookup(stack, 'Vpc', { vpcId: 'vpc-0417e46d' }),
            publicSubnets: {
                subnets: [
                    ec2.Subnet.fromSubnetId(stack, 'pub-1a', 'subnet-5bbe7b32'),
                    ec2.Subnet.fromSubnetId(stack, 'pub-1b', 'subnet-0428367c'),
                    ec2.Subnet.fromSubnetId(stack, 'pub-1c', 'subnet-1586a75f'),
                ],
            },
            privateSubnets: {
                subnets: [
                    ec2.Subnet.fromSubnetId(stack, 'priv-1a', 'subnet-0e9460dbcfc4cf6ee'),
                    ec2.Subnet.fromSubnetId(stack, 'priv-1b', 'subnet-0562f666bdf5c29af'),
                    ec2.Subnet.fromSubnetId(stack, 'priv-1c', 'subnet-00ab15c0022872f06'),
                ],
            },
            databaseSubnets: {
                subnets: [
                    ec2.Subnet.fromSubnetId(stack, 'db-1a', 'subnet-0e9460dbcfc4cf6ee'),
                    ec2.Subnet.fromSubnetId(stack, 'db-1b', 'subnet-0562f666bdf5c29af'),
                    ec2.Subnet.fromSubnetId(stack, 'db-1c', 'subnet-00ab15c0022872f06'),
                ],
            },
        });
        this.stack = [stack];
    }
}
exports.IntegTestingExistingVpcSubnets = IntegTestingExistingVpcSubnets;
new IntegTesting();
// new IntegTestingExistingVpcSubnets();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZGVmYXVsdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9pbnRlZy5kZWZhdWx0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHdDQUF3QztBQUN4QyxxQ0FBcUM7QUFDckMsbUNBQW1DO0FBRW5DLE1BQWEsWUFBWTtJQUV2QjtRQUNFLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO1FBRTFCLE1BQU0sR0FBRyxHQUFHO1lBQ1YsTUFBTSxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsa0JBQWtCLElBQUksV0FBVztZQUNyRCxPQUFPLEVBQUUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxtQkFBbUI7U0FDekMsQ0FBQztRQUVGLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsZUFBZSxFQUFFLEVBQUUsR0FBRyxFQUFFLENBQUMsQ0FBQztRQUUzRCxpRUFBaUU7UUFDakUsSUFBSSxnQkFBUSxDQUFDLEtBQUssRUFBRSxVQUFVLEVBQUU7WUFDOUIsY0FBYyxFQUFFLEtBQUssQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLGNBQWMsQ0FBQyxJQUFJLFVBQVU7WUFDdEUsZ0JBQWdCLEVBQUUsSUFBSTtZQUN0QixTQUFTLEVBQUUsQ0FBQztZQUNaLGFBQWEsRUFBRTtnQkFDYixHQUFHLEVBQUUsQ0FBQztnQkFDTixHQUFHLEVBQUUsRUFBRTtnQkFDUCxvQkFBb0IsRUFBRSxFQUFFO2FBQ3pCO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLEtBQUssR0FBRyxDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQ3ZCLENBQUM7Q0FDRjtBQTFCRCxvQ0EwQkM7QUFHRCxNQUFhLDhCQUE4QjtJQUV6QztRQUNFLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO1FBRTFCLE1BQU0sR0FBRyxHQUFHO1lBQ1YsTUFBTSxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsa0JBQWtCO1lBQ3RDLE9BQU8sRUFBRSxPQUFPLENBQUMsR0FBRyxDQUFDLG1CQUFtQjtTQUN6QyxDQUFDO1FBRUYsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBRSxlQUFlLEVBQUUsRUFBRSxHQUFHLEVBQUUsQ0FBQyxDQUFDO1FBRTNELElBQUksZ0JBQVEsQ0FBQyxLQUFLLEVBQUUsVUFBVSxFQUFFO1lBQzlCLGNBQWMsRUFBRSxLQUFLLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxjQUFjLENBQUMsSUFBSSxVQUFVO1lBQ3RFLEdBQUcsRUFBRSxHQUFHLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFLEVBQUUsS0FBSyxFQUFFLGNBQWMsRUFBRSxDQUFDO1lBQ2hFLGFBQWEsRUFBRTtnQkFDYixPQUFPLEVBQUU7b0JBQ1AsR0FBRyxDQUFDLE1BQU0sQ0FBQyxZQUFZLENBQUMsS0FBSyxFQUFFLFFBQVEsRUFBRSxpQkFBaUIsQ0FBQztvQkFDM0QsR0FBRyxDQUFDLE1BQU0sQ0FBQyxZQUFZLENBQUMsS0FBSyxFQUFFLFFBQVEsRUFBRSxpQkFBaUIsQ0FBQztvQkFDM0QsR0FBRyxDQUFDLE1BQU0sQ0FBQyxZQUFZLENBQUMsS0FBSyxFQUFFLFFBQVEsRUFBRSxpQkFBaUIsQ0FBQztpQkFDNUQ7YUFDRjtZQUNELGNBQWMsRUFBRTtnQkFDZCxPQUFPLEVBQUU7b0JBQ1AsR0FBRyxDQUFDLE1BQU0sQ0FBQyxZQUFZLENBQUMsS0FBSyxFQUFFLFNBQVMsRUFBRSwwQkFBMEIsQ0FBQztvQkFDckUsR0FBRyxDQUFDLE1BQU0sQ0FBQyxZQUFZLENBQUMsS0FBSyxFQUFFLFNBQVMsRUFBRSwwQkFBMEIsQ0FBQztvQkFDckUsR0FBRyxDQUFDLE1BQU0sQ0FBQyxZQUFZLENBQUMsS0FBSyxFQUFFLFNBQVMsRUFBRSwwQkFBMEIsQ0FBQztpQkFDdEU7YUFDRjtZQUNELGVBQWUsRUFBRTtnQkFDZixPQUFPLEVBQUU7b0JBQ1AsR0FBRyxDQUFDLE1BQU0sQ0FBQyxZQUFZLENBQUMsS0FBSyxFQUFFLE9BQU8sRUFBRSwwQkFBMEIsQ0FBQztvQkFDbkUsR0FBRyxDQUFDLE1BQU0sQ0FBQyxZQUFZLENBQUMsS0FBSyxFQUFFLE9BQU8sRUFBRSwwQkFBMEIsQ0FBQztvQkFDbkUsR0FBRyxDQUFDLE1BQU0sQ0FBQyxZQUFZLENBQUMsS0FBSyxFQUFFLE9BQU8sRUFBRSwwQkFBMEIsQ0FBQztpQkFDcEU7YUFDRjtTQUNGLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxLQUFLLEdBQUcsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUN2QixDQUFDO0NBQ0Y7QUF2Q0Qsd0VBdUNDO0FBRUQsSUFBSSxZQUFZLEVBQUUsQ0FBQztBQUVuQix3Q0FBd0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBlYzIgZnJvbSAnQGF3cy1jZGsvYXdzLWVjMic7XG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBLZXlDbG9hayB9IGZyb20gJy4vaW5kZXgnO1xuXG5leHBvcnQgY2xhc3MgSW50ZWdUZXN0aW5nIHtcbiAgcmVhZG9ubHkgc3RhY2s6IGNkay5TdGFja1tdO1xuICBjb25zdHJ1Y3RvcigpIHtcbiAgICBjb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xuXG4gICAgY29uc3QgZW52ID0ge1xuICAgICAgcmVnaW9uOiBwcm9jZXNzLmVudi5DREtfREVGQVVMVF9SRUdJT04gfHwgJ3VzLWVhc3QtMScsXG4gICAgICBhY2NvdW50OiBwcm9jZXNzLmVudi5DREtfREVGQVVMVF9BQ0NPVU5ULFxuICAgIH07XG5cbiAgICBjb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soYXBwLCAna2V5Y2xvYWstZGVtbycsIHsgZW52IH0pO1xuXG4gICAgLy8gY3JlYXRlIGEgZGVmYXVsdCBrZXljbG9hayB3b3JrbG9hZCB3aXRoIG1pbmltYWwgcmVxdWlyZWQgcHJvcHNcbiAgICBuZXcgS2V5Q2xvYWsoc3RhY2ssICdLZXlDbG9haycsIHtcbiAgICAgIGNlcnRpZmljYXRlQXJuOiBzdGFjay5ub2RlLnRyeUdldENvbnRleHQoJ0FDTV9DRVJUX0FSTicpIHx8ICdNT0NLX0FSTicsXG4gICAgICBhdXJvcmFTZXJ2ZXJsZXNzOiB0cnVlLFxuICAgICAgbm9kZUNvdW50OiAyLFxuICAgICAgYXV0b1NjYWxlVGFzazoge1xuICAgICAgICBtaW46IDIsXG4gICAgICAgIG1heDogMTAsXG4gICAgICAgIHRhcmdldENwdVV0aWxpemF0aW9uOiA2MCxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICB0aGlzLnN0YWNrID0gW3N0YWNrXTtcbiAgfVxufVxuXG5cbmV4cG9ydCBjbGFzcyBJbnRlZ1Rlc3RpbmdFeGlzdGluZ1ZwY1N1Ym5ldHMge1xuICByZWFkb25seSBzdGFjazogY2RrLlN0YWNrW107XG4gIGNvbnN0cnVjdG9yKCkge1xuICAgIGNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5cbiAgICBjb25zdCBlbnYgPSB7XG4gICAgICByZWdpb246IHByb2Nlc3MuZW52LkNES19ERUZBVUxUX1JFR0lPTixcbiAgICAgIGFjY291bnQ6IHByb2Nlc3MuZW52LkNES19ERUZBVUxUX0FDQ09VTlQsXG4gICAgfTtcblxuICAgIGNvbnN0IHN0YWNrID0gbmV3IGNkay5TdGFjayhhcHAsICdrZXljbG9hay1kZW1vJywgeyBlbnYgfSk7XG5cbiAgICBuZXcgS2V5Q2xvYWsoc3RhY2ssICdLZXlDbG9haycsIHtcbiAgICAgIGNlcnRpZmljYXRlQXJuOiBzdGFjay5ub2RlLnRyeUdldENvbnRleHQoJ0FDTV9DRVJUX0FSTicpIHx8ICdNT0NLX0FSTicsXG4gICAgICB2cGM6IGVjMi5WcGMuZnJvbUxvb2t1cChzdGFjaywgJ1ZwYycsIHsgdnBjSWQ6ICd2cGMtMDQxN2U0NmQnIH0pLFxuICAgICAgcHVibGljU3VibmV0czoge1xuICAgICAgICBzdWJuZXRzOiBbXG4gICAgICAgICAgZWMyLlN1Ym5ldC5mcm9tU3VibmV0SWQoc3RhY2ssICdwdWItMWEnLCAnc3VibmV0LTViYmU3YjMyJyksXG4gICAgICAgICAgZWMyLlN1Ym5ldC5mcm9tU3VibmV0SWQoc3RhY2ssICdwdWItMWInLCAnc3VibmV0LTA0MjgzNjdjJyksXG4gICAgICAgICAgZWMyLlN1Ym5ldC5mcm9tU3VibmV0SWQoc3RhY2ssICdwdWItMWMnLCAnc3VibmV0LTE1ODZhNzVmJyksXG4gICAgICAgIF0sXG4gICAgICB9LFxuICAgICAgcHJpdmF0ZVN1Ym5ldHM6IHtcbiAgICAgICAgc3VibmV0czogW1xuICAgICAgICAgIGVjMi5TdWJuZXQuZnJvbVN1Ym5ldElkKHN0YWNrLCAncHJpdi0xYScsICdzdWJuZXQtMGU5NDYwZGJjZmM0Y2Y2ZWUnKSxcbiAgICAgICAgICBlYzIuU3VibmV0LmZyb21TdWJuZXRJZChzdGFjaywgJ3ByaXYtMWInLCAnc3VibmV0LTA1NjJmNjY2YmRmNWMyOWFmJyksXG4gICAgICAgICAgZWMyLlN1Ym5ldC5mcm9tU3VibmV0SWQoc3RhY2ssICdwcml2LTFjJywgJ3N1Ym5ldC0wMGFiMTVjMDAyMjg3MmYwNicpLFxuICAgICAgICBdLFxuICAgICAgfSxcbiAgICAgIGRhdGFiYXNlU3VibmV0czoge1xuICAgICAgICBzdWJuZXRzOiBbXG4gICAgICAgICAgZWMyLlN1Ym5ldC5mcm9tU3VibmV0SWQoc3RhY2ssICdkYi0xYScsICdzdWJuZXQtMGU5NDYwZGJjZmM0Y2Y2ZWUnKSxcbiAgICAgICAgICBlYzIuU3VibmV0LmZyb21TdWJuZXRJZChzdGFjaywgJ2RiLTFiJywgJ3N1Ym5ldC0wNTYyZjY2NmJkZjVjMjlhZicpLFxuICAgICAgICAgIGVjMi5TdWJuZXQuZnJvbVN1Ym5ldElkKHN0YWNrLCAnZGItMWMnLCAnc3VibmV0LTAwYWIxNWMwMDIyODcyZjA2JyksXG4gICAgICAgIF0sXG4gICAgICB9LFxuICAgIH0pO1xuICAgIHRoaXMuc3RhY2sgPSBbc3RhY2tdO1xuICB9XG59XG5cbm5ldyBJbnRlZ1Rlc3RpbmcoKTtcblxuLy8gbmV3IEludGVnVGVzdGluZ0V4aXN0aW5nVnBjU3VibmV0cygpO1xuXG4iXX0=