# pngrok

这是一个使用python实现的内网穿透服务，完全使用标准库实现

### 服务端部署方式

```bash
python server.py 0.0.0.0:40000 0.0.0.0:4000
```

对外开放40000端口，以供用户访问；开放4000端口，以供客户端访问

### 客户端部署方式

```bash
python client.py 127.0.0.1:4000 127.0.0.1:80
```

连接到部署在127.0.0.1上的服务端的4000端口，将部署在127.0.0.1上的本地服务上的流量转发到服务端

### 日志

默认不显示日志，使用```--log_level```选项指定日志级别

```bash
python server.py 0.0.0.0:40000 0.0.0.0:4000 --log_level INFO
```

### buffer size

默认为2048，使用```--buffer_size```选项修改

> 但是目前因为对报文结尾的判断全靠报文大小小于buffer_size的办法判断  
> 所以要求server端和client端的buffer_size大小一致  
> 将来应该使用自定义报文，或者去解析http报文获取http报文的长度，为了以后考虑应该使用自定义报文  

```bash
python server.py 0.0.0.0:40000 0.0.0.0:4000 --buffer_size 64
```

### 开发计划

修改报文结尾的判断方法  
一个服务端可以接入多个客户端，并能对每一个客户端的身份进行认证  
为服务端建立web服务，让用户可以注册、登录、获取appid, appsecret、下载客户端脚本、创建内网穿透服务  