# Auto generated by 'inv collect-airflow'
from airfly._vendor.airflow.models.baseoperator import BaseOperator
from airfly._vendor.airflow.operators.sql import (
    SQLCheckOperator,
    SQLIntervalCheckOperator,
    SQLValueCheckOperator,
)


class _BigQueryDbHookMixin:
    pass


class BigQueryCheckOperator(_BigQueryDbHookMixin, SQLCheckOperator):
    sql: "str"
    gcp_conn_id: "str"
    bigquery_conn_id: "typing.Union[str, NoneType]"
    use_legacy_sql: "bool"
    location: "typing.Union[str, NoneType]"
    impersonation_chain: "typing.Union[str, typing.Sequence[str], NoneType]"
    labels: "typing.Union[dict, NoneType]"


class BigQueryIntervalCheckOperator(_BigQueryDbHookMixin, SQLIntervalCheckOperator):
    table: "str"
    metrics_thresholds: "dict"
    date_filter_column: "str"
    days_back: "typing.SupportsAbs[int]"
    gcp_conn_id: "str"
    bigquery_conn_id: "typing.Union[str, NoneType]"
    use_legacy_sql: "bool"
    location: "typing.Union[str, NoneType]"
    impersonation_chain: "typing.Union[str, typing.Sequence[str], NoneType]"
    labels: "typing.Union[typing.Dict, NoneType]"


class BigQueryValueCheckOperator(_BigQueryDbHookMixin, SQLValueCheckOperator):
    sql: "str"
    pass_value: "typing.Any"
    tolerance: "typing.Any"
    gcp_conn_id: "str"
    bigquery_conn_id: "typing.Union[str, NoneType]"
    use_legacy_sql: "bool"
    location: "typing.Union[str, NoneType]"
    impersonation_chain: "typing.Union[str, typing.Sequence[str], NoneType]"
    labels: "typing.Union[dict, NoneType]"


class BigQueryGetDataOperator(BaseOperator):
    dataset_id: "str"
    table_id: "str"
    max_results: "int"
    selected_fields: "typing.Union[str, NoneType]"
    gcp_conn_id: "str"
    bigquery_conn_id: "typing.Union[str, NoneType]"
    delegate_to: "typing.Union[str, NoneType]"
    location: "typing.Union[str, NoneType]"
    impersonation_chain: "typing.Union[str, typing.Sequence[str], NoneType]"


class BigQueryCreateEmptyDatasetOperator(BaseOperator):
    dataset_id: "typing.Union[str, NoneType]"
    project_id: "typing.Union[str, NoneType]"
    dataset_reference: "typing.Union[typing.Dict, NoneType]"
    location: "typing.Union[str, NoneType]"
    gcp_conn_id: "str"
    bigquery_conn_id: "typing.Union[str, NoneType]"
    delegate_to: "typing.Union[str, NoneType]"
    impersonation_chain: "typing.Union[str, typing.Sequence[str], NoneType]"
    exists_ok: "bool"


class BigQueryCreateEmptyTableOperator(BaseOperator):
    dataset_id: "str"
    table_id: "str"
    table_resource: "typing.Union[typing.Dict[str, typing.Any], NoneType]"
    project_id: "typing.Union[str, NoneType]"
    schema_fields: "typing.Union[typing.List, NoneType]"
    gcs_schema_object: "typing.Union[str, NoneType]"
    time_partitioning: "typing.Union[typing.Dict, NoneType]"
    bigquery_conn_id: "str"
    google_cloud_storage_conn_id: "str"
    delegate_to: "typing.Union[str, NoneType]"
    labels: "typing.Union[typing.Dict, NoneType]"
    view: "typing.Union[typing.Dict, NoneType]"
    materialized_view: "typing.Union[typing.Dict, NoneType]"
    encryption_configuration: "typing.Union[typing.Dict, NoneType]"
    location: "typing.Union[str, NoneType]"
    cluster_fields: "typing.Union[typing.List[str], NoneType]"
    impersonation_chain: "typing.Union[str, typing.Sequence[str], NoneType]"
    exists_ok: "bool"


class BigQueryCreateExternalTableOperator(BaseOperator):
    bucket: "str"
    source_objects: "typing.List"
    destination_project_dataset_table: "str"
    table_resource: "typing.Union[typing.Dict[str, typing.Any], NoneType]"
    schema_fields: "typing.Union[typing.List, NoneType]"
    schema_object: "typing.Union[str, NoneType]"
    source_format: "str"
    compression: "str"
    skip_leading_rows: "int"
    field_delimiter: "str"
    max_bad_records: "int"
    quote_character: "typing.Union[str, NoneType]"
    allow_quoted_newlines: "bool"
    allow_jagged_rows: "bool"
    bigquery_conn_id: "str"
    google_cloud_storage_conn_id: "str"
    delegate_to: "typing.Union[str, NoneType]"
    src_fmt_configs: "typing.Union[dict, NoneType]"
    labels: "typing.Union[typing.Dict, NoneType]"
    encryption_configuration: "typing.Union[typing.Dict, NoneType]"
    location: "typing.Union[str, NoneType]"
    impersonation_chain: "typing.Union[str, typing.Sequence[str], NoneType]"


class BigQueryDeleteDatasetOperator(BaseOperator):
    dataset_id: "str"
    project_id: "typing.Union[str, NoneType]"
    delete_contents: "bool"
    gcp_conn_id: "str"
    bigquery_conn_id: "typing.Union[str, NoneType]"
    delegate_to: "typing.Union[str, NoneType]"
    impersonation_chain: "typing.Union[str, typing.Sequence[str], NoneType]"


class BigQueryExecuteQueryOperator(BaseOperator):
    sql: "typing.Union[str, typing.Iterable]"
    destination_dataset_table: "typing.Union[str, NoneType]"
    write_disposition: "str"
    allow_large_results: "typing.Union[bool, NoneType]"
    flatten_results: "typing.Union[bool, NoneType]"
    gcp_conn_id: "str"
    bigquery_conn_id: "typing.Union[str, NoneType]"
    delegate_to: "typing.Union[str, NoneType]"
    udf_config: "typing.Union[list, NoneType]"
    use_legacy_sql: "bool"
    maximum_billing_tier: "typing.Union[int, NoneType]"
    maximum_bytes_billed: "typing.Union[float, NoneType]"
    create_disposition: "str"
    schema_update_options: "typing.Union[list, tuple, set, NoneType]"
    query_params: "typing.Union[list, NoneType]"
    labels: "typing.Union[dict, NoneType]"
    priority: "str"
    time_partitioning: "typing.Union[dict, NoneType]"
    api_resource_configs: "typing.Union[dict, NoneType]"
    cluster_fields: "typing.Union[typing.List[str], NoneType]"
    location: "typing.Union[str, NoneType]"
    encryption_configuration: "typing.Union[dict, NoneType]"
    impersonation_chain: "typing.Union[str, typing.Sequence[str], NoneType]"


class BigQueryGetDatasetOperator(BaseOperator):
    dataset_id: "str"
    project_id: "typing.Union[str, NoneType]"
    gcp_conn_id: "str"
    delegate_to: "typing.Union[str, NoneType]"
    impersonation_chain: "typing.Union[str, typing.Sequence[str], NoneType]"


class BigQueryGetDatasetTablesOperator(BaseOperator):
    dataset_id: "str"
    project_id: "typing.Union[str, NoneType]"
    max_results: "typing.Union[int, NoneType]"
    gcp_conn_id: "str"
    delegate_to: "typing.Union[str, NoneType]"
    impersonation_chain: "typing.Union[str, typing.Sequence[str], NoneType]"


class BigQueryPatchDatasetOperator(BaseOperator):
    dataset_id: "str"
    dataset_resource: "dict"
    project_id: "typing.Union[str, NoneType]"
    gcp_conn_id: "str"
    delegate_to: "typing.Union[str, NoneType]"
    impersonation_chain: "typing.Union[str, typing.Sequence[str], NoneType]"


class BigQueryUpdateDatasetOperator(BaseOperator):
    dataset_resource: "typing.Dict[str, typing.Any]"
    fields: "typing.Union[typing.List[str], NoneType]"
    dataset_id: "typing.Union[str, NoneType]"
    project_id: "typing.Union[str, NoneType]"
    gcp_conn_id: "str"
    delegate_to: "typing.Union[str, NoneType]"
    impersonation_chain: "typing.Union[str, typing.Sequence[str], NoneType]"


class BigQueryUpsertTableOperator(BaseOperator):
    dataset_id: "str"
    table_resource: "dict"
    project_id: "typing.Union[str, NoneType]"
    gcp_conn_id: "str"
    bigquery_conn_id: "typing.Union[str, NoneType]"
    delegate_to: "typing.Union[str, NoneType]"
    location: "typing.Union[str, NoneType]"
    impersonation_chain: "typing.Union[str, typing.Sequence[str], NoneType]"


class BigQueryDeleteTableOperator(BaseOperator):
    deletion_dataset_table: "str"
    gcp_conn_id: "str"
    bigquery_conn_id: "typing.Union[str, NoneType]"
    delegate_to: "typing.Union[str, NoneType]"
    ignore_if_missing: "bool"
    location: "typing.Union[str, NoneType]"
    impersonation_chain: "typing.Union[str, typing.Sequence[str], NoneType]"
