from typing import Any
from typing import Text
from typing import Callable
from typing import Optional

__all__ = [
    "CreateFailed",
    "FSError",
    "NoSysPath",
    "PathError",
    "ResourceError",
    "ResourceNotFound",
    "ResourceReadOnly",
]

class FSError(Exception):
    default_message: str = ...

    def __init__(self, msg: Optional[Text] = ...) -> None: ...
    def __str__(self) -> Text: ...
    def __repr__(self) -> Text: ...

class PathError(FSError):
    default_message: str = ...

    def __init__(
        self, path: Text, msg: Optional[Text] = ..., exc: Optional[Exception] = ...
    ) -> None: ...
    def __reduce__(self) -> str: ...

class NoSysPath(PathError): ...

class CreateFailed(FSError):
    def __init__(
        self, msg: Optional[Text] = ..., exc: Optional[Exception] = ...
    ) -> None: ...
    @classmethod
    def catch_all(cls, func: Callable[..., Any]) -> Callable[..., Any]: ...
    def __reduce__(self) -> Text: ...

class ResourceError(FSError):
    default_message = ...

    def __init__(
        self, path: Text, exc: Optional[Exception] = ..., msg: Optional[Text] = ...
    ) -> None: ...

class ResourceNotFound(ResourceError): ...
class ResourceReadOnly(ResourceError): ...
