import typing
from typing import List
from typing import Text
from typing import Type
from typing import Tuple
from typing import Union
from typing import Iterable
from typing import Iterator
from typing import Optional

if typing.TYPE_CHECKING: ...

def make_mode(init: Union[int, Iterable[Text], None]) -> int: ...

class _PermProperty:
    def __init__(self, name: Text) -> None: ...
    def __get__(
        self, obj: Permissions, obj_type: Optional[Type[Permissions]] = ...
    ) -> bool: ...
    def __set__(self, obj: Permissions, value: bool) -> None: ...

class Permissions:
    _LINUX_PERMS: List[Tuple[Text, int]] = ...
    _LINUX_PERMS_NAMES: List[Text] = ...

    def __init__(
        self,
        names: Optional[Iterable[Text]] = ...,
        mode: Optional[int] = ...,
        user: Optional[Text] = ...,
        group: Optional[Text] = ...,
        other: Optional[Text] = ...,
        sticky: Optional[bool] = ...,
        setuid: Optional[bool] = ...,
        setguid: Optional[bool] = ...,
    ) -> None: ...
    def __repr__(self) -> Text: ...
    def __str__(self) -> Text: ...
    def __iter__(self) -> Iterator[Text]: ...
    def __contains__(self, permission: object) -> bool: ...
    def __eq__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    @classmethod
    def parse(cls, ls: Text) -> Permissions: ...
    @classmethod
    def load(cls, permissions: List[Text]) -> Permissions: ...
    @classmethod
    def create(cls, init: Union[int, Iterable[Text], None] = ...) -> Permissions: ...
    @classmethod
    def get_mode(cls, init: Union[int, Iterable[Text], None]) -> int: ...
    def copy(self) -> Permissions: ...
    def dump(self) -> List[Text]: ...
    def as_str(self) -> Text: ...
    @property
    def mode(self) -> int: ...
    @mode.setter
    def mode(self, mode: int) -> None: ...
    def add(self, *permissions: Text) -> None: ...
    def remove(self, *permissions: Text) -> None: ...
    def check(self, *permissions: Text) -> bool: ...
