"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2018-2023, NVIDIA CORPORATION & AFFILIATES. All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
 * Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
 * Neither the name of NVIDIA CORPORATION nor the names of its
   contributors may be used to endorse or promote products derived
   from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Copyright (c) 2018, TensorFlow Authors. All rights reserved.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _DataType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DataTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DataType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    TYPE_INVALID: _DataType.ValueType  # 0
    """@@  .. cpp:enumerator:: DataType::INVALID = 0"""
    TYPE_BOOL: _DataType.ValueType  # 1
    """@@  .. cpp:enumerator:: DataType::BOOL = 1"""
    TYPE_UINT8: _DataType.ValueType  # 2
    """@@  .. cpp:enumerator:: DataType::UINT8 = 2"""
    TYPE_UINT16: _DataType.ValueType  # 3
    """@@  .. cpp:enumerator:: DataType::UINT16 = 3"""
    TYPE_UINT32: _DataType.ValueType  # 4
    """@@  .. cpp:enumerator:: DataType::UINT32 = 4"""
    TYPE_UINT64: _DataType.ValueType  # 5
    """@@  .. cpp:enumerator:: DataType::UINT64 = 5"""
    TYPE_INT8: _DataType.ValueType  # 6
    """@@  .. cpp:enumerator:: DataType::INT8 = 6"""
    TYPE_INT16: _DataType.ValueType  # 7
    """@@  .. cpp:enumerator:: DataType::INT16 = 7"""
    TYPE_INT32: _DataType.ValueType  # 8
    """@@  .. cpp:enumerator:: DataType::INT32 = 8"""
    TYPE_INT64: _DataType.ValueType  # 9
    """@@  .. cpp:enumerator:: DataType::INT64 = 9"""
    TYPE_FP16: _DataType.ValueType  # 10
    """@@  .. cpp:enumerator:: DataType::FP16 = 10"""
    TYPE_FP32: _DataType.ValueType  # 11
    """@@  .. cpp:enumerator:: DataType::FP32 = 11"""
    TYPE_FP64: _DataType.ValueType  # 12
    """@@  .. cpp:enumerator:: DataType::FP64 = 12"""
    TYPE_STRING: _DataType.ValueType  # 13
    """@@  .. cpp:enumerator:: DataType::STRING = 13"""
    TYPE_BF16: _DataType.ValueType  # 14
    """@@  .. cpp:enumerator:: DataType::BF16 = 14"""

class DataType(_DataType, metaclass=_DataTypeEnumTypeWrapper):
    """@@.. cpp:namespace:: inference

    @@
    @@.. cpp:enum:: DataType
    @@
    @@   Data types supported for input and output tensors.
    @@
    """

TYPE_INVALID: DataType.ValueType  # 0
"""@@  .. cpp:enumerator:: DataType::INVALID = 0"""
TYPE_BOOL: DataType.ValueType  # 1
"""@@  .. cpp:enumerator:: DataType::BOOL = 1"""
TYPE_UINT8: DataType.ValueType  # 2
"""@@  .. cpp:enumerator:: DataType::UINT8 = 2"""
TYPE_UINT16: DataType.ValueType  # 3
"""@@  .. cpp:enumerator:: DataType::UINT16 = 3"""
TYPE_UINT32: DataType.ValueType  # 4
"""@@  .. cpp:enumerator:: DataType::UINT32 = 4"""
TYPE_UINT64: DataType.ValueType  # 5
"""@@  .. cpp:enumerator:: DataType::UINT64 = 5"""
TYPE_INT8: DataType.ValueType  # 6
"""@@  .. cpp:enumerator:: DataType::INT8 = 6"""
TYPE_INT16: DataType.ValueType  # 7
"""@@  .. cpp:enumerator:: DataType::INT16 = 7"""
TYPE_INT32: DataType.ValueType  # 8
"""@@  .. cpp:enumerator:: DataType::INT32 = 8"""
TYPE_INT64: DataType.ValueType  # 9
"""@@  .. cpp:enumerator:: DataType::INT64 = 9"""
TYPE_FP16: DataType.ValueType  # 10
"""@@  .. cpp:enumerator:: DataType::FP16 = 10"""
TYPE_FP32: DataType.ValueType  # 11
"""@@  .. cpp:enumerator:: DataType::FP32 = 11"""
TYPE_FP64: DataType.ValueType  # 12
"""@@  .. cpp:enumerator:: DataType::FP64 = 12"""
TYPE_STRING: DataType.ValueType  # 13
"""@@  .. cpp:enumerator:: DataType::STRING = 13"""
TYPE_BF16: DataType.ValueType  # 14
"""@@  .. cpp:enumerator:: DataType::BF16 = 14"""
global___DataType = DataType

class ModelRateLimiter(google.protobuf.message.Message):
    """@@
    @@  .. cpp:var:: message ModelRateLimiter
    @@
    @@     The specifications required by the rate limiter to properly
    @@     schedule the inference requests across the different models
    @@     and their instances.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class Resource(google.protobuf.message.Message):
        """@@  .. cpp:var:: message Resource
        @@
        @@     The resource property.
        @@
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        GLOBAL_FIELD_NUMBER: builtins.int
        COUNT_FIELD_NUMBER: builtins.int
        name: builtins.str
        """@@  .. cpp:var:: string name
        @@
        @@     The name associated with the resource.
        @@
        """
        count: builtins.int
        """@@  .. cpp:var:: uint32 count
        @@
        @@     The number of resources required for the execution of the model
        @@     instance.
        @@
        """
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            count: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["count", b"count", "global", b"global", "name", b"name"]) -> None: ...

    RESOURCES_FIELD_NUMBER: builtins.int
    PRIORITY_FIELD_NUMBER: builtins.int
    @property
    def resources(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelRateLimiter.Resource]:
        """@@  .. cpp:var:: Resource resources (repeated)
        @@
        @@     The resources required to execute the request on a model instance.
        @@     Resources are just names with a corresponding count. The execution
        @@     of the instance will be blocked until the specificied resources are
        @@     available. By default an instance uses no rate-limiter resources.
        @@
        """
    priority: builtins.int
    """@@  .. cpp:var:: uint32 priority
    @@
    @@     The optional weighting value to be used for prioritizing across
    @@     instances. An instance with priority 2 will be given 1/2 the
    @@     number of scheduling chances as an instance_group with priority
    @@     1. The default priority is 1. The priority of value 0 will be
    @@     treated as priority 1.
    @@
    """
    def __init__(
        self,
        *,
        resources: collections.abc.Iterable[global___ModelRateLimiter.Resource] | None = ...,
        priority: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["priority", b"priority", "resources", b"resources"]) -> None: ...

global___ModelRateLimiter = ModelRateLimiter

class ModelInstanceGroup(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ModelInstanceGroup
    @@
    @@   A group of one or more instances of a model and resources made
    @@   available for those instances.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Kind:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _KindEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ModelInstanceGroup._Kind.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        KIND_AUTO: ModelInstanceGroup._Kind.ValueType  # 0
        """@@    .. cpp:enumerator:: Kind::KIND_AUTO = 0
        @@
        @@       This instance group represents instances that can run on either
        @@       CPU or GPU. If all GPUs listed in 'gpus' are available then
        @@       instances will be created on GPU(s), otherwise instances will
        @@       be created on CPU.
        @@
        """
        KIND_GPU: ModelInstanceGroup._Kind.ValueType  # 1
        """@@    .. cpp:enumerator:: Kind::KIND_GPU = 1
        @@
        @@       This instance group represents instances that must run on the
        @@       GPU.
        @@
        """
        KIND_CPU: ModelInstanceGroup._Kind.ValueType  # 2
        """@@    .. cpp:enumerator:: Kind::KIND_CPU = 2
        @@
        @@       This instance group represents instances that must run on the
        @@       CPU.
        @@
        """
        KIND_MODEL: ModelInstanceGroup._Kind.ValueType  # 3
        """@@    .. cpp:enumerator:: Kind::KIND_MODEL = 3
        @@
        @@       This instance group represents instances that should run on the
        @@       CPU and/or GPU(s) as specified by the model or backend itself.
        @@       The inference server will not override the model/backend
        @@       settings.
        @@
        """

    class Kind(_Kind, metaclass=_KindEnumTypeWrapper):
        """@@
        @@  .. cpp:enum:: Kind
        @@
        @@     Kind of this instance group.
        @@
        """

    KIND_AUTO: ModelInstanceGroup.Kind.ValueType  # 0
    """@@    .. cpp:enumerator:: Kind::KIND_AUTO = 0
    @@
    @@       This instance group represents instances that can run on either
    @@       CPU or GPU. If all GPUs listed in 'gpus' are available then
    @@       instances will be created on GPU(s), otherwise instances will
    @@       be created on CPU.
    @@
    """
    KIND_GPU: ModelInstanceGroup.Kind.ValueType  # 1
    """@@    .. cpp:enumerator:: Kind::KIND_GPU = 1
    @@
    @@       This instance group represents instances that must run on the
    @@       GPU.
    @@
    """
    KIND_CPU: ModelInstanceGroup.Kind.ValueType  # 2
    """@@    .. cpp:enumerator:: Kind::KIND_CPU = 2
    @@
    @@       This instance group represents instances that must run on the
    @@       CPU.
    @@
    """
    KIND_MODEL: ModelInstanceGroup.Kind.ValueType  # 3
    """@@    .. cpp:enumerator:: Kind::KIND_MODEL = 3
    @@
    @@       This instance group represents instances that should run on the
    @@       CPU and/or GPU(s) as specified by the model or backend itself.
    @@       The inference server will not override the model/backend
    @@       settings.
    @@
    """

    class SecondaryDevice(google.protobuf.message.Message):
        """@@
        @@  .. cpp:var:: message SecondaryDevice
        @@
        @@     A secondary device required for a model instance.
        @@
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _SecondaryDeviceKind:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _SecondaryDeviceKindEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ModelInstanceGroup.SecondaryDevice._SecondaryDeviceKind.ValueType], builtins.type):  # noqa: F821
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            KIND_NVDLA: ModelInstanceGroup.SecondaryDevice._SecondaryDeviceKind.ValueType  # 0
            """@@    .. cpp:enumerator:: SecondaryDeviceKind::KIND_NVDLA = 0
            @@
            @@       An NVDLA core. http://nvdla.org
            @@       Currently KIND_NVDLA is only supported by the TensorRT backend.
            @@
            """

        class SecondaryDeviceKind(_SecondaryDeviceKind, metaclass=_SecondaryDeviceKindEnumTypeWrapper):
            """@@
            @@  .. cpp:enum:: SecondaryDeviceKind
            @@
            @@     The kind of the secondary device.
            @@
            """

        KIND_NVDLA: ModelInstanceGroup.SecondaryDevice.SecondaryDeviceKind.ValueType  # 0
        """@@    .. cpp:enumerator:: SecondaryDeviceKind::KIND_NVDLA = 0
        @@
        @@       An NVDLA core. http://nvdla.org
        @@       Currently KIND_NVDLA is only supported by the TensorRT backend.
        @@
        """

        KIND_FIELD_NUMBER: builtins.int
        DEVICE_ID_FIELD_NUMBER: builtins.int
        kind: global___ModelInstanceGroup.SecondaryDevice.SecondaryDeviceKind.ValueType
        """@@  .. cpp:var:: SecondaryDeviceKind kind
        @@
        @@     The secondary device kind.
        @@
        """
        device_id: builtins.int
        """@@  .. cpp:var:: int64 device_id
        @@
        @@     Identifier for the secondary device.
        @@
        """
        def __init__(
            self,
            *,
            kind: global___ModelInstanceGroup.SecondaryDevice.SecondaryDeviceKind.ValueType = ...,
            device_id: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["device_id", b"device_id", "kind", b"kind"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    KIND_FIELD_NUMBER: builtins.int
    COUNT_FIELD_NUMBER: builtins.int
    RATE_LIMITER_FIELD_NUMBER: builtins.int
    GPUS_FIELD_NUMBER: builtins.int
    SECONDARY_DEVICES_FIELD_NUMBER: builtins.int
    PROFILE_FIELD_NUMBER: builtins.int
    PASSIVE_FIELD_NUMBER: builtins.int
    HOST_POLICY_FIELD_NUMBER: builtins.int
    name: builtins.str
    """@@  .. cpp:var:: string name
    @@
    @@     Optional name of this group of instances. If not specified the
    @@     name will be formed as <model name>_<group number>. The name of
    @@     individual instances will be further formed by a unique instance
    @@     number and GPU index:
    @@
    """
    kind: global___ModelInstanceGroup.Kind.ValueType
    """@@  .. cpp:var:: Kind kind
    @@
    @@     The kind of this instance group. Default is KIND_AUTO. If
    @@     KIND_AUTO or KIND_GPU then both 'count' and 'gpu' are valid and
    @@     may be specified. If KIND_CPU or KIND_MODEL only 'count' is valid
    @@     and 'gpu' cannot be specified.
    @@
    """
    count: builtins.int
    """@@  .. cpp:var:: int32 count
    @@
    @@     For a group assigned to GPU, the number of instances created for
    @@     each GPU listed in 'gpus'. For a group assigned to CPU the number
    @@     of instances created. Default is 1.
    """
    @property
    def rate_limiter(self) -> global___ModelRateLimiter:
        """@@  .. cpp:var:: ModelRateLimiter rate_limiter
        @@
        @@     The rate limiter specific settings to be associated with this
        @@     instance group. Optional, if not specified no rate limiting
        @@     will be applied to this instance group.
        @@
        """
    @property
    def gpus(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """@@  .. cpp:var:: int32 gpus (repeated)
        @@
        @@     GPU(s) where instances should be available. For each GPU listed,
        @@     'count' instances of the model will be available. Setting 'gpus'
        @@     to empty (or not specifying at all) is eqivalent to listing all
        @@     available GPUs.
        @@
        """
    @property
    def secondary_devices(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelInstanceGroup.SecondaryDevice]:
        """@@  .. cpp:var:: SecondaryDevice secondary_devices (repeated)
        @@
        @@     Secondary devices that are required by instances specified by this
        @@     instance group. Optional.
        @@
        """
    @property
    def profile(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """@@  .. cpp:var:: string profile (repeated)
        @@
        @@     For TensorRT models containing multiple optimization profile, this
        @@     parameter specifies a set of optimization profiles available to this
        @@     instance group. The inference server will choose the optimal profile
        @@     based on the shapes of the input tensors. This field should lie
        @@     between 0 and <TotalNumberOfOptimizationProfilesInPlanModel> - 1
        @@     and be specified only for TensorRT backend, otherwise an error will
        @@     be generated. If not specified, the server will select the first
        @@     optimization profile by default.
        @@
        """
    passive: builtins.bool
    """@@  .. cpp:var:: bool passive
    @@
    @@     Whether the instances within this instance group will be accepting
    @@     inference requests from the scheduler. If true, the instances will
    @@     not be added to the scheduler. Default value is false.
    @@
    """
    host_policy: builtins.str
    """@@  .. cpp:var:: string host_policy
    @@
    @@     The host policy name that the instance to be associated with.
    @@     The default value is set to reflect the device kind of the instance,
    @@     for instance, KIND_CPU is "cpu", KIND_MODEL is "model" and
    @@     KIND_GPU is "gpu_<gpu_id>".
    @@
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        kind: global___ModelInstanceGroup.Kind.ValueType = ...,
        count: builtins.int = ...,
        rate_limiter: global___ModelRateLimiter | None = ...,
        gpus: collections.abc.Iterable[builtins.int] | None = ...,
        secondary_devices: collections.abc.Iterable[global___ModelInstanceGroup.SecondaryDevice] | None = ...,
        profile: collections.abc.Iterable[builtins.str] | None = ...,
        passive: builtins.bool = ...,
        host_policy: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["rate_limiter", b"rate_limiter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["count", b"count", "gpus", b"gpus", "host_policy", b"host_policy", "kind", b"kind", "name", b"name", "passive", b"passive", "profile", b"profile", "rate_limiter", b"rate_limiter", "secondary_devices", b"secondary_devices"]) -> None: ...

global___ModelInstanceGroup = ModelInstanceGroup

class ModelTensorReshape(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ModelTensorReshape
    @@
    @@   Reshape specification for input and output tensors.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SHAPE_FIELD_NUMBER: builtins.int
    @property
    def shape(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """@@  .. cpp:var:: int64 shape (repeated)
        @@
        @@     The shape to use for reshaping.
        @@
        """
    def __init__(
        self,
        *,
        shape: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["shape", b"shape"]) -> None: ...

global___ModelTensorReshape = ModelTensorReshape

class ModelInput(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ModelInput
    @@
    @@   An input required by the model.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Format:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _FormatEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ModelInput._Format.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        FORMAT_NONE: ModelInput._Format.ValueType  # 0
        """@@    .. cpp:enumerator:: Format::FORMAT_NONE = 0
        @@
        @@       The input has no specific format. This is the default.
        @@
        """
        FORMAT_NHWC: ModelInput._Format.ValueType  # 1
        """@@    .. cpp:enumerator:: Format::FORMAT_NHWC = 1
        @@
        @@       HWC image format. Tensors with this format require 3 dimensions
        @@       if the model does not support batching (max_batch_size = 0) or 4
        @@       dimensions if the model does support batching (max_batch_size
        @@       >= 1). In either case the 'dims' below should only specify the
        @@       3 non-batch dimensions (i.e. HWC or CHW).
        @@
        """
        FORMAT_NCHW: ModelInput._Format.ValueType  # 2
        """@@    .. cpp:enumerator:: Format::FORMAT_NCHW = 2
        @@
        @@       CHW image format. Tensors with this format require 3 dimensions
        @@       if the model does not support batching (max_batch_size = 0) or 4
        @@       dimensions if the model does support batching (max_batch_size
        @@       >= 1). In either case the 'dims' below should only specify the
        @@       3 non-batch dimensions (i.e. HWC or CHW).
        @@
        """

    class Format(_Format, metaclass=_FormatEnumTypeWrapper):
        """@@
        @@  .. cpp:enum:: Format
        @@
        @@     The format for the input.
        @@
        """

    FORMAT_NONE: ModelInput.Format.ValueType  # 0
    """@@    .. cpp:enumerator:: Format::FORMAT_NONE = 0
    @@
    @@       The input has no specific format. This is the default.
    @@
    """
    FORMAT_NHWC: ModelInput.Format.ValueType  # 1
    """@@    .. cpp:enumerator:: Format::FORMAT_NHWC = 1
    @@
    @@       HWC image format. Tensors with this format require 3 dimensions
    @@       if the model does not support batching (max_batch_size = 0) or 4
    @@       dimensions if the model does support batching (max_batch_size
    @@       >= 1). In either case the 'dims' below should only specify the
    @@       3 non-batch dimensions (i.e. HWC or CHW).
    @@
    """
    FORMAT_NCHW: ModelInput.Format.ValueType  # 2
    """@@    .. cpp:enumerator:: Format::FORMAT_NCHW = 2
    @@
    @@       CHW image format. Tensors with this format require 3 dimensions
    @@       if the model does not support batching (max_batch_size = 0) or 4
    @@       dimensions if the model does support batching (max_batch_size
    @@       >= 1). In either case the 'dims' below should only specify the
    @@       3 non-batch dimensions (i.e. HWC or CHW).
    @@
    """

    NAME_FIELD_NUMBER: builtins.int
    DATA_TYPE_FIELD_NUMBER: builtins.int
    FORMAT_FIELD_NUMBER: builtins.int
    DIMS_FIELD_NUMBER: builtins.int
    RESHAPE_FIELD_NUMBER: builtins.int
    IS_SHAPE_TENSOR_FIELD_NUMBER: builtins.int
    ALLOW_RAGGED_BATCH_FIELD_NUMBER: builtins.int
    OPTIONAL_FIELD_NUMBER: builtins.int
    name: builtins.str
    """@@  .. cpp:var:: string name
    @@
    @@     The name of the input.
    @@
    """
    data_type: global___DataType.ValueType
    """@@  .. cpp:var:: DataType data_type
    @@
    @@     The data-type of the input.
    @@
    """
    format: global___ModelInput.Format.ValueType
    """@@  .. cpp:var:: Format format
    @@
    @@     The format of the input. Optional.
    @@
    """
    @property
    def dims(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """@@  .. cpp:var:: int64 dims (repeated)
        @@
        @@     The dimensions/shape of the input tensor that must be provided
        @@     when invoking the inference API for this model.
        @@
        """
    @property
    def reshape(self) -> global___ModelTensorReshape:
        """@@  .. cpp:var:: ModelTensorReshape reshape
        @@
        @@     The shape expected for this input by the backend. The input will
        @@     be reshaped to this before being presented to the backend. The
        @@     reshape must have the same number of elements as the input shape
        @@     specified by 'dims'. Optional.
        @@
        """
    is_shape_tensor: builtins.bool
    """@@  .. cpp:var:: bool is_shape_tensor
    @@
    @@     Whether or not the input is a shape tensor to the model. This field
    @@     is currently supported only for the TensorRT model. An error will be
    @@     generated if this specification does not comply with underlying
    @@     model.
    @@
    """
    allow_ragged_batch: builtins.bool
    """@@  .. cpp:var:: bool allow_ragged_batch
    @@
    @@     Whether or not the input is allowed to be "ragged" in a dynamically
    @@     created batch. Default is false indicating that two requests will
    @@     only be batched if this tensor has the same shape in both requests.
    @@     True indicates that two requests can be batched even if this tensor
    @@     has a different shape in each request.
    @@
    """
    optional: builtins.bool
    """@@  .. cpp:var:: bool optional
    @@
    @@     Whether or not the input is optional for the model execution.
    @@     If true, the input is not required in the inference request.
    @@     Default value is false.
    @@
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        data_type: global___DataType.ValueType = ...,
        format: global___ModelInput.Format.ValueType = ...,
        dims: collections.abc.Iterable[builtins.int] | None = ...,
        reshape: global___ModelTensorReshape | None = ...,
        is_shape_tensor: builtins.bool = ...,
        allow_ragged_batch: builtins.bool = ...,
        optional: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["reshape", b"reshape"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["allow_ragged_batch", b"allow_ragged_batch", "data_type", b"data_type", "dims", b"dims", "format", b"format", "is_shape_tensor", b"is_shape_tensor", "name", b"name", "optional", b"optional", "reshape", b"reshape"]) -> None: ...

global___ModelInput = ModelInput

class ModelOutput(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ModelOutput
    @@
    @@   An output produced by the model.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DATA_TYPE_FIELD_NUMBER: builtins.int
    DIMS_FIELD_NUMBER: builtins.int
    RESHAPE_FIELD_NUMBER: builtins.int
    LABEL_FILENAME_FIELD_NUMBER: builtins.int
    IS_SHAPE_TENSOR_FIELD_NUMBER: builtins.int
    name: builtins.str
    """@@  .. cpp:var:: string name
    @@
    @@     The name of the output.
    @@
    """
    data_type: global___DataType.ValueType
    """@@  .. cpp:var:: DataType data_type
    @@
    @@     The data-type of the output.
    @@
    """
    @property
    def dims(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """@@  .. cpp:var:: int64 dims (repeated)
        @@
        @@     The dimensions/shape of the output tensor.
        @@
        """
    @property
    def reshape(self) -> global___ModelTensorReshape:
        """@@  .. cpp:var:: ModelTensorReshape reshape
        @@
        @@     The shape produced for this output by the backend. The output will
        @@     be reshaped from this to the shape specifed in 'dims' before being
        @@     returned in the inference response. The reshape must have the same
        @@     number of elements as the output shape specified by 'dims'. Optional.
        @@
        """
    label_filename: builtins.str
    """@@  .. cpp:var:: string label_filename
    @@
    @@     The label file associated with this output. Should be specified only
    @@     for outputs that represent classifications. Optional.
    @@
    """
    is_shape_tensor: builtins.bool
    """@@  .. cpp:var:: bool is_shape_tensor
    @@
    @@     Whether or not the output is a shape tensor to the model. This field
    @@     is currently supported only for the TensorRT model. An error will be
    @@     generated if this specification does not comply with underlying
    @@     model.
    @@
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        data_type: global___DataType.ValueType = ...,
        dims: collections.abc.Iterable[builtins.int] | None = ...,
        reshape: global___ModelTensorReshape | None = ...,
        label_filename: builtins.str = ...,
        is_shape_tensor: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["reshape", b"reshape"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["data_type", b"data_type", "dims", b"dims", "is_shape_tensor", b"is_shape_tensor", "label_filename", b"label_filename", "name", b"name", "reshape", b"reshape"]) -> None: ...

global___ModelOutput = ModelOutput

class BatchInput(google.protobuf.message.Message):
    """@@  .. cpp:var:: message BatchInput
    @@
    @@     A batch input is an additional input that must be added by
    @@     the backend based on all the requests in a batch.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Kind:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _KindEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[BatchInput._Kind.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        BATCH_ELEMENT_COUNT: BatchInput._Kind.ValueType  # 0
        """@@      .. cpp:enumerator:: Kind::BATCH_ELEMENT_COUNT = 0
        @@
        @@         The element count of the 'source_input' will be added as
        @@         input with shape [1].
        @@
        """
        BATCH_ACCUMULATED_ELEMENT_COUNT: BatchInput._Kind.ValueType  # 1
        """@@      .. cpp:enumerator:: Kind::BATCH_ACCUMULATED_ELEMENT_COUNT = 1
        @@
        @@         The accumulated element count of the 'source_input' will be
        @@         added as input with shape [1]. For example, if there is a
        @@         batch of two request, each with 2 elements, an input of value
        @@         2 will be added to the first request, and an input of value
        @@         4 will be added to the second request.
        @@
        """
        BATCH_ACCUMULATED_ELEMENT_COUNT_WITH_ZERO: BatchInput._Kind.ValueType  # 2
        """@@      .. cpp:enumerator::
        @@         Kind::BATCH_ACCUMULATED_ELEMENT_COUNT_WITH_ZERO = 2
        @@
        @@         The accumulated element count of the 'source_input' will be
        @@         added as input with shape [1], except for the first request
        @@         in the batch. For the first request in the batch, the input
        @@         will have shape [2] where the first element is value 0.
        @@
        """
        BATCH_MAX_ELEMENT_COUNT_AS_SHAPE: BatchInput._Kind.ValueType  # 3
        """@@      .. cpp:enumerator:: Kind::BATCH_MAX_ELEMENT_COUNT_AS_SHAPE = 3
        @@
        @@         Among the requests in the batch, the max element count of the
        @@         'source_input' will be added as input with shape
        @@         [max_element_count] for the first request in the batch.
        @@         For other requests, such input will be with shape [0].
        @@         The data of the tensor will be uninitialized.
        @@
        """
        BATCH_ITEM_SHAPE: BatchInput._Kind.ValueType  # 4
        """@@      .. cpp:enumerator:: Kind::BATCH_ITEM_SHAPE = 4
        @@
        @@         Among the requests in the batch, the shape of the
        @@         'source_input' will be added as input with shape
        @@         [batch_size, len(input_dim)]. For example, if one
        @@         batch-2 input with shape [3, 1] and batch-1 input
        @@         with shape [2, 2] are batched, the batch input will
        @@         have shape [3, 2] and value [ [3, 1], [3, 1], [2, 2]].
        @@
        """
        BATCH_ITEM_SHAPE_FLATTEN: BatchInput._Kind.ValueType  # 5
        """@@      .. cpp:enumerator:: Kind::BATCH_ITEM_SHAPE_FLATTEN = 5
        @@
        @@         Among the requests in the batch, the shape of the
        @@         'source_input' will be added as input with single dimensional
        @@         shape [batch_size * len(input_dim)]. For example, if one
        @@         batch-2 input with shape [3, 1] and batch-1 input
        @@         with shape [2, 2] are batched, the batch input will
        @@         have shape [6] and value [3, 1, 3, 1, 2, 2].
        @@
        """

    class Kind(_Kind, metaclass=_KindEnumTypeWrapper):
        """@@
        @@    .. cpp:enum:: Kind
        @@
        @@       The kind of the batch input.
        @@
        """

    BATCH_ELEMENT_COUNT: BatchInput.Kind.ValueType  # 0
    """@@      .. cpp:enumerator:: Kind::BATCH_ELEMENT_COUNT = 0
    @@
    @@         The element count of the 'source_input' will be added as
    @@         input with shape [1].
    @@
    """
    BATCH_ACCUMULATED_ELEMENT_COUNT: BatchInput.Kind.ValueType  # 1
    """@@      .. cpp:enumerator:: Kind::BATCH_ACCUMULATED_ELEMENT_COUNT = 1
    @@
    @@         The accumulated element count of the 'source_input' will be
    @@         added as input with shape [1]. For example, if there is a
    @@         batch of two request, each with 2 elements, an input of value
    @@         2 will be added to the first request, and an input of value
    @@         4 will be added to the second request.
    @@
    """
    BATCH_ACCUMULATED_ELEMENT_COUNT_WITH_ZERO: BatchInput.Kind.ValueType  # 2
    """@@      .. cpp:enumerator::
    @@         Kind::BATCH_ACCUMULATED_ELEMENT_COUNT_WITH_ZERO = 2
    @@
    @@         The accumulated element count of the 'source_input' will be
    @@         added as input with shape [1], except for the first request
    @@         in the batch. For the first request in the batch, the input
    @@         will have shape [2] where the first element is value 0.
    @@
    """
    BATCH_MAX_ELEMENT_COUNT_AS_SHAPE: BatchInput.Kind.ValueType  # 3
    """@@      .. cpp:enumerator:: Kind::BATCH_MAX_ELEMENT_COUNT_AS_SHAPE = 3
    @@
    @@         Among the requests in the batch, the max element count of the
    @@         'source_input' will be added as input with shape
    @@         [max_element_count] for the first request in the batch.
    @@         For other requests, such input will be with shape [0].
    @@         The data of the tensor will be uninitialized.
    @@
    """
    BATCH_ITEM_SHAPE: BatchInput.Kind.ValueType  # 4
    """@@      .. cpp:enumerator:: Kind::BATCH_ITEM_SHAPE = 4
    @@
    @@         Among the requests in the batch, the shape of the
    @@         'source_input' will be added as input with shape
    @@         [batch_size, len(input_dim)]. For example, if one
    @@         batch-2 input with shape [3, 1] and batch-1 input
    @@         with shape [2, 2] are batched, the batch input will
    @@         have shape [3, 2] and value [ [3, 1], [3, 1], [2, 2]].
    @@
    """
    BATCH_ITEM_SHAPE_FLATTEN: BatchInput.Kind.ValueType  # 5
    """@@      .. cpp:enumerator:: Kind::BATCH_ITEM_SHAPE_FLATTEN = 5
    @@
    @@         Among the requests in the batch, the shape of the
    @@         'source_input' will be added as input with single dimensional
    @@         shape [batch_size * len(input_dim)]. For example, if one
    @@         batch-2 input with shape [3, 1] and batch-1 input
    @@         with shape [2, 2] are batched, the batch input will
    @@         have shape [6] and value [3, 1, 3, 1, 2, 2].
    @@
    """

    KIND_FIELD_NUMBER: builtins.int
    TARGET_NAME_FIELD_NUMBER: builtins.int
    DATA_TYPE_FIELD_NUMBER: builtins.int
    SOURCE_INPUT_FIELD_NUMBER: builtins.int
    kind: global___BatchInput.Kind.ValueType
    """@@    .. cpp:var:: Kind kind
    @@
    @@       The kind of this batch input.
    @@
    """
    @property
    def target_name(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """@@    .. cpp:var:: string target_name (repeated)
        @@
        @@       The name of the model inputs that the backend will create
        @@       for this batch input.
        @@
        """
    data_type: global___DataType.ValueType
    """@@    .. cpp:var:: DataType data_type
    @@
    @@       The input's datatype. The data type can be TYPE_INT32 or
    @@       TYPE_FP32.
    @@
    """
    @property
    def source_input(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """@@    .. cpp:var:: string source_input (repeated)
        @@
        @@       The backend derives the value for each batch input from one or
        @@       more other inputs. 'source_input' gives the names of those
        @@       inputs.
        @@
        """
    def __init__(
        self,
        *,
        kind: global___BatchInput.Kind.ValueType = ...,
        target_name: collections.abc.Iterable[builtins.str] | None = ...,
        data_type: global___DataType.ValueType = ...,
        source_input: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["data_type", b"data_type", "kind", b"kind", "source_input", b"source_input", "target_name", b"target_name"]) -> None: ...

global___BatchInput = BatchInput

class BatchOutput(google.protobuf.message.Message):
    """@@.. cpp:var:: message BatchOutput
    @@
    @@   A batch output is an output produced by the model that must be handled
    @@   differently by the backend based on all the requests in a batch.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Kind:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _KindEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[BatchOutput._Kind.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        BATCH_SCATTER_WITH_INPUT_SHAPE: BatchOutput._Kind.ValueType  # 0
        """@@    .. cpp:enumerator:: Kind::BATCH_SCATTER_WITH_INPUT_SHAPE = 0
        @@
        @@       The output should be scattered according to the shape of
        @@       'source_input'. The dynamic dimension of the output will
        @@       be set to the value of the same dimension in the input.
        @@
        """

    class Kind(_Kind, metaclass=_KindEnumTypeWrapper):
        """@@
        @@  .. cpp:enum:: Kind
        @@
        @@     The kind of the batch output.
        @@
        """

    BATCH_SCATTER_WITH_INPUT_SHAPE: BatchOutput.Kind.ValueType  # 0
    """@@    .. cpp:enumerator:: Kind::BATCH_SCATTER_WITH_INPUT_SHAPE = 0
    @@
    @@       The output should be scattered according to the shape of
    @@       'source_input'. The dynamic dimension of the output will
    @@       be set to the value of the same dimension in the input.
    @@
    """

    TARGET_NAME_FIELD_NUMBER: builtins.int
    KIND_FIELD_NUMBER: builtins.int
    SOURCE_INPUT_FIELD_NUMBER: builtins.int
    @property
    def target_name(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """@@  .. cpp:var:: string target_name (repeated)
        @@
        @@     The name of the outputs to be produced by this batch output
        @@     specification.
        @@
        """
    kind: global___BatchOutput.Kind.ValueType
    """@@  .. cpp:var:: Kind kind
    @@
    @@     The kind of this batch output.
    @@
    """
    @property
    def source_input(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """@@  .. cpp:var:: string source_input (repeated)
        @@
        @@     The backend derives each batch output from one or more inputs.
        @@     'source_input' gives the names of those inputs.
        @@
        """
    def __init__(
        self,
        *,
        target_name: collections.abc.Iterable[builtins.str] | None = ...,
        kind: global___BatchOutput.Kind.ValueType = ...,
        source_input: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["kind", b"kind", "source_input", b"source_input", "target_name", b"target_name"]) -> None: ...

global___BatchOutput = BatchOutput

class ModelVersionPolicy(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ModelVersionPolicy
    @@
    @@   Policy indicating which versions of a model should be made
    @@   available by the inference server.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class Latest(google.protobuf.message.Message):
        """@@  .. cpp:var:: message Latest
        @@
        @@     Serve only the latest version(s) of a model. This is
        @@     the default policy.
        @@
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NUM_VERSIONS_FIELD_NUMBER: builtins.int
        num_versions: builtins.int
        """@@    .. cpp:var:: uint32 num_versions
        @@
        @@       Serve only the 'num_versions' highest-numbered versions. T
        @@       The default value of 'num_versions' is 1, indicating that by
        @@       default only the single highest-number version of a
        @@       model will be served.
        @@
        """
        def __init__(
            self,
            *,
            num_versions: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["num_versions", b"num_versions"]) -> None: ...

    class All(google.protobuf.message.Message):
        """@@  .. cpp:var:: message All
        @@
        @@     Serve all versions of the model.
        @@
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        def __init__(
            self,
        ) -> None: ...

    class Specific(google.protobuf.message.Message):
        """@@  .. cpp:var:: message Specific
        @@
        @@     Serve only specific versions of the model.
        @@
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        VERSIONS_FIELD_NUMBER: builtins.int
        @property
        def versions(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
            """@@    .. cpp:var:: int64 versions (repeated)
            @@
            @@       The specific versions of the model that will be served.
            @@
            """
        def __init__(
            self,
            *,
            versions: collections.abc.Iterable[builtins.int] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["versions", b"versions"]) -> None: ...

    LATEST_FIELD_NUMBER: builtins.int
    ALL_FIELD_NUMBER: builtins.int
    SPECIFIC_FIELD_NUMBER: builtins.int
    @property
    def latest(self) -> global___ModelVersionPolicy.Latest:
        """@@    .. cpp:var:: Latest latest
        @@
        @@       Serve only latest version(s) of the model.
        @@
        """
    @property
    def all(self) -> global___ModelVersionPolicy.All:
        """@@    .. cpp:var:: All all
        @@
        @@       Serve all versions of the model.
        @@
        """
    @property
    def specific(self) -> global___ModelVersionPolicy.Specific:
        """@@    .. cpp:var:: Specific specific
        @@
        @@       Serve only specific version(s) of the model.
        @@
        """
    def __init__(
        self,
        *,
        latest: global___ModelVersionPolicy.Latest | None = ...,
        all: global___ModelVersionPolicy.All | None = ...,
        specific: global___ModelVersionPolicy.Specific | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["all", b"all", "latest", b"latest", "policy_choice", b"policy_choice", "specific", b"specific"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["all", b"all", "latest", b"latest", "policy_choice", b"policy_choice", "specific", b"specific"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["policy_choice", b"policy_choice"]) -> typing_extensions.Literal["latest", "all", "specific"] | None: ...

global___ModelVersionPolicy = ModelVersionPolicy

class ModelOptimizationPolicy(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ModelOptimizationPolicy
    @@
    @@   Optimization settings for a model. These settings control if/how a
    @@   model is optimized and prioritized by the backend framework when
    @@   it is loaded.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ModelPriority:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ModelPriorityEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ModelOptimizationPolicy._ModelPriority.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PRIORITY_DEFAULT: ModelOptimizationPolicy._ModelPriority.ValueType  # 0
        """@@    .. cpp:enumerator:: ModelPriority::PRIORITY_DEFAULT = 0
        @@
        @@       The default model priority.
        @@
        """
        PRIORITY_MAX: ModelOptimizationPolicy._ModelPriority.ValueType  # 1
        """@@    .. cpp:enumerator:: ModelPriority::PRIORITY_MAX = 1
        @@
        @@       The maximum model priority.
        @@
        """
        PRIORITY_MIN: ModelOptimizationPolicy._ModelPriority.ValueType  # 2
        """@@    .. cpp:enumerator:: ModelPriority::PRIORITY_MIN = 2
        @@
        @@       The minimum model priority.
        @@
        """

    class ModelPriority(_ModelPriority, metaclass=_ModelPriorityEnumTypeWrapper):
        """@@
        @@  .. cpp:enum:: ModelPriority
        @@
        @@     Model priorities. A model will be given scheduling and execution
        @@     preference over models at lower priorities. Current model
        @@     priorities only work for TensorRT models.
        @@
        """

    PRIORITY_DEFAULT: ModelOptimizationPolicy.ModelPriority.ValueType  # 0
    """@@    .. cpp:enumerator:: ModelPriority::PRIORITY_DEFAULT = 0
    @@
    @@       The default model priority.
    @@
    """
    PRIORITY_MAX: ModelOptimizationPolicy.ModelPriority.ValueType  # 1
    """@@    .. cpp:enumerator:: ModelPriority::PRIORITY_MAX = 1
    @@
    @@       The maximum model priority.
    @@
    """
    PRIORITY_MIN: ModelOptimizationPolicy.ModelPriority.ValueType  # 2
    """@@    .. cpp:enumerator:: ModelPriority::PRIORITY_MIN = 2
    @@
    @@       The minimum model priority.
    @@
    """

    class Graph(google.protobuf.message.Message):
        """@@
        @@  .. cpp:var:: message Graph
        @@
        @@     Enable generic graph optimization of the model. If not specified
        @@     the framework's default level of optimization is used. Supports
        @@     TensorFlow graphdef and savedmodel and Onnx models. For TensorFlow
        @@     causes XLA to be enabled/disabled for the model. For Onnx defaults
        @@     to enabling all optimizations, -1 enables only basic optimizations,
        @@     +1 enables only basic and extended optimizations.
        @@
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        LEVEL_FIELD_NUMBER: builtins.int
        level: builtins.int
        """@@    .. cpp:var:: int32 level
        @@
        @@       The optimization level. Defaults to 0 (zero) if not specified.
        @@
        @@         - -1: Disabled
        @@         -  0: Framework default
        @@         -  1+: Enable optimization level (greater values indicate
        @@            higher optimization levels)
        @@
        """
        def __init__(
            self,
            *,
            level: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["level", b"level"]) -> None: ...

    class Cuda(google.protobuf.message.Message):
        """@@
        @@  .. cpp:var:: message Cuda
        @@
        @@     CUDA-specific optimization settings.
        @@
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class GraphSpec(google.protobuf.message.Message):
            """@@    .. cpp:var:: message GraphSpec
            @@
            @@       Specification of the CUDA graph to be captured.
            @@
            """

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            class Shape(google.protobuf.message.Message):
                """@@      .. cpp:var:: message Dims
                @@
                @@         Specification of tensor dimension.
                @@
                """

                DESCRIPTOR: google.protobuf.descriptor.Descriptor

                DIM_FIELD_NUMBER: builtins.int
                @property
                def dim(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
                    """@@        .. cpp:var:: int64 dim (repeated)
                    @@
                    @@           The dimension.
                    @@
                    """
                def __init__(
                    self,
                    *,
                    dim: collections.abc.Iterable[builtins.int] | None = ...,
                ) -> None: ...
                def ClearField(self, field_name: typing_extensions.Literal["dim", b"dim"]) -> None: ...

            class LowerBound(google.protobuf.message.Message):
                DESCRIPTOR: google.protobuf.descriptor.Descriptor

                class InputEntry(google.protobuf.message.Message):
                    DESCRIPTOR: google.protobuf.descriptor.Descriptor

                    KEY_FIELD_NUMBER: builtins.int
                    VALUE_FIELD_NUMBER: builtins.int
                    key: builtins.str
                    @property
                    def value(self) -> global___ModelOptimizationPolicy.Cuda.GraphSpec.Shape: ...
                    def __init__(
                        self,
                        *,
                        key: builtins.str = ...,
                        value: global___ModelOptimizationPolicy.Cuda.GraphSpec.Shape | None = ...,
                    ) -> None: ...
                    def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
                    def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

                BATCH_SIZE_FIELD_NUMBER: builtins.int
                INPUT_FIELD_NUMBER: builtins.int
                batch_size: builtins.int
                """@@      .. cpp:var:: int32 batch_size
                @@
                @@         The batch size of the CUDA graph. If 'max_batch_size' is 0,
                @@         'batch_size' must be set to 0. Otherwise, 'batch_size' must
                @@         be set to value between 1 and 'max_batch_size'.
                @@
                """
                @property
                def input(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___ModelOptimizationPolicy.Cuda.GraphSpec.Shape]:
                    """@@      .. cpp:var:: map<string, Shape> input
                    @@
                    @@         The specification of the inputs. 'Shape' is the shape of
                    @@         the input without batching dimension.
                    @@
                    """
                def __init__(
                    self,
                    *,
                    batch_size: builtins.int = ...,
                    input: collections.abc.Mapping[builtins.str, global___ModelOptimizationPolicy.Cuda.GraphSpec.Shape] | None = ...,
                ) -> None: ...
                def ClearField(self, field_name: typing_extensions.Literal["batch_size", b"batch_size", "input", b"input"]) -> None: ...

            class InputEntry(google.protobuf.message.Message):
                DESCRIPTOR: google.protobuf.descriptor.Descriptor

                KEY_FIELD_NUMBER: builtins.int
                VALUE_FIELD_NUMBER: builtins.int
                key: builtins.str
                @property
                def value(self) -> global___ModelOptimizationPolicy.Cuda.GraphSpec.Shape: ...
                def __init__(
                    self,
                    *,
                    key: builtins.str = ...,
                    value: global___ModelOptimizationPolicy.Cuda.GraphSpec.Shape | None = ...,
                ) -> None: ...
                def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
                def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

            BATCH_SIZE_FIELD_NUMBER: builtins.int
            INPUT_FIELD_NUMBER: builtins.int
            GRAPH_LOWER_BOUND_FIELD_NUMBER: builtins.int
            batch_size: builtins.int
            """@@      .. cpp:var:: int32 batch_size
            @@
            @@         The batch size of the CUDA graph. If 'max_batch_size' is 0,
            @@         'batch_size' must be set to 0. Otherwise, 'batch_size' must
            @@         be set to value between 1 and 'max_batch_size'.
            @@
            """
            @property
            def input(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___ModelOptimizationPolicy.Cuda.GraphSpec.Shape]:
                """@@      .. cpp:var:: map<string, Shape> input
                @@
                @@         The specification of the inputs. 'Shape' is the shape of the
                @@         input without batching dimension.
                @@
                """
            @property
            def graph_lower_bound(self) -> global___ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound:
                """@@      .. cpp:var:: LowerBound graph_lower_bound
                @@
                @@         Specify the lower bound of the CUDA graph. Optional.
                @@         If specified, the graph can be used for input shapes and
                @@         batch sizes that are in closed interval between the lower
                @@         bound specification and graph specification. For dynamic
                @@         shape model, this allows CUDA graphs to be launched
                @@         frequently without capturing all possible shape combinations.
                @@         However, using graph for shape combinations different from
                @@         the one used for capturing introduces uninitialized data for
                @@         execution and it may distort the inference result if
                @@         the model is sensitive to uninitialized data.
                @@
                """
            def __init__(
                self,
                *,
                batch_size: builtins.int = ...,
                input: collections.abc.Mapping[builtins.str, global___ModelOptimizationPolicy.Cuda.GraphSpec.Shape] | None = ...,
                graph_lower_bound: global___ModelOptimizationPolicy.Cuda.GraphSpec.LowerBound | None = ...,
            ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["graph_lower_bound", b"graph_lower_bound"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["batch_size", b"batch_size", "graph_lower_bound", b"graph_lower_bound", "input", b"input"]) -> None: ...

        GRAPHS_FIELD_NUMBER: builtins.int
        BUSY_WAIT_EVENTS_FIELD_NUMBER: builtins.int
        GRAPH_SPEC_FIELD_NUMBER: builtins.int
        OUTPUT_COPY_STREAM_FIELD_NUMBER: builtins.int
        graphs: builtins.bool
        """@@    .. cpp:var:: bool graphs
        @@
        @@       Use CUDA graphs API to capture model operations and execute
        @@       them more efficiently. Default value is false.
        @@       Currently only recognized by TensorRT backend.
        @@
        """
        busy_wait_events: builtins.bool
        """@@    .. cpp:var:: bool busy_wait_events
        @@
        @@       Use busy-waiting to synchronize CUDA events to achieve minimum
        @@       latency from event complete to host thread to be notified, with
        @@       the cost of high CPU load. Default value is false.
        @@       Currently only recognized by TensorRT backend.
        @@
        """
        @property
        def graph_spec(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelOptimizationPolicy.Cuda.GraphSpec]:
            """@@    .. cpp:var:: GraphSpec graph_spec (repeated)
            @@
            @@       Specification of the CUDA graph to be captured. If not specified
            @@       and 'graphs' is true, the default CUDA graphs will be captured
            @@       based on model settings.
            @@       Currently only recognized by TensorRT backend.
            @@
            """
        output_copy_stream: builtins.bool
        """@@    .. cpp:var:: bool output_copy_stream
        @@
        @@       Uses a CUDA stream separate from the inference stream to copy the
        @@       output to host. However, be aware that setting this option to
        @@       true will lead to an increase in the memory consumption of the
        @@       model as Triton will allocate twice as much GPU memory for its
        @@       I/O tensor buffers. Default value is false.
        @@       Currently only recognized by TensorRT backend.
        @@
        """
        def __init__(
            self,
            *,
            graphs: builtins.bool = ...,
            busy_wait_events: builtins.bool = ...,
            graph_spec: collections.abc.Iterable[global___ModelOptimizationPolicy.Cuda.GraphSpec] | None = ...,
            output_copy_stream: builtins.bool = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["busy_wait_events", b"busy_wait_events", "graph_spec", b"graph_spec", "graphs", b"graphs", "output_copy_stream", b"output_copy_stream"]) -> None: ...

    class ExecutionAccelerators(google.protobuf.message.Message):
        """@@
        @@  .. cpp:var:: message ExecutionAccelerators
        @@
        @@     Specify the preferred execution accelerators to be used to execute
        @@     the model. Currently only recognized by ONNX Runtime backend and
        @@     TensorFlow backend.
        @@
        @@     For ONNX Runtime backend, it will deploy the model with the execution
        @@     accelerators by priority, the priority is determined based on the
        @@     order that they are set, i.e. the provider at the front has highest
        @@     priority. Overall, the priority will be in the following order:
        @@         <gpu_execution_accelerator> (if instance is on GPU)
        @@         CUDA Execution Provider     (if instance is on GPU)
        @@         <cpu_execution_accelerator>
        @@         Default CPU Execution Provider
        @@
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class Accelerator(google.protobuf.message.Message):
            """@@
            @@  .. cpp:var:: message Accelerator
            @@
            @@     Specify the accelerator to be used to execute the model.
            @@     Accelerator with the same name may accept different parameters
            @@     depending on the backends.
            @@
            """

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            class ParametersEntry(google.protobuf.message.Message):
                DESCRIPTOR: google.protobuf.descriptor.Descriptor

                KEY_FIELD_NUMBER: builtins.int
                VALUE_FIELD_NUMBER: builtins.int
                key: builtins.str
                value: builtins.str
                def __init__(
                    self,
                    *,
                    key: builtins.str = ...,
                    value: builtins.str = ...,
                ) -> None: ...
                def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

            NAME_FIELD_NUMBER: builtins.int
            PARAMETERS_FIELD_NUMBER: builtins.int
            name: builtins.str
            """@@    .. cpp:var:: string name
            @@
            @@       The name of the execution accelerator.
            @@
            """
            @property
            def parameters(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
                """@@    .. cpp:var:: map<string, string> parameters
                @@
                @@       Additional paremeters used to configure the accelerator.
                @@
                """
            def __init__(
                self,
                *,
                name: builtins.str = ...,
                parameters: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "parameters", b"parameters"]) -> None: ...

        GPU_EXECUTION_ACCELERATOR_FIELD_NUMBER: builtins.int
        CPU_EXECUTION_ACCELERATOR_FIELD_NUMBER: builtins.int
        @property
        def gpu_execution_accelerator(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelOptimizationPolicy.ExecutionAccelerators.Accelerator]:
            """@@    .. cpp:var:: Accelerator gpu_execution_accelerator (repeated)
            @@
            @@       The preferred execution provider to be used if the model instance
            @@       is deployed on GPU.
            @@
            @@       For ONNX Runtime backend, possible value is "tensorrt" as name,
            @@       and no parameters are required.
            @@
            @@       For TensorFlow backend, possible values are "tensorrt",
            @@       "auto_mixed_precision", "gpu_io".
            @@
            @@       For "tensorrt", the following parameters can be specified:
            @@         "precision_mode": The precision used for optimization.
            @@         Allowed values are "FP32" and "FP16". Default value is "FP32".
            @@
            @@         "max_cached_engines": The maximum number of cached TensorRT
            @@         engines in dynamic TensorRT ops. Default value is 100.
            @@
            @@         "minimum_segment_size": The smallest model subgraph that will
            @@         be considered for optimization by TensorRT. Default value is 3.
            @@
            @@         "max_workspace_size_bytes": The maximum GPU memory the model
            @@         can use temporarily during execution. Default value is 1GB.
            @@
            @@       For "auto_mixed_precision", no parameters are required. If set,
            @@       the model will try to use FP16 for better performance.
            @@       This optimization can not be set with "tensorrt".
            @@
            @@       For "gpu_io", no parameters are required. If set, the model will
            @@       be executed using TensorFlow Callable API to set input and output
            @@       tensors in GPU memory if possible, which can reduce data transfer
            @@       overhead if the model is used in ensemble. However, the Callable
            @@       object will be created on model creation and it will request all
            @@       outputs for every model execution, which may impact the
            @@       performance if a request does not require all outputs. This
            @@       optimization will only take affect if the model instance is
            @@       created with KIND_GPU.
            @@
            """
        @property
        def cpu_execution_accelerator(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelOptimizationPolicy.ExecutionAccelerators.Accelerator]:
            """@@    .. cpp:var:: Accelerator cpu_execution_accelerator (repeated)
            @@
            @@       The preferred execution provider to be used if the model instance
            @@       is deployed on CPU.
            @@
            @@       For ONNX Runtime backend, possible value is "openvino" as name,
            @@       and no parameters are required.
            @@
            """
        def __init__(
            self,
            *,
            gpu_execution_accelerator: collections.abc.Iterable[global___ModelOptimizationPolicy.ExecutionAccelerators.Accelerator] | None = ...,
            cpu_execution_accelerator: collections.abc.Iterable[global___ModelOptimizationPolicy.ExecutionAccelerators.Accelerator] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["cpu_execution_accelerator", b"cpu_execution_accelerator", "gpu_execution_accelerator", b"gpu_execution_accelerator"]) -> None: ...

    class PinnedMemoryBuffer(google.protobuf.message.Message):
        """@@
        @@  .. cpp:var:: message PinnedMemoryBuffer
        @@
        @@     Specify whether to use a pinned memory buffer when transferring data
        @@     between non-pinned system memory and GPU memory. Using a pinned
        @@     memory buffer for system from/to GPU transfers will typically provide
        @@     increased performance. For example, in the common use case where the
        @@     request provides inputs and delivers outputs via non-pinned system
        @@     memory, if the model instance accepts GPU IOs, the inputs will be
        @@     processed by two copies: from non-pinned system memory to pinned
        @@     memory, and from pinned memory to GPU memory. Similarly, pinned
        @@     memory will be used for delivering the outputs.
        @@
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ENABLE_FIELD_NUMBER: builtins.int
        enable: builtins.bool
        """@@    .. cpp:var:: bool enable
        @@
        @@       Use pinned memory buffer. Default is true.
        @@
        """
        def __init__(
            self,
            *,
            enable: builtins.bool = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["enable", b"enable"]) -> None: ...

    GRAPH_FIELD_NUMBER: builtins.int
    PRIORITY_FIELD_NUMBER: builtins.int
    CUDA_FIELD_NUMBER: builtins.int
    EXECUTION_ACCELERATORS_FIELD_NUMBER: builtins.int
    INPUT_PINNED_MEMORY_FIELD_NUMBER: builtins.int
    OUTPUT_PINNED_MEMORY_FIELD_NUMBER: builtins.int
    GATHER_KERNEL_BUFFER_THRESHOLD_FIELD_NUMBER: builtins.int
    EAGER_BATCHING_FIELD_NUMBER: builtins.int
    @property
    def graph(self) -> global___ModelOptimizationPolicy.Graph:
        """@@  .. cpp:var:: Graph graph
        @@
        @@     The graph optimization setting for the model. Optional.
        @@
        """
    priority: global___ModelOptimizationPolicy.ModelPriority.ValueType
    """@@  .. cpp:var:: ModelPriority priority
    @@
    @@     The priority setting for the model. Optional.
    @@
    """
    @property
    def cuda(self) -> global___ModelOptimizationPolicy.Cuda:
        """@@  .. cpp:var:: Cuda cuda
        @@
        @@     CUDA-specific optimization settings. Optional.
        @@
        """
    @property
    def execution_accelerators(self) -> global___ModelOptimizationPolicy.ExecutionAccelerators:
        """@@  .. cpp:var:: ExecutionAccelerators execution_accelerators
        @@
        @@     The accelerators used for the model. Optional.
        @@
        """
    @property
    def input_pinned_memory(self) -> global___ModelOptimizationPolicy.PinnedMemoryBuffer:
        """@@  .. cpp:var:: PinnedMemoryBuffer input_pinned_memory
        @@
        @@     Use pinned memory buffer when the data transfer for inputs
        @@     is between GPU memory and non-pinned system memory.
        @@     Default is true.
        @@
        """
    @property
    def output_pinned_memory(self) -> global___ModelOptimizationPolicy.PinnedMemoryBuffer:
        """@@  .. cpp:var:: PinnedMemoryBuffer output_pinned_memory
        @@
        @@     Use pinned memory buffer when the data transfer for outputs
        @@     is between GPU memory and non-pinned system memory.
        @@     Default is true.
        @@
        """
    gather_kernel_buffer_threshold: builtins.int
    """@@  .. cpp:var:: uint32 gather_kernel_buffer_threshold
    @@
    @@     The backend may use a gather kernel to gather input data if the
    @@     device has direct access to the source buffer and the destination
    @@     buffer. In such case, the gather kernel will be used only if the
    @@     number of buffers to be gathered is greater or equal to
    @@     the specifed value. If 0, the gather kernel will be disabled.
    @@     Default value is 0.
    @@     Currently only recognized by TensorRT backend.
    @@
    """
    eager_batching: builtins.bool
    """@@  .. cpp:var:: bool eager_batching
    @@
    @@     Start preparing the next batch before the model instance is ready
    @@     for the next inference. This option can be used to overlap the
    @@     batch preparation with model execution, with the trade-off that
    @@     the next batch might be smaller than what it could have been.
    @@     Default value is false.
    @@     Currently only recognized by TensorRT backend.
    @@
    """
    def __init__(
        self,
        *,
        graph: global___ModelOptimizationPolicy.Graph | None = ...,
        priority: global___ModelOptimizationPolicy.ModelPriority.ValueType = ...,
        cuda: global___ModelOptimizationPolicy.Cuda | None = ...,
        execution_accelerators: global___ModelOptimizationPolicy.ExecutionAccelerators | None = ...,
        input_pinned_memory: global___ModelOptimizationPolicy.PinnedMemoryBuffer | None = ...,
        output_pinned_memory: global___ModelOptimizationPolicy.PinnedMemoryBuffer | None = ...,
        gather_kernel_buffer_threshold: builtins.int = ...,
        eager_batching: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["cuda", b"cuda", "execution_accelerators", b"execution_accelerators", "graph", b"graph", "input_pinned_memory", b"input_pinned_memory", "output_pinned_memory", b"output_pinned_memory"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cuda", b"cuda", "eager_batching", b"eager_batching", "execution_accelerators", b"execution_accelerators", "gather_kernel_buffer_threshold", b"gather_kernel_buffer_threshold", "graph", b"graph", "input_pinned_memory", b"input_pinned_memory", "output_pinned_memory", b"output_pinned_memory", "priority", b"priority"]) -> None: ...

global___ModelOptimizationPolicy = ModelOptimizationPolicy

class ModelQueuePolicy(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ModelQueuePolicy
    @@
    @@   Queue policy for inference requests.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _TimeoutAction:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TimeoutActionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ModelQueuePolicy._TimeoutAction.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        REJECT: ModelQueuePolicy._TimeoutAction.ValueType  # 0
        """@@    .. cpp:enumerator:: Action::REJECT = 0
        @@
        @@       Reject the request and return error message accordingly.
        @@
        """
        DELAY: ModelQueuePolicy._TimeoutAction.ValueType  # 1
        """@@    .. cpp:enumerator:: Action::DELAY = 1
        @@
        @@       Delay the request until all other requests at the same
        @@       (or higher) priority levels that have not reached their timeouts
        @@       are processed. A delayed request will eventually be processed,
        @@       but may be delayed indefinitely due to newly arriving requests.
        @@
        """

    class TimeoutAction(_TimeoutAction, metaclass=_TimeoutActionEnumTypeWrapper):
        """@@
        @@  .. cpp:enum:: TimeoutAction
        @@
        @@     The action applied to timed-out requests.
        @@
        """

    REJECT: ModelQueuePolicy.TimeoutAction.ValueType  # 0
    """@@    .. cpp:enumerator:: Action::REJECT = 0
    @@
    @@       Reject the request and return error message accordingly.
    @@
    """
    DELAY: ModelQueuePolicy.TimeoutAction.ValueType  # 1
    """@@    .. cpp:enumerator:: Action::DELAY = 1
    @@
    @@       Delay the request until all other requests at the same
    @@       (or higher) priority levels that have not reached their timeouts
    @@       are processed. A delayed request will eventually be processed,
    @@       but may be delayed indefinitely due to newly arriving requests.
    @@
    """

    TIMEOUT_ACTION_FIELD_NUMBER: builtins.int
    DEFAULT_TIMEOUT_MICROSECONDS_FIELD_NUMBER: builtins.int
    ALLOW_TIMEOUT_OVERRIDE_FIELD_NUMBER: builtins.int
    MAX_QUEUE_SIZE_FIELD_NUMBER: builtins.int
    timeout_action: global___ModelQueuePolicy.TimeoutAction.ValueType
    """@@
    @@  .. cpp:var:: TimeoutAction timeout_action
    @@
    @@     The action applied to timed-out request.
    @@     The default action is REJECT.
    @@
    """
    default_timeout_microseconds: builtins.int
    """@@
    @@  .. cpp:var:: uint64 default_timeout_microseconds
    @@
    @@     The default timeout for every request, in microseconds.
    @@     The default value is 0 which indicates that no timeout is set.
    @@
    """
    allow_timeout_override: builtins.bool
    """@@
    @@  .. cpp:var:: bool allow_timeout_override
    @@
    @@     Whether individual request can override the default timeout value.
    @@     When true, individual requests can set a timeout that is less than
    @@     the default timeout value but may not increase the timeout.
    @@     The default value is false.
    @@
    """
    max_queue_size: builtins.int
    """@@
    @@  .. cpp:var:: uint32 max_queue_size
    @@
    @@     The maximum queue size for holding requests. A request will be
    @@     rejected immediately if it can't be enqueued because the queue is
    @@     full. The default value is 0 which indicates that no maximum
    @@     queue size is enforced.
    @@
    """
    def __init__(
        self,
        *,
        timeout_action: global___ModelQueuePolicy.TimeoutAction.ValueType = ...,
        default_timeout_microseconds: builtins.int = ...,
        allow_timeout_override: builtins.bool = ...,
        max_queue_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["allow_timeout_override", b"allow_timeout_override", "default_timeout_microseconds", b"default_timeout_microseconds", "max_queue_size", b"max_queue_size", "timeout_action", b"timeout_action"]) -> None: ...

global___ModelQueuePolicy = ModelQueuePolicy

class ModelDynamicBatching(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ModelDynamicBatching
    @@
    @@   Dynamic batching configuration. These settings control how dynamic
    @@   batching operates for the model.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class PriorityQueuePolicyEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int
        @property
        def value(self) -> global___ModelQueuePolicy: ...
        def __init__(
            self,
            *,
            key: builtins.int = ...,
            value: global___ModelQueuePolicy | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    PREFERRED_BATCH_SIZE_FIELD_NUMBER: builtins.int
    MAX_QUEUE_DELAY_MICROSECONDS_FIELD_NUMBER: builtins.int
    PRESERVE_ORDERING_FIELD_NUMBER: builtins.int
    PRIORITY_LEVELS_FIELD_NUMBER: builtins.int
    DEFAULT_PRIORITY_LEVEL_FIELD_NUMBER: builtins.int
    DEFAULT_QUEUE_POLICY_FIELD_NUMBER: builtins.int
    PRIORITY_QUEUE_POLICY_FIELD_NUMBER: builtins.int
    @property
    def preferred_batch_size(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """@@  .. cpp:var:: int32 preferred_batch_size (repeated)
        @@
        @@     Preferred batch sizes for dynamic batching. If a batch of one of
        @@     these sizes can be formed it will be executed immediately.  If
        @@     not specified a preferred batch size will be chosen automatically
        @@     based on model and GPU characteristics.
        @@
        """
    max_queue_delay_microseconds: builtins.int
    """@@  .. cpp:var:: uint64 max_queue_delay_microseconds
    @@
    @@     The maximum time, in microseconds, a request will be delayed in
    @@     the scheduling queue to wait for additional requests for
    @@     batching. Default is 0.
    @@
    """
    preserve_ordering: builtins.bool
    """@@  .. cpp:var:: bool preserve_ordering
    @@
    @@     Should the dynamic batcher preserve the ordering of responses to
    @@     match the order of requests received by the scheduler. Default is
    @@     false. If true, the responses will be returned in the same order as
    @@     the order of requests sent to the scheduler. If false, the responses
    @@     may be returned in arbitrary order. This option is specifically
    @@     needed when a sequence of related inference requests (i.e. inference
    @@     requests with the same correlation ID) are sent to the dynamic
    @@     batcher to ensure that the sequence responses are in the correct
    @@     order.
    @@
    """
    priority_levels: builtins.int
    """@@  .. cpp:var:: uint32 priority_levels
    @@
    @@     The number of priority levels to be enabled for the model,
    @@     the priority level starts from 1 and 1 is the highest priority.
    @@     Requests are handled in priority order with all priority 1 requests
    @@     processed before priority 2, all priority 2 requests processed before
    @@     priority 3, etc. Requests with the same priority level will be
    @@     handled in the order that they are received.
    @@
    """
    default_priority_level: builtins.int
    """@@  .. cpp:var:: uint32 default_priority_level
    @@
    @@     The priority level used for requests that don't specify their
    @@     priority. The value must be in the range [ 1, 'priority_levels' ].
    @@
    """
    @property
    def default_queue_policy(self) -> global___ModelQueuePolicy:
        """@@  .. cpp:var:: ModelQueuePolicy default_queue_policy
        @@
        @@     The default queue policy used for requests that don't require
        @@     priority handling and requests that specify priority levels where
        @@     there is no specific policy given. If not specified, a policy with
        @@     default field values will be used.
        @@
        """
    @property
    def priority_queue_policy(self) -> google.protobuf.internal.containers.MessageMap[builtins.int, global___ModelQueuePolicy]:
        """@@  .. cpp:var:: map<uint32, ModelQueuePolicy> priority_queue_policy
        @@
        @@     Specify the queue policy for the priority level. The default queue
        @@     policy will be used if a priority level doesn't specify a queue
        @@     policy.
        @@
        """
    def __init__(
        self,
        *,
        preferred_batch_size: collections.abc.Iterable[builtins.int] | None = ...,
        max_queue_delay_microseconds: builtins.int = ...,
        preserve_ordering: builtins.bool = ...,
        priority_levels: builtins.int = ...,
        default_priority_level: builtins.int = ...,
        default_queue_policy: global___ModelQueuePolicy | None = ...,
        priority_queue_policy: collections.abc.Mapping[builtins.int, global___ModelQueuePolicy] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["default_queue_policy", b"default_queue_policy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["default_priority_level", b"default_priority_level", "default_queue_policy", b"default_queue_policy", "max_queue_delay_microseconds", b"max_queue_delay_microseconds", "preferred_batch_size", b"preferred_batch_size", "preserve_ordering", b"preserve_ordering", "priority_levels", b"priority_levels", "priority_queue_policy", b"priority_queue_policy"]) -> None: ...

global___ModelDynamicBatching = ModelDynamicBatching

class ModelSequenceBatching(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ModelSequenceBatching
    @@
    @@   Sequence batching configuration. These settings control how sequence
    @@   batching operates for the model.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class Control(google.protobuf.message.Message):
        """@@  .. cpp:var:: message Control
        @@
        @@     A control is a signal that the sequence batcher uses to
        @@     communicate with a backend.
        @@
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _Kind:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _KindEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ModelSequenceBatching.Control._Kind.ValueType], builtins.type):  # noqa: F821
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            CONTROL_SEQUENCE_START: ModelSequenceBatching.Control._Kind.ValueType  # 0
            """@@      .. cpp:enumerator:: Kind::CONTROL_SEQUENCE_START = 0
            @@
            @@         A new sequence is/is-not starting. If true a sequence is
            @@         starting, if false a sequence is continuing. Must
            @@         specify either int32_false_true, fp32_false_true or
            @@         bool_false_true for this control. This control is optional.
            @@
            """
            CONTROL_SEQUENCE_READY: ModelSequenceBatching.Control._Kind.ValueType  # 1
            """@@      .. cpp:enumerator:: Kind::CONTROL_SEQUENCE_READY = 1
            @@
            @@         A sequence is/is-not ready for inference. If true the
            @@         input tensor data is valid and should be used. If false
            @@         the input tensor data is invalid and inferencing should
            @@         be "skipped". Must specify either int32_false_true,
            @@         fp32_false_true or bool_false_true for this control. This
            @@         control is optional.
            @@
            """
            CONTROL_SEQUENCE_END: ModelSequenceBatching.Control._Kind.ValueType  # 2
            """@@      .. cpp:enumerator:: Kind::CONTROL_SEQUENCE_END = 2
            @@
            @@         A sequence is/is-not ending. If true a sequence is
            @@         ending, if false a sequence is continuing. Must specify
            @@         either int32_false_true, fp32_false_true or bool_false_true
            @@         for this control. This control is optional.
            @@
            """
            CONTROL_SEQUENCE_CORRID: ModelSequenceBatching.Control._Kind.ValueType  # 3
            """@@      .. cpp:enumerator:: Kind::CONTROL_SEQUENCE_CORRID = 3
            @@
            @@         The correlation ID of the sequence. The correlation ID
            @@         is an uint64_t value that is communicated in whole or
            @@         in part by the tensor. The tensor's datatype must be
            @@         specified by data_type and must be TYPE_UINT64, TYPE_INT64,
            @@         TYPE_UINT32 or TYPE_INT32. If a 32-bit datatype is specified
            @@         the correlation ID will be truncated to the low-order 32
            @@         bits. This control is optional.
            @@
            """

        class Kind(_Kind, metaclass=_KindEnumTypeWrapper):
            """@@
            @@    .. cpp:enum:: Kind
            @@
            @@       The kind of the control.
            @@
            """

        CONTROL_SEQUENCE_START: ModelSequenceBatching.Control.Kind.ValueType  # 0
        """@@      .. cpp:enumerator:: Kind::CONTROL_SEQUENCE_START = 0
        @@
        @@         A new sequence is/is-not starting. If true a sequence is
        @@         starting, if false a sequence is continuing. Must
        @@         specify either int32_false_true, fp32_false_true or
        @@         bool_false_true for this control. This control is optional.
        @@
        """
        CONTROL_SEQUENCE_READY: ModelSequenceBatching.Control.Kind.ValueType  # 1
        """@@      .. cpp:enumerator:: Kind::CONTROL_SEQUENCE_READY = 1
        @@
        @@         A sequence is/is-not ready for inference. If true the
        @@         input tensor data is valid and should be used. If false
        @@         the input tensor data is invalid and inferencing should
        @@         be "skipped". Must specify either int32_false_true,
        @@         fp32_false_true or bool_false_true for this control. This
        @@         control is optional.
        @@
        """
        CONTROL_SEQUENCE_END: ModelSequenceBatching.Control.Kind.ValueType  # 2
        """@@      .. cpp:enumerator:: Kind::CONTROL_SEQUENCE_END = 2
        @@
        @@         A sequence is/is-not ending. If true a sequence is
        @@         ending, if false a sequence is continuing. Must specify
        @@         either int32_false_true, fp32_false_true or bool_false_true
        @@         for this control. This control is optional.
        @@
        """
        CONTROL_SEQUENCE_CORRID: ModelSequenceBatching.Control.Kind.ValueType  # 3
        """@@      .. cpp:enumerator:: Kind::CONTROL_SEQUENCE_CORRID = 3
        @@
        @@         The correlation ID of the sequence. The correlation ID
        @@         is an uint64_t value that is communicated in whole or
        @@         in part by the tensor. The tensor's datatype must be
        @@         specified by data_type and must be TYPE_UINT64, TYPE_INT64,
        @@         TYPE_UINT32 or TYPE_INT32. If a 32-bit datatype is specified
        @@         the correlation ID will be truncated to the low-order 32
        @@         bits. This control is optional.
        @@
        """

        KIND_FIELD_NUMBER: builtins.int
        INT32_FALSE_TRUE_FIELD_NUMBER: builtins.int
        FP32_FALSE_TRUE_FIELD_NUMBER: builtins.int
        BOOL_FALSE_TRUE_FIELD_NUMBER: builtins.int
        DATA_TYPE_FIELD_NUMBER: builtins.int
        kind: global___ModelSequenceBatching.Control.Kind.ValueType
        """@@    .. cpp:var:: Kind kind
        @@
        @@       The kind of this control.
        @@
        """
        @property
        def int32_false_true(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
            """@@    .. cpp:var:: int32 int32_false_true (repeated)
            @@
            @@       The control's true and false setting is indicated by setting
            @@       a value in an int32 tensor. The tensor must be a
            @@       1-dimensional tensor with size equal to the batch size of
            @@       the request. 'int32_false_true' must have two entries: the
            @@       first the false value and the second the true value.
            @@
            """
        @property
        def fp32_false_true(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
            """@@    .. cpp:var:: float fp32_false_true (repeated)
            @@
            @@       The control's true and false setting is indicated by setting
            @@       a value in a fp32 tensor. The tensor must be a
            @@       1-dimensional tensor with size equal to the batch size of
            @@       the request. 'fp32_false_true' must have two entries: the
            @@       first the false value and the second the true value.
            @@
            """
        @property
        def bool_false_true(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bool]:
            """@@    .. cpp:var:: bool bool_false_true (repeated)
            @@
            @@       The control's true and false setting is indicated by setting
            @@       a value in a bool tensor. The tensor must be a
            @@       1-dimensional tensor with size equal to the batch size of
            @@       the request. 'bool_false_true' must have two entries: the
            @@       first the false value and the second the true value.
            @@
            """
        data_type: global___DataType.ValueType
        """@@    .. cpp:var:: DataType data_type
        @@
        @@       The control's datatype.
        @@
        """
        def __init__(
            self,
            *,
            kind: global___ModelSequenceBatching.Control.Kind.ValueType = ...,
            int32_false_true: collections.abc.Iterable[builtins.int] | None = ...,
            fp32_false_true: collections.abc.Iterable[builtins.float] | None = ...,
            bool_false_true: collections.abc.Iterable[builtins.bool] | None = ...,
            data_type: global___DataType.ValueType = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["bool_false_true", b"bool_false_true", "data_type", b"data_type", "fp32_false_true", b"fp32_false_true", "int32_false_true", b"int32_false_true", "kind", b"kind"]) -> None: ...

    class ControlInput(google.protobuf.message.Message):
        """@@  .. cpp:var:: message ControlInput
        @@
        @@     The sequence control values to communicate by a model input.
        @@
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        CONTROL_FIELD_NUMBER: builtins.int
        name: builtins.str
        """@@    .. cpp:var:: string name
        @@
        @@       The name of the model input.
        @@
        """
        @property
        def control(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelSequenceBatching.Control]:
            """@@    .. cpp:var:: Control control (repeated)
            @@
            @@       The control value(s) that should be communicated to the
            @@       model using this model input.
            @@
            """
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            control: collections.abc.Iterable[global___ModelSequenceBatching.Control] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["control", b"control", "name", b"name"]) -> None: ...

    class InitialState(google.protobuf.message.Message):
        """@@
        @@  .. cpp:var:: message InitialState
        @@
        @@     Settings used to initialize data for implicit state.
        @@
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        DATA_TYPE_FIELD_NUMBER: builtins.int
        DIMS_FIELD_NUMBER: builtins.int
        ZERO_DATA_FIELD_NUMBER: builtins.int
        DATA_FILE_FIELD_NUMBER: builtins.int
        NAME_FIELD_NUMBER: builtins.int
        data_type: global___DataType.ValueType
        """@@      .. cpp:var:: DataType data_type
        @@
        @@         The data-type of the state.
        @@
        """
        @property
        def dims(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
            """@@      .. cpp:var:: int64 dims (repeated)
            @@
            @@         The shape of the state tensor, not including the batch
            @@         dimension.
            @@
            """
        zero_data: builtins.bool
        """@@
        @@      .. cpp:var:: bool zero_data
        @@
        @@         The identifier for using zeros as initial state data.
        @@         Note that the value of 'zero_data' will not be checked,
        @@         instead, zero data will be used as long as the field is set.
        @@
        """
        data_file: builtins.str
        """@@      .. cpp:var:: string data_file
        @@
        @@         The file whose content will be used as the initial data for
        @@         the state in row-major order. The file must be provided in
        @@         sub-directory 'initial_state' under the model directory.
        @@
        """
        name: builtins.str
        """@@  .. cpp:var:: string name
        @@
        @@     The name of the state initialization.
        @@
        """
        def __init__(
            self,
            *,
            data_type: global___DataType.ValueType = ...,
            dims: collections.abc.Iterable[builtins.int] | None = ...,
            zero_data: builtins.bool = ...,
            data_file: builtins.str = ...,
            name: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["data_file", b"data_file", "state_data", b"state_data", "zero_data", b"zero_data"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["data_file", b"data_file", "data_type", b"data_type", "dims", b"dims", "name", b"name", "state_data", b"state_data", "zero_data", b"zero_data"]) -> None: ...
        def WhichOneof(self, oneof_group: typing_extensions.Literal["state_data", b"state_data"]) -> typing_extensions.Literal["zero_data", "data_file"] | None: ...

    class State(google.protobuf.message.Message):
        """@@  .. cpp:var:: message State
        @@
        @@     An input / output pair of tensors that carry state for the sequence.
        @@
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        INPUT_NAME_FIELD_NUMBER: builtins.int
        OUTPUT_NAME_FIELD_NUMBER: builtins.int
        DATA_TYPE_FIELD_NUMBER: builtins.int
        DIMS_FIELD_NUMBER: builtins.int
        INITIAL_STATE_FIELD_NUMBER: builtins.int
        input_name: builtins.str
        """@@    .. cpp:var:: string input_name
        @@
        @@       The name of the model state input.
        @@
        """
        output_name: builtins.str
        """@@    .. cpp:var:: string output_name
        @@
        @@       The name of the model state output.
        @@
        """
        data_type: global___DataType.ValueType
        """@@    .. cpp:var:: DataType data_type
        @@
        @@       The data-type of the state.
        @@
        """
        @property
        def dims(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
            """@@    .. cpp:var:: int64 dim (repeated)
            @@
            @@       The dimension.
            @@
            """
        @property
        def initial_state(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelSequenceBatching.InitialState]:
            """@@  .. cpp:var:: InitialState initial_state (repeated)
            @@
            @@     The optional field to specify the initial state for the model.
            @@
            """
        def __init__(
            self,
            *,
            input_name: builtins.str = ...,
            output_name: builtins.str = ...,
            data_type: global___DataType.ValueType = ...,
            dims: collections.abc.Iterable[builtins.int] | None = ...,
            initial_state: collections.abc.Iterable[global___ModelSequenceBatching.InitialState] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["data_type", b"data_type", "dims", b"dims", "initial_state", b"initial_state", "input_name", b"input_name", "output_name", b"output_name"]) -> None: ...

    class StrategyDirect(google.protobuf.message.Message):
        """@@  .. cpp:var:: message StrategyDirect
        @@
        @@     The sequence batcher uses a specific, unique batch
        @@     slot for each sequence. All inference requests in a
        @@     sequence are directed to the same batch slot in the same
        @@     model instance over the lifetime of the sequence. This
        @@     is the default strategy.
        @@
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        MAX_QUEUE_DELAY_MICROSECONDS_FIELD_NUMBER: builtins.int
        MINIMUM_SLOT_UTILIZATION_FIELD_NUMBER: builtins.int
        max_queue_delay_microseconds: builtins.int
        """@@    .. cpp:var:: uint64 max_queue_delay_microseconds
        @@
        @@       The maximum time, in microseconds, a candidate request
        @@       will be delayed in the sequence batch scheduling queue to
        @@       wait for additional requests for batching. Default is 0.
        @@
        """
        minimum_slot_utilization: builtins.float
        """@@    .. cpp:var:: float minimum_slot_utilization
        @@
        @@       The minimum slot utilization that must be satisfied to
        @@       execute the batch before 'max_queue_delay_microseconds' expires.
        @@       For example, a value of 0.5 indicates that the batch should be
        @@       executed as soon as 50% or more of the slots are ready even if
        @@       the 'max_queue_delay_microseconds' timeout has not expired.
        @@       The default is 0.0, indicating that a batch will be executed
        @@       before 'max_queue_delay_microseconds' timeout expires if at least
        @@       one batch slot is ready. 'max_queue_delay_microseconds' will be
        @@       ignored unless minimum_slot_utilization is set to a non-zero
        @@       value.
        @@
        """
        def __init__(
            self,
            *,
            max_queue_delay_microseconds: builtins.int = ...,
            minimum_slot_utilization: builtins.float = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["max_queue_delay_microseconds", b"max_queue_delay_microseconds", "minimum_slot_utilization", b"minimum_slot_utilization"]) -> None: ...

    class StrategyOldest(google.protobuf.message.Message):
        """@@  .. cpp:var:: message StrategyOldest
        @@
        @@     The sequence batcher maintains up to 'max_candidate_sequences'
        @@     candidate sequences. 'max_candidate_sequences' can be greater
        @@     than the model's 'max_batch_size'. For inferencing the batcher
        @@     chooses from the candidate sequences up to 'max_batch_size'
        @@     inference requests. Requests are chosen in an oldest-first
        @@     manner across all candidate sequences. A given sequence is
        @@     not guaranteed to be assigned to the same batch slot for
        @@     all inference requests of that sequence.
        @@
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        MAX_CANDIDATE_SEQUENCES_FIELD_NUMBER: builtins.int
        PREFERRED_BATCH_SIZE_FIELD_NUMBER: builtins.int
        MAX_QUEUE_DELAY_MICROSECONDS_FIELD_NUMBER: builtins.int
        max_candidate_sequences: builtins.int
        """@@    .. cpp:var:: int32 max_candidate_sequences
        @@
        @@       Maximum number of candidate sequences that the batcher
        @@       maintains. Excess seqences are kept in an ordered backlog
        @@       and become candidates when existing candidate sequences
        @@       complete.
        @@
        """
        @property
        def preferred_batch_size(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
            """@@    .. cpp:var:: int32 preferred_batch_size (repeated)
            @@
            @@       Preferred batch sizes for dynamic batching of candidate
            @@       sequences. If a batch of one of these sizes can be formed
            @@       it will be executed immediately. If not specified a
            @@       preferred batch size will be chosen automatically
            @@       based on model and GPU characteristics.
            @@
            """
        max_queue_delay_microseconds: builtins.int
        """@@    .. cpp:var:: uint64 max_queue_delay_microseconds
        @@
        @@       The maximum time, in microseconds, a candidate request
        @@       will be delayed in the dynamic batch scheduling queue to
        @@       wait for additional requests for batching. Default is 0.
        @@
        """
        def __init__(
            self,
            *,
            max_candidate_sequences: builtins.int = ...,
            preferred_batch_size: collections.abc.Iterable[builtins.int] | None = ...,
            max_queue_delay_microseconds: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["max_candidate_sequences", b"max_candidate_sequences", "max_queue_delay_microseconds", b"max_queue_delay_microseconds", "preferred_batch_size", b"preferred_batch_size"]) -> None: ...

    DIRECT_FIELD_NUMBER: builtins.int
    OLDEST_FIELD_NUMBER: builtins.int
    MAX_SEQUENCE_IDLE_MICROSECONDS_FIELD_NUMBER: builtins.int
    CONTROL_INPUT_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    @property
    def direct(self) -> global___ModelSequenceBatching.StrategyDirect:
        """@@    .. cpp:var:: StrategyDirect direct
        @@
        @@       StrategyDirect scheduling strategy.
        @@
        """
    @property
    def oldest(self) -> global___ModelSequenceBatching.StrategyOldest:
        """@@    .. cpp:var:: StrategyOldest oldest
        @@
        @@       StrategyOldest scheduling strategy.
        @@
        """
    max_sequence_idle_microseconds: builtins.int
    """@@  .. cpp:var:: uint64 max_sequence_idle_microseconds
    @@
    @@     The maximum time, in microseconds, that a sequence is allowed to
    @@     be idle before it is aborted. The inference server considers a
    @@     sequence idle when it does not have any inference request queued
    @@     for the sequence. If this limit is exceeded, the inference server
    @@     will free the sequence slot allocated by the sequence and make it
    @@     available for another sequence. If not specified (or specified as
    @@     zero) a default value of 1000000 (1 second) is used.
    @@
    """
    @property
    def control_input(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelSequenceBatching.ControlInput]:
        """@@  .. cpp:var:: ControlInput control_input (repeated)
        @@
        @@     The model input(s) that the server should use to communicate
        @@     sequence start, stop, ready and similar control values to the
        @@     model.
        @@
        """
    @property
    def state(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelSequenceBatching.State]:
        """@@  .. cpp:var:: State state (repeated)
        @@
        @@     The optional state that can be stored in Triton for performing
        @@     inference requests on a sequence. Each sequence holds an implicit
        @@     state local to itself. The output state tensor provided by the
        @@     model in 'output_name' field of the current inference request will
        @@     be transferred as an input tensor named 'input_name' in the next
        @@     request of the same sequence. The input state of the first request
        @@     in the sequence contains garbage data.
        @@
        """
    def __init__(
        self,
        *,
        direct: global___ModelSequenceBatching.StrategyDirect | None = ...,
        oldest: global___ModelSequenceBatching.StrategyOldest | None = ...,
        max_sequence_idle_microseconds: builtins.int = ...,
        control_input: collections.abc.Iterable[global___ModelSequenceBatching.ControlInput] | None = ...,
        state: collections.abc.Iterable[global___ModelSequenceBatching.State] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["direct", b"direct", "oldest", b"oldest", "strategy_choice", b"strategy_choice"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["control_input", b"control_input", "direct", b"direct", "max_sequence_idle_microseconds", b"max_sequence_idle_microseconds", "oldest", b"oldest", "state", b"state", "strategy_choice", b"strategy_choice"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["strategy_choice", b"strategy_choice"]) -> typing_extensions.Literal["direct", "oldest"] | None: ...

global___ModelSequenceBatching = ModelSequenceBatching

class ModelEnsembling(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ModelEnsembling
    @@
    @@   Model ensembling configuration. These settings specify the models that
    @@   compose the ensemble and how data flows between the models.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class Step(google.protobuf.message.Message):
        """@@  .. cpp:var:: message Step
        @@
        @@     Each step specifies a model included in the ensemble,
        @@     maps ensemble tensor names to the model input tensors,
        @@     and maps model output tensors to ensemble tensor names
        @@
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class InputMapEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: builtins.str
            value: builtins.str
            def __init__(
                self,
                *,
                key: builtins.str = ...,
                value: builtins.str = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

        class OutputMapEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: builtins.str
            value: builtins.str
            def __init__(
                self,
                *,
                key: builtins.str = ...,
                value: builtins.str = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

        MODEL_NAME_FIELD_NUMBER: builtins.int
        MODEL_VERSION_FIELD_NUMBER: builtins.int
        INPUT_MAP_FIELD_NUMBER: builtins.int
        OUTPUT_MAP_FIELD_NUMBER: builtins.int
        model_name: builtins.str
        """@@  .. cpp:var:: string model_name
        @@
        @@     The name of the model to execute for this step of the ensemble.
        @@
        """
        model_version: builtins.int
        """@@  .. cpp:var:: int64 model_version
        @@
        @@     The version of the model to use for inference. If -1
        @@     the latest/most-recent version of the model is used.
        @@
        """
        @property
        def input_map(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
            """@@  .. cpp:var:: map<string,string> input_map
            @@
            @@     Map from name of an input tensor on this step's model to ensemble
            @@     tensor name. The ensemble tensor must have the same data type and
            @@     shape as the model input. Each model input must be assigned to
            @@     one ensemble tensor, but the same ensemble tensor can be assigned
            @@     to multiple model inputs.
            @@
            """
        @property
        def output_map(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
            """@@  .. cpp:var:: map<string,string> output_map
            @@
            @@     Map from name of an output tensor on this step's model to ensemble
            @@     tensor name. The data type and shape of the ensemble tensor will
            @@     be inferred from the model output. It is optional to assign all
            @@     model outputs to ensemble tensors. One ensemble tensor name
            @@     can appear in an output map only once.
            @@
            """
        def __init__(
            self,
            *,
            model_name: builtins.str = ...,
            model_version: builtins.int = ...,
            input_map: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
            output_map: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["input_map", b"input_map", "model_name", b"model_name", "model_version", b"model_version", "output_map", b"output_map"]) -> None: ...

    STEP_FIELD_NUMBER: builtins.int
    @property
    def step(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelEnsembling.Step]:
        """@@  .. cpp:var:: Step step (repeated)
        @@
        @@     The models and the input / output mappings used within the ensemble.
        @@
        """
    def __init__(
        self,
        *,
        step: collections.abc.Iterable[global___ModelEnsembling.Step] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["step", b"step"]) -> None: ...

global___ModelEnsembling = ModelEnsembling

class ModelParameter(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ModelParameter
    @@
    @@   A model parameter.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STRING_VALUE_FIELD_NUMBER: builtins.int
    string_value: builtins.str
    """@@  .. cpp:var:: string string_value
    @@
    @@     The string value of the parameter.
    @@
    """
    def __init__(
        self,
        *,
        string_value: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["string_value", b"string_value"]) -> None: ...

global___ModelParameter = ModelParameter

class ModelWarmup(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ModelWarmup
    @@
    @@   Settings used to construct the request sample for model warmup.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class Input(google.protobuf.message.Message):
        """@@
        @@  .. cpp:var:: message Input
        @@
        @@     Meta data associated with an input.
        @@
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        DATA_TYPE_FIELD_NUMBER: builtins.int
        DIMS_FIELD_NUMBER: builtins.int
        ZERO_DATA_FIELD_NUMBER: builtins.int
        RANDOM_DATA_FIELD_NUMBER: builtins.int
        INPUT_DATA_FILE_FIELD_NUMBER: builtins.int
        data_type: global___DataType.ValueType
        """@@    .. cpp:var:: DataType data_type
        @@
        @@       The data-type of the input.
        @@
        """
        @property
        def dims(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
            """@@    .. cpp:var:: int64 dims (repeated)
            @@
            @@       The shape of the input tensor, not including the batch dimension.
            @@
            """
        zero_data: builtins.bool
        """@@
        @@    .. cpp:var:: bool zero_data
        @@
        @@       The identifier for using zeros as input data. Note that the
        @@       value of 'zero_data' will not be checked, instead, zero data
        @@       will be used as long as the field is set.
        @@
        """
        random_data: builtins.bool
        """@@
        @@    .. cpp:var:: bool random_data
        @@
        @@       The identifier for using random data as input data. Note that
        @@       the value of 'random_data' will not be checked, instead,
        @@       random data will be used as long as the field is set.
        @@
        """
        input_data_file: builtins.str
        """@@    .. cpp:var:: string input_data_file
        @@
        @@       The file whose content will be used as raw input data in
        @@       row-major order. The file must be provided in a sub-directory
        @@       'warmup' under the model directory. The file contents should be
        @@       in binary format. For TYPE_STRING data-type, an element is
        @@       represented by a 4-byte unsigned integer giving the length
        @@       followed by the actual bytes.
        @@
        """
        def __init__(
            self,
            *,
            data_type: global___DataType.ValueType = ...,
            dims: collections.abc.Iterable[builtins.int] | None = ...,
            zero_data: builtins.bool = ...,
            random_data: builtins.bool = ...,
            input_data_file: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["input_data_file", b"input_data_file", "input_data_type", b"input_data_type", "random_data", b"random_data", "zero_data", b"zero_data"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["data_type", b"data_type", "dims", b"dims", "input_data_file", b"input_data_file", "input_data_type", b"input_data_type", "random_data", b"random_data", "zero_data", b"zero_data"]) -> None: ...
        def WhichOneof(self, oneof_group: typing_extensions.Literal["input_data_type", b"input_data_type"]) -> typing_extensions.Literal["zero_data", "random_data", "input_data_file"] | None: ...

    class InputsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___ModelWarmup.Input: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___ModelWarmup.Input | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    BATCH_SIZE_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    COUNT_FIELD_NUMBER: builtins.int
    name: builtins.str
    """@@  .. cpp:var:: string name
    @@
    @@     The name of the request sample.
    @@
    """
    batch_size: builtins.int
    """@@  .. cpp:var:: uint32 batch_size
    @@
    @@     The batch size of the inference request. This must be >= 1. For
    @@     models that don't support batching, batch_size must be 1. If
    @@     batch_size > 1, the 'inputs' specified below will be duplicated to
    @@     match the batch size requested.
    @@
    """
    @property
    def inputs(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___ModelWarmup.Input]:
        """@@  .. cpp:var:: map<string, Input> inputs
        @@
        @@     The warmup meta data associated with every model input, including
        @@     control tensors.
        @@
        """
    count: builtins.int
    """@@  .. cpp:var:: uint32 count
    @@
    @@     The number of iterations that this warmup sample will be executed.
    @@     For example, if this field is set to 2, 2 model executions using this
    @@     sample will be scheduled for warmup. Default value is 0 which
    @@     indicates that this sample will be used only once.
    @@     Note that for sequence model, 'count' may not work well
    @@     because the model often expect a valid sequence of requests which
    @@     should be represented by a series of warmup samples. 'count > 1'
    @@     essentially "resends" one of the sample, which may invalidate the
    @@     sequence and result in unexpected warmup failure.
    @@
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        batch_size: builtins.int = ...,
        inputs: collections.abc.Mapping[builtins.str, global___ModelWarmup.Input] | None = ...,
        count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["batch_size", b"batch_size", "count", b"count", "inputs", b"inputs", "name", b"name"]) -> None: ...

global___ModelWarmup = ModelWarmup

class ModelOperations(google.protobuf.message.Message):
    """@@
    @@ .. cpp:var:: message ModelOperations
    @@
    @@    The metadata of libraries providing custom operations for this model.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OP_LIBRARY_FILENAME_FIELD_NUMBER: builtins.int
    @property
    def op_library_filename(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """@@  .. cpp:var:: string op_library_filename (repeated)
        @@
        @@     Optional paths of the libraries providing custom operations for
        @@     this model. Valid only for ONNX models.
        @@
        """
    def __init__(
        self,
        *,
        op_library_filename: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["op_library_filename", b"op_library_filename"]) -> None: ...

global___ModelOperations = ModelOperations

class ModelTransactionPolicy(google.protobuf.message.Message):
    """@@
    @@ .. cpp:var:: message ModelTransactionPolicy
    @@
    @@    The specification that describes the nature of transactions
    @@    to be expected from the model.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DECOUPLED_FIELD_NUMBER: builtins.int
    decoupled: builtins.bool
    """@@  .. cpp:var:: bool decoupled
    @@
    @@     Indicates whether responses generated by the model are decoupled with
    @@     the requests issued to it, which means the number of responses
    @@     generated by model may differ from number of requests issued, and
    @@     that the responses may be out of order relative to the order of
    @@     requests. The default is false, which means the model will generate
    @@     exactly one response for each request.
    @@
    """
    def __init__(
        self,
        *,
        decoupled: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["decoupled", b"decoupled"]) -> None: ...

global___ModelTransactionPolicy = ModelTransactionPolicy

class ModelRepositoryAgents(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ModelRepositoryAgents
    @@
    @@   The repository agents for the model.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class Agent(google.protobuf.message.Message):
        """@@
        @@  .. cpp:var:: message Agent
        @@
        @@     A repository agent that should be invoked for the specified
        @@     repository actions for this model.
        @@
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class ParametersEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: builtins.str
            value: builtins.str
            def __init__(
                self,
                *,
                key: builtins.str = ...,
                value: builtins.str = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

        NAME_FIELD_NUMBER: builtins.int
        PARAMETERS_FIELD_NUMBER: builtins.int
        name: builtins.str
        """@@    .. cpp:var:: string name
        @@
        @@       The name of the agent.
        @@
        """
        @property
        def parameters(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
            """@@    .. cpp:var:: map<string, string> parameters
            @@
            @@       The parameters for the agent.
            @@
            """
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            parameters: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "parameters", b"parameters"]) -> None: ...

    AGENTS_FIELD_NUMBER: builtins.int
    @property
    def agents(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelRepositoryAgents.Agent]:
        """@@
        @@  .. cpp:var:: Agent agents (repeated)
        @@
        @@     The ordered list of agents for the model. These agents will be
        @@     invoked in order to respond to repository actions occuring for the
        @@     model.
        @@
        """
    def __init__(
        self,
        *,
        agents: collections.abc.Iterable[global___ModelRepositoryAgents.Agent] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["agents", b"agents"]) -> None: ...

global___ModelRepositoryAgents = ModelRepositoryAgents

class ModelResponseCache(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ModelResponseCache
    @@
    @@   The response cache setting for the model.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENABLE_FIELD_NUMBER: builtins.int
    enable: builtins.bool
    """@@
    @@  .. cpp::var:: bool enable
    @@
    @@     Whether or not to use response cache for the model. If True, the
    @@     responses from the model are cached and when identical request
    @@     is encountered, instead of going through the model execution,
    @@     the response from the cache is utilized. By default, response
    @@     cache is disabled for the models.
    @@
    """
    def __init__(
        self,
        *,
        enable: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["enable", b"enable"]) -> None: ...

global___ModelResponseCache = ModelResponseCache

class ModelConfig(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ModelConfig
    @@
    @@   A model configuration.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class CcModelFilenamesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    class MetricTagsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    class ParametersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___ModelParameter: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___ModelParameter | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    PLATFORM_FIELD_NUMBER: builtins.int
    BACKEND_FIELD_NUMBER: builtins.int
    VERSION_POLICY_FIELD_NUMBER: builtins.int
    MAX_BATCH_SIZE_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    OUTPUT_FIELD_NUMBER: builtins.int
    BATCH_INPUT_FIELD_NUMBER: builtins.int
    BATCH_OUTPUT_FIELD_NUMBER: builtins.int
    OPTIMIZATION_FIELD_NUMBER: builtins.int
    DYNAMIC_BATCHING_FIELD_NUMBER: builtins.int
    SEQUENCE_BATCHING_FIELD_NUMBER: builtins.int
    ENSEMBLE_SCHEDULING_FIELD_NUMBER: builtins.int
    INSTANCE_GROUP_FIELD_NUMBER: builtins.int
    DEFAULT_MODEL_FILENAME_FIELD_NUMBER: builtins.int
    CC_MODEL_FILENAMES_FIELD_NUMBER: builtins.int
    METRIC_TAGS_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    MODEL_WARMUP_FIELD_NUMBER: builtins.int
    MODEL_OPERATIONS_FIELD_NUMBER: builtins.int
    MODEL_TRANSACTION_POLICY_FIELD_NUMBER: builtins.int
    MODEL_REPOSITORY_AGENTS_FIELD_NUMBER: builtins.int
    RESPONSE_CACHE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """@@  .. cpp:var:: string name
    @@
    @@     The name of the model.
    @@
    """
    platform: builtins.str
    """@@  .. cpp:var:: string platform
    @@
    @@     The framework for the model. Possible values are
    @@     "tensorrt_plan", "tensorflow_graphdef",
    @@     "tensorflow_savedmodel", "onnxruntime_onnx",
    @@     "pytorch_libtorch".
    @@
    """
    backend: builtins.str
    """@@  .. cpp:var:: string backend
    @@
    @@     The backend used by the model.
    @@
    """
    @property
    def version_policy(self) -> global___ModelVersionPolicy:
        """@@  .. cpp:var:: ModelVersionPolicy version_policy
        @@
        @@     Policy indicating which version(s) of the model will be served.
        @@
        """
    max_batch_size: builtins.int
    """@@  .. cpp:var:: int32 max_batch_size
    @@
    @@     Maximum batch size allowed for inference. This can only decrease
    @@     what is allowed by the model itself. A max_batch_size value of 0
    @@     indicates that batching is not allowed for the model and the
    @@     dimension/shape of the input and output tensors must exactly
    @@     match what is specified in the input and output configuration. A
    @@     max_batch_size value > 0 indicates that batching is allowed and
    @@     so the model expects the input tensors to have an additional
    @@     initial dimension for the batching that is not specified in the
    @@     input (for example, if the model supports batched inputs of
    @@     2-dimensional tensors then the model configuration will specify
    @@     the input shape as [ X, Y ] but the model will expect the actual
    @@     input tensors to have shape [ N, X, Y ]). For max_batch_size > 0
    @@     returned outputs will also have an additional initial dimension
    @@     for the batch.
    @@
    """
    @property
    def input(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelInput]:
        """@@  .. cpp:var:: ModelInput input (repeated)
        @@
        @@     The inputs request by the model.
        @@
        """
    @property
    def output(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelOutput]:
        """@@  .. cpp:var:: ModelOutput output (repeated)
        @@
        @@     The outputs produced by the model.
        @@
        """
    @property
    def batch_input(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BatchInput]:
        """@@  .. cpp:var:: BatchInput batch_input (repeated)
        @@
        @@     The model input(s) that the server should use to communicate
        @@     batch related values to the model.
        @@
        """
    @property
    def batch_output(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BatchOutput]:
        """@@  .. cpp:var:: BatchOutput batch_output (repeated)
        @@
        @@     The outputs produced by the model that requires special handling
        @@     by the model backend.
        @@
        """
    @property
    def optimization(self) -> global___ModelOptimizationPolicy:
        """@@  .. cpp:var:: ModelOptimizationPolicy optimization
        @@
        @@     Optimization configuration for the model. If not specified
        @@     then default optimization policy is used.
        @@
        """
    @property
    def dynamic_batching(self) -> global___ModelDynamicBatching:
        """@@    .. cpp:var:: ModelDynamicBatching dynamic_batching
        @@
        @@       If specified, enables the dynamic-batching scheduling
        @@       policy. With dynamic-batching the scheduler may group
        @@       together independent requests into a single batch to
        @@       improve inference throughput.
        @@
        """
    @property
    def sequence_batching(self) -> global___ModelSequenceBatching:
        """@@    .. cpp:var:: ModelSequenceBatching sequence_batching
        @@
        @@       If specified, enables the sequence-batching scheduling
        @@       policy. With sequence-batching, inference requests
        @@       with the same correlation ID are routed to the same
        @@       model instance. Multiple sequences of inference requests
        @@       may be batched together into a single batch to
        @@       improve inference throughput.
        @@
        """
    @property
    def ensemble_scheduling(self) -> global___ModelEnsembling:
        """@@    .. cpp:var:: ModelEnsembling ensemble_scheduling
        @@
        @@       If specified, enables the model-ensembling scheduling
        @@       policy. With model-ensembling, inference requests
        @@       will be processed according to the specification, such as an
        @@       execution sequence of models. The input specified in this model
        @@       config will be the input for the ensemble, and the output
        @@       specified will be the output of the ensemble.
        @@
        """
    @property
    def instance_group(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelInstanceGroup]:
        """@@  .. cpp:var:: ModelInstanceGroup instance_group (repeated)
        @@
        @@     Instances of this model. If not specified, one instance
        @@     of the model will be instantiated on each available GPU.
        @@
        """
    default_model_filename: builtins.str
    """@@  .. cpp:var:: string default_model_filename
    @@
    @@     Optional filename of the model file to use if a
    @@     compute-capability specific model is not specified in
    @@     :cpp:var:`cc_model_filenames`. If not specified the default name
    @@     is 'model.graphdef', 'model.savedmodel', 'model.plan' or
    @@     'model.pt' depending on the model type.
    @@
    """
    @property
    def cc_model_filenames(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """@@  .. cpp:var:: map<string,string> cc_model_filenames
        @@
        @@     Optional map from CUDA compute capability to the filename of
        @@     the model that supports that compute capability. The filename
        @@     refers to a file within the model version directory.
        @@
        """
    @property
    def metric_tags(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """@@  .. cpp:var:: map<string,string> metric_tags
        @@
        @@     Optional metric tags. User-specific key-value pairs for metrics
        @@     reported for this model. These tags are applied to the metrics
        @@     reported on the HTTP metrics port.
        @@
        """
    @property
    def parameters(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___ModelParameter]:
        """@@  .. cpp:var:: map<string,ModelParameter> parameters
        @@
        @@     Optional model parameters. User-specified parameter values.
        @@
        """
    @property
    def model_warmup(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelWarmup]:
        """@@  .. cpp:var:: ModelWarmup model_warmup (repeated)
        @@
        @@     Warmup setting of this model. If specified, all instances
        @@     will be run with the request samples in sequence before
        @@     serving the model.
        @@     This field can only be specified if the model is not an ensemble
        @@     model.
        @@
        """
    @property
    def model_operations(self) -> global___ModelOperations:
        """@@  .. cpp:var:: ModelOperations model_operations
        @@
        @@     Optional metadata of the libraries providing custom operations for
        @@     this model.
        @@
        """
    @property
    def model_transaction_policy(self) -> global___ModelTransactionPolicy:
        """@@  .. cpp:var:: ModelTransactionPolicy model_transaction_policy
        @@
        @@     Optional specification that describes the nature of transactions
        @@     to be expected from the model.
        @@
        """
    @property
    def model_repository_agents(self) -> global___ModelRepositoryAgents:
        """@@  .. cpp:var:: ModelRepositoryAgents model_repository_agents
        @@
        @@     Optional specification of the agent(s) that should be invoked
        @@     with repository actions are performed for this model.
        @@
        """
    @property
    def response_cache(self) -> global___ModelResponseCache:
        """@@  .. cpp:var:: ModelResponseCache response_cache
        @@
        @@     Optional setting for utilizing the response cache for this
        @@     model.
        @@
        """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        platform: builtins.str = ...,
        backend: builtins.str = ...,
        version_policy: global___ModelVersionPolicy | None = ...,
        max_batch_size: builtins.int = ...,
        input: collections.abc.Iterable[global___ModelInput] | None = ...,
        output: collections.abc.Iterable[global___ModelOutput] | None = ...,
        batch_input: collections.abc.Iterable[global___BatchInput] | None = ...,
        batch_output: collections.abc.Iterable[global___BatchOutput] | None = ...,
        optimization: global___ModelOptimizationPolicy | None = ...,
        dynamic_batching: global___ModelDynamicBatching | None = ...,
        sequence_batching: global___ModelSequenceBatching | None = ...,
        ensemble_scheduling: global___ModelEnsembling | None = ...,
        instance_group: collections.abc.Iterable[global___ModelInstanceGroup] | None = ...,
        default_model_filename: builtins.str = ...,
        cc_model_filenames: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        metric_tags: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        parameters: collections.abc.Mapping[builtins.str, global___ModelParameter] | None = ...,
        model_warmup: collections.abc.Iterable[global___ModelWarmup] | None = ...,
        model_operations: global___ModelOperations | None = ...,
        model_transaction_policy: global___ModelTransactionPolicy | None = ...,
        model_repository_agents: global___ModelRepositoryAgents | None = ...,
        response_cache: global___ModelResponseCache | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["dynamic_batching", b"dynamic_batching", "ensemble_scheduling", b"ensemble_scheduling", "model_operations", b"model_operations", "model_repository_agents", b"model_repository_agents", "model_transaction_policy", b"model_transaction_policy", "optimization", b"optimization", "response_cache", b"response_cache", "scheduling_choice", b"scheduling_choice", "sequence_batching", b"sequence_batching", "version_policy", b"version_policy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["backend", b"backend", "batch_input", b"batch_input", "batch_output", b"batch_output", "cc_model_filenames", b"cc_model_filenames", "default_model_filename", b"default_model_filename", "dynamic_batching", b"dynamic_batching", "ensemble_scheduling", b"ensemble_scheduling", "input", b"input", "instance_group", b"instance_group", "max_batch_size", b"max_batch_size", "metric_tags", b"metric_tags", "model_operations", b"model_operations", "model_repository_agents", b"model_repository_agents", "model_transaction_policy", b"model_transaction_policy", "model_warmup", b"model_warmup", "name", b"name", "optimization", b"optimization", "output", b"output", "parameters", b"parameters", "platform", b"platform", "response_cache", b"response_cache", "scheduling_choice", b"scheduling_choice", "sequence_batching", b"sequence_batching", "version_policy", b"version_policy"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["scheduling_choice", b"scheduling_choice"]) -> typing_extensions.Literal["dynamic_batching", "sequence_batching", "ensemble_scheduling"] | None: ...

global___ModelConfig = ModelConfig
