"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2020-2023, NVIDIA CORPORATION & AFFILIATES. All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
 * Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
 * Neither the name of NVIDIA CORPORATION nor the names of its
   contributors may be used to endorse or promote products derived
   from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import model_config_pb2
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class ServerLiveRequest(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ServerLiveRequest
    @@
    @@   Request message for ServerLive.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ServerLiveRequest = ServerLiveRequest

class ServerLiveResponse(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ServerLiveResponse
    @@
    @@   Response message for ServerLive.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LIVE_FIELD_NUMBER: builtins.int
    live: builtins.bool
    """@@
    @@  .. cpp:var:: bool live
    @@
    @@     True if the inference server is live, false it not live.
    @@
    """
    def __init__(
        self,
        *,
        live: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["live", b"live"]) -> None: ...

global___ServerLiveResponse = ServerLiveResponse

class ServerReadyRequest(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ServerReadyRequest
    @@
    @@   Request message for ServerReady.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ServerReadyRequest = ServerReadyRequest

class ServerReadyResponse(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ServerReadyResponse
    @@
    @@   Response message for ServerReady.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    READY_FIELD_NUMBER: builtins.int
    ready: builtins.bool
    """@@
    @@  .. cpp:var:: bool ready
    @@
    @@     True if the inference server is ready, false it not ready.
    @@
    """
    def __init__(
        self,
        *,
        ready: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["ready", b"ready"]) -> None: ...

global___ServerReadyResponse = ServerReadyResponse

class ModelReadyRequest(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ModelReadyRequest
    @@
    @@   Request message for ModelReady.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """@@
    @@  .. cpp:var:: string name
    @@
    @@     The name of the model to check for readiness.
    @@
    """
    version: builtins.str
    """@@  .. cpp:var:: string version
    @@
    @@     The version of the model to check for readiness. If not given the
    @@     server will choose a version based on the model and internal policy.
    @@
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        version: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "version", b"version"]) -> None: ...

global___ModelReadyRequest = ModelReadyRequest

class ModelReadyResponse(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ModelReadyResponse
    @@
    @@   Response message for ModelReady.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    READY_FIELD_NUMBER: builtins.int
    ready: builtins.bool
    """@@
    @@  .. cpp:var:: bool ready
    @@
    @@     True if the model is ready, false it not ready.
    @@
    """
    def __init__(
        self,
        *,
        ready: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["ready", b"ready"]) -> None: ...

global___ModelReadyResponse = ModelReadyResponse

class ServerMetadataRequest(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ServerMetadataRequest
    @@
    @@   Request message for ServerMetadata.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ServerMetadataRequest = ServerMetadataRequest

class ServerMetadataResponse(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ServerMetadataResponse
    @@
    @@   Response message for ServerMetadata.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    EXTENSIONS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """@@
    @@  .. cpp:var:: string name
    @@
    @@     The server name.
    @@
    """
    version: builtins.str
    """@@
    @@  .. cpp:var:: string version
    @@
    @@     The server version.
    @@
    """
    @property
    def extensions(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """@@
        @@  .. cpp:var:: string extensions (repeated)
        @@
        @@     The extensions supported by the server.
        @@
        """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        version: builtins.str = ...,
        extensions: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["extensions", b"extensions", "name", b"name", "version", b"version"]) -> None: ...

global___ServerMetadataResponse = ServerMetadataResponse

class ModelMetadataRequest(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ModelMetadataRequest
    @@
    @@   Request message for ModelMetadata.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """@@
    @@  .. cpp:var:: string name
    @@
    @@     The name of the model.
    @@
    """
    version: builtins.str
    """@@  .. cpp:var:: string version
    @@
    @@     The version of the model to check for readiness. If not
    @@     given the server will choose a version based on the
    @@     model and internal policy.
    @@
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        version: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "version", b"version"]) -> None: ...

global___ModelMetadataRequest = ModelMetadataRequest

class ModelMetadataResponse(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ModelMetadataResponse
    @@
    @@   Response message for ModelMetadata.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class TensorMetadata(google.protobuf.message.Message):
        """@@
        @@  .. cpp:var:: message TensorMetadata
        @@
        @@     Metadata for a tensor.
        @@
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        DATATYPE_FIELD_NUMBER: builtins.int
        SHAPE_FIELD_NUMBER: builtins.int
        name: builtins.str
        """@@
        @@    .. cpp:var:: string name
        @@
        @@       The tensor name.
        @@
        """
        datatype: builtins.str
        """@@
        @@    .. cpp:var:: string datatype
        @@
        @@       The tensor data type.
        @@
        """
        @property
        def shape(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
            """@@
            @@    .. cpp:var:: int64 shape (repeated)
            @@
            @@       The tensor shape. A variable-size dimension is represented
            @@       by a -1 value.
            @@
            """
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            datatype: builtins.str = ...,
            shape: collections.abc.Iterable[builtins.int] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["datatype", b"datatype", "name", b"name", "shape", b"shape"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    VERSIONS_FIELD_NUMBER: builtins.int
    PLATFORM_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    OUTPUTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """@@
    @@  .. cpp:var:: string name
    @@
    @@     The model name.
    @@
    """
    @property
    def versions(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """@@
        @@  .. cpp:var:: string versions (repeated)
        @@
        @@     The versions of the model.
        @@
        """
    platform: builtins.str
    """@@
    @@  .. cpp:var:: string platform
    @@
    @@     The model's platform.
    @@
    """
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelMetadataResponse.TensorMetadata]:
        """@@
        @@  .. cpp:var:: TensorMetadata inputs (repeated)
        @@
        @@     The model's inputs.
        @@
        """
    @property
    def outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelMetadataResponse.TensorMetadata]:
        """@@
        @@  .. cpp:var:: TensorMetadata outputs (repeated)
        @@
        @@     The model's outputs.
        @@
        """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        versions: collections.abc.Iterable[builtins.str] | None = ...,
        platform: builtins.str = ...,
        inputs: collections.abc.Iterable[global___ModelMetadataResponse.TensorMetadata] | None = ...,
        outputs: collections.abc.Iterable[global___ModelMetadataResponse.TensorMetadata] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["inputs", b"inputs", "name", b"name", "outputs", b"outputs", "platform", b"platform", "versions", b"versions"]) -> None: ...

global___ModelMetadataResponse = ModelMetadataResponse

class InferParameter(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message InferParameter
    @@
    @@   An inference parameter value.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BOOL_PARAM_FIELD_NUMBER: builtins.int
    INT64_PARAM_FIELD_NUMBER: builtins.int
    STRING_PARAM_FIELD_NUMBER: builtins.int
    bool_param: builtins.bool
    """@@    .. cpp:var:: bool bool_param
    @@
    @@       A boolean parameter value.
    @@
    """
    int64_param: builtins.int
    """@@    .. cpp:var:: int64 int64_param
    @@
    @@       An int64 parameter value.
    @@
    """
    string_param: builtins.str
    """@@    .. cpp:var:: string string_param
    @@
    @@       A string parameter value.
    @@
    """
    def __init__(
        self,
        *,
        bool_param: builtins.bool = ...,
        int64_param: builtins.int = ...,
        string_param: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["bool_param", b"bool_param", "int64_param", b"int64_param", "parameter_choice", b"parameter_choice", "string_param", b"string_param"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["bool_param", b"bool_param", "int64_param", b"int64_param", "parameter_choice", b"parameter_choice", "string_param", b"string_param"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["parameter_choice", b"parameter_choice"]) -> typing_extensions.Literal["bool_param", "int64_param", "string_param"] | None: ...

global___InferParameter = InferParameter

class InferTensorContents(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message InferTensorContents
    @@
    @@   The data contained in a tensor represented by the repeated type
    @@   that matches the tensor's data type. Protobuf oneof is not used
    @@   because oneofs cannot contain repeated fields.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BOOL_CONTENTS_FIELD_NUMBER: builtins.int
    INT_CONTENTS_FIELD_NUMBER: builtins.int
    INT64_CONTENTS_FIELD_NUMBER: builtins.int
    UINT_CONTENTS_FIELD_NUMBER: builtins.int
    UINT64_CONTENTS_FIELD_NUMBER: builtins.int
    FP32_CONTENTS_FIELD_NUMBER: builtins.int
    FP64_CONTENTS_FIELD_NUMBER: builtins.int
    BYTES_CONTENTS_FIELD_NUMBER: builtins.int
    @property
    def bool_contents(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bool]:
        """@@
        @@  .. cpp:var:: bool bool_contents (repeated)
        @@
        @@     Representation for BOOL data type. The size must match what is
        @@     expected by the tensor's shape. The contents must be the flattened,
        @@     one-dimensional, row-major order of the tensor elements.
        @@
        """
    @property
    def int_contents(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """@@
        @@  .. cpp:var:: int32 int_contents (repeated)
        @@
        @@     Representation for INT8, INT16, and INT32 data types. The size
        @@     must match what is expected by the tensor's shape. The contents
        @@     must be the flattened, one-dimensional, row-major order of the
        @@     tensor elements.
        @@
        """
    @property
    def int64_contents(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """@@
        @@  .. cpp:var:: int64 int64_contents (repeated)
        @@
        @@     Representation for INT64 data types. The size must match what
        @@     is expected by the tensor's shape. The contents must be the
        @@     flattened, one-dimensional, row-major order of the tensor elements.
        @@
        """
    @property
    def uint_contents(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """@@
        @@  .. cpp:var:: uint32 uint_contents (repeated)
        @@
        @@     Representation for UINT8, UINT16, and UINT32 data types. The size
        @@     must match what is expected by the tensor's shape. The contents
        @@     must be the flattened, one-dimensional, row-major order of the
        @@     tensor elements.
        @@
        """
    @property
    def uint64_contents(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """@@
        @@  .. cpp:var:: uint64 uint64_contents (repeated)
        @@
        @@     Representation for UINT64 data types. The size must match what
        @@     is expected by the tensor's shape. The contents must be the
        @@     flattened, one-dimensional, row-major order of the tensor elements.
        @@
        """
    @property
    def fp32_contents(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """@@
        @@  .. cpp:var:: float fp32_contents (repeated)
        @@
        @@     Representation for FP32 data type. The size must match what is
        @@     expected by the tensor's shape. The contents must be the flattened,
        @@     one-dimensional, row-major order of the tensor elements.
        @@
        """
    @property
    def fp64_contents(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """@@
        @@  .. cpp:var:: double fp64_contents (repeated)
        @@
        @@     Representation for FP64 data type. The size must match what is
        @@     expected by the tensor's shape. The contents must be the flattened,
        @@     one-dimensional, row-major order of the tensor elements.
        @@
        """
    @property
    def bytes_contents(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bytes]:
        """@@
        @@  .. cpp:var:: bytes bytes_contents (repeated)
        @@
        @@     Representation for BYTES data type. The size must match what is
        @@     expected by the tensor's shape. The contents must be the flattened,
        @@     one-dimensional, row-major order of the tensor elements.
        @@
        """
    def __init__(
        self,
        *,
        bool_contents: collections.abc.Iterable[builtins.bool] | None = ...,
        int_contents: collections.abc.Iterable[builtins.int] | None = ...,
        int64_contents: collections.abc.Iterable[builtins.int] | None = ...,
        uint_contents: collections.abc.Iterable[builtins.int] | None = ...,
        uint64_contents: collections.abc.Iterable[builtins.int] | None = ...,
        fp32_contents: collections.abc.Iterable[builtins.float] | None = ...,
        fp64_contents: collections.abc.Iterable[builtins.float] | None = ...,
        bytes_contents: collections.abc.Iterable[builtins.bytes] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bool_contents", b"bool_contents", "bytes_contents", b"bytes_contents", "fp32_contents", b"fp32_contents", "fp64_contents", b"fp64_contents", "int64_contents", b"int64_contents", "int_contents", b"int_contents", "uint64_contents", b"uint64_contents", "uint_contents", b"uint_contents"]) -> None: ...

global___InferTensorContents = InferTensorContents

class ModelInferRequest(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ModelInferRequest
    @@
    @@   Request message for ModelInfer.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class InferInputTensor(google.protobuf.message.Message):
        """@@
        @@  .. cpp:var:: message InferInputTensor
        @@
        @@     An input tensor for an inference request.
        @@
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class ParametersEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: builtins.str
            @property
            def value(self) -> global___InferParameter: ...
            def __init__(
                self,
                *,
                key: builtins.str = ...,
                value: global___InferParameter | None = ...,
            ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

        NAME_FIELD_NUMBER: builtins.int
        DATATYPE_FIELD_NUMBER: builtins.int
        SHAPE_FIELD_NUMBER: builtins.int
        PARAMETERS_FIELD_NUMBER: builtins.int
        CONTENTS_FIELD_NUMBER: builtins.int
        name: builtins.str
        """@@
        @@    .. cpp:var:: string name
        @@
        @@       The tensor name.
        @@
        """
        datatype: builtins.str
        """@@
        @@    .. cpp:var:: string datatype
        @@
        @@       The tensor data type.
        @@
        """
        @property
        def shape(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
            """@@
            @@    .. cpp:var:: int64 shape (repeated)
            @@
            @@       The tensor shape.
            @@
            """
        @property
        def parameters(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___InferParameter]:
            """@@    .. cpp:var:: map<string,InferParameter> parameters
            @@
            @@       Optional inference input tensor parameters.
            @@
            """
        @property
        def contents(self) -> global___InferTensorContents:
            """@@    .. cpp:var:: InferTensorContents contents
            @@
            @@       The tensor contents using a data-type format. This field
            @@       must not be specified if tensor contents are being specified
            @@       in ModelInferRequest.raw_input_contents.
            @@
            """
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            datatype: builtins.str = ...,
            shape: collections.abc.Iterable[builtins.int] | None = ...,
            parameters: collections.abc.Mapping[builtins.str, global___InferParameter] | None = ...,
            contents: global___InferTensorContents | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["contents", b"contents"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["contents", b"contents", "datatype", b"datatype", "name", b"name", "parameters", b"parameters", "shape", b"shape"]) -> None: ...

    class InferRequestedOutputTensor(google.protobuf.message.Message):
        """@@
        @@  .. cpp:var:: message InferRequestedOutputTensor
        @@
        @@     An output tensor requested for an inference request.
        @@
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class ParametersEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: builtins.str
            @property
            def value(self) -> global___InferParameter: ...
            def __init__(
                self,
                *,
                key: builtins.str = ...,
                value: global___InferParameter | None = ...,
            ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

        NAME_FIELD_NUMBER: builtins.int
        PARAMETERS_FIELD_NUMBER: builtins.int
        name: builtins.str
        """@@
        @@    .. cpp:var:: string name
        @@
        @@       The tensor name.
        @@
        """
        @property
        def parameters(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___InferParameter]:
            """@@    .. cpp:var:: map<string,InferParameter> parameters
            @@
            @@       Optional requested output tensor parameters.
            @@
            """
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            parameters: collections.abc.Mapping[builtins.str, global___InferParameter] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "parameters", b"parameters"]) -> None: ...

    class ParametersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___InferParameter: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___InferParameter | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    MODEL_NAME_FIELD_NUMBER: builtins.int
    MODEL_VERSION_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    OUTPUTS_FIELD_NUMBER: builtins.int
    RAW_INPUT_CONTENTS_FIELD_NUMBER: builtins.int
    model_name: builtins.str
    """@@  .. cpp:var:: string model_name
    @@
    @@     The name of the model to use for inferencing.
    @@
    """
    model_version: builtins.str
    """@@  .. cpp:var:: string model_version
    @@
    @@     The version of the model to use for inference. If not
    @@     given the latest/most-recent version of the model is used.
    @@
    """
    id: builtins.str
    """@@  .. cpp:var:: string id
    @@
    @@     Optional identifier for the request. If specified will be
    @@     returned in the response.
    @@
    """
    @property
    def parameters(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___InferParameter]:
        """@@  .. cpp:var:: map<string,InferParameter> parameters
        @@
        @@     Optional inference parameters.
        @@
        """
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelInferRequest.InferInputTensor]:
        """@@
        @@  .. cpp:var:: InferInputTensor inputs (repeated)
        @@
        @@     The input tensors for the inference.
        @@
        """
    @property
    def outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelInferRequest.InferRequestedOutputTensor]:
        """@@
        @@  .. cpp:var:: InferRequestedOutputTensor outputs (repeated)
        @@
        @@     The requested output tensors for the inference. Optional, if not
        @@     specified all outputs specified in the model config will be
        @@     returned.
        @@
        """
    @property
    def raw_input_contents(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bytes]:
        """@@
        @@  .. cpp:var:: bytes raw_input_contents
        @@
        @@     The data contained in an input tensor can be represented in
        @@     "raw" bytes form or in the repeated type that matches the
        @@     tensor's data type. Using the "raw" bytes form will
        @@     typically allow higher performance due to the way protobuf
        @@     allocation and reuse interacts with GRPC. For example, see
        @@     https://github.com/grpc/grpc/issues/23231.
        @@
        @@     To use the raw representation 'raw_input_contents' must be
        @@     initialized with data for each tensor in the same order as
        @@     'inputs'. For each tensor, the size of this content must
        @@     match what is expected by the tensor's shape and data
        @@     type. The raw data must be the flattened, one-dimensional,
        @@     row-major order of the tensor elements without any stride
        @@     or padding between the elements. Note that the FP16 and BF16 data
        @@     types must be represented as raw content as there is no
        @@     specific data type for a 16-bit float type.
        @@
        @@     If this field is specified then InferInputTensor::contents
        @@     must not be specified for any input tensor.
        @@
        """
    def __init__(
        self,
        *,
        model_name: builtins.str = ...,
        model_version: builtins.str = ...,
        id: builtins.str = ...,
        parameters: collections.abc.Mapping[builtins.str, global___InferParameter] | None = ...,
        inputs: collections.abc.Iterable[global___ModelInferRequest.InferInputTensor] | None = ...,
        outputs: collections.abc.Iterable[global___ModelInferRequest.InferRequestedOutputTensor] | None = ...,
        raw_input_contents: collections.abc.Iterable[builtins.bytes] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "inputs", b"inputs", "model_name", b"model_name", "model_version", b"model_version", "outputs", b"outputs", "parameters", b"parameters", "raw_input_contents", b"raw_input_contents"]) -> None: ...

global___ModelInferRequest = ModelInferRequest

class ModelInferResponse(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ModelInferResponse
    @@
    @@   Response message for ModelInfer.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class InferOutputTensor(google.protobuf.message.Message):
        """@@
        @@  .. cpp:var:: message InferOutputTensor
        @@
        @@     An output tensor returned for an inference request.
        @@
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class ParametersEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: builtins.str
            @property
            def value(self) -> global___InferParameter: ...
            def __init__(
                self,
                *,
                key: builtins.str = ...,
                value: global___InferParameter | None = ...,
            ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

        NAME_FIELD_NUMBER: builtins.int
        DATATYPE_FIELD_NUMBER: builtins.int
        SHAPE_FIELD_NUMBER: builtins.int
        PARAMETERS_FIELD_NUMBER: builtins.int
        CONTENTS_FIELD_NUMBER: builtins.int
        name: builtins.str
        """@@
        @@    .. cpp:var:: string name
        @@
        @@       The tensor name.
        @@
        """
        datatype: builtins.str
        """@@
        @@    .. cpp:var:: string datatype
        @@
        @@       The tensor data type.
        @@
        """
        @property
        def shape(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
            """@@
            @@    .. cpp:var:: int64 shape (repeated)
            @@
            @@       The tensor shape.
            @@
            """
        @property
        def parameters(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___InferParameter]:
            """@@    .. cpp:var:: map<string,InferParameter> parameters
            @@
            @@       Optional output tensor parameters.
            @@
            """
        @property
        def contents(self) -> global___InferTensorContents:
            """@@    .. cpp:var:: InferTensorContents contents
            @@
            @@       The tensor contents using a data-type format. This field
            @@       must not be specified if tensor contents are being specified
            @@       in ModelInferResponse.raw_output_contents.
            @@
            """
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            datatype: builtins.str = ...,
            shape: collections.abc.Iterable[builtins.int] | None = ...,
            parameters: collections.abc.Mapping[builtins.str, global___InferParameter] | None = ...,
            contents: global___InferTensorContents | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["contents", b"contents"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["contents", b"contents", "datatype", b"datatype", "name", b"name", "parameters", b"parameters", "shape", b"shape"]) -> None: ...

    class ParametersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___InferParameter: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___InferParameter | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    MODEL_NAME_FIELD_NUMBER: builtins.int
    MODEL_VERSION_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    OUTPUTS_FIELD_NUMBER: builtins.int
    RAW_OUTPUT_CONTENTS_FIELD_NUMBER: builtins.int
    model_name: builtins.str
    """@@  .. cpp:var:: string model_name
    @@
    @@     The name of the model used for inference.
    @@
    """
    model_version: builtins.str
    """@@  .. cpp:var:: string model_version
    @@
    @@     The version of the model used for inference.
    @@
    """
    id: builtins.str
    """@@  .. cpp:var:: string id
    @@
    @@     The id of the inference request if one was specified.
    @@
    """
    @property
    def parameters(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___InferParameter]:
        """@@  .. cpp:var:: map<string,InferParameter> parameters
        @@
        @@     Optional inference response parameters.
        @@
        """
    @property
    def outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelInferResponse.InferOutputTensor]:
        """@@
        @@  .. cpp:var:: InferOutputTensor outputs (repeated)
        @@
        @@     The output tensors holding inference results.
        @@
        """
    @property
    def raw_output_contents(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bytes]:
        """@@
        @@  .. cpp:var:: bytes raw_output_contents
        @@
        @@     The data contained in an output tensor can be represented in
        @@     "raw" bytes form or in the repeated type that matches the
        @@     tensor's data type. Using the "raw" bytes form will
        @@     typically allow higher performance due to the way protobuf
        @@     allocation and reuse interacts with GRPC. For example, see
        @@     https://github.com/grpc/grpc/issues/23231.
        @@
        @@     To use the raw representation 'raw_output_contents' must be
        @@     initialized with data for each tensor in the same order as
        @@     'outputs'. For each tensor, the size of this content must
        @@     match what is expected by the tensor's shape and data
        @@     type. The raw data must be the flattened, one-dimensional,
        @@     row-major order of the tensor elements without any stride
        @@     or padding between the elements. Note that the FP16 and BF16 data
        @@     types must be represented as raw content as there is no
        @@     specific data type for a 16-bit float type.
        @@
        @@     If this field is specified then InferOutputTensor::contents
        @@     must not be specified for any output tensor.
        @@
        """
    def __init__(
        self,
        *,
        model_name: builtins.str = ...,
        model_version: builtins.str = ...,
        id: builtins.str = ...,
        parameters: collections.abc.Mapping[builtins.str, global___InferParameter] | None = ...,
        outputs: collections.abc.Iterable[global___ModelInferResponse.InferOutputTensor] | None = ...,
        raw_output_contents: collections.abc.Iterable[builtins.bytes] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "model_name", b"model_name", "model_version", b"model_version", "outputs", b"outputs", "parameters", b"parameters", "raw_output_contents", b"raw_output_contents"]) -> None: ...

global___ModelInferResponse = ModelInferResponse

class ModelStreamInferResponse(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ModelStreamInferResponse
    @@
    @@   Response message for ModelStreamInfer.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ERROR_MESSAGE_FIELD_NUMBER: builtins.int
    INFER_RESPONSE_FIELD_NUMBER: builtins.int
    error_message: builtins.str
    """@@
    @@  .. cpp:var:: string error_message
    @@
    @@     The message describing the error. The empty message
    @@     indicates the inference was successful without errors.
    @@
    """
    @property
    def infer_response(self) -> global___ModelInferResponse:
        """@@
        @@  .. cpp:var:: ModelInferResponse infer_response
        @@
        @@     Holds the results of the request.
        @@
        """
    def __init__(
        self,
        *,
        error_message: builtins.str = ...,
        infer_response: global___ModelInferResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["infer_response", b"infer_response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["error_message", b"error_message", "infer_response", b"infer_response"]) -> None: ...

global___ModelStreamInferResponse = ModelStreamInferResponse

class ModelConfigRequest(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ModelConfigRequest
    @@
    @@   Request message for ModelConfig.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """@@
    @@  .. cpp:var:: string name
    @@
    @@     The name of the model.
    @@
    """
    version: builtins.str
    """@@  .. cpp:var:: string version
    @@
    @@     The version of the model. If not given the model version
    @@     is selected automatically based on the version policy.
    @@
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        version: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "version", b"version"]) -> None: ...

global___ModelConfigRequest = ModelConfigRequest

class ModelConfigResponse(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ModelConfigResponse
    @@
    @@   Response message for ModelConfig.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONFIG_FIELD_NUMBER: builtins.int
    @property
    def config(self) -> model_config_pb2.ModelConfig:
        """@@
        @@  .. cpp:var:: ModelConfig config
        @@
        @@     The model configuration.
        @@
        """
    def __init__(
        self,
        *,
        config: model_config_pb2.ModelConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["config", b"config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["config", b"config"]) -> None: ...

global___ModelConfigResponse = ModelConfigResponse

class ModelStatisticsRequest(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ModelStatisticsRequest
    @@
    @@   Request message for ModelStatistics.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """@@  .. cpp:var:: string name
    @@
    @@     The name of the model. If not given returns statistics for
    @@     all models.
    @@
    """
    version: builtins.str
    """@@  .. cpp:var:: string version
    @@
    @@     The version of the model. If not given returns statistics for
    @@     all model versions.
    @@
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        version: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "version", b"version"]) -> None: ...

global___ModelStatisticsRequest = ModelStatisticsRequest

class StatisticDuration(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message StatisticDuration
    @@
    @@   Statistic recording a cumulative duration metric.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COUNT_FIELD_NUMBER: builtins.int
    NS_FIELD_NUMBER: builtins.int
    count: builtins.int
    """@@  .. cpp:var:: uint64 count
    @@
    @@     Cumulative number of times this metric occurred.
    @@
    """
    ns: builtins.int
    """@@  .. cpp:var:: uint64 total_time_ns
    @@
    @@     Total collected duration of this metric in nanoseconds.
    @@
    """
    def __init__(
        self,
        *,
        count: builtins.int = ...,
        ns: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["count", b"count", "ns", b"ns"]) -> None: ...

global___StatisticDuration = StatisticDuration

class InferStatistics(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message InferStatistics
    @@
    @@   Inference statistics.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUCCESS_FIELD_NUMBER: builtins.int
    FAIL_FIELD_NUMBER: builtins.int
    QUEUE_FIELD_NUMBER: builtins.int
    COMPUTE_INPUT_FIELD_NUMBER: builtins.int
    COMPUTE_INFER_FIELD_NUMBER: builtins.int
    COMPUTE_OUTPUT_FIELD_NUMBER: builtins.int
    CACHE_HIT_FIELD_NUMBER: builtins.int
    CACHE_MISS_FIELD_NUMBER: builtins.int
    @property
    def success(self) -> global___StatisticDuration:
        """@@  .. cpp:var:: StatisticDuration success
        @@
        @@     Cumulative count and duration for successful inference
        @@     request. The "success" count and cumulative duration includes
        @@     cache hits.
        @@
        """
    @property
    def fail(self) -> global___StatisticDuration:
        """@@  .. cpp:var:: StatisticDuration fail
        @@
        @@     Cumulative count and duration for failed inference
        @@     request.
        @@
        """
    @property
    def queue(self) -> global___StatisticDuration:
        """@@  .. cpp:var:: StatisticDuration queue
        @@
        @@     The count and cumulative duration that inference requests wait in
        @@     scheduling or other queues. The "queue" count and cumulative 
        @@     duration includes cache hits.
        @@
        """
    @property
    def compute_input(self) -> global___StatisticDuration:
        """@@  .. cpp:var:: StatisticDuration compute_input
        @@
        @@     The count and cumulative duration to prepare input tensor data as
        @@     required by the model framework / backend. For example, this duration
        @@     should include the time to copy input tensor data to the GPU.
        @@     The "compute_input" count and cumulative duration do not account for
        @@     requests that were a cache hit. See the "cache_hit" field for more
        @@     info.
        @@
        """
    @property
    def compute_infer(self) -> global___StatisticDuration:
        """@@  .. cpp:var:: StatisticDuration compute_infer
        @@
        @@     The count and cumulative duration to execute the model.
        @@     The "compute_infer" count and cumulative duration do not account for
        @@     requests that were a cache hit. See the "cache_hit" field for more
        @@     info.
        @@
        """
    @property
    def compute_output(self) -> global___StatisticDuration:
        """@@  .. cpp:var:: StatisticDuration compute_output
        @@
        @@     The count and cumulative duration to extract output tensor data
        @@     produced by the model framework / backend. For example, this duration
        @@     should include the time to copy output tensor data from the GPU.
        @@     The "compute_output" count and cumulative duration do not account for
        @@     requests that were a cache hit. See the "cache_hit" field for more
        @@     info.
        @@
        """
    @property
    def cache_hit(self) -> global___StatisticDuration:
        """@@  .. cpp:var:: StatisticDuration cache_hit
        @@
        @@     The count of response cache hits and cumulative duration to lookup
        @@     and extract output tensor data from the Response Cache on a cache
        @@     hit. For example, this duration should include the time to copy
        @@     output tensor data from the Response Cache to the response object.
        @@     On cache hits, triton does not need to go to the model/backend 
        @@     for the output tensor data, so the "compute_input", "compute_infer",
        @@     and "compute_output" fields are not updated. Assuming the response
        @@     cache is enabled for a given model, a cache hit occurs for a
        @@     request to that model when the request metadata (model name,
        @@     model version, model inputs) hashes to an existing entry in the
        @@     cache. On a cache miss, the request hash and response output tensor
        @@     data is added to the cache. See response cache docs for more info:
        @@     https://github.com/triton-inference-server/server/blob/main/docs/response_cache.md
        @@
        """
    @property
    def cache_miss(self) -> global___StatisticDuration:
        """@@  .. cpp:var:: StatisticDuration cache_miss
        @@
        @@     The count of response cache misses and cumulative duration to lookup
        @@     and insert output tensor data from the computed response to the cache.
        @@     For example, this duration should include the time to copy
        @@     output tensor data from the response object to the Response Cache.
        @@     Assuming the response cache is enabled for a given model, a cache
        @@     miss occurs for a request to that model when the request metadata
        @@     does NOT hash to an existing entry in the cache. See the response
        @@     cache docs for more info:
        @@     https://github.com/triton-inference-server/server/blob/main/docs/response_cache.md
        @@
        """
    def __init__(
        self,
        *,
        success: global___StatisticDuration | None = ...,
        fail: global___StatisticDuration | None = ...,
        queue: global___StatisticDuration | None = ...,
        compute_input: global___StatisticDuration | None = ...,
        compute_infer: global___StatisticDuration | None = ...,
        compute_output: global___StatisticDuration | None = ...,
        cache_hit: global___StatisticDuration | None = ...,
        cache_miss: global___StatisticDuration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["cache_hit", b"cache_hit", "cache_miss", b"cache_miss", "compute_infer", b"compute_infer", "compute_input", b"compute_input", "compute_output", b"compute_output", "fail", b"fail", "queue", b"queue", "success", b"success"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cache_hit", b"cache_hit", "cache_miss", b"cache_miss", "compute_infer", b"compute_infer", "compute_input", b"compute_input", "compute_output", b"compute_output", "fail", b"fail", "queue", b"queue", "success", b"success"]) -> None: ...

global___InferStatistics = InferStatistics

class InferBatchStatistics(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message InferBatchStatistics
    @@
    @@   Inference batch statistics.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BATCH_SIZE_FIELD_NUMBER: builtins.int
    COMPUTE_INPUT_FIELD_NUMBER: builtins.int
    COMPUTE_INFER_FIELD_NUMBER: builtins.int
    COMPUTE_OUTPUT_FIELD_NUMBER: builtins.int
    batch_size: builtins.int
    """@@  .. cpp:var:: uint64 batch_size
    @@
    @@     The size of the batch.
    @@
    """
    @property
    def compute_input(self) -> global___StatisticDuration:
        """@@  .. cpp:var:: StatisticDuration compute_input
        @@
        @@     The count and cumulative duration to prepare input tensor data as
        @@     required by the model framework / backend with the given batch size.
        @@     For example, this duration should include the time to copy input
        @@     tensor data to the GPU.
        @@
        """
    @property
    def compute_infer(self) -> global___StatisticDuration:
        """@@  .. cpp:var:: StatisticDuration compute_infer
        @@
        @@     The count and cumulative duration to execute the model with the given
        @@     batch size.
        @@
        """
    @property
    def compute_output(self) -> global___StatisticDuration:
        """@@  .. cpp:var:: StatisticDuration compute_output
        @@
        @@     The count and cumulative duration to extract output tensor data
        @@     produced by the model framework / backend with the given batch size.
        @@     For example, this duration should include the time to copy output
        @@     tensor data from the GPU.
        @@
        """
    def __init__(
        self,
        *,
        batch_size: builtins.int = ...,
        compute_input: global___StatisticDuration | None = ...,
        compute_infer: global___StatisticDuration | None = ...,
        compute_output: global___StatisticDuration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["compute_infer", b"compute_infer", "compute_input", b"compute_input", "compute_output", b"compute_output"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["batch_size", b"batch_size", "compute_infer", b"compute_infer", "compute_input", b"compute_input", "compute_output", b"compute_output"]) -> None: ...

global___InferBatchStatistics = InferBatchStatistics

class ModelStatistics(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ModelStatistics
    @@
    @@   Statistics for a specific model and version.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    LAST_INFERENCE_FIELD_NUMBER: builtins.int
    INFERENCE_COUNT_FIELD_NUMBER: builtins.int
    EXECUTION_COUNT_FIELD_NUMBER: builtins.int
    INFERENCE_STATS_FIELD_NUMBER: builtins.int
    BATCH_STATS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """@@  .. cpp:var:: string name
    @@
    @@     The name of the model. If not given returns statistics for all
    @@
    """
    version: builtins.str
    """@@  .. cpp:var:: string version
    @@
    @@     The version of the model.
    @@
    """
    last_inference: builtins.int
    """@@  .. cpp:var:: uint64 last_inference
    @@
    @@     The timestamp of the last inference request made for this model,
    @@     as milliseconds since the epoch.
    @@
    """
    inference_count: builtins.int
    """@@  .. cpp:var:: uint64 last_inference
    @@
    @@     The cumulative count of successful inference requests made for this
    @@     model. Each inference in a batched request is counted as an
    @@     individual inference. For example, if a client sends a single
    @@     inference request with batch size 64, "inference_count" will be
    @@     incremented by 64. Similarly, if a clients sends 64 individual
    @@     requests each with batch size 1, "inference_count" will be
    @@     incremented by 64. The "inference_count" value DOES NOT include
    @@     cache hits.
    @@
    """
    execution_count: builtins.int
    """@@  .. cpp:var:: uint64 last_inference
    @@
    @@     The cumulative count of the number of successful inference executions
    @@     performed for the model. When dynamic batching is enabled, a single
    @@     model execution can perform inferencing for more than one inference
    @@     request. For example, if a clients sends 64 individual requests each
    @@     with batch size 1 and the dynamic batcher batches them into a single
    @@     large batch for model execution then "execution_count" will be
    @@     incremented by 1. If, on the other hand, the dynamic batcher is not
    @@     enabled for that each of the 64 individual requests is executed
    @@     independently, then "execution_count" will be incremented by 64.
    @@     The "execution_count" value DOES NOT include cache hits.
    @@
    """
    @property
    def inference_stats(self) -> global___InferStatistics:
        """@@  .. cpp:var:: InferStatistics inference_stats
        @@
        @@     The aggregate statistics for the model/version.
        @@
        """
    @property
    def batch_stats(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___InferBatchStatistics]:
        """@@  .. cpp:var:: InferBatchStatistics batch_stats (repeated)
        @@
        @@     The aggregate statistics for each different batch size that is
        @@     executed in the model. The batch statistics indicate how many actual
        @@     model executions were performed and show differences due to different
        @@     batch size (for example, larger batches typically take longer to
        @@     compute).
        @@
        """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        version: builtins.str = ...,
        last_inference: builtins.int = ...,
        inference_count: builtins.int = ...,
        execution_count: builtins.int = ...,
        inference_stats: global___InferStatistics | None = ...,
        batch_stats: collections.abc.Iterable[global___InferBatchStatistics] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["inference_stats", b"inference_stats"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["batch_stats", b"batch_stats", "execution_count", b"execution_count", "inference_count", b"inference_count", "inference_stats", b"inference_stats", "last_inference", b"last_inference", "name", b"name", "version", b"version"]) -> None: ...

global___ModelStatistics = ModelStatistics

class ModelStatisticsResponse(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ModelStatisticsResponse
    @@
    @@   Response message for ModelStatistics.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_STATS_FIELD_NUMBER: builtins.int
    @property
    def model_stats(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelStatistics]:
        """@@  .. cpp:var:: ModelStatistics model_stats (repeated)
        @@
        @@     Statistics for each requested model.
        @@
        """
    def __init__(
        self,
        *,
        model_stats: collections.abc.Iterable[global___ModelStatistics] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_stats", b"model_stats"]) -> None: ...

global___ModelStatisticsResponse = ModelStatisticsResponse

class ModelRepositoryParameter(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message ModelRepositoryParameter
    @@
    @@   An model repository parameter value.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BOOL_PARAM_FIELD_NUMBER: builtins.int
    INT64_PARAM_FIELD_NUMBER: builtins.int
    STRING_PARAM_FIELD_NUMBER: builtins.int
    BYTES_PARAM_FIELD_NUMBER: builtins.int
    bool_param: builtins.bool
    """@@    .. cpp:var:: bool bool_param
    @@
    @@       A boolean parameter value.
    @@
    """
    int64_param: builtins.int
    """@@    .. cpp:var:: int64 int64_param
    @@
    @@       An int64 parameter value.
    @@
    """
    string_param: builtins.str
    """@@    .. cpp:var:: string string_param
    @@
    @@       A string parameter value.
    @@
    """
    bytes_param: builtins.bytes
    """@@    .. cpp:var:: bytes bytes_param
    @@
    @@       A bytes parameter value.
    @@
    """
    def __init__(
        self,
        *,
        bool_param: builtins.bool = ...,
        int64_param: builtins.int = ...,
        string_param: builtins.str = ...,
        bytes_param: builtins.bytes = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["bool_param", b"bool_param", "bytes_param", b"bytes_param", "int64_param", b"int64_param", "parameter_choice", b"parameter_choice", "string_param", b"string_param"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["bool_param", b"bool_param", "bytes_param", b"bytes_param", "int64_param", b"int64_param", "parameter_choice", b"parameter_choice", "string_param", b"string_param"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["parameter_choice", b"parameter_choice"]) -> typing_extensions.Literal["bool_param", "int64_param", "string_param", "bytes_param"] | None: ...

global___ModelRepositoryParameter = ModelRepositoryParameter

class RepositoryIndexRequest(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message RepositoryIndexRequest
    @@
    @@   Request message for RepositoryIndex.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REPOSITORY_NAME_FIELD_NUMBER: builtins.int
    READY_FIELD_NUMBER: builtins.int
    repository_name: builtins.str
    """@@  .. cpp:var:: string repository_name
    @@
    @@     The name of the repository. If empty the index is returned
    @@     for all repositories.
    @@
    """
    ready: builtins.bool
    """@@  .. cpp:var:: bool ready
    @@
    @@     If true returned only models currently ready for inferencing.
    @@
    """
    def __init__(
        self,
        *,
        repository_name: builtins.str = ...,
        ready: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["ready", b"ready", "repository_name", b"repository_name"]) -> None: ...

global___RepositoryIndexRequest = RepositoryIndexRequest

class RepositoryIndexResponse(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message RepositoryIndexResponse
    @@
    @@   Response message for RepositoryIndex.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class ModelIndex(google.protobuf.message.Message):
        """@@
        @@  .. cpp:var:: message ModelIndex
        @@
        @@     Index entry for a model.
        @@
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        VERSION_FIELD_NUMBER: builtins.int
        STATE_FIELD_NUMBER: builtins.int
        REASON_FIELD_NUMBER: builtins.int
        name: builtins.str
        """@@
        @@    .. cpp:var:: string name
        @@
        @@       The name of the model.
        @@
        """
        version: builtins.str
        """@@    .. cpp:var:: string version
        @@
        @@       The version of the model.
        @@
        """
        state: builtins.str
        """@@
        @@    .. cpp:var:: string state
        @@
        @@       The state of the model.
        @@
        """
        reason: builtins.str
        """@@
        @@    .. cpp:var:: string reason
        @@
        @@       The reason, if any, that the model is in the given state.
        @@
        """
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            version: builtins.str = ...,
            state: builtins.str = ...,
            reason: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "reason", b"reason", "state", b"state", "version", b"version"]) -> None: ...

    MODELS_FIELD_NUMBER: builtins.int
    @property
    def models(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RepositoryIndexResponse.ModelIndex]:
        """@@
        @@  .. cpp:var:: ModelIndex models (repeated)
        @@
        @@     An index entry for each model.
        @@
        """
    def __init__(
        self,
        *,
        models: collections.abc.Iterable[global___RepositoryIndexResponse.ModelIndex] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["models", b"models"]) -> None: ...

global___RepositoryIndexResponse = RepositoryIndexResponse

class RepositoryModelLoadRequest(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message RepositoryModelLoadRequest
    @@
    @@   Request message for RepositoryModelLoad.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class ParametersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___ModelRepositoryParameter: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___ModelRepositoryParameter | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    REPOSITORY_NAME_FIELD_NUMBER: builtins.int
    MODEL_NAME_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    repository_name: builtins.str
    """@@  .. cpp:var:: string repository_name
    @@
    @@     The name of the repository to load from. If empty the model
    @@     is loaded from any repository.
    @@
    """
    model_name: builtins.str
    """@@  .. cpp:var:: string repository_name
    @@
    @@     The name of the model to load, or reload.
    @@
    """
    @property
    def parameters(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___ModelRepositoryParameter]:
        """@@  .. cpp:var:: map<string,ModelRepositoryParameter> parameters
        @@
        @@     Optional model repository request parameters.
        @@
        """
    def __init__(
        self,
        *,
        repository_name: builtins.str = ...,
        model_name: builtins.str = ...,
        parameters: collections.abc.Mapping[builtins.str, global___ModelRepositoryParameter] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_name", b"model_name", "parameters", b"parameters", "repository_name", b"repository_name"]) -> None: ...

global___RepositoryModelLoadRequest = RepositoryModelLoadRequest

class RepositoryModelLoadResponse(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message RepositoryModelLoadResponse
    @@
    @@   Response message for RepositoryModelLoad.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___RepositoryModelLoadResponse = RepositoryModelLoadResponse

class RepositoryModelUnloadRequest(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message RepositoryModelUnloadRequest
    @@
    @@   Request message for RepositoryModelUnload.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class ParametersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___ModelRepositoryParameter: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___ModelRepositoryParameter | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    REPOSITORY_NAME_FIELD_NUMBER: builtins.int
    MODEL_NAME_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    repository_name: builtins.str
    """@@  .. cpp:var:: string repository_name
    @@
    @@     The name of the repository from which the model was originally
    @@     loaded. If empty the repository is not considered.
    @@
    """
    model_name: builtins.str
    """@@  .. cpp:var:: string repository_name
    @@
    @@     The name of the model to unload.
    @@
    """
    @property
    def parameters(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___ModelRepositoryParameter]:
        """@@  .. cpp:var:: map<string,ModelRepositoryParameter> parameters
        @@
        @@     Optional model repository request parameters.
        @@
        """
    def __init__(
        self,
        *,
        repository_name: builtins.str = ...,
        model_name: builtins.str = ...,
        parameters: collections.abc.Mapping[builtins.str, global___ModelRepositoryParameter] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_name", b"model_name", "parameters", b"parameters", "repository_name", b"repository_name"]) -> None: ...

global___RepositoryModelUnloadRequest = RepositoryModelUnloadRequest

class RepositoryModelUnloadResponse(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message RepositoryModelUnloadResponse
    @@
    @@   Response message for RepositoryModelUnload.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___RepositoryModelUnloadResponse = RepositoryModelUnloadResponse

class SystemSharedMemoryStatusRequest(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message SystemSharedMemoryStatusRequest
    @@
    @@   Request message for SystemSharedMemoryStatus.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """@@
    @@  .. cpp:var:: string name
    @@
    @@     The name of the region to get status for. If empty the
    @@     status is returned for all registered regions.
    @@
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___SystemSharedMemoryStatusRequest = SystemSharedMemoryStatusRequest

class SystemSharedMemoryStatusResponse(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message SystemSharedMemoryStatusResponse
    @@
    @@   Response message for SystemSharedMemoryStatus.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class RegionStatus(google.protobuf.message.Message):
        """@@
        @@  .. cpp:var:: message RegionStatus
        @@
        @@     Status for a shared memory region.
        @@
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        KEY_FIELD_NUMBER: builtins.int
        OFFSET_FIELD_NUMBER: builtins.int
        BYTE_SIZE_FIELD_NUMBER: builtins.int
        name: builtins.str
        """@@
        @@    .. cpp:var:: string name
        @@
        @@       The name for the shared memory region.
        @@
        """
        key: builtins.str
        """@@    .. cpp:var:: string shared_memory_key
        @@
        @@       The key of the underlying memory object that contains the
        @@       shared memory region.
        @@
        """
        offset: builtins.int
        """@@    .. cpp:var:: uint64 offset
        @@
        @@       Offset, in bytes, within the underlying memory object to
        @@       the start of the shared memory region.
        @@
        """
        byte_size: builtins.int
        """@@    .. cpp:var:: uint64 byte_size
        @@
        @@       Size of the shared memory region, in bytes.
        @@
        """
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            key: builtins.str = ...,
            offset: builtins.int = ...,
            byte_size: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["byte_size", b"byte_size", "key", b"key", "name", b"name", "offset", b"offset"]) -> None: ...

    class RegionsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___SystemSharedMemoryStatusResponse.RegionStatus: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___SystemSharedMemoryStatusResponse.RegionStatus | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    REGIONS_FIELD_NUMBER: builtins.int
    @property
    def regions(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___SystemSharedMemoryStatusResponse.RegionStatus]:
        """@@
        @@  .. cpp:var:: map<string,RegionStatus> regions
        @@
        @@     Status for each of the registered regions, indexed by
        @@     region name.
        @@
        """
    def __init__(
        self,
        *,
        regions: collections.abc.Mapping[builtins.str, global___SystemSharedMemoryStatusResponse.RegionStatus] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["regions", b"regions"]) -> None: ...

global___SystemSharedMemoryStatusResponse = SystemSharedMemoryStatusResponse

class SystemSharedMemoryRegisterRequest(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message SystemSharedMemoryRegisterRequest
    @@
    @@   Request message for SystemSharedMemoryRegister.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    KEY_FIELD_NUMBER: builtins.int
    OFFSET_FIELD_NUMBER: builtins.int
    BYTE_SIZE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """@@
    @@  .. cpp:var:: string name
    @@
    @@     The name of the region to register.
    @@
    """
    key: builtins.str
    """@@  .. cpp:var:: string shared_memory_key
    @@
    @@     The key of the underlying memory object that contains the
    @@     shared memory region.
    @@
    """
    offset: builtins.int
    """@@  .. cpp:var:: uint64 offset
    @@
    @@     Offset, in bytes, within the underlying memory object to
    @@     the start of the shared memory region.
    @@
    """
    byte_size: builtins.int
    """@@  .. cpp:var:: uint64 byte_size
    @@
    @@     Size of the shared memory region, in bytes.
    @@
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        key: builtins.str = ...,
        offset: builtins.int = ...,
        byte_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["byte_size", b"byte_size", "key", b"key", "name", b"name", "offset", b"offset"]) -> None: ...

global___SystemSharedMemoryRegisterRequest = SystemSharedMemoryRegisterRequest

class SystemSharedMemoryRegisterResponse(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message SystemSharedMemoryRegisterResponse
    @@
    @@   Response message for SystemSharedMemoryRegister.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___SystemSharedMemoryRegisterResponse = SystemSharedMemoryRegisterResponse

class SystemSharedMemoryUnregisterRequest(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message SystemSharedMemoryUnregisterRequest
    @@
    @@   Request message for SystemSharedMemoryUnregister.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """@@
    @@  .. cpp:var:: string name
    @@
    @@     The name of the system region to unregister. If empty
    @@     all system shared-memory regions are unregistered.
    @@
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___SystemSharedMemoryUnregisterRequest = SystemSharedMemoryUnregisterRequest

class SystemSharedMemoryUnregisterResponse(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message SystemSharedMemoryUnregisterResponse
    @@
    @@   Response message for SystemSharedMemoryUnregister.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___SystemSharedMemoryUnregisterResponse = SystemSharedMemoryUnregisterResponse

class CudaSharedMemoryStatusRequest(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message CudaSharedMemoryStatusRequest
    @@
    @@   Request message for CudaSharedMemoryStatus.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """@@
    @@  .. cpp:var:: string name
    @@
    @@     The name of the region to get status for. If empty the
    @@     status is returned for all registered regions.
    @@
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___CudaSharedMemoryStatusRequest = CudaSharedMemoryStatusRequest

class CudaSharedMemoryStatusResponse(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message CudaSharedMemoryStatusResponse
    @@
    @@   Response message for CudaSharedMemoryStatus.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class RegionStatus(google.protobuf.message.Message):
        """@@
        @@  .. cpp:var:: message RegionStatus
        @@
        @@     Status for a shared memory region.
        @@
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        DEVICE_ID_FIELD_NUMBER: builtins.int
        BYTE_SIZE_FIELD_NUMBER: builtins.int
        name: builtins.str
        """@@
        @@    .. cpp:var:: string name
        @@
        @@       The name for the shared memory region.
        @@
        """
        device_id: builtins.int
        """@@    .. cpp:var:: uin64 device_id
        @@
        @@       The GPU device ID where the cudaIPC handle was created.
        @@
        """
        byte_size: builtins.int
        """@@    .. cpp:var:: uint64 byte_size
        @@
        @@       Size of the shared memory region, in bytes.
        @@
        """
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            device_id: builtins.int = ...,
            byte_size: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["byte_size", b"byte_size", "device_id", b"device_id", "name", b"name"]) -> None: ...

    class RegionsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___CudaSharedMemoryStatusResponse.RegionStatus: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___CudaSharedMemoryStatusResponse.RegionStatus | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    REGIONS_FIELD_NUMBER: builtins.int
    @property
    def regions(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___CudaSharedMemoryStatusResponse.RegionStatus]:
        """@@
        @@  .. cpp:var:: map<string,RegionStatus> regions
        @@
        @@     Status for each of the registered regions, indexed by
        @@     region name.
        @@
        """
    def __init__(
        self,
        *,
        regions: collections.abc.Mapping[builtins.str, global___CudaSharedMemoryStatusResponse.RegionStatus] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["regions", b"regions"]) -> None: ...

global___CudaSharedMemoryStatusResponse = CudaSharedMemoryStatusResponse

class CudaSharedMemoryRegisterRequest(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message CudaSharedMemoryRegisterRequest
    @@
    @@   Request message for CudaSharedMemoryRegister.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    RAW_HANDLE_FIELD_NUMBER: builtins.int
    DEVICE_ID_FIELD_NUMBER: builtins.int
    BYTE_SIZE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """@@
    @@  .. cpp:var:: string name
    @@
    @@     The name of the region to register.
    @@
    """
    raw_handle: builtins.bytes
    """@@  .. cpp:var:: bytes raw_handle
    @@
    @@     The raw serialized cudaIPC handle.
    @@
    """
    device_id: builtins.int
    """@@  .. cpp:var:: int64 device_id
    @@
    @@     The GPU device ID on which the cudaIPC handle was created.
    @@
    """
    byte_size: builtins.int
    """@@  .. cpp:var:: uint64 byte_size
    @@
    @@     Size of the shared memory block, in bytes.
    @@
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        raw_handle: builtins.bytes = ...,
        device_id: builtins.int = ...,
        byte_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["byte_size", b"byte_size", "device_id", b"device_id", "name", b"name", "raw_handle", b"raw_handle"]) -> None: ...

global___CudaSharedMemoryRegisterRequest = CudaSharedMemoryRegisterRequest

class CudaSharedMemoryRegisterResponse(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message CudaSharedMemoryRegisterResponse
    @@
    @@   Response message for CudaSharedMemoryRegister.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___CudaSharedMemoryRegisterResponse = CudaSharedMemoryRegisterResponse

class CudaSharedMemoryUnregisterRequest(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message CudaSharedMemoryUnregisterRequest
    @@
    @@   Request message for CudaSharedMemoryUnregister.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """@@
    @@  .. cpp:var:: string name
    @@
    @@     The name of the cuda region to unregister. If empty
    @@     all cuda shared-memory regions are unregistered.
    @@
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___CudaSharedMemoryUnregisterRequest = CudaSharedMemoryUnregisterRequest

class CudaSharedMemoryUnregisterResponse(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message CudaSharedMemoryUnregisterResponse
    @@
    @@   Response message for CudaSharedMemoryUnregister.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___CudaSharedMemoryUnregisterResponse = CudaSharedMemoryUnregisterResponse

class TraceSettingRequest(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message TraceSettingRequest
    @@
    @@   Request message for TraceSetting.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class SettingValue(google.protobuf.message.Message):
        """@@
        @@  .. cpp:var:: message SettingValue
        @@
        @@     The values to be associated with a trace setting.
        @@     If no value is provided, the setting will be clear and
        @@     the global setting value will be used.
        @@
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        VALUE_FIELD_NUMBER: builtins.int
        @property
        def value(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """@@
            @@    .. cpp:var:: string value (repeated)
            @@
            @@       The value.
            @@
            """
        def __init__(
            self,
            *,
            value: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["value", b"value"]) -> None: ...

    class SettingsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___TraceSettingRequest.SettingValue: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___TraceSettingRequest.SettingValue | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    SETTINGS_FIELD_NUMBER: builtins.int
    MODEL_NAME_FIELD_NUMBER: builtins.int
    @property
    def settings(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___TraceSettingRequest.SettingValue]:
        """@@  .. cpp:var:: map<string,SettingValue> settings
        @@
        @@     The new setting values to be updated,
        @@     settings that are not specified will remain unchanged.
        @@
        """
    model_name: builtins.str
    """@@
    @@  .. cpp:var:: string model_name
    @@
    @@     The name of the model to apply the new trace settings.
    @@     If not given, the new settings will be applied globally.
    @@
    """
    def __init__(
        self,
        *,
        settings: collections.abc.Mapping[builtins.str, global___TraceSettingRequest.SettingValue] | None = ...,
        model_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_name", b"model_name", "settings", b"settings"]) -> None: ...

global___TraceSettingRequest = TraceSettingRequest

class TraceSettingResponse(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message TraceSettingResponse
    @@
    @@   Response message for TraceSetting.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class SettingValue(google.protobuf.message.Message):
        """@@
        @@  .. cpp:var:: message SettingValue
        @@
        @@     The values to be associated with a trace setting.
        @@
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        VALUE_FIELD_NUMBER: builtins.int
        @property
        def value(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """@@
            @@    .. cpp:var:: string value (repeated)
            @@
            @@       The value.
            @@
            """
        def __init__(
            self,
            *,
            value: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["value", b"value"]) -> None: ...

    class SettingsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___TraceSettingResponse.SettingValue: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___TraceSettingResponse.SettingValue | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    SETTINGS_FIELD_NUMBER: builtins.int
    @property
    def settings(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___TraceSettingResponse.SettingValue]:
        """@@  .. cpp:var:: map<string,SettingValue> settings
        @@
        @@     The current trace settings, including any changes specified
        @@     by TraceSettingRequest.
        @@
        """
    def __init__(
        self,
        *,
        settings: collections.abc.Mapping[builtins.str, global___TraceSettingResponse.SettingValue] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["settings", b"settings"]) -> None: ...

global___TraceSettingResponse = TraceSettingResponse

class LogSettingsRequest(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message LogSettingsRequest
    @@
    @@   Request message for LogSettings.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class SettingValue(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        BOOL_PARAM_FIELD_NUMBER: builtins.int
        UINT32_PARAM_FIELD_NUMBER: builtins.int
        STRING_PARAM_FIELD_NUMBER: builtins.int
        bool_param: builtins.bool
        """@@    .. cpp:var:: bool bool_param
        @@
        @@       A boolean parameter value.
        @@
        """
        uint32_param: builtins.int
        """@@    .. cpp:var:: uint32 uint32_param
        @@
        @@       An uint32 parameter value.
        @@
        """
        string_param: builtins.str
        """@@    .. cpp:var:: string string_param
        @@
        @@       A string parameter value.
        @@
        """
        def __init__(
            self,
            *,
            bool_param: builtins.bool = ...,
            uint32_param: builtins.int = ...,
            string_param: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["bool_param", b"bool_param", "parameter_choice", b"parameter_choice", "string_param", b"string_param", "uint32_param", b"uint32_param"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["bool_param", b"bool_param", "parameter_choice", b"parameter_choice", "string_param", b"string_param", "uint32_param", b"uint32_param"]) -> None: ...
        def WhichOneof(self, oneof_group: typing_extensions.Literal["parameter_choice", b"parameter_choice"]) -> typing_extensions.Literal["bool_param", "uint32_param", "string_param"] | None: ...

    class SettingsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___LogSettingsRequest.SettingValue: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___LogSettingsRequest.SettingValue | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    SETTINGS_FIELD_NUMBER: builtins.int
    @property
    def settings(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___LogSettingsRequest.SettingValue]:
        """@@  .. cpp:var:: map<string,SettingValue> settings
        @@
        @@     The current log settings.
        @@
        """
    def __init__(
        self,
        *,
        settings: collections.abc.Mapping[builtins.str, global___LogSettingsRequest.SettingValue] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["settings", b"settings"]) -> None: ...

global___LogSettingsRequest = LogSettingsRequest

class LogSettingsResponse(google.protobuf.message.Message):
    """@@
    @@.. cpp:var:: message LogSettingsResponse
    @@
    @@   Response message for LogSettings.
    @@
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class SettingValue(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        BOOL_PARAM_FIELD_NUMBER: builtins.int
        UINT32_PARAM_FIELD_NUMBER: builtins.int
        STRING_PARAM_FIELD_NUMBER: builtins.int
        bool_param: builtins.bool
        """@@    .. cpp:var:: bool bool_param
        @@
        @@       A boolean parameter value.
        @@
        """
        uint32_param: builtins.int
        """@@    .. cpp:var:: uint32 uint32_param
        @@
        @@       An int32 parameter value.
        @@
        """
        string_param: builtins.str
        """@@    .. cpp:var:: string string_param
        @@
        @@       A string parameter value.
        @@
        """
        def __init__(
            self,
            *,
            bool_param: builtins.bool = ...,
            uint32_param: builtins.int = ...,
            string_param: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["bool_param", b"bool_param", "parameter_choice", b"parameter_choice", "string_param", b"string_param", "uint32_param", b"uint32_param"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["bool_param", b"bool_param", "parameter_choice", b"parameter_choice", "string_param", b"string_param", "uint32_param", b"uint32_param"]) -> None: ...
        def WhichOneof(self, oneof_group: typing_extensions.Literal["parameter_choice", b"parameter_choice"]) -> typing_extensions.Literal["bool_param", "uint32_param", "string_param"] | None: ...

    class SettingsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___LogSettingsResponse.SettingValue: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___LogSettingsResponse.SettingValue | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    SETTINGS_FIELD_NUMBER: builtins.int
    @property
    def settings(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___LogSettingsResponse.SettingValue]:
        """@@  .. cpp:var:: map<string,SettingValue> settings
        @@
        @@     The current log settings.
        @@
        """
    def __init__(
        self,
        *,
        settings: collections.abc.Mapping[builtins.str, global___LogSettingsResponse.SettingValue] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["settings", b"settings"]) -> None: ...

global___LogSettingsResponse = LogSettingsResponse
