"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2020-2023, NVIDIA CORPORATION & AFFILIATES. All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
 * Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
 * Neither the name of NVIDIA CORPORATION nor the names of its
   contributors may be used to endorse or promote products derived
   from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
"""
import abc
import collections.abc
import grpc
import service_pb2

class GRPCInferenceServiceStub:
    """@@
    @@.. cpp:var:: service InferenceService
    @@
    @@   Inference Server GRPC endpoints.
    @@
    """

    def __init__(self, channel: grpc.Channel) -> None: ...
    ServerLive: grpc.UnaryUnaryMultiCallable[
        service_pb2.ServerLiveRequest,
        service_pb2.ServerLiveResponse,
    ]
    """@@  .. cpp:var:: rpc ServerLive(ServerLiveRequest) returns
    @@       (ServerLiveResponse)
    @@
    @@     Check liveness of the inference server.
    @@
    """
    ServerReady: grpc.UnaryUnaryMultiCallable[
        service_pb2.ServerReadyRequest,
        service_pb2.ServerReadyResponse,
    ]
    """@@  .. cpp:var:: rpc ServerReady(ServerReadyRequest) returns
    @@       (ServerReadyResponse)
    @@
    @@     Check readiness of the inference server.
    @@
    """
    ModelReady: grpc.UnaryUnaryMultiCallable[
        service_pb2.ModelReadyRequest,
        service_pb2.ModelReadyResponse,
    ]
    """@@  .. cpp:var:: rpc ModelReady(ModelReadyRequest) returns
    @@       (ModelReadyResponse)
    @@
    @@     Check readiness of a model in the inference server.
    @@
    """
    ServerMetadata: grpc.UnaryUnaryMultiCallable[
        service_pb2.ServerMetadataRequest,
        service_pb2.ServerMetadataResponse,
    ]
    """@@  .. cpp:var:: rpc ServerMetadata(ServerMetadataRequest) returns
    @@       (ServerMetadataResponse)
    @@
    @@     Get server metadata.
    @@
    """
    ModelMetadata: grpc.UnaryUnaryMultiCallable[
        service_pb2.ModelMetadataRequest,
        service_pb2.ModelMetadataResponse,
    ]
    """@@  .. cpp:var:: rpc ModelMetadata(ModelMetadataRequest) returns
    @@       (ModelMetadataResponse)
    @@
    @@     Get model metadata.
    @@
    """
    ModelInfer: grpc.UnaryUnaryMultiCallable[
        service_pb2.ModelInferRequest,
        service_pb2.ModelInferResponse,
    ]
    """@@  .. cpp:var:: rpc ModelInfer(ModelInferRequest) returns
    @@       (ModelInferResponse)
    @@
    @@     Perform inference using a specific model.
    @@
    """
    ModelStreamInfer: grpc.StreamStreamMultiCallable[
        service_pb2.ModelInferRequest,
        service_pb2.ModelStreamInferResponse,
    ]
    """@@  .. cpp:var:: rpc ModelStreamInfer(stream ModelInferRequest) returns
    @@       (stream ModelStreamInferResponse)
    @@
    @@     Perform streaming inference.
    @@
    """
    ModelConfig: grpc.UnaryUnaryMultiCallable[
        service_pb2.ModelConfigRequest,
        service_pb2.ModelConfigResponse,
    ]
    """@@  .. cpp:var:: rpc ModelConfig(ModelConfigRequest) returns
    @@       (ModelConfigResponse)
    @@
    @@     Get model configuration.
    @@
    """
    ModelStatistics: grpc.UnaryUnaryMultiCallable[
        service_pb2.ModelStatisticsRequest,
        service_pb2.ModelStatisticsResponse,
    ]
    """@@  .. cpp:var:: rpc ModelStatistics(
    @@                     ModelStatisticsRequest)
    @@                   returns (ModelStatisticsResponse)
    @@
    @@     Get the cumulative inference statistics for a model.
    @@
    """
    RepositoryIndex: grpc.UnaryUnaryMultiCallable[
        service_pb2.RepositoryIndexRequest,
        service_pb2.RepositoryIndexResponse,
    ]
    """@@  .. cpp:var:: rpc RepositoryIndex(RepositoryIndexRequest) returns
    @@       (RepositoryIndexResponse)
    @@
    @@     Get the index of model repository contents.
    @@
    """
    RepositoryModelLoad: grpc.UnaryUnaryMultiCallable[
        service_pb2.RepositoryModelLoadRequest,
        service_pb2.RepositoryModelLoadResponse,
    ]
    """@@  .. cpp:var:: rpc RepositoryModelLoad(RepositoryModelLoadRequest) returns
    @@       (RepositoryModelLoadResponse)
    @@
    @@     Load or reload a model from a repository.
    @@
    """
    RepositoryModelUnload: grpc.UnaryUnaryMultiCallable[
        service_pb2.RepositoryModelUnloadRequest,
        service_pb2.RepositoryModelUnloadResponse,
    ]
    """@@  .. cpp:var:: rpc RepositoryModelUnload(RepositoryModelUnloadRequest)
    @@       returns (RepositoryModelUnloadResponse)
    @@
    @@     Unload a model.
    @@
    """
    SystemSharedMemoryStatus: grpc.UnaryUnaryMultiCallable[
        service_pb2.SystemSharedMemoryStatusRequest,
        service_pb2.SystemSharedMemoryStatusResponse,
    ]
    """@@  .. cpp:var:: rpc SystemSharedMemoryStatus(
    @@                     SystemSharedMemoryStatusRequest)
    @@                   returns (SystemSharedMemoryStatusRespose)
    @@
    @@     Get the status of all registered system-shared-memory regions.
    @@
    """
    SystemSharedMemoryRegister: grpc.UnaryUnaryMultiCallable[
        service_pb2.SystemSharedMemoryRegisterRequest,
        service_pb2.SystemSharedMemoryRegisterResponse,
    ]
    """@@  .. cpp:var:: rpc SystemSharedMemoryRegister(
    @@                     SystemSharedMemoryRegisterRequest)
    @@                   returns (SystemSharedMemoryRegisterResponse)
    @@
    @@     Register a system-shared-memory region.
    @@
    """
    SystemSharedMemoryUnregister: grpc.UnaryUnaryMultiCallable[
        service_pb2.SystemSharedMemoryUnregisterRequest,
        service_pb2.SystemSharedMemoryUnregisterResponse,
    ]
    """@@  .. cpp:var:: rpc SystemSharedMemoryUnregister(
    @@                     SystemSharedMemoryUnregisterRequest)
    @@                   returns (SystemSharedMemoryUnregisterResponse)
    @@
    @@     Unregister a system-shared-memory region.
    @@
    """
    CudaSharedMemoryStatus: grpc.UnaryUnaryMultiCallable[
        service_pb2.CudaSharedMemoryStatusRequest,
        service_pb2.CudaSharedMemoryStatusResponse,
    ]
    """@@  .. cpp:var:: rpc CudaSharedMemoryStatus(
    @@                     CudaSharedMemoryStatusRequest)
    @@                   returns (CudaSharedMemoryStatusRespose)
    @@
    @@     Get the status of all registered CUDA-shared-memory regions.
    @@
    """
    CudaSharedMemoryRegister: grpc.UnaryUnaryMultiCallable[
        service_pb2.CudaSharedMemoryRegisterRequest,
        service_pb2.CudaSharedMemoryRegisterResponse,
    ]
    """@@  .. cpp:var:: rpc CudaSharedMemoryRegister(
    @@                     CudaSharedMemoryRegisterRequest)
    @@                   returns (CudaSharedMemoryRegisterResponse)
    @@
    @@     Register a CUDA-shared-memory region.
    @@
    """
    CudaSharedMemoryUnregister: grpc.UnaryUnaryMultiCallable[
        service_pb2.CudaSharedMemoryUnregisterRequest,
        service_pb2.CudaSharedMemoryUnregisterResponse,
    ]
    """@@  .. cpp:var:: rpc CudaSharedMemoryUnregister(
    @@                     CudaSharedMemoryUnregisterRequest)
    @@                   returns (CudaSharedMemoryUnregisterResponse)
    @@
    @@     Unregister a CUDA-shared-memory region.
    @@
    """
    TraceSetting: grpc.UnaryUnaryMultiCallable[
        service_pb2.TraceSettingRequest,
        service_pb2.TraceSettingResponse,
    ]
    """@@  .. cpp:var:: rpc TraceSetting(TraceSettingRequest)
    @@                   returns (TraceSettingResponse)
    @@
    @@     Update and get the trace setting of the Triton server.
    @@
    """
    LogSettings: grpc.UnaryUnaryMultiCallable[
        service_pb2.LogSettingsRequest,
        service_pb2.LogSettingsResponse,
    ]
    """@@  .. cpp:var:: rpc LogSettings(LogSettingsRequest)
    @@                   returns (LogSettingsResponse)
    @@
    @@     Update and get the log settings of the Triton server.
    @@
    """

class GRPCInferenceServiceServicer(metaclass=abc.ABCMeta):
    """@@
    @@.. cpp:var:: service InferenceService
    @@
    @@   Inference Server GRPC endpoints.
    @@
    """

    @abc.abstractmethod
    def ServerLive(
        self,
        request: service_pb2.ServerLiveRequest,
        context: grpc.ServicerContext,
    ) -> service_pb2.ServerLiveResponse:
        """@@  .. cpp:var:: rpc ServerLive(ServerLiveRequest) returns
        @@       (ServerLiveResponse)
        @@
        @@     Check liveness of the inference server.
        @@
        """
    @abc.abstractmethod
    def ServerReady(
        self,
        request: service_pb2.ServerReadyRequest,
        context: grpc.ServicerContext,
    ) -> service_pb2.ServerReadyResponse:
        """@@  .. cpp:var:: rpc ServerReady(ServerReadyRequest) returns
        @@       (ServerReadyResponse)
        @@
        @@     Check readiness of the inference server.
        @@
        """
    @abc.abstractmethod
    def ModelReady(
        self,
        request: service_pb2.ModelReadyRequest,
        context: grpc.ServicerContext,
    ) -> service_pb2.ModelReadyResponse:
        """@@  .. cpp:var:: rpc ModelReady(ModelReadyRequest) returns
        @@       (ModelReadyResponse)
        @@
        @@     Check readiness of a model in the inference server.
        @@
        """
    @abc.abstractmethod
    def ServerMetadata(
        self,
        request: service_pb2.ServerMetadataRequest,
        context: grpc.ServicerContext,
    ) -> service_pb2.ServerMetadataResponse:
        """@@  .. cpp:var:: rpc ServerMetadata(ServerMetadataRequest) returns
        @@       (ServerMetadataResponse)
        @@
        @@     Get server metadata.
        @@
        """
    @abc.abstractmethod
    def ModelMetadata(
        self,
        request: service_pb2.ModelMetadataRequest,
        context: grpc.ServicerContext,
    ) -> service_pb2.ModelMetadataResponse:
        """@@  .. cpp:var:: rpc ModelMetadata(ModelMetadataRequest) returns
        @@       (ModelMetadataResponse)
        @@
        @@     Get model metadata.
        @@
        """
    @abc.abstractmethod
    def ModelInfer(
        self,
        request: service_pb2.ModelInferRequest,
        context: grpc.ServicerContext,
    ) -> service_pb2.ModelInferResponse:
        """@@  .. cpp:var:: rpc ModelInfer(ModelInferRequest) returns
        @@       (ModelInferResponse)
        @@
        @@     Perform inference using a specific model.
        @@
        """
    @abc.abstractmethod
    def ModelStreamInfer(
        self,
        request_iterator: collections.abc.Iterator[service_pb2.ModelInferRequest],
        context: grpc.ServicerContext,
    ) -> collections.abc.Iterator[service_pb2.ModelStreamInferResponse]:
        """@@  .. cpp:var:: rpc ModelStreamInfer(stream ModelInferRequest) returns
        @@       (stream ModelStreamInferResponse)
        @@
        @@     Perform streaming inference.
        @@
        """
    @abc.abstractmethod
    def ModelConfig(
        self,
        request: service_pb2.ModelConfigRequest,
        context: grpc.ServicerContext,
    ) -> service_pb2.ModelConfigResponse:
        """@@  .. cpp:var:: rpc ModelConfig(ModelConfigRequest) returns
        @@       (ModelConfigResponse)
        @@
        @@     Get model configuration.
        @@
        """
    @abc.abstractmethod
    def ModelStatistics(
        self,
        request: service_pb2.ModelStatisticsRequest,
        context: grpc.ServicerContext,
    ) -> service_pb2.ModelStatisticsResponse:
        """@@  .. cpp:var:: rpc ModelStatistics(
        @@                     ModelStatisticsRequest)
        @@                   returns (ModelStatisticsResponse)
        @@
        @@     Get the cumulative inference statistics for a model.
        @@
        """
    @abc.abstractmethod
    def RepositoryIndex(
        self,
        request: service_pb2.RepositoryIndexRequest,
        context: grpc.ServicerContext,
    ) -> service_pb2.RepositoryIndexResponse:
        """@@  .. cpp:var:: rpc RepositoryIndex(RepositoryIndexRequest) returns
        @@       (RepositoryIndexResponse)
        @@
        @@     Get the index of model repository contents.
        @@
        """
    @abc.abstractmethod
    def RepositoryModelLoad(
        self,
        request: service_pb2.RepositoryModelLoadRequest,
        context: grpc.ServicerContext,
    ) -> service_pb2.RepositoryModelLoadResponse:
        """@@  .. cpp:var:: rpc RepositoryModelLoad(RepositoryModelLoadRequest) returns
        @@       (RepositoryModelLoadResponse)
        @@
        @@     Load or reload a model from a repository.
        @@
        """
    @abc.abstractmethod
    def RepositoryModelUnload(
        self,
        request: service_pb2.RepositoryModelUnloadRequest,
        context: grpc.ServicerContext,
    ) -> service_pb2.RepositoryModelUnloadResponse:
        """@@  .. cpp:var:: rpc RepositoryModelUnload(RepositoryModelUnloadRequest)
        @@       returns (RepositoryModelUnloadResponse)
        @@
        @@     Unload a model.
        @@
        """
    @abc.abstractmethod
    def SystemSharedMemoryStatus(
        self,
        request: service_pb2.SystemSharedMemoryStatusRequest,
        context: grpc.ServicerContext,
    ) -> service_pb2.SystemSharedMemoryStatusResponse:
        """@@  .. cpp:var:: rpc SystemSharedMemoryStatus(
        @@                     SystemSharedMemoryStatusRequest)
        @@                   returns (SystemSharedMemoryStatusRespose)
        @@
        @@     Get the status of all registered system-shared-memory regions.
        @@
        """
    @abc.abstractmethod
    def SystemSharedMemoryRegister(
        self,
        request: service_pb2.SystemSharedMemoryRegisterRequest,
        context: grpc.ServicerContext,
    ) -> service_pb2.SystemSharedMemoryRegisterResponse:
        """@@  .. cpp:var:: rpc SystemSharedMemoryRegister(
        @@                     SystemSharedMemoryRegisterRequest)
        @@                   returns (SystemSharedMemoryRegisterResponse)
        @@
        @@     Register a system-shared-memory region.
        @@
        """
    @abc.abstractmethod
    def SystemSharedMemoryUnregister(
        self,
        request: service_pb2.SystemSharedMemoryUnregisterRequest,
        context: grpc.ServicerContext,
    ) -> service_pb2.SystemSharedMemoryUnregisterResponse:
        """@@  .. cpp:var:: rpc SystemSharedMemoryUnregister(
        @@                     SystemSharedMemoryUnregisterRequest)
        @@                   returns (SystemSharedMemoryUnregisterResponse)
        @@
        @@     Unregister a system-shared-memory region.
        @@
        """
    @abc.abstractmethod
    def CudaSharedMemoryStatus(
        self,
        request: service_pb2.CudaSharedMemoryStatusRequest,
        context: grpc.ServicerContext,
    ) -> service_pb2.CudaSharedMemoryStatusResponse:
        """@@  .. cpp:var:: rpc CudaSharedMemoryStatus(
        @@                     CudaSharedMemoryStatusRequest)
        @@                   returns (CudaSharedMemoryStatusRespose)
        @@
        @@     Get the status of all registered CUDA-shared-memory regions.
        @@
        """
    @abc.abstractmethod
    def CudaSharedMemoryRegister(
        self,
        request: service_pb2.CudaSharedMemoryRegisterRequest,
        context: grpc.ServicerContext,
    ) -> service_pb2.CudaSharedMemoryRegisterResponse:
        """@@  .. cpp:var:: rpc CudaSharedMemoryRegister(
        @@                     CudaSharedMemoryRegisterRequest)
        @@                   returns (CudaSharedMemoryRegisterResponse)
        @@
        @@     Register a CUDA-shared-memory region.
        @@
        """
    @abc.abstractmethod
    def CudaSharedMemoryUnregister(
        self,
        request: service_pb2.CudaSharedMemoryUnregisterRequest,
        context: grpc.ServicerContext,
    ) -> service_pb2.CudaSharedMemoryUnregisterResponse:
        """@@  .. cpp:var:: rpc CudaSharedMemoryUnregister(
        @@                     CudaSharedMemoryUnregisterRequest)
        @@                   returns (CudaSharedMemoryUnregisterResponse)
        @@
        @@     Unregister a CUDA-shared-memory region.
        @@
        """
    @abc.abstractmethod
    def TraceSetting(
        self,
        request: service_pb2.TraceSettingRequest,
        context: grpc.ServicerContext,
    ) -> service_pb2.TraceSettingResponse:
        """@@  .. cpp:var:: rpc TraceSetting(TraceSettingRequest)
        @@                   returns (TraceSettingResponse)
        @@
        @@     Update and get the trace setting of the Triton server.
        @@
        """
    @abc.abstractmethod
    def LogSettings(
        self,
        request: service_pb2.LogSettingsRequest,
        context: grpc.ServicerContext,
    ) -> service_pb2.LogSettingsResponse:
        """@@  .. cpp:var:: rpc LogSettings(LogSettingsRequest)
        @@                   returns (LogSettingsResponse)
        @@
        @@     Update and get the log settings of the Triton server.
        @@
        """

def add_GRPCInferenceServiceServicer_to_server(servicer: GRPCInferenceServiceServicer, server: grpc.Server) -> None: ...
