# Licensed under the Apache License, Version 2.0 (the "License");
#    you may not use this file except in compliance with the License.
#    You may obtain a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS,
#    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#    See the License for the specific language governing permissions and
#    limitations under the License.

"""add annotations to container

Revision ID: df87dbd4846c
Revises: d502ce8fb705
Create Date: 2019-12-21 16:47:11.503444

"""

# revision identifiers, used by Alembic.
revision = 'df87dbd4846c'
down_revision = 'd502ce8fb705'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa


def MediumText():
    return sa.Text().with_variant(sa.dialects.mysql.MEDIUMTEXT(), 'mysql')


def upgrade():
    op.add_column('container',
                  sa.Column('annotations', MediumText(), nullable=True))
