# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['nornir_pyntc', 'nornir_pyntc.connections', 'nornir_pyntc.tasks']

package_data = \
{'': ['*']}

install_requires = \
['nornir>=3.2.0,<4.0.0', 'pyntc>=0.20.1,<0.21.0']

entry_points = \
{'console_scripts': ['nornir_pyntc = nornir_pyntc.cli:main'],
 'nornir.plugins.connections': ['pyntc = nornir_pyntc.connections:Pyntc']}

setup_kwargs = {
    'name': 'nornir-pyntc',
    'version': '1.0.0',
    'description': 'pyntc plugin for Nornir',
    'long_description': '# nornir-pyntc\n\nnornir-pyntc is a [Nornir Plugin](https://nornir.readthedocs.io/en/latest/plugins/index.html). It extends the main functionality that Nornir provides by adding a plugin wrapping around [pyntc](https://github.com/networktocode/pyntc) library. nornir-pyntc comes with a `connection` plugin and `task` definitions that can be used via the Nornir core library.\n\n## Installation\n\nnornir-pyntc is available as a Python package in PyPI and can be installed with pip:\n\nInitial install:\n\n```\npip install nornir-pyntc\n```\n\nTo upgrade:\n\n```\npip install nornir-pyntc --upgrade\n```\n\n## Supported Platforms\n\n- Cisco AireOS - uses netmiko (SSH)\n- Cisco ASA - uses netmiko (SSH)\n- Cisco IOS platforms - uses netmiko (SSH)\n- Cisco NX-OS - uses pynxos (NX-API)\n- Arista EOS - uses pyeapi (eAPI)\n- Juniper Junos - uses PyEz (NETCONF)\n- F5 Networks - uses f5-sdk (ReST)\n\n## Plugins\n\nNornir allows plugins to extend different functionality.\n\nThese include:\n- Connections\n- Tasks\n- Inventory\n- Processors\n- Runners\n\n`nornir-pyntc` is a collection of connection and tasks plugins.\n\n### Connections\n\n- `pyntc_connection` - Manages device connections.\n\n### Tasks\n\nThe plugin comes with tasks that expose the basic pyntc functionality.\n\n- [pyntc_config](https://github.com/networktocode/pyntc#config-commands) - Pass configuration commands to a network device.\n- [pyntc_file_copy](https://github.com/networktocode/pyntc#copying-files) - Copy a file to a network device.\n- [pyntc_install_os](https://github.com/networktocode/pyntc#installing-operating-systems) - Install an operating system.\n- [pyntc_reboot](https://github.com/networktocode/pyntc#reboot) - Reboot a network device.\n- [pyntc_save](https://github.com/networktocode/pyntc#save-configs) - Save the running configuration of a network device.\n- [pyntc_show](https://github.com/networktocode/pyntc#sending-show-commands) - Send a single `show` command to a network device.\n- [pyntc_show_list](https://github.com/networktocode/pyntc#sending-multiple-commands) - Send multiple `show` commands to a network device.\n\n\n## Basic Usage\n\nBelow examples demonstrate basic usage patterns for the plugin\'s connection and tasks.\n\n### Connection Examples\n\nThis example demonstrates how to use a manual connection handler. The code executes the `open_connection` and `close_connection` method calls manually.\n\n```python\n# Base import that is required to Initialize the core Nornir handler.\nfrom nornir import InitNornir\n\n# Specific nornir-pytnc imports.\n# Connection plugin import\nfrom nornir_pyntc.connections.pyntc_connection import Pyntc\n# Task plugin import for running show commands.\nfrom nornir_pyntc.tasks.pyntc_show import pyntc_show\n\n# Nornir utility function to print results in a simplified way.\nfrom nornir_utils.plugins.functions import print_result\n\nnr = InitNornir(config_file="config.yml")\n\ndef task_manages_connection_manually(task):\n    task.host.open_connection("pyntc", configuration=task.nornir.config)\n    result = nr.run(task=pyntc_show, command="show version")\n    task.host.close_connection("pyntc")\n\nmanual_result = nr.run(\n    task=task_manages_connection_manually,\n)\n\nprint_result(manual_result)\n\n```\n\nFor more details see the section on manual connection handling in the [Nornir Documentation](https://nornir.readthedocs.io/en/latest/howto/handling_connections.html#Manually).\n\n### Task Examples\n\nThis example illustrates how to use a task plugin and allow the task plugin to utilize the native nornir-pyntc connection:\n\n```python\n# Base import that is required to Initialize the core Nornir handler.\nfrom nornir import InitNornir\n\n# Specific nornir-pytnc imports.\n# Task plugin import for running show commands.\nfrom nornir_pyntc.tasks.pyntc_show import pyntc_show\n\n# Nornir utility function to print results in a simplified way.\nfrom nornir_utils.plugins.functions import print_result\n\nnr = InitNornir(config_file="config.yml")\n\nresult = nr.run(task=pyntc_show, command="show version")\n\nprint_result(result)\n```\n\n```raw\npyntc_show**********************************************************************\n* n5k1 ** changed : False ******************************************************\nvvvv pyntc_show ** changed : False vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv INFO\n{ \'bios_cmpl_time\': \'05/09/2012\',\n  \'bios_ver_str\': \'3.6.0\',\n  \'bootflash_size\': 2007040,\n  \'chassis_id\': \'Nexus5548 Chassis\',\n  \'cpu_name\': \'Intel(R) Xeon(R) CPU        \',\n  \'header_str\': \'Cisco Nexus Operating System (NX-OS) Software\\n\'\n                \'TAC support: http://www.cisco.com/tac\\n\'\n                \'Documents: \'\n                \'http://www.cisco.com/en/US/products/ps9372/tsd_products_support_series_home.html\\n\'\n                \'Copyright (c) 2002-2022, Cisco Systems, Inc. All rights \'\n                \'reserved.\\n\'\n                \'The copyrights to certain works contained herein are owned \'\n                \'by\\n\'\n                \'other third parties and are used and distributed under \'\n                \'license.\\n\'\n                \'Some parts of this software are covered under the GNU Public\\n\'\n                \'License. A copy of the license is available at\\n\'\n                \'http://www.gnu.org/licenses/gpl.html.\\n\',\n  \'host_name\': \'Nexus5K-1\',\n  \'isan_cmpl_time\': \' 2/8/2022 3:00:00\',\n  \'isan_file_name\': \'bootflash:///n5000-uk9.7.3.11.N1.1.bin\',\n  \'isan_tmstmp\': \'02/08/2022 14:26:50\',\n  \'kern_uptm_days\': 0,\n  \'kern_uptm_hrs\': 1,\n  \'kern_uptm_mins\': 3,\n  \'kern_uptm_secs\': 49,\n  \'kick_cmpl_time\': \' 2/8/2022 3:00:00\',\n  \'kick_file_name\': \'bootflash:///n5000-uk9-kickstart.7.3.11.N1.1.bin\',\n  \'kick_tmstmp\': \'02/08/2022 12:31:24\',\n  \'kickstart_ver_str\': \'7.3(11)N1(1)\',\n  \'mem_type\': \'kB\',\n  \'memory\': 8253792,\n  \'module_id\': \'O2 32X10GE/Modular Universal Platform Supervisor\',\n  \'power_seq_ver_str\': [ \'             Module 1: v3.0\',\n                         \'             Module 2: v2.0\',\n                         \'             Module not detected\',\n                         \'             Module not detected\'],\n  \'proc_board_id\': \'FOC190386H4\',\n  \'rr_ctime\': \' Tue Jan 26 14:22:12 2016\\n\',\n  \'rr_reason\': \'Reset due to upgrade\',\n  \'rr_service\': \'\',\n  \'rr_sys_ver\': \'7.3(8)N1(1)\',\n  \'rr_usecs\': 628308,\n  \'sys_ver_str\': \'7.3(11)N1(1)\',\n  \'ucontroller_ver_str\': \'v1.2.0.1\'}\n^^^^ END pyntc_show ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n* n5k2 ** changed : False ******************************************************\nvvvv pyntc_show ** changed : False vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv INFO\n{ \'bios_cmpl_time\': \'05/09/2012\',\n  \'bios_ver_str\': \'3.6.0\',\n  \'bootflash_size\': 2007040,\n  \'chassis_id\': \'Nexus5548 Chassis\',\n  \'cpu_name\': \'Intel(R) Xeon(R) CPU        \',\n  \'header_str\': \'Cisco Nexus Operating System (NX-OS) Software\\n\'\n                \'TAC support: http://www.cisco.com/tac\\n\'\n                \'Documents: \'\n                \'http://www.cisco.com/en/US/products/ps9372/tsd_products_support_series_home.html\\n\'\n                \'Copyright (c) 2002-2022, Cisco Systems, Inc. All rights \'\n                \'reserved.\\n\'\n                \'The copyrights to certain works contained herein are owned \'\n                \'by\\n\'\n                \'other third parties and are used and distributed under \'\n                \'license.\\n\'\n                \'Some parts of this software are covered under the GNU Public\\n\'\n                \'License. A copy of the license is available at\\n\'\n                \'http://www.gnu.org/licenses/gpl.html.\\n\',\n  \'host_name\': \'Nexus5K-2\',\n  \'isan_cmpl_time\': \' 2/8/2022 3:00:00\',\n  \'isan_file_name\': \'bootflash:///n5000-uk9.7.3.11.N1.1.bin\',\n  \'isan_tmstmp\': \'02/08/2022 14:26:50\',\n  \'kern_uptm_days\': 0,\n  \'kern_uptm_hrs\': 1,\n  \'kern_uptm_mins\': 37,\n  \'kern_uptm_secs\': 48,\n  \'kick_cmpl_time\': \' 2/8/2022 3:00:00\',\n  \'kick_file_name\': \'bootflash:///n5000-uk9-kickstart.7.3.11.N1.1.bin\',\n  \'kick_tmstmp\': \'02/08/2022 12:31:24\',\n  \'kickstart_ver_str\': \'7.3(11)N1(1)\',\n  \'mem_type\': \'kB\',\n  \'memory\': 8253792,\n  \'module_id\': \'O2 32X10GE/Modular Universal Platform Supervisor\',\n  \'power_seq_ver_str\': [ \'             Module 1: v3.0\',\n                         \'             Module 2: v2.0\',\n                         \'             Module not detected\',\n                         \'             Module not detected\'],\n  \'proc_board_id\': \'FOC190386H2\',\n  \'rr_ctime\': \' Tue Jan 26 14:33:19 2016\\n\',\n  \'rr_reason\': \'Reset due to upgrade\',\n  \'rr_service\': \'\',\n  \'rr_sys_ver\': \'7.3(8)N1(1)\',\n  \'rr_usecs\': 68494,\n  \'sys_ver_str\': \'7.3(11)N1(1)\',\n  \'ucontroller_ver_str\': \'v1.2.0.1\'}\n^^^^ END pyntc_show ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n```\n\n## Questions\n\nFor any questions or comments, please feel free to swing by the [networktocode slack channel](https://networktocode.slack.com).\n\nSign up [here](http://slack.networktocode.com/)\n',
    'author': 'Network to Code, LLC',
    'author_email': 'info@networktocode.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/networktocode-llc/nornir_pyntc',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
