"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getMethodsFromSchemaPath = exports.getSchemaPaths = void 0;
const props_1 = require("./props");
const getSchemaPaths = (schema) => {
    const paths = schema.get('paths');
    if (typeof paths === 'undefined')
        return undefined;
    return Object.keys(paths).reduce((acc, path) => {
        if (!path.startsWith('x-')) {
            return { ...acc, [path]: paths[path] };
        }
        return acc;
    }, {});
};
exports.getSchemaPaths = getSchemaPaths;
const getMethodsFromSchemaPath = (path) => Object.keys(path)
    .reduce((acc, pathKey) => {
    if (pathKey in props_1.HTTPMethod) {
        acc[pathKey] = path[pathKey];
    }
    return acc;
}, {});
exports.getMethodsFromSchemaPath = getMethodsFromSchemaPath;
//# sourceMappingURL=data:application/json;base64,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