"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CorsIntegration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigateway_1 = require("aws-cdk-lib/aws-apigateway");
const base_1 = require("./base");
const template = `
$input.json("$")
#set($domains = [__DOMAINS__])
#set($origin = $input.params("origin"))
#if($domains.size() == 1 && $domains[0] == "*")
#set($context.responseOverride.header.Access-Control-Allow-Origin="*")
#elseif($domains.contains($origin))
#set($context.responseOverride.header.Access-Control-Allow-Origin="$origin")
#end
`.trim();
/**
 * Defines `OPTIONS` integration used in Cross-Origin Resource Sharing (CORS).
 *
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-cors.html
 * @see https://medium.com/@srikanth650/use-api-gateway-with-mock-integration-to-allow-cors-from-multiple-origins-bdcb431d07d3
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/request-response-data-mappings.html#mapping-response-parameters
 */
class CorsIntegration extends base_1.Integration {
    /**
     * Defines `OPTIONS` integration used in Cross-Origin Resource Sharing (CORS).
     *
     * @example
     * '/bar': {
     *   'OPTIONS': new openapix.CorsIntegration(this, {
     *     headers: 'Content-Type,X-Amz-Date,Authorization',
     *     origins: '*',
     *     methods: 'OPTIONS,GET',
     *   }),
     * },
     */
    constructor(_, props) {
        const { headers, origins, methods } = props;
        const integration = {
            type: aws_apigateway_1.IntegrationType.MOCK,
            options: {
                requestTemplates: { 'application/json': '{"statusCode": 204}' },
                integrationResponses: [
                    {
                        statusCode: '204',
                        responseParameters: {
                            'method.response.header.Access-Control-Allow-Methods': methods,
                            'method.response.header.Access-Control-Allow-Headers': headers,
                        },
                        responseTemplates: {
                            'application/json': CorsIntegration.buildTemplate(origins),
                        },
                    },
                ],
            },
        };
        const config = {
            type: base_1.InternalIntegrationType.CORS,
            validator: props?.validator,
        };
        super(integration, config);
    }
    /** Build Apache Velocity (`.vtl`) template for CORS response. */
    static buildTemplate(origins) {
        const originsForTmpl = origins.split(',').map(o => `"${o}"`).join(',');
        const tmpl = template.replace('__DOMAINS__', originsForTmpl);
        return tmpl;
    }
}
exports.CorsIntegration = CorsIntegration;
_a = JSII_RTTI_SYMBOL_1;
CorsIntegration[_a] = { fqn: "@alma-cdk/openapix.CorsIntegration", version: "0.0.47" };
//# sourceMappingURL=data:application/json;base64,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