"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaIntegration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const apigateway = require("aws-cdk-lib/aws-apigateway");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const lambda_invocation_1 = require("../lambda-invocation");
const base_1 = require("./base");
/** Defines an AWS Lambda integration. */
class LambdaIntegration extends base_1.Integration {
    /**
     * Defines an AWS Lambda integration.
     *
     * @example
     * '/message': {
     *    'POST': new openapix.LambdaIntegration(this, fn),
     * },
     */
    constructor(scope, fn, props) {
        const lambdaInvocation = new lambda_invocation_1.LambdaInvocation(scope, fn);
        const integration = {
            type: LambdaIntegration.selectIntegrationType(props?.proxy),
            uri: lambdaInvocation.uri,
            integrationHttpMethod: 'POST',
            options: props,
        };
        const config = {
            type: base_1.InternalIntegrationType.LAMBDA,
            validator: props?.validator,
        };
        super(integration, config);
        this.fn = fn;
    }
    /**
     * Selects the Lambda integration type.
     *
     * @default
     * 'AWS_PROXY'
     */
    static selectIntegrationType(proxy) {
        if (proxy === false) {
            return apigateway.IntegrationType.AWS;
        }
        // default to proxy as CDK does
        return apigateway.IntegrationType.AWS_PROXY;
    }
    /** Allow Lambda invoke action to be performed by given identity. */
    grantFunctionInvoke(scope, id, principal) {
        /**
         * if the lambda functions are created in separate stacks, circular dependencies appear
         * when we grant function invoke permissions directly. This is a hacky way to avoid the issue
         */
        const fn = aws_lambda_1.Function.fromFunctionAttributes(scope, id, {
            functionArn: this.fn.functionArn,
            sameEnvironment: true,
        });
        fn.grantInvoke(principal);
    }
}
exports.LambdaIntegration = LambdaIntegration;
_a = JSII_RTTI_SYMBOL_1;
LambdaIntegration[_a] = { fqn: "@alma-cdk/openapix.LambdaIntegration", version: "0.0.47" };
//# sourceMappingURL=data:application/json;base64,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