<a id="mypy-boto3-transfer"></a>

# mypy-boto3-transfer

[![PyPI - mypy-boto3-transfer](https://img.shields.io/pypi/v/mypy-boto3-transfer.svg?color=blue)](https://pypi.org/project/mypy-boto3-transfer)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-transfer.svg?color=blue)](https://pypi.org/project/mypy-boto3-transfer)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-transfer?color=blue)](https://pypistats.org/packages/mypy-boto3-transfer)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.Transfer 1.19.9](https://boto3.amazonaws.com/v1/documentation/api/1.19.9/reference/services/transfer.html#Transfer)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 6.0.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-transfer docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_transfer/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-transfer](#mypy-boto3-transfer)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `Transfer` service.

```bash
python -m pip install boto3-stubs[transfer]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[transfer]` in your environment:
  `python -m pip install 'boto3-stubs[transfer]'`

Both type checking and auto-complete should work for `Transfer` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[transfer]` in your environment:
  `python -m pip install 'boto3-stubs[transfer]'`

Both type checking and auto-complete should work for `Transfer` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[transfer]` in your environment:
  `python -m pip install 'boto3-stubs[transfer]'`
- Run `mypy` as usual

Type checking should work for `Transfer` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[transfer]` in your environment:
  `python -m pip install 'boto3-stubs[transfer]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Transfer` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`TransferClient` provides annotations for `boto3.client("transfer")`.

```python
import boto3

from mypy_boto3_transfer import TransferClient

client: TransferClient = boto3.client("transfer")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: TransferClient = session.client("transfer")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_transfer.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_transfer import TransferClient
from mypy_boto3_transfer.paginator import (
    ListServersPaginator,
)

client: TransferClient = boto3.client("transfer")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_servers_paginator: ListServersPaginator = client.get_paginator("list_servers")
```

<a id="literals"></a>

### Literals

`mypy_boto3_transfer.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_transfer.literals import (
    CustomStepStatusType,
    DomainType,
    EndpointTypeType,
    ExecutionErrorTypeType,
    ExecutionStatusType,
    HomeDirectoryTypeType,
    IdentityProviderTypeType,
    ListServersPaginatorName,
    OverwriteExistingType,
    ProtocolType,
    StateType,
    WorkflowStepTypeType,
    ServiceName,
    PaginatorName,
)

def check_value(value: CustomStepStatusType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_transfer.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_transfer.type_defs import (
    CopyStepDetailsTypeDef,
    CreateAccessRequestRequestTypeDef,
    CreateAccessResponseTypeDef,
    CreateServerRequestRequestTypeDef,
    CreateServerResponseTypeDef,
    CreateUserRequestRequestTypeDef,
    CreateUserResponseTypeDef,
    CreateWorkflowRequestRequestTypeDef,
    CreateWorkflowResponseTypeDef,
    CustomStepDetailsTypeDef,
    DeleteAccessRequestRequestTypeDef,
    DeleteServerRequestRequestTypeDef,
    DeleteSshPublicKeyRequestRequestTypeDef,
    DeleteStepDetailsTypeDef,
    DeleteUserRequestRequestTypeDef,
    DeleteWorkflowRequestRequestTypeDef,
    DescribeAccessRequestRequestTypeDef,
    DescribeAccessResponseTypeDef,
    DescribeExecutionRequestRequestTypeDef,
    DescribeExecutionResponseTypeDef,
    DescribeSecurityPolicyRequestRequestTypeDef,
    DescribeSecurityPolicyResponseTypeDef,
    DescribeServerRequestRequestTypeDef,
    DescribeServerResponseTypeDef,
    DescribeUserRequestRequestTypeDef,
    DescribeUserResponseTypeDef,
    DescribeWorkflowRequestRequestTypeDef,
    DescribeWorkflowResponseTypeDef,
    DescribedAccessTypeDef,
    DescribedExecutionTypeDef,
    DescribedSecurityPolicyTypeDef,
    DescribedServerTypeDef,
    DescribedUserTypeDef,
    DescribedWorkflowTypeDef,
    EfsFileLocationTypeDef,
    EndpointDetailsTypeDef,
    ExecutionErrorTypeDef,
    ExecutionResultsTypeDef,
    ExecutionStepResultTypeDef,
    FileLocationTypeDef,
    HomeDirectoryMapEntryTypeDef,
    IdentityProviderDetailsTypeDef,
    ImportSshPublicKeyRequestRequestTypeDef,
    ImportSshPublicKeyResponseTypeDef,
    InputFileLocationTypeDef,
    ListAccessesRequestRequestTypeDef,
    ListAccessesResponseTypeDef,
    ListExecutionsRequestRequestTypeDef,
    ListExecutionsResponseTypeDef,
    ListSecurityPoliciesRequestRequestTypeDef,
    ListSecurityPoliciesResponseTypeDef,
    ListServersRequestRequestTypeDef,
    ListServersResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListUsersRequestRequestTypeDef,
    ListUsersResponseTypeDef,
    ListWorkflowsRequestRequestTypeDef,
    ListWorkflowsResponseTypeDef,
    ListedAccessTypeDef,
    ListedExecutionTypeDef,
    ListedServerTypeDef,
    ListedUserTypeDef,
    ListedWorkflowTypeDef,
    LoggingConfigurationTypeDef,
    PaginatorConfigTypeDef,
    PosixProfileTypeDef,
    ProtocolDetailsTypeDef,
    ResponseMetadataTypeDef,
    S3FileLocationTypeDef,
    S3InputFileLocationTypeDef,
    S3TagTypeDef,
    SendWorkflowStepStateRequestRequestTypeDef,
    ServiceMetadataTypeDef,
    SshPublicKeyTypeDef,
    StartServerRequestRequestTypeDef,
    StopServerRequestRequestTypeDef,
    TagResourceRequestRequestTypeDef,
    TagStepDetailsTypeDef,
    TagTypeDef,
    TestIdentityProviderRequestRequestTypeDef,
    TestIdentityProviderResponseTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateAccessRequestRequestTypeDef,
    UpdateAccessResponseTypeDef,
    UpdateServerRequestRequestTypeDef,
    UpdateServerResponseTypeDef,
    UpdateUserRequestRequestTypeDef,
    UpdateUserResponseTypeDef,
    UserDetailsTypeDef,
    WorkflowDetailTypeDef,
    WorkflowDetailsTypeDef,
    WorkflowStepTypeDef,
)

def get_structure() -> CopyStepDetailsTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-transfer` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-transfer docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_transfer/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
