---
layout: post
title: "curl"
date: 2021-01-17
author: "@vsoch"
annotate_criteria: https://rseng.github.io/software/repository/github/curl/curl/annotate-criteria/index.html
annotate_taxonomy: https://rseng.github.io/software/repository/github/curl/curl/annotate-taxonomy/index.html
categories:
- Software
---

One of the aims of the Research Software Encyclopedia is to bring attention to libraries
that we take for granted. The ones that easily come to mind are git and Linux, but today's
showcase honors another open source library that you've probably used and taken for granted - 
[curl](https://github.com/curl/curl)! Some might argue that this library is not
qualified to be called research software, but we could probably agree that is plays an
import role in the research ecosystem, which is why we want to showcase it today.

<br>

![{{ site.baseurl }}/assets/img/posts/showcase/curl.png]({{ site.baseurl }}/assets/img/posts/showcase/curl.png)

<br>

Are you already familiar with this software? We encourage you to contribute to the [research software encyclopedia](https://rseng.github.io/rse/tutorials/annotation/) and annotate the respository:

<ul>
<li><a href="{{ page.annotate_criteria }}" target="_blank">Annotate the software criteria</a></li>
<li><a href="{{ page.annotate_taxonomy }}" target="_blank">Annotate the software taxonomy</a></li>
</ul>

otherwise, keep reading!

<!--more--> 

 - [What is curl?](#what-is)
 - [How do I cite it?](#cite)
 - [How do I get started?](#getting-started)
 - [How do I contribute to the software survey](#contribute)
 - [Where can I learn more?](#learn-more)

<a id="what-is">
## What is curl?

If you've ever written any kind of shell script that interacts with a web resource
such as an API, you've very likely used curl. Curl is, by it's own definition on the GitHub
repository:

> A command line tool and library for transferring data with URL syntax, supporting DICT, FILE, FTP, FTPS, GOPHER, GOPHERS, HTTP, HTTPS, IMAP, IMAPS, LDAP, LDAPS, MQTT, POP3, POP3S, RTMP, RTMPS, RTSP, SCP, SFTP, SMB, SMBS, SMTP, SMTPS, TELNET and TFTP. libcurl offers a myriad of powerful features

Yes, holy cow, that is a lot of formats supported! You might call it the bread and butter of requests.
If I'm not using Python or some other higher level language to make a request, curl is my go-to tool.
And you can definitely look at the [man pages](https://curl.se/docs/manual.html) to see a wide variety of examples.
I use it most often for debugging the GitHub [Rest API](https://docs.github.com/en/rest/reference). For example, here is how I might
open a pull request from a particular `$BRANCH` for the Research Software Encyclopedia Software
database:

```bash
curl  -X POST  -H "Accept: application/vnd.github.v3+json"  -H "Authorization: token $GITHUB_TOKEN"  https://api.github.com/repos/rseng/software/pulls -d '{"head":"${BRANCH}", "base":"master", "body": "Fixes https://github.com/rseng/software/issues/160", "title": "Update from annotate/taxonomy-vsoch-2020-12-09/22-13-20"}'
```

In the above, we see that we are adding special headers (`-H`), and then providing an entire body of data to be parsed into some
kind of dictionary or hash with values. But this is just a simple example - curl can do so much more than standard `GET` and `POST`!
To really see it's influence, not just for research software but the entire open source ecosystem, just
search GitHub for curl. You'll see over 17K repositories, 23 million code snippets, and usage across
many different languages.

![{{ site.baseurl }}/assets/img/posts/showcase/curl-github.png]({{ site.baseurl }}/assets/img/posts/showcase/curl-github.png)

<br>

What does it take to maintain such a library? Check out [this post](https://daniel.haxx.se/blog/2021/01/15/food-on-the-table-while-giving-away-code/) 
written by the creator and (still) maintainer Daniel Stenberg, who started the code base as early as 1996 but really
established it in 1998. He tells a story of how he thought about licensing, copyright, and balancing development of
the library with sustaining his own livelihood. Given that it's been more than 2 decades and the project is going strong,
I highly recommend reading the post to learn some of his insights.


<a id="cite">
## How do I cite it?

Curl is exactly the kind of library that you would use and not think to cite in a paper.
Because of this, it's likely that citation (or providing a DOI) is not a priority for the authors.
Aside from GitHub releases and [the repository](https://github.com/curl/curl), I don't see 
any strong indication that there is a preference or way to easily cite it. If you know of one,
please [open an issue](https://github.com/rseng/rseng/issues)!

<a id="getting-started">
## How do I get started?
 
Curl is widely used enough so that there are many online resources! Here are a few:

 - [Freecodecamp Tutorial](https://www.freecodecamp.org/news/how-to-start-using-curl-and-why-a-hands-on-introduction-ea1c913caaaa/)
 - [Curl's Tutorial](https://curl.se/docs/httpscripting.html)
 - [GitHub](https://github.com/curl/curl)
 - [GeeksforGeeks](https://www.geeksforgeeks.org/curl-command-in-linux-with-examples/)

And another fun way to learn is just looking at [examples in the wild](https://github.com/search?l=Shell&q=curl&type=Code)!

<a id="contribute">
## How do I contribute to the software survey?

<ul>
  <li><a href="{{ page.annotate_criteria }}" target="_blank">Annotate the software criteria</a></li>
  <li><a href="{{ page.annotate_taxonomy }}" target="_blank">Annotate the software taxonomy</a></li>
</ul>

or read more about annotation [here]({{ site.baseurl }}/tutorials/annotate-your-software). You can clone the software repository to do
bulk annotation, or annotation any repository in the <a href="https://rseng.github.io/software/" target="_blank">software database</a>,
We want annotation to be fun, straight-forward, and easy, so we will be showcasing one repository to annotate per week.
If you'd like to request annotation of a particular repository (or addition to the software database)
please don't hesitate to [open an issue](https://github.com/rseng/software/issues) or even a pull request.

<a id="learn-more">
## Where can I learn more?

You might find these other resources useful:

 - [The Research Software Database](https://github.com/rseng/software) on GitHub
 - [RSEpedia Documentation](https://rseng.github.io/rse)
 - [Google Docs Manuscript](https://docs.google.com/document/d/1wDb0udH9OrFWrMBsAVb8RrUMCKKRHoyEep7yveJ1d0k/edit) you are invited to contribute to.
 - [Annotation Documentation for RSEpedia](https://rseng.github.io/rse/tutorials/annotation/)
 - [Annotation Tutorial in RSEng docs](https://rseng.github.io/rse/tutorials/annotation/)

For any resource, you are encouraged to give feedback and contribute!
