---
layout: post
title: "anTraX"
date: 2021-01-24
author: "@vsoch"
annotate_criteria: https://rseng.github.io/software/repository/github/Social-Evolution-and-Behavior/anTraX/annotate-criteria/index.html
annotate_taxonomy: https://rseng.github.io/software/repository/github/Social-Evolution-and-Behavior/anTraX/annotate-taxonomy/index.html
categories:
- Software
---

The software we want to share this week is really neat - here we present [Social-Evolution-and-Behavior/anTraX](https://github.com/Social-Evolution-and-Behavior/anTraX)!

<br>

<video width="640" height="480" controls>
  <source src="{{ site.baseurl }}/assets/img/posts/showcase/ants.mp4" type="video/mp4">
Your browser does not support the video tag.
</video> 

<br>

The image above comes directly from the [arXiv supplementary material](https://www.biorxiv.org/content/10.1101/2020.04.29.068478v1.supplementary-material) publication from the authors. You can probably guess from the above what the software does - we are tracking ants (or other
small friends) to better understand their movement or behavior.
Are you already familiar with this software? We encourage you to contribute to the [research software encyclopedia](https://rseng.github.io/rse/tutorials/annotation/) and annotate the respository:

<ul>
<li><a href="{{ page.annotate_criteria }}" target="_blank">Annotate the software criteria</a></li>
<li><a href="{{ page.annotate_taxonomy }}" target="_blank">Annotate the software taxonomy</a></li>
</ul>

otherwise, keep reading!

<!--more--> 

 - [What is anTraX?](#what-is)
 - [How do I cite it?](#cite)
 - [How do I get started?](#getting-started)
 - [How do I contribute to the software survey](#contribute)
 - [Where can I learn more?](#learn-more)

<a id="what-is">
## What is anTraX?

From the authors, anTraX is:

> high throughput tracking of color-tagged insects

It seems like the authors had ants (or other small insects) that were tagged with colored dots, and wanted
a simple approach to be able to track them. I'd imagine they are studying colony movement or behavior over multiple days,
and needed a good way to keep track of movement. The software works with Linux and (optionally) Matlab,
and even includes a [test dataset](https://antrax.readthedocs.io/en/latest/quickstart/) with the Getting Started
guide if you don't have your own ants and want to play around with it anyway.


<a id="cite">
## How do I cite it?

You can read the paper on [arXiv](https://www.biorxiv.org/content/10.1101/2020.04.29.068478v1) (and browse
to the figures section to see a whole set of cool videos like the one above!) or on [eLife](https://elifesciences.org/articles/58145).

```
@article {10.7554/eLife.58145,
article_type = {journal},
title = {anTraX, a software package for high-throughput video tracking of color-tagged insects},
author = {Gal, Asaf and Saragosti, Jonathan and Kronauer, Daniel JC},
editor = {Berman, Gordon J and Dulac, Catherine and Shaevitz, Joshua W and Perez-Escudero, Alfonso},
volume = 9,
year = 2020,
month = {nov},
pub_date = {2020-11-19},
pages = {e58145},
citation = {eLife 2020;9:e58145},
doi = {10.7554/eLife.58145},
url = {https://doi.org/10.7554/eLife.58145},
abstract = {Recent years have seen a surge in methods to track and analyze animal behavior. Nevertheless, tracking individuals in closely interacting, group-living organisms remains a challenge. Here, we present anTraX, an algorithm and software package for high-throughput video tracking of color-tagged insects. anTraX combines neural network classification of animals with a novel approach for representing tracking data as a graph, enabling individual tracking even in cases where it is difficult to segment animals from one another, or where tags are obscured. The use of color tags, a well-established and robust method for marking individual insects in groups, relaxes requirements for image size and quality, and makes the software broadly applicable. anTraX is readily integrated into existing tools and methods for automated image analysis of behavior to further augment its output. anTraX can handle large-scale experiments with minimal human involvement, allowing researchers to simultaneously monitor many social groups over long time periods.},
keywords = {ants, social insects, collective behavior, ethology, social behavior, formicidae, tracking, machine vision, machine learning},
journal = {eLife},
issn = {2050-084X},
publisher = {eLife Sciences Publications, Ltd},
}
```

<a id="getting-started">
## How do I get started?
 
There are many resources available for learning!

 - [The GitHub Repository](https://github.com/Social-Evolution-and-Behavior/anTraX) has source code and links
 - [Documentation](https://antrax.readthedocs.io/en/latest/quickstart/) on readthedocs
 - [ArXiv Paper](https://www.biorxiv.org/content/10.1101/2020.04.29.068478v1.supplementary-material) with great videos and examples as supplementary material
 - [eLife](https://elifesciences.org/articles/58145) is a more recent publication.


<a id="contribute">
## How do I contribute to the software survey?

<ul>
  <li><a href="{{ page.annotate_criteria }}" target="_blank">Annotate the software criteria</a></li>
  <li><a href="{{ page.annotate_taxonomy }}" target="_blank">Annotate the software taxonomy</a></li>
</ul>

or read more about annotation [here]({{ site.baseurl }}/tutorials/annotate-your-software). You can clone the software repository to do
bulk annotation, or annotation any repository in the <a href="https://rseng.github.io/software/" target="_blank">software database</a>,
We want annotation to be fun, straight-forward, and easy, so we will be showcasing one repository to annotate per week.
If you'd like to request annotation of a particular repository (or addition to the software database)
please don't hesitate to [open an issue](https://github.com/rseng/software/issues) or even a pull request.

<a id="learn-more">
## Where can I learn more?

You might find these other resources useful:

 - [The Research Software Database](https://github.com/rseng/software) on GitHub
 - [RSEpedia Documentation](https://rseng.github.io/rse)
 - [Google Docs Manuscript](https://docs.google.com/document/d/1wDb0udH9OrFWrMBsAVb8RrUMCKKRHoyEep7yveJ1d0k/edit) you are invited to contribute to.
 - [Annotation Documentation for RSEpedia](https://rseng.github.io/rse/tutorials/annotation/)
 - [Annotation Tutorial in RSEng docs](https://rseng.github.io/rse/tutorials/annotation/)

For any resource, you are encouraged to give feedback and contribute!
