---
layout: post
title: "3dfier"
date: 2021-01-24
author: "@vsoch"
annotate_criteria: https://rseng.github.io/software/repository/github/tudelft3d/3dfier/annotate-criteria/index.html
annotate_taxonomy: https://rseng.github.io/software/repository/github/tudelft3d/3dfier/annotate-taxonomy/index.html
categories:
- Software
---

In the world of research software, we have a strong expectation about the kinds of libraries that we might see.
There are many different kinds of tools for parsing datasets, or a domain specific utility, along with
statistical or other numerical tools. But when visualization is thrown into the mix, or using a data file in a way
that is surprising and unexpected? These are the kinds of repositories that are so different and unique that they capture
our attention we have to share it! This is exactly the case with the library for the software showcase this week - [tudelft3d/3dfier](https://github.com/tudelft3d/3dfier)!

<br>

<iframe src="https://player.vimeo.com/video/181421237" width="640" height="360" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen></iframe>
<p><a href="https://vimeo.com/181421237">Delft in 3D by TU Delft</a> from <a href="https://vimeo.com/user20388455">Filip Biljecki</a> on <a href="https://vimeo.com">Vimeo</a>.</p>

<br>

The quick video above can give you a sense of what this software is capable of doing - starting with basic maps and point clouds, and generating
a beautiful rendered 3D scene, which might be what you'd guess based on the name "3dfier." If you are already familiar with this software, we encourage you to contribute to the [research software encyclopedia](https://rseng.github.io/rse/tutorials/annotation/) and annotate the respository:

<ul>
<li><a href="{{ page.annotate_criteria }}" target="_blank">Annotate the software criteria</a></li>
<li><a href="{{ page.annotate_taxonomy }}" target="_blank">Annotate the software taxonomy</a></li>
</ul>

otherwise, keep reading!

<!--more--> 

 - [What is 3dfier?](#what-is)
 - [How do I cite it?](#cite)
 - [How do I get started?](#getting-started)
 - [How do I contribute to the software survey](#contribute)
 - [Where can I learn more?](#learn-more)

<a id="what-is">
## What is 3dfier?

3dfier is software developed by the 3D Geoinformation group at [TU Delft in the Netherlands](https://3d.bk.tudelft.nl/) that takes raw data files (a topographic map and lidar point cloud)
and helps to generate a 3D model of the environment. There are actually a [rich set](http://tudelft3d.github.io/3dfier/supported_file_formats.html) of allowed import formats, so you shouldn't be turned away from trying it if you aren't familar with these particular file types! Why would you want to do this? Well maybe you are a gamer and have a fantasty of easily converting your world into Minecraft (and I'm not familiar enough with Minecraft to know if this would work), but more realistically you want to generate a 3D environment to run simulations for the climate or other general environment. Generally speaking, you can define how you want the 3D-ification to occur by way of a [configuration file](https://github.com/tudelft3d/3dfier/blob/master/resources/config_files/myconfig.yml), and this generally includes mappings to classes for:

 - buildings
 - terrain
 - road
 - water
 - forest
 - bridge 
 - separations (like walls and fences)


A good place to start might be to browse [tutorials](http://tudelft3d.github.io/3dfier/generate_lod1.html) or [examples](http://tudelft3d.github.io/3dfier/minimal_data_requirements.html).

<a id="cite">
## How do I cite it?

It's highly recommended to read the paper on [Joss](https://joss.theoj.org/papers/10.21105/joss.02866) to get a better understand for the utility and use of this library.

```
@article{3dfier,
  author = {Ledoux, Hugo and Biljecki, Filip and Dukai, Balázs and Kumar, Kavisha and Peters, Ravi and Stoter, Jantien and Commandeur, Tom},
  doi = {10.21105/joss.02866},
  journal = {Journal of Open Source Software},
  number = {57},
  pages = {2866},
  title = {3dfier: automatic reconstruction of 3D city models},
  volume = {6},
  year = {2021}
}
```

<a id="getting-started">
## How do I get started?
 
You might want to check out:

 - [The GitHub Repository](https://github.com/tudelft3d/3dfier)
 - [Documentation](https://tudelft3d.github.io/3dfier) 
 - [ArXiv Paper](https://joss.theoj.org/papers/10.21105/joss.02866) 
 - [Tutorials](https://tudelft3d.github.io/3dfier/generate_lod1.html)
 - [Examples](https://tudelft3d.github.io/3dfier/minimal_data_requirements.html)



<a id="contribute">
## How do I contribute to the software survey?

<ul>
  <li><a href="{{ page.annotate_criteria }}" target="_blank">Annotate the software criteria</a></li>
  <li><a href="{{ page.annotate_taxonomy }}" target="_blank">Annotate the software taxonomy</a></li>
</ul>

or read more about annotation [here]({{ site.baseurl }}/tutorials/annotate-your-software). You can clone the software repository to do
bulk annotation, or annotation any repository in the <a href="https://rseng.github.io/software/" target="_blank">software database</a>,
We want annotation to be fun, straight-forward, and easy, so we will be showcasing one repository to annotate per week.
If you'd like to request annotation of a particular repository (or addition to the software database)
please don't hesitate to [open an issue](https://github.com/rseng/software/issues) or even a pull request.

<a id="learn-more">
## Where can I learn more?

You might find these other resources useful:

 - [The Research Software Database](https://github.com/rseng/software) on GitHub
 - [RSEpedia Documentation](https://rseng.github.io/rse)
 - [Google Docs Manuscript](https://docs.google.com/document/d/1wDb0udH9OrFWrMBsAVb8RrUMCKKRHoyEep7yveJ1d0k/edit) you are invited to contribute to.
 - [Annotation Documentation for RSEpedia](https://rseng.github.io/rse/tutorials/annotation/)
 - [Annotation Tutorial in RSEng docs](https://rseng.github.io/rse/tutorials/annotation/)

For any resource, you are encouraged to give feedback and contribute!
