---
layout: post
title: "podman"
date: 2021-03-07
author: "@vsoch"
annotate_criteria: https://rseng.github.io/software/repository/github/containers/podman/annotate-criteria/index.html
annotate_taxonomy: https://rseng.github.io/software/repository/github/containers/podman/annotate-taxonomy/index.html
categories:
- Software
---

This week for the RSEPedia showcase, we are highlighting another rootless container technology
that is empowering developers and researchers to use containerization, [podman!](https://github.com/containers/podman).
We also want to point out that this week is the [Container Plumbing Days](https://containerplumbing.org/)
conference, a free event where you can register and attend talks about everything from container building,
to security, and standards. Woohoo!

<br>

![{{ site.baseurl }}/assets/img/posts/showcase/podman.png]({{ site.baseurl }}/assets/img/posts/showcase/podman.png)

<br>

If you are already familiar with this software, we encourage you to contribute to the [research software encyclopedia](https://rseng.github.io/rse/tutorials/annotation/) and annotate the respository:

<ul>
<li><a href="{{ page.annotate_criteria }}" target="_blank">Annotate the software criteria</a></li>
<li><a href="{{ page.annotate_taxonomy }}" target="_blank">Annotate the software taxonomy</a></li>
</ul>

otherwise, keep reading!

<!--more--> 

 - [What is podman?](#what-is)
 - [How do I cite it?](#cite)
 - [How do I get started?](#getting-started)
 - [How do I contribute to the software survey](#contribute)
 - [Where can I learn more?](#learn-more)

<a id="what-is">
## What is podman?

You've probably heard of [Docker](https://docs.docker.com/get-started/), and if you are an academic that needs containers for
HPC, you've probably also heard of [Singularity](https://sylabs.io/guides/3.0/user-guide/quick_start.html). Podman is a sibling of this family,
a container technology that aims to be rootless, meaning you can run it in places (like high performance computing
clusters) where you don't have power to install anything. If you aren't familar with containers, then think
about it like packaging your entire operating system, libraries, and research software of interest into 
a package that you can share with your colleagues. They can run exactly what you ran again, as you intended it.
What does Podman look like? It actually is very familiar to docker. For example, if I'm using to using Docker like this:

```bash
$ docker build -t container .
$ docker run container echo noodles
```

I can use podman like this!

```bash
$ podman build -t container .
$ podman run container echo noodles
```

It's proudly OCI compliant, but wait, what the heck does that mean?

## The Open Container Initiative

OCI refers to the "[Open Container Initiative](https://opencontainers.org/)" and it's a governing body that works hard to 
ensure that when you build a container, pull a container from a registry, or otherwise interact with containers
in some respect, there are standards defined that designate how to do that. Why is this important?
It's important because we have a lot of developers and players in this container landscape, and if we don't
develop using common standards, it might not be possible, to (for example) push a Singularity container to an OCI
registry. We couldn't switch Podman for Docker and have it work. If you haven't heard of OCI, here is a nice
introductory video:

<iframe width="560" height="315" src="https://www.youtube.com/embed/cJp86kGOAQg" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

You can learn more about the projects [here](https://www.youtube.com/watch?v=r8ltmwWVuQs&t=0s),
and how to contribute [here](https://www.youtube.com/watch?v=vDXYDDeUIGQ).
As developers and research software engineers, we rely on these basic technologies to help
with reproducibility of our work. While containerization isn't the one all solution to this
problem, it's helped immensely. We should minimally have awareness about these technologies if we want
to be strong RSEs. We are featuring podman this week because the [Container Plumbing Days](https://containerplumbing.org/)
conference is this week (March 9-10th) and if you care about the future of some of these technologies,
you should attend any talks of interest.


<a id="cite">
## How do I cite it?

Podman doesn't have a citation proper, but we've opened an [issue to ask](https://github.com/containers/podman/issues/9654)!
For the time being, you likely can cite the repository or documentation site.


<a id="getting-started">
## How do I get started?
 
You might want to check out:

 - [The GitHub Repository](https://github.com/containers/podman)
 - [Documentation](http://docs.podman.io/en/latest/) 
 - [Getting Started Guide](https://podman.io/getting-started/)


<a id="contribute">
## How do I contribute to the software survey?

<ul>
  <li><a href="{{ page.annotate_criteria }}" target="_blank">Annotate the software criteria</a></li>
  <li><a href="{{ page.annotate_taxonomy }}" target="_blank">Annotate the software taxonomy</a></li>
</ul>

or read more about annotation [here]({{ site.baseurl }}/tutorials/annotate-your-software). You can clone the software repository to do
bulk annotation, or annotation any repository in the <a href="https://rseng.github.io/software/" target="_blank">software database</a>,
We want annotation to be fun, straight-forward, and easy, so we will be showcasing one repository to annotate per week.
If you'd like to request annotation of a particular repository (or addition to the software database)
please don't hesitate to [open an issue](https://github.com/rseng/software/issues) or even a pull request.

<a id="learn-more">
## Where can I learn more?

You might find these other resources useful:

 - [The Research Software Database](https://github.com/rseng/software) on GitHub
 - [RSEpedia Documentation](https://rseng.github.io/rse)
 - [Google Docs Manuscript](https://docs.google.com/document/d/1wDb0udH9OrFWrMBsAVb8RrUMCKKRHoyEep7yveJ1d0k/edit) you are invited to contribute to.
 - [Annotation Documentation for RSEpedia](https://rseng.github.io/rse/tutorials/annotation/)
 - [Annotation Tutorial in RSEng docs](https://rseng.github.io/rse/tutorials/annotation/)

For any resource, you are encouraged to give feedback and contribute!

