---
layout: post
title: "clingo"
date: 2021-03-21
author: "@vsoch"
annotate_criteria: https://rseng.github.io/software/repository/github/potassco/clingo/annotate-criteria/index.html
annotate_taxonomy: https://rseng.github.io/software/repository/github/potassco/clingo/annotate-taxonomy/index.html
categories:
- Software
---

When you use a package manager, how does it work? Or more generally, have you ever been interested in solvers?
This week we showcase [clingo](https://github.com/potassco/clingo), a grounder and solver for logic programs.
It's a fundamental tool to allow you to learn and do Answer Set Programming (ASP). If you are doing research
software engineering in the direction of innovating research software, this library will be of interest to you.
Why? Because we very likely can model existing methods with answer set programming to create new tools and ideas.

<br>

![{{ site.baseurl }}/assets/img/posts/showcase/clingo.png]({{ site.baseurl }}/assets/img/posts/showcase/clingo.png)

<br>

If you are already familiar with this software, we encourage you to contribute to the [research software encyclopedia](https://rseng.github.io/rse/tutorials/annotation/) and annotate the respository:

<ul>
<li><a href="{{ page.annotate_criteria }}" target="_blank">Annotate the software criteria</a></li>
<li><a href="{{ page.annotate_taxonomy }}" target="_blank">Annotate the software taxonomy</a></li>
</ul>

otherwise, keep reading!

<!--more--> 

 - [What is clingo?](#what-is)
 - [How do I cite it?](#cite)
 - [How do I get started?](#getting-started)
 - [How do I contribute to the software survey](#contribute)
 - [Where can I learn more?](#learn-more)

<a id="what-is">
## What is clingo?

Before we discuss clingo, we should briefly tell you about Answer Set Programming, or ASP.
From [this reference](https://www.cs.utexas.edu/users/vl/teaching/378/ASP.pdf), you'll learn that there
is a university in Germany, the [University of Potsdam](https://en.wikipedia.org/wiki/University_of_Potsdam), 
and they have a collection of tools for answer set programming. The set of tools is referred to
as "Potassco" (Potsdam Answer Set Solving Collection) and Clingo is one of these tools. From a very
high level standpoint, the developer can basically express combinatorial problems as logic programs (files with extension lp) that
define statements or facts (called atoms) and then a set of rules, and then we can ask Clingo to find
a stable model. While the details are out of scope for this post, you can [read more](https://www.cs.utexas.edu/users/vl/teaching/378/ASP.pdf)
in this fantastic reference, or the [getting started](https://potassco.org/doc/start/) page that also has
interactive examples. Also see the other links at the end of the post for more resources.

### A Dummy Example

For a quick dummy example, I decided to use the clingo container provided by
the [autamus registry](https://github.com/orgs/autamus/packages/container/package/clingo),
which is an effort championed by [alecbs](https://github.com/alecbcs/) to provide containers for spack packages.
Let's first pull the Clingo container so we have an interactive environment to work in.

```bash
$ docker run --rm -it ghcr.io/autamus/clingo:latest bash
```

Clingo will be installed via spack, and already on our path! It's installed in
what is called a [spack view](https://spack.readthedocs.io/en/latest/workflows.html#filesystem-views), if you are interested.

```bash
# which clingo
/opt/view/bin/clingo
```

Let's write a small logic program, which we will put in a file called `dinosaur.lp`.
It will help us determine if a living thing is a dinosaur. You can find this
in detail [here](https://github.com/vsoch/libabigail-python/tree/main/clingo).

```lp
% These are blanket facts, statements that each of these is living
% I think these are called atoms
living(vanessa).
living(fernando).
living(maria).

% This tells use size of arms for each living thing
armsize(vanessa, "small").
armsize(fernando, "large").
armsize(fernando, "small").

% A boolean to say we can roar!
canroar(vanessa).

% An entity is a dinosaur if they are living, have tiny arms, and can roar.
dinosaur(Entity) :- living(Entity), armsize(Entity, "small"), canroar(Entity).
```

I've saved the above into a file called [dinosaur.lp](https://github.com/vsoch/libabigail-python/blob/main/clingo/programs/dinosaur.lp). 
To look for a solution, we can run clingo:

```bash
# clingo dinosaur.lp 
clingo version 5.5.0
Reading from dinosaur.lp
Solving...
Answer: 1
canroar(vanessa) armsize(vanessa,"small") armsize(fernando,"large") armsize(fernando,"small") living(vanessa) living(fernando) living(maria) dinosaur(vanessa)
SATISFIABLE

Models       : 1
Calls        : 1
Time         : 0.003s (Solving: 0.00s 1st Model: 0.00s Unsat: 0.00s)
CPU Time     : 0.001s
```

We have concluded that vanessa is a dinosaur! Now this is a very simple, and silly
example. There are several more interesting use cases such as the [concretizer for spack](https://github.com/spack/spack/blob/develop/lib/spack/spack/solver/concretize.lp), and the examples and resources I'll link in this post.

<a id="cite">
## How do I cite it?

There are many [papers on clingo](https://scholar.google.com/scholar?hl=en&as_sdt=0%2C6&q=clingo&btnG=),
so we will include one here but you should do a search to find what is appropriate for your
use case. [This paper](https://www.cambridge.org/core/journals/theory-and-practice-of-logic-programming/article/abs/multishot-asp-solving-with-clingo/FAED3429900D84CDD5155326A36548F2) is from Theory and Practive of Logic Programming:

```
@article{gebser_kaminski_kaufmann_schaub_2019, title={Multi-shot ASP solving with clingo}, volume={19}, DOI={10.1017/S1471068418000054}, number={1}, journal={Theory and Practice of Logic Programming}, publisher={Cambridge University Press}, author={GEBSER, MARTIN and KAMINSKI, ROLAND and KAUFMANN, BENJAMIN and SCHAUB, TORSTEN}, year={2019}, pages={27–82}}
```

<a id="getting-started">
## How do I get started?
 
You might want to check out:

 - [The GitHub Repository](https://github.com/potassco/clingo)
 - [Documentation](https://github.com/potassco/guide/releases) 
 - [Clingo Page](https://potassco.org/clingo/)
 - [Getting Started Guide](https://potassco.org/doc/start/)


<a id="contribute">
## How do I contribute to the software survey?

<ul>
  <li><a href="{{ page.annotate_criteria }}" target="_blank">Annotate the software criteria</a></li>
  <li><a href="{{ page.annotate_taxonomy }}" target="_blank">Annotate the software taxonomy</a></li>
</ul>

or read more about annotation [here]({{ site.baseurl }}/tutorials/annotate-your-software). You can clone the software repository to do
bulk annotation, or annotation any repository in the <a href="https://rseng.github.io/software/" target="_blank">software database</a>,
We want annotation to be fun, straight-forward, and easy, so we will be showcasing one repository to annotate per week.
If you'd like to request annotation of a particular repository (or addition to the software database)
please don't hesitate to [open an issue](https://github.com/rseng/software/issues) or even a pull request.

<a id="learn-more">
## Where can I learn more?

You might find these other resources useful:

 - [The Research Software Database](https://github.com/rseng/software) on GitHub
 - [RSEpedia Documentation](https://rseng.github.io/rse)
 - [Google Docs Manuscript](https://docs.google.com/document/d/1wDb0udH9OrFWrMBsAVb8RrUMCKKRHoyEep7yveJ1d0k/edit) you are invited to contribute to.
 - [Annotation Documentation for RSEpedia](https://rseng.github.io/rse/tutorials/annotation/)
 - [Annotation Tutorial in RSEng docs](https://rseng.github.io/rse/tutorials/annotation/)

For any resource, you are encouraged to give feedback and contribute!

