# Generated by Django 2.2.9 on 2020-02-16 23:57

import django_dramatiq_pg.models
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='QueuedJob',
            fields=[
                ('message_id', models.UUIDField(primary_key=True, serialize=False)),
                ('queue_name', models.TextField(default='default')),
                ('state', models.TextField(choices=[('QUEUED', 'queued'), ('CONSUMED', 'consumed'), ('REJECTED', 'rejected'), ('DONE', 'done')], default=django_dramatiq_pg.models.State('queued'))),
                ('mtime', models.DateTimeField()),
                ('message', django.contrib.postgres.fields.jsonb.JSONField()),
                ('result', django.contrib.postgres.fields.jsonb.JSONField()),
                ('result_ttl', models.DateTimeField()),
            ],
            options={
                'db_table': 'queue',
                'managed': False,
            },
        ),
        migrations.RunSQL('''
CREATE SCHEMA dramatiq;

CREATE TYPE dramatiq."state" AS ENUM (
  'queued',
  'consumed',
  'rejected',
  'done'
);

CREATE TABLE dramatiq.queue(
  message_id uuid PRIMARY KEY,
  queue_name TEXT NOT NULL DEFAULT 'default',
  "state" dramatiq."state",
  mtime TIMESTAMP WITH TIME ZONE DEFAULT (NOW() AT TIME ZONE 'UTC'),
  -- message as encoded by dramatiq.
  message JSONB,
  "result" JSONB,
  result_ttl  TIMESTAMP WITH TIME ZONE
) WITHOUT OIDS;

-- Index state and mtime together to speed up deletion. This can also speed up
-- statistics when VACUUM ANALYZE is recent enough.
CREATE INDEX ON dramatiq.queue ("state", mtime);
CREATE INDEX ON dramatiq.queue ((message->>'actor_name'));
        '''),
    ]
