"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const events = require("@aws-cdk/aws-events");
const core_1 = require("@aws-cdk/core");
/**
 * Low-level class for generic CodePipeline Actions.
 *
 * WARNING: this class should not be externally exposed, but is currently visible
 * because of a limitation of jsii (https://github.com/aws/jsii/issues/524).
 *
 * This class will disappear in a future release and should not be used.
 *
 * @experimental
 */
class Action {
    constructor(actionProperties) {
        this.variableReferenced = false;
        this.customerProvidedNamespace = actionProperties.variablesNamespace;
        this.namespaceOrToken = core_1.Lazy.stringValue({ produce: () => {
                // make sure the action was bound (= added to a pipeline)
                if (this.actualNamespace !== undefined) {
                    return this.customerProvidedNamespace !== undefined
                        // if a customer passed a namespace explicitly, always use that
                        ? this.customerProvidedNamespace
                        // otherwise, only return a namespace if any variable was referenced
                        : (this.variableReferenced ? this.actualNamespace : undefined);
                }
                else {
                    throw new Error(`Cannot reference variables of action '${this.actionProperties.actionName}', ` +
                        'as that action was never added to a pipeline');
                }
            } });
        this.actionProperties = {
            ...actionProperties,
            variablesNamespace: this.namespaceOrToken,
        };
    }
    bind(scope, stage, options) {
        this._pipeline = stage.pipeline;
        this._stage = stage;
        this._scope = scope;
        this.actualNamespace = this.customerProvidedNamespace === undefined
            // default a namespace name, based on the stage and action names
            ? `${stage.stageName}_${this.actionProperties.actionName}_NS`
            : this.customerProvidedNamespace;
        return this.bound(scope, stage, options);
    }
    onStateChange(name, target, options) {
        const rule = new events.Rule(this.scope, name, options);
        rule.addTarget(target);
        rule.addEventPattern({
            detailType: ['CodePipeline Action Execution State Change'],
            source: ['aws.codepipeline'],
            resources: [this.pipeline.pipelineArn],
            detail: {
                stage: [this.stage.stageName],
                action: [this.actionProperties.actionName],
            },
        });
        return rule;
    }
    variableExpression(variableName) {
        this.variableReferenced = true;
        return `#{${this.namespaceOrToken}.${variableName}}`;
    }
    get pipeline() {
        if (this._pipeline) {
            return this._pipeline;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    get stage() {
        if (this._stage) {
            return this._stage;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    /**
     * Retrieves the Construct scope of this Action.
     * Only available after the Action has been added to a Stage,
     * and that Stage to a Pipeline.
     */
    get scope() {
        if (this._scope) {
            return this._scope;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline first');
        }
    }
}
exports.Action = Action;
//# sourceMappingURL=data:application/json;base64,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