# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from ._inputs import *

__all__ = ['MetabaseArgs', 'Metabase']

@pulumi.input_type
class MetabaseArgs:
    def __init__(__self__, *,
                 domain: Optional[pulumi.Input['CustomDomainArgs']] = None,
                 metabase_version: Optional[pulumi.Input[str]] = None,
                 networking: Optional[pulumi.Input['NetworkingArgs']] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Metabase resource.
        :param pulumi.Input['CustomDomainArgs'] domain: Optionally provide a hosted zone and domain name for the Metabase service.
        :param pulumi.Input[str] metabase_version: The version of Metabase to run - used as a tag on the `metabase/metabase` Dockerhub image.
        :param pulumi.Input['NetworkingArgs'] networking: Optionally provide specific subnet IDs to run the different resources of Metabase.
        :param pulumi.Input[str] vpc_id: The VPC to use for the Metabase service. If left blank then the default VPC will be used.
        """
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if metabase_version is not None:
            pulumi.set(__self__, "metabase_version", metabase_version)
        if networking is not None:
            pulumi.set(__self__, "networking", networking)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input['CustomDomainArgs']]:
        """
        Optionally provide a hosted zone and domain name for the Metabase service.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input['CustomDomainArgs']]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="metabaseVersion")
    def metabase_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of Metabase to run - used as a tag on the `metabase/metabase` Dockerhub image.
        """
        return pulumi.get(self, "metabase_version")

    @metabase_version.setter
    def metabase_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metabase_version", value)

    @property
    @pulumi.getter
    def networking(self) -> Optional[pulumi.Input['NetworkingArgs']]:
        """
        Optionally provide specific subnet IDs to run the different resources of Metabase.
        """
        return pulumi.get(self, "networking")

    @networking.setter
    def networking(self, value: Optional[pulumi.Input['NetworkingArgs']]):
        pulumi.set(self, "networking", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC to use for the Metabase service. If left blank then the default VPC will be used.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class Metabase(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain: Optional[pulumi.Input[pulumi.InputType['CustomDomainArgs']]] = None,
                 metabase_version: Optional[pulumi.Input[str]] = None,
                 networking: Optional[pulumi.Input[pulumi.InputType['NetworkingArgs']]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resources provisions a container running Metabase on AWS ECS Fargate. By default
        the resource will run the service in the AWS Account's Default VPC unless a VPC is defined. This
        resource will also deploy the `latest` version of Metabase unless a version is supplied.

        You can provide specific subnets to host the Load Balancer, Database, and ECS Service, as well
        as provide a custom domain name for the service.

        ## Example Usage
        ### Default

        ```python
        import pulumi
        import pulumi_metabase as metabase

        metabase_service = metabase.Metabase("metabaseService")
        pulumi.export("url", metabase_service.dns_name)
        ```
        {{ /example }}
        ### Custom Domain & Networking

        ```python
        import pulumi
        import pulumi_metabase as metabase

        metabase_service = metabase.Metabase("metabaseService",
            vpc_id="vpc-123",
            networking=metabase.NetworkingArgs(
                ecs_subnet_ids=[
                    "subnet-123",
                    "subnet-456",
                ],
                db_subnet_ids=[
                    "subnet-789",
                    "subnet-abc",
                ],
                lb_subnet_ids=[
                    "subnet-def",
                    "subnet-ghi",
                ],
            ),
            domain=metabase.CustomDomainArgs(
                hosted_zone_name="example.com",
                domain_name="metabase.example.com",
            ))
        pulumi.export("url", metabase_service.dns_name)
        ```
        {{ /example }}

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['CustomDomainArgs']] domain: Optionally provide a hosted zone and domain name for the Metabase service.
        :param pulumi.Input[str] metabase_version: The version of Metabase to run - used as a tag on the `metabase/metabase` Dockerhub image.
        :param pulumi.Input[pulumi.InputType['NetworkingArgs']] networking: Optionally provide specific subnet IDs to run the different resources of Metabase.
        :param pulumi.Input[str] vpc_id: The VPC to use for the Metabase service. If left blank then the default VPC will be used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[MetabaseArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resources provisions a container running Metabase on AWS ECS Fargate. By default
        the resource will run the service in the AWS Account's Default VPC unless a VPC is defined. This
        resource will also deploy the `latest` version of Metabase unless a version is supplied.

        You can provide specific subnets to host the Load Balancer, Database, and ECS Service, as well
        as provide a custom domain name for the service.

        ## Example Usage
        ### Default

        ```python
        import pulumi
        import pulumi_metabase as metabase

        metabase_service = metabase.Metabase("metabaseService")
        pulumi.export("url", metabase_service.dns_name)
        ```
        {{ /example }}
        ### Custom Domain & Networking

        ```python
        import pulumi
        import pulumi_metabase as metabase

        metabase_service = metabase.Metabase("metabaseService",
            vpc_id="vpc-123",
            networking=metabase.NetworkingArgs(
                ecs_subnet_ids=[
                    "subnet-123",
                    "subnet-456",
                ],
                db_subnet_ids=[
                    "subnet-789",
                    "subnet-abc",
                ],
                lb_subnet_ids=[
                    "subnet-def",
                    "subnet-ghi",
                ],
            ),
            domain=metabase.CustomDomainArgs(
                hosted_zone_name="example.com",
                domain_name="metabase.example.com",
            ))
        pulumi.export("url", metabase_service.dns_name)
        ```
        {{ /example }}

        :param str resource_name: The name of the resource.
        :param MetabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MetabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain: Optional[pulumi.Input[pulumi.InputType['CustomDomainArgs']]] = None,
                 metabase_version: Optional[pulumi.Input[str]] = None,
                 networking: Optional[pulumi.Input[pulumi.InputType['NetworkingArgs']]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MetabaseArgs.__new__(MetabaseArgs)

            __props__.__dict__["domain"] = domain
            __props__.__dict__["metabase_version"] = metabase_version
            __props__.__dict__["networking"] = networking
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["dns_name"] = None
            __props__.__dict__["security_group_id"] = None
        super(Metabase, __self__).__init__(
            'metabase:index:Metabase',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Output[str]:
        """
        The DNS name for the Metabase instance.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[str]:
        """
        The security group id for the Metabase instance.
        """
        return pulumi.get(self, "security_group_id")

