"""Broadworks OCI-P Interface Response Classes"""
# Autogenerated from the Broadworks XML Schemas.
# Do not edit as changes will be overwritten.
# Generated on 2020-10-19T17:35:53.953786
# fmt: off
from typing import List

from classforge import Field

import broadworks_ocip.types as OCI
from .base import ElementInfo as E
from .base import OCIResponse


class AuthenticationResponse(OCIResponse):
    """
    ``AuthenticationRequest()``/Response is 1st stage of the 2 stage OCI login process.


    Attributes:
        user_id: userId
        nonce: nonce
        password_algorithm: passwordAlgorithm
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("nonce", "nonce", str, is_required=True),
        E("password_algorithm", "passwordAlgorithm", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)
    nonce: str = Field(type=str, required=True, mutable=False)
    password_algorithm: str = Field(type=str, required=True, mutable=False)


class AuthenticationVerifyResponse(OCIResponse):
    """
    Response to ``AuthenticationVerifyRequest()``

    Replaced By: ``AuthenticationVerifyResponse14sp8()``

    Attributes:
        login_type: loginType
        locale: locale
        encoding: encoding
        group_id: groupId
        service_provider_id: serviceProviderId
        is_enterprise: isEnterprise
        password_expires_days: passwordExpiresDays
        user_domain: userDomain
        last_name: lastName
        first_name: firstName
    """

    _ELEMENTS = (
        E("login_type", "loginType", str, is_required=True),
        E("locale", "locale", str, is_required=True),
        E("encoding", "encoding", str, is_required=True),
        E("group_id", "groupId", str),
        E("service_provider_id", "serviceProviderId", str),
        E("is_enterprise", "isEnterprise", bool, is_required=True),
        E("password_expires_days", "passwordExpiresDays", int),
        E("user_domain", "userDomain", str, is_required=True),
        E("last_name", "lastName", str),
        E("first_name", "firstName", str),
    )

    login_type: str = Field(type=str, required=True, mutable=False)
    locale: str = Field(type=str, required=True, mutable=False)
    encoding: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=False, mutable=False)
    service_provider_id: str = Field(type=str, required=False, mutable=False)
    is_enterprise: bool = Field(type=bool, required=True, mutable=False)
    password_expires_days: int = Field(type=int, required=False, mutable=False)
    user_domain: str = Field(type=str, required=True, mutable=False)
    last_name: str = Field(type=str, required=False, mutable=False)
    first_name: str = Field(type=str, required=False, mutable=False)


class AuthenticationVerifyResponse14sp8(OCIResponse):
    """
    Response to ``AuthenticationVerifyRequest14sp8()`` If a phoneNumber is returned, it
    will be the primay DN of the user

    Attributes:
        login_type: loginType
        locale: locale
        encoding: encoding
        group_id: groupId
        service_provider_id: serviceProviderId
        is_enterprise: isEnterprise
        password_expires_days: passwordExpiresDays
        last_name: lastName
        first_name: firstName
        user_id: userId
        phone_number: phoneNumber
    """

    _ELEMENTS = (
        E("login_type", "loginType", str, is_required=True),
        E("locale", "locale", str, is_required=True),
        E("encoding", "encoding", str, is_required=True),
        E("group_id", "groupId", str),
        E("service_provider_id", "serviceProviderId", str),
        E("is_enterprise", "isEnterprise", bool, is_required=True),
        E("password_expires_days", "passwordExpiresDays", int),
        E("last_name", "lastName", str),
        E("first_name", "firstName", str),
        E("user_id", "userId", str, is_required=True),
        E("phone_number", "phoneNumber", str),
    )

    login_type: str = Field(type=str, required=True, mutable=False)
    locale: str = Field(type=str, required=True, mutable=False)
    encoding: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=False, mutable=False)
    service_provider_id: str = Field(type=str, required=False, mutable=False)
    is_enterprise: bool = Field(type=bool, required=True, mutable=False)
    password_expires_days: int = Field(type=int, required=False, mutable=False)
    last_name: str = Field(type=str, required=False, mutable=False)
    first_name: str = Field(type=str, required=False, mutable=False)
    user_id: str = Field(type=str, required=True, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)


class DeviceManagementFileAuthLocationGetResponse(OCIResponse):
    """
    Return the address and credentials of the File Repository hosting the requested access
    device file.

    Also return the file name and path on the File Repository.  This is a response to
    ``DeviceManagementFileAuthLocationGetRequest()``.

    Attributes:
        file_repository_user_name: fileRepositoryUserName
        file_repository_password: fileRepositoryPassword
        net_address: netAddress
        remote_file_format: remoteFileFormat
        port_number: portNumber
        root_directory: rootDirectory
        cpe_file_directory: cpeFileDirectory
        secure: secure
        mac_in_non_request_uri: macInNonRequestURI
        mac_format_in_non_request_uri: macFormatInNonRequestURI
        use_http_digest_authentication: useHttpDigestAuthentication
        mac_based_file_authentication: macBasedFileAuthentication
        user_name_password_file_authentication: userNamePasswordFileAuthentication
        completion_notification: completionNotification
        file_category: fileCategory
    """

    _ELEMENTS = (
        E("file_repository_user_name", "fileRepositoryUserName", str, is_required=True),
        E("file_repository_password", "fileRepositoryPassword", str, is_required=True),
        E("net_address", "netAddress", str, is_required=True),
        E("remote_file_format", "remoteFileFormat", str, is_required=True),
        E("port_number", "portNumber", int),
        E("root_directory", "rootDirectory", str),
        E("cpe_file_directory", "cpeFileDirectory", str),
        E("secure", "secure", bool),
        E("mac_in_non_request_uri", "macInNonRequestURI", bool),
        E("mac_format_in_non_request_uri", "macFormatInNonRequestURI", str),
        E("use_http_digest_authentication", "useHttpDigestAuthentication", bool),
        E("mac_based_file_authentication", "macBasedFileAuthentication", bool),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication", bool,
        ),
        E("completion_notification", "completionNotification", bool),
        E("file_category", "fileCategory", str),
    )

    file_repository_user_name: str = Field(type=str, required=True, mutable=False)
    file_repository_password: str = Field(type=str, required=True, mutable=False)
    net_address: str = Field(type=str, required=True, mutable=False)
    remote_file_format: str = Field(type=str, required=True, mutable=False)
    port_number: int = Field(type=int, required=False, mutable=False)
    root_directory: str = Field(type=str, required=False, mutable=False)
    cpe_file_directory: str = Field(type=str, required=False, mutable=False)
    secure: bool = Field(type=bool, required=False, mutable=False)
    mac_in_non_request_uri: bool = Field(type=bool, required=False, mutable=False)
    mac_format_in_non_request_uri: str = Field(type=str, required=False, mutable=False)
    use_http_digest_authentication: bool = Field(type=bool, required=False, mutable=False)
    mac_based_file_authentication: bool = Field(type=bool, required=False, mutable=False)
    user_name_password_file_authentication: bool = Field(
        type=bool, required=False, mutable=False,
    )
    completion_notification: bool = Field(type=bool, required=False, mutable=False)
    file_category: str = Field(type=str, required=False, mutable=False)


class DeviceManagementFileAuthLocationGetResponse17(OCIResponse):
    """
    Return the address and credentials of the File Repository hosting the requested access
    device file.

    Also return the file name and path on the File Repository.  This is a response to
    ``DeviceManagementFileAuthLocationGetRequest17()``. Replaced by:
    ``DeviceManagementFileAuthLocationGetRequest18()``

    Attributes:
        file_repository_user_name: fileRepositoryUserName
        file_repository_password: fileRepositoryPassword
        net_address: netAddress
        remote_file_format: remoteFileFormat
        port_number: portNumber
        root_directory: rootDirectory
        cpe_file_directory: cpeFileDirectory
        secure: secure
        mac_in_non_request_uri: macInNonRequestURI
        mac_format_in_non_request_uri: macFormatInNonRequestURI
        use_http_digest_authentication: useHttpDigestAuthentication
        mac_based_file_authentication: macBasedFileAuthentication
        user_name_password_file_authentication: userNamePasswordFileAuthentication
        completion_notification: completionNotification
        file_category: fileCategory
    """

    _ELEMENTS = (
        E("file_repository_user_name", "fileRepositoryUserName", str, is_required=True),
        E("file_repository_password", "fileRepositoryPassword", str, is_required=True),
        E("net_address", "netAddress", str, is_required=True),
        E("remote_file_format", "remoteFileFormat", str, is_required=True),
        E("port_number", "portNumber", int),
        E("root_directory", "rootDirectory", str),
        E("cpe_file_directory", "cpeFileDirectory", str),
        E("secure", "secure", bool),
        E("mac_in_non_request_uri", "macInNonRequestURI", bool),
        E("mac_format_in_non_request_uri", "macFormatInNonRequestURI", str),
        E("use_http_digest_authentication", "useHttpDigestAuthentication", bool),
        E("mac_based_file_authentication", "macBasedFileAuthentication", bool),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication", bool,
        ),
        E("completion_notification", "completionNotification", bool),
        E("file_category", "fileCategory", str),
    )

    file_repository_user_name: str = Field(type=str, required=True, mutable=False)
    file_repository_password: str = Field(type=str, required=True, mutable=False)
    net_address: str = Field(type=str, required=True, mutable=False)
    remote_file_format: str = Field(type=str, required=True, mutable=False)
    port_number: int = Field(type=int, required=False, mutable=False)
    root_directory: str = Field(type=str, required=False, mutable=False)
    cpe_file_directory: str = Field(type=str, required=False, mutable=False)
    secure: bool = Field(type=bool, required=False, mutable=False)
    mac_in_non_request_uri: bool = Field(type=bool, required=False, mutable=False)
    mac_format_in_non_request_uri: str = Field(type=str, required=False, mutable=False)
    use_http_digest_authentication: bool = Field(type=bool, required=False, mutable=False)
    mac_based_file_authentication: bool = Field(type=bool, required=False, mutable=False)
    user_name_password_file_authentication: bool = Field(
        type=bool, required=False, mutable=False,
    )
    completion_notification: bool = Field(type=bool, required=False, mutable=False)
    file_category: str = Field(type=str, required=False, mutable=False)


class DeviceManagementFileAuthLocationGetResponse18(OCIResponse):
    """
    Return the address and credentials of the File Repository hosting the requested access
    device file.

    Also return the file name and path on the File Repository.  This is a response to
    ``DeviceManagementFileAuthLocationGetRequest18()``. Replaced by:
    ``DeviceManagementFileAuthLocationGetResponse21()``.

    Attributes:
        file_repository_user_name: fileRepositoryUserName
        file_repository_password: fileRepositoryPassword
        net_address: netAddress
        remote_file_format: remoteFileFormat
        port_number: portNumber
        root_directory: rootDirectory
        cpe_file_directory: cpeFileDirectory
        secure: secure
        mac_in_non_request_uri: macInNonRequestURI
        mac_format_in_non_request_uri: macFormatInNonRequestURI
        use_http_digest_authentication: useHttpDigestAuthentication
        mac_based_file_authentication: macBasedFileAuthentication
        user_name_password_file_authentication: userNamePasswordFileAuthentication
        completion_notification: completionNotification
        file_category: fileCategory
        enable_caching: enableCaching
    """

    _ELEMENTS = (
        E("file_repository_user_name", "fileRepositoryUserName", str, is_required=True),
        E("file_repository_password", "fileRepositoryPassword", str, is_required=True),
        E("net_address", "netAddress", str, is_required=True),
        E("remote_file_format", "remoteFileFormat", str, is_required=True),
        E("port_number", "portNumber", int),
        E("root_directory", "rootDirectory", str),
        E("cpe_file_directory", "cpeFileDirectory", str),
        E("secure", "secure", bool),
        E("mac_in_non_request_uri", "macInNonRequestURI", bool),
        E("mac_format_in_non_request_uri", "macFormatInNonRequestURI", str),
        E("use_http_digest_authentication", "useHttpDigestAuthentication", bool),
        E("mac_based_file_authentication", "macBasedFileAuthentication", bool),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication", bool,
        ),
        E("completion_notification", "completionNotification", bool),
        E("file_category", "fileCategory", str),
        E("enable_caching", "enableCaching", bool),
    )

    file_repository_user_name: str = Field(type=str, required=True, mutable=False)
    file_repository_password: str = Field(type=str, required=True, mutable=False)
    net_address: str = Field(type=str, required=True, mutable=False)
    remote_file_format: str = Field(type=str, required=True, mutable=False)
    port_number: int = Field(type=int, required=False, mutable=False)
    root_directory: str = Field(type=str, required=False, mutable=False)
    cpe_file_directory: str = Field(type=str, required=False, mutable=False)
    secure: bool = Field(type=bool, required=False, mutable=False)
    mac_in_non_request_uri: bool = Field(type=bool, required=False, mutable=False)
    mac_format_in_non_request_uri: str = Field(type=str, required=False, mutable=False)
    use_http_digest_authentication: bool = Field(type=bool, required=False, mutable=False)
    mac_based_file_authentication: bool = Field(type=bool, required=False, mutable=False)
    user_name_password_file_authentication: bool = Field(
        type=bool, required=False, mutable=False,
    )
    completion_notification: bool = Field(type=bool, required=False, mutable=False)
    file_category: str = Field(type=str, required=False, mutable=False)
    enable_caching: bool = Field(type=bool, required=False, mutable=False)


class DeviceManagementFileAuthLocationGetResponse21(OCIResponse):
    """
    This is a response to ``DeviceManagementFileAuthLocationGetRequest21()``.

    Return the address and credentials of the File Repository hosting the requested access
    device file.  Also return the file name and path on the File Repository.  Also returns
    the status of the file authentication.

    Attributes:
        status: status
        file_repository_user_name: fileRepositoryUserName
        file_repository_password: fileRepositoryPassword
        net_address: netAddress
        remote_file_format: remoteFileFormat
        port_number: portNumber
        root_directory: rootDirectory
        cpe_file_directory: cpeFileDirectory
        secure: secure
        mac_in_non_request_uri: macInNonRequestURI
        mac_format_in_non_request_uri: macFormatInNonRequestURI
        use_http_digest_authentication: useHttpDigestAuthentication
        mac_based_file_authentication: macBasedFileAuthentication
        user_name_password_file_authentication: userNamePasswordFileAuthentication
        completion_notification: completionNotification
        file_category: fileCategory
        enable_caching: enableCaching
        notify_file_upload: notifyFileUpload
    """

    _ELEMENTS = (
        E("status", "status", str),
        E("file_repository_user_name", "fileRepositoryUserName", str, is_required=True),
        E("file_repository_password", "fileRepositoryPassword", str, is_required=True),
        E("net_address", "netAddress", str, is_required=True),
        E("remote_file_format", "remoteFileFormat", str, is_required=True),
        E("port_number", "portNumber", int),
        E("root_directory", "rootDirectory", str),
        E("cpe_file_directory", "cpeFileDirectory", str),
        E("secure", "secure", bool),
        E("mac_in_non_request_uri", "macInNonRequestURI", bool),
        E("mac_format_in_non_request_uri", "macFormatInNonRequestURI", str),
        E("use_http_digest_authentication", "useHttpDigestAuthentication", bool),
        E("mac_based_file_authentication", "macBasedFileAuthentication", bool),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication", bool,
        ),
        E("completion_notification", "completionNotification", bool),
        E("file_category", "fileCategory", str),
        E("enable_caching", "enableCaching", bool),
        E("notify_file_upload", "notifyFileUpload", bool),
    )

    status: str = Field(type=str, required=False, mutable=False)
    file_repository_user_name: str = Field(type=str, required=True, mutable=False)
    file_repository_password: str = Field(type=str, required=True, mutable=False)
    net_address: str = Field(type=str, required=True, mutable=False)
    remote_file_format: str = Field(type=str, required=True, mutable=False)
    port_number: int = Field(type=int, required=False, mutable=False)
    root_directory: str = Field(type=str, required=False, mutable=False)
    cpe_file_directory: str = Field(type=str, required=False, mutable=False)
    secure: bool = Field(type=bool, required=False, mutable=False)
    mac_in_non_request_uri: bool = Field(type=bool, required=False, mutable=False)
    mac_format_in_non_request_uri: str = Field(type=str, required=False, mutable=False)
    use_http_digest_authentication: bool = Field(type=bool, required=False, mutable=False)
    mac_based_file_authentication: bool = Field(type=bool, required=False, mutable=False)
    user_name_password_file_authentication: bool = Field(
        type=bool, required=False, mutable=False,
    )
    completion_notification: bool = Field(type=bool, required=False, mutable=False)
    file_category: str = Field(type=str, required=False, mutable=False)
    enable_caching: bool = Field(type=bool, required=False, mutable=False)
    notify_file_upload: bool = Field(type=bool, required=False, mutable=False)


class EnterpriseBroadWorksMobileManagerGetDomainListResponse(OCIResponse):
    """
    Response to the ``EnterpriseBroadWorksMobileManagerGetDomainListRequest()``.

    Contains the list of domains.

    Attributes:
        domain_name: domainName
    """

    _ELEMENTS = (
        E("domain_name", "domainName", str, is_array=True),
    )

    domain_name: "List[str]" = Field(type=list, required=False, mutable=False)


class EnterpriseBroadWorksMobileManagerGetHomeZoneListResponse(OCIResponse):
    """
    Response to the ``EnterpriseBroadWorksMobileManagerGetHomeZoneListRequest()``.

    Contains a table with column headings: "Home Zone Id", "Domain Name", "Mobile Country
    Code", "Mobile Network Code", "Local Area Code" and "Cell Identity".

    Attributes:
        home_zones_table: homeZonesTable
    """

    _ELEMENTS = (
        E(
            "home_zones_table", "homeZonesTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    home_zones_table: "list" = Field(type=list, required=True, mutable=False)


class EnterpriseBroadWorksMobileManagerGetHomeZoneResponse(OCIResponse):
    """
    Response to the ``EnterpriseBroadWorksMobileManagerGetHomeZoneRequest()``

    Attributes:
        home_zone_domain_name: homeZoneDomainName
        mobile_country_code: mobileCountryCode
        mobile_network_code: mobileNetworkCode
        location_area_code: locationAreaCode
        cell_identity: cellIdentity
    """

    _ELEMENTS = (
        E("home_zone_domain_name", "homeZoneDomainName", str, is_required=True),
        E("mobile_country_code", "mobileCountryCode", str, is_required=True),
        E("mobile_network_code", "mobileNetworkCode", str, is_required=True),
        E("location_area_code", "locationAreaCode", str, is_required=True),
        E("cell_identity", "cellIdentity", str, is_required=True),
    )

    home_zone_domain_name: str = Field(type=str, required=True, mutable=False)
    mobile_country_code: str = Field(type=str, required=True, mutable=False)
    mobile_network_code: str = Field(type=str, required=True, mutable=False)
    location_area_code: str = Field(type=str, required=True, mutable=False)
    cell_identity: str = Field(type=str, required=True, mutable=False)


class EnterpriseBroadWorksMobileManagerGetResponse(OCIResponse):
    """
    Response to the ``EnterpriseBroadWorksMobileManagerGetRequest()``

    Attributes:
        mobile_manager_id: mobileManagerId
        name: name
        is_active: isActive
        local_to_carrier: localToCarrier
        deactivation_reason: deactivationReason
        max_tx_per_second_enabled: maxTxPerSecondEnabled
        max_tx_per_second: maxTxPerSecond
        tldn_enabled: tldnEnabled
        generic_number_enabled: genericNumberEnabled
        mobile_state_check_enabled: mobileStateCheckEnabled
        location_based_services_enabled: locationBasedServicesEnabled
    """

    _ELEMENTS = (
        E("mobile_manager_id", "mobileManagerId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
        E("local_to_carrier", "localToCarrier", bool, is_required=True),
        E("deactivation_reason", "deactivationReason", str),
        E("max_tx_per_second_enabled", "maxTxPerSecondEnabled", bool, is_required=True),
        E("max_tx_per_second", "maxTxPerSecond", int),
        E("tldn_enabled", "tldnEnabled", bool, is_required=True),
        E("generic_number_enabled", "genericNumberEnabled", bool, is_required=True),
        E("mobile_state_check_enabled", "mobileStateCheckEnabled", bool, is_required=True),
        E(
            "location_based_services_enabled", "locationBasedServicesEnabled", bool,
            is_required=True,
        ),
    )

    mobile_manager_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=True, mutable=False)
    local_to_carrier: bool = Field(type=bool, required=True, mutable=False)
    deactivation_reason: str = Field(type=str, required=False, mutable=False)
    max_tx_per_second_enabled: bool = Field(type=bool, required=True, mutable=False)
    max_tx_per_second: int = Field(type=int, required=False, mutable=False)
    tldn_enabled: bool = Field(type=bool, required=True, mutable=False)
    generic_number_enabled: bool = Field(type=bool, required=True, mutable=False)
    mobile_state_check_enabled: bool = Field(type=bool, required=True, mutable=False)
    location_based_services_enabled: bool = Field(type=bool, required=True, mutable=False)


class EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAssignmentListResponse(OCIResponse):
    """
    Response to
    ``EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAssignmentListRequest()``.

    The response contains a table with columns: "Mobile Number", "User Id", "Last Name",
    "First Name","Phone Number","Extension", "Group Id", "Department" and "Mobile
    Network". The "Mobile Number" column contains a single DN. The "User Id", "Last Name"
    and "First Name" columns contains the corresponding attributes of the user possessing
    the DN(s). The "Phone Number" column contains a single DN. The "Group Id" column
    contains the Group Id of the user.  The "Department" column contains the department of
    the user if it is part of a department.  The "Mobile Network" column contains the
    Mobile Network the number belongs to.

    Attributes:
        mobile_subscriber_directory_numbers_assignment_table:
            mobileSubscriberDirectoryNumbersAssignmentTable
    """

    _ELEMENTS = (
        E(
            "mobile_subscriber_directory_numbers_assignment_table",
            "mobileSubscriberDirectoryNumbersAssignmentTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    mobile_subscriber_directory_numbers_assignment_table: "list" = Field(
        type=list, required=True, mutable=False,
    )


class EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListResponse(OCIResponse):
    """
    Response to
    ``EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest()``.

    Contains a list of available Mobile Subscriber Directory Numbers not yet assigned to
    any user.

    Attributes:
        available_mobile_subscriber_directory_number:
            availableMobileSubscriberDirectoryNumber
    """

    _ELEMENTS = (
        E(
            "available_mobile_subscriber_directory_number",
            "availableMobileSubscriberDirectoryNumber", str, is_array=True,
        ),
    )

    available_mobile_subscriber_directory_number: "List[str]" = Field(
        type=list, required=False, mutable=False,
    )


class EnterpriseCallCenterAgentThresholdDefaultProfileGetResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterAgentThresholdDefaultProfileGetRequest()``.

    The agent table contains the agents assigned to the profile and has column headings:
    "User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address";

    Attributes:
        profile_name: profileName
        profile_description: profileDescription
        threshold_current_call_state_idle_time_yellow:
            thresholdCurrentCallStateIdleTimeYellow
        threshold_current_call_state_idle_time_red: thresholdCurrentCallStateIdleTimeRed
        threshold_current_call_state_on_call_time_yellow:
            thresholdCurrentCallStateOnCallTimeYellow
        threshold_current_call_state_on_call_time_red:
            thresholdCurrentCallStateOnCallTimeRed
        threshold_current_agent_state_unavailable_time_yellow:
            thresholdCurrentAgentStateUnavailableTimeYellow
        threshold_current_agent_state_unavailable_time_red:
            thresholdCurrentAgentStateUnavailableTimeRed
        threshold_average_busy_in_time_yellow: thresholdAverageBusyInTimeYellow
        threshold_average_busy_in_time_red: thresholdAverageBusyInTimeRed
        threshold_average_busy_out_time_yellow: thresholdAverageBusyOutTimeYellow
        threshold_average_busy_out_time_red: thresholdAverageBusyOutTimeRed
        threshold_average_wrap_up_time_yellow: thresholdAverageWrapUpTimeYellow
        threshold_average_wrap_up_time_red: thresholdAverageWrapUpTimeRed
        enable_notification_email: enableNotificationEmail
        notification_email_address: notificationEmailAddress
        agent_table: agentTable
    """

    _ELEMENTS = (
        E("profile_name", "profileName", str, is_required=True),
        E("profile_description", "profileDescription", str),
        E(
            "threshold_current_call_state_idle_time_yellow",
            "thresholdCurrentCallStateIdleTimeYellow", int,
        ),
        E(
            "threshold_current_call_state_idle_time_red",
            "thresholdCurrentCallStateIdleTimeRed", int,
        ),
        E(
            "threshold_current_call_state_on_call_time_yellow",
            "thresholdCurrentCallStateOnCallTimeYellow", int,
        ),
        E(
            "threshold_current_call_state_on_call_time_red",
            "thresholdCurrentCallStateOnCallTimeRed", int,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_yellow",
            "thresholdCurrentAgentStateUnavailableTimeYellow", int,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_red",
            "thresholdCurrentAgentStateUnavailableTimeRed", int,
        ),
        E("threshold_average_busy_in_time_yellow", "thresholdAverageBusyInTimeYellow", int),
        E("threshold_average_busy_in_time_red", "thresholdAverageBusyInTimeRed", int),
        E("threshold_average_busy_out_time_yellow", "thresholdAverageBusyOutTimeYellow", int),
        E("threshold_average_busy_out_time_red", "thresholdAverageBusyOutTimeRed", int),
        E("threshold_average_wrap_up_time_yellow", "thresholdAverageWrapUpTimeYellow", int),
        E("threshold_average_wrap_up_time_red", "thresholdAverageWrapUpTimeRed", int),
        E("enable_notification_email", "enableNotificationEmail", bool, is_required=True),
        E("notification_email_address", "notificationEmailAddress", str),
        E("agent_table", "agentTable", list, is_complex=True, is_table=True),
    )

    profile_name: str = Field(type=str, required=True, mutable=False)
    profile_description: str = Field(type=str, required=False, mutable=False)
    threshold_current_call_state_idle_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_call_state_idle_time_red: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_call_state_on_call_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_call_state_on_call_time_red: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_agent_state_unavailable_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_agent_state_unavailable_time_red: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_busy_in_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_busy_in_time_red: int = Field(type=int, required=False, mutable=False)
    threshold_average_busy_out_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_busy_out_time_red: int = Field(type=int, required=False, mutable=False)
    threshold_average_wrap_up_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_wrap_up_time_red: int = Field(type=int, required=False, mutable=False)
    enable_notification_email: bool = Field(type=bool, required=True, mutable=False)
    notification_email_address: str = Field(type=str, required=False, mutable=False)
    agent_table: "list" = Field(type=list, required=False, mutable=False)


class EnterpriseCallCenterAgentThresholdProfileGetAvailableAgentListResponse(OCIResponse):
    """
    Response to the
    ``EnterpriseCallCenterAgentThresholdProfileGetAvailableAgentListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address", "Agent Threshold Profile";

    Attributes:
        agent_table: agentTable
    """

    _ELEMENTS = (
        E(
            "agent_table", "agentTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    agent_table: "list" = Field(type=list, required=True, mutable=False)


class EnterpriseCallCenterAgentThresholdProfileGetListResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterAgentThresholdProfileGetListRequest()``.

    Contains a table with all the Call Center Agent Threshold Profiles in the Enterprise.
    The column headings are: "Default", "Name", "Description".

    Attributes:
        profiles_table: profilesTable
    """

    _ELEMENTS = (
        E(
            "profiles_table", "profilesTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    profiles_table: "list" = Field(type=list, required=True, mutable=False)


class EnterpriseCallCenterAgentThresholdProfileGetResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterAgentThresholdProfileGetRequest()``.

    The agentTable contains the agents assigned to the profile and has the column
    headings: "User Id", "Group Id", "Last Name", "First Name", "Hiragana Last Name",
    "Hiragana First Name", "Phone Number", "Extension", "Department", "Email Address";

    Attributes:
        profile_description: profileDescription
        threshold_current_call_state_idle_time_yellow:
            thresholdCurrentCallStateIdleTimeYellow
        threshold_current_call_state_idle_time_red: thresholdCurrentCallStateIdleTimeRed
        threshold_current_call_state_on_call_time_yellow:
            thresholdCurrentCallStateOnCallTimeYellow
        threshold_current_call_state_on_call_time_red:
            thresholdCurrentCallStateOnCallTimeRed
        threshold_current_agent_state_unavailable_time_yellow:
            thresholdCurrentAgentStateUnavailableTimeYellow
        threshold_current_agent_state_unavailable_time_red:
            thresholdCurrentAgentStateUnavailableTimeRed
        threshold_average_busy_in_time_yellow: thresholdAverageBusyInTimeYellow
        threshold_average_busy_in_time_red: thresholdAverageBusyInTimeRed
        threshold_average_busy_out_time_yellow: thresholdAverageBusyOutTimeYellow
        threshold_average_busy_out_time_red: thresholdAverageBusyOutTimeRed
        threshold_average_wrap_up_time_yellow: thresholdAverageWrapUpTimeYellow
        threshold_average_wrap_up_time_red: thresholdAverageWrapUpTimeRed
        enable_notification_email: enableNotificationEmail
        notification_email_address: notificationEmailAddress
        agent_table: agentTable
    """

    _ELEMENTS = (
        E("profile_description", "profileDescription", str),
        E(
            "threshold_current_call_state_idle_time_yellow",
            "thresholdCurrentCallStateIdleTimeYellow", int,
        ),
        E(
            "threshold_current_call_state_idle_time_red",
            "thresholdCurrentCallStateIdleTimeRed", int,
        ),
        E(
            "threshold_current_call_state_on_call_time_yellow",
            "thresholdCurrentCallStateOnCallTimeYellow", int,
        ),
        E(
            "threshold_current_call_state_on_call_time_red",
            "thresholdCurrentCallStateOnCallTimeRed", int,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_yellow",
            "thresholdCurrentAgentStateUnavailableTimeYellow", int,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_red",
            "thresholdCurrentAgentStateUnavailableTimeRed", int,
        ),
        E("threshold_average_busy_in_time_yellow", "thresholdAverageBusyInTimeYellow", int),
        E("threshold_average_busy_in_time_red", "thresholdAverageBusyInTimeRed", int),
        E("threshold_average_busy_out_time_yellow", "thresholdAverageBusyOutTimeYellow", int),
        E("threshold_average_busy_out_time_red", "thresholdAverageBusyOutTimeRed", int),
        E("threshold_average_wrap_up_time_yellow", "thresholdAverageWrapUpTimeYellow", int),
        E("threshold_average_wrap_up_time_red", "thresholdAverageWrapUpTimeRed", int),
        E("enable_notification_email", "enableNotificationEmail", bool, is_required=True),
        E("notification_email_address", "notificationEmailAddress", str),
        E(
            "agent_table", "agentTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    profile_description: str = Field(type=str, required=False, mutable=False)
    threshold_current_call_state_idle_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_call_state_idle_time_red: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_call_state_on_call_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_call_state_on_call_time_red: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_agent_state_unavailable_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_agent_state_unavailable_time_red: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_busy_in_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_busy_in_time_red: int = Field(type=int, required=False, mutable=False)
    threshold_average_busy_out_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_busy_out_time_red: int = Field(type=int, required=False, mutable=False)
    threshold_average_wrap_up_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_wrap_up_time_red: int = Field(type=int, required=False, mutable=False)
    enable_notification_email: bool = Field(type=bool, required=True, mutable=False)
    notification_email_address: str = Field(type=str, required=False, mutable=False)
    agent_table: "list" = Field(type=list, required=True, mutable=False)


class EnterpriseCallCenterAgentUnavailableCodeGetListResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterAgentUnavailableCodeGetListRequest()``.

    Contains a table with column headings: "Is Active", "Code", "Description".

    Attributes:
        unavailable_codes_table: unavailableCodesTable
    """

    _ELEMENTS = (
        E(
            "unavailable_codes_table", "unavailableCodesTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    unavailable_codes_table: "list" = Field(type=list, required=True, mutable=False)


class EnterpriseCallCenterAgentUnavailableCodeGetResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterAgentUnavailableCodeGetRequest()``

    Attributes:
        is_active: isActive
        description: description
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("description", "description", str),
    )

    is_active: bool = Field(type=bool, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class EnterpriseCallCenterAgentUnavailableCodeSettingsGetResponse(OCIResponse):
    """
    Response to ``EnterpriseCallCenterAgentUnavailableCodeSettingsGetRequest()``.

    Replaced by ``EnterpriseCallCenterAgentUnavailableCodeSettingsGetResponse17sp4()``.

    Attributes:
        enable_agent_unavailable_codes: enableAgentUnavailableCodes
        default_agent_unavailable_code_on_dnd: defaultAgentUnavailableCodeOnDND
        default_agent_unavailable_code_on_personal_calls:
            defaultAgentUnavailableCodeOnPersonalCalls
        default_agent_unavailable_code_on_consecutive_bounces:
            defaultAgentUnavailableCodeOnConsecutiveBounces
        force_use_of_agent_unavailable_codes: forceUseOfAgentUnavailableCodes
        default_agent_unavailable_code: defaultAgentUnavailableCode
    """

    _ELEMENTS = (
        E(
            "enable_agent_unavailable_codes", "enableAgentUnavailableCodes", bool,
            is_required=True,
        ),
        E("default_agent_unavailable_code_on_dnd", "defaultAgentUnavailableCodeOnDND", str),
        E(
            "default_agent_unavailable_code_on_personal_calls",
            "defaultAgentUnavailableCodeOnPersonalCalls", str,
        ),
        E(
            "default_agent_unavailable_code_on_consecutive_bounces",
            "defaultAgentUnavailableCodeOnConsecutiveBounces", str,
        ),
        E(
            "force_use_of_agent_unavailable_codes", "forceUseOfAgentUnavailableCodes",
            bool, is_required=True,
        ),
        E("default_agent_unavailable_code", "defaultAgentUnavailableCode", str),
    )

    enable_agent_unavailable_codes: bool = Field(type=bool, required=True, mutable=False)
    default_agent_unavailable_code_on_dnd: str = Field(
        type=str, required=False, mutable=False,
    )
    default_agent_unavailable_code_on_personal_calls: str = Field(
        type=str, required=False, mutable=False,
    )
    default_agent_unavailable_code_on_consecutive_bounces: str = Field(
        type=str, required=False, mutable=False,
    )
    force_use_of_agent_unavailable_codes: bool = Field(
        type=bool, required=True, mutable=False,
    )
    default_agent_unavailable_code: str = Field(type=str, required=False, mutable=False)


class EnterpriseCallCenterAgentUnavailableCodeSettingsGetResponse17sp4(OCIResponse):
    """
    Response to ``EnterpriseCallCenterAgentUnavailableCodeSettingsGetRequest17sp4()``.


    Attributes:
        enable_agent_unavailable_codes: enableAgentUnavailableCodes
        default_agent_unavailable_code_on_dnd: defaultAgentUnavailableCodeOnDND
        default_agent_unavailable_code_on_personal_calls:
            defaultAgentUnavailableCodeOnPersonalCalls
        default_agent_unavailable_code_on_consecutive_bounces:
            defaultAgentUnavailableCodeOnConsecutiveBounces
        default_agent_unavailable_code_on_not_reachable:
            defaultAgentUnavailableCodeOnNotReachable
        force_use_of_agent_unavailable_codes: forceUseOfAgentUnavailableCodes
        default_agent_unavailable_code: defaultAgentUnavailableCode
    """

    _ELEMENTS = (
        E(
            "enable_agent_unavailable_codes", "enableAgentUnavailableCodes", bool,
            is_required=True,
        ),
        E("default_agent_unavailable_code_on_dnd", "defaultAgentUnavailableCodeOnDND", str),
        E(
            "default_agent_unavailable_code_on_personal_calls",
            "defaultAgentUnavailableCodeOnPersonalCalls", str,
        ),
        E(
            "default_agent_unavailable_code_on_consecutive_bounces",
            "defaultAgentUnavailableCodeOnConsecutiveBounces", str,
        ),
        E(
            "default_agent_unavailable_code_on_not_reachable",
            "defaultAgentUnavailableCodeOnNotReachable", str,
        ),
        E(
            "force_use_of_agent_unavailable_codes", "forceUseOfAgentUnavailableCodes",
            bool, is_required=True,
        ),
        E("default_agent_unavailable_code", "defaultAgentUnavailableCode", str),
    )

    enable_agent_unavailable_codes: bool = Field(type=bool, required=True, mutable=False)
    default_agent_unavailable_code_on_dnd: str = Field(
        type=str, required=False, mutable=False,
    )
    default_agent_unavailable_code_on_personal_calls: str = Field(
        type=str, required=False, mutable=False,
    )
    default_agent_unavailable_code_on_consecutive_bounces: str = Field(
        type=str, required=False, mutable=False,
    )
    default_agent_unavailable_code_on_not_reachable: str = Field(
        type=str, required=False, mutable=False,
    )
    force_use_of_agent_unavailable_codes: bool = Field(
        type=bool, required=True, mutable=False,
    )
    default_agent_unavailable_code: str = Field(type=str, required=False, mutable=False)


class EnterpriseCallCenterCallDispositionCodeGetListResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterCallDispositionCodeGetListRequest()``.

    Contains a table with column headings: "Is Active", "Code", "Description".

    Attributes:
        disposition_codes_table: dispositionCodesTable
    """

    _ELEMENTS = (
        E(
            "disposition_codes_table", "dispositionCodesTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    disposition_codes_table: "list" = Field(type=list, required=True, mutable=False)


class EnterpriseCallCenterCallDispositionCodeGetResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterCallDispositionCodeGetRequest()``

    Attributes:
        is_active: isActive
        description: description
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("description", "description", str),
    )

    is_active: bool = Field(type=bool, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class EnterpriseCallCenterCallDispositionCodeGetUsageListResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterCallDispositionCodeGetUsageListRequest()``.

    The Type column contains either "Call Center" or "Route Point". Contains a table with
    column headings: "Group Id", "Id", "Name" and "Type".

    Attributes:
        call_center_table: callCenterTable
    """

    _ELEMENTS = (
        E(
            "call_center_table", "callCenterTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    call_center_table: "list" = Field(type=list, required=True, mutable=False)


class EnterpriseCallCenterCurrentAndPastAgentGetListResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterCurrentAndPastAgentGetListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        agent_user_table: agentUserTable
        deleted_agent_user_table: deletedAgentUserTable
    """

    _ELEMENTS = (
        E(
            "agent_user_table", "agentUserTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
        E(
            "deleted_agent_user_table", "deletedAgentUserTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    agent_user_table: "list" = Field(type=list, required=True, mutable=False)
    deleted_agent_user_table: "list" = Field(type=list, required=True, mutable=False)


class EnterpriseCallCenterCurrentAndPastCallCenterGetListResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterCurrentAndPastCallCenterGetListRequest()``.


    Attributes:
        service_user_id: serviceUserId
        deleted_service_user_id: deletedServiceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_array=True),
        E("deleted_service_user_id", "deletedServiceUserId", str, is_array=True),
    )

    service_user_id: "List[str]" = Field(type=list, required=False, mutable=False)
    deleted_service_user_id: "List[str]" = Field(type=list, required=False, mutable=False)


class EnterpriseCallCenterCurrentAndPastDNISGetListResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterCurrentAndPastDNISGetListRequest()``.


    Attributes:
        name: name
        deleted_name: deletedName
    """

    _ELEMENTS = (
        E("name", "name", str, is_array=True),
        E("deleted_name", "deletedName", str, is_array=True),
    )

    name: "List[str]" = Field(type=list, required=False, mutable=False)
    deleted_name: "List[str]" = Field(type=list, required=False, mutable=False)


class EnterpriseCallCenterEnhancedReportingBrandingGetResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterEnhancedReportingBrandingGetRequest()``.


    Attributes:
        branding_choice: brandingChoice
        branding_file_description: brandingFileDescription
    """

    _ELEMENTS = (
        E("branding_choice", "brandingChoice", str, is_required=True),
        E("branding_file_description", "brandingFileDescription", str),
    )

    branding_choice: str = Field(type=str, required=True, mutable=False)
    branding_file_description: str = Field(type=str, required=False, mutable=False)


class EnterpriseCallCenterEnhancedReportingGetAvailableReportTemplateListResponse(OCIResponse):
    """
    Response to
    ``EnterpriseCallCenterEnhancedReportingGetAvailableReportTemplateListRequest()``.

    Contains a table with column headings: "Name", "Description" and "Level", "Is Agent
    Required", "Is Call Center Required", "Is Call Center Dnis Required", "Is Real Time
    Report", "Is Sampling Period Required", "Call Completion Threshold Parameter", "Short
    Duration Threshold Parameter", "Service Level Threshold Parameter", "Service Level
    Inclusions Parameter", "Service Level Objective Threshold Parameter", "Abandoned Call
    Threshold Parameter", "Service Level Threshold Parameter Number", "Abandoned Call
    Threshold Parameter Number" and "Scope". The possible values for "Level" are "System"
    and "Enterprise". The possible values for "Is Agent Required", "Is Call Center
    Required", "Is Call Center Dnis Required", "Is Real Time Report" and "Is Sampling
    Period Required" are "true" and "false". The possible values for "Call Completion
    Threshold Parameter", "Short Duration Threshold Parameter", "Service Level Threshold
    Parameter", "Service Level Inclusions Parameter", "Service Level Objective Threshold
    Parameter" and "Abandoned Call Threshold Parameter" are "Required", "Hidden" and "Does
    Not Apply". The possible values for "Scope" are "Supervisor Only" and "Supervisor and
    Agent".

    Attributes:
        report_template_table: reportTemplateTable
    """

    _ELEMENTS = (
        E(
            "report_template_table", "reportTemplateTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    report_template_table: "list" = Field(type=list, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingGetResponse(OCIResponse):
    """
    Response to ``EnterpriseCallCenterEnhancedReportingGetRequest()``.

    Replaced by ``EnterpriseCallCenterEnhancedReportingGetResponse19()``

    Attributes:
        reporting_server: reportingServer
        web_statistic_source: webStatisticSource
    """

    _ELEMENTS = (
        E("reporting_server", "reportingServer", str, is_required=True),
        E("web_statistic_source", "webStatisticSource", str, is_required=True),
    )

    reporting_server: str = Field(type=str, required=True, mutable=False)
    web_statistic_source: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingGetResponse19(OCIResponse):
    """
    Response to ``EnterpriseCallCenterEnhancedReportingGetRequest19()``.


    Attributes:
        reporting_server: reportingServer
    """

    _ELEMENTS = (
        E("reporting_server", "reportingServer", str, is_required=True),
    )

    reporting_server: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingReportTemplateGetListResponse(OCIResponse):
    """
    Response to ``EnterpriseCallCenterEnhancedReportingReportTemplateGetListRequest()``.

    Contains a table with column headings: "Name", "Description", "Type" and "Enabled".

    Attributes:
        report_template_table: reportTemplateTable
    """

    _ELEMENTS = (
        E(
            "report_template_table", "reportTemplateTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    report_template_table: "list" = Field(type=list, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingReportTemplateGetResponse(OCIResponse):
    """
    Response to ``EnterpriseCallCenterEnhancedReportingReportTemplateGetRequest()``.


    Attributes:
        description: description
        data_template: dataTemplate
        filter_number: filterNumber
        xslt_template_description: xsltTemplateDescription
        scope: scope
        is_enabled: isEnabled
        is_realtime_report: isRealtimeReport
        call_completion_threshold_param: callCompletionThresholdParam
        short_duration_threshold_param: shortDurationThresholdParam
        service_level_threshold_param: serviceLevelThresholdParam
        service_level_inclusions_param: serviceLevelInclusionsParam
        service_level_objective_threshold_param: serviceLevelObjectiveThresholdParam
        abandoned_call_threshold_param: abandonedCallThresholdParam
        service_level_threshold_param_number: serviceLevelThresholdParamNumber
        abandoned_call_threshold_param_number: abandonedCallThresholdParamNumber
        filter_value: filterValue
    """

    _ELEMENTS = (
        E("description", "description", str),
        E("data_template", "dataTemplate", str, is_required=True),
        E("filter_number", "filterNumber", int),
        E("xslt_template_description", "xsltTemplateDescription", str, is_required=True),
        E("scope", "scope", str, is_required=True),
        E("is_enabled", "isEnabled", bool, is_required=True),
        E("is_realtime_report", "isRealtimeReport", bool),
        E("call_completion_threshold_param", "callCompletionThresholdParam", str),
        E("short_duration_threshold_param", "shortDurationThresholdParam", str),
        E("service_level_threshold_param", "serviceLevelThresholdParam", str),
        E("service_level_inclusions_param", "serviceLevelInclusionsParam", str),
        E(
            "service_level_objective_threshold_param",
            "serviceLevelObjectiveThresholdParam", str,
        ),
        E("abandoned_call_threshold_param", "abandonedCallThresholdParam", str),
        E("service_level_threshold_param_number", "serviceLevelThresholdParamNumber", int),
        E("abandoned_call_threshold_param_number", "abandonedCallThresholdParamNumber", int),
        E("filter_value", "filterValue", str),
    )

    description: str = Field(type=str, required=False, mutable=False)
    data_template: str = Field(type=str, required=True, mutable=False)
    filter_number: int = Field(type=int, required=False, mutable=False)
    xslt_template_description: str = Field(type=str, required=True, mutable=False)
    scope: str = Field(type=str, required=True, mutable=False)
    is_enabled: bool = Field(type=bool, required=True, mutable=False)
    is_realtime_report: bool = Field(type=bool, required=False, mutable=False)
    call_completion_threshold_param: str = Field(type=str, required=False, mutable=False)
    short_duration_threshold_param: str = Field(type=str, required=False, mutable=False)
    service_level_threshold_param: str = Field(type=str, required=False, mutable=False)
    service_level_inclusions_param: str = Field(type=str, required=False, mutable=False)
    service_level_objective_threshold_param: str = Field(
        type=str, required=False, mutable=False,
    )
    abandoned_call_threshold_param: str = Field(type=str, required=False, mutable=False)
    service_level_threshold_param_number: int = Field(type=int, required=False, mutable=False)
    abandoned_call_threshold_param_number: int = Field(
        type=int, required=False, mutable=False,
    )
    filter_value: str = Field(type=str, required=False, mutable=False)


class EnterpriseCallCenterEnhancedReportingScheduledReportGetActiveListResponse(OCIResponse):
    """
    Response to
    ``EnterpriseCallCenterEnhancedReportingScheduledReportGetActiveListRequest()``.

    Contains a table with column headings : "Schedule Name", "Description", "Created By",
    "Is Supervisor Report", "Report Template Name", "Report Template Level" and
    "Recurring". The "Created By" can be either "Administrator" or user id if created by
    supervisor.  The possible values for "Recurring" are "None", "Daily", "Weekly",
    "Monthly" and "Yearly". The possible values for "Report Level" are "System" and
    "Enterprise".

    Attributes:
        scheduled_report_table: scheduledReportTable
    """

    _ELEMENTS = (
        E(
            "scheduled_report_table", "scheduledReportTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    scheduled_report_table: "list" = Field(type=list, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingScheduledReportGetCompletedListResponse(OCIResponse):
    """
    Response to
    ``EnterpriseCallCenterEnhancedReportingScheduledReportGetCompletedListRequest()``
    Contains a table with column headings : "Schedule Name", "Description", "Created By",
    "Is Supervisor Report", "Report Template Name", "Report Template Level" and
    "Recurring".

    The "Created By" can be either "Administrator" or user id if created by supervisor.
    The possible values for "Recurring" are "None", "Daily", "Weekly", "Monthly" and
    "Yearly". The possible values for "Report Level" are "System" and "Enterprise".

    Attributes:
        scheduled_report_table: scheduledReportTable
    """

    _ELEMENTS = (
        E(
            "scheduled_report_table", "scheduledReportTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    scheduled_report_table: "list" = Field(type=list, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingScheduledReportGetListResponse(OCIResponse):
    """
    Response to ``EnterpriseCallCenterEnhancedReportingScheduledReportGetListRequest()``.

    Contains a table with column headings : "Schedule Name", "Description", "Created By",
    "Is Supervisor Report", "Status", "Report Template Name", "Report Template Level" and
    "Recurring". The "Created By" can be either "Administrator" or user id if created by
    supervisor.  The possible values for "Status" are "Active", and "Completed". The
    possible values for "Recurring" are "None", "Daily", "Weekly", "Monthly" and "Yearly".
    The possible values for "Report Level" are "System" and "Enterprise".

    Attributes:
        scheduled_report_table: scheduledReportTable
    """

    _ELEMENTS = (
        E(
            "scheduled_report_table", "scheduledReportTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    scheduled_report_table: "list" = Field(type=list, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListResponse(OCIResponse):
    """
    Response to
    ``EnterpriseCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListRequest()``.

    Contains a table with column headings: "Schedule Name", "Created By", "Created By
    Supervisor", and "Is Active". The "Created By" can be either "Administrator" or user
    id if created by supervisor.

    Attributes:
        schedule_report_table: scheduleReportTable
    """

    _ELEMENTS = (
        E(
            "schedule_report_table", "scheduleReportTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    schedule_report_table: "list" = Field(type=list, required=True, mutable=False)


class EnterpriseCallCenterGetResponse(OCIResponse):
    """
    Response to ``EnterpriseCallCenterGetRequest()``.

    Replaced by ``EnterpriseCallCenterGetResponse17sp4()``.

    Attributes:
        use_system_default_guard_timer: useSystemDefaultGuardTimer
        enable_guard_timer: enableGuardTimer
        guard_timer_seconds: guardTimerSeconds
        use_system_default_unavailable_settings: useSystemDefaultUnavailableSettings
        force_agent_unavailable_on_dnd_activation: forceAgentUnavailableOnDNDActivation
        force_agent_unavailable_on_personal_calls: forceAgentUnavailableOnPersonalCalls
        force_agent_unavailable_on_bounced_call_limit:
            forceAgentUnavailableOnBouncedCallLimit
        number_consecutive_bounced_calls_to_force_agent_unavailable:
            numberConsecutiveBouncedCallsToForceAgentUnavailable
    """

    _ELEMENTS = (
        E(
            "use_system_default_guard_timer", "useSystemDefaultGuardTimer", bool,
            is_required=True,
        ),
        E("enable_guard_timer", "enableGuardTimer", bool, is_required=True),
        E("guard_timer_seconds", "guardTimerSeconds", int, is_required=True),
        E(
            "use_system_default_unavailable_settings",
            "useSystemDefaultUnavailableSettings", bool,
        ),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation", bool,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls", bool,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit", bool,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable", int,
        ),
    )

    use_system_default_guard_timer: bool = Field(type=bool, required=True, mutable=False)
    enable_guard_timer: bool = Field(type=bool, required=True, mutable=False)
    guard_timer_seconds: int = Field(type=int, required=True, mutable=False)
    use_system_default_unavailable_settings: bool = Field(
        type=bool, required=False, mutable=False,
    )
    force_agent_unavailable_on_dnd_activation: bool = Field(
        type=bool, required=False, mutable=False,
    )
    force_agent_unavailable_on_personal_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    force_agent_unavailable_on_bounced_call_limit: bool = Field(
        type=bool, required=False, mutable=False,
    )
    number_consecutive_bounced_calls_to_force_agent_unavailable: int = Field(
        type=int, required=False, mutable=False,
    )


class EnterpriseCallCenterGetResponse17sp4(OCIResponse):
    """
    Response to ``EnterpriseCallCenterGetRequest17sp4()``.


    Attributes:
        use_system_default_guard_timer: useSystemDefaultGuardTimer
        enable_guard_timer: enableGuardTimer
        guard_timer_seconds: guardTimerSeconds
        use_system_default_unavailable_settings: useSystemDefaultUnavailableSettings
        force_agent_unavailable_on_dnd_activation: forceAgentUnavailableOnDNDActivation
        force_agent_unavailable_on_personal_calls: forceAgentUnavailableOnPersonalCalls
        force_agent_unavailable_on_bounced_call_limit:
            forceAgentUnavailableOnBouncedCallLimit
        number_consecutive_bounced_calls_to_force_agent_unavailable:
            numberConsecutiveBouncedCallsToForceAgentUnavailable
        force_agent_unavailable_on_not_reachable: forceAgentUnavailableOnNotReachable
    """

    _ELEMENTS = (
        E(
            "use_system_default_guard_timer", "useSystemDefaultGuardTimer", bool,
            is_required=True,
        ),
        E("enable_guard_timer", "enableGuardTimer", bool, is_required=True),
        E("guard_timer_seconds", "guardTimerSeconds", int, is_required=True),
        E(
            "use_system_default_unavailable_settings",
            "useSystemDefaultUnavailableSettings", bool,
        ),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation", bool,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls", bool,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit", bool,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable", int,
        ),
        E(
            "force_agent_unavailable_on_not_reachable",
            "forceAgentUnavailableOnNotReachable", bool,
        ),
    )

    use_system_default_guard_timer: bool = Field(type=bool, required=True, mutable=False)
    enable_guard_timer: bool = Field(type=bool, required=True, mutable=False)
    guard_timer_seconds: int = Field(type=int, required=True, mutable=False)
    use_system_default_unavailable_settings: bool = Field(
        type=bool, required=False, mutable=False,
    )
    force_agent_unavailable_on_dnd_activation: bool = Field(
        type=bool, required=False, mutable=False,
    )
    force_agent_unavailable_on_personal_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    force_agent_unavailable_on_bounced_call_limit: bool = Field(
        type=bool, required=False, mutable=False,
    )
    number_consecutive_bounced_calls_to_force_agent_unavailable: int = Field(
        type=int, required=False, mutable=False,
    )
    force_agent_unavailable_on_not_reachable: bool = Field(
        type=bool, required=False, mutable=False,
    )


class EnterpriseCallCenterGetRoutingPolicyResponse(OCIResponse):
    """
    Response to ``EnterpriseCallCenterGetRoutingPolicyRequest()``.

    Contains a table with column headings: "Service User Id", "Name" and "Priority".

    Attributes:
        routing_policy: routingPolicy
        call_center_table: callCenterTable
    """

    _ELEMENTS = (
        E("routing_policy", "routingPolicy", str, is_required=True),
        E(
            "call_center_table", "callCenterTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    routing_policy: str = Field(type=str, required=True, mutable=False)
    call_center_table: "list" = Field(type=list, required=True, mutable=False)


class EnterpriseEnterpriseTrunkGetAvailableUserListResponse(OCIResponse):
    """
    Response to ``EnterpriseEnterpriseTrunkGetAvailableUserListRequest()``.

    The column headings for the enterpriseTrunkUserTable are: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name", "Phone Number",
    "Extension", "Department", "Email Address".

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class EnterpriseEnterpriseTrunkGetListResponse(OCIResponse):
    """
    Response to ``EnterpriseEnterpriseTrunkGetListRequest()``.

    Contains a table of enterprise trunks defined in the enterprise The column headings
    are: "Enterprise Trunk Name", "Routing Type"

    Attributes:
        enterprise_trunk_table: enterpriseTrunkTable
    """

    _ELEMENTS = (
        E(
            "enterprise_trunk_table", "enterpriseTrunkTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    enterprise_trunk_table: "list" = Field(type=list, required=True, mutable=False)


class EnterpriseEnterpriseTrunkGetResponse(OCIResponse):
    """
    Response to ``EnterpriseEnterpriseTrunkGetRequest()``.

    Replaced by: ``EnterpriseEnterpriseTrunkGetResponse21()``.

    Attributes:
        maximum_reroute_attempts: maximumRerouteAttempts
        route_exhaustion_action: routeExhaustionAction
        route_exhaustion_forward_address: routeExhaustionForwardAddress
        ordered_routing: orderedRouting
        priority_weighted_routing: priorityWeightedRouting
    """

    _ELEMENTS = (
        E("maximum_reroute_attempts", "maximumRerouteAttempts", int, is_required=True),
        E("route_exhaustion_action", "routeExhaustionAction", str, is_required=True),
        E("route_exhaustion_forward_address", "routeExhaustionForwardAddress", str),
        E("ordered_routing", "orderedRouting", str, is_complex=True),  # unknown
        E(
            "priority_weighted_routing", "priorityWeightedRouting", str, is_complex=True,
        ),  # unknown
    )

    maximum_reroute_attempts: int = Field(type=int, required=True, mutable=False)
    route_exhaustion_action: str = Field(type=str, required=True, mutable=False)
    route_exhaustion_forward_address: str = Field(type=str, required=False, mutable=False)
    ordered_routing: str = Field(type=str, required=False, mutable=False)
    priority_weighted_routing: str = Field(type=str, required=False, mutable=False)


class EnterpriseEnterpriseTrunkGetResponse21(OCIResponse):
    """
    Response to ``EnterpriseEnterpriseTrunkGetRequest21()``.


    Attributes:
        maximum_reroute_attempts: maximumRerouteAttempts
        route_exhaustion_action: routeExhaustionAction
        route_exhaustion_forward_address: routeExhaustionForwardAddress
        ordered_routing: orderedRouting
        priority_weighted_routing: priorityWeightedRouting
        enable_capacity_management: enableCapacityManagement
        max_active_calls: maxActiveCalls
        capacity_exceeded_trap_initial_calls: capacityExceededTrapInitialCalls
        capacity_exceeded_trap_offset_calls: capacityExceededTrapOffsetCalls
    """

    _ELEMENTS = (
        E("maximum_reroute_attempts", "maximumRerouteAttempts", int, is_required=True),
        E("route_exhaustion_action", "routeExhaustionAction", str, is_required=True),
        E("route_exhaustion_forward_address", "routeExhaustionForwardAddress", str),
        E("ordered_routing", "orderedRouting", str, is_complex=True),  # unknown
        E(
            "priority_weighted_routing", "priorityWeightedRouting", str, is_complex=True,
        ),  # unknown
        E("enable_capacity_management", "enableCapacityManagement", bool, is_required=True),
        E("max_active_calls", "maxActiveCalls", int),
        E("capacity_exceeded_trap_initial_calls", "capacityExceededTrapInitialCalls", int),
        E("capacity_exceeded_trap_offset_calls", "capacityExceededTrapOffsetCalls", int),
    )

    maximum_reroute_attempts: int = Field(type=int, required=True, mutable=False)
    route_exhaustion_action: str = Field(type=str, required=True, mutable=False)
    route_exhaustion_forward_address: str = Field(type=str, required=False, mutable=False)
    ordered_routing: str = Field(type=str, required=False, mutable=False)
    priority_weighted_routing: str = Field(type=str, required=False, mutable=False)
    enable_capacity_management: bool = Field(type=bool, required=True, mutable=False)
    max_active_calls: int = Field(type=int, required=False, mutable=False)
    capacity_exceeded_trap_initial_calls: int = Field(type=int, required=False, mutable=False)
    capacity_exceeded_trap_offset_calls: int = Field(type=int, required=False, mutable=False)


class EnterpriseEnterpriseTrunkGetUserListResponse(OCIResponse):
    """
    Response to ``EnterpriseEnterpriseTrunkGetUserListRequest()``.

    The column headings for the enterpriseTrunkUserTable are: "Group Id", "User Id", "Last
    Name", "First Name", "Phone Number", "Alternate Trunk Identity", "Hiragana Last Name",
    "Hiragana First Name", "Extension", "Department", "Email Address" and "Route List
    Assigned".

    Attributes:
        enterprise_trunk_user_table: enterpriseTrunkUserTable
    """

    _ELEMENTS = (
        E(
            "enterprise_trunk_user_table", "enterpriseTrunkUserTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    enterprise_trunk_user_table: "list" = Field(type=list, required=True, mutable=False)


class EnterprisePhoneDirectoryGetListResponse(OCIResponse):
    """
    Response to ``EnterprisePhoneDirectoryGetListRequest()``.

    Contains a table with a row for each phone number and column headings : "Name",
    "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana Name",
    "Group Id", "Yahoo Id". If extended directory information is requested, the following
    columns are also included: "First Name", "Last Name", "User Id", "Pager", "Title",
    "Time Zone", "Location", "Address Line 1", "Address Line 2", "City", "State", "Zip",
    "Country". Replace by: ``EnterprisePhoneDirectoryGetListResponse17()``

    Attributes:
        directory_table: directoryTable
    """

    _ELEMENTS = (
        E(
            "directory_table", "directoryTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    directory_table: "list" = Field(type=list, required=True, mutable=False)


class EnterprisePhoneDirectoryGetListResponse17(OCIResponse):
    """
    Response to ``EnterprisePhoneDirectoryGetListRequest17()``.

    Contains a table with a row for each phone number and column headings : "Name",
    "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana Name",
    "Group Id", "Yahoo Id", "Is Virtual On-Net User". If extended directory information is
    requested, the following columns are also included: "First Name", "Last Name", "User
    Id", "Pager", "Title", "Time Zone", "Location", "Address Line 1", "Address Line 2",
    "City", "State", "Zip", "Country". Replaced by:
    ``EnterprisePhoneDirectoryGetListResponse18()``

    Attributes:
        directory_table: directoryTable
    """

    _ELEMENTS = (
        E(
            "directory_table", "directoryTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    directory_table: "list" = Field(type=list, required=True, mutable=False)


class EnterprisePhoneDirectoryGetListResponse17sp3(OCIResponse):
    """
    Response to ``EnterprisePhoneDirectoryGetListRequest17sp3()``.

    Contains a table with a row for each phone number and column headings : "Name",
    "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana Name",
    "Group Id", "Yahoo Id", "IMP Id", "Is Virtual On-Net User". If extended directory
    information is requested, the following columns are also included: "First Name", "Last
    Name", "User Id", "Pager", "Title", "Time Zone", "Location", "Address Line 1",
    "Address Line 2", "City", "State", "Zip", "Country". Replaced by:
    ``EnterprisePhoneDirectoryGetListResponse18()``

    Attributes:
        directory_table: directoryTable
    """

    _ELEMENTS = (
        E(
            "directory_table", "directoryTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    directory_table: "list" = Field(type=list, required=True, mutable=False)


class EnterprisePhoneDirectoryGetListResponse18(OCIResponse):
    """
    Response to ``EnterprisePhoneDirectoryGetListRequest18()``.

    Contains a table with a row for each phone number and column headings : "Name",
    "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana Name",
    "Group Id", "Yahoo Id", "User Id", "IMP Id", "Is Virtual On-Net User". If extended
    directory information is requested, the following columns are also included: "First
    Name", "Last Name", "Pager", "Title", "Time Zone", "Location", "Address Line 1",
    "Address Line 2", "City", "State", "Zip", "Country".

    Attributes:
        directory_table: directoryTable
    """

    _ELEMENTS = (
        E(
            "directory_table", "directoryTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    directory_table: "list" = Field(type=list, required=True, mutable=False)


class EnterprisePreAlertingAnnouncementGetResponse(OCIResponse):
    """
    Get the Enterprise level pre-alerting service settings.

    The response is either a ``EnterprisePreAlertingAnnouncementGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        announcement_interruption: announcementInterruption
        interruption_digit_sequence: interruptionDigitSequence
        audio_selection: audioSelection
        audio_file_description: audioFileDescription
        audio_media_type: audioMediaType
        audio_file_url: audioFileUrl
        video_selection: videoSelection
        video_file_description: videoFileDescription
        video_media_type: videoMediaType
        video_file_url: videoFileUrl
    """

    _ELEMENTS = (
        E("announcement_interruption", "announcementInterruption", str, is_required=True),
        E("interruption_digit_sequence", "interruptionDigitSequence", str),
        E("audio_selection", "audioSelection", str, is_required=True),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("audio_file_url", "audioFileUrl", str),
        E("video_selection", "videoSelection", str, is_required=True),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
        E("video_file_url", "videoFileUrl", str),
    )

    announcement_interruption: str = Field(type=str, required=True, mutable=False)
    interruption_digit_sequence: str = Field(type=str, required=False, mutable=False)
    audio_selection: str = Field(type=str, required=True, mutable=False)
    audio_file_description: str = Field(type=str, required=False, mutable=False)
    audio_media_type: str = Field(type=str, required=False, mutable=False)
    audio_file_url: str = Field(type=str, required=False, mutable=False)
    video_selection: str = Field(type=str, required=True, mutable=False)
    video_file_description: str = Field(type=str, required=False, mutable=False)
    video_media_type: str = Field(type=str, required=False, mutable=False)
    video_file_url: str = Field(type=str, required=False, mutable=False)


class EnterpriseRouteListEnterpriseTrunkNumberRangeGetAvailableListResponse(OCIResponse):
    """
    Response to
    ``EnterpriseRouteListEnterpriseTrunkNumberRangeGetAvailableListRequest()``.

    Contains a list of number ranges that are assigned to an enterprise and still
    available for assignment to users within the enterprise.  The column headings are
    "Number Range Start", "Number Range End" and "Is Active".

    Attributes:
        available_number_range_table: availableNumberRangeTable
    """

    _ELEMENTS = (
        E(
            "available_number_range_table", "availableNumberRangeTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    available_number_range_table: "list" = Field(type=list, required=True, mutable=False)


class EnterpriseRouteListEnterpriseTrunkNumberRangeGetSummaryListResponse(OCIResponse):
    """
    Response to ``EnterpriseRouteListEnterpriseTrunkNumberRangeGetSummaryListRequest()``.

    The response contains a table with columns: "Number Range Start", "Number Range End",
    "Group Id", "User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana
    First Name", "Phone Number", "Extension", "Department", "Email Address", "Enterprise
    Trunk" and "Is Active". The "User Id", "Last Name", "First Name", "Hiragana Last
    Name", "Hiragana First Name", "Phone Number", "Extension", "Department" and "Email
    Address" columns contains the corresponding attributes of the user possessing the
    number range.  The "Enterprise Trunk" column contains the enterprise trunk the user
    possessing the number range belongs to.  The "Is Active" column indicates if the
    number range has been activated.

    Attributes:
        number_range_summary_table: numberRangeSummaryTable
    """

    _ELEMENTS = (
        E(
            "number_range_summary_table", "numberRangeSummaryTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    number_range_summary_table: "list" = Field(type=list, required=True, mutable=False)


class EnterpriseSessionAdmissionControlGroupGetListResponse(OCIResponse):
    """
    Response to ``EnterpriseSessionAdmissionControlGroupGetListRequest()``.

    Contains a table of session admission control group configured in the enterprise.  The
    column headings are: "Name", "Is Default", "Maximum Sessions", "Maximum Originating
    Sessions", "Maximum Terminating Sessions"..

    Attributes:
        session_admission_control_group_table: sessionAdmissionControlGroupTable
    """

    _ELEMENTS = (
        E(
            "session_admission_control_group_table", "sessionAdmissionControlGroupTable",
            list, is_complex=True, is_required=True, is_table=True,
        ),
    )

    session_admission_control_group_table: "list" = Field(
        type=list, required=True, mutable=False,
    )


class EnterpriseVirtualOnNetEnterpriseExtensionsGetUserListResponse(OCIResponse):
    """
    Response to ``EnterpriseVirtualOnNetEnterpriseExtensionsGetUserListRequest()``.

    Contains a table with column headings : "Group Id", "Last Name", "First Name", "Phone
    Number", "Extension", "Virtual On-Net Call Type" in a row for each user.

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class EnterpriseVoiceVPNGetPolicyListResponse(OCIResponse):
    """
    Response to ``EnterpriseVoiceVPNGetListResponse()``.

    Returns a 4 column table with column headings: "Location Code", "Min Extension
    Length", "Max Extension Length", "Location Selection".

    Attributes:
        location_list: locationList
    """

    _ELEMENTS = (
        E(
            "location_list", "locationList", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    location_list: "list" = Field(type=list, required=True, mutable=False)


class EnterpriseVoiceVPNGetResponse(OCIResponse):
    """
    Response to ``EnterpriseVoiceVPNGetRequest()``.

    Replaced By: ``EnterpriseVoiceVPNGetResponse14sp3()``

    Attributes:
        is_active: isActive
        default_selection: defaultSelection
        e164_selection: e164Selection
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("default_selection", "defaultSelection", str, is_required=True),
        E("e164_selection", "e164Selection", str, is_required=True),
    )

    is_active: bool = Field(type=bool, required=True, mutable=False)
    default_selection: str = Field(type=str, required=True, mutable=False)
    e164_selection: str = Field(type=str, required=True, mutable=False)


class EnterpriseVoiceVPNGetResponse14sp3(OCIResponse):
    """
    Response to ``EnterpriseVoiceVPNGetRequest14sp3()``.


    Attributes:
        is_active: isActive
        default_selection: defaultSelection
        e164_selection: e164Selection
        use_phone_context: usePhoneContext
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("default_selection", "defaultSelection", str, is_required=True),
        E("e164_selection", "e164Selection", str, is_required=True),
        E("use_phone_context", "usePhoneContext", bool, is_required=True),
    )

    is_active: bool = Field(type=bool, required=True, mutable=False)
    default_selection: str = Field(type=str, required=True, mutable=False)
    e164_selection: str = Field(type=str, required=True, mutable=False)
    use_phone_context: bool = Field(type=bool, required=True, mutable=False)


class ExternalAuthenticationCreateLoginTokenResponse(OCIResponse):
    """
    Response to ``ExternalAuthenticationCreateLoginTokenRequest()``.


    Attributes:
        login_token: loginToken
    """

    _ELEMENTS = (
        E("login_token", "loginToken", str, is_required=True),
    )

    login_token: str = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceAvailablePortGetListResponse(OCIResponse):
    """
    Response to ``GroupAccessDeviceAvailablePortGetListRequest()``.

    Contains a list of available ports in a device using static mode.  The list is empty
    in case the device is using dynamic mode.

    Attributes:
        port_number: portNumber
    """

    _ELEMENTS = (
        E("port_number", "portNumber", int, is_array=True),
    )

    port_number: "List[int]" = Field(type=list, required=False, mutable=False)


class GroupAccessDeviceCustomTagGetListResponse(OCIResponse):
    """
    Response to ``GroupAccessDeviceCustomTagGetListRequest()``.

    Contains a table of custom configuration tags managed by the Device Management System
    on a per-device profile basis.  The column headings are: "Tag Name", "Tag Value"

    Attributes:
        device_custom_tags_table: deviceCustomTagsTable
    """

    _ELEMENTS = (
        E(
            "device_custom_tags_table", "deviceCustomTagsTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    device_custom_tags_table: "list" = Field(type=list, required=True, mutable=False)


class GroupAccessDeviceFileGetListResponse(OCIResponse):
    """
    Response to ``GroupAccessDeviceFileGetListRequest()``.

    Contains a table of device files managed by the Device Management System on a per-
    device profile basis.  The column headings are: "File Type", "File Format", "Is
    Authenticated".

    Replaced By: ``GroupAccessDeviceFileGetListResponse14sp8()``

    Attributes:
        device_files_table: deviceFilesTable
    """

    _ELEMENTS = (
        E(
            "device_files_table", "deviceFilesTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    device_files_table: "list" = Field(type=list, required=True, mutable=False)


class GroupAccessDeviceFileGetListResponse14sp8(OCIResponse):
    """
    Response to ``GroupAccessDeviceFileGetListRequest14sp8()``.

    Contains a table of device files managed by the Device Management System on a per-
    device profile basis.  The column headings are: "File Format", "Is Authenticated",
    "Access URL", "Repository URL", "Template URL", "Extended Capture". The following
    columns are only used in AS data mode: "Extended Capture"

    Attributes:
        device_files_table: deviceFilesTable
    """

    _ELEMENTS = (
        E(
            "device_files_table", "deviceFilesTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    device_files_table: "list" = Field(type=list, required=True, mutable=False)


class GroupAccessDeviceFileGetResponse(OCIResponse):
    """
    Response to ``GroupAccessDeviceFileGetRequest()``.

    Replaced By: ``GroupAccessDeviceFileGetResponse14sp8()``

    Attributes:
        file_source: fileSource
        configuration_file_name: configurationFileName
    """

    _ELEMENTS = (
        E("file_source", "fileSource", str, is_required=True),
        E("configuration_file_name", "configurationFileName", str),
    )

    file_source: str = Field(type=str, required=True, mutable=False)
    configuration_file_name: str = Field(type=str, required=False, mutable=False)


class GroupAccessDeviceFileGetResponse14sp8(OCIResponse):
    """
    Response to ``GroupAccessDeviceFileGetRequest14sp8()``.

    Replaced by: ``GroupAccessDeviceFileGetResponse16sp1()``

    Attributes:
        file_source: fileSource
        configuration_file_name: configurationFileName
    """

    _ELEMENTS = (
        E("file_source", "fileSource", str, is_required=True),
        E("configuration_file_name", "configurationFileName", str),
    )

    file_source: str = Field(type=str, required=True, mutable=False)
    configuration_file_name: str = Field(type=str, required=False, mutable=False)


class GroupAccessDeviceFileGetResponse16sp1(OCIResponse):
    """
    Response to ``GroupAccessDeviceFileGetRequest16sp1()``.


    Attributes:
        file_source: fileSource
        configuration_file_name: configurationFileName
        access_url: accessUrl
        repository_url: repositoryUrl
        template_url: templateUrl
    """

    _ELEMENTS = (
        E("file_source", "fileSource", str, is_required=True),
        E("configuration_file_name", "configurationFileName", str),
        E("access_url", "accessUrl", str, is_required=True),
        E("repository_url", "repositoryUrl", str),
        E("template_url", "templateUrl", str),
    )

    file_source: str = Field(type=str, required=True, mutable=False)
    configuration_file_name: str = Field(type=str, required=False, mutable=False)
    access_url: str = Field(type=str, required=True, mutable=False)
    repository_url: str = Field(type=str, required=False, mutable=False)
    template_url: str = Field(type=str, required=False, mutable=False)


class GroupAccessDeviceFileGetResponse20(OCIResponse):
    """
    Response to ``GroupAccessDeviceFileGetRequest20()``.


    Attributes:
        file_source: fileSource
        configuration_file_name: configurationFileName
        access_url: accessUrl
        repository_url: repositoryUrl
        template_url: templateUrl
        extended_capture_enabled: extendedCaptureEnabled
        extended_capture_url: extendedCaptureURL
    """

    _ELEMENTS = (
        E("file_source", "fileSource", str, is_required=True),
        E("configuration_file_name", "configurationFileName", str),
        E("access_url", "accessUrl", str, is_required=True),
        E("repository_url", "repositoryUrl", str),
        E("template_url", "templateUrl", str),
        E("extended_capture_enabled", "extendedCaptureEnabled", bool),
        E("extended_capture_url", "extendedCaptureURL", str),
    )

    file_source: str = Field(type=str, required=True, mutable=False)
    configuration_file_name: str = Field(type=str, required=False, mutable=False)
    access_url: str = Field(type=str, required=True, mutable=False)
    repository_url: str = Field(type=str, required=False, mutable=False)
    template_url: str = Field(type=str, required=False, mutable=False)
    extended_capture_enabled: bool = Field(type=bool, required=False, mutable=False)
    extended_capture_url: str = Field(type=str, required=False, mutable=False)


class GroupAccessDeviceGetAvailableDetailListResponse14(OCIResponse):
    """
    Response to ``GroupAccessDeviceGetAvailableDetailListRequest14()``.


    Attributes:
        available_access_device: availableAccessDevice
    """

    _ELEMENTS = (
        E(
            "available_access_device", "availableAccessDevice", str, is_complex=True,
            is_array=True,
        ),  # unknown
    )

    available_access_device: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupAccessDeviceGetAvailableDetailListResponse19(OCIResponse):
    """
    Response to ``GroupAccessDeviceGetAvailableDetailListRequest19()``.


    Attributes:
        available_access_device: availableAccessDevice
    """

    _ELEMENTS = (
        E(
            "available_access_device", "availableAccessDevice", str, is_complex=True,
            is_array=True,
        ),  # unknown
    )

    available_access_device: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupAccessDeviceGetEnhancedConfigurationTypeListResponse(OCIResponse):
    """
    Response to ``GroupAccessDeviceGetEnhancedConfigurationTypeListRequest()``.


    Attributes:
        device_type: deviceType
    """

    _ELEMENTS = (
        E("device_type", "deviceType", str, is_array=True),
    )

    device_type: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupAccessDeviceGetEnhancedConfigurationTypeResponse14(OCIResponse):
    """
    Response to ``GroupAccessDeviceGetEnhancedConfigurationTypeRequest14()``.


    Attributes:
        supports_enhanced_configuration: supportsEnhancedConfiguration
        supports_reset: supportsReset
        configuration_type: configurationType
        configuration_file_name: configurationFileName
    """

    _ELEMENTS = (
        E(
            "supports_enhanced_configuration", "supportsEnhancedConfiguration", bool,
            is_required=True,
        ),
        E("supports_reset", "supportsReset", bool, is_required=True),
        E("configuration_type", "configurationType", str),
        E("configuration_file_name", "configurationFileName", str),
    )

    supports_enhanced_configuration: bool = Field(type=bool, required=True, mutable=False)
    supports_reset: bool = Field(type=bool, required=True, mutable=False)
    configuration_type: str = Field(type=str, required=False, mutable=False)
    configuration_file_name: str = Field(type=str, required=False, mutable=False)


class GroupAccessDeviceGetListResponse(OCIResponse):
    """
    Response to ``GroupAccessDeviceGetListRequest()``.

    Contains a table of devices configured in the group.  The column headings are: "Device
    Name", "Device Type", "Available Ports", "Net Address", "MAC Address", "Status" and
    "Version".

    Attributes:
        access_device_table: accessDeviceTable
    """

    _ELEMENTS = (
        E(
            "access_device_table", "accessDeviceTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    access_device_table: "list" = Field(type=list, required=True, mutable=False)


class GroupAccessDeviceGetUserListResponse(OCIResponse):
    """
    Response to ``GroupAccessDeviceGetUserListRequest()``.

    The column headings for the deviceUserTable are: "Line/Port", "Last Name", "First
    Name", "Phone Number", "User Id", "User Type", "Endpoint Type", "Order", "Primary
    Line/Port", "Extension", "Department", "Email Address", "Private Identity". In IMS
    mode, the table will contain a row for each TEL-URI in the Phone Number column.  In
    Standalone mode, rows for the alternate numbers are not included.  The User Type
    column contains one of the enumerated UserType values.  The Endpoint Type column
    contains one of the enumerated EndpointType values.  The Private Identity column is
    empty is AS mode.

    Attributes:
        device_user_table: deviceUserTable
    """

    _ELEMENTS = (
        E(
            "device_user_table", "deviceUserTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    device_user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupAccountAuthorizationCodesGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupAccountAuthorizationCodesGetAvailableUserListRequest()``.

    The column headings are: "User Id", "Last Name", "First Name", "Hiragana Last Name"
    and "Hiragana First Name", "Phone Number", "Extension", "Department", "Email Address".

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupAccountAuthorizationCodesGetResponse(OCIResponse):
    """
    Response to ``GroupAccountAuthorizationCodesGetRequest()``.

    The tables has the following column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name", "Hiragana First Name", "Phone Number", "Extension",
    "Department", "Email Address".

    Attributes:
        type: type
        number_of_digits: numberOfDigits
        allow_local_and_toll_free_calls: allowLocalAndTollFreeCalls
        mandatory_usage_user_table: mandatoryUsageUserTable
        optional_usage_user_table: optionalUsageUserTable
    """

    _ELEMENTS = (
        E("type", "type", str, is_required=True),
        E("number_of_digits", "numberOfDigits", int, is_required=True),
        E(
            "allow_local_and_toll_free_calls", "allowLocalAndTollFreeCalls", bool,
            is_required=True,
        ),
        E(
            "mandatory_usage_user_table", "mandatoryUsageUserTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
        E(
            "optional_usage_user_table", "optionalUsageUserTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    type: str = Field(type=str, required=True, mutable=False)
    number_of_digits: int = Field(type=int, required=True, mutable=False)
    allow_local_and_toll_free_calls: bool = Field(type=bool, required=True, mutable=False)
    mandatory_usage_user_table: "list" = Field(type=list, required=True, mutable=False)
    optional_usage_user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupAdminGetListResponse(OCIResponse):
    """
    Response to ``GroupAdminGetListRequest()``.

    Contains a 5 column table with column headings "Administrator ID", "Last Name", "First
    Name", "Department", "Language".

    Attributes:
        group_admin_table: groupAdminTable
    """

    _ELEMENTS = (
        E(
            "group_admin_table", "groupAdminTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    group_admin_table: "list" = Field(type=list, required=True, mutable=False)


class GroupAdminGetPolicyResponse(OCIResponse):
    """
    Response to ``GroupAdminGetPolicyRequest()``.

    Contains the policy settings for the group administrator.

    Attributes:
        profile_access: profileAccess
        user_access: userAccess
        admin_access: adminAccess
        department_access: departmentAccess
        access_device_access: accessDeviceAccess
        enhanced_service_instance_access: enhancedServiceInstanceAccess
        feature_access_code_access: featureAccessCodeAccess
        phone_number_extension_access: phoneNumberExtensionAccess
        service_access: serviceAccess
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "enhanced_service_instance_access", "enhancedServiceInstanceAccess", str,
            is_required=True,
        ),
        E("feature_access_code_access", "featureAccessCodeAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
    )

    profile_access: str = Field(type=str, required=True, mutable=False)
    user_access: str = Field(type=str, required=True, mutable=False)
    admin_access: str = Field(type=str, required=True, mutable=False)
    department_access: str = Field(type=str, required=True, mutable=False)
    access_device_access: str = Field(type=str, required=True, mutable=False)
    enhanced_service_instance_access: str = Field(type=str, required=True, mutable=False)
    feature_access_code_access: str = Field(type=str, required=True, mutable=False)
    phone_number_extension_access: str = Field(type=str, required=True, mutable=False)
    service_access: str = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyResponse14sp1(OCIResponse):
    """
    Response to ``GroupAdminGetPolicyRequest14sp1()``.

    Contains the policy settings for the group administrator.

    Attributes:
        profile_access: profileAccess
        user_access: userAccess
        admin_access: adminAccess
        department_access: departmentAccess
        access_device_access: accessDeviceAccess
        enhanced_service_instance_access: enhancedServiceInstanceAccess
        feature_access_code_access: featureAccessCodeAccess
        phone_number_extension_access: phoneNumberExtensionAccess
        service_access: serviceAccess
        trunk_group_access: trunkGroupAccess
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "enhanced_service_instance_access", "enhancedServiceInstanceAccess", str,
            is_required=True,
        ),
        E("feature_access_code_access", "featureAccessCodeAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("trunk_group_access", "trunkGroupAccess", str, is_required=True),
    )

    profile_access: str = Field(type=str, required=True, mutable=False)
    user_access: str = Field(type=str, required=True, mutable=False)
    admin_access: str = Field(type=str, required=True, mutable=False)
    department_access: str = Field(type=str, required=True, mutable=False)
    access_device_access: str = Field(type=str, required=True, mutable=False)
    enhanced_service_instance_access: str = Field(type=str, required=True, mutable=False)
    feature_access_code_access: str = Field(type=str, required=True, mutable=False)
    phone_number_extension_access: str = Field(type=str, required=True, mutable=False)
    service_access: str = Field(type=str, required=True, mutable=False)
    trunk_group_access: str = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyResponse16sp1(OCIResponse):
    """
    Response to ``GroupAdminGetPolicyRequest16sp1()``.

    Contains the policy settings for the group administrator.  Replaced by:
    ``GroupAdminGetPolicyRequest17()``

    Attributes:
        profile_access: profileAccess
        user_access: userAccess
        admin_access: adminAccess
        department_access: departmentAccess
        access_device_access: accessDeviceAccess
        enhanced_service_instance_access: enhancedServiceInstanceAccess
        feature_access_code_access: featureAccessCodeAccess
        phone_number_extension_access: phoneNumberExtensionAccess
        service_access: serviceAccess
        trunk_group_access: trunkGroupAccess
        session_admission_control_access: sessionAdmissionControlAccess
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "enhanced_service_instance_access", "enhancedServiceInstanceAccess", str,
            is_required=True,
        ),
        E("feature_access_code_access", "featureAccessCodeAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("trunk_group_access", "trunkGroupAccess", str, is_required=True),
        E(
            "session_admission_control_access", "sessionAdmissionControlAccess", str,
            is_required=True,
        ),
    )

    profile_access: str = Field(type=str, required=True, mutable=False)
    user_access: str = Field(type=str, required=True, mutable=False)
    admin_access: str = Field(type=str, required=True, mutable=False)
    department_access: str = Field(type=str, required=True, mutable=False)
    access_device_access: str = Field(type=str, required=True, mutable=False)
    enhanced_service_instance_access: str = Field(type=str, required=True, mutable=False)
    feature_access_code_access: str = Field(type=str, required=True, mutable=False)
    phone_number_extension_access: str = Field(type=str, required=True, mutable=False)
    service_access: str = Field(type=str, required=True, mutable=False)
    trunk_group_access: str = Field(type=str, required=True, mutable=False)
    session_admission_control_access: str = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyResponse16sp2(OCIResponse):
    """
    Response to ``GroupAdminGetPolicyRequest16sp2()``.

    Contains the policy settings for the group administrator.

    Attributes:
        profile_access: profileAccess
        user_access: userAccess
        admin_access: adminAccess
        department_access: departmentAccess
        access_device_access: accessDeviceAccess
        enhanced_service_instance_access: enhancedServiceInstanceAccess
        feature_access_code_access: featureAccessCodeAccess
        phone_number_extension_access: phoneNumberExtensionAccess
        calling_line_id_number_access: callingLineIdNumberAccess
        service_access: serviceAccess
        trunk_group_access: trunkGroupAccess
        session_admission_control_access: sessionAdmissionControlAccess
        dialable_caller_id_access: dialableCallerIDAccess
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "enhanced_service_instance_access", "enhancedServiceInstanceAccess", str,
            is_required=True,
        ),
        E("feature_access_code_access", "featureAccessCodeAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E(
            "calling_line_id_number_access", "callingLineIdNumberAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("trunk_group_access", "trunkGroupAccess", str, is_required=True),
        E(
            "session_admission_control_access", "sessionAdmissionControlAccess", str,
            is_required=True,
        ),
        E("dialable_caller_id_access", "dialableCallerIDAccess", str, is_required=True),
    )

    profile_access: str = Field(type=str, required=True, mutable=False)
    user_access: str = Field(type=str, required=True, mutable=False)
    admin_access: str = Field(type=str, required=True, mutable=False)
    department_access: str = Field(type=str, required=True, mutable=False)
    access_device_access: str = Field(type=str, required=True, mutable=False)
    enhanced_service_instance_access: str = Field(type=str, required=True, mutable=False)
    feature_access_code_access: str = Field(type=str, required=True, mutable=False)
    phone_number_extension_access: str = Field(type=str, required=True, mutable=False)
    calling_line_id_number_access: str = Field(type=str, required=True, mutable=False)
    service_access: str = Field(type=str, required=True, mutable=False)
    trunk_group_access: str = Field(type=str, required=True, mutable=False)
    session_admission_control_access: str = Field(type=str, required=True, mutable=False)
    dialable_caller_id_access: str = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyResponse17(OCIResponse):
    """
    Response to ``GroupAdminGetPolicyRequest17()``.

    Contains the policy settings for the group administrator.

    Attributes:
        profile_access: profileAccess
        user_access: userAccess
        admin_access: adminAccess
        department_access: departmentAccess
        access_device_access: accessDeviceAccess
        enhanced_service_instance_access: enhancedServiceInstanceAccess
        feature_access_code_access: featureAccessCodeAccess
        phone_number_extension_access: phoneNumberExtensionAccess
        calling_line_id_number_access: callingLineIdNumberAccess
        service_access: serviceAccess
        trunk_group_access: trunkGroupAccess
        session_admission_control_access: sessionAdmissionControlAccess
        office_zone_access: officeZoneAccess
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "enhanced_service_instance_access", "enhancedServiceInstanceAccess", str,
            is_required=True,
        ),
        E("feature_access_code_access", "featureAccessCodeAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E(
            "calling_line_id_number_access", "callingLineIdNumberAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("trunk_group_access", "trunkGroupAccess", str, is_required=True),
        E(
            "session_admission_control_access", "sessionAdmissionControlAccess", str,
            is_required=True,
        ),
        E("office_zone_access", "officeZoneAccess", str, is_required=True),
    )

    profile_access: str = Field(type=str, required=True, mutable=False)
    user_access: str = Field(type=str, required=True, mutable=False)
    admin_access: str = Field(type=str, required=True, mutable=False)
    department_access: str = Field(type=str, required=True, mutable=False)
    access_device_access: str = Field(type=str, required=True, mutable=False)
    enhanced_service_instance_access: str = Field(type=str, required=True, mutable=False)
    feature_access_code_access: str = Field(type=str, required=True, mutable=False)
    phone_number_extension_access: str = Field(type=str, required=True, mutable=False)
    calling_line_id_number_access: str = Field(type=str, required=True, mutable=False)
    service_access: str = Field(type=str, required=True, mutable=False)
    trunk_group_access: str = Field(type=str, required=True, mutable=False)
    session_admission_control_access: str = Field(type=str, required=True, mutable=False)
    office_zone_access: str = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyResponse17sp3(OCIResponse):
    """
    Response to ``GroupAdminGetPolicyRequest17sp3()``.

    Contains the policy settings for the group administrator.  The following elements are
    only used in AS data mode: dialableCallerIDAccess

    Attributes:
        profile_access: profileAccess
        user_access: userAccess
        admin_access: adminAccess
        department_access: departmentAccess
        access_device_access: accessDeviceAccess
        enhanced_service_instance_access: enhancedServiceInstanceAccess
        feature_access_code_access: featureAccessCodeAccess
        phone_number_extension_access: phoneNumberExtensionAccess
        calling_line_id_number_access: callingLineIdNumberAccess
        service_access: serviceAccess
        trunk_group_access: trunkGroupAccess
        session_admission_control_access: sessionAdmissionControlAccess
        office_zone_access: officeZoneAccess
        dialable_caller_id_access: dialableCallerIDAccess
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "enhanced_service_instance_access", "enhancedServiceInstanceAccess", str,
            is_required=True,
        ),
        E("feature_access_code_access", "featureAccessCodeAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E(
            "calling_line_id_number_access", "callingLineIdNumberAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("trunk_group_access", "trunkGroupAccess", str, is_required=True),
        E(
            "session_admission_control_access", "sessionAdmissionControlAccess", str,
            is_required=True,
        ),
        E("office_zone_access", "officeZoneAccess", str, is_required=True),
        E("dialable_caller_id_access", "dialableCallerIDAccess", str, is_required=True),
    )

    profile_access: str = Field(type=str, required=True, mutable=False)
    user_access: str = Field(type=str, required=True, mutable=False)
    admin_access: str = Field(type=str, required=True, mutable=False)
    department_access: str = Field(type=str, required=True, mutable=False)
    access_device_access: str = Field(type=str, required=True, mutable=False)
    enhanced_service_instance_access: str = Field(type=str, required=True, mutable=False)
    feature_access_code_access: str = Field(type=str, required=True, mutable=False)
    phone_number_extension_access: str = Field(type=str, required=True, mutable=False)
    calling_line_id_number_access: str = Field(type=str, required=True, mutable=False)
    service_access: str = Field(type=str, required=True, mutable=False)
    trunk_group_access: str = Field(type=str, required=True, mutable=False)
    session_admission_control_access: str = Field(type=str, required=True, mutable=False)
    office_zone_access: str = Field(type=str, required=True, mutable=False)
    dialable_caller_id_access: str = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyResponse18(OCIResponse):
    """
    Response to ``GroupAdminGetPolicyRequest18()``.

    Contains the policy settings for the group administrator.  The following elements are
    only used in AS data mode: dialableCallerIDAccess

    Attributes:
        profile_access: profileAccess
        user_access: userAccess
        admin_access: adminAccess
        department_access: departmentAccess
        access_device_access: accessDeviceAccess
        enhanced_service_instance_access: enhancedServiceInstanceAccess
        feature_access_code_access: featureAccessCodeAccess
        phone_number_extension_access: phoneNumberExtensionAccess
        calling_line_id_number_access: callingLineIdNumberAccess
        service_access: serviceAccess
        trunk_group_access: trunkGroupAccess
        session_admission_control_access: sessionAdmissionControlAccess
        office_zone_access: officeZoneAccess
        number_activation_access: numberActivationAccess
        dialable_caller_id_access: dialableCallerIDAccess
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "enhanced_service_instance_access", "enhancedServiceInstanceAccess", str,
            is_required=True,
        ),
        E("feature_access_code_access", "featureAccessCodeAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E(
            "calling_line_id_number_access", "callingLineIdNumberAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("trunk_group_access", "trunkGroupAccess", str, is_required=True),
        E(
            "session_admission_control_access", "sessionAdmissionControlAccess", str,
            is_required=True,
        ),
        E("office_zone_access", "officeZoneAccess", str, is_required=True),
        E("number_activation_access", "numberActivationAccess", str, is_required=True),
        E("dialable_caller_id_access", "dialableCallerIDAccess", str, is_required=True),
    )

    profile_access: str = Field(type=str, required=True, mutable=False)
    user_access: str = Field(type=str, required=True, mutable=False)
    admin_access: str = Field(type=str, required=True, mutable=False)
    department_access: str = Field(type=str, required=True, mutable=False)
    access_device_access: str = Field(type=str, required=True, mutable=False)
    enhanced_service_instance_access: str = Field(type=str, required=True, mutable=False)
    feature_access_code_access: str = Field(type=str, required=True, mutable=False)
    phone_number_extension_access: str = Field(type=str, required=True, mutable=False)
    calling_line_id_number_access: str = Field(type=str, required=True, mutable=False)
    service_access: str = Field(type=str, required=True, mutable=False)
    trunk_group_access: str = Field(type=str, required=True, mutable=False)
    session_admission_control_access: str = Field(type=str, required=True, mutable=False)
    office_zone_access: str = Field(type=str, required=True, mutable=False)
    number_activation_access: str = Field(type=str, required=True, mutable=False)
    dialable_caller_id_access: str = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyResponse19sp1(OCIResponse):
    """
    Response to ``GroupAdminGetPolicyRequest19sp1()``.

    Contains the policy settings for the group administrator.  The following elements are
    only used in AS data mode: dialableCallerIDAccess
    communicationBarringUserProfileAccess (This element will not be returned in the
    response for Service Provider group administrators)

    Attributes:
        profile_access: profileAccess
        user_access: userAccess
        admin_access: adminAccess
        department_access: departmentAccess
        access_device_access: accessDeviceAccess
        enhanced_service_instance_access: enhancedServiceInstanceAccess
        feature_access_code_access: featureAccessCodeAccess
        phone_number_extension_access: phoneNumberExtensionAccess
        calling_line_id_number_access: callingLineIdNumberAccess
        service_access: serviceAccess
        trunk_group_access: trunkGroupAccess
        session_admission_control_access: sessionAdmissionControlAccess
        office_zone_access: officeZoneAccess
        number_activation_access: numberActivationAccess
        dialable_caller_id_access: dialableCallerIDAccess
        communication_barring_user_profile_access: communicationBarringUserProfileAccess
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "enhanced_service_instance_access", "enhancedServiceInstanceAccess", str,
            is_required=True,
        ),
        E("feature_access_code_access", "featureAccessCodeAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E(
            "calling_line_id_number_access", "callingLineIdNumberAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("trunk_group_access", "trunkGroupAccess", str, is_required=True),
        E(
            "session_admission_control_access", "sessionAdmissionControlAccess", str,
            is_required=True,
        ),
        E("office_zone_access", "officeZoneAccess", str, is_required=True),
        E("number_activation_access", "numberActivationAccess", str, is_required=True),
        E("dialable_caller_id_access", "dialableCallerIDAccess", str, is_required=True),
        E(
            "communication_barring_user_profile_access",
            "communicationBarringUserProfileAccess", str,
        ),
    )

    profile_access: str = Field(type=str, required=True, mutable=False)
    user_access: str = Field(type=str, required=True, mutable=False)
    admin_access: str = Field(type=str, required=True, mutable=False)
    department_access: str = Field(type=str, required=True, mutable=False)
    access_device_access: str = Field(type=str, required=True, mutable=False)
    enhanced_service_instance_access: str = Field(type=str, required=True, mutable=False)
    feature_access_code_access: str = Field(type=str, required=True, mutable=False)
    phone_number_extension_access: str = Field(type=str, required=True, mutable=False)
    calling_line_id_number_access: str = Field(type=str, required=True, mutable=False)
    service_access: str = Field(type=str, required=True, mutable=False)
    trunk_group_access: str = Field(type=str, required=True, mutable=False)
    session_admission_control_access: str = Field(type=str, required=True, mutable=False)
    office_zone_access: str = Field(type=str, required=True, mutable=False)
    number_activation_access: str = Field(type=str, required=True, mutable=False)
    dialable_caller_id_access: str = Field(type=str, required=True, mutable=False)
    communication_barring_user_profile_access: str = Field(
        type=str, required=False, mutable=False,
    )


class GroupAdminGetPolicyResponse20(OCIResponse):
    """
    Response to ``GroupAdminGetPolicyRequest20()``.

    Contains the policy settings for the group administrator.  The following elements are
    only used in AS data mode: dialableCallerIDAccess verifyTranslationAndroutingAccess
    communicationBarringUserProfileAccess (This element is only returned for groups in an
    enterprise)

    Attributes:
        profile_access: profileAccess
        user_access: userAccess
        admin_access: adminAccess
        department_access: departmentAccess
        access_device_access: accessDeviceAccess
        enhanced_service_instance_access: enhancedServiceInstanceAccess
        feature_access_code_access: featureAccessCodeAccess
        phone_number_extension_access: phoneNumberExtensionAccess
        calling_line_id_number_access: callingLineIdNumberAccess
        service_access: serviceAccess
        trunk_group_access: trunkGroupAccess
        session_admission_control_access: sessionAdmissionControlAccess
        office_zone_access: officeZoneAccess
        number_activation_access: numberActivationAccess
        dialable_caller_id_access: dialableCallerIDAccess
        verify_translation_and_routing_access: verifyTranslationAndRoutingAccess
        communication_barring_user_profile_access: communicationBarringUserProfileAccess
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "enhanced_service_instance_access", "enhancedServiceInstanceAccess", str,
            is_required=True,
        ),
        E("feature_access_code_access", "featureAccessCodeAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E(
            "calling_line_id_number_access", "callingLineIdNumberAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("trunk_group_access", "trunkGroupAccess", str, is_required=True),
        E(
            "session_admission_control_access", "sessionAdmissionControlAccess", str,
            is_required=True,
        ),
        E("office_zone_access", "officeZoneAccess", str, is_required=True),
        E("number_activation_access", "numberActivationAccess", str, is_required=True),
        E("dialable_caller_id_access", "dialableCallerIDAccess", str, is_required=True),
        E(
            "verify_translation_and_routing_access", "verifyTranslationAndRoutingAccess",
            str, is_required=True,
        ),
        E(
            "communication_barring_user_profile_access",
            "communicationBarringUserProfileAccess", str,
        ),
    )

    profile_access: str = Field(type=str, required=True, mutable=False)
    user_access: str = Field(type=str, required=True, mutable=False)
    admin_access: str = Field(type=str, required=True, mutable=False)
    department_access: str = Field(type=str, required=True, mutable=False)
    access_device_access: str = Field(type=str, required=True, mutable=False)
    enhanced_service_instance_access: str = Field(type=str, required=True, mutable=False)
    feature_access_code_access: str = Field(type=str, required=True, mutable=False)
    phone_number_extension_access: str = Field(type=str, required=True, mutable=False)
    calling_line_id_number_access: str = Field(type=str, required=True, mutable=False)
    service_access: str = Field(type=str, required=True, mutable=False)
    trunk_group_access: str = Field(type=str, required=True, mutable=False)
    session_admission_control_access: str = Field(type=str, required=True, mutable=False)
    office_zone_access: str = Field(type=str, required=True, mutable=False)
    number_activation_access: str = Field(type=str, required=True, mutable=False)
    dialable_caller_id_access: str = Field(type=str, required=True, mutable=False)
    verify_translation_and_routing_access: str = Field(type=str, required=True, mutable=False)
    communication_barring_user_profile_access: str = Field(
        type=str, required=False, mutable=False,
    )


class GroupAdminGetResponse(OCIResponse):
    """
    Response to the ``GroupAdminGetRequest()``.

    The response contains the group administrators profile information.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        first_name: firstName
        last_name: lastName
        language: language
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("first_name", "firstName", str),
        E("last_name", "lastName", str),
        E("language", "language", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    first_name: str = Field(type=str, required=False, mutable=False)
    last_name: str = Field(type=str, required=False, mutable=False)
    language: str = Field(type=str, required=True, mutable=False)


class GroupAdviceOfChargeGetResponse(OCIResponse):
    """
    Response to ``GroupAdviceOfChargeGetRequest()``.

    Contains a list of Advice of Charge group parameters.

    Attributes:
        use_group_level_ao_c_settings: useGroupLevelAoCSettings
        delay_between_notification_seconds: delayBetweenNotificationSeconds
    """

    _ELEMENTS = (
        E(
            "use_group_level_ao_c_settings", "useGroupLevelAoCSettings", bool,
            is_required=True,
        ),
        E(
            "delay_between_notification_seconds", "delayBetweenNotificationSeconds", int,
            is_required=True,
        ),
    )

    use_group_level_ao_c_settings: bool = Field(type=bool, required=True, mutable=False)
    delay_between_notification_seconds: int = Field(type=int, required=True, mutable=False)


class GroupAnnouncementFileGetListResponse(OCIResponse):
    """
    Response to ``GroupAnnouncementFileGetAvailableListRequest()``.

    When requested, the response contains a table with columns: "Name", "Media Type" and
    "File Size". The "Name" column contains the name of the announcement file.  The "Media
    Type" column contains the media type of the announcement File with the possible
    values: WMA - Windows Media Audio file WAV - A WAV file 3GP - A 3GP file MOV - A MOV
    file using a H.263 or H.264 codec.  The "File Size" column contains the file size (KB)
    of the announcement file.

    The response also contains the current total file size (KB) for the group across all
    media types and the maximum total file size (MB) allowed for the group.

    Attributes:
        announcement_table: announcementTable
        total_file_size: totalFileSize
        max_file_size: maxFileSize
    """

    _ELEMENTS = (
        E("announcement_table", "announcementTable", list, is_complex=True, is_table=True),
        E("total_file_size", "totalFileSize", int, is_required=True),
        E("max_file_size", "maxFileSize", int, is_required=True),
    )

    announcement_table: "list" = Field(type=list, required=False, mutable=False)
    total_file_size: int = Field(type=int, required=True, mutable=False)
    max_file_size: int = Field(type=int, required=True, mutable=False)


class GroupAnnouncementFileGetResponse(OCIResponse):
    """
    Response to ``GroupAnnouncementFileGetRequest()``.

    The response contains the file size, uploaded timestamp, description and usage for an
    announcement file in the user announcement repository.  The usage table has columns
    "Service Name", and "Instance Name". The Service Name values correspond to string
    values of the GroupService and UserService data types.  With the exception of the
    string "Voice Portal" which is returned when the announcement is being used by Voice
    Portal Personalized Name.

    Attributes:
        description: description
        filesize: filesize
        last_uploaded: lastUploaded
        usage_table: usageTable
    """

    _ELEMENTS = (
        E("description", "description", str, is_required=True),
        E("filesize", "filesize", int, is_required=True),
        E("last_uploaded", "lastUploaded", str, is_required=True),
        E(
            "usage_table", "usageTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    description: str = Field(type=str, required=True, mutable=False)
    filesize: int = Field(type=int, required=True, mutable=False)
    last_uploaded: str = Field(type=str, required=True, mutable=False)
    usage_table: "list" = Field(type=list, required=True, mutable=False)


class GroupApplicationServerSetGetResponse(OCIResponse):
    """
    Response to the ``GroupApplicationServerSetGetRequest()``.

    The response contains the group's Application Server set information.

    Attributes:
        application_server_set_name: applicationServerSetName
    """

    _ELEMENTS = (
        E("application_server_set_name", "applicationServerSetName", str),
    )

    application_server_set_name: str = Field(type=str, required=False, mutable=False)


class GroupAutoAttendantGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupAutoAttendantGetInstanceListRequest()``.

    Contains a table with column headings: "Service User Id", "Name", "Video", "Phone
    Number", "Extension", "Department", "Is Active", "Type". The column values for "Video"
    and "Is Active" can either be true, or false.  The column values for "Type" can either
    be Basic or Standard.  In HSS Mode the value for the "Type" column will always be
    populated with Basic.

    Attributes:
        auto_attendant_table: autoAttendantTable
    """

    _ELEMENTS = (
        E(
            "auto_attendant_table", "autoAttendantTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    auto_attendant_table: "list" = Field(type=list, required=True, mutable=False)


class GroupAutoAttendantSubmenuGetListResponse(OCIResponse):
    """
    Response to the ``GroupAutoAttendantSubmenuGetListRequest()``.

    Contains a table with column headings: "Submenu Id" "Is Used". The column values for
    "Is Used" can either be true, or false.

    Attributes:
        submenu_table: submenuTable
    """

    _ELEMENTS = (
        E(
            "submenu_table", "submenuTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    submenu_table: "list" = Field(type=list, required=True, mutable=False)


class GroupAutoAttendantSubmenuGetUsageListResponse(OCIResponse):
    """
    Response to the ``GroupAutoAttendantSubmenuGetUsageListRequest()``.

    Contains a table with column headings: "Type" and "Submenu ID". The "Type" Column will
    contain one of the following: Business Hours Menu, After Hours Menu, Holiday Menu or
    Submenu.  The "Submenu ID" Column will be left blank when the "Type" Column contains
    one of the base menu types (Business Hours Menu, After Hours Menu or Holiday Menu),
    and will contain the Submenu ID when the "Type" Column contains type Submenu.

    Attributes:
        submenu_table: submenuTable
    """

    _ELEMENTS = (
        E(
            "submenu_table", "submenuTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    submenu_table: "list" = Field(type=list, required=True, mutable=False)


class GroupBroadWorksAnywhereGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupBroadWorksAnywhereGetInstanceListRequest()``.

    Contains a table with column headings: "Service User Id", "Name", "Phone Number",
    "Extension", "Department", "Is Active". The column value for "Is Active" can either be
    true, or false.

    Attributes:
        broad_works_anywhere_table: broadWorksAnywhereTable
    """

    _ELEMENTS = (
        E(
            "broad_works_anywhere_table", "broadWorksAnywhereTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    broad_works_anywhere_table: "list" = Field(type=list, required=True, mutable=False)


class GroupBroadWorksMobileManagerGetDomainListResponse(OCIResponse):
    """
    Response to the ``GroupBroadWorksMobileManagerGetDomainListRequest()``.

    Contains the list of domains.

    Attributes:
        domain_name: domainName
    """

    _ELEMENTS = (
        E("domain_name", "domainName", str, is_array=True),
    )

    domain_name: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupBroadWorksMobileManagerGetHomeZoneListResponse(OCIResponse):
    """
    Response to the ``GroupBroadWorksMobileManagerGetHomeZoneListRequest()``.

    Contains a table with column headings: "Home Zone Id", "Domain Name", "Mobile Country
    Code", "Mobile Network Code", "Local Area Code" and "Cell Identity".

    Attributes:
        home_zones_table: homeZonesTable
    """

    _ELEMENTS = (
        E(
            "home_zones_table", "homeZonesTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    home_zones_table: "list" = Field(type=list, required=True, mutable=False)


class GroupBroadWorksMobileManagerGetHomeZoneResponse(OCIResponse):
    """
    Response to the ``GroupBroadWorksMobileManagerGetHomeZoneRequest()``

    Attributes:
        home_zone_domain_name: homeZoneDomainName
        mobile_country_code: mobileCountryCode
        mobile_network_code: mobileNetworkCode
        location_area_code: locationAreaCode
        cell_identity: cellIdentity
    """

    _ELEMENTS = (
        E("home_zone_domain_name", "homeZoneDomainName", str, is_required=True),
        E("mobile_country_code", "mobileCountryCode", str, is_required=True),
        E("mobile_network_code", "mobileNetworkCode", str, is_required=True),
        E("location_area_code", "locationAreaCode", str, is_required=True),
        E("cell_identity", "cellIdentity", str, is_required=True),
    )

    home_zone_domain_name: str = Field(type=str, required=True, mutable=False)
    mobile_country_code: str = Field(type=str, required=True, mutable=False)
    mobile_network_code: str = Field(type=str, required=True, mutable=False)
    location_area_code: str = Field(type=str, required=True, mutable=False)
    cell_identity: str = Field(type=str, required=True, mutable=False)


class GroupBroadWorksMobileManagerGetResponse(OCIResponse):
    """
    Response to the ``GroupBroadWorksMobileManagerGetRequest()``

    Attributes:
        mobile_manager_id: mobileManagerId
        name: name
        is_active: isActive
        local_to_carrier: localToCarrier
        deactivation_reason: deactivationReason
        max_tx_per_second_enabled: maxTxPerSecondEnabled
        max_tx_per_second: maxTxPerSecond
        tldn_enabled: tldnEnabled
        generic_number_enabled: genericNumberEnabled
        mobile_state_check_enabled: mobileStateCheckEnabled
        location_based_services_enabled: locationBasedServicesEnabled
    """

    _ELEMENTS = (
        E("mobile_manager_id", "mobileManagerId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
        E("local_to_carrier", "localToCarrier", bool, is_required=True),
        E("deactivation_reason", "deactivationReason", str),
        E("max_tx_per_second_enabled", "maxTxPerSecondEnabled", bool, is_required=True),
        E("max_tx_per_second", "maxTxPerSecond", int),
        E("tldn_enabled", "tldnEnabled", bool, is_required=True),
        E("generic_number_enabled", "genericNumberEnabled", bool, is_required=True),
        E("mobile_state_check_enabled", "mobileStateCheckEnabled", bool, is_required=True),
        E(
            "location_based_services_enabled", "locationBasedServicesEnabled", bool,
            is_required=True,
        ),
    )

    mobile_manager_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=True, mutable=False)
    local_to_carrier: bool = Field(type=bool, required=True, mutable=False)
    deactivation_reason: str = Field(type=str, required=False, mutable=False)
    max_tx_per_second_enabled: bool = Field(type=bool, required=True, mutable=False)
    max_tx_per_second: int = Field(type=int, required=False, mutable=False)
    tldn_enabled: bool = Field(type=bool, required=True, mutable=False)
    generic_number_enabled: bool = Field(type=bool, required=True, mutable=False)
    mobile_state_check_enabled: bool = Field(type=bool, required=True, mutable=False)
    location_based_services_enabled: bool = Field(type=bool, required=True, mutable=False)


class GroupBroadWorksMobilityGetResponse(OCIResponse):
    """
    The response to a ``GroupBroadWorksMobilityGetRequest()``.


    Attributes:
        use_setting_level: useSettingLevel
        enable_location_services: enableLocationServices
        enable_msrn_lookup: enableMSRNLookup
        enable_mobile_state_checking: enableMobileStateChecking
        deny_call_originations: denyCallOriginations
        deny_call_terminations: denyCallTerminations
    """

    _ELEMENTS = (
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("enable_location_services", "enableLocationServices", bool, is_required=True),
        E("enable_msrn_lookup", "enableMSRNLookup", bool, is_required=True),
        E(
            "enable_mobile_state_checking", "enableMobileStateChecking", bool,
            is_required=True,
        ),
        E("deny_call_originations", "denyCallOriginations", bool, is_required=True),
        E("deny_call_terminations", "denyCallTerminations", bool, is_required=True),
    )

    use_setting_level: str = Field(type=str, required=True, mutable=False)
    enable_location_services: bool = Field(type=bool, required=True, mutable=False)
    enable_msrn_lookup: bool = Field(type=bool, required=True, mutable=False)
    enable_mobile_state_checking: bool = Field(type=bool, required=True, mutable=False)
    deny_call_originations: bool = Field(type=bool, required=True, mutable=False)
    deny_call_terminations: bool = Field(type=bool, required=True, mutable=False)


class GroupBroadWorksMobilityGetResponse19sp1(OCIResponse):
    """
    The response to a ``GroupBroadWorksMobilityGetRequest19sp1()``.


    Attributes:
        use_setting_level: useSettingLevel
        enable_location_services: enableLocationServices
        enable_msrn_lookup: enableMSRNLookup
        enable_mobile_state_checking: enableMobileStateChecking
        deny_call_originations: denyCallOriginations
        deny_call_terminations: denyCallTerminations
        enable_announcement_suppression: enableAnnouncementSuppression
    """

    _ELEMENTS = (
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("enable_location_services", "enableLocationServices", bool, is_required=True),
        E("enable_msrn_lookup", "enableMSRNLookup", bool, is_required=True),
        E(
            "enable_mobile_state_checking", "enableMobileStateChecking", bool,
            is_required=True,
        ),
        E("deny_call_originations", "denyCallOriginations", bool, is_required=True),
        E("deny_call_terminations", "denyCallTerminations", bool, is_required=True),
        E(
            "enable_announcement_suppression", "enableAnnouncementSuppression", bool,
            is_required=True,
        ),
    )

    use_setting_level: str = Field(type=str, required=True, mutable=False)
    enable_location_services: bool = Field(type=bool, required=True, mutable=False)
    enable_msrn_lookup: bool = Field(type=bool, required=True, mutable=False)
    enable_mobile_state_checking: bool = Field(type=bool, required=True, mutable=False)
    deny_call_originations: bool = Field(type=bool, required=True, mutable=False)
    deny_call_terminations: bool = Field(type=bool, required=True, mutable=False)
    enable_announcement_suppression: bool = Field(type=bool, required=True, mutable=False)


class GroupBroadWorksMobilityMobileSubscriberDirectoryNumberGetAssignmentListResponse(OCIResponse):
    """
    Response to the
    ``GroupBroadWorksMobilityMobileSubscriberDirectoryNumberGetAssignmentListRequest()``.

    The response contains a table with columns: "Mobile Number", "User Id", "Last Name",
    "First Name","Phone Number", "Extension", "Department",. The "Mobile Number" column
    contains a single DN. The "User Id", "Last Name" and "First Name" columns contains the
    corresponding attributes of the user possessing the DN(s). The "Phone Number" column
    contains a single DN. The "Department" column contains the department of the user if
    it is part of a department.

    Attributes:
        mobile_subscriber_directory_number_table: mobileSubscriberDirectoryNumberTable
    """

    _ELEMENTS = (
        E(
            "mobile_subscriber_directory_number_table",
            "mobileSubscriberDirectoryNumberTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    mobile_subscriber_directory_number_table: "list" = Field(
        type=list, required=True, mutable=False,
    )


class GroupBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListResponse(OCIResponse):
    """
    Response to
    ``GroupBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest()``.

    Contains a list of available Mobile Subscriber Directory Numbers not yet assigned to
    any user.

    Attributes:
        mobile_subscriber_directory_number: mobileSubscriberDirectoryNumber
    """

    _ELEMENTS = (
        E(
            "mobile_subscriber_directory_number", "mobileSubscriberDirectoryNumber", str,
            is_array=True,
        ),
    )

    mobile_subscriber_directory_number: "List[str]" = Field(
        type=list, required=False, mutable=False,
    )


class GroupCallCapacityManagementGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupCallCapacityManagementGetAvailableUserListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCapacityManagementGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupCallCapacityManagementGetInstanceListRequest()``.

    Contains a table with column headings: "Name", "Is Default", "Maximum Calls", "Maximum
    Incoming Calls", "Maximum Outgoing Calls".

    Attributes:
        call_capacity_group_table: callCapacityGroupTable
    """

    _ELEMENTS = (
        E(
            "call_capacity_group_table", "callCapacityGroupTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    call_capacity_group_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCapacityManagementGetInstanceResponse(OCIResponse):
    """
    Response to the ``GroupCallCapacityManagementGetInstanceRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        name: name
        max_active_calls_allowed: maxActiveCallsAllowed
        max_incoming_active_calls_allowed: maxIncomingActiveCallsAllowed
        max_outgoing_active_calls_allowed: maxOutgoingActiveCallsAllowed
        default_group_for_new_users: defaultGroupForNewUsers
        user_table: userTable
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("max_active_calls_allowed", "maxActiveCallsAllowed", int, is_required=True),
        E("max_incoming_active_calls_allowed", "maxIncomingActiveCallsAllowed", int),
        E("max_outgoing_active_calls_allowed", "maxOutgoingActiveCallsAllowed", int),
        E("default_group_for_new_users", "defaultGroupForNewUsers", bool, is_required=True),
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    name: str = Field(type=str, required=True, mutable=False)
    max_active_calls_allowed: int = Field(type=int, required=True, mutable=False)
    max_incoming_active_calls_allowed: int = Field(type=int, required=False, mutable=False)
    max_outgoing_active_calls_allowed: int = Field(type=int, required=False, mutable=False)
    default_group_for_new_users: bool = Field(type=bool, required=True, mutable=False)
    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCenterAgentThresholdDefaultProfileGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterAgentThresholdDefaultProfileGetRequest()``.

    The agent table contains the agents assigned to the profile and has column headings:
    "User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address";

    Attributes:
        profile_name: profileName
        profile_description: profileDescription
        threshold_current_call_state_idle_time_yellow:
            thresholdCurrentCallStateIdleTimeYellow
        threshold_current_call_state_idle_time_red: thresholdCurrentCallStateIdleTimeRed
        threshold_current_call_state_on_call_time_yellow:
            thresholdCurrentCallStateOnCallTimeYellow
        threshold_current_call_state_on_call_time_red:
            thresholdCurrentCallStateOnCallTimeRed
        threshold_current_agent_state_unavailable_time_yellow:
            thresholdCurrentAgentStateUnavailableTimeYellow
        threshold_current_agent_state_unavailable_time_red:
            thresholdCurrentAgentStateUnavailableTimeRed
        threshold_average_busy_in_time_yellow: thresholdAverageBusyInTimeYellow
        threshold_average_busy_in_time_red: thresholdAverageBusyInTimeRed
        threshold_average_busy_out_time_yellow: thresholdAverageBusyOutTimeYellow
        threshold_average_busy_out_time_red: thresholdAverageBusyOutTimeRed
        threshold_average_wrap_up_time_yellow: thresholdAverageWrapUpTimeYellow
        threshold_average_wrap_up_time_red: thresholdAverageWrapUpTimeRed
        enable_notification_email: enableNotificationEmail
        notification_email_address: notificationEmailAddress
        agent_table: agentTable
    """

    _ELEMENTS = (
        E("profile_name", "profileName", str, is_required=True),
        E("profile_description", "profileDescription", str),
        E(
            "threshold_current_call_state_idle_time_yellow",
            "thresholdCurrentCallStateIdleTimeYellow", int,
        ),
        E(
            "threshold_current_call_state_idle_time_red",
            "thresholdCurrentCallStateIdleTimeRed", int,
        ),
        E(
            "threshold_current_call_state_on_call_time_yellow",
            "thresholdCurrentCallStateOnCallTimeYellow", int,
        ),
        E(
            "threshold_current_call_state_on_call_time_red",
            "thresholdCurrentCallStateOnCallTimeRed", int,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_yellow",
            "thresholdCurrentAgentStateUnavailableTimeYellow", int,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_red",
            "thresholdCurrentAgentStateUnavailableTimeRed", int,
        ),
        E("threshold_average_busy_in_time_yellow", "thresholdAverageBusyInTimeYellow", int),
        E("threshold_average_busy_in_time_red", "thresholdAverageBusyInTimeRed", int),
        E("threshold_average_busy_out_time_yellow", "thresholdAverageBusyOutTimeYellow", int),
        E("threshold_average_busy_out_time_red", "thresholdAverageBusyOutTimeRed", int),
        E("threshold_average_wrap_up_time_yellow", "thresholdAverageWrapUpTimeYellow", int),
        E("threshold_average_wrap_up_time_red", "thresholdAverageWrapUpTimeRed", int),
        E("enable_notification_email", "enableNotificationEmail", bool, is_required=True),
        E("notification_email_address", "notificationEmailAddress", str),
        E("agent_table", "agentTable", list, is_complex=True, is_table=True),
    )

    profile_name: str = Field(type=str, required=True, mutable=False)
    profile_description: str = Field(type=str, required=False, mutable=False)
    threshold_current_call_state_idle_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_call_state_idle_time_red: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_call_state_on_call_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_call_state_on_call_time_red: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_agent_state_unavailable_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_agent_state_unavailable_time_red: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_busy_in_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_busy_in_time_red: int = Field(type=int, required=False, mutable=False)
    threshold_average_busy_out_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_busy_out_time_red: int = Field(type=int, required=False, mutable=False)
    threshold_average_wrap_up_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_wrap_up_time_red: int = Field(type=int, required=False, mutable=False)
    enable_notification_email: bool = Field(type=bool, required=True, mutable=False)
    notification_email_address: str = Field(type=str, required=False, mutable=False)
    agent_table: "list" = Field(type=list, required=False, mutable=False)


class GroupCallCenterAgentThresholdProfileGetAvailableAgentListResponse(OCIResponse):
    """
    Response to the
    ``GroupCallCenterAgentThresholdProfileGetAvailableAgentListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address", "Agent Threshold Profile";

    Attributes:
        agent_table: agentTable
    """

    _ELEMENTS = (
        E(
            "agent_table", "agentTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    agent_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCenterAgentThresholdProfileGetListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterAgentThresholdProfileGetListRequest()``.

    Contains a table with all the Call Center Agent Threshold Profiles in the Group.  The
    column headings are: "Default", "Name", "Description".

    Attributes:
        profiles_table: profilesTable
    """

    _ELEMENTS = (
        E(
            "profiles_table", "profilesTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    profiles_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCenterAgentThresholdProfileGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterAgentThresholdProfileGetRequest()``.

    The agentTable contains the agents assigned to the profile and has the column
    headings: "User Id", "Group Id", "Last Name", "First Name", "Hiragana Last Name",
    "Hiragana First Name", "Phone Number", "Extension", "Department", "Email Address";

    Attributes:
        profile_description: profileDescription
        threshold_current_call_state_idle_time_yellow:
            thresholdCurrentCallStateIdleTimeYellow
        threshold_current_call_state_idle_time_red: thresholdCurrentCallStateIdleTimeRed
        threshold_current_call_state_on_call_time_yellow:
            thresholdCurrentCallStateOnCallTimeYellow
        threshold_current_call_state_on_call_time_red:
            thresholdCurrentCallStateOnCallTimeRed
        threshold_current_agent_state_unavailable_time_yellow:
            thresholdCurrentAgentStateUnavailableTimeYellow
        threshold_current_agent_state_unavailable_time_red:
            thresholdCurrentAgentStateUnavailableTimeRed
        threshold_average_busy_in_time_yellow: thresholdAverageBusyInTimeYellow
        threshold_average_busy_in_time_red: thresholdAverageBusyInTimeRed
        threshold_average_busy_out_time_yellow: thresholdAverageBusyOutTimeYellow
        threshold_average_busy_out_time_red: thresholdAverageBusyOutTimeRed
        threshold_average_wrap_up_time_yellow: thresholdAverageWrapUpTimeYellow
        threshold_average_wrap_up_time_red: thresholdAverageWrapUpTimeRed
        enable_notification_email: enableNotificationEmail
        notification_email_address: notificationEmailAddress
        agent_table: agentTable
    """

    _ELEMENTS = (
        E("profile_description", "profileDescription", str),
        E(
            "threshold_current_call_state_idle_time_yellow",
            "thresholdCurrentCallStateIdleTimeYellow", int,
        ),
        E(
            "threshold_current_call_state_idle_time_red",
            "thresholdCurrentCallStateIdleTimeRed", int,
        ),
        E(
            "threshold_current_call_state_on_call_time_yellow",
            "thresholdCurrentCallStateOnCallTimeYellow", int,
        ),
        E(
            "threshold_current_call_state_on_call_time_red",
            "thresholdCurrentCallStateOnCallTimeRed", int,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_yellow",
            "thresholdCurrentAgentStateUnavailableTimeYellow", int,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_red",
            "thresholdCurrentAgentStateUnavailableTimeRed", int,
        ),
        E("threshold_average_busy_in_time_yellow", "thresholdAverageBusyInTimeYellow", int),
        E("threshold_average_busy_in_time_red", "thresholdAverageBusyInTimeRed", int),
        E("threshold_average_busy_out_time_yellow", "thresholdAverageBusyOutTimeYellow", int),
        E("threshold_average_busy_out_time_red", "thresholdAverageBusyOutTimeRed", int),
        E("threshold_average_wrap_up_time_yellow", "thresholdAverageWrapUpTimeYellow", int),
        E("threshold_average_wrap_up_time_red", "thresholdAverageWrapUpTimeRed", int),
        E("enable_notification_email", "enableNotificationEmail", bool, is_required=True),
        E("notification_email_address", "notificationEmailAddress", str),
        E(
            "agent_table", "agentTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    profile_description: str = Field(type=str, required=False, mutable=False)
    threshold_current_call_state_idle_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_call_state_idle_time_red: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_call_state_on_call_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_call_state_on_call_time_red: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_agent_state_unavailable_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_agent_state_unavailable_time_red: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_busy_in_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_busy_in_time_red: int = Field(type=int, required=False, mutable=False)
    threshold_average_busy_out_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_busy_out_time_red: int = Field(type=int, required=False, mutable=False)
    threshold_average_wrap_up_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_wrap_up_time_red: int = Field(type=int, required=False, mutable=False)
    enable_notification_email: bool = Field(type=bool, required=True, mutable=False)
    notification_email_address: str = Field(type=str, required=False, mutable=False)
    agent_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCenterAgentUnavailableCodeGetListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterAgentUnavailableCodeGetListRequest()``.

    Contains a table with column headings: "Is Active", "Code", "Description".

    Attributes:
        unavailable_codes_table: unavailableCodesTable
    """

    _ELEMENTS = (
        E(
            "unavailable_codes_table", "unavailableCodesTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    unavailable_codes_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCenterAgentUnavailableCodeGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterAgentUnavailableCodeGetRequest()``

    Attributes:
        is_active: isActive
        description: description
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("description", "description", str),
    )

    is_active: bool = Field(type=bool, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class GroupCallCenterAgentUnavailableCodeSettingsGetResponse(OCIResponse):
    """
    Response to ``GroupCallCenterAgentUnavailableCodeSettingsGetRequest()``.

    Replaced by ``GroupCallCenterAgentUnavailableCodeSettingsGetResponse17sp4()``.

    Attributes:
        enable_agent_unavailable_codes: enableAgentUnavailableCodes
        default_agent_unavailable_code_on_dnd: defaultAgentUnavailableCodeOnDND
        default_agent_unavailable_code_on_personal_calls:
            defaultAgentUnavailableCodeOnPersonalCalls
        default_agent_unavailable_code_on_consecutive_bounces:
            defaultAgentUnavailableCodeOnConsecutiveBounces
        force_use_of_agent_unavailable_codes: forceUseOfAgentUnavailableCodes
        default_agent_unavailable_code: defaultAgentUnavailableCode
    """

    _ELEMENTS = (
        E(
            "enable_agent_unavailable_codes", "enableAgentUnavailableCodes", bool,
            is_required=True,
        ),
        E("default_agent_unavailable_code_on_dnd", "defaultAgentUnavailableCodeOnDND", str),
        E(
            "default_agent_unavailable_code_on_personal_calls",
            "defaultAgentUnavailableCodeOnPersonalCalls", str,
        ),
        E(
            "default_agent_unavailable_code_on_consecutive_bounces",
            "defaultAgentUnavailableCodeOnConsecutiveBounces", str,
        ),
        E(
            "force_use_of_agent_unavailable_codes", "forceUseOfAgentUnavailableCodes",
            bool, is_required=True,
        ),
        E("default_agent_unavailable_code", "defaultAgentUnavailableCode", str),
    )

    enable_agent_unavailable_codes: bool = Field(type=bool, required=True, mutable=False)
    default_agent_unavailable_code_on_dnd: str = Field(
        type=str, required=False, mutable=False,
    )
    default_agent_unavailable_code_on_personal_calls: str = Field(
        type=str, required=False, mutable=False,
    )
    default_agent_unavailable_code_on_consecutive_bounces: str = Field(
        type=str, required=False, mutable=False,
    )
    force_use_of_agent_unavailable_codes: bool = Field(
        type=bool, required=True, mutable=False,
    )
    default_agent_unavailable_code: str = Field(type=str, required=False, mutable=False)


class GroupCallCenterAgentUnavailableCodeSettingsGetResponse17sp4(OCIResponse):
    """
    Response to ``GroupCallCenterAgentUnavailableCodeSettingsGetRequest17sp4()``.


    Attributes:
        enable_agent_unavailable_codes: enableAgentUnavailableCodes
        default_agent_unavailable_code_on_dnd: defaultAgentUnavailableCodeOnDND
        default_agent_unavailable_code_on_personal_calls:
            defaultAgentUnavailableCodeOnPersonalCalls
        default_agent_unavailable_code_on_consecutive_bounces:
            defaultAgentUnavailableCodeOnConsecutiveBounces
        default_agent_unavailable_code_on_not_reachable:
            defaultAgentUnavailableCodeOnNotReachable
        force_use_of_agent_unavailable_codes: forceUseOfAgentUnavailableCodes
        default_agent_unavailable_code: defaultAgentUnavailableCode
    """

    _ELEMENTS = (
        E(
            "enable_agent_unavailable_codes", "enableAgentUnavailableCodes", bool,
            is_required=True,
        ),
        E("default_agent_unavailable_code_on_dnd", "defaultAgentUnavailableCodeOnDND", str),
        E(
            "default_agent_unavailable_code_on_personal_calls",
            "defaultAgentUnavailableCodeOnPersonalCalls", str,
        ),
        E(
            "default_agent_unavailable_code_on_consecutive_bounces",
            "defaultAgentUnavailableCodeOnConsecutiveBounces", str,
        ),
        E(
            "default_agent_unavailable_code_on_not_reachable",
            "defaultAgentUnavailableCodeOnNotReachable", str,
        ),
        E(
            "force_use_of_agent_unavailable_codes", "forceUseOfAgentUnavailableCodes",
            bool, is_required=True,
        ),
        E("default_agent_unavailable_code", "defaultAgentUnavailableCode", str),
    )

    enable_agent_unavailable_codes: bool = Field(type=bool, required=True, mutable=False)
    default_agent_unavailable_code_on_dnd: str = Field(
        type=str, required=False, mutable=False,
    )
    default_agent_unavailable_code_on_personal_calls: str = Field(
        type=str, required=False, mutable=False,
    )
    default_agent_unavailable_code_on_consecutive_bounces: str = Field(
        type=str, required=False, mutable=False,
    )
    default_agent_unavailable_code_on_not_reachable: str = Field(
        type=str, required=False, mutable=False,
    )
    force_use_of_agent_unavailable_codes: bool = Field(
        type=bool, required=True, mutable=False,
    )
    default_agent_unavailable_code: str = Field(type=str, required=False, mutable=False)


class GroupCallCenterBouncedCallGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterBouncedCallGetRequest()``.


    Attributes:
        is_active: isActive
        number_of_rings_before_bouncing_call: numberOfRingsBeforeBouncingCall
        enable_transfer: enableTransfer
        transfer_phone_number: transferPhoneNumber
        bounce_call_when_agent_unavailable: bounceCallWhenAgentUnavailable
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E(
            "number_of_rings_before_bouncing_call", "numberOfRingsBeforeBouncingCall",
            int, is_required=True,
        ),
        E("enable_transfer", "enableTransfer", bool),
        E("transfer_phone_number", "transferPhoneNumber", str),
        E(
            "bounce_call_when_agent_unavailable", "bounceCallWhenAgentUnavailable", bool,
            is_required=True,
        ),
    )

    is_active: bool = Field(type=bool, required=True, mutable=False)
    number_of_rings_before_bouncing_call: int = Field(type=int, required=True, mutable=False)
    enable_transfer: bool = Field(type=bool, required=False, mutable=False)
    transfer_phone_number: str = Field(type=str, required=False, mutable=False)
    bounce_call_when_agent_unavailable: bool = Field(type=bool, required=True, mutable=False)


class GroupCallCenterBouncedCallGetResponse17(OCIResponse):
    """
    Response to the ``GroupCallCenterBouncedCallGetRequest17()``.


    Attributes:
        is_active: isActive
        number_of_rings_before_bouncing_call: numberOfRingsBeforeBouncingCall
        enable_transfer: enableTransfer
        transfer_phone_number: transferPhoneNumber
        bounce_call_when_agent_unavailable: bounceCallWhenAgentUnavailable
        alert_call_center_call_on_hold: alertCallCenterCallOnHold
        alert_call_center_call_on_hold_seconds: alertCallCenterCallOnHoldSeconds
        bounce_call_center_call_on_hold: bounceCallCenterCallOnHold
        bounce_call_center_call_on_hold_seconds: bounceCallCenterCallOnHoldSeconds
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E(
            "number_of_rings_before_bouncing_call", "numberOfRingsBeforeBouncingCall",
            int, is_required=True,
        ),
        E("enable_transfer", "enableTransfer", bool),
        E("transfer_phone_number", "transferPhoneNumber", str),
        E("bounce_call_when_agent_unavailable", "bounceCallWhenAgentUnavailable", bool),
        E("alert_call_center_call_on_hold", "alertCallCenterCallOnHold", bool),
        E("alert_call_center_call_on_hold_seconds", "alertCallCenterCallOnHoldSeconds", int),
        E("bounce_call_center_call_on_hold", "bounceCallCenterCallOnHold", bool),
        E(
            "bounce_call_center_call_on_hold_seconds",
            "bounceCallCenterCallOnHoldSeconds", int,
        ),
    )

    is_active: bool = Field(type=bool, required=True, mutable=False)
    number_of_rings_before_bouncing_call: int = Field(type=int, required=True, mutable=False)
    enable_transfer: bool = Field(type=bool, required=False, mutable=False)
    transfer_phone_number: str = Field(type=str, required=False, mutable=False)
    bounce_call_when_agent_unavailable: bool = Field(type=bool, required=False, mutable=False)
    alert_call_center_call_on_hold: bool = Field(type=bool, required=False, mutable=False)
    alert_call_center_call_on_hold_seconds: int = Field(
        type=int, required=False, mutable=False,
    )
    bounce_call_center_call_on_hold: bool = Field(type=bool, required=False, mutable=False)
    bounce_call_center_call_on_hold_seconds: int = Field(
        type=int, required=False, mutable=False,
    )


class GroupCallCenterCallDispositionCodeGetListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterCallDispositionCodeGetListRequest()``.

    Contains a table with column headings: "Is Active", "Code", "Description".

    Attributes:
        disposition_codes_table: dispositionCodesTable
    """

    _ELEMENTS = (
        E(
            "disposition_codes_table", "dispositionCodesTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    disposition_codes_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCenterCallDispositionCodeGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterCallDispositionCodeGetRequest()``

    Attributes:
        is_active: isActive
        description: description
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("description", "description", str),
    )

    is_active: bool = Field(type=bool, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class GroupCallCenterCallDispositionCodeGetUsageListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterCallDispositionCodeGetUsageListRequest()``.

    The Type column contains either "Call Center" or "Route Point". Contains a table with
    column headings: "Id", "Name" and "Type".

    Attributes:
        call_center_table: callCenterTable
    """

    _ELEMENTS = (
        E(
            "call_center_table", "callCenterTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    call_center_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCenterComfortMessageBypassGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterComfortMessageBypassGetRequest()``.


    Attributes:
        is_active: isActive
        call_waiting_age_threshold_seconds: callWaitingAgeThresholdSeconds
        play_announcement_after_ringing: playAnnouncementAfterRinging
        ring_time_before_playing_announcement_seconds:
            ringTimeBeforePlayingAnnouncementSeconds
        audio_message_selection: audioMessageSelection
        audio_file_url: audioFileUrl
        audio_file_description: audioFileDescription
        audio_media_type: audioMediaType
        video_message_selection: videoMessageSelection
        video_file_url: videoFileUrl
        video_file_description: videoFileDescription
        video_media_type: videoMediaType
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E(
            "call_waiting_age_threshold_seconds", "callWaitingAgeThresholdSeconds", int,
            is_required=True,
        ),
        E(
            "play_announcement_after_ringing", "playAnnouncementAfterRinging", bool,
            is_required=True,
        ),
        E(
            "ring_time_before_playing_announcement_seconds",
            "ringTimeBeforePlayingAnnouncementSeconds", int, is_required=True,
        ),
        E("audio_message_selection", "audioMessageSelection", str, is_required=True),
        E("audio_file_url", "audioFileUrl", str),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("video_message_selection", "videoMessageSelection", str, is_required=True),
        E("video_file_url", "videoFileUrl", str),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
    )

    is_active: bool = Field(type=bool, required=True, mutable=False)
    call_waiting_age_threshold_seconds: int = Field(type=int, required=True, mutable=False)
    play_announcement_after_ringing: bool = Field(type=bool, required=True, mutable=False)
    ring_time_before_playing_announcement_seconds: int = Field(
        type=int, required=True, mutable=False,
    )
    audio_message_selection: str = Field(type=str, required=True, mutable=False)
    audio_file_url: str = Field(type=str, required=False, mutable=False)
    audio_file_description: str = Field(type=str, required=False, mutable=False)
    audio_media_type: str = Field(type=str, required=False, mutable=False)
    video_message_selection: str = Field(type=str, required=True, mutable=False)
    video_file_url: str = Field(type=str, required=False, mutable=False)
    video_file_description: str = Field(type=str, required=False, mutable=False)
    video_media_type: str = Field(type=str, required=False, mutable=False)


class GroupCallCenterCurrentAndPastAgentGetListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterCurrentAndPastAgentGetListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        agent_user_table: agentUserTable
        deleted_agent_user_table: deletedAgentUserTable
    """

    _ELEMENTS = (
        E(
            "agent_user_table", "agentUserTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
        E(
            "deleted_agent_user_table", "deletedAgentUserTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    agent_user_table: "list" = Field(type=list, required=True, mutable=False)
    deleted_agent_user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCenterCurrentAndPastCallCenterGetListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterCurrentAndPastCallCenterGetListRequest()``.


    Attributes:
        service_user_id: serviceUserId
        deleted_service_user_id: deletedServiceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_array=True),
        E("deleted_service_user_id", "deletedServiceUserId", str, is_array=True),
    )

    service_user_id: "List[str]" = Field(type=list, required=False, mutable=False)
    deleted_service_user_id: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupCallCenterCurrentAndPastDNISGetListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterCurrentAndPastDNISGetListRequest()``.


    Attributes:
        name: name
        deleted_name: deletedName
    """

    _ELEMENTS = (
        E("name", "name", str, is_array=True),
        E("deleted_name", "deletedName", str, is_array=True),
    )

    name: "List[str]" = Field(type=list, required=False, mutable=False)
    deleted_name: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupCallCenterDistinctiveRingingGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterDistinctiveRingingGetRequest()``.


    Attributes:
        distinctive_ringing_call_center_calls: distinctiveRingingCallCenterCalls
        distinctive_ringing_ring_pattern_for_call_center:
            distinctiveRingingRingPatternForCallCenter
        distinctive_ringing_force_delivery_ring_pattern:
            distinctiveRingingForceDeliveryRingPattern
    """

    _ELEMENTS = (
        E(
            "distinctive_ringing_call_center_calls", "distinctiveRingingCallCenterCalls",
            bool, is_required=True,
        ),
        E(
            "distinctive_ringing_ring_pattern_for_call_center",
            "distinctiveRingingRingPatternForCallCenter", str, is_required=True,
        ),
        E(
            "distinctive_ringing_force_delivery_ring_pattern",
            "distinctiveRingingForceDeliveryRingPattern", str,
        ),
    )

    distinctive_ringing_call_center_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    distinctive_ringing_ring_pattern_for_call_center: str = Field(
        type=str, required=True, mutable=False,
    )
    distinctive_ringing_force_delivery_ring_pattern: str = Field(
        type=str, required=False, mutable=False,
    )


class GroupCallCenterEnhancedGetResponse(OCIResponse):
    """
    Response to ``GroupCallCenterEnhancedGetRequest()``.


    Attributes:
        override_agent_wrap_up_time: overrideAgentWrapUpTime
        wrap_up_seconds: wrapUpSeconds
    """

    _ELEMENTS = (
        E("override_agent_wrap_up_time", "overrideAgentWrapUpTime", bool, is_required=True),
        E("wrap_up_seconds", "wrapUpSeconds", int),
    )

    override_agent_wrap_up_time: bool = Field(type=bool, required=True, mutable=False)
    wrap_up_seconds: int = Field(type=int, required=False, mutable=False)


class GroupCallCenterEnhancedReportingBrandingGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterEnhancedReportingBrandingGetRequest()``.


    Attributes:
        branding_choice: brandingChoice
        branding_file_description: brandingFileDescription
    """

    _ELEMENTS = (
        E("branding_choice", "brandingChoice", str, is_required=True),
        E("branding_file_description", "brandingFileDescription", str),
    )

    branding_choice: str = Field(type=str, required=True, mutable=False)
    branding_file_description: str = Field(type=str, required=False, mutable=False)


class GroupCallCenterEnhancedReportingGetAvailableReportTemplateListResponse(OCIResponse):
    """
    Response to
    ``GroupCallCenterEnhancedReportingGetAvailableReportTemplateListRequest()``.

    Contains a table with column headings: "Name", "Description" and "Level", "Is Agent
    Required", "Is Call Center Required", "Is Call Center Dnis Required","Is Real Time
    Report", "Is Sampling Period Required", "Call Completion Threshold Parameter", "Short
    Duration Threshold Parameter", "Service Level Threshold Parameter", "Service Level
    Inclusions Parameter", "Service Level Objective Threshold Parameter", "Abandoned Call
    Threshold Parameter", "Service Level Threshold Parameter Number", and "Abandoned Call
    Threshold Parameter Number". The possible values for "Level" are "System" and "Group".
    The possible values for "Is Agent Required", "Is Call Center Required", "Is Call
    Center Dnis Required", "Is Real Time Report" and "Is Sampling Period Required" are
    "true" and "false". The possible values for "Call Completion Threshold Parameter",
    "Short Duration Threshold Parameter", "Service Level Threshold Parameter", "Service
    Level Inclusions Parameter","Service Level Objective Threshold Parameter" and
    "Abandoned Call Threshold Parameter" are "Required", "Hidden" and "Does Not Apply".

    Attributes:
        report_template_table: reportTemplateTable
    """

    _ELEMENTS = (
        E(
            "report_template_table", "reportTemplateTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    report_template_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCenterEnhancedReportingGetResponse(OCIResponse):
    """
    Response to ``GroupCallCenterEnhancedReportingGetRequest()``.

    Replaced by ``GroupCallCenterEnhancedReportingGetResponse19()``

    Attributes:
        reporting_server: reportingServer
        web_statistic_source: webStatisticSource
    """

    _ELEMENTS = (
        E("reporting_server", "reportingServer", str, is_required=True),
        E("web_statistic_source", "webStatisticSource", str, is_required=True),
    )

    reporting_server: str = Field(type=str, required=True, mutable=False)
    web_statistic_source: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterEnhancedReportingGetResponse19(OCIResponse):
    """
    Response to ``GroupCallCenterEnhancedReportingGetRequest19()``.


    Attributes:
        reporting_server: reportingServer
    """

    _ELEMENTS = (
        E("reporting_server", "reportingServer", str, is_required=True),
    )

    reporting_server: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterEnhancedReportingReportTemplateGetListResponse(OCIResponse):
    """
    Response to ``GroupCallCenterEnhancedReportingReportTemplateGetListRequest()``.

    Contains a table with column headings: "Name", "Description", "Type" and "Enabled"

    Attributes:
        report_template_table: reportTemplateTable
    """

    _ELEMENTS = (
        E(
            "report_template_table", "reportTemplateTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    report_template_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCenterEnhancedReportingReportTemplateGetResponse(OCIResponse):
    """
    Response to ``GroupCallCenterEnhancedReportingReportTemplateGetRequest()``.


    Attributes:
        description: description
        data_template: dataTemplate
        filter_number: filterNumber
        xslt_template_description: xsltTemplateDescription
        scope: scope
        is_enabled: isEnabled
        is_realtime_report: isRealtimeReport
        call_completion_threshold_param: callCompletionThresholdParam
        short_duration_threshold_param: shortDurationThresholdParam
        service_level_threshold_param: serviceLevelThresholdParam
        service_level_inclusions_param: serviceLevelInclusionsParam
        service_level_objective_threshold_param: serviceLevelObjectiveThresholdParam
        abandoned_call_threshold_param: abandonedCallThresholdParam
        service_level_threshold_param_number: serviceLevelThresholdParamNumber
        abandoned_call_threshold_param_number: abandonedCallThresholdParamNumber
        filter_value: filterValue
    """

    _ELEMENTS = (
        E("description", "description", str),
        E("data_template", "dataTemplate", str, is_required=True),
        E("filter_number", "filterNumber", int),
        E("xslt_template_description", "xsltTemplateDescription", str, is_required=True),
        E("scope", "scope", str, is_required=True),
        E("is_enabled", "isEnabled", bool, is_required=True),
        E("is_realtime_report", "isRealtimeReport", bool),
        E("call_completion_threshold_param", "callCompletionThresholdParam", str),
        E("short_duration_threshold_param", "shortDurationThresholdParam", str),
        E("service_level_threshold_param", "serviceLevelThresholdParam", str),
        E("service_level_inclusions_param", "serviceLevelInclusionsParam", str),
        E(
            "service_level_objective_threshold_param",
            "serviceLevelObjectiveThresholdParam", str,
        ),
        E("abandoned_call_threshold_param", "abandonedCallThresholdParam", str),
        E("service_level_threshold_param_number", "serviceLevelThresholdParamNumber", int),
        E("abandoned_call_threshold_param_number", "abandonedCallThresholdParamNumber", int),
        E("filter_value", "filterValue", str),
    )

    description: str = Field(type=str, required=False, mutable=False)
    data_template: str = Field(type=str, required=True, mutable=False)
    filter_number: int = Field(type=int, required=False, mutable=False)
    xslt_template_description: str = Field(type=str, required=True, mutable=False)
    scope: str = Field(type=str, required=True, mutable=False)
    is_enabled: bool = Field(type=bool, required=True, mutable=False)
    is_realtime_report: bool = Field(type=bool, required=False, mutable=False)
    call_completion_threshold_param: str = Field(type=str, required=False, mutable=False)
    short_duration_threshold_param: str = Field(type=str, required=False, mutable=False)
    service_level_threshold_param: str = Field(type=str, required=False, mutable=False)
    service_level_inclusions_param: str = Field(type=str, required=False, mutable=False)
    service_level_objective_threshold_param: str = Field(
        type=str, required=False, mutable=False,
    )
    abandoned_call_threshold_param: str = Field(type=str, required=False, mutable=False)
    service_level_threshold_param_number: int = Field(type=int, required=False, mutable=False)
    abandoned_call_threshold_param_number: int = Field(
        type=int, required=False, mutable=False,
    )
    filter_value: str = Field(type=str, required=False, mutable=False)


class GroupCallCenterEnhancedReportingScheduledReportGetActiveListResponse(OCIResponse):
    """
    Response to ``GroupCallCenterEnhancedReportingScheduledReportGetActiveListRequest()``
    Contains a table with column headings : "Schedule Name", "Description", "Created By",
    "Is Supervisor Report", "Report Template Name", "Report Template Level" and
    "Recurring".

    The "Created By" can be either "Administrator" or user id if created by supervisor.
    The possible values for "Recurring" are "None", "Daily", "Weekly", "Monthly" and
    "Yearly". The possible values for "Report Template Level" are "System" and "Group".

    Attributes:
        scheduled_report_table: scheduledReportTable
    """

    _ELEMENTS = (
        E(
            "scheduled_report_table", "scheduledReportTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    scheduled_report_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCenterEnhancedReportingScheduledReportGetCompletedListResponse(OCIResponse):
    """
    Response to
    ``GroupCallCenterEnhancedReportingScheduledReportGetCompletedListRequest()`` Contains
    a table with column headings : "Schedule Name", "Description", "Created By", "Is
    Supervisor Report", "Report Template Name", "Report Template Level" and "Recurring".

    The "Created By" can be either "Administrator" or user id if created by supervisor.
    The possible values for "Recurring" are "None", "Daily", "Weekly", "Monthly" and
    "Yearly". The possible values for "Report Template Level" are "System" and "Group".

    Attributes:
        scheduled_report_table: scheduledReportTable
    """

    _ELEMENTS = (
        E(
            "scheduled_report_table", "scheduledReportTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    scheduled_report_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCenterEnhancedReportingScheduledReportGetListResponse(OCIResponse):
    """
    Response to ``GroupCallCenterEnhancedReportingScheduledReportGetListRequest()``.

    Contains a table with column headings : "Schedule Name", "Description", "Created By",
    "Is Supervisor Report", "Status", "Report Template Name", "Report Template Level" and
    "Recurring". The "Created By" can be either "Administrator" or user id if created by
    supervisor.  The possible values for "Status" are "Active", and "Completed". The
    possible values for "Recurring" are "None", "Daily", "Weekly", "Monthly" and "Yearly".
    The possible values for "Report Template Level" are "System" and "Group".

    Attributes:
        scheduled_report_table: scheduledReportTable
    """

    _ELEMENTS = (
        E(
            "scheduled_report_table", "scheduledReportTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    scheduled_report_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListResponse(OCIResponse):
    """
    Response to
    ``GroupCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListRequest()``.

    Contains a table with column headings: "Schedule Name", "Created By", "Created By
    Supervisor", and "Is Active". The "Created By" can be either "Administrator" or user
    id if created by supervisor.

    Attributes:
        schedule_report_table: scheduleReportTable
    """

    _ELEMENTS = (
        E(
            "schedule_report_table", "scheduleReportTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    schedule_report_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCenterForcedForwardingGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterForcedForwardingGetRequest()``.


    Attributes:
        is_active: isActive
        forward_to_phone_number: forwardToPhoneNumber
        allow_enable_via_fac: allowEnableViaFAC
        play_announcement_before_forwarding: playAnnouncementBeforeForwarding
        audio_message_selection: audioMessageSelection
        audio_file_url: audioFileUrl
        audio_file_description: audioFileDescription
        audio_media_type: audioMediaType
        video_message_selection: videoMessageSelection
        video_file_url: videoFileUrl
        video_file_description: videoFileDescription
        video_media_type: videoMediaType
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("forward_to_phone_number", "forwardToPhoneNumber", str),
        E("allow_enable_via_fac", "allowEnableViaFAC", bool, is_required=True),
        E(
            "play_announcement_before_forwarding", "playAnnouncementBeforeForwarding",
            bool, is_required=True,
        ),
        E("audio_message_selection", "audioMessageSelection", str, is_required=True),
        E("audio_file_url", "audioFileUrl", str),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("video_message_selection", "videoMessageSelection", str, is_required=True),
        E("video_file_url", "videoFileUrl", str),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
    )

    is_active: bool = Field(type=bool, required=True, mutable=False)
    forward_to_phone_number: str = Field(type=str, required=False, mutable=False)
    allow_enable_via_fac: bool = Field(type=bool, required=True, mutable=False)
    play_announcement_before_forwarding: bool = Field(type=bool, required=True, mutable=False)
    audio_message_selection: str = Field(type=str, required=True, mutable=False)
    audio_file_url: str = Field(type=str, required=False, mutable=False)
    audio_file_description: str = Field(type=str, required=False, mutable=False)
    audio_media_type: str = Field(type=str, required=False, mutable=False)
    video_message_selection: str = Field(type=str, required=True, mutable=False)
    video_file_url: str = Field(type=str, required=False, mutable=False)
    video_file_description: str = Field(type=str, required=False, mutable=False)
    video_media_type: str = Field(type=str, required=False, mutable=False)


class GroupCallCenterGetAgentListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetAgentListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Weight", "Phone Number", "Extension",
    "Department", "Email Address", "Skill Level".

    Attributes:
        agent_table: agentTable
    """

    _ELEMENTS = (
        E(
            "agent_table", "agentTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    agent_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCenterGetAnnouncementResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetAnnouncementRequest()``.


    Attributes:
        entrance_message_selection: entranceMessageSelection
        entrance_message_audio_file_description: entranceMessageAudioFileDescription
        entrance_message_video_file_description: entranceMessageVideoFileDescription
        periodic_comfort_message_selection: periodicComfortMessageSelection
        periodic_comfort_message_audio_file_description:
            periodicComfortMessageAudioFileDescription
        periodic_comfort_message_video_file_description:
            periodicComfortMessageVideoFileDescription
        on_hold_message_selection: onHoldMessageSelection
        on_hold_message_audio_file_description: onHoldMessageAudioFileDescription
        on_hold_message_video_file_description: onHoldMessageVideoFileDescription
    """

    _ELEMENTS = (
        E("entrance_message_selection", "entranceMessageSelection", str, is_required=True),
        E(
            "entrance_message_audio_file_description",
            "entranceMessageAudioFileDescription", str,
        ),
        E(
            "entrance_message_video_file_description",
            "entranceMessageVideoFileDescription", str,
        ),
        E(
            "periodic_comfort_message_selection", "periodicComfortMessageSelection", str,
            is_required=True,
        ),
        E(
            "periodic_comfort_message_audio_file_description",
            "periodicComfortMessageAudioFileDescription", str,
        ),
        E(
            "periodic_comfort_message_video_file_description",
            "periodicComfortMessageVideoFileDescription", str,
        ),
        E("on_hold_message_selection", "onHoldMessageSelection", str, is_required=True),
        E("on_hold_message_audio_file_description", "onHoldMessageAudioFileDescription", str),
        E("on_hold_message_video_file_description", "onHoldMessageVideoFileDescription", str),
    )

    entrance_message_selection: str = Field(type=str, required=True, mutable=False)
    entrance_message_audio_file_description: str = Field(
        type=str, required=False, mutable=False,
    )
    entrance_message_video_file_description: str = Field(
        type=str, required=False, mutable=False,
    )
    periodic_comfort_message_selection: str = Field(type=str, required=True, mutable=False)
    periodic_comfort_message_audio_file_description: str = Field(
        type=str, required=False, mutable=False,
    )
    periodic_comfort_message_video_file_description: str = Field(
        type=str, required=False, mutable=False,
    )
    on_hold_message_selection: str = Field(type=str, required=True, mutable=False)
    on_hold_message_audio_file_description: str = Field(
        type=str, required=False, mutable=False,
    )
    on_hold_message_video_file_description: str = Field(
        type=str, required=False, mutable=False,
    )


class GroupCallCenterGetAvailableAgentListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetAvailableAgentListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCenterGetAvailableSupervisorListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetAvailableSupervisorListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCenterGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetAvailableUserListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name".

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCenterGetDNISAgentListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetDNISAgentListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        agent_table: agentTable
    """

    _ELEMENTS = (
        E(
            "agent_table", "agentTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    agent_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCenterGetDNISListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetDNISListResponse()``.

    Contains a table with column headings: "Name", "Phone Number", "Extension",
    "Priority", "Is Primary DNIS".

    Attributes:
        display_dnis_number: displayDNISNumber
        display_dnis_name: displayDNISName
        promote_calls_from_priority1to0: promoteCallsFromPriority1to0
        promote_calls_from_priority2to1: promoteCallsFromPriority2to1
        promote_calls_from_priority3to2: promoteCallsFromPriority3to2
        promote_calls_from_priority1to0_seconds: promoteCallsFromPriority1to0Seconds
        promote_calls_from_priority2to1_seconds: promoteCallsFromPriority2to1Seconds
        promote_calls_from_priority3to2_seconds: promoteCallsFromPriority3to2Seconds
        dnis_table: dnisTable
    """

    _ELEMENTS = (
        E("display_dnis_number", "displayDNISNumber", bool, is_required=True),
        E("display_dnis_name", "displayDNISName", bool, is_required=True),
        E(
            "promote_calls_from_priority1to0", "promoteCallsFromPriority1to0", bool,
            is_required=True,
        ),
        E(
            "promote_calls_from_priority2to1", "promoteCallsFromPriority2to1", bool,
            is_required=True,
        ),
        E(
            "promote_calls_from_priority3to2", "promoteCallsFromPriority3to2", bool,
            is_required=True,
        ),
        E(
            "promote_calls_from_priority1to0_seconds",
            "promoteCallsFromPriority1to0Seconds", int, is_required=True,
        ),
        E(
            "promote_calls_from_priority2to1_seconds",
            "promoteCallsFromPriority2to1Seconds", int, is_required=True,
        ),
        E(
            "promote_calls_from_priority3to2_seconds",
            "promoteCallsFromPriority3to2Seconds", int, is_required=True,
        ),
        E("dnis_table", "dnisTable", list, is_complex=True, is_required=True, is_table=True),
    )

    display_dnis_number: bool = Field(type=bool, required=True, mutable=False)
    display_dnis_name: bool = Field(type=bool, required=True, mutable=False)
    promote_calls_from_priority1to0: bool = Field(type=bool, required=True, mutable=False)
    promote_calls_from_priority2to1: bool = Field(type=bool, required=True, mutable=False)
    promote_calls_from_priority3to2: bool = Field(type=bool, required=True, mutable=False)
    promote_calls_from_priority1to0_seconds: int = Field(
        type=int, required=True, mutable=False,
    )
    promote_calls_from_priority2to1_seconds: int = Field(
        type=int, required=True, mutable=False,
    )
    promote_calls_from_priority3to2_seconds: int = Field(
        type=int, required=True, mutable=False,
    )
    dnis_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCenterGetDNISResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetDNISResponse()``.


    Attributes:
        dnis_phone_number: dnisPhoneNumber
        extension: extension
        use_custom_clid_settings: useCustomCLIDSettings
        calling_line_id_phone_number: callingLineIdPhoneNumber
        calling_line_id_last_name: callingLineIdLastName
        calling_line_id_first_name: callingLineIdFirstName
        use_custom_dnis_announcement_settings: useCustomDnisAnnouncementSettings
        priority: priority
        allow_outgoing_acd_call: allowOutgoingACDCall
    """

    _ELEMENTS = (
        E("dnis_phone_number", "dnisPhoneNumber", str),
        E("extension", "extension", str),
        E("use_custom_clid_settings", "useCustomCLIDSettings", bool, is_required=True),
        E("calling_line_id_phone_number", "callingLineIdPhoneNumber", str),
        E("calling_line_id_last_name", "callingLineIdLastName", str),
        E("calling_line_id_first_name", "callingLineIdFirstName", str),
        E(
            "use_custom_dnis_announcement_settings", "useCustomDnisAnnouncementSettings",
            bool, is_required=True,
        ),
        E("priority", "priority", str, is_required=True),
        E("allow_outgoing_acd_call", "allowOutgoingACDCall", bool, is_required=True),
    )

    dnis_phone_number: str = Field(type=str, required=False, mutable=False)
    extension: str = Field(type=str, required=False, mutable=False)
    use_custom_clid_settings: bool = Field(type=bool, required=True, mutable=False)
    calling_line_id_phone_number: str = Field(type=str, required=False, mutable=False)
    calling_line_id_last_name: str = Field(type=str, required=False, mutable=False)
    calling_line_id_first_name: str = Field(type=str, required=False, mutable=False)
    use_custom_dnis_announcement_settings: bool = Field(
        type=bool, required=True, mutable=False,
    )
    priority: str = Field(type=str, required=True, mutable=False)
    allow_outgoing_acd_call: bool = Field(type=bool, required=True, mutable=False)


class GroupCallCenterGetDistinctiveRingingResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetDistinctiveRingingRequest()``.


    Attributes:
        distinctive_ringing_call_center_calls: distinctiveRingingCallCenterCalls
        distinctive_ringing_ring_pattern_for_call_center:
            distinctiveRingingRingPatternForCallCenter
        distinctive_ringing_force_delivery_ring_pattern:
            distinctiveRingingForceDeliveryRingPattern
    """

    _ELEMENTS = (
        E(
            "distinctive_ringing_call_center_calls", "distinctiveRingingCallCenterCalls",
            bool, is_required=True,
        ),
        E(
            "distinctive_ringing_ring_pattern_for_call_center",
            "distinctiveRingingRingPatternForCallCenter", str, is_required=True,
        ),
        E(
            "distinctive_ringing_force_delivery_ring_pattern",
            "distinctiveRingingForceDeliveryRingPattern", str,
        ),
    )

    distinctive_ringing_call_center_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    distinctive_ringing_ring_pattern_for_call_center: str = Field(
        type=str, required=True, mutable=False,
    )
    distinctive_ringing_force_delivery_ring_pattern: str = Field(
        type=str, required=False, mutable=False,
    )


class GroupCallCenterGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetInstanceListRequest()``.

    Contains a table with column headings: "Service User Id", "Name", "Video", "Phone
    Number", "Extension", "Department", "Is Active", "Policy", "Type". The column values
    for "Video" and "Is Active" can either be true, or false.  The column values for
    "Type" can be "Basic", "Standard" or "Premium". NOTE: prior to release 14, the policy
    column did not match the HuntPolicy enumerated type.

    Attributes:
        call_center_table: callCenterTable
    """

    _ELEMENTS = (
        E(
            "call_center_table", "callCenterTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    call_center_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCenterGetInstanceQueueStatusResponse(OCIResponse):
    """
    Contains Call Center queue status and a table with column headings: "User Id", "First
    Name", "Last Name", "Phone Number", "Extension", "Department", "Email Address".


    Attributes:
        number_of_calls_queued_now: numberOfCallsQueuedNow
        agents_currently_staffed: agentsCurrentlyStaffed
    """

    _ELEMENTS = (
        E("number_of_calls_queued_now", "numberOfCallsQueuedNow", int, is_required=True),
        E(
            "agents_currently_staffed", "agentsCurrentlyStaffed", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    number_of_calls_queued_now: int = Field(type=int, required=True, mutable=False)
    agents_currently_staffed: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCenterGetInstanceStatisticsReportingResponse(OCIResponse):
    """
    Contains Call Center statistics reporting settings.


    Attributes:
        generate_daily_report: generateDailyReport
        collection_period_minutes: collectionPeriodMinutes
        reporting_email_address1: reportingEmailAddress1
        reporting_email_address2: reportingEmailAddress2
    """

    _ELEMENTS = (
        E("generate_daily_report", "generateDailyReport", bool, is_required=True),
        E("collection_period_minutes", "collectionPeriodMinutes", int, is_required=True),
        E("reporting_email_address1", "reportingEmailAddress1", str),
        E("reporting_email_address2", "reportingEmailAddress2", str),
    )

    generate_daily_report: bool = Field(type=bool, required=True, mutable=False)
    collection_period_minutes: int = Field(type=int, required=True, mutable=False)
    reporting_email_address1: str = Field(type=str, required=False, mutable=False)
    reporting_email_address2: str = Field(type=str, required=False, mutable=False)


class GroupCallCenterGetInstanceStatisticsReportingResponse16(OCIResponse):
    """
    Contains Call Center statistics reporting settings.


    Attributes:
        generate_daily_report: generateDailyReport
        collection_period_minutes: collectionPeriodMinutes
        reporting_email_address1: reportingEmailAddress1
        reporting_email_address2: reportingEmailAddress2
        statistics_source: statisticsSource
    """

    _ELEMENTS = (
        E("generate_daily_report", "generateDailyReport", bool, is_required=True),
        E("collection_period_minutes", "collectionPeriodMinutes", int, is_required=True),
        E("reporting_email_address1", "reportingEmailAddress1", str),
        E("reporting_email_address2", "reportingEmailAddress2", str),
        E("statistics_source", "statisticsSource", str, is_required=True),
    )

    generate_daily_report: bool = Field(type=bool, required=True, mutable=False)
    collection_period_minutes: int = Field(type=int, required=True, mutable=False)
    reporting_email_address1: str = Field(type=str, required=False, mutable=False)
    reporting_email_address2: str = Field(type=str, required=False, mutable=False)
    statistics_source: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceStatisticsReportingResponse17sp1(OCIResponse):
    """
    Response to ``GroupCallCenterGetInstanceStatisticsReportingRequest17sp1()``.

    Contains Call Center statistics reporting settings.

    Attributes:
        generate_daily_report: generateDailyReport
        collection_period_minutes: collectionPeriodMinutes
        reporting_email_address1: reportingEmailAddress1
        reporting_email_address2: reportingEmailAddress2
        statistics_source: statisticsSource
    """

    _ELEMENTS = (
        E("generate_daily_report", "generateDailyReport", bool, is_required=True),
        E("collection_period_minutes", "collectionPeriodMinutes", int, is_required=True),
        E("reporting_email_address1", "reportingEmailAddress1", str),
        E("reporting_email_address2", "reportingEmailAddress2", str),
        E("statistics_source", "statisticsSource", str, is_required=True),
    )

    generate_daily_report: bool = Field(type=bool, required=True, mutable=False)
    collection_period_minutes: int = Field(type=int, required=True, mutable=False)
    reporting_email_address1: str = Field(type=str, required=False, mutable=False)
    reporting_email_address2: str = Field(type=str, required=False, mutable=False)
    statistics_source: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetResponse(OCIResponse):
    """
    Response to ``GroupCallCenterGetRequest()``.

    Replaced by ``GroupCallCenterGetResponse17sp4()``.

    Attributes:
        use_system_default_guard_timer: useSystemDefaultGuardTimer
        enable_guard_timer: enableGuardTimer
        guard_timer_seconds: guardTimerSeconds
        use_system_default_unavailable_settings: useSystemDefaultUnavailableSettings
        force_agent_unavailable_on_dnd_activation: forceAgentUnavailableOnDNDActivation
        force_agent_unavailable_on_personal_calls: forceAgentUnavailableOnPersonalCalls
        force_agent_unavailable_on_bounced_call_limit:
            forceAgentUnavailableOnBouncedCallLimit
        number_consecutive_bounced_calls_to_force_agent_unavailable:
            numberConsecutiveBouncedCallsToForceAgentUnavailable
    """

    _ELEMENTS = (
        E(
            "use_system_default_guard_timer", "useSystemDefaultGuardTimer", bool,
            is_required=True,
        ),
        E("enable_guard_timer", "enableGuardTimer", bool, is_required=True),
        E("guard_timer_seconds", "guardTimerSeconds", int, is_required=True),
        E(
            "use_system_default_unavailable_settings",
            "useSystemDefaultUnavailableSettings", bool,
        ),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation", bool,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls", bool,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit", bool,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable", int,
        ),
    )

    use_system_default_guard_timer: bool = Field(type=bool, required=True, mutable=False)
    enable_guard_timer: bool = Field(type=bool, required=True, mutable=False)
    guard_timer_seconds: int = Field(type=int, required=True, mutable=False)
    use_system_default_unavailable_settings: bool = Field(
        type=bool, required=False, mutable=False,
    )
    force_agent_unavailable_on_dnd_activation: bool = Field(
        type=bool, required=False, mutable=False,
    )
    force_agent_unavailable_on_personal_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    force_agent_unavailable_on_bounced_call_limit: bool = Field(
        type=bool, required=False, mutable=False,
    )
    number_consecutive_bounced_calls_to_force_agent_unavailable: int = Field(
        type=int, required=False, mutable=False,
    )


class GroupCallCenterGetResponse17sp4(OCIResponse):
    """
    Response to ``GroupCallCenterGetRequest17sp4()``.


    Attributes:
        use_system_default_guard_timer: useSystemDefaultGuardTimer
        enable_guard_timer: enableGuardTimer
        guard_timer_seconds: guardTimerSeconds
        use_system_default_unavailable_settings: useSystemDefaultUnavailableSettings
        force_agent_unavailable_on_dnd_activation: forceAgentUnavailableOnDNDActivation
        force_agent_unavailable_on_personal_calls: forceAgentUnavailableOnPersonalCalls
        force_agent_unavailable_on_bounced_call_limit:
            forceAgentUnavailableOnBouncedCallLimit
        number_consecutive_bounced_calls_to_force_agent_unavailable:
            numberConsecutiveBouncedCallsToForceAgentUnavailable
        force_agent_unavailable_on_not_reachable: forceAgentUnavailableOnNotReachable
    """

    _ELEMENTS = (
        E(
            "use_system_default_guard_timer", "useSystemDefaultGuardTimer", bool,
            is_required=True,
        ),
        E("enable_guard_timer", "enableGuardTimer", bool, is_required=True),
        E("guard_timer_seconds", "guardTimerSeconds", int, is_required=True),
        E(
            "use_system_default_unavailable_settings",
            "useSystemDefaultUnavailableSettings", bool,
        ),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation", bool,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls", bool,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit", bool,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable", int,
        ),
        E(
            "force_agent_unavailable_on_not_reachable",
            "forceAgentUnavailableOnNotReachable", bool,
        ),
    )

    use_system_default_guard_timer: bool = Field(type=bool, required=True, mutable=False)
    enable_guard_timer: bool = Field(type=bool, required=True, mutable=False)
    guard_timer_seconds: int = Field(type=int, required=True, mutable=False)
    use_system_default_unavailable_settings: bool = Field(
        type=bool, required=False, mutable=False,
    )
    force_agent_unavailable_on_dnd_activation: bool = Field(
        type=bool, required=False, mutable=False,
    )
    force_agent_unavailable_on_personal_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    force_agent_unavailable_on_bounced_call_limit: bool = Field(
        type=bool, required=False, mutable=False,
    )
    number_consecutive_bounced_calls_to_force_agent_unavailable: int = Field(
        type=int, required=False, mutable=False,
    )
    force_agent_unavailable_on_not_reachable: bool = Field(
        type=bool, required=False, mutable=False,
    )


class GroupCallCenterGetRoutingPolicyResponse(OCIResponse):
    """
    Response to ``GroupCallCenterGetRoutingPolicyRequest()``.

    Contains a table with column headings: "Service User Id", "Name" and "Priority".

    Attributes:
        routing_policy: routingPolicy
        call_center_table: callCenterTable
    """

    _ELEMENTS = (
        E("routing_policy", "routingPolicy", str, is_required=True),
        E(
            "call_center_table", "callCenterTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    routing_policy: str = Field(type=str, required=True, mutable=False)
    call_center_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCenterGetSupervisorListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetSupervisorListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name". Element "reportingServerURL"" will always be blank.

    Replaced By: ``GroupCallCenterSupervisorReportingGetResponse()``

    Attributes:
        reporting_server_url: reportingServerURL
        supervisor_table: supervisorTable
    """

    _ELEMENTS = (
        E("reporting_server_url", "reportingServerURL", str),
        E(
            "supervisor_table", "supervisorTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    reporting_server_url: str = Field(type=str, required=False, mutable=False)
    supervisor_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCenterGetSupervisorListResponse16(OCIResponse):
    """
    Response to the ``GroupCallCenterGetSupervisorListRequest16()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        supervisor_table: supervisorTable
    """

    _ELEMENTS = (
        E(
            "supervisor_table", "supervisorTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    supervisor_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCenterGetUnlicensedAgentListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetUnlicensedAgentListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Group Id", "Extension",
    "Department", "Email Address".

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCenterHolidayServiceGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterHolidayServiceGetRequest()``.


    Attributes:
        action: action
        holiday_schedule: holidaySchedule
        transfer_phone_number: transferPhoneNumber
        play_announcement_before_action: playAnnouncementBeforeAction
        audio_message_selection: audioMessageSelection
        audio_file_url: audioFileUrl
        audio_file_description: audioFileDescription
        audio_media_type: audioMediaType
        video_message_selection: videoMessageSelection
        video_file_url: videoFileUrl
        video_file_description: videoFileDescription
        video_media_type: videoMediaType
    """

    _ELEMENTS = (
        E("action", "action", str, is_required=True),
        E("holiday_schedule", "holidaySchedule", str),
        E("transfer_phone_number", "transferPhoneNumber", str),
        E(
            "play_announcement_before_action", "playAnnouncementBeforeAction", bool,
            is_required=True,
        ),
        E("audio_message_selection", "audioMessageSelection", str, is_required=True),
        E("audio_file_url", "audioFileUrl", str),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("video_message_selection", "videoMessageSelection", str, is_required=True),
        E("video_file_url", "videoFileUrl", str),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
    )

    action: str = Field(type=str, required=True, mutable=False)
    holiday_schedule: str = Field(type=str, required=False, mutable=False)
    transfer_phone_number: str = Field(type=str, required=False, mutable=False)
    play_announcement_before_action: bool = Field(type=bool, required=True, mutable=False)
    audio_message_selection: str = Field(type=str, required=True, mutable=False)
    audio_file_url: str = Field(type=str, required=False, mutable=False)
    audio_file_description: str = Field(type=str, required=False, mutable=False)
    audio_media_type: str = Field(type=str, required=False, mutable=False)
    video_message_selection: str = Field(type=str, required=True, mutable=False)
    video_file_url: str = Field(type=str, required=False, mutable=False)
    video_file_description: str = Field(type=str, required=False, mutable=False)
    video_media_type: str = Field(type=str, required=False, mutable=False)


class GroupCallCenterNightServiceGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterNightServiceGetRequest()``.


    Attributes:
        action: action
        business_hours: businessHours
        force_night_service: forceNightService
        allow_manual_override_via_fac: allowManualOverrideViaFAC
        transfer_phone_number: transferPhoneNumber
        play_announcement_before_action: playAnnouncementBeforeAction
        audio_message_selection: audioMessageSelection
        audio_file_url: audioFileUrl
        audio_file_description: audioFileDescription
        audio_media_type: audioMediaType
        video_message_selection: videoMessageSelection
        video_file_url: videoFileUrl
        video_file_description: videoFileDescription
        video_media_type: videoMediaType
        manual_announcement_mode: manualAnnouncementMode
        manual_audio_message_selection: manualAudioMessageSelection
        manual_audio_file_url: manualAudioFileUrl
        manual_audio_file_description: manualAudioFileDescription
        manual_audio_media_type: manualAudioMediaType
        manual_video_message_selection: manualVideoMessageSelection
        manual_video_file_url: manualVideoFileUrl
        manual_video_file_description: manualVideoFileDescription
        manual_video_media_type: manualVideoMediaType
    """

    _ELEMENTS = (
        E("action", "action", str, is_required=True),
        E("business_hours", "businessHours", str),
        E("force_night_service", "forceNightService", bool, is_required=True),
        E(
            "allow_manual_override_via_fac", "allowManualOverrideViaFAC", bool,
            is_required=True,
        ),
        E("transfer_phone_number", "transferPhoneNumber", str),
        E(
            "play_announcement_before_action", "playAnnouncementBeforeAction", bool,
            is_required=True,
        ),
        E("audio_message_selection", "audioMessageSelection", str, is_required=True),
        E("audio_file_url", "audioFileUrl", str),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("video_message_selection", "videoMessageSelection", str, is_required=True),
        E("video_file_url", "videoFileUrl", str),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
        E("manual_announcement_mode", "manualAnnouncementMode", str, is_required=True),
        E(
            "manual_audio_message_selection", "manualAudioMessageSelection", str,
            is_required=True,
        ),
        E("manual_audio_file_url", "manualAudioFileUrl", str),
        E("manual_audio_file_description", "manualAudioFileDescription", str),
        E("manual_audio_media_type", "manualAudioMediaType", str),
        E(
            "manual_video_message_selection", "manualVideoMessageSelection", str,
            is_required=True,
        ),
        E("manual_video_file_url", "manualVideoFileUrl", str),
        E("manual_video_file_description", "manualVideoFileDescription", str),
        E("manual_video_media_type", "manualVideoMediaType", str),
    )

    action: str = Field(type=str, required=True, mutable=False)
    business_hours: str = Field(type=str, required=False, mutable=False)
    force_night_service: bool = Field(type=bool, required=True, mutable=False)
    allow_manual_override_via_fac: bool = Field(type=bool, required=True, mutable=False)
    transfer_phone_number: str = Field(type=str, required=False, mutable=False)
    play_announcement_before_action: bool = Field(type=bool, required=True, mutable=False)
    audio_message_selection: str = Field(type=str, required=True, mutable=False)
    audio_file_url: str = Field(type=str, required=False, mutable=False)
    audio_file_description: str = Field(type=str, required=False, mutable=False)
    audio_media_type: str = Field(type=str, required=False, mutable=False)
    video_message_selection: str = Field(type=str, required=True, mutable=False)
    video_file_url: str = Field(type=str, required=False, mutable=False)
    video_file_description: str = Field(type=str, required=False, mutable=False)
    video_media_type: str = Field(type=str, required=False, mutable=False)
    manual_announcement_mode: str = Field(type=str, required=True, mutable=False)
    manual_audio_message_selection: str = Field(type=str, required=True, mutable=False)
    manual_audio_file_url: str = Field(type=str, required=False, mutable=False)
    manual_audio_file_description: str = Field(type=str, required=False, mutable=False)
    manual_audio_media_type: str = Field(type=str, required=False, mutable=False)
    manual_video_message_selection: str = Field(type=str, required=True, mutable=False)
    manual_video_file_url: str = Field(type=str, required=False, mutable=False)
    manual_video_file_description: str = Field(type=str, required=False, mutable=False)
    manual_video_media_type: str = Field(type=str, required=False, mutable=False)


class GroupCallCenterOverflowGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterOverflowGetRequest()``.


    Attributes:
        action: action
        transfer_phone_number: transferPhoneNumber
        overflow_after_timeout: overflowAfterTimeout
        timeout_seconds: timeoutSeconds
        play_announcement_before_overflow_processing:
            playAnnouncementBeforeOverflowProcessing
        audio_message_selection: audioMessageSelection
        audio_file_url: audioFileUrl
        audio_file_description: audioFileDescription
        audio_media_type: audioMediaType
        video_message_selection: videoMessageSelection
        video_file_url: videoFileUrl
        video_file_description: videoFileDescription
        video_media_type: videoMediaType
    """

    _ELEMENTS = (
        E("action", "action", str, is_required=True),
        E("transfer_phone_number", "transferPhoneNumber", str),
        E("overflow_after_timeout", "overflowAfterTimeout", bool, is_required=True),
        E("timeout_seconds", "timeoutSeconds", int, is_required=True),
        E(
            "play_announcement_before_overflow_processing",
            "playAnnouncementBeforeOverflowProcessing", bool, is_required=True,
        ),
        E("audio_message_selection", "audioMessageSelection", str, is_required=True),
        E("audio_file_url", "audioFileUrl", str),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("video_message_selection", "videoMessageSelection", str),
        E("video_file_url", "videoFileUrl", str),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
    )

    action: str = Field(type=str, required=True, mutable=False)
    transfer_phone_number: str = Field(type=str, required=False, mutable=False)
    overflow_after_timeout: bool = Field(type=bool, required=True, mutable=False)
    timeout_seconds: int = Field(type=int, required=True, mutable=False)
    play_announcement_before_overflow_processing: bool = Field(
        type=bool, required=True, mutable=False,
    )
    audio_message_selection: str = Field(type=str, required=True, mutable=False)
    audio_file_url: str = Field(type=str, required=False, mutable=False)
    audio_file_description: str = Field(type=str, required=False, mutable=False)
    audio_media_type: str = Field(type=str, required=False, mutable=False)
    video_message_selection: str = Field(type=str, required=False, mutable=False)
    video_file_url: str = Field(type=str, required=False, mutable=False)
    video_file_description: str = Field(type=str, required=False, mutable=False)
    video_media_type: str = Field(type=str, required=False, mutable=False)


class GroupCallCenterQueueCallDispositionCodeGetListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterQueueCallDispositionCodeGetListRequest()``.

    Contains a table with column headings: "Is Active", "Code", "Description" and "Level".
    Level column can be any of the values in the data type CallDispositionCodeLevel.

    Attributes:
        disposition_codes_table: dispositionCodesTable
    """

    _ELEMENTS = (
        E(
            "disposition_codes_table", "dispositionCodesTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    disposition_codes_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallCenterQueueCallDispositionCodeGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterQueueCallDispositionCodeGetRequest()``

    Attributes:
        is_active: isActive
        description: description
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("description", "description", str),
    )

    is_active: bool = Field(type=bool, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class GroupCallCenterQueueStatusNotificationGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterQueueStatusNotificationGetRequest()``.

    The response contains the call center status configuration information.

    Attributes:
        enable_queue_status_notification: enableQueueStatusNotification
        enable_queue_depth_threshold: enableQueueDepthThreshold
        enable_waiting_time_threshold: enableWaitingTimeThreshold
        number_of_calls_threshold: numberOfCallsThreshold
        waiting_time_of_calls_threshold: waitingTimeOfCallsThreshold
    """

    _ELEMENTS = (
        E(
            "enable_queue_status_notification", "enableQueueStatusNotification", bool,
            is_required=True,
        ),
        E(
            "enable_queue_depth_threshold", "enableQueueDepthThreshold", bool,
            is_required=True,
        ),
        E(
            "enable_waiting_time_threshold", "enableWaitingTimeThreshold", bool,
            is_required=True,
        ),
        E("number_of_calls_threshold", "numberOfCallsThreshold", int, is_required=True),
        E(
            "waiting_time_of_calls_threshold", "waitingTimeOfCallsThreshold", int,
            is_required=True,
        ),
    )

    enable_queue_status_notification: bool = Field(type=bool, required=True, mutable=False)
    enable_queue_depth_threshold: bool = Field(type=bool, required=True, mutable=False)
    enable_waiting_time_threshold: bool = Field(type=bool, required=True, mutable=False)
    number_of_calls_threshold: int = Field(type=int, required=True, mutable=False)
    waiting_time_of_calls_threshold: int = Field(type=int, required=True, mutable=False)


class GroupCallCenterQueueThresholdsGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterQueueThresholdsGetRequest()``.


    Attributes:
        is_active: isActive
        threshold_current_calls_in_queue_yellow: thresholdCurrentCallsInQueueYellow
        threshold_current_calls_in_queue_red: thresholdCurrentCallsInQueueRed
        threshold_current_longest_waiting_call_yellow:
            thresholdCurrentLongestWaitingCallYellow
        threshold_current_longest_waiting_call_red: thresholdCurrentLongestWaitingCallRed
        threshold_average_estimated_wait_time_yellow:
            thresholdAverageEstimatedWaitTimeYellow
        threshold_average_estimated_wait_time_red: thresholdAverageEstimatedWaitTimeRed
        threshold_average_handling_time_yellow: thresholdAverageHandlingTimeYellow
        threshold_average_handling_time_red: thresholdAverageHandlingTimeRed
        threshold_average_speed_of_answer_yellow: thresholdAverageSpeedOfAnswerYellow
        threshold_average_speed_of_answer_red: thresholdAverageSpeedOfAnswerRed
        enable_notification_email: enableNotificationEmail
        notification_email_address: notificationEmailAddress
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E(
            "threshold_current_calls_in_queue_yellow",
            "thresholdCurrentCallsInQueueYellow", int,
        ),
        E("threshold_current_calls_in_queue_red", "thresholdCurrentCallsInQueueRed", int),
        E(
            "threshold_current_longest_waiting_call_yellow",
            "thresholdCurrentLongestWaitingCallYellow", int,
        ),
        E(
            "threshold_current_longest_waiting_call_red",
            "thresholdCurrentLongestWaitingCallRed", int,
        ),
        E(
            "threshold_average_estimated_wait_time_yellow",
            "thresholdAverageEstimatedWaitTimeYellow", int,
        ),
        E(
            "threshold_average_estimated_wait_time_red",
            "thresholdAverageEstimatedWaitTimeRed", int,
        ),
        E(
            "threshold_average_handling_time_yellow",
            "thresholdAverageHandlingTimeYellow", int,
        ),
        E("threshold_average_handling_time_red", "thresholdAverageHandlingTimeRed", int),
        E(
            "threshold_average_speed_of_answer_yellow",
            "thresholdAverageSpeedOfAnswerYellow", int,
        ),
        E("threshold_average_speed_of_answer_red", "thresholdAverageSpeedOfAnswerRed", int),
        E("enable_notification_email", "enableNotificationEmail", bool, is_required=True),
        E("notification_email_address", "notificationEmailAddress", str),
    )

    is_active: bool = Field(type=bool, required=True, mutable=False)
    threshold_current_calls_in_queue_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_calls_in_queue_red: int = Field(type=int, required=False, mutable=False)
    threshold_current_longest_waiting_call_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_longest_waiting_call_red: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_estimated_wait_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_estimated_wait_time_red: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_handling_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_handling_time_red: int = Field(type=int, required=False, mutable=False)
    threshold_average_speed_of_answer_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_speed_of_answer_red: int = Field(
        type=int, required=False, mutable=False,
    )
    enable_notification_email: bool = Field(type=bool, required=True, mutable=False)
    notification_email_address: str = Field(type=str, required=False, mutable=False)


class GroupCallCenterStrandedCallGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterStrandedCallGetRequest()``.


    Attributes:
        action: action
        transfer_phone_number: transferPhoneNumber
        audio_message_selection: audioMessageSelection
        audio_file_url: audioFileUrl
        audio_file_description: audioFileDescription
        audio_media_type: audioMediaType
        video_message_selection: videoMessageSelection
        video_file_url: videoFileUrl
        video_file_description: videoFileDescription
        video_media_type: videoMediaType
    """

    _ELEMENTS = (
        E("action", "action", str, is_required=True),
        E("transfer_phone_number", "transferPhoneNumber", str),
        E("audio_message_selection", "audioMessageSelection", str),
        E("audio_file_url", "audioFileUrl", str),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("video_message_selection", "videoMessageSelection", str),
        E("video_file_url", "videoFileUrl", str),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
    )

    action: str = Field(type=str, required=True, mutable=False)
    transfer_phone_number: str = Field(type=str, required=False, mutable=False)
    audio_message_selection: str = Field(type=str, required=False, mutable=False)
    audio_file_url: str = Field(type=str, required=False, mutable=False)
    audio_file_description: str = Field(type=str, required=False, mutable=False)
    audio_media_type: str = Field(type=str, required=False, mutable=False)
    video_message_selection: str = Field(type=str, required=False, mutable=False)
    video_file_url: str = Field(type=str, required=False, mutable=False)
    video_file_description: str = Field(type=str, required=False, mutable=False)
    video_media_type: str = Field(type=str, required=False, mutable=False)


class GroupCallCenterSupervisorReportingGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterSupervisorReportingGetRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name".

    Attributes:
        reporting_server_name: reportingServerName
        supervisor_table: supervisorTable
    """

    _ELEMENTS = (
        E("reporting_server_name", "reportingServerName", str),
        E(
            "supervisor_table", "supervisorTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    reporting_server_name: str = Field(type=str, required=False, mutable=False)
    supervisor_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallParkGetAvailableAlternateRecallUserListResponse(OCIResponse):
    """
    Response to the ``GroupCallParkGetAvailableAlternateRecallUserListResponse()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name".

    Attributes:
        available_hunt_group_table: availableHuntGroupTable
    """

    _ELEMENTS = (
        E(
            "available_hunt_group_table", "availableHuntGroupTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    available_hunt_group_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallParkGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupCallParkGetAvailableUserListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallParkGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupCallParkGetInstanceListRequest()``.


    Attributes:
        name: name
    """

    _ELEMENTS = (
        E("name", "name", str, is_array=True),
    )

    name: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupCallParkGetInstanceResponse(OCIResponse):
    """
    Response to the ``GroupCallParkGetInstanceRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name". The users are in the table are in the order they
    will try to be parked on.

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallParkGetInstanceResponse16sp2(OCIResponse):
    """
    Response to the ``GroupCallParkGetInstanceRequest16sp2()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address". The users are in the table are in the order they will try to be parked on.
    The following elements are only used in AS data mode: recallAlternateUserId recallTo

    Attributes:
        recall_alternate_user_id: recallAlternateUserId
        recall_to: recallTo
        user_table: userTable
    """

    _ELEMENTS = (
        E("recall_alternate_user_id", "recallAlternateUserId", str),
        E("recall_to", "recallTo", str, is_required=True),
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    recall_alternate_user_id: str = Field(type=str, required=False, mutable=False)
    recall_to: str = Field(type=str, required=True, mutable=False)
    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallParkGetResponse(OCIResponse):
    """
    Response to the ``GroupCallParkGetRequest()``.

    Contains the settings that apply to the whole group for Call Park.

    Attributes:
        recall_timer_seconds: recallTimerSeconds
        display_timer_seconds: displayTimerSeconds
        enable_destination_announcement: enableDestinationAnnouncement
    """

    _ELEMENTS = (
        E("recall_timer_seconds", "recallTimerSeconds", int, is_required=True),
        E("display_timer_seconds", "displayTimerSeconds", int, is_required=True),
        E(
            "enable_destination_announcement", "enableDestinationAnnouncement", bool,
            is_required=True,
        ),
    )

    recall_timer_seconds: int = Field(type=int, required=True, mutable=False)
    display_timer_seconds: int = Field(type=int, required=True, mutable=False)
    enable_destination_announcement: bool = Field(type=bool, required=True, mutable=False)


class GroupCallParkGetResponse16sp2(OCIResponse):
    """
    Response to the ``GroupCallParkGetRequest16sp2()``.

    Contains the settings that apply to the whole group for Call Park.  The following
    elements are only used in AS data mode: recallAlternateUserId recallRingPattern
    recallTo alternateUserRecallTimerSeconds

    Attributes:
        recall_timer_seconds: recallTimerSeconds
        display_timer_seconds: displayTimerSeconds
        enable_destination_announcement: enableDestinationAnnouncement
        recall_alternate_user_id: recallAlternateUserId
        recall_ring_pattern: recallRingPattern
        recall_to: recallTo
        alternate_user_recall_timer_seconds: alternateUserRecallTimerSeconds
    """

    _ELEMENTS = (
        E("recall_timer_seconds", "recallTimerSeconds", int, is_required=True),
        E("display_timer_seconds", "displayTimerSeconds", int, is_required=True),
        E(
            "enable_destination_announcement", "enableDestinationAnnouncement", bool,
            is_required=True,
        ),
        E("recall_alternate_user_id", "recallAlternateUserId", str),
        E("recall_ring_pattern", "recallRingPattern", str, is_required=True),
        E("recall_to", "recallTo", str, is_required=True),
        E(
            "alternate_user_recall_timer_seconds", "alternateUserRecallTimerSeconds", int,
            is_required=True,
        ),
    )

    recall_timer_seconds: int = Field(type=int, required=True, mutable=False)
    display_timer_seconds: int = Field(type=int, required=True, mutable=False)
    enable_destination_announcement: bool = Field(type=bool, required=True, mutable=False)
    recall_alternate_user_id: str = Field(type=str, required=False, mutable=False)
    recall_ring_pattern: str = Field(type=str, required=True, mutable=False)
    recall_to: str = Field(type=str, required=True, mutable=False)
    alternate_user_recall_timer_seconds: int = Field(type=int, required=True, mutable=False)


class GroupCallPickupGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupCallPickupGetAvailableUserListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallPickupGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupCallPickupGetInstanceListRequest()``.


    Attributes:
        name: name
    """

    _ELEMENTS = (
        E("name", "name", str, is_array=True),
    )

    name: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupCallPickupGetInstanceResponse(OCIResponse):
    """
    Response to the ``GroupCallPickupGetInstanceRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCallProcessingGetPolicyResponse14(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest14()``.


    Attributes:
        use_group_setting: useGroupSetting
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
    """

    _ELEMENTS = (
        E("use_group_setting", "useGroupSetting", bool, is_required=True),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
    )

    use_group_setting: bool = Field(type=bool, required=True, mutable=False)
    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )


class GroupCallProcessingGetPolicyResponse14sp1(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest14sp1()``.


    Attributes:
        use_group_setting: useGroupSetting
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
    """

    _ELEMENTS = (
        E("use_group_setting", "useGroupSetting", bool, is_required=True),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
    )

    use_group_setting: bool = Field(type=bool, required=True, mutable=False)
    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )


class GroupCallProcessingGetPolicyResponse14sp4(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest14sp4()``.

    Replaced By : ``GroupCallProcessingGetPolicyResponse15()``

    Attributes:
        use_group_setting: useGroupSetting
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_external_calls_via_private_dialing_plan:
            overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
    """

    _ELEMENTS = (
        E("use_group_setting", "useGroupSetting", bool, is_required=True),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_external_calls_via_private_dialing_plan",
            "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan", bool,
            is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
    )

    use_group_setting: bool = Field(type=bool, required=True, mutable=False)
    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    override_clid_restriction_for_external_calls_via_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(type=bool, required=True, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )


class GroupCallProcessingGetPolicyResponse14sp7(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest14sp7()``.


    Attributes:
        use_group_clid_setting: useGroupCLIDSetting
        use_group_media_setting: useGroupMediaSetting
        use_group_call_limits_setting: useGroupCallLimitsSetting
        use_group_translation_routing_setting: useGroupTranslationRoutingSetting
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_external_calls_via_private_dialing_plan:
            overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
        clid_policy: clidPolicy
        emergency_clid_policy: emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity:
            allowAlternateNumbersForRedirectingIdentity
        use_group_name: useGroupName
    """

    _ELEMENTS = (
        E("use_group_clid_setting", "useGroupCLIDSetting", bool, is_required=True),
        E("use_group_media_setting", "useGroupMediaSetting", bool, is_required=True),
        E(
            "use_group_call_limits_setting", "useGroupCallLimitsSetting", bool,
            is_required=True,
        ),
        E(
            "use_group_translation_routing_setting", "useGroupTranslationRoutingSetting",
            bool, is_required=True,
        ),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_external_calls_via_private_dialing_plan",
            "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan", bool,
            is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E("use_group_name", "useGroupName", bool, is_required=True),
    )

    use_group_clid_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_media_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_call_limits_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_translation_routing_setting: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    override_clid_restriction_for_external_calls_via_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(type=bool, required=True, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )
    clid_policy: str = Field(type=str, required=True, mutable=False)
    emergency_clid_policy: str = Field(type=str, required=True, mutable=False)
    allow_alternate_numbers_for_redirecting_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_group_name: bool = Field(type=bool, required=True, mutable=False)


class GroupCallProcessingGetPolicyResponse15(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest15()``.


    Attributes:
        use_group_setting: useGroupSetting
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category:
            overrideCLIDRestrictionForPrivateCallCategory
        use_enterprise_clid_for_private_call_category:
            useEnterpriseCLIDForPrivateCallCategory
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
    """

    _ELEMENTS = (
        E("use_group_setting", "useGroupSetting", bool, is_required=True),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
    )

    use_group_setting: bool = Field(type=bool, required=True, mutable=False)
    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    override_clid_restriction_for_private_call_category: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_enterprise_clid_for_private_call_category: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(type=bool, required=True, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )


class GroupCallProcessingGetPolicyResponse15sp2(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest15sp2()``.


    Attributes:
        use_group_clid_setting: useGroupCLIDSetting
        use_group_media_setting: useGroupMediaSetting
        use_group_call_limits_setting: useGroupCallLimitsSetting
        use_group_translation_routing_setting: useGroupTranslationRoutingSetting
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category:
            overrideCLIDRestrictionForPrivateCallCategory
        use_enterprise_clid_for_private_call_category:
            useEnterpriseCLIDForPrivateCallCategory
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
        clid_policy: clidPolicy
        emergency_clid_policy: emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity:
            allowAlternateNumbersForRedirectingIdentity
        use_group_name: useGroupName
    """

    _ELEMENTS = (
        E("use_group_clid_setting", "useGroupCLIDSetting", bool, is_required=True),
        E("use_group_media_setting", "useGroupMediaSetting", bool, is_required=True),
        E(
            "use_group_call_limits_setting", "useGroupCallLimitsSetting", bool,
            is_required=True,
        ),
        E(
            "use_group_translation_routing_setting", "useGroupTranslationRoutingSetting",
            bool, is_required=True,
        ),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E("use_group_name", "useGroupName", bool, is_required=True),
    )

    use_group_clid_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_media_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_call_limits_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_translation_routing_setting: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    override_clid_restriction_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_enterprise_clid_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(type=bool, required=True, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )
    clid_policy: str = Field(type=str, required=True, mutable=False)
    emergency_clid_policy: str = Field(type=str, required=True, mutable=False)
    allow_alternate_numbers_for_redirecting_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_group_name: bool = Field(type=bool, required=True, mutable=False)


class GroupCallProcessingGetPolicyResponse16(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest16()``.


    Attributes:
        use_group_clid_setting: useGroupCLIDSetting
        use_group_media_setting: useGroupMediaSetting
        use_group_call_limits_setting: useGroupCallLimitsSetting
        use_group_translation_routing_setting: useGroupTranslationRoutingSetting
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category:
            overrideCLIDRestrictionForPrivateCallCategory
        use_enterprise_clid_for_private_call_category:
            useEnterpriseCLIDForPrivateCallCategory
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
        clid_policy: clidPolicy
        emergency_clid_policy: emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity:
            allowAlternateNumbersForRedirectingIdentity
        use_group_name: useGroupName
    """

    _ELEMENTS = (
        E("use_group_clid_setting", "useGroupCLIDSetting", bool, is_required=True),
        E("use_group_media_setting", "useGroupMediaSetting", bool, is_required=True),
        E(
            "use_group_call_limits_setting", "useGroupCallLimitsSetting", bool,
            is_required=True,
        ),
        E(
            "use_group_translation_routing_setting", "useGroupTranslationRoutingSetting",
            bool, is_required=True,
        ),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E("use_group_name", "useGroupName", bool, is_required=True),
    )

    use_group_clid_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_media_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_call_limits_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_translation_routing_setting: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    override_clid_restriction_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_enterprise_clid_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(type=bool, required=True, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )
    clid_policy: str = Field(type=str, required=True, mutable=False)
    emergency_clid_policy: str = Field(type=str, required=True, mutable=False)
    allow_alternate_numbers_for_redirecting_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_group_name: bool = Field(type=bool, required=True, mutable=False)


class GroupCallProcessingGetPolicyResponse16sp2(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest16sp2()``.


    Attributes:
        use_group_clid_setting: useGroupCLIDSetting
        use_group_media_setting: useGroupMediaSetting
        use_group_call_limits_setting: useGroupCallLimitsSetting
        use_group_translation_routing_setting: useGroupTranslationRoutingSetting
        use_group_dclid_setting: useGroupDCLIDSetting
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category:
            overrideCLIDRestrictionForPrivateCallCategory
        use_enterprise_clid_for_private_call_category:
            useEnterpriseCLIDForPrivateCallCategory
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
        clid_policy: clidPolicy
        emergency_clid_policy: emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity:
            allowAlternateNumbersForRedirectingIdentity
        use_group_name: useGroupName
        enable_dialable_caller_id: enableDialableCallerID
    """

    _ELEMENTS = (
        E("use_group_clid_setting", "useGroupCLIDSetting", bool, is_required=True),
        E("use_group_media_setting", "useGroupMediaSetting", bool, is_required=True),
        E(
            "use_group_call_limits_setting", "useGroupCallLimitsSetting", bool,
            is_required=True,
        ),
        E(
            "use_group_translation_routing_setting", "useGroupTranslationRoutingSetting",
            bool, is_required=True,
        ),
        E("use_group_dclid_setting", "useGroupDCLIDSetting", bool, is_required=True),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E("use_group_name", "useGroupName", bool, is_required=True),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool, is_required=True),
    )

    use_group_clid_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_media_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_call_limits_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_translation_routing_setting: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_group_dclid_setting: bool = Field(type=bool, required=True, mutable=False)
    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    override_clid_restriction_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_enterprise_clid_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(type=bool, required=True, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )
    clid_policy: str = Field(type=str, required=True, mutable=False)
    emergency_clid_policy: str = Field(type=str, required=True, mutable=False)
    allow_alternate_numbers_for_redirecting_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_group_name: bool = Field(type=bool, required=True, mutable=False)
    enable_dialable_caller_id: bool = Field(type=bool, required=True, mutable=False)


class GroupCallProcessingGetPolicyResponse17(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest17()``.


    Attributes:
        use_group_clid_setting: useGroupCLIDSetting
        use_group_media_setting: useGroupMediaSetting
        use_group_call_limits_setting: useGroupCallLimitsSetting
        use_group_translation_routing_setting: useGroupTranslationRoutingSetting
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category:
            overrideCLIDRestrictionForPrivateCallCategory
        use_enterprise_clid_for_private_call_category:
            useEnterpriseCLIDForPrivateCallCategory
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
        clid_policy: clidPolicy
        emergency_clid_policy: emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity:
            allowAlternateNumbersForRedirectingIdentity
        use_group_name: useGroupName
        block_calling_name_for_external_calls: blockCallingNameForExternalCalls
    """

    _ELEMENTS = (
        E("use_group_clid_setting", "useGroupCLIDSetting", bool, is_required=True),
        E("use_group_media_setting", "useGroupMediaSetting", bool, is_required=True),
        E(
            "use_group_call_limits_setting", "useGroupCallLimitsSetting", bool,
            is_required=True,
        ),
        E(
            "use_group_translation_routing_setting", "useGroupTranslationRoutingSetting",
            bool, is_required=True,
        ),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E("use_group_name", "useGroupName", bool, is_required=True),
        E(
            "block_calling_name_for_external_calls", "blockCallingNameForExternalCalls",
            bool, is_required=True,
        ),
    )

    use_group_clid_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_media_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_call_limits_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_translation_routing_setting: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    override_clid_restriction_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_enterprise_clid_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(type=bool, required=True, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )
    clid_policy: str = Field(type=str, required=True, mutable=False)
    emergency_clid_policy: str = Field(type=str, required=True, mutable=False)
    allow_alternate_numbers_for_redirecting_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_group_name: bool = Field(type=bool, required=True, mutable=False)
    block_calling_name_for_external_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )


class GroupCallProcessingGetPolicyResponse17sp3(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest17sp3()``.

    The following elements are only used in AS data mode: useGroupDCLIDSetting
    enableDialableCallerID Replaced by ``GroupCallProcessingGetPolicyResponse17sp4()``

    Attributes:
        use_group_clid_setting: useGroupCLIDSetting
        use_group_media_setting: useGroupMediaSetting
        use_group_call_limits_setting: useGroupCallLimitsSetting
        use_group_translation_routing_setting: useGroupTranslationRoutingSetting
        use_group_dclid_setting: useGroupDCLIDSetting
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category:
            overrideCLIDRestrictionForPrivateCallCategory
        use_enterprise_clid_for_private_call_category:
            useEnterpriseCLIDForPrivateCallCategory
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
        clid_policy: clidPolicy
        emergency_clid_policy: emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity:
            allowAlternateNumbersForRedirectingIdentity
        use_group_name: useGroupName
        block_calling_name_for_external_calls: blockCallingNameForExternalCalls
        enable_dialable_caller_id: enableDialableCallerID
    """

    _ELEMENTS = (
        E("use_group_clid_setting", "useGroupCLIDSetting", bool, is_required=True),
        E("use_group_media_setting", "useGroupMediaSetting", bool, is_required=True),
        E(
            "use_group_call_limits_setting", "useGroupCallLimitsSetting", bool,
            is_required=True,
        ),
        E(
            "use_group_translation_routing_setting", "useGroupTranslationRoutingSetting",
            bool, is_required=True,
        ),
        E("use_group_dclid_setting", "useGroupDCLIDSetting", bool, is_required=True),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E("use_group_name", "useGroupName", bool, is_required=True),
        E(
            "block_calling_name_for_external_calls", "blockCallingNameForExternalCalls",
            bool, is_required=True,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool, is_required=True),
    )

    use_group_clid_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_media_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_call_limits_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_translation_routing_setting: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_group_dclid_setting: bool = Field(type=bool, required=True, mutable=False)
    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    override_clid_restriction_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_enterprise_clid_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(type=bool, required=True, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )
    clid_policy: str = Field(type=str, required=True, mutable=False)
    emergency_clid_policy: str = Field(type=str, required=True, mutable=False)
    allow_alternate_numbers_for_redirecting_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_group_name: bool = Field(type=bool, required=True, mutable=False)
    block_calling_name_for_external_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_dialable_caller_id: bool = Field(type=bool, required=True, mutable=False)


class GroupCallProcessingGetPolicyResponse17sp4(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest17sp4()``.

    The following elements are only used in AS data mode: useGroupDCLIDSetting
    enableDialableCallerID allowConfigurableCLIDForRedirectingIdentity Replaced by
    ``GroupCallProcessingGetPolicyResponse18()``

    Attributes:
        use_group_clid_setting: useGroupCLIDSetting
        use_group_media_setting: useGroupMediaSetting
        use_group_call_limits_setting: useGroupCallLimitsSetting
        use_group_translation_routing_setting: useGroupTranslationRoutingSetting
        use_group_dclid_setting: useGroupDCLIDSetting
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category:
            overrideCLIDRestrictionForPrivateCallCategory
        use_enterprise_clid_for_private_call_category:
            useEnterpriseCLIDForPrivateCallCategory
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
        clid_policy: clidPolicy
        emergency_clid_policy: emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity:
            allowAlternateNumbersForRedirectingIdentity
        use_group_name: useGroupName
        block_calling_name_for_external_calls: blockCallingNameForExternalCalls
        enable_dialable_caller_id: enableDialableCallerID
        allow_configurable_clid_for_redirecting_identity:
            allowConfigurableCLIDForRedirectingIdentity
    """

    _ELEMENTS = (
        E("use_group_clid_setting", "useGroupCLIDSetting", bool, is_required=True),
        E("use_group_media_setting", "useGroupMediaSetting", bool, is_required=True),
        E(
            "use_group_call_limits_setting", "useGroupCallLimitsSetting", bool,
            is_required=True,
        ),
        E(
            "use_group_translation_routing_setting", "useGroupTranslationRoutingSetting",
            bool, is_required=True,
        ),
        E("use_group_dclid_setting", "useGroupDCLIDSetting", bool, is_required=True),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E("use_group_name", "useGroupName", bool, is_required=True),
        E(
            "block_calling_name_for_external_calls", "blockCallingNameForExternalCalls",
            bool, is_required=True,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool, is_required=True),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool, is_required=True,
        ),
    )

    use_group_clid_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_media_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_call_limits_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_translation_routing_setting: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_group_dclid_setting: bool = Field(type=bool, required=True, mutable=False)
    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    override_clid_restriction_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_enterprise_clid_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(type=bool, required=True, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )
    clid_policy: str = Field(type=str, required=True, mutable=False)
    emergency_clid_policy: str = Field(type=str, required=True, mutable=False)
    allow_alternate_numbers_for_redirecting_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_group_name: bool = Field(type=bool, required=True, mutable=False)
    block_calling_name_for_external_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_dialable_caller_id: bool = Field(type=bool, required=True, mutable=False)
    allow_configurable_clid_for_redirecting_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )


class GroupCallProcessingGetPolicyResponse18(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest18()``.

    The following elements are only used in AS data mode: useGroupDCLIDSetting
    enableDialableCallerID allowConfigurableCLIDForRedirectingIdentity
    allowDepartmentCLIDNameOverride

    Attributes:
        use_group_clid_setting: useGroupCLIDSetting
        use_group_media_setting: useGroupMediaSetting
        use_group_call_limits_setting: useGroupCallLimitsSetting
        use_group_translation_routing_setting: useGroupTranslationRoutingSetting
        use_group_dclid_setting: useGroupDCLIDSetting
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category:
            overrideCLIDRestrictionForPrivateCallCategory
        use_enterprise_clid_for_private_call_category:
            useEnterpriseCLIDForPrivateCallCategory
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
        clid_policy: clidPolicy
        emergency_clid_policy: emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity:
            allowAlternateNumbersForRedirectingIdentity
        use_group_name: useGroupName
        block_calling_name_for_external_calls: blockCallingNameForExternalCalls
        enable_dialable_caller_id: enableDialableCallerID
        allow_configurable_clid_for_redirecting_identity:
            allowConfigurableCLIDForRedirectingIdentity
        allow_department_clid_name_override: allowDepartmentCLIDNameOverride
    """

    _ELEMENTS = (
        E("use_group_clid_setting", "useGroupCLIDSetting", bool, is_required=True),
        E("use_group_media_setting", "useGroupMediaSetting", bool, is_required=True),
        E(
            "use_group_call_limits_setting", "useGroupCallLimitsSetting", bool,
            is_required=True,
        ),
        E(
            "use_group_translation_routing_setting", "useGroupTranslationRoutingSetting",
            bool, is_required=True,
        ),
        E("use_group_dclid_setting", "useGroupDCLIDSetting", bool, is_required=True),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E("use_group_name", "useGroupName", bool, is_required=True),
        E(
            "block_calling_name_for_external_calls", "blockCallingNameForExternalCalls",
            bool, is_required=True,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool, is_required=True),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool, is_required=True,
        ),
        E(
            "allow_department_clid_name_override", "allowDepartmentCLIDNameOverride",
            bool, is_required=True,
        ),
    )

    use_group_clid_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_media_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_call_limits_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_translation_routing_setting: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_group_dclid_setting: bool = Field(type=bool, required=True, mutable=False)
    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    override_clid_restriction_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_enterprise_clid_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(type=bool, required=True, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )
    clid_policy: str = Field(type=str, required=True, mutable=False)
    emergency_clid_policy: str = Field(type=str, required=True, mutable=False)
    allow_alternate_numbers_for_redirecting_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_group_name: bool = Field(type=bool, required=True, mutable=False)
    block_calling_name_for_external_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_dialable_caller_id: bool = Field(type=bool, required=True, mutable=False)
    allow_configurable_clid_for_redirecting_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_department_clid_name_override: bool = Field(type=bool, required=True, mutable=False)


class GroupCallProcessingGetPolicyResponse18sp1(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest18()``.

    The following elements are only used in AS data mode: useGroupDCLIDSetting
    enableDialableCallerID allowConfigurableCLIDForRedirectingIdentity
    allowDepartmentCLIDNameOverride enterpriseCallsCLIDPolicy groupCallsCLIDPolicy
    Replaced by: ``GroupCallProcessingGetPolicyResponse19sp1()``

    Attributes:
        use_group_clid_setting: useGroupCLIDSetting
        use_group_media_setting: useGroupMediaSetting
        use_group_call_limits_setting: useGroupCallLimitsSetting
        use_group_translation_routing_setting: useGroupTranslationRoutingSetting
        use_group_dclid_setting: useGroupDCLIDSetting
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category:
            overrideCLIDRestrictionForPrivateCallCategory
        use_enterprise_clid_for_private_call_category:
            useEnterpriseCLIDForPrivateCallCategory
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
        clid_policy: clidPolicy
        emergency_clid_policy: emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity:
            allowAlternateNumbersForRedirectingIdentity
        use_group_name: useGroupName
        block_calling_name_for_external_calls: blockCallingNameForExternalCalls
        enable_dialable_caller_id: enableDialableCallerID
        allow_configurable_clid_for_redirecting_identity:
            allowConfigurableCLIDForRedirectingIdentity
        allow_department_clid_name_override: allowDepartmentCLIDNameOverride
        enterprise_calls_clid_policy: enterpriseCallsCLIDPolicy
        group_calls_clid_policy: groupCallsCLIDPolicy
    """

    _ELEMENTS = (
        E("use_group_clid_setting", "useGroupCLIDSetting", bool, is_required=True),
        E("use_group_media_setting", "useGroupMediaSetting", bool, is_required=True),
        E(
            "use_group_call_limits_setting", "useGroupCallLimitsSetting", bool,
            is_required=True,
        ),
        E(
            "use_group_translation_routing_setting", "useGroupTranslationRoutingSetting",
            bool, is_required=True,
        ),
        E("use_group_dclid_setting", "useGroupDCLIDSetting", bool, is_required=True),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E("use_group_name", "useGroupName", bool, is_required=True),
        E(
            "block_calling_name_for_external_calls", "blockCallingNameForExternalCalls",
            bool, is_required=True,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool, is_required=True),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool, is_required=True,
        ),
        E(
            "allow_department_clid_name_override", "allowDepartmentCLIDNameOverride",
            bool, is_required=True,
        ),
        E("enterprise_calls_clid_policy", "enterpriseCallsCLIDPolicy", str, is_required=True),
        E("group_calls_clid_policy", "groupCallsCLIDPolicy", str, is_required=True),
    )

    use_group_clid_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_media_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_call_limits_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_translation_routing_setting: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_group_dclid_setting: bool = Field(type=bool, required=True, mutable=False)
    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    override_clid_restriction_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_enterprise_clid_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(type=bool, required=True, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )
    clid_policy: str = Field(type=str, required=True, mutable=False)
    emergency_clid_policy: str = Field(type=str, required=True, mutable=False)
    allow_alternate_numbers_for_redirecting_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_group_name: bool = Field(type=bool, required=True, mutable=False)
    block_calling_name_for_external_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_dialable_caller_id: bool = Field(type=bool, required=True, mutable=False)
    allow_configurable_clid_for_redirecting_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_department_clid_name_override: bool = Field(type=bool, required=True, mutable=False)
    enterprise_calls_clid_policy: str = Field(type=str, required=True, mutable=False)
    group_calls_clid_policy: str = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyResponse19sp1(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest()``.

    The following elements are only used in AS data mode: useGroupDCLIDSetting
    enableDialableCallerID allowConfigurableCLIDForRedirectingIdentity
    allowDepartmentCLIDNameOverride enterpriseCallsCLIDPolicy groupCallsCLIDPolicy

    Attributes:
        use_group_clid_setting: useGroupCLIDSetting
        use_group_media_setting: useGroupMediaSetting
        use_group_call_limits_setting: useGroupCallLimitsSetting
        use_group_translation_routing_setting: useGroupTranslationRoutingSetting
        use_group_dclid_setting: useGroupDCLIDSetting
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category:
            overrideCLIDRestrictionForPrivateCallCategory
        use_enterprise_clid_for_private_call_category:
            useEnterpriseCLIDForPrivateCallCategory
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
        clid_policy: clidPolicy
        emergency_clid_policy: emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity:
            allowAlternateNumbersForRedirectingIdentity
        use_group_name: useGroupName
        block_calling_name_for_external_calls: blockCallingNameForExternalCalls
        enable_dialable_caller_id: enableDialableCallerID
        allow_configurable_clid_for_redirecting_identity:
            allowConfigurableCLIDForRedirectingIdentity
        allow_department_clid_name_override: allowDepartmentCLIDNameOverride
        enterprise_calls_clid_policy: enterpriseCallsCLIDPolicy
        group_calls_clid_policy: groupCallsCLIDPolicy
    """

    _ELEMENTS = (
        E("use_group_clid_setting", "useGroupCLIDSetting", bool, is_required=True),
        E("use_group_media_setting", "useGroupMediaSetting", bool, is_required=True),
        E(
            "use_group_call_limits_setting", "useGroupCallLimitsSetting", bool,
            is_required=True,
        ),
        E(
            "use_group_translation_routing_setting", "useGroupTranslationRoutingSetting",
            bool, is_required=True,
        ),
        E("use_group_dclid_setting", "useGroupDCLIDSetting", bool, is_required=True),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E("use_group_name", "useGroupName", bool, is_required=True),
        E(
            "block_calling_name_for_external_calls", "blockCallingNameForExternalCalls",
            bool, is_required=True,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool, is_required=True),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool, is_required=True,
        ),
        E(
            "allow_department_clid_name_override", "allowDepartmentCLIDNameOverride",
            bool, is_required=True,
        ),
        E("enterprise_calls_clid_policy", "enterpriseCallsCLIDPolicy", str, is_required=True),
        E("group_calls_clid_policy", "groupCallsCLIDPolicy", str, is_required=True),
    )

    use_group_clid_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_media_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_call_limits_setting: bool = Field(type=bool, required=True, mutable=False)
    use_group_translation_routing_setting: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_group_dclid_setting: bool = Field(type=bool, required=True, mutable=False)
    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    override_clid_restriction_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_enterprise_clid_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(type=bool, required=True, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )
    clid_policy: str = Field(type=str, required=True, mutable=False)
    emergency_clid_policy: str = Field(type=str, required=True, mutable=False)
    allow_alternate_numbers_for_redirecting_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_group_name: bool = Field(type=bool, required=True, mutable=False)
    block_calling_name_for_external_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_dialable_caller_id: bool = Field(type=bool, required=True, mutable=False)
    allow_configurable_clid_for_redirecting_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_department_clid_name_override: bool = Field(type=bool, required=True, mutable=False)
    enterprise_calls_clid_policy: str = Field(type=str, required=True, mutable=False)
    group_calls_clid_policy: str = Field(type=str, required=True, mutable=False)


class GroupCallRecordingGetResponse(OCIResponse):
    """
    Response to the ``GroupCallRecordingGetRequest()``.

    The response contains the group's Call Recording platform information.

    Attributes:
        name: name
    """

    _ELEMENTS = (
        E("name", "name", str),
    )

    name: str = Field(type=str, required=False, mutable=False)


class GroupCallingLineIdGetResponse(OCIResponse):
    """
    Response to the ``GroupCallingLineIdGetRequest()``.

    The response contains the group's calling line id settings.

    Attributes:
        use_group_number: useGroupNumber
        use_group_name: useGroupName
        calling_line_id_phone_number: callingLineIdPhoneNumber
        calling_line_id_name: callingLineIdName
    """

    _ELEMENTS = (
        E("use_group_number", "useGroupNumber", bool, is_required=True),
        E("use_group_name", "useGroupName", bool, is_required=True),
        E("calling_line_id_phone_number", "callingLineIdPhoneNumber", str),
        E("calling_line_id_name", "callingLineIdName", str),
    )

    use_group_number: bool = Field(type=bool, required=True, mutable=False)
    use_group_name: bool = Field(type=bool, required=True, mutable=False)
    calling_line_id_phone_number: str = Field(type=str, required=False, mutable=False)
    calling_line_id_name: str = Field(type=str, required=False, mutable=False)


class GroupCallingPlanGetDigitPatternListResponse(OCIResponse):
    """
    Response to ``GroupCallingPlanGetDigitPatternListRequest()``.

    Contains a table with column headings: "Name", "Digit Pattern".

    Attributes:
        digit_pattern_table: digitPatternTable
    """

    _ELEMENTS = (
        E(
            "digit_pattern_table", "digitPatternTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    digit_pattern_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCollaborateBridgeGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupCollaborateBridgeGetAvailableUserListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", and "Hiragana First Name", "Phone Number", "Extension", "Department",
    "Email Address".

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCollaborateBridgeGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupCollaborateBridgeGetInstanceListRequest()``.

    Contains a table with column headings: "Service User Id", "Name", "Phone Number",
    "Extension", "Department", "Participants", and "Is Default". The column values for "Is
    default" can either be true, or false.

    Attributes:
        collaborate_bridge_table: collaborateBridgeTable
    """

    _ELEMENTS = (
        E(
            "collaborate_bridge_table", "collaborateBridgeTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    collaborate_bridge_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCommPilotCallManagerGetResponse(OCIResponse):
    """
    Response to ``GroupCommPilotCallManagerGetRequest()``.


    Attributes:
        group_directory: groupDirectory
    """

    _ELEMENTS = (
        E("group_directory", "groupDirectory", str, is_required=True),
    )

    group_directory: str = Field(type=str, required=True, mutable=False)


class GroupCommunicationBarringGetResponse(OCIResponse):
    """
    Response to ``SystemCommunicationBarringGetRequest()``.


    Attributes:
        use_default_service_provider_profile: useDefaultServiceProviderProfile
        profile: profile
    """

    _ELEMENTS = (
        E(
            "use_default_service_provider_profile", "useDefaultServiceProviderProfile",
            bool, is_required=True,
        ),
        E("profile", "profile", str),
    )

    use_default_service_provider_profile: bool = Field(
        type=bool, required=True, mutable=False,
    )
    profile: str = Field(type=str, required=False, mutable=False)


class GroupCommunicationBarringProfileGetAssignedListResponse(OCIResponse):
    """
    Response to the ``GroupCommunicationBarringProfileGetAssignedListRequest()``.

    The response contains a simple list of all communication barring profiles assigned to
    the group.

    Attributes:
        profile_name: profileName
    """

    _ELEMENTS = (
        E("profile_name", "profileName", str, is_array=True),
    )

    profile_name: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupCustomContactDirectoryGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupCustomContactDirectoryGetAvailableUserListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name". Replace by:
    ``GroupCustomContactDirectoryGetAvailableUserListResponse17()``

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCustomContactDirectoryGetAvailableUserListResponse17(OCIResponse):
    """
    Response to the ``GroupCustomContactDirectoryGetAvailableUserListRequest17()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Virtual On-Net Phone Number", "Group Id", "Is
    Virtual On-Net User", "Phone Number", "Extension", "Department", "Email Address". If
    the entry represents a Virtual On-Net user then "User Id" is blank, the "Virtual On-
    Net Phone Number" contains the phone Number of the Virtual On-Net user, the "Group Id"
    contains the Virtual On-Net user's group and the "Is Virtual On-Net User" contains
    true.  If the entry represents a BroadWorks user then the "User Id" contains his
    BroadWorks userId, the "Virtual On-Net Phone Number" and "Group Id" fields are blank
    and the "Is Virtual On-Net User" contains false.

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCustomContactDirectoryGetListResponse(OCIResponse):
    """
    Response to the ``GroupCustomContactDirectoryGetListRequest()``.

    The response contains all the group's custom contact directory names.

    Attributes:
        name: name
    """

    _ELEMENTS = (
        E("name", "name", str, is_array=True),
    )

    name: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupCustomContactDirectoryGetResponse(OCIResponse):
    """
    Response to the ``GroupCustomContactDirectoryGetRequest()``.

    The response contains all the group's custom contact directory names.  Contains a
    table with column headings: "User Id", "Last Name", "First Name", "Hiragana Last
    Name", "Hiragana First Name". Replace by:
    ``GroupCustomContactDirectoryGetResponse17()``

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCustomContactDirectoryGetResponse17(OCIResponse):
    """
    Response to the ``GroupCustomContactDirectoryGetRequest17()``.

    The response contains all the contacts in the group's given custom contact directory.
    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Virtual On-Net Phone Number", "Group Id", "Is
    Virtual On-Net User", "Department", "Phone Number", "Extension", "Mobile", "Email
    Address", "Yahoo Id", "Title", "IMP Id". If the entry represents a Virtual On-Net user
    then "User Id" is blank, the "Virtual On-Net Phone Number" contains the phone Number
    of the Virtual On-Net user, the "Group Id" contains the Virtual On-Net user's group
    and the "Is Virtual On-Net User" contains true.  If the entry represents a BroadWorks
    user then the "User Id" contains his BroadWorks userId, the "Virtual On-Net Phone
    Number" and "Group Id" fields are field is blank and the "Is Virtual On-Net User"
    contains false.

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupCustomRingbackGroupGetResponse(OCIResponse):
    """
    Response to the ``GroupCustomRingbackGroupGetRequest()``.

    Replaced By: ``GroupCustomRingbackGroupGetResponse16()``

    Attributes:
        is_active: isActive
        audio_selection: audioSelection
        audio_file_description: audioFileDescription
        audio_file_url: audioFileUrl
        video_selection: videoSelection
        video_file_description: videoFileDescription
        video_file_url: videoFileUrl
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("audio_selection", "audioSelection", str, is_required=True),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_file_url", "audioFileUrl", str),
        E("video_selection", "videoSelection", str, is_required=True),
        E("video_file_description", "videoFileDescription", str),
        E("video_file_url", "videoFileUrl", str),
    )

    is_active: bool = Field(type=bool, required=True, mutable=False)
    audio_selection: str = Field(type=str, required=True, mutable=False)
    audio_file_description: str = Field(type=str, required=False, mutable=False)
    audio_file_url: str = Field(type=str, required=False, mutable=False)
    video_selection: str = Field(type=str, required=True, mutable=False)
    video_file_description: str = Field(type=str, required=False, mutable=False)
    video_file_url: str = Field(type=str, required=False, mutable=False)


class GroupCustomRingbackGroupGetResponse16(OCIResponse):
    """
    Response to the ``GroupCustomRingbackGroupGetRequest16()``.


    Attributes:
        is_active: isActive
        audio_selection: audioSelection
        audio_file_description: audioFileDescription
        audio_media_type: audioMediaType
        audio_file_url: audioFileUrl
        video_selection: videoSelection
        video_file_description: videoFileDescription
        video_media_type: videoMediaType
        video_file_url: videoFileUrl
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("audio_selection", "audioSelection", str, is_required=True),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("audio_file_url", "audioFileUrl", str),
        E("video_selection", "videoSelection", str, is_required=True),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
        E("video_file_url", "videoFileUrl", str),
    )

    is_active: bool = Field(type=bool, required=True, mutable=False)
    audio_selection: str = Field(type=str, required=True, mutable=False)
    audio_file_description: str = Field(type=str, required=False, mutable=False)
    audio_media_type: str = Field(type=str, required=False, mutable=False)
    audio_file_url: str = Field(type=str, required=False, mutable=False)
    video_selection: str = Field(type=str, required=True, mutable=False)
    video_file_description: str = Field(type=str, required=False, mutable=False)
    video_media_type: str = Field(type=str, required=False, mutable=False)
    video_file_url: str = Field(type=str, required=False, mutable=False)


class GroupDepartmentAdminGetListResponse(OCIResponse):
    """
    Response to ``GroupDepartmentAdminGetListRequest()``.

    Contains a 5 column table with column headings "Administrator ID", "Last Name", "First
    Name", "Department", "Language".

    Attributes:
        department_admin_table: departmentAdminTable
    """

    _ELEMENTS = (
        E(
            "department_admin_table", "departmentAdminTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    department_admin_table: "list" = Field(type=list, required=True, mutable=False)


class GroupDepartmentGetListResponse18(OCIResponse):
    """
    Response to ``GroupDepartmentGetListRequest18()``.

    Contains a table of department attributes.  The column headings are: "Is Enterprise
    Department", "Department Name", "Full Path Name", "Calling Line Id Name", and "Calling
    Line Id Phone Number"

    Attributes:
        department_table: departmentTable
    """

    _ELEMENTS = (
        E(
            "department_table", "departmentTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    department_table: "list" = Field(type=list, required=True, mutable=False)


class GroupDeviceManagementEventGetListResponse(OCIResponse):
    """
    Response to ``GroupDeviceManagementEventGetListRequest()``.

    Contains a table with column headings: "Event Id", "Status", "Action", "Level",
    "Type", "Additional Info", "Is Local", "Completion %", "Pushed/ Same Hash/ Not
    Pushed", "Login Id", "Start Time", "Process Time". "Event Id" is a unique identifer
    for the event.  "Status" can be: Pending, Queued, In Progress, Process On Other Host,
    Stale, Completed, Canceled.  "Action" can be: Delete, Download, Rebuild, Reset,
    Upload.  "Level" can be: Device, Device Type, Device Type Group, Group, User.  "Type"
    can be: Automatic, Manual.  "Additional Info" includes the affected device type,
    device or group.  It depends on the level of the event: Device Profile: "Device Name"
    "Service Provider Id" "Group Id" Device Type: "Device Type Name" Device Type Group:
    "Service Provider Id" "Group Id" "Device Type Name" Group: "Service Provider Id"
    "Group Id" User: "User Id" "Is Local" is set to "yes" if the event is processed on the
    server who received the request, "no" otherwise meaning that the event is processed on
    another server.  "Completion %" provides an estimate of the completion of the event.
    A percentage is given, the current number of completed expanded event, and the total
    number of expanded event.  "Pushed/ Same Hash/ Not Pushed" gives the total number of
    files that were pushed, not pushed because of same hash, and not pushed when
    processing the event.  "LoginId" is the user or admin id who triggered the event.
    "Start Time" is the date when the event was started.  The display shows the month,
    days, hours, and minutes (MM-dd hh:mm). "Process Time" is the time taken to process
    the event in hours, minutes, seconds, and milliseconds (hhhh:mm:ss.SSS). Each row
    represents an event sorted by priority of processing.  The first row in the table is
    an event that has an associated expanded event currently being processed or next in
    line to be processed.

    Attributes:
        event_table: eventTable
    """

    _ELEMENTS = (
        E(
            "event_table", "eventTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    event_table: "list" = Field(type=list, required=True, mutable=False)


class GroupDeviceManagementGetAccessDeviceCountForDeviceTypeGroupResponse(OCIResponse):
    """
    Response to ``GroupDeviceManagementGetAccessDeviceCountForDeviceTypeGroupRequest()``.


    Attributes:
        access_device_count: accessDeviceCount
    """

    _ELEMENTS = (
        E("access_device_count", "accessDeviceCount", int, is_required=True),
    )

    access_device_count: int = Field(type=int, required=True, mutable=False)


class GroupDeviceTypeCustomTagGetListResponse(OCIResponse):
    """
    Response to ``GroupDeviceTypeCustomTagGetListRequest()``.

    Contains a table of custom configuration tags managed by the Device Management System
    on a per-device type basis for a group.  The column headings are: "Tag Name", "Tag
    Value"

    Attributes:
        group_device_type_custom_tags_table: groupDeviceTypeCustomTagsTable
    """

    _ELEMENTS = (
        E(
            "group_device_type_custom_tags_table", "groupDeviceTypeCustomTagsTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    group_device_type_custom_tags_table: "list" = Field(
        type=list, required=True, mutable=False,
    )


class GroupDeviceTypeFileGetListResponse(OCIResponse):
    """
    Response to ``GroupDeviceTypeFileGetListRequest()``.

    Contains a table of device type files managed by the Device Management System, on a
    per-group basis.  The column headings are: "File Type", "File Format", "Is
    Authenticated".

    Replaced By: ``GroupDeviceTypeFileGetListResponse14sp8()``

    Attributes:
        group_device_type_files_table: groupDeviceTypeFilesTable
    """

    _ELEMENTS = (
        E(
            "group_device_type_files_table", "groupDeviceTypeFilesTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    group_device_type_files_table: "list" = Field(type=list, required=True, mutable=False)


class GroupDeviceTypeFileGetListResponse14sp8(OCIResponse):
    """
    Response to ``GroupDeviceTypeFileGetListRequest14sp8()``.

    Contains a table of device type files managed by the Device Management System, on a
    per-group basis.  The column headings are: "File Format", "Is Authenticated", "Access
    URL", "Repository URL", "Template URL". Replaced by:
    GroupDeviceTypeFileGetListResponset21.

    Attributes:
        group_device_type_files_table: groupDeviceTypeFilesTable
        group_has_files_with_customizable_tags: groupHasFilesWithCustomizableTags
    """

    _ELEMENTS = (
        E(
            "group_device_type_files_table", "groupDeviceTypeFilesTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
        E(
            "group_has_files_with_customizable_tags", "groupHasFilesWithCustomizableTags",
            bool,
        ),
    )

    group_device_type_files_table: "list" = Field(type=list, required=True, mutable=False)
    group_has_files_with_customizable_tags: bool = Field(
        type=bool, required=False, mutable=False,
    )


class GroupDeviceTypeFileGetListResponse21(OCIResponse):
    """
    Response to ``GroupDeviceTypeFileGetListRequest21()``.

    Contains a table of device type files managed by the Device Management System, on a
    per-group basis.  The column headings are: "File Format", "Is Authenticated", "Access
    URL", "Repository URL", "Template URL".

    Attributes:
        group_device_type_files_table: groupDeviceTypeFilesTable
        group_has_customizable_dynamic_files: groupHasCustomizableDynamicFiles
    """

    _ELEMENTS = (
        E(
            "group_device_type_files_table", "groupDeviceTypeFilesTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
        E(
            "group_has_customizable_dynamic_files", "groupHasCustomizableDynamicFiles",
            bool, is_required=True,
        ),
    )

    group_device_type_files_table: "list" = Field(type=list, required=True, mutable=False)
    group_has_customizable_dynamic_files: bool = Field(
        type=bool, required=True, mutable=False,
    )


class GroupDeviceTypeFileGetResponse(OCIResponse):
    """
    Response to ``GroupDeviceTypeFileGetRequest()``.

    Replaced By: ``GroupDeviceTypeFileGetResponse14sp8()``

    Attributes:
        file_source: fileSource
        configuration_file_name: configurationFileName
    """

    _ELEMENTS = (
        E("file_source", "fileSource", str),
        E("configuration_file_name", "configurationFileName", str),
    )

    file_source: str = Field(type=str, required=False, mutable=False)
    configuration_file_name: str = Field(type=str, required=False, mutable=False)


class GroupDeviceTypeFileGetResponse14sp8(OCIResponse):
    """
    Response to ``GroupDeviceTypeFileGetRequest14sp8()``.

    Replaced by: ``GroupDeviceTypeFileGetResponse16sp1()``

    Attributes:
        file_source: fileSource
        configuration_file_name: configurationFileName
    """

    _ELEMENTS = (
        E("file_source", "fileSource", str),
        E("configuration_file_name", "configurationFileName", str),
    )

    file_source: str = Field(type=str, required=False, mutable=False)
    configuration_file_name: str = Field(type=str, required=False, mutable=False)


class GroupDeviceTypeFileGetResponse16sp1(OCIResponse):
    """
    Response to ``GroupDeviceTypeFileGetRequest16sp1()``.


    Attributes:
        file_source: fileSource
        configuration_file_name: configurationFileName
        access_url: accessUrl
        repository_url: repositoryUrl
        template_url: templateUrl
    """

    _ELEMENTS = (
        E("file_source", "fileSource", str),
        E("configuration_file_name", "configurationFileName", str),
        E("access_url", "accessUrl", str, is_required=True),
        E("repository_url", "repositoryUrl", str),
        E("template_url", "templateUrl", str),
    )

    file_source: str = Field(type=str, required=False, mutable=False)
    configuration_file_name: str = Field(type=str, required=False, mutable=False)
    access_url: str = Field(type=str, required=True, mutable=False)
    repository_url: str = Field(type=str, required=False, mutable=False)
    template_url: str = Field(type=str, required=False, mutable=False)


class GroupDialPlanPolicyGetAccessCodeListResponse(OCIResponse):
    """
    Response to ``GroupDialPlanPolicyGetAccessCodeListRequest()`` Contains a table with
    column headings: "Access Code", "Enable Secondary Dial Tone", "Description"

    Attributes:
        access_code_table: accessCodeTable
    """

    _ELEMENTS = (
        E(
            "access_code_table", "accessCodeTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    access_code_table: "list" = Field(type=list, required=True, mutable=False)


class GroupDialPlanPolicyGetAccessCodeResponse(OCIResponse):
    """
    Response to ``GroupDialPlanPolicyGetAccessCodeRequest()``

    Attributes:
        include_code_for_network_translations_and_routing:
            includeCodeForNetworkTranslationsAndRouting
        include_code_for_screening_services: includeCodeForScreeningServices
        enable_secondary_dial_tone: enableSecondaryDialTone
        description: description
    """

    _ELEMENTS = (
        E(
            "include_code_for_network_translations_and_routing",
            "includeCodeForNetworkTranslationsAndRouting", bool, is_required=True,
        ),
        E(
            "include_code_for_screening_services", "includeCodeForScreeningServices",
            bool, is_required=True,
        ),
        E("enable_secondary_dial_tone", "enableSecondaryDialTone", bool, is_required=True),
        E("description", "description", str),
    )

    include_code_for_network_translations_and_routing: bool = Field(
        type=bool, required=True, mutable=False,
    )
    include_code_for_screening_services: bool = Field(type=bool, required=True, mutable=False)
    enable_secondary_dial_tone: bool = Field(type=bool, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class GroupDialPlanPolicyGetResponse(OCIResponse):
    """
    Response to ``GroupDialPlanPolicyGetRequest()`` Replaced by:
    ``GroupDialPlanPolicyGetResponse17()``

    Attributes:
        use_setting: useSetting
        requires_access_code_for_public_calls: requiresAccessCodeForPublicCalls
        allow_e164_public_calls: allowE164PublicCalls
        public_digit_map: publicDigitMap
        private_digit_map: privateDigitMap
    """

    _ELEMENTS = (
        E("use_setting", "useSetting", str, is_required=True),
        E(
            "requires_access_code_for_public_calls", "requiresAccessCodeForPublicCalls",
            bool, is_required=True,
        ),
        E("allow_e164_public_calls", "allowE164PublicCalls", bool, is_required=True),
        E("public_digit_map", "publicDigitMap", str),
        E("private_digit_map", "privateDigitMap", str),
    )

    use_setting: str = Field(type=str, required=True, mutable=False)
    requires_access_code_for_public_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_e164_public_calls: bool = Field(type=bool, required=True, mutable=False)
    public_digit_map: str = Field(type=str, required=False, mutable=False)
    private_digit_map: str = Field(type=str, required=False, mutable=False)


class GroupDialPlanPolicyGetResponse17(OCIResponse):
    """
    Response to ``GroupDialPlanPolicyGetRequest17()``

    Attributes:
        use_setting: useSetting
        requires_access_code_for_public_calls: requiresAccessCodeForPublicCalls
        allow_e164_public_calls: allowE164PublicCalls
        prefer_e164_number_format_for_callback_services:
            preferE164NumberFormatForCallbackServices
        public_digit_map: publicDigitMap
        private_digit_map: privateDigitMap
    """

    _ELEMENTS = (
        E("use_setting", "useSetting", str, is_required=True),
        E(
            "requires_access_code_for_public_calls", "requiresAccessCodeForPublicCalls",
            bool, is_required=True,
        ),
        E("allow_e164_public_calls", "allowE164PublicCalls", bool, is_required=True),
        E(
            "prefer_e164_number_format_for_callback_services",
            "preferE164NumberFormatForCallbackServices", bool, is_required=True,
        ),
        E("public_digit_map", "publicDigitMap", str),
        E("private_digit_map", "privateDigitMap", str),
    )

    use_setting: str = Field(type=str, required=True, mutable=False)
    requires_access_code_for_public_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_e164_public_calls: bool = Field(type=bool, required=True, mutable=False)
    prefer_e164_number_format_for_callback_services: bool = Field(
        type=bool, required=True, mutable=False,
    )
    public_digit_map: str = Field(type=str, required=False, mutable=False)
    private_digit_map: str = Field(type=str, required=False, mutable=False)


class GroupDialableCallerIDCriteriaGetResponse(OCIResponse):
    """
    Response to the ``GroupDialableCallerIDCriteriaGetRequest()``.

    The response contains the Dialable Caller ID Criteria information.

    Attributes:
        description: description
        prefix_digits: prefixDigits
        match_call_type: matchCallType
        match_alternate_call_indicator: matchAlternateCallIndicator
        match_local_category: matchLocalCategory
        match_national_category: matchNationalCategory
        match_interlata_category: matchInterlataCategory
        match_intralata_category: matchIntralataCategory
        match_international_category: matchInternationalCategory
        match_private_category: matchPrivateCategory
        match_emergency_category: matchEmergencyCategory
        match_other_category: matchOtherCategory
    """

    _ELEMENTS = (
        E("description", "description", str),
        E("prefix_digits", "prefixDigits", str),
        E("match_call_type", "matchCallType", str, is_array=True),
        E(
            "match_alternate_call_indicator", "matchAlternateCallIndicator", str,
            is_array=True,
        ),
        E("match_local_category", "matchLocalCategory", bool, is_required=True),
        E("match_national_category", "matchNationalCategory", bool, is_required=True),
        E("match_interlata_category", "matchInterlataCategory", bool, is_required=True),
        E("match_intralata_category", "matchIntralataCategory", bool, is_required=True),
        E(
            "match_international_category", "matchInternationalCategory", bool,
            is_required=True,
        ),
        E("match_private_category", "matchPrivateCategory", bool, is_required=True),
        E("match_emergency_category", "matchEmergencyCategory", bool, is_required=True),
        E("match_other_category", "matchOtherCategory", bool, is_required=True),
    )

    description: str = Field(type=str, required=False, mutable=False)
    prefix_digits: str = Field(type=str, required=False, mutable=False)
    match_call_type: "List[str]" = Field(type=list, required=False, mutable=False)
    match_alternate_call_indicator: "List[str]" = Field(
        type=list, required=False, mutable=False,
    )
    match_local_category: bool = Field(type=bool, required=True, mutable=False)
    match_national_category: bool = Field(type=bool, required=True, mutable=False)
    match_interlata_category: bool = Field(type=bool, required=True, mutable=False)
    match_intralata_category: bool = Field(type=bool, required=True, mutable=False)
    match_international_category: bool = Field(type=bool, required=True, mutable=False)
    match_private_category: bool = Field(type=bool, required=True, mutable=False)
    match_emergency_category: bool = Field(type=bool, required=True, mutable=False)
    match_other_category: bool = Field(type=bool, required=True, mutable=False)


class GroupDialableCallerIDGetResponse(OCIResponse):
    """
    Response to the ``GroupDialableCallerIDGetRequest()``.

    The criteria table�s column headings are "Active", "Name", "Description", �Prefix
    Digits�, �Priority�.

    Attributes:
        use_group_criteria: useGroupCriteria
        ns_screening_failure_policy: nsScreeningFailurePolicy
        criteria_table: criteriaTable
    """

    _ELEMENTS = (
        E("use_group_criteria", "useGroupCriteria", bool, is_required=True),
        E("ns_screening_failure_policy", "nsScreeningFailurePolicy", str, is_required=True),
        E(
            "criteria_table", "criteriaTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    use_group_criteria: bool = Field(type=bool, required=True, mutable=False)
    ns_screening_failure_policy: str = Field(type=str, required=True, mutable=False)
    criteria_table: "list" = Field(type=list, required=True, mutable=False)


class GroupDigitCollectionGetResponse13mp4(OCIResponse):
    """
    Response to ``GroupDigitCollectionGetRequest13mp4()``.


    Attributes:
        use_setting: useSetting
        access_code: accessCode
        public_digit_map: publicDigitMap
        private_digit_map: privateDigitMap
    """

    _ELEMENTS = (
        E("use_setting", "useSetting", str, is_required=True),
        E("access_code", "accessCode", str),
        E("public_digit_map", "publicDigitMap", str),
        E("private_digit_map", "privateDigitMap", str),
    )

    use_setting: str = Field(type=str, required=True, mutable=False)
    access_code: str = Field(type=str, required=False, mutable=False)
    public_digit_map: str = Field(type=str, required=False, mutable=False)
    private_digit_map: str = Field(type=str, required=False, mutable=False)


class GroupDirectoryNumberHuntingGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupDirectoryNumberHuntingGetAvailableUserListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupDirectoryNumberHuntingGetResponse(OCIResponse):
    """
    Response to the ``GroupDirectoryNumberHuntingGetRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address". Replaced by: ``GroupDirectoryNumberHuntingGetResponse17sp1()``

    Attributes:
        agent_user_table: agentUserTable
    """

    _ELEMENTS = (
        E(
            "agent_user_table", "agentUserTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    agent_user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupDirectoryNumberHuntingGetResponse17sp1(OCIResponse):
    """
    Response to the ``GroupDirectoryNumberHuntingGetRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        agent_user_table: agentUserTable
        use_terminate_call_to_agent_first: useTerminateCallToAgentFirst
        use_original_agent_services_for_busy_and_no_answer_calls:
            useOriginalAgentServicesForBusyAndNoAnswerCalls
    """

    _ELEMENTS = (
        E(
            "agent_user_table", "agentUserTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
        E(
            "use_terminate_call_to_agent_first", "useTerminateCallToAgentFirst", bool,
            is_required=True,
        ),
        E(
            "use_original_agent_services_for_busy_and_no_answer_calls",
            "useOriginalAgentServicesForBusyAndNoAnswerCalls", bool, is_required=True,
        ),
    )

    agent_user_table: "list" = Field(type=list, required=True, mutable=False)
    use_terminate_call_to_agent_first: bool = Field(type=bool, required=True, mutable=False)
    use_original_agent_services_for_busy_and_no_answer_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )


class GroupDnGetActivationListResponse(OCIResponse):
    """
    Response to the ``GroupDnGetActivationListRequest()``.

    The response contains a table with columns: "Phone Numbers", and "Activated". ". Phone
    Numbers are only returned if assigned to a user.  The "Phone Numbers" column contains
    either a single DN or a range of DNs.  The "Activated" column indicates if the phone
    number(s) are activated or not.

    Attributes:
        dn_table: dnTable
    """

    _ELEMENTS = (
        E("dn_table", "dnTable", list, is_complex=True, is_required=True, is_table=True),
    )

    dn_table: "list" = Field(type=list, required=True, mutable=False)


class GroupDnGetAssignmentListResponse(OCIResponse):
    """
    Response to the ``GroupDnGetAssignmentListRequest()``.

    The response contains a table with columns: "Phone Numbers", "Assigned To",
    "Department", "Activated". The "Phone Numbers" column contains either a single DN or a
    range of DNs.  The "Assigned To" column contains the user name or service instance
    name possessing the DN(s). The "Department" column contains the department of the DN,
    not the department of the user or service instance.  The "Activated" column indicates
    if the DN or DN range has been activated.  Only has a value if the DN(s) is assigned
    to a user.  Replaced by: ``GroupDnGetAssignmentListResponse18()``

    Attributes:
        dn_table: dnTable
    """

    _ELEMENTS = (
        E("dn_table", "dnTable", list, is_complex=True, is_required=True, is_table=True),
    )

    dn_table: "list" = Field(type=list, required=True, mutable=False)


class GroupDnGetAssignmentListResponse18(OCIResponse):
    """
    Response to the ``GroupDnGetAssignmentListRequest18()``.

    The response contains a table with columns: "Phone Numbers", "Department",
    "Activated", "User Id", "Last Name", "First Name", "Extension", "Email Address", "User
    Type". The "Phone Numbers" column contains either a single DN or a range of DNs.  The
    "User Id", "Last Name" and "First Name" columns contains the corresponding attributes
    of the user possessing the DN(s). For a service instance, "Last Name" contains the
    service instance name and "First Name" column contains the corresponding enumerated
    UserType value.  The "Department" column contains the department of the DN, not the
    department of the user or service instance.  The "Activated" column indicates if the
    DN or DN range has been activated.  Only has a value if the DN(s) is assigned to a
    user.  The "User Type" column contains the corresponding enumerated UserType value.
    NOTE: the same phone number can show up in the list twice if the phone number is being
    used as the group calling line Id.

    Attributes:
        dn_table: dnTable
    """

    _ELEMENTS = (
        E("dn_table", "dnTable", list, is_complex=True, is_required=True, is_table=True),
    )

    dn_table: "list" = Field(type=list, required=True, mutable=False)


class GroupDnGetAvailableListResponse(OCIResponse):
    """
    Response to the ``GroupDnGetAvailableListRequest()``.

    The response contains the list of DNs that are assigned to a group and still available
    for assignment to users or service instances within the group.

    Attributes:
        phone_number: phoneNumber
    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str, is_array=True),
    )

    phone_number: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupDnGetAvailableRangesListResponse(OCIResponse):
    """
    Response to the ``GroupDnGetAvailableRangesListRequest()``.

    The response contains the list of group DNs that are not assigned to user, service
    instances or IMRN pool.  The Dns are returned in a list of DNs or DN ranges and
    formated in E164 format for display.

    Attributes:
        phone_number: phoneNumber
    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str, is_array=True),
    )

    phone_number: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupDnGetDetailedAvailableListResponse(OCIResponse):
    """
    Response to the ``GroupDnGetDetailedAvailableListRequest()``.

    The response contains a table with columns: "Phone Number", "Department". The "Phone
    Numbers" column contains a single DN. The "Department" column contains the department
    of the DN if the DN is part of the department.  The "Activated" column indicates if
    the DN has been activated.  Only has a value if the DN(s) is assigned to a user or if
    "Group Enable Activation Mode" is enabled.

    Attributes:
        dn_table: dnTable
    """

    _ELEMENTS = (
        E("dn_table", "dnTable", list, is_complex=True, is_required=True, is_table=True),
    )

    dn_table: "list" = Field(type=list, required=True, mutable=False)


class GroupDnGetListResponse(OCIResponse):
    """
    Response to the ``GroupDnGetListRequest()``.

    The response contains the list of DNs assigned to the group.

    Attributes:
        phone_number: phoneNumber
    """

    _ELEMENTS = (
        E("phone_number", "phoneNumber", str, is_array=True),
    )

    phone_number: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupDnGetSummaryListResponse(OCIResponse):
    """
    Response to the ``GroupDnGetSummaryListRequest()``.

    The response contains a table with columns: "Phone Numbers", "Assigned". The "Phone
    Numbers" column contains either a single DN or a range of DNs.  The "Assigned" column
    contains a boolean flag indicating if the DN(s) are currently assigned to a user or
    service instance.  The "Activated" column indicates if the DN or DN range has been
    activated.  Only has a value if the DN(s) is assigned to a user or if "Group Enable
    Activation Mode" is enabled.

    Attributes:
        dn_table: dnTable
    """

    _ELEMENTS = (
        E("dn_table", "dnTable", list, is_complex=True, is_required=True, is_table=True),
    )

    dn_table: "list" = Field(type=list, required=True, mutable=False)


class GroupDomainGetAssignedListResponse(OCIResponse):
    """
    Contains a simple list of all group domain names.


    Attributes:
        group_default_domain: groupDefaultDomain
        domain: domain
    """

    _ELEMENTS = (
        E("group_default_domain", "groupDefaultDomain", str, is_required=True),
        E("domain", "domain", str, is_array=True),
    )

    group_default_domain: str = Field(type=str, required=True, mutable=False)
    domain: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupDomainGetAssignedUserListResponse(OCIResponse):
    """
    Response to ``GroupDomainGetAssignedUserListRequest()``.

    The table columns are: "User Id", "Last Name", "First Name", "Department", "Phone
    Number", "Email Address", "Service Provider Id", "Group Id", "Hiragana Last Name" and
    "Hiragana First Name", "Extension".

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupEmergencyZonesGetResponse(OCIResponse):
    """
    Response to ``GroupEmergencyZonesGetRequest()``.


    Attributes:
        is_active: isActive
        emergency_zones_prohibition: emergencyZonesProhibition
        send_emergency_call_notify_email: sendEmergencyCallNotifyEmail
        emergency_call_notify_email_address: emergencyCallNotifyEmailAddress
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("emergency_zones_prohibition", "emergencyZonesProhibition", str, is_required=True),
        E(
            "send_emergency_call_notify_email", "sendEmergencyCallNotifyEmail", bool,
            is_required=True,
        ),
        E("emergency_call_notify_email_address", "emergencyCallNotifyEmailAddress", str),
    )

    is_active: bool = Field(type=bool, required=True, mutable=False)
    emergency_zones_prohibition: str = Field(type=str, required=True, mutable=False)
    send_emergency_call_notify_email: bool = Field(type=bool, required=True, mutable=False)
    emergency_call_notify_email_address: str = Field(type=str, required=False, mutable=False)


class GroupEndpointGetListResponse(OCIResponse):
    """
    Response to ``GroupEndpointGetListRequest()``.

    The column headings for the endpointTable are: "Line/Port", "Last Name", "First Name",
    "User Id", "User Type", "Phone Number", "Extension", "Device Type", "Device Name",
    "Net Address", "MAC Address", "Department", "Email Address". Possible values for User
    Type are �User�, �CCBasic�, �CCStandard�, �CCPremium�, �RP�, �MOH�, �MOHVideo�.

    Attributes:
        endpoint_table: endpointTable
    """

    _ELEMENTS = (
        E(
            "endpoint_table", "endpointTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    endpoint_table: "list" = Field(type=list, required=True, mutable=False)


class GroupEnterpriseTrunkGetAvailableTrunkGroupListResponse(OCIResponse):
    """
    Response to ``GroupEnterpriseTrunkGetAvailableTrunkGroupListRequest()``.


    Attributes:
        trunk_group_name: trunkGroupName
    """

    _ELEMENTS = (
        E("trunk_group_name", "trunkGroupName", str, is_array=True),
    )

    trunk_group_name: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupEnterpriseTrunkGetAvailableUserListResponse(OCIResponse):
    """
    Response to ``GroupEnterpriseTrunkGetAvailableUserListRequest()``.

    The column headings for the enterpriseTrunkUserTable are: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name", "Phone Number",
    "Extension", "Department", "Email Address".

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupEnterpriseTrunkGetListResponse(OCIResponse):
    """
    Response to ``GroupEnterpriseTrunkGetListRequest()``.

    Contains a table of enterprise trunks defined in the enterprise The column headings
    are: "Enterprise Trunk Name", "Routing Type"

    Attributes:
        enterprise_trunk_table: enterpriseTrunkTable
    """

    _ELEMENTS = (
        E(
            "enterprise_trunk_table", "enterpriseTrunkTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    enterprise_trunk_table: "list" = Field(type=list, required=True, mutable=False)


class GroupEnterpriseTrunkGetResponse(OCIResponse):
    """
    Response to ``GroupEnterpriseTrunkGetRequest()``.

    Replaced by: ``GroupEnterpriseTrunkGetResponse21()``.

    Attributes:
        maximum_reroute_attempts: maximumRerouteAttempts
        route_exhaustion_action: routeExhaustionAction
        route_exhaustion_forward_address: routeExhaustionForwardAddress
        ordered_routing: orderedRouting
        priority_weighted_routing: priorityWeightedRouting
    """

    _ELEMENTS = (
        E("maximum_reroute_attempts", "maximumRerouteAttempts", int, is_required=True),
        E("route_exhaustion_action", "routeExhaustionAction", str, is_required=True),
        E("route_exhaustion_forward_address", "routeExhaustionForwardAddress", str),
        E("ordered_routing", "orderedRouting", str, is_complex=True),  # unknown
        E(
            "priority_weighted_routing", "priorityWeightedRouting", str, is_complex=True,
        ),  # unknown
    )

    maximum_reroute_attempts: int = Field(type=int, required=True, mutable=False)
    route_exhaustion_action: str = Field(type=str, required=True, mutable=False)
    route_exhaustion_forward_address: str = Field(type=str, required=False, mutable=False)
    ordered_routing: str = Field(type=str, required=False, mutable=False)
    priority_weighted_routing: str = Field(type=str, required=False, mutable=False)


class GroupEnterpriseTrunkGetResponse21(OCIResponse):
    """
    Response to ``GroupEnterpriseTrunkGetRequest21()``.


    Attributes:
        maximum_reroute_attempts: maximumRerouteAttempts
        route_exhaustion_action: routeExhaustionAction
        route_exhaustion_forward_address: routeExhaustionForwardAddress
        ordered_routing: orderedRouting
        priority_weighted_routing: priorityWeightedRouting
        enable_capacity_management: enableCapacityManagement
        max_active_calls: maxActiveCalls
        capacity_exceeded_trap_initial_calls: capacityExceededTrapInitialCalls
        capacity_exceeded_trap_offset_calls: capacityExceededTrapOffsetCalls
    """

    _ELEMENTS = (
        E("maximum_reroute_attempts", "maximumRerouteAttempts", int, is_required=True),
        E("route_exhaustion_action", "routeExhaustionAction", str, is_required=True),
        E("route_exhaustion_forward_address", "routeExhaustionForwardAddress", str),
        E("ordered_routing", "orderedRouting", str, is_complex=True),  # unknown
        E(
            "priority_weighted_routing", "priorityWeightedRouting", str, is_complex=True,
        ),  # unknown
        E("enable_capacity_management", "enableCapacityManagement", bool, is_required=True),
        E("max_active_calls", "maxActiveCalls", int),
        E("capacity_exceeded_trap_initial_calls", "capacityExceededTrapInitialCalls", int),
        E("capacity_exceeded_trap_offset_calls", "capacityExceededTrapOffsetCalls", int),
    )

    maximum_reroute_attempts: int = Field(type=int, required=True, mutable=False)
    route_exhaustion_action: str = Field(type=str, required=True, mutable=False)
    route_exhaustion_forward_address: str = Field(type=str, required=False, mutable=False)
    ordered_routing: str = Field(type=str, required=False, mutable=False)
    priority_weighted_routing: str = Field(type=str, required=False, mutable=False)
    enable_capacity_management: bool = Field(type=bool, required=True, mutable=False)
    max_active_calls: int = Field(type=int, required=False, mutable=False)
    capacity_exceeded_trap_initial_calls: int = Field(type=int, required=False, mutable=False)
    capacity_exceeded_trap_offset_calls: int = Field(type=int, required=False, mutable=False)


class GroupEnterpriseTrunkGetUserListResponse(OCIResponse):
    """
    Response to ``GroupEnterpriseTrunkGetUserListRequest()``.

    The column headings for the enterpriseTrunkUserTable are: "User Id", "Last Name",
    "First Name", "Phone Number", "Alternate Trunk Identity", "Hiragana Last Name",
    "Hiragana First Name", "Extension", "Department", "Email Address" and "Route List
    Assigned".

    Attributes:
        enterprise_trunk_user_table: enterpriseTrunkUserTable
    """

    _ELEMENTS = (
        E(
            "enterprise_trunk_user_table", "enterpriseTrunkUserTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    enterprise_trunk_user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupExchangeIntegrationGetResponse(OCIResponse):
    """
    Response to ``GroupExchangeIntegrationGetRequest()``.


    Attributes:
        enable_exchange_integration: enableExchangeIntegration
        exchange_url: exchangeURL
        exchange_user_name: exchangeUserName
    """

    _ELEMENTS = (
        E("enable_exchange_integration", "enableExchangeIntegration", bool, is_required=True),
        E("exchange_url", "exchangeURL", str),
        E("exchange_user_name", "exchangeUserName", str),
    )

    enable_exchange_integration: bool = Field(type=bool, required=True, mutable=False)
    exchange_url: str = Field(type=str, required=False, mutable=False)
    exchange_user_name: str = Field(type=str, required=False, mutable=False)


class GroupExtensionLengthGetResponse(OCIResponse):
    """
    Response to ``GroupExtensionLengthGetRequest()``.


    Attributes:
        extension_length: extensionLength
    """

    _ELEMENTS = (
        E("extension_length", "extensionLength", int, is_required=True),
    )

    extension_length: int = Field(type=int, required=True, mutable=False)


class GroupExtensionLengthGetResponse17(OCIResponse):
    """
    Response to ``GroupExtensionLengthGetRequest17()``.


    Attributes:
        min_extension_length: minExtensionLength
        max_extension_length: maxExtensionLength
        default_extension_length: defaultExtensionLength
    """

    _ELEMENTS = (
        E("min_extension_length", "minExtensionLength", int, is_required=True),
        E("max_extension_length", "maxExtensionLength", int, is_required=True),
        E("default_extension_length", "defaultExtensionLength", int, is_required=True),
    )

    min_extension_length: int = Field(type=int, required=True, mutable=False)
    max_extension_length: int = Field(type=int, required=True, mutable=False)
    default_extension_length: int = Field(type=int, required=True, mutable=False)


class GroupFileRepositoryDeviceUserGetListResponse(OCIResponse):
    """
    Response to ``GroupFileRepositoryDeviceUserGetListRequest()``.

    Contains a table with column headings : "User Name","Allow Delete","Allow Get","Allow
    Put" in a row for each file repository service provider user.

    Attributes:
        file_repository_user_table: fileRepositoryUserTable
    """

    _ELEMENTS = (
        E(
            "file_repository_user_table", "fileRepositoryUserTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    file_repository_user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupFindMeFollowMeAlertingGroupGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupFindMeFollowMeAlertingGroupGetAvailableUserListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupFindMeFollowMeGetAlertingGroupListResponse(OCIResponse):
    """
    Response to the ``GroupFindMeFollowMeGetAlertingGroupListRequest()``.

    Contains a table with column headings: "Name", "Priority".

    Attributes:
        alerting_group_table: alertingGroupTable
    """

    _ELEMENTS = (
        E(
            "alerting_group_table", "alertingGroupTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    alerting_group_table: "list" = Field(type=list, required=True, mutable=False)


class GroupFindMeFollowMeGetAlertingGroupResponse(OCIResponse):
    """
    Response to ``GroupFindMeFollowMeGetAlertingGroupRequest()``.

    Contains the alerting group information.  The user table’s column headings are: "User
    Id", "Last Name", "First Name", "Hiragana Last Name" and "Hiragana First Name", "Phone
    Number", "Extension", "Department", "Email Address". The criteria table's column
    headings are: "Is Active", "Criteria Name", "Time Schedule", "Calls From",
    "Blacklisted", "Holiday Schedule"", "Calls To Type", "Calls To Number" and "Calls To
    Extension". The possible values for the "Calls To Type" column are the following or a
    combination of them separated by comma: - Primary - Alternate X (where x is a number
    between 1 and 10) The possible values for the "Calls To Number" column are the
    following or a combination of them separated by comma: - The value of the phone number
    for the corresponding Calls To Type, when the number is available.  i.e.  Alternate 1
    may have extension, but no number.  - When no number is available a blank space is
    provided instead.  The possible values for the "Calls To Extension" column are the
    following or a combination of them separated by comma: - The value of the extension
    for the corresponding Calls To Type, when the extension is available.  i.e.  Primary
    may have number, but no extension.  - When no extension is available a blank space is
    provided instead.

    Attributes:
        alerting_group_description: alertingGroupDescription
        use_diversion_inhibitor: useDiversionInhibitor
        answer_confirmation_required: answerConfirmationRequired
        number_of_rings: numberOfRings
        phone_number: phoneNumber
        user_table: userTable
        criteria_table: criteriaTable
    """

    _ELEMENTS = (
        E("alerting_group_description", "alertingGroupDescription", str),
        E("use_diversion_inhibitor", "useDiversionInhibitor", bool, is_required=True),
        E(
            "answer_confirmation_required", "answerConfirmationRequired", bool,
            is_required=True,
        ),
        E("number_of_rings", "numberOfRings", int, is_required=True),
        E("phone_number", "phoneNumber", str, is_array=True),
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
        E(
            "criteria_table", "criteriaTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    alerting_group_description: str = Field(type=str, required=False, mutable=False)
    use_diversion_inhibitor: bool = Field(type=bool, required=True, mutable=False)
    answer_confirmation_required: bool = Field(type=bool, required=True, mutable=False)
    number_of_rings: int = Field(type=int, required=True, mutable=False)
    phone_number: "List[str]" = Field(type=list, required=False, mutable=False)
    user_table: "list" = Field(type=list, required=True, mutable=False)
    criteria_table: "list" = Field(type=list, required=True, mutable=False)


class GroupFindMeFollowMeGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupFindMeFollowMeGetInstanceListRequest()``.

    Contains a table with column headings: "Service User Id", "Name", "Phone Number",
    "Extension", "Department", "Is Active". The column value for "Is Active" can either be
    true, or false.

    Attributes:
        find_me_follow_me_table: findMeFollowMeTable
    """

    _ELEMENTS = (
        E(
            "find_me_follow_me_table", "findMeFollowMeTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    find_me_follow_me_table: "list" = Field(type=list, required=True, mutable=False)


class GroupFlexibleSeatingAccessDeviceGetListResponse(OCIResponse):
    """
    Response to ``GroupFlexibleSeatingAccessDeviceGetListRequest()``

    Attributes:
        available_access_device: availableAccessDevice
    """

    _ELEMENTS = (
        E(
            "available_access_device", "availableAccessDevice", str, is_complex=True,
            is_array=True,
        ),  # unknown
    )

    available_access_device: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupFlexibleSeatingHostGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupFlexibleSeatingHostGetInstanceListRequest()``.

    Contains a table with column headings: "Service User Id", "Name", "Phone Number",
    "Extension", "Department", "Is Active". The column value for "Is Active" can either be
    true, or false.

    Attributes:
        flexible_seating_host_table: flexibleSeatingHostTable
    """

    _ELEMENTS = (
        E(
            "flexible_seating_host_table", "flexibleSeatingHostTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    flexible_seating_host_table: "list" = Field(type=list, required=True, mutable=False)


class GroupFlexibleSeatingHostGuestAssociationGetResponse(OCIResponse):
    """
    Response to ``GroupFlexibleSeatingHostGuestAssociationGetRequest()``.


    Attributes:
        enforce_association_limit: enforceAssociationLimit
        association_limit_hours: associationLimitHours
        access_level: accessLevel
        guest_last_name: guestLastName
        guest_first_name: guestFirstName
        guest_phone_number: guestPhoneNumber
        guest_extension: guestExtension
        guest_location_dialing_code: guestLocationDialingCode
        guest_association_date_time: guestAssociationDateTime
    """

    _ELEMENTS = (
        E("enforce_association_limit", "enforceAssociationLimit", bool, is_required=True),
        E("association_limit_hours", "associationLimitHours", int, is_required=True),
        E("access_level", "accessLevel", str, is_required=True),
        E("guest_last_name", "guestLastName", str),
        E("guest_first_name", "guestFirstName", str),
        E("guest_phone_number", "guestPhoneNumber", str),
        E("guest_extension", "guestExtension", str),
        E("guest_location_dialing_code", "guestLocationDialingCode", str),
        E("guest_association_date_time", "guestAssociationDateTime", str),
    )

    enforce_association_limit: bool = Field(type=bool, required=True, mutable=False)
    association_limit_hours: int = Field(type=int, required=True, mutable=False)
    access_level: str = Field(type=str, required=True, mutable=False)
    guest_last_name: str = Field(type=str, required=False, mutable=False)
    guest_first_name: str = Field(type=str, required=False, mutable=False)
    guest_phone_number: str = Field(type=str, required=False, mutable=False)
    guest_extension: str = Field(type=str, required=False, mutable=False)
    guest_location_dialing_code: str = Field(type=str, required=False, mutable=False)
    guest_association_date_time: str = Field(type=str, required=False, mutable=False)


class GroupFlexibleSeatingHostRoutingPoliciesGetResponse(OCIResponse):
    """
    Response to the ``GroupFlexibleSeatingHostRoutingPoliciesGetRequest()``.


    Attributes:
        allow_emergency_calls: allowEmergencyCalls
        allow_calls_to_voice_portal: allowCallsToVoicePortal
    """

    _ELEMENTS = (
        E("allow_emergency_calls", "allowEmergencyCalls", bool, is_required=True),
        E("allow_calls_to_voice_portal", "allowCallsToVoicePortal", bool, is_required=True),
    )

    allow_emergency_calls: bool = Field(type=bool, required=True, mutable=False)
    allow_calls_to_voice_portal: bool = Field(type=bool, required=True, mutable=False)


class GroupGetDefaultResponse(OCIResponse):
    """
    Response to the ``GroupGetDefaultRequest()``.

    All values are default values for a group's profile.

    Attributes:
        default_domain: defaultDomain
        user_limit: userLimit
        time_zone: timeZone
        time_zone_display_name: timeZoneDisplayName
    """

    _ELEMENTS = (
        E("default_domain", "defaultDomain", str, is_required=True),
        E("user_limit", "userLimit", int, is_required=True),
        E("time_zone", "timeZone", str, is_required=True),
        E("time_zone_display_name", "timeZoneDisplayName", str, is_required=True),
    )

    default_domain: str = Field(type=str, required=True, mutable=False)
    user_limit: int = Field(type=int, required=True, mutable=False)
    time_zone: str = Field(type=str, required=True, mutable=False)
    time_zone_display_name: str = Field(type=str, required=True, mutable=False)


class GroupGetListInServiceProviderResponse(OCIResponse):
    """
    Response to ``GroupGetListInServiceProviderRequest()``.

    Contains a 3 column table with column headings: "Group Id", "Group Name", "User Limit"
    and a row for each group.

    Attributes:
        group_table: groupTable
    """

    _ELEMENTS = (
        E(
            "group_table", "groupTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    group_table: "list" = Field(type=list, required=True, mutable=False)


class GroupGetListInSystemResponse(OCIResponse):
    """
    Response to ``GroupGetListInSystemRequest()``.

    Contains a table with column headings: "Group Id", "Group Name", "User Limit",
    "Organization Id", "Organization Type" and a row for each group.  The "Organization
    Id" column is populated with either a service provider Id or an enterprise Id.  The
    "Organization Type" column is populated with one of the enumerated strings defined in
    the OrganizationType OCI data type.  Please see OCISchemaDataTypes.xsd for details on
    OrganizationType.

    Attributes:
        group_table: groupTable
    """

    _ELEMENTS = (
        E(
            "group_table", "groupTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    group_table: "list" = Field(type=list, required=True, mutable=False)


class GroupGetUserServiceAssignedUserListResponse(OCIResponse):
    """
    Return a table containing the list of users assigned the user service or service pack.

    The table contains columns: "User Id", "Last Name", "First Name", "Department", "Phone
    Number", "Email Address", "Hiragana Last Name"; "Hiragana First Name", "Extension".
    This is a response to the ``GroupGetUserServiceAssignedUserListRequest()``.

    Attributes:
        user_list_table: userListTable
    """

    _ELEMENTS = (
        E(
            "user_list_table", "userListTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    user_list_table: "list" = Field(type=list, required=True, mutable=False)


class GroupGroupPagingGetAvailableOriginatorListResponse(OCIResponse):
    """
    Response to the ``GroupGroupPagingGetAvailableOriginatorListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name" and "Hiragana First Name", "Phone Number", "Extension", "Department",
    "Email Address".

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupGroupPagingGetAvailableTargetListResponse(OCIResponse):
    """
    Response to the ``GroupGroupPagingGetAvailableTargetListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name" and "Hiragana First Name", "Phone Number", "Extension", "Department",
    "Email Address".

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupGroupPagingGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupGroupPagingGetInstanceListRequest()``.

    Contains a table with column headings: "Service User Id", "Name", "Phone Number",
    "Extension", "Department", "Is Active". The column value for "Is Active" can either be
    true, or false.

    Attributes:
        paging_group_table: pagingGroupTable
    """

    _ELEMENTS = (
        E(
            "paging_group_table", "pagingGroupTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    paging_group_table: "list" = Field(type=list, required=True, mutable=False)


class GroupGroupPagingGetOriginatorListResponse(OCIResponse):
    """
    Response to the ``GroupGroupPagingGetOriginatorListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        originator_table: originatorTable
    """

    _ELEMENTS = (
        E(
            "originator_table", "originatorTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    originator_table: "list" = Field(type=list, required=True, mutable=False)


class GroupGroupPagingGetTargetListResponse(OCIResponse):
    """
    Response to the ``GroupGroupPagingGetTargetListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        target_table: targetTable
    """

    _ELEMENTS = (
        E(
            "target_table", "targetTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    target_table: "list" = Field(type=list, required=True, mutable=False)


class GroupGroupPagingTargetsCapacityGetResponse(OCIResponse):
    """
    Response to ``GroupGroupPagingTargetsCapacityGetRequest()``.


    Attributes:
        maximum_target_users_from_service_provider: maximumTargetUsersFromServiceProvider
        maximum_target_users: maximumTargetUsers
    """

    _ELEMENTS = (
        E(
            "maximum_target_users_from_service_provider",
            "maximumTargetUsersFromServiceProvider", int, is_required=True,
        ),
        E("maximum_target_users", "maximumTargetUsers", int, is_required=True),
    )

    maximum_target_users_from_service_provider: int = Field(
        type=int, required=True, mutable=False,
    )
    maximum_target_users: int = Field(type=int, required=True, mutable=False)


class GroupHolidayScheduleGetListResponse(OCIResponse):
    """
    Response to the ``GroupHolidayScheduleGetListRequest()``.

    The response contains all the group's holiday schedule name.

    Attributes:
        holiday_schedule_name: holidayScheduleName
    """

    _ELEMENTS = (
        E("holiday_schedule_name", "holidayScheduleName", str, is_array=True),
    )

    holiday_schedule_name: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupHuntGroupGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupHuntGroupGetAvailableUserListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupHuntGroupGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupHuntGroupGetInstanceListRequest()``.

    Contains a table with column headings: "Service User Id", "Name", "Phone Number",
    "Extension", "Department", "Is Active", "Policy". The column values for "Is Active"
    can either be true, or false.  NOTE: prior to release 14, the policy column did not
    match the HuntPolicy enumerated type.

    Attributes:
        hunt_group_table: huntGroupTable
    """

    _ELEMENTS = (
        E(
            "hunt_group_table", "huntGroupTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    hunt_group_table: "list" = Field(type=list, required=True, mutable=False)


class GroupIMRNGetListResponse(OCIResponse):
    """
    Response to ``GroupIMRNGetListRequest()``.


    Attributes:
        imrn: imrn
    """

    _ELEMENTS = (
        E("imrn", "imrn", str, is_array=True),
    )

    imrn: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupInstantGroupCallGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupInstantGroupCallGetInstanceListRequest()``.

    Contains a 6 column table with column headings: "Service User Id", "Name", "Phone
    Number", "Extension", "Department", "Is Active". The column values for Is Active can
    either be true, or false.

    Attributes:
        instant_group_call_table: instantGroupCallTable
    """

    _ELEMENTS = (
        E(
            "instant_group_call_table", "instantGroupCallTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    instant_group_call_table: "list" = Field(type=list, required=True, mutable=False)


class GroupIntegratedIMPGetResponse(OCIResponse):
    """
    Response to the ``GroupIntegratedIMPGetRequest()``.

    The response contains the group Integrated IMP service attributes.

    Attributes:
        use_service_provider_setting: useServiceProviderSetting
        service_domain: serviceDomain
    """

    _ELEMENTS = (
        E(
            "use_service_provider_setting", "useServiceProviderSetting", bool,
            is_required=True,
        ),
        E("service_domain", "serviceDomain", str),
    )

    use_service_provider_setting: bool = Field(type=bool, required=True, mutable=False)
    service_domain: str = Field(type=str, required=False, mutable=False)


class GroupInterceptGroupGetResponse(OCIResponse):
    """
    Response to the ``GroupInterceptGroupGetRequest()``.

    Replaced By: ``GroupInterceptGroupGetResponse16()``

    Attributes:
        is_active: isActive
        announcement_selection: announcementSelection
        audio_file_description: audioFileDescription
        video_file_description: videoFileDescription
        play_new_phone_number: playNewPhoneNumber
        new_phone_number: newPhoneNumber
        transfer_on_zero_to_phone_number: transferOnZeroToPhoneNumber
        transfer_phone_number: transferPhoneNumber
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("announcement_selection", "announcementSelection", str, is_required=True),
        E("audio_file_description", "audioFileDescription", str),
        E("video_file_description", "videoFileDescription", str),
        E("play_new_phone_number", "playNewPhoneNumber", bool, is_required=True),
        E("new_phone_number", "newPhoneNumber", str),
        E(
            "transfer_on_zero_to_phone_number", "transferOnZeroToPhoneNumber", bool,
            is_required=True,
        ),
        E("transfer_phone_number", "transferPhoneNumber", str),
    )

    is_active: bool = Field(type=bool, required=True, mutable=False)
    announcement_selection: str = Field(type=str, required=True, mutable=False)
    audio_file_description: str = Field(type=str, required=False, mutable=False)
    video_file_description: str = Field(type=str, required=False, mutable=False)
    play_new_phone_number: bool = Field(type=bool, required=True, mutable=False)
    new_phone_number: str = Field(type=str, required=False, mutable=False)
    transfer_on_zero_to_phone_number: bool = Field(type=bool, required=True, mutable=False)
    transfer_phone_number: str = Field(type=str, required=False, mutable=False)


class GroupInterceptGroupGetResponse16(OCIResponse):
    """
    Response to the ``GroupInterceptGroupGetRequest16()``.

    Replaced By: ``GroupInterceptGroupGetResponse16sp1()``

    Attributes:
        is_active: isActive
        announcement_selection: announcementSelection
        audio_file_description: audioFileDescription
        audio_media_type: audioMediaType
        video_file_description: videoFileDescription
        video_media_type: videoMediaType
        play_new_phone_number: playNewPhoneNumber
        new_phone_number: newPhoneNumber
        transfer_on_zero_to_phone_number: transferOnZeroToPhoneNumber
        transfer_phone_number: transferPhoneNumber
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("announcement_selection", "announcementSelection", str, is_required=True),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
        E("play_new_phone_number", "playNewPhoneNumber", bool, is_required=True),
        E("new_phone_number", "newPhoneNumber", str),
        E(
            "transfer_on_zero_to_phone_number", "transferOnZeroToPhoneNumber", bool,
            is_required=True,
        ),
        E("transfer_phone_number", "transferPhoneNumber", str),
    )

    is_active: bool = Field(type=bool, required=True, mutable=False)
    announcement_selection: str = Field(type=str, required=True, mutable=False)
    audio_file_description: str = Field(type=str, required=False, mutable=False)
    audio_media_type: str = Field(type=str, required=False, mutable=False)
    video_file_description: str = Field(type=str, required=False, mutable=False)
    video_media_type: str = Field(type=str, required=False, mutable=False)
    play_new_phone_number: bool = Field(type=bool, required=True, mutable=False)
    new_phone_number: str = Field(type=str, required=False, mutable=False)
    transfer_on_zero_to_phone_number: bool = Field(type=bool, required=True, mutable=False)
    transfer_phone_number: str = Field(type=str, required=False, mutable=False)


class GroupInterceptGroupGetResponse16sp1(OCIResponse):
    """
    Response to the ``GroupInterceptGroupGetRequest16sp1()``.


    Attributes:
        is_active: isActive
        announcement_selection: announcementSelection
        audio_file_description: audioFileDescription
        audio_media_type: audioMediaType
        video_file_description: videoFileDescription
        video_media_type: videoMediaType
        play_new_phone_number: playNewPhoneNumber
        new_phone_number: newPhoneNumber
        transfer_on_zero_to_phone_number: transferOnZeroToPhoneNumber
        transfer_phone_number: transferPhoneNumber
        reroute_outbound_calls: rerouteOutboundCalls
        outbound_reroute_phone_number: outboundReroutePhoneNumber
        allow_outbound_local_calls: allowOutboundLocalCalls
        inbound_call_mode: inboundCallMode
        alternate_blocking_announcement: alternateBlockingAnnouncement
        route_to_voice_mail: routeToVoiceMail
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("announcement_selection", "announcementSelection", str, is_required=True),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
        E("play_new_phone_number", "playNewPhoneNumber", bool, is_required=True),
        E("new_phone_number", "newPhoneNumber", str),
        E(
            "transfer_on_zero_to_phone_number", "transferOnZeroToPhoneNumber", bool,
            is_required=True,
        ),
        E("transfer_phone_number", "transferPhoneNumber", str),
        E("reroute_outbound_calls", "rerouteOutboundCalls", bool, is_required=True),
        E("outbound_reroute_phone_number", "outboundReroutePhoneNumber", str),
        E("allow_outbound_local_calls", "allowOutboundLocalCalls", bool, is_required=True),
        E("inbound_call_mode", "inboundCallMode", str, is_required=True),
        E(
            "alternate_blocking_announcement", "alternateBlockingAnnouncement", bool,
            is_required=True,
        ),
        E("route_to_voice_mail", "routeToVoiceMail", bool, is_required=True),
    )

    is_active: bool = Field(type=bool, required=True, mutable=False)
    announcement_selection: str = Field(type=str, required=True, mutable=False)
    audio_file_description: str = Field(type=str, required=False, mutable=False)
    audio_media_type: str = Field(type=str, required=False, mutable=False)
    video_file_description: str = Field(type=str, required=False, mutable=False)
    video_media_type: str = Field(type=str, required=False, mutable=False)
    play_new_phone_number: bool = Field(type=bool, required=True, mutable=False)
    new_phone_number: str = Field(type=str, required=False, mutable=False)
    transfer_on_zero_to_phone_number: bool = Field(type=bool, required=True, mutable=False)
    transfer_phone_number: str = Field(type=str, required=False, mutable=False)
    reroute_outbound_calls: bool = Field(type=bool, required=True, mutable=False)
    outbound_reroute_phone_number: str = Field(type=str, required=False, mutable=False)
    allow_outbound_local_calls: bool = Field(type=bool, required=True, mutable=False)
    inbound_call_mode: str = Field(type=str, required=True, mutable=False)
    alternate_blocking_announcement: bool = Field(type=bool, required=True, mutable=False)
    route_to_voice_mail: bool = Field(type=bool, required=True, mutable=False)


class GroupInventoryReportGetResponse(OCIResponse):
    """
    Response to ``GroupInventoryReportGetRequest()``.


    Attributes:
        inventory_report_table: inventoryReportTable
    """

    _ELEMENTS = (
        E(
            "inventory_report_table", "inventoryReportTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    inventory_report_table: "list" = Field(type=list, required=True, mutable=False)


class GroupLDAPIntegrationGetDirectoryResponse(OCIResponse):
    """
    Response to ``GroupLDAPIntegrationGetDirectoryRequest()``.


    Attributes:
        use_level: useLevel
        server_net_address: serverNetAddress
        server_port: serverPort
        search_base: searchBase
        use_ssl: useSSL
        require_authentication: requireAuthentication
        authenticated_dn: authenticatedDN
        authenticated_password: authenticatedPassword
        is_sort_enabled: isSortEnabled
        is_paged_result_enabled: isPagedResultEnabled
        search_filter: searchFilter
        include_search_attribute_in_search_filter: includeSearchAttributeInSearchFilter
        column1_attribute_name: column1AttributeName
        column2_attribute_name: column2AttributeName
        column3_attribute_name: column3AttributeName
        column4_attribute_name: column4AttributeName
        column1_label: column1Label
        column2_label: column2Label
        column3_label: column3Label
        column4_label: column4Label
        search_column: searchColumn
    """

    _ELEMENTS = (
        E("use_level", "useLevel", str, is_required=True),
        E("server_net_address", "serverNetAddress", str),
        E("server_port", "serverPort", int, is_required=True),
        E("search_base", "searchBase", str),
        E("use_ssl", "useSSL", bool, is_required=True),
        E("require_authentication", "requireAuthentication", bool, is_required=True),
        E("authenticated_dn", "authenticatedDN", str),
        E("authenticated_password", "authenticatedPassword", str),
        E("is_sort_enabled", "isSortEnabled", bool, is_required=True),
        E("is_paged_result_enabled", "isPagedResultEnabled", bool, is_required=True),
        E("search_filter", "searchFilter", str),
        E(
            "include_search_attribute_in_search_filter",
            "includeSearchAttributeInSearchFilter", bool, is_required=True,
        ),
        E("column1_attribute_name", "column1AttributeName", str, is_required=True),
        E("column2_attribute_name", "column2AttributeName", str),
        E("column3_attribute_name", "column3AttributeName", str),
        E("column4_attribute_name", "column4AttributeName", str),
        E("column1_label", "column1Label", str),
        E("column2_label", "column2Label", str),
        E("column3_label", "column3Label", str),
        E("column4_label", "column4Label", str),
        E("search_column", "searchColumn", int, is_required=True),
    )

    use_level: str = Field(type=str, required=True, mutable=False)
    server_net_address: str = Field(type=str, required=False, mutable=False)
    server_port: int = Field(type=int, required=True, mutable=False)
    search_base: str = Field(type=str, required=False, mutable=False)
    use_ssl: bool = Field(type=bool, required=True, mutable=False)
    require_authentication: bool = Field(type=bool, required=True, mutable=False)
    authenticated_dn: str = Field(type=str, required=False, mutable=False)
    authenticated_password: str = Field(type=str, required=False, mutable=False)
    is_sort_enabled: bool = Field(type=bool, required=True, mutable=False)
    is_paged_result_enabled: bool = Field(type=bool, required=True, mutable=False)
    search_filter: str = Field(type=str, required=False, mutable=False)
    include_search_attribute_in_search_filter: bool = Field(
        type=bool, required=True, mutable=False,
    )
    column1_attribute_name: str = Field(type=str, required=True, mutable=False)
    column2_attribute_name: str = Field(type=str, required=False, mutable=False)
    column3_attribute_name: str = Field(type=str, required=False, mutable=False)
    column4_attribute_name: str = Field(type=str, required=False, mutable=False)
    column1_label: str = Field(type=str, required=False, mutable=False)
    column2_label: str = Field(type=str, required=False, mutable=False)
    column3_label: str = Field(type=str, required=False, mutable=False)
    column4_label: str = Field(type=str, required=False, mutable=False)
    search_column: int = Field(type=int, required=True, mutable=False)


class GroupLDAPIntegrationGetResponse(OCIResponse):
    """
    Response to ``GroupLDAPIntegrationGetRequest()``.


    Attributes:
        is_active: isActive
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
    )

    is_active: bool = Field(type=bool, required=True, mutable=False)


class GroupMWIDeliveryToMobileEndpointGetResponse(OCIResponse):
    """
    Response to ``GroupMWIDeliveryToMobileEndpointGetRequest()``.

    The templateActivationTable contains the list of templates defined for the group.  The
    column headings are "Enable", "Language", "Type".

    Attributes:
        use_setting_level: useSettingLevel
        template_activation_table: templateActivationTable
    """

    _ELEMENTS = (
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E(
            "template_activation_table", "templateActivationTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    use_setting_level: str = Field(type=str, required=True, mutable=False)
    template_activation_table: "list" = Field(type=list, required=True, mutable=False)


class GroupMeetMeConferencingGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupMeetMeConferencingGetAvailableUserListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", and "Hiragana First Name", "Phone Number", "Extension", "Department",
    "Email Address".

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupMeetMeConferencingGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupMeetMeConferencingGetInstanceListRequest()``.

    Contains a table with column headings: "Service User Id", "Name", "Phone Number",
    "Extension", "Department", "Ports", and "Is Active". The column values for "Is Active"
    can either be true, or false.

    Attributes:
        conference_bridge_table: conferenceBridgeTable
    """

    _ELEMENTS = (
        E(
            "conference_bridge_table", "conferenceBridgeTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    conference_bridge_table: "list" = Field(type=list, required=True, mutable=False)


class GroupNetworkClassOfServiceGetAssignedListResponse(OCIResponse):
    """
    Response to ``GroupNetworkClassOfServiceGetAssignedListRequest()``.

    Contains a table of all Network Classes of Service assigned to the group.  The column
    headings are: "Name", "Description" and "Default".

    Attributes:
        network_class_of_service_table: networkClassOfServiceTable
    """

    _ELEMENTS = (
        E(
            "network_class_of_service_table", "networkClassOfServiceTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    network_class_of_service_table: "list" = Field(type=list, required=True, mutable=False)


class GroupNetworkClassOfServiceGetAssignedUserListResponse(OCIResponse):
    """
    Response to ``GroupNetworkClassOfServiceGetAssignedUserListRequest()``.

    Contains a table of users that have the Network Class of Service assigned.  The column
    headings are: "User Id", "User Type", "Last Name", "First Name", "Department", "Phone
    Number", "Email Address", "Service Provider Id", "Group Id", "Hiragana Last Name" and
    "Hiragana First Name" , "Extension". Replaced by
    ``GroupNetworkClassOfServiceGetAssignedUserListResponse21()``

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupNetworkClassOfServiceGetAssignedUserListResponse21(OCIResponse):
    """
    Response to ``GroupNetworkClassOfServiceGetAssignedUserListRequest21()``.

    Contains a table of users that have the Network Class of Service assigned.  The column
    headings are: "User Id", "User Type", "Last Name", "First Name", "Department", "Phone
    Number", "Email Address", "Service Provider Id", "Group Id", "Hiragana Last Name" and
    "Hiragana First Name" , "Extension". The User type column will display Auto Attendant
    and the Call Center subtype.  Call Center - Basic, Call Center - Standard and Call
    Center - Premium will be displayed instead of Call Center and Auto Attendant (for the
    Basic Auto Attendant) and Auto Attendant - Standard instead of Auto Attendant.

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupOfficeZoneGetAssignedListResponse(OCIResponse):
    """
    Response to ``GroupOfficeZoneGetAssignedListRequest()``.

    Contains a table of all Office Zones assigned to the group.  The column headings are:
    "Name", "Description" and "Default".

    Attributes:
        office_zone_table: officeZoneTable
    """

    _ELEMENTS = (
        E(
            "office_zone_table", "officeZoneTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    office_zone_table: "list" = Field(type=list, required=True, mutable=False)


class GroupOfficeZoneGetAssignedUserListResponse(OCIResponse):
    """
    Response to ``GroupOfiiceZoneGetAssignedUserListRequest()``.

    Contains a table of users that have the Office Zone assigned.  The column headings
    are: "User Id", "User Type", "Last Name", "First Name", "Department", "Phone Number",
    "Email Address", "Hiragana Last Name" and "Hiragana First Name", "Extension". Office
    Zones can only be unassigned if the Location-Based Calling Restrictions has been
    authorized to the group otherwise the request will fail.

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupOutgoingCallingPlanPinholeDigitPatternGetListResponse(OCIResponse):
    """
    Response to ``GroupOutgoingCallingPlanPinholeDigitPatternGetListRequest()``.

    Contains a table with column headings: "Name", "Digit Pattern".

    Attributes:
        digit_pattern_table: digitPatternTable
    """

    _ELEMENTS = (
        E(
            "digit_pattern_table", "digitPatternTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    digit_pattern_table: "list" = Field(type=list, required=True, mutable=False)


class GroupPasswordRulesGetResponse(OCIResponse):
    """
    Response to ``GroupPasswordRulesGetRequest()``.

    Contains the password rules applicable to users within the group.  Repleced by:
    ``GroupPasswordRulesGetResponse16()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        disallow_user_id: disallowUserId
        disallow_old_password: disallowOldPassword
        disallow_reversed_old_password: disallowReversedOldPassword
        restrict_min_digits: restrictMinDigits
        min_digits: minDigits
        restrict_min_upper_case_letters: restrictMinUpperCaseLetters
        min_upper_case_letters: minUpperCaseLetters
        restrict_min_lower_case_letters: restrictMinLowerCaseLetters
        min_lower_case_letters: minLowerCaseLetters
        restrict_min_non_alphanumeric_characters: restrictMinNonAlphanumericCharacters
        min_non_alphanumeric_characters: minNonAlphanumericCharacters
        min_length: minLength
        max_failed_login_attempts: maxFailedLoginAttempts
        password_expires_days: passwordExpiresDays
        send_login_disabled_notify_email: sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address: loginDisabledNotifyEmailAddress
        disallow_rules_modification: disallowRulesModification
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("disallow_user_id", "disallowUserId", bool, is_required=True),
        E("disallow_old_password", "disallowOldPassword", bool, is_required=True),
        E(
            "disallow_reversed_old_password", "disallowReversedOldPassword", bool,
            is_required=True,
        ),
        E("restrict_min_digits", "restrictMinDigits", bool, is_required=True),
        E("min_digits", "minDigits", int, is_required=True),
        E(
            "restrict_min_upper_case_letters", "restrictMinUpperCaseLetters", bool,
            is_required=True,
        ),
        E("min_upper_case_letters", "minUpperCaseLetters", int, is_required=True),
        E(
            "restrict_min_lower_case_letters", "restrictMinLowerCaseLetters", bool,
            is_required=True,
        ),
        E("min_lower_case_letters", "minLowerCaseLetters", int, is_required=True),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters", bool, is_required=True,
        ),
        E(
            "min_non_alphanumeric_characters", "minNonAlphanumericCharacters", int,
            is_required=True,
        ),
        E("min_length", "minLength", int, is_required=True),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int, is_required=True),
        E("password_expires_days", "passwordExpiresDays", int, is_required=True),
        E(
            "send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool,
            is_required=True,
        ),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
        E("disallow_rules_modification", "disallowRulesModification", bool, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    disallow_user_id: bool = Field(type=bool, required=True, mutable=False)
    disallow_old_password: bool = Field(type=bool, required=True, mutable=False)
    disallow_reversed_old_password: bool = Field(type=bool, required=True, mutable=False)
    restrict_min_digits: bool = Field(type=bool, required=True, mutable=False)
    min_digits: int = Field(type=int, required=True, mutable=False)
    restrict_min_upper_case_letters: bool = Field(type=bool, required=True, mutable=False)
    min_upper_case_letters: int = Field(type=int, required=True, mutable=False)
    restrict_min_lower_case_letters: bool = Field(type=bool, required=True, mutable=False)
    min_lower_case_letters: int = Field(type=int, required=True, mutable=False)
    restrict_min_non_alphanumeric_characters: bool = Field(
        type=bool, required=True, mutable=False,
    )
    min_non_alphanumeric_characters: int = Field(type=int, required=True, mutable=False)
    min_length: int = Field(type=int, required=True, mutable=False)
    max_failed_login_attempts: int = Field(type=int, required=True, mutable=False)
    password_expires_days: int = Field(type=int, required=True, mutable=False)
    send_login_disabled_notify_email: bool = Field(type=bool, required=True, mutable=False)
    login_disabled_notify_email_address: str = Field(type=str, required=False, mutable=False)
    disallow_rules_modification: bool = Field(type=bool, required=True, mutable=False)


class GroupPasswordRulesGetResponse16(OCIResponse):
    """
    Response to ``GroupPasswordRulesGetRequest16()``.

    Contains the password rules applicable to users within the group.

    Attributes:
        disallow_user_id: disallowUserId
        disallow_old_password: disallowOldPassword
        disallow_reversed_old_password: disallowReversedOldPassword
        restrict_min_digits: restrictMinDigits
        min_digits: minDigits
        restrict_min_upper_case_letters: restrictMinUpperCaseLetters
        min_upper_case_letters: minUpperCaseLetters
        restrict_min_lower_case_letters: restrictMinLowerCaseLetters
        min_lower_case_letters: minLowerCaseLetters
        restrict_min_non_alphanumeric_characters: restrictMinNonAlphanumericCharacters
        min_non_alphanumeric_characters: minNonAlphanumericCharacters
        min_length: minLength
        max_failed_login_attempts: maxFailedLoginAttempts
        password_expires_days: passwordExpiresDays
        send_login_disabled_notify_email: sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address: loginDisabledNotifyEmailAddress
        disallow_rules_modification: disallowRulesModification
        disallow_previous_passwords: disallowPreviousPasswords
        number_of_previous_passwords: numberOfPreviousPasswords
    """

    _ELEMENTS = (
        E("disallow_user_id", "disallowUserId", bool, is_required=True),
        E("disallow_old_password", "disallowOldPassword", bool, is_required=True),
        E(
            "disallow_reversed_old_password", "disallowReversedOldPassword", bool,
            is_required=True,
        ),
        E("restrict_min_digits", "restrictMinDigits", bool, is_required=True),
        E("min_digits", "minDigits", int, is_required=True),
        E(
            "restrict_min_upper_case_letters", "restrictMinUpperCaseLetters", bool,
            is_required=True,
        ),
        E("min_upper_case_letters", "minUpperCaseLetters", int, is_required=True),
        E(
            "restrict_min_lower_case_letters", "restrictMinLowerCaseLetters", bool,
            is_required=True,
        ),
        E("min_lower_case_letters", "minLowerCaseLetters", int, is_required=True),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters", bool, is_required=True,
        ),
        E(
            "min_non_alphanumeric_characters", "minNonAlphanumericCharacters", int,
            is_required=True,
        ),
        E("min_length", "minLength", int, is_required=True),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int, is_required=True),
        E("password_expires_days", "passwordExpiresDays", int, is_required=True),
        E(
            "send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool,
            is_required=True,
        ),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
        E("disallow_rules_modification", "disallowRulesModification", bool, is_required=True),
        E("disallow_previous_passwords", "disallowPreviousPasswords", bool, is_required=True),
        E("number_of_previous_passwords", "numberOfPreviousPasswords", int, is_required=True),
    )

    disallow_user_id: bool = Field(type=bool, required=True, mutable=False)
    disallow_old_password: bool = Field(type=bool, required=True, mutable=False)
    disallow_reversed_old_password: bool = Field(type=bool, required=True, mutable=False)
    restrict_min_digits: bool = Field(type=bool, required=True, mutable=False)
    min_digits: int = Field(type=int, required=True, mutable=False)
    restrict_min_upper_case_letters: bool = Field(type=bool, required=True, mutable=False)
    min_upper_case_letters: int = Field(type=int, required=True, mutable=False)
    restrict_min_lower_case_letters: bool = Field(type=bool, required=True, mutable=False)
    min_lower_case_letters: int = Field(type=int, required=True, mutable=False)
    restrict_min_non_alphanumeric_characters: bool = Field(
        type=bool, required=True, mutable=False,
    )
    min_non_alphanumeric_characters: int = Field(type=int, required=True, mutable=False)
    min_length: int = Field(type=int, required=True, mutable=False)
    max_failed_login_attempts: int = Field(type=int, required=True, mutable=False)
    password_expires_days: int = Field(type=int, required=True, mutable=False)
    send_login_disabled_notify_email: bool = Field(type=bool, required=True, mutable=False)
    login_disabled_notify_email_address: str = Field(type=str, required=False, mutable=False)
    disallow_rules_modification: bool = Field(type=bool, required=True, mutable=False)
    disallow_previous_passwords: bool = Field(type=bool, required=True, mutable=False)
    number_of_previous_passwords: int = Field(type=int, required=True, mutable=False)


class GroupPhoneDirectoryGetListResponse(OCIResponse):
    """
    Response to ``GroupPhoneDirectoryGetListRequest()``.

    Contains a table with a row for each phone number and column headings : "Name",
    "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana Name",
    "Group Id", "Yahoo Id". If extended directory information is requested, the following
    columns are also included: "First Name", "Last Name", "User Id", "Pager", "Title",
    "Time Zone", "Location", "Address Line 1", "Address Line 2", "City", "State", "Zip",
    "Country". Replace by: ``GroupPhoneDirectoryGetListResponse17()``

    Attributes:
        directory_table: directoryTable
    """

    _ELEMENTS = (
        E(
            "directory_table", "directoryTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    directory_table: "list" = Field(type=list, required=True, mutable=False)


class GroupPhoneDirectoryGetListResponse17(OCIResponse):
    """
    Response to ``GroupPhoneDirectoryGetListRequest17()``.

    Contains a table with a row for each phone number and column headings : "Name",
    "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana Name",
    "Group Id", "Yahoo Id", "Is Virtual On-Net User" If extended directory information is
    requested, the following columns are also included: "First Name", "Last Name", "User
    Id", "Pager", "Title", "Time Zone", "Location", "Address Line 1", "Address Line 2",
    "City", "State", "Zip", "Country". Replaced by:
    ``GroupPhoneDirectoryGetListResponse18()``

    Attributes:
        directory_table: directoryTable
    """

    _ELEMENTS = (
        E(
            "directory_table", "directoryTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    directory_table: "list" = Field(type=list, required=True, mutable=False)


class GroupPhoneDirectoryGetListResponse17sp3(OCIResponse):
    """
    Response to ``GroupPhoneDirectoryGetListRequest17sp3()``.

    Contains a table with a row for each phone number and column headings : "Name",
    "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana Name",
    "Group Id", "Yahoo Id", "IMP Id" and "Is Virtual On-Net User" If extended directory
    information is requested, the following columns are also included: "First Name", "Last
    Name", "User Id", "Pager", "Title", "Time Zone", "Location", "Address Line 1",
    "Address Line 2", "City", "State", "Zip", "Country". Replaced by:
    ``GroupPhoneDirectoryGetListResponse18()``

    Attributes:
        directory_table: directoryTable
    """

    _ELEMENTS = (
        E(
            "directory_table", "directoryTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    directory_table: "list" = Field(type=list, required=True, mutable=False)


class GroupPhoneDirectoryGetListResponse18(OCIResponse):
    """
    Response to ``GroupPhoneDirectoryGetListRequest18()``.

    Contains a table with a row for each phone number and column headings : "Name",
    "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana Name",
    "Group Id", "Yahoo Id", "User Id", "IMP Id" and "Is Virtual On-Net User". If extended
    directory information is requested, the following columns are also included: "First
    Name", "Last Name", "Pager", "Title", "Time Zone", "Location", "Address Line 1",
    "Address Line 2", "City", "State", "Zip", "Country".

    Attributes:
        directory_table: directoryTable
    """

    _ELEMENTS = (
        E(
            "directory_table", "directoryTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    directory_table: "list" = Field(type=list, required=True, mutable=False)


class GroupPolicyGetResponse(OCIResponse):
    """
    Response to ``GroupPolicyGetRequest()``.

    Contains the policy settings for the group.

    Attributes:
        calling_plan_access: callingPlanAccess
        extension_access: extensionAccess
        ldap_integration_access: ldapIntegrationAccess
        voice_messaging_access: voiceMessagingAccess
        department_admin_user_access: departmentAdminUserAccess
        user_authentication_access: userAuthenticationAccess
        user_group_directory_access: userGroupDirectoryAccess
        user_profile_access: userProfileAccess
    """

    _ELEMENTS = (
        E("calling_plan_access", "callingPlanAccess", str, is_required=True),
        E("extension_access", "extensionAccess", str, is_required=True),
        E("ldap_integration_access", "ldapIntegrationAccess", str, is_required=True),
        E("voice_messaging_access", "voiceMessagingAccess", str, is_required=True),
        E("department_admin_user_access", "departmentAdminUserAccess", str, is_required=True),
        E("user_authentication_access", "userAuthenticationAccess", str, is_required=True),
        E("user_group_directory_access", "userGroupDirectoryAccess", str, is_required=True),
        E("user_profile_access", "userProfileAccess", str, is_required=True),
    )

    calling_plan_access: str = Field(type=str, required=True, mutable=False)
    extension_access: str = Field(type=str, required=True, mutable=False)
    ldap_integration_access: str = Field(type=str, required=True, mutable=False)
    voice_messaging_access: str = Field(type=str, required=True, mutable=False)
    department_admin_user_access: str = Field(type=str, required=True, mutable=False)
    user_authentication_access: str = Field(type=str, required=True, mutable=False)
    user_group_directory_access: str = Field(type=str, required=True, mutable=False)
    user_profile_access: str = Field(type=str, required=True, mutable=False)


class GroupPolicyGetResponse14sp1(OCIResponse):
    """
    Response to ``GroupPolicyGetRequest14sp1()``.

    Contains the policy settings for the group.

    Attributes:
        calling_plan_access: callingPlanAccess
        extension_access: extensionAccess
        ldap_integration_access: ldapIntegrationAccess
        voice_messaging_access: voiceMessagingAccess
        department_admin_user_access: departmentAdminUserAccess
        department_admin_trunk_group_access: departmentAdminTrunkGroupAccess
        user_authentication_access: userAuthenticationAccess
        user_group_directory_access: userGroupDirectoryAccess
        user_profile_access: userProfileAccess
    """

    _ELEMENTS = (
        E("calling_plan_access", "callingPlanAccess", str, is_required=True),
        E("extension_access", "extensionAccess", str, is_required=True),
        E("ldap_integration_access", "ldapIntegrationAccess", str, is_required=True),
        E("voice_messaging_access", "voiceMessagingAccess", str, is_required=True),
        E("department_admin_user_access", "departmentAdminUserAccess", str, is_required=True),
        E(
            "department_admin_trunk_group_access", "departmentAdminTrunkGroupAccess", str,
            is_required=True,
        ),
        E("user_authentication_access", "userAuthenticationAccess", str, is_required=True),
        E("user_group_directory_access", "userGroupDirectoryAccess", str, is_required=True),
        E("user_profile_access", "userProfileAccess", str, is_required=True),
    )

    calling_plan_access: str = Field(type=str, required=True, mutable=False)
    extension_access: str = Field(type=str, required=True, mutable=False)
    ldap_integration_access: str = Field(type=str, required=True, mutable=False)
    voice_messaging_access: str = Field(type=str, required=True, mutable=False)
    department_admin_user_access: str = Field(type=str, required=True, mutable=False)
    department_admin_trunk_group_access: str = Field(type=str, required=True, mutable=False)
    user_authentication_access: str = Field(type=str, required=True, mutable=False)
    user_group_directory_access: str = Field(type=str, required=True, mutable=False)
    user_profile_access: str = Field(type=str, required=True, mutable=False)


class GroupPolicyGetResponse14sp4(OCIResponse):
    """
    Response to ``GroupPolicyGetRequest14sp4()``.

    Contains the policy settings for the group.

    Attributes:
        calling_plan_access: callingPlanAccess
        extension_access: extensionAccess
        ldap_integration_access: ldapIntegrationAccess
        voice_messaging_access: voiceMessagingAccess
        department_admin_user_access: departmentAdminUserAccess
        department_admin_trunk_group_access: departmentAdminTrunkGroupAccess
        user_authentication_access: userAuthenticationAccess
        user_group_directory_access: userGroupDirectoryAccess
        user_profile_access: userProfileAccess
        user_enhanced_call_log_access: userEnhancedCallLogAccess
    """

    _ELEMENTS = (
        E("calling_plan_access", "callingPlanAccess", str, is_required=True),
        E("extension_access", "extensionAccess", str, is_required=True),
        E("ldap_integration_access", "ldapIntegrationAccess", str, is_required=True),
        E("voice_messaging_access", "voiceMessagingAccess", str, is_required=True),
        E("department_admin_user_access", "departmentAdminUserAccess", str, is_required=True),
        E(
            "department_admin_trunk_group_access", "departmentAdminTrunkGroupAccess", str,
            is_required=True,
        ),
        E("user_authentication_access", "userAuthenticationAccess", str, is_required=True),
        E("user_group_directory_access", "userGroupDirectoryAccess", str, is_required=True),
        E("user_profile_access", "userProfileAccess", str, is_required=True),
        E(
            "user_enhanced_call_log_access", "userEnhancedCallLogAccess", str,
            is_required=True,
        ),
    )

    calling_plan_access: str = Field(type=str, required=True, mutable=False)
    extension_access: str = Field(type=str, required=True, mutable=False)
    ldap_integration_access: str = Field(type=str, required=True, mutable=False)
    voice_messaging_access: str = Field(type=str, required=True, mutable=False)
    department_admin_user_access: str = Field(type=str, required=True, mutable=False)
    department_admin_trunk_group_access: str = Field(type=str, required=True, mutable=False)
    user_authentication_access: str = Field(type=str, required=True, mutable=False)
    user_group_directory_access: str = Field(type=str, required=True, mutable=False)
    user_profile_access: str = Field(type=str, required=True, mutable=False)
    user_enhanced_call_log_access: str = Field(type=str, required=True, mutable=False)


class GroupPolicyGetResponse17(OCIResponse):
    """
    Response to ``GroupPolicyGetRequest17()``.

    Contains the policy settings for the group.

    Attributes:
        calling_plan_access: callingPlanAccess
        extension_access: extensionAccess
        ldap_integration_access: ldapIntegrationAccess
        voice_messaging_access: voiceMessagingAccess
        department_admin_user_access: departmentAdminUserAccess
        department_admin_trunk_group_access: departmentAdminTrunkGroupAccess
        department_admin_phone_number_extension_access:
            departmentAdminPhoneNumberExtensionAccess
        department_admin_calling_line_id_number_access:
            departmentAdminCallingLineIdNumberAccess
        user_authentication_access: userAuthenticationAccess
        user_group_directory_access: userGroupDirectoryAccess
        user_profile_access: userProfileAccess
        user_enhanced_call_log_access: userEnhancedCallLogAccess
    """

    _ELEMENTS = (
        E("calling_plan_access", "callingPlanAccess", str, is_required=True),
        E("extension_access", "extensionAccess", str, is_required=True),
        E("ldap_integration_access", "ldapIntegrationAccess", str, is_required=True),
        E("voice_messaging_access", "voiceMessagingAccess", str, is_required=True),
        E("department_admin_user_access", "departmentAdminUserAccess", str, is_required=True),
        E(
            "department_admin_trunk_group_access", "departmentAdminTrunkGroupAccess", str,
            is_required=True,
        ),
        E(
            "department_admin_phone_number_extension_access",
            "departmentAdminPhoneNumberExtensionAccess", str, is_required=True,
        ),
        E(
            "department_admin_calling_line_id_number_access",
            "departmentAdminCallingLineIdNumberAccess", str, is_required=True,
        ),
        E("user_authentication_access", "userAuthenticationAccess", str, is_required=True),
        E("user_group_directory_access", "userGroupDirectoryAccess", str, is_required=True),
        E("user_profile_access", "userProfileAccess", str, is_required=True),
        E(
            "user_enhanced_call_log_access", "userEnhancedCallLogAccess", str,
            is_required=True,
        ),
    )

    calling_plan_access: str = Field(type=str, required=True, mutable=False)
    extension_access: str = Field(type=str, required=True, mutable=False)
    ldap_integration_access: str = Field(type=str, required=True, mutable=False)
    voice_messaging_access: str = Field(type=str, required=True, mutable=False)
    department_admin_user_access: str = Field(type=str, required=True, mutable=False)
    department_admin_trunk_group_access: str = Field(type=str, required=True, mutable=False)
    department_admin_phone_number_extension_access: str = Field(
        type=str, required=True, mutable=False,
    )
    department_admin_calling_line_id_number_access: str = Field(
        type=str, required=True, mutable=False,
    )
    user_authentication_access: str = Field(type=str, required=True, mutable=False)
    user_group_directory_access: str = Field(type=str, required=True, mutable=False)
    user_profile_access: str = Field(type=str, required=True, mutable=False)
    user_enhanced_call_log_access: str = Field(type=str, required=True, mutable=False)


class GroupPolicyGetResponse20(OCIResponse):
    """
    Response to ``GroupPolicyGetRequest20()``.

    Contains the policy settings for the group.

    Attributes:
        calling_plan_access: callingPlanAccess
        extension_access: extensionAccess
        ldap_integration_access: ldapIntegrationAccess
        voice_messaging_access: voiceMessagingAccess
        department_admin_user_access: departmentAdminUserAccess
        department_admin_trunk_group_access: departmentAdminTrunkGroupAccess
        department_admin_phone_number_extension_access:
            departmentAdminPhoneNumberExtensionAccess
        department_admin_calling_line_id_number_access:
            departmentAdminCallingLineIdNumberAccess
        user_authentication_access: userAuthenticationAccess
        user_group_directory_access: userGroupDirectoryAccess
        user_profile_access: userProfileAccess
        user_enhanced_call_log_access: userEnhancedCallLogAccess
        user_auto_attendant_name_dialing_access: userAutoAttendantNameDialingAccess
    """

    _ELEMENTS = (
        E("calling_plan_access", "callingPlanAccess", str, is_required=True),
        E("extension_access", "extensionAccess", str, is_required=True),
        E("ldap_integration_access", "ldapIntegrationAccess", str, is_required=True),
        E("voice_messaging_access", "voiceMessagingAccess", str, is_required=True),
        E("department_admin_user_access", "departmentAdminUserAccess", str, is_required=True),
        E(
            "department_admin_trunk_group_access", "departmentAdminTrunkGroupAccess", str,
            is_required=True,
        ),
        E(
            "department_admin_phone_number_extension_access",
            "departmentAdminPhoneNumberExtensionAccess", str, is_required=True,
        ),
        E(
            "department_admin_calling_line_id_number_access",
            "departmentAdminCallingLineIdNumberAccess", str, is_required=True,
        ),
        E("user_authentication_access", "userAuthenticationAccess", str, is_required=True),
        E("user_group_directory_access", "userGroupDirectoryAccess", str, is_required=True),
        E("user_profile_access", "userProfileAccess", str, is_required=True),
        E(
            "user_enhanced_call_log_access", "userEnhancedCallLogAccess", str,
            is_required=True,
        ),
        E(
            "user_auto_attendant_name_dialing_access",
            "userAutoAttendantNameDialingAccess", str, is_required=True,
        ),
    )

    calling_plan_access: str = Field(type=str, required=True, mutable=False)
    extension_access: str = Field(type=str, required=True, mutable=False)
    ldap_integration_access: str = Field(type=str, required=True, mutable=False)
    voice_messaging_access: str = Field(type=str, required=True, mutable=False)
    department_admin_user_access: str = Field(type=str, required=True, mutable=False)
    department_admin_trunk_group_access: str = Field(type=str, required=True, mutable=False)
    department_admin_phone_number_extension_access: str = Field(
        type=str, required=True, mutable=False,
    )
    department_admin_calling_line_id_number_access: str = Field(
        type=str, required=True, mutable=False,
    )
    user_authentication_access: str = Field(type=str, required=True, mutable=False)
    user_group_directory_access: str = Field(type=str, required=True, mutable=False)
    user_profile_access: str = Field(type=str, required=True, mutable=False)
    user_enhanced_call_log_access: str = Field(type=str, required=True, mutable=False)
    user_auto_attendant_name_dialing_access: str = Field(
        type=str, required=True, mutable=False,
    )


class GroupPolycomPhoneServicesGetResponse(OCIResponse):
    """
    Response to ``GroupPolycomPhoneServicesGetRequest()``.


    Attributes:
        include_group_common_phone_list_in_directory:
            includeGroupCommonPhoneListInDirectory
        include_group_custom_contact_directory_in_directory:
            includeGroupCustomContactDirectoryInDirectory
        group_custom_contact_directory: groupCustomContactDirectory
    """

    _ELEMENTS = (
        E(
            "include_group_common_phone_list_in_directory",
            "includeGroupCommonPhoneListInDirectory", bool, is_required=True,
        ),
        E(
            "include_group_custom_contact_directory_in_directory",
            "includeGroupCustomContactDirectoryInDirectory", bool, is_required=True,
        ),
        E("group_custom_contact_directory", "groupCustomContactDirectory", str),
    )

    include_group_common_phone_list_in_directory: bool = Field(
        type=bool, required=True, mutable=False,
    )
    include_group_custom_contact_directory_in_directory: bool = Field(
        type=bool, required=True, mutable=False,
    )
    group_custom_contact_directory: str = Field(type=str, required=False, mutable=False)


class GroupPortalPasscodeRulesGetResponse(OCIResponse):
    """
    Response to ``GroupPortalPasscodeRulesGetRequest()``.

    Contains the group's passcode rules setting.

    Attributes:
        use_rule_level: useRuleLevel
        disallow_repeated_digits: disallowRepeatedDigits
        disallow_user_number: disallowUserNumber
        disallow_reversed_user_number: disallowReversedUserNumber
        disallow_old_passcode: disallowOldPasscode
        disallow_reversed_old_passcode: disallowReversedOldPasscode
        min_code_length: minCodeLength
        max_code_length: maxCodeLength
        disable_login_after_max_failed_login_attempts:
            disableLoginAfterMaxFailedLoginAttempts
        max_failed_login_attempts: maxFailedLoginAttempts
        expire_password: expirePassword
        passcode_expires_days: passcodeExpiresDays
        send_login_disabled_notify_email: sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address: loginDisabledNotifyEmailAddress
    """

    _ELEMENTS = (
        E("use_rule_level", "useRuleLevel", str, is_required=True),
        E("disallow_repeated_digits", "disallowRepeatedDigits", bool, is_required=True),
        E("disallow_user_number", "disallowUserNumber", bool, is_required=True),
        E(
            "disallow_reversed_user_number", "disallowReversedUserNumber", bool,
            is_required=True,
        ),
        E("disallow_old_passcode", "disallowOldPasscode", bool, is_required=True),
        E(
            "disallow_reversed_old_passcode", "disallowReversedOldPasscode", bool,
            is_required=True,
        ),
        E("min_code_length", "minCodeLength", int, is_required=True),
        E("max_code_length", "maxCodeLength", int, is_required=True),
        E(
            "disable_login_after_max_failed_login_attempts",
            "disableLoginAfterMaxFailedLoginAttempts", bool, is_required=True,
        ),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int),
        E("expire_password", "expirePassword", bool, is_required=True),
        E("passcode_expires_days", "passcodeExpiresDays", int),
        E(
            "send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool,
            is_required=True,
        ),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
    )

    use_rule_level: str = Field(type=str, required=True, mutable=False)
    disallow_repeated_digits: bool = Field(type=bool, required=True, mutable=False)
    disallow_user_number: bool = Field(type=bool, required=True, mutable=False)
    disallow_reversed_user_number: bool = Field(type=bool, required=True, mutable=False)
    disallow_old_passcode: bool = Field(type=bool, required=True, mutable=False)
    disallow_reversed_old_passcode: bool = Field(type=bool, required=True, mutable=False)
    min_code_length: int = Field(type=int, required=True, mutable=False)
    max_code_length: int = Field(type=int, required=True, mutable=False)
    disable_login_after_max_failed_login_attempts: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_failed_login_attempts: int = Field(type=int, required=False, mutable=False)
    expire_password: bool = Field(type=bool, required=True, mutable=False)
    passcode_expires_days: int = Field(type=int, required=False, mutable=False)
    send_login_disabled_notify_email: bool = Field(type=bool, required=True, mutable=False)
    login_disabled_notify_email_address: str = Field(type=str, required=False, mutable=False)


class GroupPortalPasscodeRulesGetResponse19(OCIResponse):
    """
    Response to ``GroupPortalPasscodeRulesGetRequest19()``.

    Contains the group's passcode rules setting.  The following elements are only used in
    AS data mode: numberOfRepeatedDigits disallowRepeatedPatterns
    disallowContiguousSequences numberOfAscendingDigits numberOfDescendingDigits
    numberOfPreviousPasscodes

    Attributes:
        use_rule_level: useRuleLevel
        disallow_repeated_digits: disallowRepeatedDigits
        number_of_repeated_digits: numberOfRepeatedDigits
        disallow_repeated_patterns: disallowRepeatedPatterns
        disallow_contiguous_sequences: disallowContiguousSequences
        number_of_ascending_digits: numberOfAscendingDigits
        number_of_descending_digits: numberOfDescendingDigits
        disallow_user_number: disallowUserNumber
        disallow_reversed_user_number: disallowReversedUserNumber
        disallow_old_passcode: disallowOldPasscode
        number_of_previous_passcodes: numberOfPreviousPasscodes
        disallow_reversed_old_passcode: disallowReversedOldPasscode
        min_code_length: minCodeLength
        max_code_length: maxCodeLength
        disable_login_after_max_failed_login_attempts:
            disableLoginAfterMaxFailedLoginAttempts
        max_failed_login_attempts: maxFailedLoginAttempts
        expire_password: expirePassword
        passcode_expires_days: passcodeExpiresDays
        send_login_disabled_notify_email: sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address: loginDisabledNotifyEmailAddress
    """

    _ELEMENTS = (
        E("use_rule_level", "useRuleLevel", str, is_required=True),
        E("disallow_repeated_digits", "disallowRepeatedDigits", bool, is_required=True),
        E("number_of_repeated_digits", "numberOfRepeatedDigits", int, is_required=True),
        E("disallow_repeated_patterns", "disallowRepeatedPatterns", bool, is_required=True),
        E(
            "disallow_contiguous_sequences", "disallowContiguousSequences", bool,
            is_required=True,
        ),
        E("number_of_ascending_digits", "numberOfAscendingDigits", int, is_required=True),
        E("number_of_descending_digits", "numberOfDescendingDigits", int, is_required=True),
        E("disallow_user_number", "disallowUserNumber", bool, is_required=True),
        E(
            "disallow_reversed_user_number", "disallowReversedUserNumber", bool,
            is_required=True,
        ),
        E("disallow_old_passcode", "disallowOldPasscode", bool, is_required=True),
        E("number_of_previous_passcodes", "numberOfPreviousPasscodes", int, is_required=True),
        E(
            "disallow_reversed_old_passcode", "disallowReversedOldPasscode", bool,
            is_required=True,
        ),
        E("min_code_length", "minCodeLength", int, is_required=True),
        E("max_code_length", "maxCodeLength", int, is_required=True),
        E(
            "disable_login_after_max_failed_login_attempts",
            "disableLoginAfterMaxFailedLoginAttempts", bool, is_required=True,
        ),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int),
        E("expire_password", "expirePassword", bool, is_required=True),
        E("passcode_expires_days", "passcodeExpiresDays", int),
        E(
            "send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool,
            is_required=True,
        ),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
    )

    use_rule_level: str = Field(type=str, required=True, mutable=False)
    disallow_repeated_digits: bool = Field(type=bool, required=True, mutable=False)
    number_of_repeated_digits: int = Field(type=int, required=True, mutable=False)
    disallow_repeated_patterns: bool = Field(type=bool, required=True, mutable=False)
    disallow_contiguous_sequences: bool = Field(type=bool, required=True, mutable=False)
    number_of_ascending_digits: int = Field(type=int, required=True, mutable=False)
    number_of_descending_digits: int = Field(type=int, required=True, mutable=False)
    disallow_user_number: bool = Field(type=bool, required=True, mutable=False)
    disallow_reversed_user_number: bool = Field(type=bool, required=True, mutable=False)
    disallow_old_passcode: bool = Field(type=bool, required=True, mutable=False)
    number_of_previous_passcodes: int = Field(type=int, required=True, mutable=False)
    disallow_reversed_old_passcode: bool = Field(type=bool, required=True, mutable=False)
    min_code_length: int = Field(type=int, required=True, mutable=False)
    max_code_length: int = Field(type=int, required=True, mutable=False)
    disable_login_after_max_failed_login_attempts: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_failed_login_attempts: int = Field(type=int, required=False, mutable=False)
    expire_password: bool = Field(type=bool, required=True, mutable=False)
    passcode_expires_days: int = Field(type=int, required=False, mutable=False)
    send_login_disabled_notify_email: bool = Field(type=bool, required=True, mutable=False)
    login_disabled_notify_email_address: str = Field(type=str, required=False, mutable=False)


class GroupPreAlertingAnnouncementGetResponse(OCIResponse):
    """
    Get the group level pre-alerting service settings.

    The response is either a ``GroupPreAlertingAnnouncementGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        announcement_interruption: announcementInterruption
        interruption_digit_sequence: interruptionDigitSequence
        audio_selection: audioSelection
        audio_file_description: audioFileDescription
        audio_media_type: audioMediaType
        audio_file_url: audioFileUrl
        video_selection: videoSelection
        video_file_description: videoFileDescription
        video_media_type: videoMediaType
        video_file_url: videoFileUrl
    """

    _ELEMENTS = (
        E("announcement_interruption", "announcementInterruption", str, is_required=True),
        E("interruption_digit_sequence", "interruptionDigitSequence", str),
        E("audio_selection", "audioSelection", str, is_required=True),
        E("audio_file_description", "audioFileDescription", str),
        E("audio_media_type", "audioMediaType", str),
        E("audio_file_url", "audioFileUrl", str),
        E("video_selection", "videoSelection", str, is_required=True),
        E("video_file_description", "videoFileDescription", str),
        E("video_media_type", "videoMediaType", str),
        E("video_file_url", "videoFileUrl", str),
    )

    announcement_interruption: str = Field(type=str, required=True, mutable=False)
    interruption_digit_sequence: str = Field(type=str, required=False, mutable=False)
    audio_selection: str = Field(type=str, required=True, mutable=False)
    audio_file_description: str = Field(type=str, required=False, mutable=False)
    audio_media_type: str = Field(type=str, required=False, mutable=False)
    audio_file_url: str = Field(type=str, required=False, mutable=False)
    video_selection: str = Field(type=str, required=True, mutable=False)
    video_file_description: str = Field(type=str, required=False, mutable=False)
    video_media_type: str = Field(type=str, required=False, mutable=False)
    video_file_url: str = Field(type=str, required=False, mutable=False)


class GroupRouteListEnterpriseTrunkNumberRangeGetAvailableListResponse(OCIResponse):
    """
    Response to ``GroupRouteListEnterpriseTrunkNumberRangeGetAvailableListRequest()``.

    Contains a list of number ranges that are assigned to a group and still available for
    assignment to users within the group.  The column headings are "Number Range Start",
    "Number Range End" and "Is Active".

    Attributes:
        available_number_range_table: availableNumberRangeTable
    """

    _ELEMENTS = (
        E(
            "available_number_range_table", "availableNumberRangeTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    available_number_range_table: "list" = Field(type=list, required=True, mutable=False)


class GroupRouteListEnterpriseTrunkNumberRangeGetSummaryListResponse(OCIResponse):
    """
    Response to ``GroupRouteListEnterpriseTrunkNumberRangeGetSummaryListRequest()``.

    The response contains a table with columns: "Number Range Start", "Number Range End",
    "User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address", "Enterprise Trunk" and "Is
    Active". The "User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana
    First Name", "Phone Number", "Extension", "Department" and "Email Address" columns
    contains the corresponding attributes of the user possessing the number range.  The
    "Enterprise Trunk" column contains the enterprise trunk the user possessing the number
    range belongs to.  The "Is Active" column indicates if the number range has been
    activated.

    Attributes:
        number_range_summary_table: numberRangeSummaryTable
    """

    _ELEMENTS = (
        E(
            "number_range_summary_table", "numberRangeSummaryTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    number_range_summary_table: "list" = Field(type=list, required=True, mutable=False)


class GroupRoutePointBouncedCallGetResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointBouncedCallGetRequest()``.


    Attributes:
        is_active: isActive
        number_of_rings_before_bouncing_call: numberOfRingsBeforeBouncingCall
        enable_transfer: enableTransfer
        transfer_phone_number: transferPhoneNumber
        bounce_call_when_agent_unavailable: bounceCallWhenAgentUnavailable
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E(
            "number_of_rings_before_bouncing_call", "numberOfRingsBeforeBouncingCall",
            int, is_required=True,
        ),
        E("enable_transfer", "enableTransfer", bool),
        E("transfer_phone_number", "transferPhoneNumber", str),
        E(
            "bounce_call_when_agent_unavailable", "bounceCallWhenAgentUnavailable", bool,
            is_required=True,
        ),
    )

    is_active: bool = Field(type=bool, required=True, mutable=False)
    number_of_rings_before_bouncing_call: int = Field(type=int, required=True, mutable=False)
    enable_transfer: bool = Field(type=bool, required=False, mutable=False)
    transfer_phone_number: str = Field(type=str, required=False, mutable=False)
    bounce_call_when_agent_unavailable: bool = Field(type=bool, required=True, mutable=False)


class GroupRoutePointDistinctiveRingingGetResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointDistinctiveRingingGetRequest()``.


    Attributes:
        enable_distinctive_ringing: enableDistinctiveRinging
        distinctive_ringing_ring_pattern: distinctiveRingingRingPattern
        distinctive_ringing_force_delivery_ring_pattern:
            distinctiveRingingForceDeliveryRingPattern
    """

    _ELEMENTS = (
        E("enable_distinctive_ringing", "enableDistinctiveRinging", bool, is_required=True),
        E(
            "distinctive_ringing_ring_pattern", "distinctiveRingingRingPattern", str,
            is_required=True,
        ),
        E(
            "distinctive_ringing_force_delivery_ring_pattern",
            "distinctiveRingingForceDeliveryRingPattern", str, is_required=True,
        ),
    )

    enable_distinctive_ringing: bool = Field(type=bool, required=True, mutable=False)
    distinctive_ringing_ring_pattern: str = Field(type=str, required=True, mutable=False)
    distinctive_ringing_force_delivery_ring_pattern: str = Field(
        type=str, required=True, mutable=False,
    )


class GroupRoutePointExternalSystemGetAssignedListResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointExternalSystemGetAssignedListRequest()``.

    Contains a table of all Route Point External Systems assigned to the group.  The
    column headings are: "Name" and "Description".

    Attributes:
        external_system_table: externalSystemTable
    """

    _ELEMENTS = (
        E(
            "external_system_table", "externalSystemTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    external_system_table: "list" = Field(type=list, required=True, mutable=False)


class GroupRoutePointExternalSystemGetAssignedRoutePointListResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointExternalSystemGetAssignedRoutePointListRequest()``.

    Contains a table with column headings: "Service User Id", "Name", "Video", "Phone
    Number", "Extension", "Department". The column values for "Video" can either be
    "true", or "false".

    Attributes:
        route_point_table: routePointTable
    """

    _ELEMENTS = (
        E(
            "route_point_table", "routePointTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    route_point_table: "list" = Field(type=list, required=True, mutable=False)


class GroupRoutePointGetDNISAgentListResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointGetDNISAgentListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        agent_table: agentTable
    """

    _ELEMENTS = (
        E(
            "agent_table", "agentTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    agent_table: "list" = Field(type=list, required=True, mutable=False)


class GroupRoutePointGetDNISListResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointGetDNISListRequest()``.

    Contains a table with column headings: "Name", "Phone Number", "Extension".

    Attributes:
        display_dnis_number: displayDNISNumber
        display_dnis_name: displayDNISName
        dnis_table: dnisTable
    """

    _ELEMENTS = (
        E("display_dnis_number", "displayDNISNumber", bool, is_required=True),
        E("display_dnis_name", "displayDNISName", bool, is_required=True),
        E("dnis_table", "dnisTable", list, is_complex=True, is_required=True, is_table=True),
    )

    display_dnis_number: bool = Field(type=bool, required=True, mutable=False)
    display_dnis_name: bool = Field(type=bool, required=True, mutable=False)
    dnis_table: "list" = Field(type=list, required=True, mutable=False)


class GroupRoutePointGetDNISResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointGetDNISRequest()``.


    Attributes:
        dnis_phone_number: dnisPhoneNumber
        extension: extension
        use_custom_clid_settings: useCustomCLIDSettings
        calling_line_id_phone_number: callingLineIdPhoneNumber
        calling_line_id_last_name: callingLineIdLastName
        calling_line_id_first_name: callingLineIdFirstName
        use_custom_dnis_announcement_settings: useCustomDnisAnnouncementSettings
        allow_outgoing_acd_call: allowOutgoingACDCall
    """

    _ELEMENTS = (
        E("dnis_phone_number", "dnisPhoneNumber", str),
        E("extension", "extension", str),
        E("use_custom_clid_settings", "useCustomCLIDSettings", bool, is_required=True),
        E("calling_line_id_phone_number", "callingLineIdPhoneNumber", str),
        E("calling_line_id_last_name", "callingLineIdLastName", str),
        E("calling_line_id_first_name", "callingLineIdFirstName", str),
        E(
            "use_custom_dnis_announcement_settings", "useCustomDnisAnnouncementSettings",
            bool, is_required=True,
        ),
        E("allow_outgoing_acd_call", "allowOutgoingACDCall", bool, is_required=True),
    )

    dnis_phone_number: str = Field(type=str, required=False, mutable=False)
    extension: str = Field(type=str, required=False, mutable=False)
    use_custom_clid_settings: bool = Field(type=bool, required=True, mutable=False)
    calling_line_id_phone_number: str = Field(type=str, required=False, mutable=False)
    calling_line_id_last_name: str = Field(type=str, required=False, mutable=False)
    calling_line_id_first_name: str = Field(type=str, required=False, mutable=False)
    use_custom_dnis_announcement_settings: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_outgoing_acd_call: bool = Field(type=bool, required=True, mutable=False)


class GroupRoutePointGetFailoverPolicyResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointGetFailoverPolicyRequest()``.


    Attributes:
        enable_failover_support: enableFailoverSupport
        external_system: externalSystem
        failover_phone_number: failoverPhoneNumber
        failover_status: failoverStatus
        per_call_enable_failover_support: perCallEnableFailoverSupport
        per_call_call_failure_timeout_seconds: perCallCallFailureTimeoutSeconds
        per_call_outbound_call_failure_timeout_seconds:
            perCallOutboundCallFailureTimeoutSeconds
        per_call_failover_phone_number: perCallFailoverPhoneNumber
    """

    _ELEMENTS = (
        E("enable_failover_support", "enableFailoverSupport", bool, is_required=True),
        E("external_system", "externalSystem", str),
        E("failover_phone_number", "failoverPhoneNumber", str),
        E("failover_status", "failoverStatus", str, is_required=True),
        E(
            "per_call_enable_failover_support", "perCallEnableFailoverSupport", bool,
            is_required=True,
        ),
        E(
            "per_call_call_failure_timeout_seconds", "perCallCallFailureTimeoutSeconds",
            int, is_required=True,
        ),
        E(
            "per_call_outbound_call_failure_timeout_seconds",
            "perCallOutboundCallFailureTimeoutSeconds", int, is_required=True,
        ),
        E("per_call_failover_phone_number", "perCallFailoverPhoneNumber", str),
    )

    enable_failover_support: bool = Field(type=bool, required=True, mutable=False)
    external_system: str = Field(type=str, required=False, mutable=False)
    failover_phone_number: str = Field(type=str, required=False, mutable=False)
    failover_status: str = Field(type=str, required=True, mutable=False)
    per_call_enable_failover_support: bool = Field(type=bool, required=True, mutable=False)
    per_call_call_failure_timeout_seconds: int = Field(type=int, required=True, mutable=False)
    per_call_outbound_call_failure_timeout_seconds: int = Field(
        type=int, required=True, mutable=False,
    )
    per_call_failover_phone_number: str = Field(type=str, required=False, mutable=False)


class GroupRoutePointGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointGetInstanceListRequest()``.

    Contains a table with column headings: "Service User Id", "Name", "Video", "Phone
    Number", "Extension", "Department", "Is Active". The column values for "Video" and "Is
    Active" can either be true, or false.

    Attributes:
        route_point_table: routePointTable
    """

    _ELEMENTS = (
        E(
            "route_point_table", "routePointTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    route_point_table: "list" = Field(type=list, required=True, mutable=False)


class GroupRoutePointQueueCallDispositionCodeGetListResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointQueueCallDispositionCodeGetListRequest()``.

    Contains a table with column headings: "Is Active", "Code", "Description" and "Level".
    Level column can be any of the values in the data type CallDispositionCodeLevel.

    Attributes:
        disposition_codes_table: dispositionCodesTable
    """

    _ELEMENTS = (
        E(
            "disposition_codes_table", "dispositionCodesTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    disposition_codes_table: "list" = Field(type=list, required=True, mutable=False)


class GroupRoutePointQueueCallDispositionCodeGetResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointQueueCallDispositionCodeGetRequest()``

    Attributes:
        is_active: isActive
        description: description
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("description", "description", str),
    )

    is_active: bool = Field(type=bool, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class GroupRoutingProfileGetResponse(OCIResponse):
    """
    Response to ``GroupRoutingProfileGetRequest()``.


    Attributes:
        routing_profile: routingProfile
    """

    _ELEMENTS = (
        E("routing_profile", "routingProfile", str),
    )

    routing_profile: str = Field(type=str, required=False, mutable=False)


class GroupScheduleGetEventListResponse(OCIResponse):
    """
    Response to ``GroupScheduleGetEventListRequest()``.

    The response contains a list of events.

    Attributes:
        event_name: eventName
    """

    _ELEMENTS = (
        E("event_name", "eventName", str, is_array=True),
    )

    event_name: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupScheduleGetListResponse(OCIResponse):
    """
    Response to ``GroupScheduleGetListRequest()``.

    The response contains a list of system schedules.

    Attributes:
        schedule_name: scheduleName
        schedule_type: scheduleType
        schedule_level: scheduleLevel
    """

    _ELEMENTS = (
        E("schedule_name", "scheduleName", str, is_array=True),
        E("schedule_type", "scheduleType", str, is_array=True),
        E("schedule_level", "scheduleLevel", str, is_array=True),
    )

    schedule_name: "List[str]" = Field(type=list, required=False, mutable=False)
    schedule_type: "List[str]" = Field(type=list, required=False, mutable=False)
    schedule_level: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupSeriesCompletionGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupSeriesCompletionGetAvailableUserListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupSeriesCompletionGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupSeriesCompletionGetInstanceListRequest()``.


    Attributes:
        name: name
    """

    _ELEMENTS = (
        E("name", "name", str, is_array=True),
    )

    name: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupSeriesCompletionGetInstanceResponse(OCIResponse):
    """
    Response to the ``GroupSeriesCompletionGetInstanceRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupServiceGetAuthorizationListResponse(OCIResponse):
    """
    Response to ``GroupServiceGetAuthorizationListRequest()``.

    Contains three tables, one for the service packs, one for the group services, and one
    for the user services.  The user table has the following column headings: "Service
    Name", "Authorized", "Assigned", "Limited", "Quantity", "Usage", "Licensed",
    "Allowed", "User Assignable", "Group Service Assignable". The group service table has
    the following column headings: "Service Name", "Authorized", "Assigned", "Limited",
    "Quantity", "Usage", "Licensed", "Allowed". The service pack table's column headings
    are: "Service Pack Name", "Authorized", "Assigned", "Limited", "Allocated", "Allowed",
    "Usage", "Description".

    Attributes:
        service_packs_authorization_table: servicePacksAuthorizationTable
        group_services_authorization_table: groupServicesAuthorizationTable
        user_services_authorization_table: userServicesAuthorizationTable
    """

    _ELEMENTS = (
        E(
            "service_packs_authorization_table", "servicePacksAuthorizationTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
        E(
            "group_services_authorization_table", "groupServicesAuthorizationTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
        E(
            "user_services_authorization_table", "userServicesAuthorizationTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    service_packs_authorization_table: "list" = Field(type=list, required=True, mutable=False)
    group_services_authorization_table: "list" = Field(
        type=list, required=True, mutable=False,
    )
    user_services_authorization_table: "list" = Field(type=list, required=True, mutable=False)


class GroupServiceGetAuthorizedListResponse(OCIResponse):
    """
    Response to ``GroupServiceGetAuthorizedListRequest()``.


    Attributes:
        service_pack_name: servicePackName
        group_service_name: groupServiceName
        user_service_name: userServiceName
    """

    _ELEMENTS = (
        E("service_pack_name", "servicePackName", str, is_array=True),
        E("group_service_name", "groupServiceName", str, is_array=True),
        E("user_service_name", "userServiceName", str, is_array=True),
    )

    service_pack_name: "List[str]" = Field(type=list, required=False, mutable=False)
    group_service_name: "List[str]" = Field(type=list, required=False, mutable=False)
    user_service_name: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupServiceInstancePrivacyGetResponse(OCIResponse):
    """
    Response to ``GroupServiceInstancePrivacyGetRequest()``.

    Replaced by: ``GroupServiceInstancePrivacyGetResponse17sp4()``

    Attributes:
        enable_directory_privacy: enableDirectoryPrivacy
        enable_auto_attendant_extension_dialing_privacy:
            enableAutoAttendantExtensionDialingPrivacy
    """

    _ELEMENTS = (
        E("enable_directory_privacy", "enableDirectoryPrivacy", bool, is_required=True),
        E(
            "enable_auto_attendant_extension_dialing_privacy",
            "enableAutoAttendantExtensionDialingPrivacy", bool, is_required=True,
        ),
    )

    enable_directory_privacy: bool = Field(type=bool, required=True, mutable=False)
    enable_auto_attendant_extension_dialing_privacy: bool = Field(
        type=bool, required=True, mutable=False,
    )


class GroupServiceInstancePrivacyGetResponse17sp4(OCIResponse):
    """
    Response to ``GroupServiceInstancePrivacyGetRequest17sp4()``.


    Attributes:
        enable_directory_privacy: enableDirectoryPrivacy
        enable_auto_attendant_extension_dialing_privacy:
            enableAutoAttendantExtensionDialingPrivacy
        enable_auto_attendant_name_dialing_privacy: enableAutoAttendantNameDialingPrivacy
    """

    _ELEMENTS = (
        E("enable_directory_privacy", "enableDirectoryPrivacy", bool, is_required=True),
        E(
            "enable_auto_attendant_extension_dialing_privacy",
            "enableAutoAttendantExtensionDialingPrivacy", bool, is_required=True,
        ),
        E(
            "enable_auto_attendant_name_dialing_privacy",
            "enableAutoAttendantNameDialingPrivacy", bool, is_required=True,
        ),
    )

    enable_directory_privacy: bool = Field(type=bool, required=True, mutable=False)
    enable_auto_attendant_extension_dialing_privacy: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_auto_attendant_name_dialing_privacy: bool = Field(
        type=bool, required=True, mutable=False,
    )


class GroupServiceIsAssignedResponse(OCIResponse):
    """
    Returns true if the GroupService is assigned, otherwise false.


    Attributes:
        is_assigned: isAssigned
    """

    _ELEMENTS = (
        E("is_assigned", "isAssigned", bool, is_required=True),
    )

    is_assigned: bool = Field(type=bool, required=True, mutable=False)


class GroupServicePhoneNumberLookupResponse(OCIResponse):
    """
    Response to the ``GroupServicePhoneNumberLookupRequest()``.

    The column headings for the userTable are: "User Id", "Last Name", "First Name",
    "Hiragana Last Name", "Hiragana First Name", "Phone Number", "Extension" and
    "Department".

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupServiceScriptsGroupGetLogResponse(OCIResponse):
    """
    Response to ``GroupServiceScriptsGroupGetLogRequest()``.


    Attributes:
        log_content: logContent
    """

    _ELEMENTS = (
        E("log_content", "logContent", str),
    )

    log_content: str = Field(type=str, required=False, mutable=False)


class GroupServiceScriptsGroupGetResponse(OCIResponse):
    """
    Response to ``GroupServiceScriptsGroupGetRequest()``.


    Attributes:
        is_active: isActive
        script_name: scriptName
        script_content: scriptContent
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("script_name", "scriptName", str),
        E("script_content", "scriptContent", str),
    )

    is_active: bool = Field(type=bool, required=True, mutable=False)
    script_name: str = Field(type=str, required=False, mutable=False)
    script_content: str = Field(type=str, required=False, mutable=False)


class GroupSessionAdmissionControlGetResponse(OCIResponse):
    """
    Response to the ``GroupSessionAdmissionControlGetRequest()``.

    The response contains the session admission control capacity allocated for the group.

    Attributes:
        restrict_aggregate_sessions: restrictAggregateSessions
        max_sessions: maxSessions
        max_user_originating_sessions: maxUserOriginatingSessions
        max_user_terminating_sessions: maxUserTerminatingSessions
        count_intra_group_sessions: countIntraGroupSessions
    """

    _ELEMENTS = (
        E("restrict_aggregate_sessions", "restrictAggregateSessions", bool, is_required=True),
        E("max_sessions", "maxSessions", int),
        E("max_user_originating_sessions", "maxUserOriginatingSessions", int),
        E("max_user_terminating_sessions", "maxUserTerminatingSessions", int),
        E("count_intra_group_sessions", "countIntraGroupSessions", bool, is_required=True),
    )

    restrict_aggregate_sessions: bool = Field(type=bool, required=True, mutable=False)
    max_sessions: int = Field(type=int, required=False, mutable=False)
    max_user_originating_sessions: int = Field(type=int, required=False, mutable=False)
    max_user_terminating_sessions: int = Field(type=int, required=False, mutable=False)
    count_intra_group_sessions: bool = Field(type=bool, required=True, mutable=False)


class GroupSessionAdmissionControlGroupGetListResponse(OCIResponse):
    """
    Response to ``GroupSessionAdmissionControlGroupGetListRequest()``.

    Contains a table of session admission control group configured in the group.  The
    column headings are: "Name", "Is Default", "Maximum Sessions", "Maximum Originating
    Sessions", "Maximum Terminating Sessions".

    Attributes:
        session_admission_control_group_table: sessionAdmissionControlGroupTable
    """

    _ELEMENTS = (
        E(
            "session_admission_control_group_table", "sessionAdmissionControlGroupTable",
            list, is_complex=True, is_required=True, is_table=True,
        ),
    )

    session_admission_control_group_table: "list" = Field(
        type=list, required=True, mutable=False,
    )


class GroupSpeedDial100GetResponse(OCIResponse):
    """
    Response to the ``GroupSpeedDial100GetRequest()``.


    Attributes:
        prefix: prefix
    """

    _ELEMENTS = (
        E("prefix", "prefix", str, is_required=True),
    )

    prefix: str = Field(type=str, required=True, mutable=False)


class GroupSpeedDial100GetResponse17sp1(OCIResponse):
    """
    Response to the ``GroupSpeedDial100GetRequest17sp1()``.


    Attributes:
        prefix: prefix
    """

    _ELEMENTS = (
        E("prefix", "prefix", str),
    )

    prefix: str = Field(type=str, required=False, mutable=False)


class GroupThirdPartyVoiceMailSupportGetResponse(OCIResponse):
    """
    Response to ``GroupThirdPartyVoiceMailSupportGetRequest()``.


    Attributes:
        is_active: isActive
        group_server: groupServer
    """

    _ELEMENTS = (
        E("is_active", "isActive", bool, is_required=True),
        E("group_server", "groupServer", str),
    )

    is_active: bool = Field(type=bool, required=True, mutable=False)
    group_server: str = Field(type=str, required=False, mutable=False)


class GroupTimeScheduleGetListResponse(OCIResponse):
    """
    Response to the ``GroupTimeScheduleGetListRequest()``.

    The response contains all the group's time schedule name.

    Attributes:
        time_schedule: timeSchedule
    """

    _ELEMENTS = (
        E("time_schedule", "timeSchedule", str, is_array=True),
    )

    time_schedule: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupTrunkGroupGetAvailableDetailListResponse(OCIResponse):
    """
    Response to ``GroupTrunkGroupGetAvailableDetailListRequest()``.


    Attributes:
        trunk_group: trunkGroup
    """

    _ELEMENTS = (
        E("trunk_group", "trunkGroup", str, is_complex=True, is_array=True),  # unknown
    )

    trunk_group: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupTrunkGroupGetAvailableHostedUserListResponse(OCIResponse):
    """
    Response to the ``GroupTrunkGroupGetAvailableHostedUserListRequest()``.

    Contains a table with column headings: "User Id", "Last Name", "First Name", "Hiragana
    Last Name", "Hiragana First Name", "Phone Number", "Extension", "Department", "Email
    Address".

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupTrunkGroupGetInstanceListResponse14(OCIResponse):
    """
    Response to ``GroupTrunkGroupGetInstanceListRequest14()``.

    Contains a table with column headings "Service User Id", "Name", "Department", "Device
    Name", "Device Level", "Group Id". The "Device Level" column contains one of the
    AccessDeviceLevel enumerated constants.

    Attributes:
        trunk_group_table: trunkGroupTable
    """

    _ELEMENTS = (
        E(
            "trunk_group_table", "trunkGroupTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    trunk_group_table: "list" = Field(type=list, required=True, mutable=False)


class GroupTrunkGroupGetInstanceListResponse14sp4(OCIResponse):
    """
    Response to ``GroupTrunkGroupGetInstanceListRequest14sp4()``.

    Contains a table with column headings "Name", "Department", "Device Name", "Device
    Level", "Group Id". The "Device Level" column contains one of the AccessDeviceLevel
    enumerated constants.

    Attributes:
        trunk_group_table: trunkGroupTable
    """

    _ELEMENTS = (
        E(
            "trunk_group_table", "trunkGroupTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    trunk_group_table: "list" = Field(type=list, required=True, mutable=False)


class GroupTrunkGroupGetInstanceUserListResponse(OCIResponse):
    """
    Response to ``GroupTrunkGroupGetInstanceUserListRequest()``.

    The response contains a 7 column table with column headings "User Id", "Last Name",
    "First Name", "Department", "Phone Number", "Hiragana Last Name", "Hiragana First
    Name".

    Attributes:
        trunk_group_user_table: trunkGroupUserTable
    """

    _ELEMENTS = (
        E(
            "trunk_group_user_table", "trunkGroupUserTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    trunk_group_user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupTrunkGroupGetInstanceUserListResponse14sp4(OCIResponse):
    """
    Response to ``GroupTrunkGroupGetInstanceUserListRequest14sp4()``.

    The response contains a 9 column table with column headings "User Id", "Last Name",
    "First Name", "Department", "Phone Number", "Hiragana Last Name", "Hiragana First
    Name", "Extension", "Email Address".

    Attributes:
        trunk_group_user_table: trunkGroupUserTable
    """

    _ELEMENTS = (
        E(
            "trunk_group_user_table", "trunkGroupUserTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    trunk_group_user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupTrunkGroupSecurityClassificationGetResponse(OCIResponse):
    """
    Response to the ``GroupTrunkGroupSecurityClassificationGetRequest()``.


    Attributes:
        default_security_classification: defaultSecurityClassification
    """

    _ELEMENTS = (
        E("default_security_classification", "defaultSecurityClassification", str),
    )

    default_security_classification: str = Field(type=str, required=False, mutable=False)


class GroupTrunkGroupUserCreationTaskGetListResponse(OCIResponse):
    """
    Response to ``GroupTrunkGroupUserCreationTaskGetListRequest()``.

    Contains a table with a row for each user creation task and column headings : "Name",
    "Status", "Users Created", "Total Users To Create", "Error Count".

    Attributes:
        task_table: taskTable
    """

    _ELEMENTS = (
        E("task_table", "taskTable", list, is_complex=True, is_required=True, is_table=True),
    )

    task_table: "list" = Field(type=list, required=True, mutable=False)


class GroupTrunkGroupUserCreationTaskGetListResponse14sp4(OCIResponse):
    """
    Response to ``GroupTrunkGroupUserCreationTaskGetListRequest14sp4()``.

    Contains a table with a row for each user creation task and column headings : "Name",
    "Status", "Users Created", "Total Users To Create", "Error Count".

    Attributes:
        task_table: taskTable
    """

    _ELEMENTS = (
        E("task_table", "taskTable", list, is_complex=True, is_required=True, is_table=True),
    )

    task_table: "list" = Field(type=list, required=True, mutable=False)


class GroupTrunkGroupUserCreationTaskGetResponse(OCIResponse):
    """
    Response to a ``GroupTrunkGroupUserCreationTaskGetRequest()``.


    Attributes:
        user_id_format: userIdFormat
        user_id_domain: userIdDomain
        populate_extension: populateExtension
        line_port_format: linePortFormat
        line_port_domain: linePortDomain
        populate_contact: populateContact
        contact_format: contactFormat
        contact_domain: contactDomain
        users_created: usersCreated
        total_users_to_create: totalUsersToCreate
        error_count: errorCount
        service_pack_name: servicePackName
        user_service_name: userServiceName
        status: status
        user_creation_mode: userCreationMode
        task_summary: taskSummary
    """

    _ELEMENTS = (
        E("user_id_format", "userIdFormat", str, is_required=True),
        E("user_id_domain", "userIdDomain", str, is_required=True),
        E("populate_extension", "populateExtension", bool, is_required=True),
        E("line_port_format", "linePortFormat", str, is_required=True),
        E("line_port_domain", "linePortDomain", str, is_required=True),
        E("populate_contact", "populateContact", bool, is_required=True),
        E("contact_format", "contactFormat", str),
        E("contact_domain", "contactDomain", str),
        E("users_created", "usersCreated", int, is_required=True),
        E("total_users_to_create", "totalUsersToCreate", int, is_required=True),
        E("error_count", "errorCount", int, is_required=True),
        E("service_pack_name", "servicePackName", str, is_array=True),
        E("user_service_name", "userServiceName", str, is_array=True),
        E("status", "status", str, is_required=True),
        E("user_creation_mode", "userCreationMode", str, is_required=True),
        E("task_summary", "taskSummary", str, is_required=True),
    )

    user_id_format: str = Field(type=str, required=True, mutable=False)
    user_id_domain: str = Field(type=str, required=True, mutable=False)
    populate_extension: bool = Field(type=bool, required=True, mutable=False)
    line_port_format: str = Field(type=str, required=True, mutable=False)
    line_port_domain: str = Field(type=str, required=True, mutable=False)
    populate_contact: bool = Field(type=bool, required=True, mutable=False)
    contact_format: str = Field(type=str, required=False, mutable=False)
    contact_domain: str = Field(type=str, required=False, mutable=False)
    users_created: int = Field(type=int, required=True, mutable=False)
    total_users_to_create: int = Field(type=int, required=True, mutable=False)
    error_count: int = Field(type=int, required=True, mutable=False)
    service_pack_name: "List[str]" = Field(type=list, required=False, mutable=False)
    user_service_name: "List[str]" = Field(type=list, required=False, mutable=False)
    status: str = Field(type=str, required=True, mutable=False)
    user_creation_mode: str = Field(type=str, required=True, mutable=False)
    task_summary: str = Field(type=str, required=True, mutable=False)


class GroupTrunkGroupUserCreationTaskGetResponse14sp4(OCIResponse):
    """
    Response to a ``GroupTrunkGroupUserCreationTaskGetRequest14sp4()``.


    Attributes:
        user_id_format: userIdFormat
        user_id_domain: userIdDomain
        populate_extension: populateExtension
        line_port_format: linePortFormat
        line_port_domain: linePortDomain
        populate_contact: populateContact
        contact_format: contactFormat
        contact_domain: contactDomain
        users_created: usersCreated
        total_users_to_create: totalUsersToCreate
        error_count: errorCount
        service_pack_name: servicePackName
        user_service_name: userServiceName
        status: status
        user_creation_mode: userCreationMode
        task_summary: taskSummary
        report_file_key: reportFileKey
    """

    _ELEMENTS = (
        E("user_id_format", "userIdFormat", str, is_required=True),
        E("user_id_domain", "userIdDomain", str, is_required=True),
        E("populate_extension", "populateExtension", bool, is_required=True),
        E("line_port_format", "linePortFormat", str, is_required=True),
        E("line_port_domain", "linePortDomain", str, is_required=True),
        E("populate_contact", "populateContact", bool, is_required=True),
        E("contact_format", "contactFormat", str),
        E("contact_domain", "contactDomain", str),
        E("users_created", "usersCreated", int, is_required=True),
        E("total_users_to_create", "totalUsersToCreate", int, is_required=True),
        E("error_count", "errorCount", int, is_required=True),
        E("service_pack_name", "servicePackName", str, is_array=True),
        E("user_service_name", "userServiceName", str, is_array=True),
        E("status", "status", str, is_required=True),
        E("user_creation_mode", "userCreationMode", str, is_required=True),
        E("task_summary", "taskSummary", str, is_required=True),
        E("report_file_key", "reportFileKey", str, is_required=True),
    )

    user_id_format: str = Field(type=str, required=True, mutable=False)
    user_id_domain: str = Field(type=str, required=True, mutable=False)
    populate_extension: bool = Field(type=bool, required=True, mutable=False)
    line_port_format: str = Field(type=str, required=True, mutable=False)
    line_port_domain: str = Field(type=str, required=True, mutable=False)
    populate_contact: bool = Field(type=bool, required=True, mutable=False)
    contact_format: str = Field(type=str, required=False, mutable=False)
    contact_domain: str = Field(type=str, required=False, mutable=False)
    users_created: int = Field(type=int, required=True, mutable=False)
    total_users_to_create: int = Field(type=int, required=True, mutable=False)
    error_count: int = Field(type=int, required=True, mutable=False)
    service_pack_name: "List[str]" = Field(type=list, required=False, mutable=False)
    user_service_name: "List[str]" = Field(type=list, required=False, mutable=False)
    status: str = Field(type=str, required=True, mutable=False)
    user_creation_mode: str = Field(type=str, required=True, mutable=False)
    task_summary: str = Field(type=str, required=True, mutable=False)
    report_file_key: str = Field(type=str, required=True, mutable=False)


class GroupVirtualOnNetEnterpriseExtensionsGetUserListResponse(OCIResponse):
    """
    Response to ``GroupVirtualOnNetEnterpriseExtensionsGetUserListRequest()``.

    Contains a table with column headings: "Last Name", "First Name", "Phone Number",
    "Extension", "Virtual On-Net Call Type Name" in a row for each user.

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class GroupVirtualOnNetEnterpriseExtensionsGetUserResponse(OCIResponse):
    """
    Response to ``GroupVirtualOnNetEnterpriseExtensionsGetUserRequest()``.


    Attributes:
        extension: extension
        first_name: firstName
        last_name: lastName
        calling_line_id_first_name: callingLineIdFirstName
        calling_line_id_last_name: callingLineIdLastName
        virtual_on_net_call_type_name: virtualOnNetCallTypeName
    """

    _ELEMENTS = (
        E("extension", "extension", str, is_required=True),
        E("first_name", "firstName", str, is_required=True),
        E("last_name", "lastName", str, is_required=True),
        E("calling_line_id_first_name", "callingLineIdFirstName", str, is_required=True),
        E("calling_line_id_last_name", "callingLineIdLastName", str, is_required=True),
        E("virtual_on_net_call_type_name", "virtualOnNetCallTypeName", str, is_required=True),
    )

    extension: str = Field(type=str, required=True, mutable=False)
    first_name: str = Field(type=str, required=True, mutable=False)
    last_name: str = Field(type=str, required=True, mutable=False)
    calling_line_id_first_name: str = Field(type=str, required=True, mutable=False)
    calling_line_id_last_name: str = Field(type=str, required=True, mutable=False)
    virtual_on_net_call_type_name: str = Field(type=str, required=True, mutable=False)


class GroupVoiceMessagingGroupGetPasscodeRulesResponse(OCIResponse):
    """
    Response to ``GroupVoiceMessagingGroupGetPasscodeRulesRequest()``.

    Contains the group's voice portal passcode rules setting.

    Replaced By: ``GroupPortalPasscodeRulesGetResponse()``

    Attributes:
        use_rule_level: useRuleLevel
        disallow_repeated_digits: disallowRepeatedDigits
        disallow_user_number: disallowUserNumber
        disallow_reversed_user_number: disallowReversedUserNumber
        disallow_old_passcode: disallowOldPasscode
        disallow_reversed_old_passcode: disallowReversedOldPasscode
        min_code_length: minCodeLength
        max_code_length: maxCodeLength
        disable_login_after_max_failed_login_attempts:
            disableLoginAfterMaxFailedLoginAttempts
        max_failed_login_attempts: maxFailedLoginAttempts
        expire_password: expirePassword
        passcode_expires_days: passcodeExpiresDays
        send_login_disabled_notify_email: sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address: loginDisabledNotifyEmailAddress
    """

    _ELEMENTS = (
        E("use_rule_level", "useRuleLevel", str, is_required=True),
        E("disallow_repeated_digits", "disallowRepeatedDigits", bool, is_required=True),
        E("disallow_user_number", "disallowUserNumber", bool, is_required=True),
        E(
            "disallow_reversed_user_number", "disallowReversedUserNumber", bool,
            is_required=True,
        ),
        E("disallow_old_passcode", "disallowOldPasscode", bool, is_required=True),
        E(
            "disallow_reversed_old_passcode", "disallowReversedOldPasscode", bool,
            is_required=True,
        ),
        E("min_code_length", "minCodeLength", int, is_required=True),
        E("max_code_length", "maxCodeLength", int, is_required=True),
        E(
            "disable_login_after_max_failed_login_attempts",
            "disableLoginAfterMaxFailedLoginAttempts", bool, is_required=True,
        ),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int),
        E("expire_password", "expirePassword", bool, is_required=True),
        E("passcode_expires_days", "passcodeExpiresDays", int),
        E(
            "send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool,
            is_required=True,
        ),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
    )

    use_rule_level: str = Field(type=str, required=True, mutable=False)
    disallow_repeated_digits: bool = Field(type=bool, required=True, mutable=False)
    disallow_user_number: bool = Field(type=bool, required=True, mutable=False)
    disallow_reversed_user_number: bool = Field(type=bool, required=True, mutable=False)
    disallow_old_passcode: bool = Field(type=bool, required=True, mutable=False)
    disallow_reversed_old_passcode: bool = Field(type=bool, required=True, mutable=False)
    min_code_length: int = Field(type=int, required=True, mutable=False)
    max_code_length: int = Field(type=int, required=True, mutable=False)
    disable_login_after_max_failed_login_attempts: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_failed_login_attempts: int = Field(type=int, required=False, mutable=False)
    expire_password: bool = Field(type=bool, required=True, mutable=False)
    passcode_expires_days: int = Field(type=int, required=False, mutable=False)
    send_login_disabled_notify_email: bool = Field(type=bool, required=True, mutable=False)
    login_disabled_notify_email_address: str = Field(type=str, required=False, mutable=False)


class GroupVoiceMessagingGroupGetResponse(OCIResponse):
    """
    Response to ``GroupVoiceMessagingGroupGetRequest()``.

    Contains the group's voice messaging settings.

    Attributes:
        use_mail_server_setting: useMailServerSetting
        warn_caller_before_recording_voice_message: warnCallerBeforeRecordingVoiceMessage
        allow_users_configuring_advanced_settings: allowUsersConfiguringAdvancedSettings
        allow_compose_or_forward_message_to_entire_group:
            allowComposeOrForwardMessageToEntireGroup
        mail_server_net_address: mailServerNetAddress
        mail_server_protocol: mailServerProtocol
        real_delete_for_imap: realDeleteForImap
        max_mailbox_length_minutes: maxMailboxLengthMinutes
        does_message_age: doesMessageAge
        hold_period_days: holdPeriodDays
    """

    _ELEMENTS = (
        E("use_mail_server_setting", "useMailServerSetting", str, is_required=True),
        E(
            "warn_caller_before_recording_voice_message",
            "warnCallerBeforeRecordingVoiceMessage", bool, is_required=True,
        ),
        E(
            "allow_users_configuring_advanced_settings",
            "allowUsersConfiguringAdvancedSettings", bool, is_required=True,
        ),
        E(
            "allow_compose_or_forward_message_to_entire_group",
            "allowComposeOrForwardMessageToEntireGroup", bool, is_required=True,
        ),
        E("mail_server_net_address", "mailServerNetAddress", str),
        E("mail_server_protocol", "mailServerProtocol", str, is_required=True),
        E("real_delete_for_imap", "realDeleteForImap", bool, is_required=True),
        E("max_mailbox_length_minutes", "maxMailboxLengthMinutes", int, is_required=True),
        E("does_message_age", "doesMessageAge", bool, is_required=True),
        E("hold_period_days", "holdPeriodDays", int, is_required=True),
    )

    use_mail_server_setting: str = Field(type=str, required=True, mutable=False)
    warn_caller_before_recording_voice_message: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_users_configuring_advanced_settings: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_compose_or_forward_message_to_entire_group: bool = Field(
        type=bool, required=True, mutable=False,
    )
    mail_server_net_address: str = Field(type=str, required=False, mutable=False)
    mail_server_protocol: str = Field(type=str, required=True, mutable=False)
    real_delete_for_imap: bool = Field(type=bool, required=True, mutable=False)
    max_mailbox_length_minutes: int = Field(type=int, required=True, mutable=False)
    does_message_age: bool = Field(type=bool, required=True, mutable=False)
    hold_period_days: int = Field(type=int, required=True, mutable=False)


class GroupVoiceMessagingGroupGetVoicePortalBrandingResponse(OCIResponse):
    """
    Response to the ``GroupVoiceMessagingGroupGetVoicePortalBrandingRequest()``.

    Replaced By: ``GroupVoiceMessagingGroupGetVoicePortalBrandingResponse16()``

    Attributes:
        voice_portal_greeting_selection: voicePortalGreetingSelection
        voice_portal_greeting_file_description: voicePortalGreetingFileDescription
        voice_messaging_greeting_selection: voiceMessagingGreetingSelection
        voice_messaging_greeting_file_description: voiceMessagingGreetingFileDescription
    """

    _ELEMENTS = (
        E(
            "voice_portal_greeting_selection", "voicePortalGreetingSelection", str,
            is_required=True,
        ),
        E(
            "voice_portal_greeting_file_description",
            "voicePortalGreetingFileDescription", str,
        ),
        E(
            "voice_messaging_greeting_selection", "voiceMessagingGreetingSelection", str,
            is_required=True,
        ),
        E(
            "voice_messaging_greeting_file_description",
            "voiceMessagingGreetingFileDescription", str,
        ),
    )

    voice_portal_greeting_selection: str = Field(type=str, required=True, mutable=False)
    voice_portal_greeting_file_description: str = Field(
        type=str, required=False, mutable=False,
    )
    voice_messaging_greeting_selection: str = Field(type=str, required=True, mutable=False)
    voice_messaging_greeting_file_description: str = Field(
        type=str, required=False, mutable=False,
    )


class GroupVoiceMessagingGroupGetVoicePortalBrandingResponse16(OCIResponse):
    """
    Response to the ``GroupVoiceMessagingGroupGetVoicePortalBrandingRequest16()``.


    Attributes:
        voice_portal_greeting_selection: voicePortalGreetingSelection
        voice_portal_greeting_file_description: voicePortalGreetingFileDescription
        voice_portal_greeting_media_type: voicePortalGreetingMediaType
        voice_messaging_greeting_selection: voiceMessagingGreetingSelection
        voice_messaging_greeting_file_description: voiceMessagingGreetingFileDescription
        voice_messaging_greeting_media_type: voiceMessagingGreetingMediaType
    """

    _ELEMENTS = (
        E(
            "voice_portal_greeting_selection", "voicePortalGreetingSelection", str,
            is_required=True,
        ),
        E(
            "voice_portal_greeting_file_description",
            "voicePortalGreetingFileDescription", str,
        ),
        E("voice_portal_greeting_media_type", "voicePortalGreetingMediaType", str),
        E(
            "voice_messaging_greeting_selection", "voiceMessagingGreetingSelection", str,
            is_required=True,
        ),
        E(
            "voice_messaging_greeting_file_description",
            "voiceMessagingGreetingFileDescription", str,
        ),
        E("voice_messaging_greeting_media_type", "voiceMessagingGreetingMediaType", str),
    )

    voice_portal_greeting_selection: str = Field(type=str, required=True, mutable=False)
    voice_portal_greeting_file_description: str = Field(
        type=str, required=False, mutable=False,
    )
    voice_portal_greeting_media_type: str = Field(type=str, required=False, mutable=False)
    voice_messaging_greeting_selection: str = Field(type=str, required=True, mutable=False)
    voice_messaging_greeting_file_description: str = Field(
        type=str, required=False, mutable=False,
    )
    voice_messaging_greeting_media_type: str = Field(type=str, required=False, mutable=False)


class GroupVoiceXmlGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupVoiceXmlGetInstanceListRequest()``.

    Contains a table with column headings: "Service User Id", "Name", "Phone Number",
    "Extension", "Department", "Is Active". The column values for "Is Active" can either
    be true, or false.

    Attributes:
        voice_xml_table: voiceXmlTable
    """

    _ELEMENTS = (
        E(
            "voice_xml_table", "voiceXmlTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    voice_xml_table: "list" = Field(type=list, required=True, mutable=False)


class LoginResponse13mp10(OCIResponse):
    """
    ``LoginRequest13mp10()``/Response13mp10 is 2nd stage of the 2 stage OCI login process.


    Attributes:
        login_type: loginType
        locale: locale
        encoding: encoding
    """

    _ELEMENTS = (
        E("login_type", "loginType", str, is_required=True),
        E("locale", "locale", str, is_required=True),
        E("encoding", "encoding", str, is_required=True),
    )

    login_type: str = Field(type=str, required=True, mutable=False)
    locale: str = Field(type=str, required=True, mutable=False)
    encoding: str = Field(type=str, required=True, mutable=False)


class LoginResponse14sp4(OCIResponse):
    """
    ``LoginRequest14sp4()``/Response14sp4 is 2nd stage of the 2 stage OCI login process.


    Attributes:
        login_type: loginType
        locale: locale
        encoding: encoding
        group_id: groupId
        service_provider_id: serviceProviderId
        is_enterprise: isEnterprise
        password_expires_days: passwordExpiresDays
        user_domain: userDomain
    """

    _ELEMENTS = (
        E("login_type", "loginType", str, is_required=True),
        E("locale", "locale", str, is_required=True),
        E("encoding", "encoding", str, is_required=True),
        E("group_id", "groupId", str),
        E("service_provider_id", "serviceProviderId", str),
        E("is_enterprise", "isEnterprise", bool, is_required=True),
        E("password_expires_days", "passwordExpiresDays", int),
        E("user_domain", "userDomain", str, is_required=True),
    )

    login_type: str = Field(type=str, required=True, mutable=False)
    locale: str = Field(type=str, required=True, mutable=False)
    encoding: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=False, mutable=False)
    service_provider_id: str = Field(type=str, required=False, mutable=False)
    is_enterprise: bool = Field(type=bool, required=True, mutable=False)
    password_expires_days: int = Field(type=int, required=False, mutable=False)
    user_domain: str = Field(type=str, required=True, mutable=False)


class PrimaryInfoGetResponse(OCIResponse):
    """
    Information about the primary server in the high-availablity cluster.

    For optimization, we only get the hostname and addresses for primary if they are
    explicitly requested or if the current server is not the primary.

    Attributes:
        is_primary: isPrimary
        hostname_for_primary: hostnameForPrimary
        address_for_primary: addressForPrimary
        private_address_for_primary: privateAddressForPrimary
    """

    _ELEMENTS = (
        E("is_primary", "isPrimary", bool, is_required=True),
        E("hostname_for_primary", "hostnameForPrimary", str),
        E("address_for_primary", "addressForPrimary", str, is_array=True),
        E("private_address_for_primary", "privateAddressForPrimary", str, is_array=True),
    )

    is_primary: bool = Field(type=bool, required=True, mutable=False)
    hostname_for_primary: str = Field(type=str, required=False, mutable=False)
    address_for_primary: "List[str]" = Field(type=list, required=False, mutable=False)
    private_address_for_primary: "List[str]" = Field(type=list, required=False, mutable=False)


class PublicClusterGetFullyQualifiedDomainNameResponse(OCIResponse):
    """
    Response to ``PublicClusterGetFullyQualifiedDomainNameRequest()``.


    Attributes:
        public_cluster_fqdn: publicClusterFQDN
    """

    _ELEMENTS = (
        E("public_cluster_fqdn", "publicClusterFQDN", str),
    )

    public_cluster_fqdn: str = Field(type=str, required=False, mutable=False)


class ServiceProviderAccessDeviceCustomTagGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderAccessDeviceCustomTagGetListRequest()``.

    Contains a table of custom configuration tags managed by the Device Management System
    on a per-device profile basis.  The column headings are: "Tag Name", "Tag Value"

    Attributes:
        device_custom_tags_table: deviceCustomTagsTable
    """

    _ELEMENTS = (
        E(
            "device_custom_tags_table", "deviceCustomTagsTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    device_custom_tags_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderAccessDeviceFileGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderAccessDeviceFileGetListRequest()``.

    Contains a table of device files managed by the Device Management System on a per-
    device profile basis.  The column headings are: "File Type", "File Format", "Is
    Authenticated".

    Replaced By: ``ServiceProviderAccessDeviceFileGetListResponse14sp8()``

    Attributes:
        device_files_table: deviceFilesTable
    """

    _ELEMENTS = (
        E(
            "device_files_table", "deviceFilesTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    device_files_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderAccessDeviceFileGetListResponse14sp8(OCIResponse):
    """
    Response to ``ServiceProviderAccessDeviceFileGetListRequest14sp8()``.

    Contains a table of device files managed by the Device Management System on a per-
    device profile basis.  The column headings are: "File Format", "Is Authenticated",
    "Access URL", "Repository URL", "Template URL", "Extended Capture". The following
    columns are only used in AS data mode: "Extended Capture"

    Attributes:
        device_files_table: deviceFilesTable
    """

    _ELEMENTS = (
        E(
            "device_files_table", "deviceFilesTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    device_files_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderAccessDeviceFileGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderAccessDeviceFileGetRequest()``.

    Replaced By: ``ServiceProviderAccessDeviceFileGetResponse14sp8()``

    Attributes:
        file_source: fileSource
        configuration_file_name: configurationFileName
    """

    _ELEMENTS = (
        E("file_source", "fileSource", str, is_required=True),
        E("configuration_file_name", "configurationFileName", str),
    )

    file_source: str = Field(type=str, required=True, mutable=False)
    configuration_file_name: str = Field(type=str, required=False, mutable=False)


class ServiceProviderAccessDeviceFileGetResponse14sp8(OCIResponse):
    """
    Response to ``ServiceProviderAccessDeviceFileGetRequest14sp8()``.

    Replaced by: ``ServiceProviderAccessDeviceFileGetResponse16sp1()``

    Attributes:
        file_source: fileSource
        configuration_file_name: configurationFileName
    """

    _ELEMENTS = (
        E("file_source", "fileSource", str, is_required=True),
        E("configuration_file_name", "configurationFileName", str),
    )

    file_source: str = Field(type=str, required=True, mutable=False)
    configuration_file_name: str = Field(type=str, required=False, mutable=False)


class ServiceProviderAccessDeviceFileGetResponse16sp1(OCIResponse):
    """
    Response to ``ServiceProviderAccessDeviceFileGetRequest16sp1()``.


    Attributes:
        file_source: fileSource
        configuration_file_name: configurationFileName
        access_url: accessUrl
        repository_url: repositoryUrl
        template_url: templateUrl
    """

    _ELEMENTS = (
        E("file_source", "fileSource", str, is_required=True),
        E("configuration_file_name", "configurationFileName", str),
        E("access_url", "accessUrl", str, is_required=True),
        E("repository_url", "repositoryUrl", str),
        E("template_url", "templateUrl", str),
    )

    file_source: str = Field(type=str, required=True, mutable=False)
    configuration_file_name: str = Field(type=str, required=False, mutable=False)
    access_url: str = Field(type=str, required=True, mutable=False)
    repository_url: str = Field(type=str, required=False, mutable=False)
    template_url: str = Field(type=str, required=False, mutable=False)


class ServiceProviderAccessDeviceFileGetResponse20(OCIResponse):
    """
    Response to ``ServiceProviderAccessDeviceFileGetRequest20()``.


    Attributes:
        file_source: fileSource
        configuration_file_name: configurationFileName
        access_url: accessUrl
        repository_url: repositoryUrl
        template_url: templateUrl
        extended_capture_enabled: extendedCaptureEnabled
        extended_capture_url: extendedCaptureURL
    """

    _ELEMENTS = (
        E("file_source", "fileSource", str, is_required=True),
        E("configuration_file_name", "configurationFileName", str),
        E("access_url", "accessUrl", str, is_required=True),
        E("repository_url", "repositoryUrl", str),
        E("template_url", "templateUrl", str),
        E("extended_capture_enabled", "extendedCaptureEnabled", bool),
        E("extended_capture_url", "extendedCaptureURL", str),
    )

    file_source: str = Field(type=str, required=True, mutable=False)
    configuration_file_name: str = Field(type=str, required=False, mutable=False)
    access_url: str = Field(type=str, required=True, mutable=False)
    repository_url: str = Field(type=str, required=False, mutable=False)
    template_url: str = Field(type=str, required=False, mutable=False)
    extended_capture_enabled: bool = Field(type=bool, required=False, mutable=False)
    extended_capture_url: str = Field(type=str, required=False, mutable=False)


class ServiceProviderAccessDeviceGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderAccessDeviceGetListRequest()``.

    Contains a table of devices configured in the service provider.  The column headings
    are: "Device Name", "Device Type", "Available Ports", "Net Address", "MAC Address",
    "Status", and "Version".

    Attributes:
        access_device_table: accessDeviceTable
    """

    _ELEMENTS = (
        E(
            "access_device_table", "accessDeviceTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    access_device_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderAccessDeviceGetUserListResponse(OCIResponse):
    """
    Response to ``ServiceProviderAccessDeviceGetUserListRequest()``.

    The column headings for the deviceUserTable are: "Line/Port", "Last Name", "First
    Name", "Phone Number", "Group Id", "User Id", "User Type", "Endpoint Type", "Primary
    Line/Port", "Order", "Extension", "Department", "Email Address", "Private Identity".
    In IMS mode, the table will contain a row for each TEL-URI in the Phone Number column.
    In standalone mode, rows for the alternate numbers are not included.  The User Type
    column contains one of the enumerated UserType values.  The Endpoint Type column
    contains one of the enumerated EndpointType values.  The Private Identity column is
    empty is AS mode.

    Attributes:
        device_user_table: deviceUserTable
    """

    _ELEMENTS = (
        E(
            "device_user_table", "deviceUserTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    device_user_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderAdminGetListResponse14(OCIResponse):
    """
    Response to ``ServiceProviderAdminGetListRequest14()``.

    Contains a 5 column table with column headings "Administrator ID", "Last Name", "First
    Name", "Administrator Type", "Language".

    Attributes:
        service_provider_admin_table: serviceProviderAdminTable
    """

    _ELEMENTS = (
        E(
            "service_provider_admin_table", "serviceProviderAdminTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    service_provider_admin_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderAdminGetPolicyResponse14(OCIResponse):
    """
    Response to ``ServiceProviderAdminGetPolicyRequest14()``.

    Contains the policy settings for the service provider administrator.  The
    networkPolicyAccess is returned only for the enterprise administrator.

    Attributes:
        profile_access: profileAccess
        group_access: groupAccess
        user_access: userAccess
        admin_access: adminAccess
        department_access: departmentAccess
        access_device_access: accessDeviceAccess
        phone_number_extension_access: phoneNumberExtensionAccess
        service_access: serviceAccess
        service_pack_access: servicePackAccess
        web_branding_access: webBrandingAccess
        network_policy_access: networkPolicyAccess
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("group_access", "groupAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("service_pack_access", "servicePackAccess", str, is_required=True),
        E("web_branding_access", "webBrandingAccess", str, is_required=True),
        E("network_policy_access", "networkPolicyAccess", str),
    )

    profile_access: str = Field(type=str, required=True, mutable=False)
    group_access: str = Field(type=str, required=True, mutable=False)
    user_access: str = Field(type=str, required=True, mutable=False)
    admin_access: str = Field(type=str, required=True, mutable=False)
    department_access: str = Field(type=str, required=True, mutable=False)
    access_device_access: str = Field(type=str, required=True, mutable=False)
    phone_number_extension_access: str = Field(type=str, required=True, mutable=False)
    service_access: str = Field(type=str, required=True, mutable=False)
    service_pack_access: str = Field(type=str, required=True, mutable=False)
    web_branding_access: str = Field(type=str, required=True, mutable=False)
    network_policy_access: str = Field(type=str, required=False, mutable=False)


class ServiceProviderAdminGetPolicyResponse16sp1(OCIResponse):
    """
    Response to ``ServiceProviderAdminGetPolicyRequest16sp1()``.

    Contains the policy settings for the service provider administrator.  The
    networkPolicyAccess is returned only for the enterprise administrator.  Replaced by:
    ``ServiceProviderAdminGetPolicyResponse17()``

    Attributes:
        profile_access: profileAccess
        group_access: groupAccess
        user_access: userAccess
        admin_access: adminAccess
        department_access: departmentAccess
        access_device_access: accessDeviceAccess
        phone_number_extension_access: phoneNumberExtensionAccess
        service_access: serviceAccess
        service_pack_access: servicePackAccess
        session_admission_control_access: sessionAdmissionControlAccess
        web_branding_access: webBrandingAccess
        network_policy_access: networkPolicyAccess
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("group_access", "groupAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("service_pack_access", "servicePackAccess", str, is_required=True),
        E(
            "session_admission_control_access", "sessionAdmissionControlAccess", str,
            is_required=True,
        ),
        E("web_branding_access", "webBrandingAccess", str, is_required=True),
        E("network_policy_access", "networkPolicyAccess", str),
    )

    profile_access: str = Field(type=str, required=True, mutable=False)
    group_access: str = Field(type=str, required=True, mutable=False)
    user_access: str = Field(type=str, required=True, mutable=False)
    admin_access: str = Field(type=str, required=True, mutable=False)
    department_access: str = Field(type=str, required=True, mutable=False)
    access_device_access: str = Field(type=str, required=True, mutable=False)
    phone_number_extension_access: str = Field(type=str, required=True, mutable=False)
    service_access: str = Field(type=str, required=True, mutable=False)
    service_pack_access: str = Field(type=str, required=True, mutable=False)
    session_admission_control_access: str = Field(type=str, required=True, mutable=False)
    web_branding_access: str = Field(type=str, required=True, mutable=False)
    network_policy_access: str = Field(type=str, required=False, mutable=False)


class ServiceProviderAdminGetPolicyResponse16sp2(OCIResponse):
    """
    Response to ``ServiceProviderAdminGetPolicyRequest16sp1()``.

    Response to ``ServiceProviderAdminGetPolicyRequest16sp2()``. Contains the policy
    settings for the service provider administrator.  The networkPolicyAccess is returned
    only for the enterprise administrator.

    Attributes:
        profile_access: profileAccess
        group_access: groupAccess
        user_access: userAccess
        admin_access: adminAccess
        department_access: departmentAccess
        access_device_access: accessDeviceAccess
        phone_number_extension_access: phoneNumberExtensionAccess
        service_access: serviceAccess
        service_pack_access: servicePackAccess
        session_admission_control_access: sessionAdmissionControlAccess
        web_branding_access: webBrandingAccess
        network_policy_access: networkPolicyAccess
        dialable_caller_id_access: dialableCallerIDAccess
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("group_access", "groupAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("service_pack_access", "servicePackAccess", str, is_required=True),
        E(
            "session_admission_control_access", "sessionAdmissionControlAccess", str,
            is_required=True,
        ),
        E("web_branding_access", "webBrandingAccess", str, is_required=True),
        E("network_policy_access", "networkPolicyAccess", str),
        E("dialable_caller_id_access", "dialableCallerIDAccess", str, is_required=True),
    )

    profile_access: str = Field(type=str, required=True, mutable=False)
    group_access: str = Field(type=str, required=True, mutable=False)
    user_access: str = Field(type=str, required=True, mutable=False)
    admin_access: str = Field(type=str, required=True, mutable=False)
    department_access: str = Field(type=str, required=True, mutable=False)
    access_device_access: str = Field(type=str, required=True, mutable=False)
    phone_number_extension_access: str = Field(type=str, required=True, mutable=False)
    service_access: str = Field(type=str, required=True, mutable=False)
    service_pack_access: str = Field(type=str, required=True, mutable=False)
    session_admission_control_access: str = Field(type=str, required=True, mutable=False)
    web_branding_access: str = Field(type=str, required=True, mutable=False)
    network_policy_access: str = Field(type=str, required=False, mutable=False)
    dialable_caller_id_access: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminGetPolicyResponse17(OCIResponse):
    """
    Response to ``ServiceProviderAdminGetPolicyRequest17()``.

    Contains the policy settings for the service provider administrator.  The
    networkPolicyAccess is returned only for the enterprise administrator.

    Attributes:
        profile_access: profileAccess
        group_access: groupAccess
        user_access: userAccess
        admin_access: adminAccess
        department_access: departmentAccess
        access_device_access: accessDeviceAccess
        phone_number_extension_access: phoneNumberExtensionAccess
        calling_line_id_number_access: callingLineIdNumberAccess
        service_access: serviceAccess
        service_pack_access: servicePackAccess
        session_admission_control_access: sessionAdmissionControlAccess
        web_branding_access: webBrandingAccess
        office_zone_access: officeZoneAccess
        network_policy_access: networkPolicyAccess
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("group_access", "groupAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E(
            "calling_line_id_number_access", "callingLineIdNumberAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("service_pack_access", "servicePackAccess", str, is_required=True),
        E(
            "session_admission_control_access", "sessionAdmissionControlAccess", str,
            is_required=True,
        ),
        E("web_branding_access", "webBrandingAccess", str, is_required=True),
        E("office_zone_access", "officeZoneAccess", str, is_required=True),
        E("network_policy_access", "networkPolicyAccess", str),
    )

    profile_access: str = Field(type=str, required=True, mutable=False)
    group_access: str = Field(type=str, required=True, mutable=False)
    user_access: str = Field(type=str, required=True, mutable=False)
    admin_access: str = Field(type=str, required=True, mutable=False)
    department_access: str = Field(type=str, required=True, mutable=False)
    access_device_access: str = Field(type=str, required=True, mutable=False)
    phone_number_extension_access: str = Field(type=str, required=True, mutable=False)
    calling_line_id_number_access: str = Field(type=str, required=True, mutable=False)
    service_access: str = Field(type=str, required=True, mutable=False)
    service_pack_access: str = Field(type=str, required=True, mutable=False)
    session_admission_control_access: str = Field(type=str, required=True, mutable=False)
    web_branding_access: str = Field(type=str, required=True, mutable=False)
    office_zone_access: str = Field(type=str, required=True, mutable=False)
    network_policy_access: str = Field(type=str, required=False, mutable=False)


class ServiceProviderAdminGetPolicyResponse17sp1(OCIResponse):
    """
    Response to ``ServiceProviderAdminGetPolicyRequest17sp1()``.

    Contains the policy settings for the service provider administrator.  The
    networkPolicyAccess is returned only for the enterprise administrator.  The following
    elements are only used in HSS data mode: communicationBarringAccess

    Attributes:
        profile_access: profileAccess
        group_access: groupAccess
        user_access: userAccess
        admin_access: adminAccess
        department_access: departmentAccess
        access_device_access: accessDeviceAccess
        phone_number_extension_access: phoneNumberExtensionAccess
        calling_line_id_number_access: callingLineIdNumberAccess
        service_access: serviceAccess
        service_pack_access: servicePackAccess
        session_admission_control_access: sessionAdmissionControlAccess
        web_branding_access: webBrandingAccess
        office_zone_access: officeZoneAccess
        communication_barring_access: communicationBarringAccess
        network_policy_access: networkPolicyAccess
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("group_access", "groupAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E(
            "calling_line_id_number_access", "callingLineIdNumberAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("service_pack_access", "servicePackAccess", str, is_required=True),
        E(
            "session_admission_control_access", "sessionAdmissionControlAccess", str,
            is_required=True,
        ),
        E("web_branding_access", "webBrandingAccess", str, is_required=True),
        E("office_zone_access", "officeZoneAccess", str, is_required=True),
        E(
            "communication_barring_access", "communicationBarringAccess", str,
            is_required=True,
        ),
        E("network_policy_access", "networkPolicyAccess", str),
    )

    profile_access: str = Field(type=str, required=True, mutable=False)
    group_access: str = Field(type=str, required=True, mutable=False)
    user_access: str = Field(type=str, required=True, mutable=False)
    admin_access: str = Field(type=str, required=True, mutable=False)
    department_access: str = Field(type=str, required=True, mutable=False)
    access_device_access: str = Field(type=str, required=True, mutable=False)
    phone_number_extension_access: str = Field(type=str, required=True, mutable=False)
    calling_line_id_number_access: str = Field(type=str, required=True, mutable=False)
    service_access: str = Field(type=str, required=True, mutable=False)
    service_pack_access: str = Field(type=str, required=True, mutable=False)
    session_admission_control_access: str = Field(type=str, required=True, mutable=False)
    web_branding_access: str = Field(type=str, required=True, mutable=False)
    office_zone_access: str = Field(type=str, required=True, mutable=False)
    communication_barring_access: str = Field(type=str, required=True, mutable=False)
    network_policy_access: str = Field(type=str, required=False, mutable=False)


class ServiceProviderAdminGetPolicyResponse17sp3(OCIResponse):
    """
    Response to ``ServiceProviderAdminGetPolicyRequest17sp3()``.

    Contains the policy settings for the service provider administrator.  The
    networkPolicyAccess is returned only for the enterprise administrator.  The following
    elements are only used in AS data mode: dialableCallerIDAccess The following elements
    are only used in HSS data mode: communicationBarringAccess

    Attributes:
        profile_access: profileAccess
        group_access: groupAccess
        user_access: userAccess
        admin_access: adminAccess
        department_access: departmentAccess
        access_device_access: accessDeviceAccess
        phone_number_extension_access: phoneNumberExtensionAccess
        calling_line_id_number_access: callingLineIdNumberAccess
        service_access: serviceAccess
        service_pack_access: servicePackAccess
        session_admission_control_access: sessionAdmissionControlAccess
        web_branding_access: webBrandingAccess
        office_zone_access: officeZoneAccess
        communication_barring_access: communicationBarringAccess
        network_policy_access: networkPolicyAccess
        dialable_caller_id_access: dialableCallerIDAccess
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("group_access", "groupAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E(
            "calling_line_id_number_access", "callingLineIdNumberAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("service_pack_access", "servicePackAccess", str, is_required=True),
        E(
            "session_admission_control_access", "sessionAdmissionControlAccess", str,
            is_required=True,
        ),
        E("web_branding_access", "webBrandingAccess", str, is_required=True),
        E("office_zone_access", "officeZoneAccess", str, is_required=True),
        E(
            "communication_barring_access", "communicationBarringAccess", str,
            is_required=True,
        ),
        E("network_policy_access", "networkPolicyAccess", str),
        E("dialable_caller_id_access", "dialableCallerIDAccess", str, is_required=True),
    )

    profile_access: str = Field(type=str, required=True, mutable=False)
    group_access: str = Field(type=str, required=True, mutable=False)
    user_access: str = Field(type=str, required=True, mutable=False)
    admin_access: str = Field(type=str, required=True, mutable=False)
    department_access: str = Field(type=str, required=True, mutable=False)
    access_device_access: str = Field(type=str, required=True, mutable=False)
    phone_number_extension_access: str = Field(type=str, required=True, mutable=False)
    calling_line_id_number_access: str = Field(type=str, required=True, mutable=False)
    service_access: str = Field(type=str, required=True, mutable=False)
    service_pack_access: str = Field(type=str, required=True, mutable=False)
    session_admission_control_access: str = Field(type=str, required=True, mutable=False)
    web_branding_access: str = Field(type=str, required=True, mutable=False)
    office_zone_access: str = Field(type=str, required=True, mutable=False)
    communication_barring_access: str = Field(type=str, required=True, mutable=False)
    network_policy_access: str = Field(type=str, required=False, mutable=False)
    dialable_caller_id_access: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminGetPolicyResponse18(OCIResponse):
    """
    Response to ``ServiceProviderAdminGetPolicyRequest18()``.

    Contains the policy settings for the service provider administrator.  The
    networkPolicyAccess and numberActivationAccess are returned only for the enterprise
    administrator.  The following elements are only used in AS data mode:
    dialableCallerIDAccess

    Attributes:
        profile_access: profileAccess
        group_access: groupAccess
        user_access: userAccess
        admin_access: adminAccess
        department_access: departmentAccess
        access_device_access: accessDeviceAccess
        phone_number_extension_access: phoneNumberExtensionAccess
        calling_line_id_number_access: callingLineIdNumberAccess
        service_access: serviceAccess
        service_pack_access: servicePackAccess
        session_admission_control_access: sessionAdmissionControlAccess
        web_branding_access: webBrandingAccess
        office_zone_access: officeZoneAccess
        communication_barring_access: communicationBarringAccess
        network_policy_access: networkPolicyAccess
        number_activation_access: numberActivationAccess
        dialable_caller_id_access: dialableCallerIDAccess
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("group_access", "groupAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E(
            "calling_line_id_number_access", "callingLineIdNumberAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("service_pack_access", "servicePackAccess", str, is_required=True),
        E(
            "session_admission_control_access", "sessionAdmissionControlAccess", str,
            is_required=True,
        ),
        E("web_branding_access", "webBrandingAccess", str, is_required=True),
        E("office_zone_access", "officeZoneAccess", str, is_required=True),
        E(
            "communication_barring_access", "communicationBarringAccess", str,
            is_required=True,
        ),
        E("network_policy_access", "networkPolicyAccess", str),
        E("number_activation_access", "numberActivationAccess", str),
        E("dialable_caller_id_access", "dialableCallerIDAccess", str, is_required=True),
    )

    profile_access: str = Field(type=str, required=True, mutable=False)
    group_access: str = Field(type=str, required=True, mutable=False)
    user_access: str = Field(type=str, required=True, mutable=False)
    admin_access: str = Field(type=str, required=True, mutable=False)
    department_access: str = Field(type=str, required=True, mutable=False)
    access_device_access: str = Field(type=str, required=True, mutable=False)
    phone_number_extension_access: str = Field(type=str, required=True, mutable=False)
    calling_line_id_number_access: str = Field(type=str, required=True, mutable=False)
    service_access: str = Field(type=str, required=True, mutable=False)
    service_pack_access: str = Field(type=str, required=True, mutable=False)
    session_admission_control_access: str = Field(type=str, required=True, mutable=False)
    web_branding_access: str = Field(type=str, required=True, mutable=False)
    office_zone_access: str = Field(type=str, required=True, mutable=False)
    communication_barring_access: str = Field(type=str, required=True, mutable=False)
    network_policy_access: str = Field(type=str, required=False, mutable=False)
    number_activation_access: str = Field(type=str, required=False, mutable=False)
    dialable_caller_id_access: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminGetPolicyResponse20(OCIResponse):
    """
    Response to ``ServiceProviderAdminGetPolicyRequest20()``.

    Contains the policy settings for the service provider administrator.  The
    networkPolicyAccess and numberActivationAccess are returned only for the enterprise
    administrator.  The following elements are only used in AS data mode:
    dialableCallerIDAccess verifyTranslationAndRoutingAccess

    Attributes:
        profile_access: profileAccess
        group_access: groupAccess
        user_access: userAccess
        admin_access: adminAccess
        department_access: departmentAccess
        access_device_access: accessDeviceAccess
        phone_number_extension_access: phoneNumberExtensionAccess
        calling_line_id_number_access: callingLineIdNumberAccess
        service_access: serviceAccess
        service_pack_access: servicePackAccess
        session_admission_control_access: sessionAdmissionControlAccess
        web_branding_access: webBrandingAccess
        office_zone_access: officeZoneAccess
        communication_barring_access: communicationBarringAccess
        network_policy_access: networkPolicyAccess
        number_activation_access: numberActivationAccess
        dialable_caller_id_access: dialableCallerIDAccess
        verify_translation_and_routing_access: verifyTranslationAndRoutingAccess
    """

    _ELEMENTS = (
        E("profile_access", "profileAccess", str, is_required=True),
        E("group_access", "groupAccess", str, is_required=True),
        E("user_access", "userAccess", str, is_required=True),
        E("admin_access", "adminAccess", str, is_required=True),
        E("department_access", "departmentAccess", str, is_required=True),
        E("access_device_access", "accessDeviceAccess", str, is_required=True),
        E(
            "phone_number_extension_access", "phoneNumberExtensionAccess", str,
            is_required=True,
        ),
        E(
            "calling_line_id_number_access", "callingLineIdNumberAccess", str,
            is_required=True,
        ),
        E("service_access", "serviceAccess", str, is_required=True),
        E("service_pack_access", "servicePackAccess", str, is_required=True),
        E(
            "session_admission_control_access", "sessionAdmissionControlAccess", str,
            is_required=True,
        ),
        E("web_branding_access", "webBrandingAccess", str, is_required=True),
        E("office_zone_access", "officeZoneAccess", str, is_required=True),
        E(
            "communication_barring_access", "communicationBarringAccess", str,
            is_required=True,
        ),
        E("network_policy_access", "networkPolicyAccess", str),
        E("number_activation_access", "numberActivationAccess", str),
        E("dialable_caller_id_access", "dialableCallerIDAccess", str, is_required=True),
        E(
            "verify_translation_and_routing_access", "verifyTranslationAndRoutingAccess",
            str, is_required=True,
        ),
    )

    profile_access: str = Field(type=str, required=True, mutable=False)
    group_access: str = Field(type=str, required=True, mutable=False)
    user_access: str = Field(type=str, required=True, mutable=False)
    admin_access: str = Field(type=str, required=True, mutable=False)
    department_access: str = Field(type=str, required=True, mutable=False)
    access_device_access: str = Field(type=str, required=True, mutable=False)
    phone_number_extension_access: str = Field(type=str, required=True, mutable=False)
    calling_line_id_number_access: str = Field(type=str, required=True, mutable=False)
    service_access: str = Field(type=str, required=True, mutable=False)
    service_pack_access: str = Field(type=str, required=True, mutable=False)
    session_admission_control_access: str = Field(type=str, required=True, mutable=False)
    web_branding_access: str = Field(type=str, required=True, mutable=False)
    office_zone_access: str = Field(type=str, required=True, mutable=False)
    communication_barring_access: str = Field(type=str, required=True, mutable=False)
    network_policy_access: str = Field(type=str, required=False, mutable=False)
    number_activation_access: str = Field(type=str, required=False, mutable=False)
    dialable_caller_id_access: str = Field(type=str, required=True, mutable=False)
    verify_translation_and_routing_access: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminGetResponse14(OCIResponse):
    """
    Response to the ``ServiceProviderAdminGetRequest14()``.

    The response contains the service provider administrators profile information.

    Attributes:
        service_provider_id: serviceProviderId
        first_name: firstName
        last_name: lastName
        language: language
        administrator_type: administratorType
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("first_name", "firstName", str),
        E("last_name", "lastName", str),
        E("language", "language", str, is_required=True),
        E("administrator_type", "administratorType", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    first_name: str = Field(type=str, required=False, mutable=False)
    last_name: str = Field(type=str, required=False, mutable=False)
    language: str = Field(type=str, required=True, mutable=False)
    administrator_type: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAdviceOfChargeGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderAdviceOfChargeGetRequest()``.

    Contains a list of Advice of Charge service provider parameters.

    Attributes:
        use_sp_level_ao_c_settings: useSPLevelAoCSettings
        delay_between_notification_seconds: delayBetweenNotificationSeconds
    """

    _ELEMENTS = (
        E("use_sp_level_ao_c_settings", "useSPLevelAoCSettings", bool, is_required=True),
        E(
            "delay_between_notification_seconds", "delayBetweenNotificationSeconds", int,
            is_required=True,
        ),
    )

    use_sp_level_ao_c_settings: bool = Field(type=bool, required=True, mutable=False)
    delay_between_notification_seconds: int = Field(type=int, required=True, mutable=False)


class ServiceProviderAnswerConfirmationGetResponse(OCIResponse):
    """
    Response to the ``ServiceProviderAnswerConfirmationGetRequest()``.

    Replaced By: ``ServiceProviderAnswerConfirmationGetResponse16()``

    Attributes:
        announcement_message_selection: announcementMessageSelection
        confirmation_message_audio_file_description:
            confirmationMessageAudioFileDescription
        confirmation_timout_seconds: confirmationTimoutSeconds
    """

    _ELEMENTS = (
        E(
            "announcement_message_selection", "announcementMessageSelection", str,
            is_required=True,
        ),
        E(
            "confirmation_message_audio_file_description",
            "confirmationMessageAudioFileDescription", str,
        ),
        E("confirmation_timout_seconds", "confirmationTimoutSeconds", int, is_required=True),
    )

    announcement_message_selection: str = Field(type=str, required=True, mutable=False)
    confirmation_message_audio_file_description: str = Field(
        type=str, required=False, mutable=False,
    )
    confirmation_timout_seconds: int = Field(type=int, required=True, mutable=False)


class ServiceProviderAnswerConfirmationGetResponse16(OCIResponse):
    """
    Response to the ``ServiceProviderAnswerConfirmationGetRequest16()``.


    Attributes:
        announcement_message_selection: announcementMessageSelection
        confirmation_message_audio_file_description:
            confirmationMessageAudioFileDescription
        confirmation_message_media_type: confirmationMessageMediaType
        confirmation_timout_seconds: confirmationTimoutSeconds
    """

    _ELEMENTS = (
        E(
            "announcement_message_selection", "announcementMessageSelection", str,
            is_required=True,
        ),
        E(
            "confirmation_message_audio_file_description",
            "confirmationMessageAudioFileDescription", str,
        ),
        E("confirmation_message_media_type", "confirmationMessageMediaType", str),
        E("confirmation_timout_seconds", "confirmationTimoutSeconds", int, is_required=True),
    )

    announcement_message_selection: str = Field(type=str, required=True, mutable=False)
    confirmation_message_audio_file_description: str = Field(
        type=str, required=False, mutable=False,
    )
    confirmation_message_media_type: str = Field(type=str, required=False, mutable=False)
    confirmation_timout_seconds: int = Field(type=int, required=True, mutable=False)


class ServiceProviderApplicationServerSetGetResponse(OCIResponse):
    """
    Response to the ``ServiceProviderApplicationServerSetGetRequest()``.

    The response contains the service provider or enterprise's Application Server set
    information.

    Attributes:
        application_server_set_name: applicationServerSetName
    """

    _ELEMENTS = (
        E("application_server_set_name", "applicationServerSetName", str),
    )

    application_server_set_name: str = Field(type=str, required=False, mutable=False)


class ServiceProviderBroadWorksCommunicatorGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderBroadWorksCommunicatorGetRequest()``.


    Attributes:
        configuration_server_url: configurationServerURL
    """

    _ELEMENTS = (
        E("configuration_server_url", "configurationServerURL", str),
    )

    configuration_server_url: str = Field(type=str, required=False, mutable=False)


class ServiceProviderBroadWorksMobilityGetResponse(OCIResponse):
    """
    The response to a ``ServiceProviderBroadWorksMobilityGetRequest()``.


    Attributes:
        use_setting_level: useSettingLevel
        enable_location_services: enableLocationServices
        enable_msrn_lookup: enableMSRNLookup
        enable_mobile_state_checking: enableMobileStateChecking
        deny_call_originations: denyCallOriginations
        deny_call_terminations: denyCallTerminations
    """

    _ELEMENTS = (
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("enable_location_services", "enableLocationServices", bool, is_required=True),
        E("enable_msrn_lookup", "enableMSRNLookup", bool, is_required=True),
        E(
            "enable_mobile_state_checking", "enableMobileStateChecking", bool,
            is_required=True,
        ),
        E("deny_call_originations", "denyCallOriginations", bool, is_required=True),
        E("deny_call_terminations", "denyCallTerminations", bool, is_required=True),
    )

    use_setting_level: str = Field(type=str, required=True, mutable=False)
    enable_location_services: bool = Field(type=bool, required=True, mutable=False)
    enable_msrn_lookup: bool = Field(type=bool, required=True, mutable=False)
    enable_mobile_state_checking: bool = Field(type=bool, required=True, mutable=False)
    deny_call_originations: bool = Field(type=bool, required=True, mutable=False)
    deny_call_terminations: bool = Field(type=bool, required=True, mutable=False)


class ServiceProviderBroadWorksMobilityGetResponse19sp1(OCIResponse):
    """
    The response to a ``ServiceProviderBroadWorksMobilityGetRequest19sp1()``.


    Attributes:
        use_setting_level: useSettingLevel
        enable_location_services: enableLocationServices
        enable_msrn_lookup: enableMSRNLookup
        enable_mobile_state_checking: enableMobileStateChecking
        deny_call_originations: denyCallOriginations
        deny_call_terminations: denyCallTerminations
        enable_announcement_suppression: enableAnnouncementSuppression
    """

    _ELEMENTS = (
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("enable_location_services", "enableLocationServices", bool, is_required=True),
        E("enable_msrn_lookup", "enableMSRNLookup", bool, is_required=True),
        E(
            "enable_mobile_state_checking", "enableMobileStateChecking", bool,
            is_required=True,
        ),
        E("deny_call_originations", "denyCallOriginations", bool, is_required=True),
        E("deny_call_terminations", "denyCallTerminations", bool, is_required=True),
        E(
            "enable_announcement_suppression", "enableAnnouncementSuppression", bool,
            is_required=True,
        ),
    )

    use_setting_level: str = Field(type=str, required=True, mutable=False)
    enable_location_services: bool = Field(type=bool, required=True, mutable=False)
    enable_msrn_lookup: bool = Field(type=bool, required=True, mutable=False)
    enable_mobile_state_checking: bool = Field(type=bool, required=True, mutable=False)
    deny_call_originations: bool = Field(type=bool, required=True, mutable=False)
    deny_call_terminations: bool = Field(type=bool, required=True, mutable=False)
    enable_announcement_suppression: bool = Field(type=bool, required=True, mutable=False)


class ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListResponse(OCIResponse):
    """
    Response to
    ``ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest()``.

    Contains a list of available Mobile Subscriber Directory Numbers not yet assigned to
    any group.

    Attributes:
        available_mobile_subscriber_directory_number:
            availableMobileSubscriberDirectoryNumber
    """

    _ELEMENTS = (
        E(
            "available_mobile_subscriber_directory_number",
            "availableMobileSubscriberDirectoryNumber", str, is_array=True,
        ),
    )

    available_mobile_subscriber_directory_number: "List[str]" = Field(
        type=list, required=False, mutable=False,
    )


class ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberGetSummaryListResponse(OCIResponse):
    """
    Response to
    ``ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberGetSummaryListRequest()``.

    The column headings are "Phone Number", "Group Id" and "Mobile Network".

    Attributes:
        mobile_subscriber_directory_numbers_summary_table:
            mobileSubscriberDirectoryNumbersSummaryTable
    """

    _ELEMENTS = (
        E(
            "mobile_subscriber_directory_numbers_summary_table",
            "mobileSubscriberDirectoryNumbersSummaryTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    mobile_subscriber_directory_numbers_summary_table: "list" = Field(
        type=list, required=True, mutable=False,
    )


class ServiceProviderCallProcessingGetPolicyResponse14(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest14()``.


    Attributes:
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        enforce_enterprise_calling_line_identity_restriction:
            enforceEnterpriseCallingLineIdentityRestriction
        use_setting_level: useSettingLevel
        conference_uri: conferenceURI
    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("conference_uri", "conferenceURI", str),
    )

    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enforce_enterprise_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_setting_level: str = Field(type=str, required=True, mutable=False)
    conference_uri: str = Field(type=str, required=False, mutable=False)


class ServiceProviderCallProcessingGetPolicyResponse14sp1(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest14sp1()``.


    Attributes:
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        enforce_enterprise_calling_line_identity_restriction:
            enforceEnterpriseCallingLineIdentityRestriction
        use_setting_level: useSettingLevel
        conference_uri: conferenceURI
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("conference_uri", "conferenceURI", str),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
    )

    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enforce_enterprise_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_setting_level: str = Field(type=str, required=True, mutable=False)
    conference_uri: str = Field(type=str, required=False, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )


class ServiceProviderCallProcessingGetPolicyResponse14sp4(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest14sp4()``.

    Replaced By : ``ServiceProviderCallProcessingGetPolicyResponse15()``

    Attributes:
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_external_calls_via_private_dialing_plan:
            overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        enforce_enterprise_calling_line_identity_restriction:
            enforceEnterpriseCallingLineIdentityRestriction
        use_setting_level: useSettingLevel
        conference_uri: conferenceURI
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_external_calls_via_private_dialing_plan",
            "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan", bool,
            is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("conference_uri", "conferenceURI", str),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
    )

    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    override_clid_restriction_for_external_calls_via_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(type=bool, required=True, mutable=False)
    enforce_enterprise_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_setting_level: str = Field(type=str, required=True, mutable=False)
    conference_uri: str = Field(type=str, required=False, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )


class ServiceProviderCallProcessingGetPolicyResponse14sp7(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest14sp7()``.


    Attributes:
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_external_calls_via_private_dialing_plan:
            overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        enforce_enterprise_calling_line_identity_restriction:
            enforceEnterpriseCallingLineIdentityRestriction
        use_setting_level: useSettingLevel
        conference_uri: conferenceURI
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
        clid_policy: clidPolicy
        emergency_clid_policy: emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity:
            allowAlternateNumbersForRedirectingIdentity
    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_external_calls_via_private_dialing_plan",
            "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan", bool,
            is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("conference_uri", "conferenceURI", str),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
    )

    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    override_clid_restriction_for_external_calls_via_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(type=bool, required=True, mutable=False)
    enforce_enterprise_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_setting_level: str = Field(type=str, required=True, mutable=False)
    conference_uri: str = Field(type=str, required=False, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )
    clid_policy: str = Field(type=str, required=True, mutable=False)
    emergency_clid_policy: str = Field(type=str, required=True, mutable=False)
    allow_alternate_numbers_for_redirecting_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )


class ServiceProviderCallProcessingGetPolicyResponse15(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest15()``.


    Attributes:
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category:
            overrideCLIDRestrictionForPrivateCallCategory
        use_enterprise_clid_for_private_call_category:
            useEnterpriseCLIDForPrivateCallCategory
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        enforce_enterprise_calling_line_identity_restriction:
            enforceEnterpriseCallingLineIdentityRestriction
        use_setting_level: useSettingLevel
        conference_uri: conferenceURI
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("conference_uri", "conferenceURI", str),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
    )

    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    override_clid_restriction_for_private_call_category: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_enterprise_clid_for_private_call_category: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(type=bool, required=True, mutable=False)
    enforce_enterprise_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_setting_level: str = Field(type=str, required=True, mutable=False)
    conference_uri: str = Field(type=str, required=False, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )


class ServiceProviderCallProcessingGetPolicyResponse15sp2(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest15sp2()``.


    Attributes:
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category:
            overrideCLIDRestrictionForPrivateCallCategory
        use_enterprise_clid_for_private_call_category:
            useEnterpriseCLIDForPrivateCallCategory
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        enforce_enterprise_calling_line_identity_restriction:
            enforceEnterpriseCallingLineIdentityRestriction
        use_setting_level: useSettingLevel
        conference_uri: conferenceURI
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
        clid_policy: clidPolicy
        emergency_clid_policy: emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity:
            allowAlternateNumbersForRedirectingIdentity
    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("conference_uri", "conferenceURI", str),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
    )

    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    override_clid_restriction_for_private_call_category: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_enterprise_clid_for_private_call_category: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(type=bool, required=True, mutable=False)
    enforce_enterprise_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_setting_level: str = Field(type=str, required=True, mutable=False)
    conference_uri: str = Field(type=str, required=False, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )
    clid_policy: str = Field(type=str, required=True, mutable=False)
    emergency_clid_policy: str = Field(type=str, required=True, mutable=False)
    allow_alternate_numbers_for_redirecting_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )


class ServiceProviderCallProcessingGetPolicyResponse16(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest16()``.


    Attributes:
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category:
            overrideCLIDRestrictionForPrivateCallCategory
        use_enterprise_clid_for_private_call_category:
            useEnterpriseCLIDForPrivateCallCategory
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        enforce_enterprise_calling_line_identity_restriction:
            enforceEnterpriseCallingLineIdentityRestriction
        use_setting_level: useSettingLevel
        conference_uri: conferenceURI
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
        clid_policy: clidPolicy
        emergency_clid_policy: emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity:
            allowAlternateNumbersForRedirectingIdentity
    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("conference_uri", "conferenceURI", str),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
    )

    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    override_clid_restriction_for_private_call_category: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_enterprise_clid_for_private_call_category: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(type=bool, required=True, mutable=False)
    enforce_enterprise_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_setting_level: str = Field(type=str, required=True, mutable=False)
    conference_uri: str = Field(type=str, required=False, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )
    clid_policy: str = Field(type=str, required=True, mutable=False)
    emergency_clid_policy: str = Field(type=str, required=True, mutable=False)
    allow_alternate_numbers_for_redirecting_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )


class ServiceProviderCallProcessingGetPolicyResponse16sp2(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest16sp2()``.


    Attributes:
        use_service_provider_dclid_setting: useServiceProviderDCLIDSetting
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category:
            overrideCLIDRestrictionForPrivateCallCategory
        use_enterprise_clid_for_private_call_category:
            useEnterpriseCLIDForPrivateCallCategory
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        enforce_enterprise_calling_line_identity_restriction:
            enforceEnterpriseCallingLineIdentityRestriction
        use_setting_level: useSettingLevel
        conference_uri: conferenceURI
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
        clid_policy: clidPolicy
        emergency_clid_policy: emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity:
            allowAlternateNumbersForRedirectingIdentity
        enable_dialable_caller_id: enableDialableCallerID
    """

    _ELEMENTS = (
        E(
            "use_service_provider_dclid_setting", "useServiceProviderDCLIDSetting", bool,
            is_required=True,
        ),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("conference_uri", "conferenceURI", str),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool, is_required=True),
    )

    use_service_provider_dclid_setting: bool = Field(type=bool, required=True, mutable=False)
    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    override_clid_restriction_for_private_call_category: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_enterprise_clid_for_private_call_category: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(type=bool, required=True, mutable=False)
    enforce_enterprise_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_setting_level: str = Field(type=str, required=True, mutable=False)
    conference_uri: str = Field(type=str, required=False, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )
    clid_policy: str = Field(type=str, required=True, mutable=False)
    emergency_clid_policy: str = Field(type=str, required=True, mutable=False)
    allow_alternate_numbers_for_redirecting_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_dialable_caller_id: bool = Field(type=bool, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyResponse17(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest17()``.


    Attributes:
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category:
            overrideCLIDRestrictionForPrivateCallCategory
        use_enterprise_clid_for_private_call_category:
            useEnterpriseCLIDForPrivateCallCategory
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        enforce_enterprise_calling_line_identity_restriction:
            enforceEnterpriseCallingLineIdentityRestriction
        use_setting_level: useSettingLevel
        conference_uri: conferenceURI
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
        clid_policy: clidPolicy
        emergency_clid_policy: emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity:
            allowAlternateNumbersForRedirectingIdentity
        block_calling_name_for_external_calls: blockCallingNameForExternalCalls
    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("conference_uri", "conferenceURI", str),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E(
            "block_calling_name_for_external_calls", "blockCallingNameForExternalCalls",
            bool, is_required=True,
        ),
    )

    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    override_clid_restriction_for_private_call_category: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_enterprise_clid_for_private_call_category: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(type=bool, required=True, mutable=False)
    enforce_enterprise_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_setting_level: str = Field(type=str, required=True, mutable=False)
    conference_uri: str = Field(type=str, required=False, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )
    clid_policy: str = Field(type=str, required=True, mutable=False)
    emergency_clid_policy: str = Field(type=str, required=True, mutable=False)
    allow_alternate_numbers_for_redirecting_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )
    block_calling_name_for_external_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )


class ServiceProviderCallProcessingGetPolicyResponse17sp3(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest17sp3()``.

    The following elements are only used in AS data mode: useServiceProviderDCLIDSetting
    enableDialableCallerID

    Attributes:
        use_service_provider_dclid_setting: useServiceProviderDCLIDSetting
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category:
            overrideCLIDRestrictionForPrivateCallCategory
        use_enterprise_clid_for_private_call_category:
            useEnterpriseCLIDForPrivateCallCategory
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        enforce_enterprise_calling_line_identity_restriction:
            enforceEnterpriseCallingLineIdentityRestriction
        use_setting_level: useSettingLevel
        conference_uri: conferenceURI
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
        clid_policy: clidPolicy
        emergency_clid_policy: emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity:
            allowAlternateNumbersForRedirectingIdentity
        block_calling_name_for_external_calls: blockCallingNameForExternalCalls
        enable_dialable_caller_id: enableDialableCallerID
    """

    _ELEMENTS = (
        E(
            "use_service_provider_dclid_setting", "useServiceProviderDCLIDSetting", bool,
            is_required=True,
        ),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("conference_uri", "conferenceURI", str),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E(
            "block_calling_name_for_external_calls", "blockCallingNameForExternalCalls",
            bool, is_required=True,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool, is_required=True),
    )

    use_service_provider_dclid_setting: bool = Field(type=bool, required=True, mutable=False)
    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    override_clid_restriction_for_private_call_category: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_enterprise_clid_for_private_call_category: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(type=bool, required=True, mutable=False)
    enforce_enterprise_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_setting_level: str = Field(type=str, required=True, mutable=False)
    conference_uri: str = Field(type=str, required=False, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )
    clid_policy: str = Field(type=str, required=True, mutable=False)
    emergency_clid_policy: str = Field(type=str, required=True, mutable=False)
    allow_alternate_numbers_for_redirecting_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )
    block_calling_name_for_external_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_dialable_caller_id: bool = Field(type=bool, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyResponse17sp4(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest17sp4()``.

    The following elements are only used in AS data mode: useServiceProviderDCLIDSetting
    enableDialableCallerID allowConfigurableCLIDForRedirectingIdentity

    Attributes:
        use_service_provider_dclid_setting: useServiceProviderDCLIDSetting
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category:
            overrideCLIDRestrictionForPrivateCallCategory
        use_enterprise_clid_for_private_call_category:
            useEnterpriseCLIDForPrivateCallCategory
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        enforce_enterprise_calling_line_identity_restriction:
            enforceEnterpriseCallingLineIdentityRestriction
        use_setting_level: useSettingLevel
        conference_uri: conferenceURI
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
        clid_policy: clidPolicy
        emergency_clid_policy: emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity:
            allowAlternateNumbersForRedirectingIdentity
        block_calling_name_for_external_calls: blockCallingNameForExternalCalls
        enable_dialable_caller_id: enableDialableCallerID
        allow_configurable_clid_for_redirecting_identity:
            allowConfigurableCLIDForRedirectingIdentity
    """

    _ELEMENTS = (
        E(
            "use_service_provider_dclid_setting", "useServiceProviderDCLIDSetting", bool,
            is_required=True,
        ),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("conference_uri", "conferenceURI", str),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E(
            "block_calling_name_for_external_calls", "blockCallingNameForExternalCalls",
            bool, is_required=True,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool, is_required=True),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool, is_required=True,
        ),
    )

    use_service_provider_dclid_setting: bool = Field(type=bool, required=True, mutable=False)
    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    override_clid_restriction_for_private_call_category: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_enterprise_clid_for_private_call_category: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(type=bool, required=True, mutable=False)
    enforce_enterprise_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_setting_level: str = Field(type=str, required=True, mutable=False)
    conference_uri: str = Field(type=str, required=False, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )
    clid_policy: str = Field(type=str, required=True, mutable=False)
    emergency_clid_policy: str = Field(type=str, required=True, mutable=False)
    allow_alternate_numbers_for_redirecting_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )
    block_calling_name_for_external_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_dialable_caller_id: bool = Field(type=bool, required=True, mutable=False)
    allow_configurable_clid_for_redirecting_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )


class ServiceProviderCallProcessingGetPolicyResponse18sp1(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest18sp1()``.

    The following elements are only used in AS data mode: useServiceProviderDCLIDSetting
    enableDialableCallerID allowConfigurableCLIDForRedirectingIdentity
    enterpriseCallsCLIDPolicy groupCallsCLIDPolicy Replaced by:
    ``ServiceProviderCallProcessingGetPolicyResponse19sp1()``

    Attributes:
        use_service_provider_dclid_setting: useServiceProviderDCLIDSetting
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category:
            overrideCLIDRestrictionForPrivateCallCategory
        use_enterprise_clid_for_private_call_category:
            useEnterpriseCLIDForPrivateCallCategory
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        enforce_enterprise_calling_line_identity_restriction:
            enforceEnterpriseCallingLineIdentityRestriction
        use_setting_level: useSettingLevel
        conference_uri: conferenceURI
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
        clid_policy: clidPolicy
        emergency_clid_policy: emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity:
            allowAlternateNumbersForRedirectingIdentity
        block_calling_name_for_external_calls: blockCallingNameForExternalCalls
        enable_dialable_caller_id: enableDialableCallerID
        allow_configurable_clid_for_redirecting_identity:
            allowConfigurableCLIDForRedirectingIdentity
        enterprise_calls_clid_policy: enterpriseCallsCLIDPolicy
        group_calls_clid_policy: groupCallsCLIDPolicy
    """

    _ELEMENTS = (
        E(
            "use_service_provider_dclid_setting", "useServiceProviderDCLIDSetting", bool,
            is_required=True,
        ),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("conference_uri", "conferenceURI", str),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E(
            "block_calling_name_for_external_calls", "blockCallingNameForExternalCalls",
            bool, is_required=True,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool, is_required=True),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool, is_required=True,
        ),
        E("enterprise_calls_clid_policy", "enterpriseCallsCLIDPolicy", str, is_required=True),
        E("group_calls_clid_policy", "groupCallsCLIDPolicy", str, is_required=True),
    )

    use_service_provider_dclid_setting: bool = Field(type=bool, required=True, mutable=False)
    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    override_clid_restriction_for_private_call_category: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_enterprise_clid_for_private_call_category: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(type=bool, required=True, mutable=False)
    enforce_enterprise_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_setting_level: str = Field(type=str, required=True, mutable=False)
    conference_uri: str = Field(type=str, required=False, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )
    clid_policy: str = Field(type=str, required=True, mutable=False)
    emergency_clid_policy: str = Field(type=str, required=True, mutable=False)
    allow_alternate_numbers_for_redirecting_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )
    block_calling_name_for_external_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_dialable_caller_id: bool = Field(type=bool, required=True, mutable=False)
    allow_configurable_clid_for_redirecting_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enterprise_calls_clid_policy: str = Field(type=str, required=True, mutable=False)
    group_calls_clid_policy: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyResponse19sp1(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest19sp1()``.

    The following elements are only used in AS data mode: useServiceProviderDCLIDSetting
    enableDialableCallerID allowConfigurableCLIDForRedirectingIdentity
    enterpriseCallsCLIDPolicy groupCallsCLIDPolicy

    Attributes:
        use_service_provider_dclid_setting: useServiceProviderDCLIDSetting
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category:
            overrideCLIDRestrictionForPrivateCallCategory
        use_enterprise_clid_for_private_call_category:
            useEnterpriseCLIDForPrivateCallCategory
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        enforce_enterprise_calling_line_identity_restriction:
            enforceEnterpriseCallingLineIdentityRestriction
        use_setting_level: useSettingLevel
        conference_uri: conferenceURI
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
        clid_policy: clidPolicy
        emergency_clid_policy: emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity:
            allowAlternateNumbersForRedirectingIdentity
        block_calling_name_for_external_calls: blockCallingNameForExternalCalls
        enable_dialable_caller_id: enableDialableCallerID
        allow_configurable_clid_for_redirecting_identity:
            allowConfigurableCLIDForRedirectingIdentity
        enterprise_calls_clid_policy: enterpriseCallsCLIDPolicy
        group_calls_clid_policy: groupCallsCLIDPolicy
    """

    _ELEMENTS = (
        E(
            "use_service_provider_dclid_setting", "useServiceProviderDCLIDSetting", bool,
            is_required=True,
        ),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("use_setting_level", "useSettingLevel", str, is_required=True),
        E("conference_uri", "conferenceURI", str),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
        E(
            "block_calling_name_for_external_calls", "blockCallingNameForExternalCalls",
            bool, is_required=True,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool, is_required=True),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool, is_required=True,
        ),
        E("enterprise_calls_clid_policy", "enterpriseCallsCLIDPolicy", str, is_required=True),
        E("group_calls_clid_policy", "groupCallsCLIDPolicy", str, is_required=True),
    )

    use_service_provider_dclid_setting: bool = Field(type=bool, required=True, mutable=False)
    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    override_clid_restriction_for_private_call_category: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_enterprise_clid_for_private_call_category: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(type=bool, required=True, mutable=False)
    enforce_enterprise_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_setting_level: str = Field(type=str, required=True, mutable=False)
    conference_uri: str = Field(type=str, required=False, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )
    clid_policy: str = Field(type=str, required=True, mutable=False)
    emergency_clid_policy: str = Field(type=str, required=True, mutable=False)
    allow_alternate_numbers_for_redirecting_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )
    block_calling_name_for_external_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_dialable_caller_id: bool = Field(type=bool, required=True, mutable=False)
    allow_configurable_clid_for_redirecting_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enterprise_calls_clid_policy: str = Field(type=str, required=True, mutable=False)
    group_calls_clid_policy: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringCriteriaGetAssignedListResponse(OCIResponse):
    """
    Response to ``ServiceProviderCommunicationBarringCriteriaGetAssignedListRequest()``.

    Contains a table of all Communication Barring Criteria assigned to the service
    provider.  The column headings are: "Name" and "Description".

    Attributes:
        criteria_table: criteriaTable
    """

    _ELEMENTS = (
        E(
            "criteria_table", "criteriaTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    criteria_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderCommunicationBarringDigitPatternCriteriaGetListResponse(OCIResponse):
    """
    Response to the
    ``ServiceProviderCommunicationBarringDigitPatternCriteriaGetListRequest()``.

    The response contains a table of all Digit Pattern Criteria defined for the service
    provider.  The column headings are "Name" and "Description"

    Attributes:
        criteria_table: criteriaTable
    """

    _ELEMENTS = (
        E(
            "criteria_table", "criteriaTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    criteria_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderCommunicationBarringDigitPatternCriteriaGetPatternListResponse(OCIResponse):
    """
    Response to the
    ``ServiceProviderCommunicationBarringDigitPatternCriteriaGetPatternListRequest()``.

    The response contains the Digit Pattern Criteria information.

    Attributes:
        match_digit_pattern: matchDigitPattern
    """

    _ELEMENTS = (
        E("match_digit_pattern", "matchDigitPattern", str, is_array=True),
    )

    match_digit_pattern: "List[str]" = Field(type=list, required=False, mutable=False)


class ServiceProviderCommunicationBarringDigitPatternCriteriaGetResponse(OCIResponse):
    """
    Response to the
    ``ServiceProviderCommunicationBarringDigitPatternCriteriaGetRequest()``.

    The response contains the Digit Pattern Criteria information.

    Attributes:
        description: description
    """

    _ELEMENTS = (
        E("description", "description", str),
    )

    description: str = Field(type=str, required=False, mutable=False)


class ServiceProviderCommunicationBarringIncomingCriteriaGetAssignedListResponse(OCIResponse):
    """
    Response to
    ``ServiceProviderCommunicationBarringIncomingCriteriaGetAssignedListRequest()``.

    Contains a table of all Communication Barring Incoming Criteria assigned to the
    service provider.  The column headings are: "Name" and "Description".

    Attributes:
        criteria_table: criteriaTable
    """

    _ELEMENTS = (
        E(
            "criteria_table", "criteriaTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    criteria_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderCommunicationBarringProfileGetAssignedGroupListResponse(OCIResponse):
    """
    Response to
    ``ServiceProviderCommunicationBarringProfileGetAssignedGroupListRequest()``.

    Contains a table of groups that have the Communication Barring Profile assigned.  The
    column headings are: "Group Id" and "Group Name".

    Attributes:
        group_table: groupTable
    """

    _ELEMENTS = (
        E(
            "group_table", "groupTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    group_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderCommunicationBarringProfileGetCriteriaUsageListResponse(OCIResponse):
    """
    Response to ServiceProviderCommunicationBarring
    ``ProfileGetCriteriaUsageListRequest()``.

    Contains a table of profiles that have the Communication Barring Criteria assigned.
    The column headings are: "Name" and "Description".

    Attributes:
        profile_table: profileTable
    """

    _ELEMENTS = (
        E(
            "profile_table", "profileTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    profile_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderCommunicationBarringProfileGetDigitPatternCriteriaUsageListResponse(OCIResponse):
    """
    Response to the
    ``ServiceProviderCommunicationBarringProfileGetDigitPatternCriteriaUsageListRequest()``.

    The response contains a table of all Profiles that use the specific Digit Pattern
    Criteria.  The column headings are "Name" and "Description"

    Attributes:
        profile_table: profileTable
    """

    _ELEMENTS = (
        E(
            "profile_table", "profileTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    profile_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderCommunicationBarringProfileGetIncomingCriteriaUsageListResponse(OCIResponse):
    """
    Response to
    ``ServiceProviderCommunicationBarringProfileGetIncomingCriteriaUsageListRequest()``.

    Contains a table of profiles that have the Communication Barring Incoming Criteria
    assigned.  The column headings are: "Name" and "Description".

    Attributes:
        profile_table: profileTable
    """

    _ELEMENTS = (
        E(
            "profile_table", "profileTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    profile_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderCommunicationBarringProfileGetListResponse(OCIResponse):
    """
    Response to the ``ServiceProviderCommunicationBarringProfileGetListRequest()``.

    The response contains a table of all Communication Barring Profiles for the service
    provider.  The column headings are "Default" , "Name" and "Description"

    Attributes:
        profile_table: profileTable
    """

    _ELEMENTS = (
        E(
            "profile_table", "profileTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    profile_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderDeviceManagementEventGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderDeviceManagementEventGetListRequest()``.

    Contains a table with column headings: "Event Id", "Status", "Action", "Level",
    "Type", "Additional Info", "Is Local", "Completion %", "Pushed/ Same Hash/ Not
    Pushed", "Login Id", "Start Time", "Process Time". "Event Id" is a unique identifer
    for the event.  "Status" can be: Pending, Queued, In Progress, Process On Other Host,
    Stale, Completed, Canceled.  "Action" can be: Delete, Download, Rebuild, Reset,
    Upload.  "Level" can be: Device, Device Type, Device Type Group, Group, User.  "Type"
    can be: Automatic, Manual.  "Additional Info" includes the affected device type,
    device or group.  It depends on the level of the event: Device Profile: "Device Name"
    "Service Provider Id" "Group Id" Device Type: "Device Type Name" Device Type Group:
    "Service Provider Id" "Group Id" "Device Type Name" Group: "Service Provider Id"
    "Group Id" User: "User Id" "Is Local" is set to "yes" if the event is processed on the
    server who received the request, "no" otherwise meaning that the event is processed on
    another server.  "Completion %" provides an estimate of the completion of the event.
    A percentage is given, the current number of completed expanded event, and the total
    number of expanded event.  "Pushed/ Same Hash/ Not Pushed" gives the total number of
    files that were pushed, not pushed because of same hash, and not pushed when
    processing the event.  "LoginId" is the user or admin id who triggered the event.
    "Start Time" is the date when the event was started.  The display shows the month,
    days, hours, and minutes (MM-dd hh:mm). "Process Time" is the time taken to process
    the event in hours, minutes, seconds, and milliseconds (hhhh:mm:ss.SSS). Each row
    represents an event sorted by priority of processing.  The first row in the table is
    an event that has an associated expanded event currently being processed or next in
    line to be processed.

    Attributes:
        event_table: eventTable
    """

    _ELEMENTS = (
        E(
            "event_table", "eventTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    event_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderDeviceProfileAuthenticationPasswordRulesGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderDeviceProfileAuthenticationPasswordRulesGetRequest()``.

    Contains the device profile authentication password rules for the service provider.

    Attributes:
        use_service_provider_settings: useServiceProviderSettings
        disallow_authentication_name: disallowAuthenticationName
        disallow_old_password: disallowOldPassword
        disallow_reversed_old_password: disallowReversedOldPassword
        restrict_min_digits: restrictMinDigits
        min_digits: minDigits
        restrict_min_upper_case_letters: restrictMinUpperCaseLetters
        min_upper_case_letters: minUpperCaseLetters
        restrict_min_lower_case_letters: restrictMinLowerCaseLetters
        min_lower_case_letters: minLowerCaseLetters
        restrict_min_non_alphanumeric_characters: restrictMinNonAlphanumericCharacters
        min_non_alphanumeric_characters: minNonAlphanumericCharacters
        min_length: minLength
        send_permanent_lockout_notification: sendPermanentLockoutNotification
        permanent_lockout_notify_email_address: permanentLockoutNotifyEmailAddress
        device_profile_authentication_lockout_type: deviceProfileAuthenticationLockoutType
        device_profile_temporary_lockout_threshold: deviceProfileTemporaryLockoutThreshold
        device_profile_wait_algorithm: deviceProfileWaitAlgorithm
        device_profile_lockout_fixed_minutes: deviceProfileLockoutFixedMinutes
        device_profile_permanent_lockout_threshold: deviceProfilePermanentLockoutThreshold
    """

    _ELEMENTS = (
        E(
            "use_service_provider_settings", "useServiceProviderSettings", bool,
            is_required=True,
        ),
        E(
            "disallow_authentication_name", "disallowAuthenticationName", bool,
            is_required=True,
        ),
        E("disallow_old_password", "disallowOldPassword", bool, is_required=True),
        E(
            "disallow_reversed_old_password", "disallowReversedOldPassword", bool,
            is_required=True,
        ),
        E("restrict_min_digits", "restrictMinDigits", bool, is_required=True),
        E("min_digits", "minDigits", int, is_required=True),
        E(
            "restrict_min_upper_case_letters", "restrictMinUpperCaseLetters", bool,
            is_required=True,
        ),
        E("min_upper_case_letters", "minUpperCaseLetters", int, is_required=True),
        E(
            "restrict_min_lower_case_letters", "restrictMinLowerCaseLetters", bool,
            is_required=True,
        ),
        E("min_lower_case_letters", "minLowerCaseLetters", int, is_required=True),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters", bool, is_required=True,
        ),
        E(
            "min_non_alphanumeric_characters", "minNonAlphanumericCharacters", int,
            is_required=True,
        ),
        E("min_length", "minLength", int, is_required=True),
        E(
            "send_permanent_lockout_notification", "sendPermanentLockoutNotification",
            bool, is_required=True,
        ),
        E(
            "permanent_lockout_notify_email_address",
            "permanentLockoutNotifyEmailAddress", str,
        ),
        E(
            "device_profile_authentication_lockout_type",
            "deviceProfileAuthenticationLockoutType", str, is_required=True,
        ),
        E(
            "device_profile_temporary_lockout_threshold",
            "deviceProfileTemporaryLockoutThreshold", int, is_required=True,
        ),
        E(
            "device_profile_wait_algorithm", "deviceProfileWaitAlgorithm", str,
            is_required=True,
        ),
        E(
            "device_profile_lockout_fixed_minutes", "deviceProfileLockoutFixedMinutes",
            str, is_required=True,
        ),
        E(
            "device_profile_permanent_lockout_threshold",
            "deviceProfilePermanentLockoutThreshold", int, is_required=True,
        ),
    )

    use_service_provider_settings: bool = Field(type=bool, required=True, mutable=False)
    disallow_authentication_name: bool = Field(type=bool, required=True, mutable=False)
    disallow_old_password: bool = Field(type=bool, required=True, mutable=False)
    disallow_reversed_old_password: bool = Field(type=bool, required=True, mutable=False)
    restrict_min_digits: bool = Field(type=bool, required=True, mutable=False)
    min_digits: int = Field(type=int, required=True, mutable=False)
    restrict_min_upper_case_letters: bool = Field(type=bool, required=True, mutable=False)
    min_upper_case_letters: int = Field(type=int, required=True, mutable=False)
    restrict_min_lower_case_letters: bool = Field(type=bool, required=True, mutable=False)
    min_lower_case_letters: int = Field(type=int, required=True, mutable=False)
    restrict_min_non_alphanumeric_characters: bool = Field(
        type=bool, required=True, mutable=False,
    )
    min_non_alphanumeric_characters: int = Field(type=int, required=True, mutable=False)
    min_length: int = Field(type=int, required=True, mutable=False)
    send_permanent_lockout_notification: bool = Field(type=bool, required=True, mutable=False)
    permanent_lockout_notify_email_address: str = Field(
        type=str, required=False, mutable=False,
    )
    device_profile_authentication_lockout_type: str = Field(
        type=str, required=True, mutable=False,
    )
    device_profile_temporary_lockout_threshold: int = Field(
        type=int, required=True, mutable=False,
    )
    device_profile_wait_algorithm: str = Field(type=str, required=True, mutable=False)
    device_profile_lockout_fixed_minutes: str = Field(type=str, required=True, mutable=False)
    device_profile_permanent_lockout_threshold: int = Field(
        type=int, required=True, mutable=False,
    )


class ServiceProviderDialPlanPolicyGetAccessCodeListResponse(OCIResponse):
    """
    Response to ``ServiceProviderDialPlanPolicyGetAccessCodeListRequest()``.

    Contains a table with column headings: "Access Code", "Enable Secondary Dial Tone",
    "Description".

    Attributes:
        access_code_table: accessCodeTable
    """

    _ELEMENTS = (
        E(
            "access_code_table", "accessCodeTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    access_code_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderDialPlanPolicyGetAccessCodeResponse(OCIResponse):
    """
    Response to ``ServiceProviderDialPlanPolicyGetAccessCodeRequest()``

    Attributes:
        include_code_for_network_translations_and_routing:
            includeCodeForNetworkTranslationsAndRouting
        include_code_for_screening_services: includeCodeForScreeningServices
        enable_secondary_dial_tone: enableSecondaryDialTone
        description: description
    """

    _ELEMENTS = (
        E(
            "include_code_for_network_translations_and_routing",
            "includeCodeForNetworkTranslationsAndRouting", bool, is_required=True,
        ),
        E(
            "include_code_for_screening_services", "includeCodeForScreeningServices",
            bool, is_required=True,
        ),
        E("enable_secondary_dial_tone", "enableSecondaryDialTone", bool, is_required=True),
        E("description", "description", str),
    )

    include_code_for_network_translations_and_routing: bool = Field(
        type=bool, required=True, mutable=False,
    )
    include_code_for_screening_services: bool = Field(type=bool, required=True, mutable=False)
    enable_secondary_dial_tone: bool = Field(type=bool, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class ServiceProviderDialPlanPolicyGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderDialPlanPolicyGetRequest()`` Replaced by:
    ``ServiceProviderDialPlanPolicyGetResponse17()``

    Attributes:
        requires_access_code_for_public_calls: requiresAccessCodeForPublicCalls
        allow_e164_public_calls: allowE164PublicCalls
        public_digit_map: publicDigitMap
        private_digit_map: privateDigitMap
    """

    _ELEMENTS = (
        E(
            "requires_access_code_for_public_calls", "requiresAccessCodeForPublicCalls",
            bool, is_required=True,
        ),
        E("allow_e164_public_calls", "allowE164PublicCalls", bool, is_required=True),
        E("public_digit_map", "publicDigitMap", str),
        E("private_digit_map", "privateDigitMap", str),
    )

    requires_access_code_for_public_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_e164_public_calls: bool = Field(type=bool, required=True, mutable=False)
    public_digit_map: str = Field(type=str, required=False, mutable=False)
    private_digit_map: str = Field(type=str, required=False, mutable=False)


class ServiceProviderDialPlanPolicyGetResponse17(OCIResponse):
    """
    Response to ``ServiceProviderDialPlanPolicyGetRequest17()``

    Attributes:
        requires_access_code_for_public_calls: requiresAccessCodeForPublicCalls
        allow_e164_public_calls: allowE164PublicCalls
        prefer_e164_number_format_for_callback_services:
            preferE164NumberFormatForCallbackServices
        public_digit_map: publicDigitMap
        private_digit_map: privateDigitMap
    """

    _ELEMENTS = (
        E(
            "requires_access_code_for_public_calls", "requiresAccessCodeForPublicCalls",
            bool, is_required=True,
        ),
        E("allow_e164_public_calls", "allowE164PublicCalls", bool, is_required=True),
        E(
            "prefer_e164_number_format_for_callback_services",
            "preferE164NumberFormatForCallbackServices", bool, is_required=True,
        ),
        E("public_digit_map", "publicDigitMap", str),
        E("private_digit_map", "privateDigitMap", str),
    )

    requires_access_code_for_public_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_e164_public_calls: bool = Field(type=bool, required=True, mutable=False)
    prefer_e164_number_format_for_callback_services: bool = Field(
        type=bool, required=True, mutable=False,
    )
    public_digit_map: str = Field(type=str, required=False, mutable=False)
    private_digit_map: str = Field(type=str, required=False, mutable=False)


class ServiceProviderDialableCallerIDCriteriaGetResponse(OCIResponse):
    """
    Response to the ``ServiceProviderDialableCallerIDCriteriaGetRequest()``.

    The response contains the Dialable Caller ID Criteria information.

    Attributes:
        description: description
        prefix_digits: prefixDigits
        match_call_type: matchCallType
        match_alternate_call_indicator: matchAlternateCallIndicator
        match_local_category: matchLocalCategory
        match_national_category: matchNationalCategory
        match_interlata_category: matchInterlataCategory
        match_intralata_category: matchIntralataCategory
        match_international_category: matchInternationalCategory
        match_private_category: matchPrivateCategory
        match_emergency_category: matchEmergencyCategory
        match_other_category: matchOtherCategory
    """

    _ELEMENTS = (
        E("description", "description", str),
        E("prefix_digits", "prefixDigits", str),
        E("match_call_type", "matchCallType", str, is_array=True),
        E(
            "match_alternate_call_indicator", "matchAlternateCallIndicator", str,
            is_array=True,
        ),
        E("match_local_category", "matchLocalCategory", bool, is_required=True),
        E("match_national_category", "matchNationalCategory", bool, is_required=True),
        E("match_interlata_category", "matchInterlataCategory", bool, is_required=True),
        E("match_intralata_category", "matchIntralataCategory", bool, is_required=True),
        E(
            "match_international_category", "matchInternationalCategory", bool,
            is_required=True,
        ),
        E("match_private_category", "matchPrivateCategory", bool, is_required=True),
        E("match_emergency_category", "matchEmergencyCategory", bool, is_required=True),
        E("match_other_category", "matchOtherCategory", bool, is_required=True),
    )

    description: str = Field(type=str, required=False, mutable=False)
    prefix_digits: str = Field(type=str, required=False, mutable=False)
    match_call_type: "List[str]" = Field(type=list, required=False, mutable=False)
    match_alternate_call_indicator: "List[str]" = Field(
        type=list, required=False, mutable=False,
    )
    match_local_category: bool = Field(type=bool, required=True, mutable=False)
    match_national_category: bool = Field(type=bool, required=True, mutable=False)
    match_interlata_category: bool = Field(type=bool, required=True, mutable=False)
    match_intralata_category: bool = Field(type=bool, required=True, mutable=False)
    match_international_category: bool = Field(type=bool, required=True, mutable=False)
    match_private_category: bool = Field(type=bool, required=True, mutable=False)
    match_emergency_category: bool = Field(type=bool, required=True, mutable=False)
    match_other_category: bool = Field(type=bool, required=True, mutable=False)


class ServiceProviderDialableCallerIDGetResponse(OCIResponse):
    """
    Response to the ``ServiceProviderDialableCallerIDGetRequest()``.

    The criteria table?s column headings are ?Active?, "Name", "Description", ?Prefix
    Digits?, and ?Priority?.

    Attributes:
        use_service_provider_criteria: useServiceProviderCriteria
        ns_screening_failure_policy: nsScreeningFailurePolicy
        criteria_table: criteriaTable
    """

    _ELEMENTS = (
        E(
            "use_service_provider_criteria", "useServiceProviderCriteria", bool,
            is_required=True,
        ),
        E("ns_screening_failure_policy", "nsScreeningFailurePolicy", str, is_required=True),
        E(
            "criteria_table", "criteriaTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    use_service_provider_criteria: bool = Field(type=bool, required=True, mutable=False)
    ns_screening_failure_policy: str = Field(type=str, required=True, mutable=False)
    criteria_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderDigitCollectionGetResponse13mp4(OCIResponse):
    """
    Response to ``ServiceProviderDigitCollectionGetRequest13mp4()``.


    Attributes:
        access_code: accessCode
        public_digit_map: publicDigitMap
        private_digit_map: privateDigitMap
    """

    _ELEMENTS = (
        E("access_code", "accessCode", str),
        E("public_digit_map", "publicDigitMap", str),
        E("private_digit_map", "privateDigitMap", str),
    )

    access_code: str = Field(type=str, required=False, mutable=False)
    public_digit_map: str = Field(type=str, required=False, mutable=False)
    private_digit_map: str = Field(type=str, required=False, mutable=False)


class ServiceProviderDnGetAvailableListResponse(OCIResponse):
    """
    Response to ``ServiceProviderDnGetAvailableListRequest()``.

    Contains a list of available DNs not yet assigned to any group.

    Attributes:
        available_dn: availableDn
    """

    _ELEMENTS = (
        E("available_dn", "availableDn", str, is_array=True),
    )

    available_dn: "List[str]" = Field(type=list, required=False, mutable=False)


class ServiceProviderDnGetSummaryListResponse(OCIResponse):
    """
    Response to ``ServiceProviderDnGetSummaryListRequest()``.

    The column headings are "Phone Numbers, "Group Id" and "Can Delete"

    Attributes:
        dn_summary_table: dnSummaryTable
    """

    _ELEMENTS = (
        E(
            "dn_summary_table", "dnSummaryTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    dn_summary_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderDomainGetAssignedGroupListResponse(OCIResponse):
    """
    Response to ``ServiceProviderDomainGetAssignedGroupListRequest()``.

    Contains a table with column headings: "Group Id", "Group Name" and a row for each
    group.

    Attributes:
        group_table: groupTable
    """

    _ELEMENTS = (
        E(
            "group_table", "groupTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    group_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderDomainGetAssignedListResponse(OCIResponse):
    """
    Contains a simple list of all service provider domain names.


    Attributes:
        service_provider_default_domain: serviceProviderDefaultDomain
        domain: domain
    """

    _ELEMENTS = (
        E(
            "service_provider_default_domain", "serviceProviderDefaultDomain", str,
            is_required=True,
        ),
        E("domain", "domain", str, is_array=True),
    )

    service_provider_default_domain: str = Field(type=str, required=True, mutable=False)
    domain: "List[str]" = Field(type=list, required=False, mutable=False)


class ServiceProviderEndpointGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderEndpointGetListRequest()``.

    The column headings for the endpointTable are: "Group Id", "Line/Port", "Last Name",
    "First Name", "User Id", "User Type", "Phone Number", "Extension", "Device Type",
    "Device Name", "Net Address", "MAC Address", "Department", "Email Address". Possible
    values for User Type are "User", "CCBasic", "CCStandard", "CCPremium", "RP", "MOH",
    "MOHVideo".

    Attributes:
        endpoint_table: endpointTable
    """

    _ELEMENTS = (
        E(
            "endpoint_table", "endpointTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    endpoint_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderEnhancedCallLogsGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderEnhancedCallLogsGetRequest()``.


    Attributes:
        max_logged_calls: maxLoggedCalls
        call_expiration_days: callExpirationDays
    """

    _ELEMENTS = (
        E("max_logged_calls", "maxLoggedCalls", int, is_required=True),
        E("call_expiration_days", "callExpirationDays", int, is_required=True),
    )

    max_logged_calls: int = Field(type=int, required=True, mutable=False)
    call_expiration_days: int = Field(type=int, required=True, mutable=False)


class ServiceProviderEnhancedCallLogsGetResponse17sp4(OCIResponse):
    """
    Response to ``ServiceProviderEnhancedCallLogsGetRequest17sp4()``.


    Attributes:
        max_logged_calls: maxLoggedCalls
        call_expiration_days: callExpirationDays
    """

    _ELEMENTS = (
        E("max_logged_calls", "maxLoggedCalls", int, is_required=True),
        E("call_expiration_days", "callExpirationDays", int, is_required=True),
    )

    max_logged_calls: int = Field(type=int, required=True, mutable=False)
    call_expiration_days: int = Field(type=int, required=True, mutable=False)


class ServiceProviderExternalCustomRingbackGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderExternalCustomRingbackGetRequest()``.


    Attributes:
        prefix_digits: prefixDigits
        server_net_address: serverNetAddress
        server_port: serverPort
        timeout_seconds: timeoutSeconds
    """

    _ELEMENTS = (
        E("prefix_digits", "prefixDigits", str),
        E("server_net_address", "serverNetAddress", str),
        E("server_port", "serverPort", int),
        E("timeout_seconds", "timeoutSeconds", int, is_required=True),
    )

    prefix_digits: str = Field(type=str, required=False, mutable=False)
    server_net_address: str = Field(type=str, required=False, mutable=False)
    server_port: int = Field(type=int, required=False, mutable=False)
    timeout_seconds: int = Field(type=int, required=True, mutable=False)


class ServiceProviderFileRepositoryDeviceUserGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderFileRepositoryDeviceUserGetListRequest()``.

    Contains a table with column headings : "User Name","Allow Delete","Allow Get","Allow
    Put" in a row for each file repository service provider user.

    Attributes:
        file_repository_user_table: fileRepositoryUserTable
    """

    _ELEMENTS = (
        E(
            "file_repository_user_table", "fileRepositoryUserTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    file_repository_user_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderGetDefaultResponse(OCIResponse):
    """
    Response to the ``ServiceProviderGetDefaultRequest()``.

    All values are default values for a service provider or enterprise's profile.

    Attributes:
        is_enterprise: isEnterprise
        default_domain: defaultDomain
    """

    _ELEMENTS = (
        E("is_enterprise", "isEnterprise", bool, is_required=True),
        E("default_domain", "defaultDomain", str, is_required=True),
    )

    is_enterprise: bool = Field(type=bool, required=True, mutable=False)
    default_domain: str = Field(type=str, required=True, mutable=False)


class ServiceProviderGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderGetListRequest()``.

    Contains a 3 column table with column headings 'Service Provider Id', 'Service
    Provider Name' and 'Is Enterprise' and a row for each service provider or enterprise.

    Attributes:
        service_provider_table: serviceProviderTable
    """

    _ELEMENTS = (
        E(
            "service_provider_table", "serviceProviderTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    service_provider_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderGroupPagingTargetsCapacityGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderGroupPagingTargetsCapacityGetRequest()``.


    Attributes:
        maximum_target_users: maximumTargetUsers
    """

    _ELEMENTS = (
        E("maximum_target_users", "maximumTargetUsers", int, is_required=True),
    )

    maximum_target_users: int = Field(type=int, required=True, mutable=False)


class ServiceProviderIMRNGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderIMRNGetListRequest()``.


    Attributes:
        imrn: imrn
    """

    _ELEMENTS = (
        E("imrn", "imrn", str, is_array=True),
    )

    imrn: "List[str]" = Field(type=list, required=False, mutable=False)


class ServiceProviderInCallServiceActivationGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderInCallServiceActivationGetRequest()``.

    Replaced by: ``ServiceProviderInCallServiceActivationGetResponse17()``

    Attributes:
        activation_digits: activationDigits
    """

    _ELEMENTS = (
        E("activation_digits", "activationDigits", str, is_required=True),
    )

    activation_digits: str = Field(type=str, required=True, mutable=False)


class ServiceProviderInCallServiceActivationGetResponse17(OCIResponse):
    """
    Response to ``ServiceProviderInCallServiceActivationGetRequest17()``.


    Attributes:
        flash_activation_digits: flashActivationDigits
        call_transfer_activation_digits: callTransferActivationDigits
    """

    _ELEMENTS = (
        E("flash_activation_digits", "flashActivationDigits", str, is_required=True),
        E(
            "call_transfer_activation_digits", "callTransferActivationDigits", str,
            is_required=True,
        ),
    )

    flash_activation_digits: str = Field(type=str, required=True, mutable=False)
    call_transfer_activation_digits: str = Field(type=str, required=True, mutable=False)


class ServiceProviderIntegratedIMPGetResponse(OCIResponse):
    """
    Response to the ``ServiceProviderIntegratedIMPGetRequest()``.

    The response contains the service provider Integrated IMP service attributes.
    Replaced by: ``ServiceProviderIntegratedIMPGetResponse21()``

    Attributes:
        use_system_service_domain: useSystemServiceDomain
        service_domain: serviceDomain
    """

    _ELEMENTS = (
        E("use_system_service_domain", "useSystemServiceDomain", bool, is_required=True),
        E("service_domain", "serviceDomain", str),
    )

    use_system_service_domain: bool = Field(type=bool, required=True, mutable=False)
    service_domain: str = Field(type=str, required=False, mutable=False)


class ServiceProviderIntegratedIMPGetResponse21(OCIResponse):
    """
    Response to the ``ServiceProviderIntegratedIMPGetRequest21()``.

    The response contains the service provider Integrated IMP service attributes.

    Attributes:
        use_system_service_domain: useSystemServiceDomain
        service_domain: serviceDomain
        service_port: servicePort
        use_system_messaging_server: useSystemMessagingServer
        provisioning_url: provisioningUrl
        provisioning_user_id: provisioningUserId
        bosh_url: boshURL
    """

    _ELEMENTS = (
        E("use_system_service_domain", "useSystemServiceDomain", bool, is_required=True),
        E("service_domain", "serviceDomain", str),
        E("service_port", "servicePort", int),
        E("use_system_messaging_server", "useSystemMessagingServer", bool, is_required=True),
        E("provisioning_url", "provisioningUrl", str),
        E("provisioning_user_id", "provisioningUserId", str),
        E("bosh_url", "boshURL", str),
    )

    use_system_service_domain: bool = Field(type=bool, required=True, mutable=False)
    service_domain: str = Field(type=str, required=False, mutable=False)
    service_port: int = Field(type=int, required=False, mutable=False)
    use_system_messaging_server: bool = Field(type=bool, required=True, mutable=False)
    provisioning_url: str = Field(type=str, required=False, mutable=False)
    provisioning_user_id: str = Field(type=str, required=False, mutable=False)
    bosh_url: str = Field(type=str, required=False, mutable=False)


class ServiceProviderLDAPIntegrationGetDirectoryResponse(OCIResponse):
    """
    Response to ``ServiceProviderLDAPIntegrationGetDirectoryRequest()``.


    Attributes:
        server_net_address: serverNetAddress
        server_port: serverPort
        search_base: searchBase
        use_ssl: useSSL
        require_authentication: requireAuthentication
        authenticated_dn: authenticatedDN
        authenticated_password: authenticatedPassword
        is_sort_enabled: isSortEnabled
        is_paged_result_enabled: isPagedResultEnabled
        search_filter: searchFilter
        include_search_attribute_in_search_filter: includeSearchAttributeInSearchFilter
        column1_attribute_name: column1AttributeName
        column2_attribute_name: column2AttributeName
        column3_attribute_name: column3AttributeName
        column4_attribute_name: column4AttributeName
        column1_label: column1Label
        column2_label: column2Label
        column3_label: column3Label
        column4_label: column4Label
        search_column: searchColumn
    """

    _ELEMENTS = (
        E("server_net_address", "serverNetAddress", str),
        E("server_port", "serverPort", int, is_required=True),
        E("search_base", "searchBase", str),
        E("use_ssl", "useSSL", bool, is_required=True),
        E("require_authentication", "requireAuthentication", bool, is_required=True),
        E("authenticated_dn", "authenticatedDN", str),
        E("authenticated_password", "authenticatedPassword", str),
        E("is_sort_enabled", "isSortEnabled", bool, is_required=True),
        E("is_paged_result_enabled", "isPagedResultEnabled", bool, is_required=True),
        E("search_filter", "searchFilter", str),
        E(
            "include_search_attribute_in_search_filter",
            "includeSearchAttributeInSearchFilter", bool, is_required=True,
        ),
        E("column1_attribute_name", "column1AttributeName", str, is_required=True),
        E("column2_attribute_name", "column2AttributeName", str),
        E("column3_attribute_name", "column3AttributeName", str),
        E("column4_attribute_name", "column4AttributeName", str),
        E("column1_label", "column1Label", str),
        E("column2_label", "column2Label", str),
        E("column3_label", "column3Label", str),
        E("column4_label", "column4Label", str),
        E("search_column", "searchColumn", int, is_required=True),
    )

    server_net_address: str = Field(type=str, required=False, mutable=False)
    server_port: int = Field(type=int, required=True, mutable=False)
    search_base: str = Field(type=str, required=False, mutable=False)
    use_ssl: bool = Field(type=bool, required=True, mutable=False)
    require_authentication: bool = Field(type=bool, required=True, mutable=False)
    authenticated_dn: str = Field(type=str, required=False, mutable=False)
    authenticated_password: str = Field(type=str, required=False, mutable=False)
    is_sort_enabled: bool = Field(type=bool, required=True, mutable=False)
    is_paged_result_enabled: bool = Field(type=bool, required=True, mutable=False)
    search_filter: str = Field(type=str, required=False, mutable=False)
    include_search_attribute_in_search_filter: bool = Field(
        type=bool, required=True, mutable=False,
    )
    column1_attribute_name: str = Field(type=str, required=True, mutable=False)
    column2_attribute_name: str = Field(type=str, required=False, mutable=False)
    column3_attribute_name: str = Field(type=str, required=False, mutable=False)
    column4_attribute_name: str = Field(type=str, required=False, mutable=False)
    column1_label: str = Field(type=str, required=False, mutable=False)
    column2_label: str = Field(type=str, required=False, mutable=False)
    column3_label: str = Field(type=str, required=False, mutable=False)
    column4_label: str = Field(type=str, required=False, mutable=False)
    search_column: int = Field(type=int, required=True, mutable=False)


class ServiceProviderLanguageGetAvailableListResponse(OCIResponse):
    """
    Response to ``ServiceProviderLanguageGetAvailableListRequest()``.

    The language table column headings are: "Language", "Locale" and "Encoding".

    Attributes:
        default_language: defaultLanguage
        language_table: languageTable
    """

    _ELEMENTS = (
        E("default_language", "defaultLanguage", str, is_required=True),
        E(
            "language_table", "languageTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    default_language: str = Field(type=str, required=True, mutable=False)
    language_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderLanguageGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderLanguageGetListRequest()``.


    Attributes:
        language: language
        default_language: defaultLanguage
    """

    _ELEMENTS = (
        E("language", "language", str, is_array=True),
        E("default_language", "defaultLanguage", str),
    )

    language: "List[str]" = Field(type=list, required=False, mutable=False)
    default_language: str = Field(type=str, required=False, mutable=False)


class ServiceProviderMWIDeliveryToMobileEndpointGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderMWIDeliveryToMobileEndpointGetRequest()``.

    The templateActivationTable contains the list of templates defined for the service
    provider.  The column headings are "Enable", "Language", "Type".

    Attributes:
        template_activation_table: templateActivationTable
    """

    _ELEMENTS = (
        E(
            "template_activation_table", "templateActivationTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    template_activation_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderMaliciousCallTraceGetResponse(OCIResponse):
    """
    Response to the ``ServiceProviderMaliciousCallTraceGetRequest()``.

    The response contains the service provider Malicious Call Trace settings.

    Attributes:
        use_system_play_mct_warning_announcement: useSystemPlayMCTWarningAnnouncement
        play_mct_warning_announcement: playMCTWarningAnnouncement
    """

    _ELEMENTS = (
        E(
            "use_system_play_mct_warning_announcement",
            "useSystemPlayMCTWarningAnnouncement", bool, is_required=True,
        ),
        E(
            "play_mct_warning_announcement", "playMCTWarningAnnouncement", bool,
            is_required=True,
        ),
    )

    use_system_play_mct_warning_announcement: bool = Field(
        type=bool, required=True, mutable=False,
    )
    play_mct_warning_announcement: bool = Field(type=bool, required=True, mutable=False)


class ServiceProviderNetworkClassOfServiceGetAssignedGroupListResponse(OCIResponse):
    """
    Response to ``ServiceProviderNetworkClassOfServiceGetAssignedGroupListRequest()``.

    Contains a table of groups that have the Network Class of Service assigned.  The
    column headings are: "Group Id" and "Group Name".

    Attributes:
        group_table: groupTable
    """

    _ELEMENTS = (
        E(
            "group_table", "groupTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    group_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderNetworkClassOfServiceGetAssignedListResponse(OCIResponse):
    """
    Response to ``ServiceProviderNetworkClassOfServiceGetAssignedListRequest()``.

    Contains a table of all Network Classes of Service assigned to the service provider.
    The column headings are: "Name", "Description" and "Default".

    Attributes:
        network_class_of_service_table: networkClassOfServiceTable
    """

    _ELEMENTS = (
        E(
            "network_class_of_service_table", "networkClassOfServiceTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    network_class_of_service_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderNumberPortabilityQueryGetResponse(OCIResponse):
    """
    Response to the ``ServiceProviderNumberPortabilityQueryGetRequest()``.

    The response contains the service provider number portability query information.

    Attributes:
        enable_number_portability_query_for_outgoing_calls:
            enableNumberPortabilityQueryForOutgoingCalls
        enable_number_portability_query_for_incoming_calls:
            enableNumberPortabilityQueryForIncomingCalls
        enable_number_portability_query_for_network_calls_only:
            enableNumberPortabilityQueryForNetworkCallsOnly
        digit_pattern: digitPattern
    """

    _ELEMENTS = (
        E(
            "enable_number_portability_query_for_outgoing_calls",
            "enableNumberPortabilityQueryForOutgoingCalls", bool, is_required=True,
        ),
        E(
            "enable_number_portability_query_for_incoming_calls",
            "enableNumberPortabilityQueryForIncomingCalls", bool, is_required=True,
        ),
        E(
            "enable_number_portability_query_for_network_calls_only",
            "enableNumberPortabilityQueryForNetworkCallsOnly", bool, is_required=True,
        ),
        E("digit_pattern", "digitPattern", str, is_array=True),
    )

    enable_number_portability_query_for_outgoing_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_number_portability_query_for_incoming_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_number_portability_query_for_network_calls_only: bool = Field(
        type=bool, required=True, mutable=False,
    )
    digit_pattern: "List[str]" = Field(type=list, required=False, mutable=False)


class ServiceProviderOfficeZoneGetAssignedGroupListResponse(OCIResponse):
    """
    Response to ``ServiceProviderOfficeZoneGetAssignedGroupListRequest()``.

    Contains a table of groups that have the Office Zone assigned.  The column headings
    are: "Group Id" and "Group Name".

    Attributes:
        group_table: groupTable
    """

    _ELEMENTS = (
        E(
            "group_table", "groupTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    group_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderOfficeZoneGetAssignedListResponse(OCIResponse):
    """
    Response to ``ServiceProviderOfficeZoneGetAssignedListRequest()``.

    Contains a table of all Office Zones assigned to the service provider.  The column
    headings are: "Name", "Description" and "Default".

    Attributes:
        office_zone_table: officeZoneTable
    """

    _ELEMENTS = (
        E(
            "office_zone_table", "officeZoneTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    office_zone_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderPasswordRulesGetResponse13mp2(OCIResponse):
    """
    Response to ``ServiceProviderPasswordRulesGetRequest13mp2()``.

    Contains the group, department administrator and/or user password rules setting.

    Replaced By: ``ServiceProviderPasswordRulesGetResponse16()``

    Attributes:
        service_provider_id: serviceProviderId
        rules_apply_to: rulesApplyTo
        allow_web_add_external_authentication_users:
            allowWebAddExternalAuthenticationUsers
        disallow_user_id: disallowUserId
        disallow_old_password: disallowOldPassword
        disallow_reversed_old_password: disallowReversedOldPassword
        restrict_min_digits: restrictMinDigits
        min_digits: minDigits
        restrict_min_upper_case_letters: restrictMinUpperCaseLetters
        min_upper_case_letters: minUpperCaseLetters
        restrict_min_lower_case_letters: restrictMinLowerCaseLetters
        min_lower_case_letters: minLowerCaseLetters
        restrict_min_non_alphanumeric_characters: restrictMinNonAlphanumericCharacters
        min_non_alphanumeric_characters: minNonAlphanumericCharacters
        min_length: minLength
        max_failed_login_attempts: maxFailedLoginAttempts
        password_expires_days: passwordExpiresDays
        send_login_disabled_notify_email: sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address: loginDisabledNotifyEmailAddress
        disallow_rules_modification: disallowRulesModification
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("rules_apply_to", "rulesApplyTo", str, is_required=True),
        E(
            "allow_web_add_external_authentication_users",
            "allowWebAddExternalAuthenticationUsers", bool, is_required=True,
        ),
        E("disallow_user_id", "disallowUserId", bool, is_required=True),
        E("disallow_old_password", "disallowOldPassword", bool, is_required=True),
        E(
            "disallow_reversed_old_password", "disallowReversedOldPassword", bool,
            is_required=True,
        ),
        E("restrict_min_digits", "restrictMinDigits", bool, is_required=True),
        E("min_digits", "minDigits", int, is_required=True),
        E(
            "restrict_min_upper_case_letters", "restrictMinUpperCaseLetters", bool,
            is_required=True,
        ),
        E("min_upper_case_letters", "minUpperCaseLetters", int, is_required=True),
        E(
            "restrict_min_lower_case_letters", "restrictMinLowerCaseLetters", bool,
            is_required=True,
        ),
        E("min_lower_case_letters", "minLowerCaseLetters", int, is_required=True),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters", bool, is_required=True,
        ),
        E(
            "min_non_alphanumeric_characters", "minNonAlphanumericCharacters", int,
            is_required=True,
        ),
        E("min_length", "minLength", int, is_required=True),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int, is_required=True),
        E("password_expires_days", "passwordExpiresDays", int, is_required=True),
        E(
            "send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool,
            is_required=True,
        ),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
        E("disallow_rules_modification", "disallowRulesModification", bool, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    rules_apply_to: str = Field(type=str, required=True, mutable=False)
    allow_web_add_external_authentication_users: bool = Field(
        type=bool, required=True, mutable=False,
    )
    disallow_user_id: bool = Field(type=bool, required=True, mutable=False)
    disallow_old_password: bool = Field(type=bool, required=True, mutable=False)
    disallow_reversed_old_password: bool = Field(type=bool, required=True, mutable=False)
    restrict_min_digits: bool = Field(type=bool, required=True, mutable=False)
    min_digits: int = Field(type=int, required=True, mutable=False)
    restrict_min_upper_case_letters: bool = Field(type=bool, required=True, mutable=False)
    min_upper_case_letters: int = Field(type=int, required=True, mutable=False)
    restrict_min_lower_case_letters: bool = Field(type=bool, required=True, mutable=False)
    min_lower_case_letters: int = Field(type=int, required=True, mutable=False)
    restrict_min_non_alphanumeric_characters: bool = Field(
        type=bool, required=True, mutable=False,
    )
    min_non_alphanumeric_characters: int = Field(type=int, required=True, mutable=False)
    min_length: int = Field(type=int, required=True, mutable=False)
    max_failed_login_attempts: int = Field(type=int, required=True, mutable=False)
    password_expires_days: int = Field(type=int, required=True, mutable=False)
    send_login_disabled_notify_email: bool = Field(type=bool, required=True, mutable=False)
    login_disabled_notify_email_address: str = Field(type=str, required=False, mutable=False)
    disallow_rules_modification: bool = Field(type=bool, required=True, mutable=False)


class ServiceProviderPasswordRulesGetResponse16(OCIResponse):
    """
    Response to ``ServiceProviderPasswordRulesGetRequest16()``.

    Contains the group, department administrator and/or user password rules setting.

    Attributes:
        rules_apply_to: rulesApplyTo
        allow_web_add_external_authentication_users:
            allowWebAddExternalAuthenticationUsers
        disallow_user_id: disallowUserId
        disallow_old_password: disallowOldPassword
        disallow_reversed_old_password: disallowReversedOldPassword
        restrict_min_digits: restrictMinDigits
        min_digits: minDigits
        restrict_min_upper_case_letters: restrictMinUpperCaseLetters
        min_upper_case_letters: minUpperCaseLetters
        restrict_min_lower_case_letters: restrictMinLowerCaseLetters
        min_lower_case_letters: minLowerCaseLetters
        restrict_min_non_alphanumeric_characters: restrictMinNonAlphanumericCharacters
        min_non_alphanumeric_characters: minNonAlphanumericCharacters
        min_length: minLength
        max_failed_login_attempts: maxFailedLoginAttempts
        password_expires_days: passwordExpiresDays
        send_login_disabled_notify_email: sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address: loginDisabledNotifyEmailAddress
        disallow_rules_modification: disallowRulesModification
        disallow_previous_passwords: disallowPreviousPasswords
        number_of_previous_passwords: numberOfPreviousPasswords
    """

    _ELEMENTS = (
        E("rules_apply_to", "rulesApplyTo", str, is_required=True),
        E(
            "allow_web_add_external_authentication_users",
            "allowWebAddExternalAuthenticationUsers", bool, is_required=True,
        ),
        E("disallow_user_id", "disallowUserId", bool, is_required=True),
        E("disallow_old_password", "disallowOldPassword", bool, is_required=True),
        E(
            "disallow_reversed_old_password", "disallowReversedOldPassword", bool,
            is_required=True,
        ),
        E("restrict_min_digits", "restrictMinDigits", bool, is_required=True),
        E("min_digits", "minDigits", int, is_required=True),
        E(
            "restrict_min_upper_case_letters", "restrictMinUpperCaseLetters", bool,
            is_required=True,
        ),
        E("min_upper_case_letters", "minUpperCaseLetters", int, is_required=True),
        E(
            "restrict_min_lower_case_letters", "restrictMinLowerCaseLetters", bool,
            is_required=True,
        ),
        E("min_lower_case_letters", "minLowerCaseLetters", int, is_required=True),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters", bool, is_required=True,
        ),
        E(
            "min_non_alphanumeric_characters", "minNonAlphanumericCharacters", int,
            is_required=True,
        ),
        E("min_length", "minLength", int, is_required=True),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int, is_required=True),
        E("password_expires_days", "passwordExpiresDays", int, is_required=True),
        E(
            "send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool,
            is_required=True,
        ),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
        E("disallow_rules_modification", "disallowRulesModification", bool, is_required=True),
        E("disallow_previous_passwords", "disallowPreviousPasswords", bool, is_required=True),
        E("number_of_previous_passwords", "numberOfPreviousPasswords", int, is_required=True),
    )

    rules_apply_to: str = Field(type=str, required=True, mutable=False)
    allow_web_add_external_authentication_users: bool = Field(
        type=bool, required=True, mutable=False,
    )
    disallow_user_id: bool = Field(type=bool, required=True, mutable=False)
    disallow_old_password: bool = Field(type=bool, required=True, mutable=False)
    disallow_reversed_old_password: bool = Field(type=bool, required=True, mutable=False)
    restrict_min_digits: bool = Field(type=bool, required=True, mutable=False)
    min_digits: int = Field(type=int, required=True, mutable=False)
    restrict_min_upper_case_letters: bool = Field(type=bool, required=True, mutable=False)
    min_upper_case_letters: int = Field(type=int, required=True, mutable=False)
    restrict_min_lower_case_letters: bool = Field(type=bool, required=True, mutable=False)
    min_lower_case_letters: int = Field(type=int, required=True, mutable=False)
    restrict_min_non_alphanumeric_characters: bool = Field(
        type=bool, required=True, mutable=False,
    )
    min_non_alphanumeric_characters: int = Field(type=int, required=True, mutable=False)
    min_length: int = Field(type=int, required=True, mutable=False)
    max_failed_login_attempts: int = Field(type=int, required=True, mutable=False)
    password_expires_days: int = Field(type=int, required=True, mutable=False)
    send_login_disabled_notify_email: bool = Field(type=bool, required=True, mutable=False)
    login_disabled_notify_email_address: str = Field(type=str, required=False, mutable=False)
    disallow_rules_modification: bool = Field(type=bool, required=True, mutable=False)
    disallow_previous_passwords: bool = Field(type=bool, required=True, mutable=False)
    number_of_previous_passwords: int = Field(type=int, required=True, mutable=False)


class ServiceProviderPortalPasscodeRulesGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderPortalPasscodeRulesGetRequest()``.

    Contains the service provider's passcode rules setting.

    Attributes:
        disallow_repeated_digits: disallowRepeatedDigits
        disallow_user_number: disallowUserNumber
        disallow_reversed_user_number: disallowReversedUserNumber
        disallow_old_passcode: disallowOldPasscode
        disallow_reversed_old_passcode: disallowReversedOldPasscode
        min_code_length: minCodeLength
        max_code_length: maxCodeLength
        disable_login_after_max_failed_login_attempts:
            disableLoginAfterMaxFailedLoginAttempts
        max_failed_login_attempts: maxFailedLoginAttempts
        expire_password: expirePassword
        passcode_expires_days: passcodeExpiresDays
        send_login_disabled_notify_email: sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address: loginDisabledNotifyEmailAddress
    """

    _ELEMENTS = (
        E("disallow_repeated_digits", "disallowRepeatedDigits", bool, is_required=True),
        E("disallow_user_number", "disallowUserNumber", bool, is_required=True),
        E(
            "disallow_reversed_user_number", "disallowReversedUserNumber", bool,
            is_required=True,
        ),
        E("disallow_old_passcode", "disallowOldPasscode", bool, is_required=True),
        E(
            "disallow_reversed_old_passcode", "disallowReversedOldPasscode", bool,
            is_required=True,
        ),
        E("min_code_length", "minCodeLength", int, is_required=True),
        E("max_code_length", "maxCodeLength", int, is_required=True),
        E(
            "disable_login_after_max_failed_login_attempts",
            "disableLoginAfterMaxFailedLoginAttempts", bool, is_required=True,
        ),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int),
        E("expire_password", "expirePassword", bool, is_required=True),
        E("passcode_expires_days", "passcodeExpiresDays", int),
        E(
            "send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool,
            is_required=True,
        ),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
    )

    disallow_repeated_digits: bool = Field(type=bool, required=True, mutable=False)
    disallow_user_number: bool = Field(type=bool, required=True, mutable=False)
    disallow_reversed_user_number: bool = Field(type=bool, required=True, mutable=False)
    disallow_old_passcode: bool = Field(type=bool, required=True, mutable=False)
    disallow_reversed_old_passcode: bool = Field(type=bool, required=True, mutable=False)
    min_code_length: int = Field(type=int, required=True, mutable=False)
    max_code_length: int = Field(type=int, required=True, mutable=False)
    disable_login_after_max_failed_login_attempts: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_failed_login_attempts: int = Field(type=int, required=False, mutable=False)
    expire_password: bool = Field(type=bool, required=True, mutable=False)
    passcode_expires_days: int = Field(type=int, required=False, mutable=False)
    send_login_disabled_notify_email: bool = Field(type=bool, required=True, mutable=False)
    login_disabled_notify_email_address: str = Field(type=str, required=False, mutable=False)


class ServiceProviderPortalPasscodeRulesGetResponse19(OCIResponse):
    """
    Response to ``ServiceProviderPortalPasscodeRulesGetRequest19()``.

    Contains the service provider's passcode rules setting.  The following elements are
    only used in AS data mode: numberOfRepeatedDigits disallowRepeatedPatterns
    disallowContiguousSequences numberOfAscendingDigits numberOfDescendingDigits
    numberOfPreviousPasscodes

    Attributes:
        disallow_repeated_digits: disallowRepeatedDigits
        number_of_repeated_digits: numberOfRepeatedDigits
        disallow_repeated_patterns: disallowRepeatedPatterns
        disallow_contiguous_sequences: disallowContiguousSequences
        number_of_ascending_digits: numberOfAscendingDigits
        number_of_descending_digits: numberOfDescendingDigits
        disallow_user_number: disallowUserNumber
        disallow_reversed_user_number: disallowReversedUserNumber
        disallow_old_passcode: disallowOldPasscode
        number_of_previous_passcodes: numberOfPreviousPasscodes
        disallow_reversed_old_passcode: disallowReversedOldPasscode
        min_code_length: minCodeLength
        max_code_length: maxCodeLength
        disable_login_after_max_failed_login_attempts:
            disableLoginAfterMaxFailedLoginAttempts
        max_failed_login_attempts: maxFailedLoginAttempts
        expire_password: expirePassword
        passcode_expires_days: passcodeExpiresDays
        send_login_disabled_notify_email: sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address: loginDisabledNotifyEmailAddress
    """

    _ELEMENTS = (
        E("disallow_repeated_digits", "disallowRepeatedDigits", bool, is_required=True),
        E("number_of_repeated_digits", "numberOfRepeatedDigits", int, is_required=True),
        E("disallow_repeated_patterns", "disallowRepeatedPatterns", bool, is_required=True),
        E(
            "disallow_contiguous_sequences", "disallowContiguousSequences", bool,
            is_required=True,
        ),
        E("number_of_ascending_digits", "numberOfAscendingDigits", int, is_required=True),
        E("number_of_descending_digits", "numberOfDescendingDigits", int, is_required=True),
        E("disallow_user_number", "disallowUserNumber", bool, is_required=True),
        E(
            "disallow_reversed_user_number", "disallowReversedUserNumber", bool,
            is_required=True,
        ),
        E("disallow_old_passcode", "disallowOldPasscode", bool, is_required=True),
        E("number_of_previous_passcodes", "numberOfPreviousPasscodes", int, is_required=True),
        E(
            "disallow_reversed_old_passcode", "disallowReversedOldPasscode", bool,
            is_required=True,
        ),
        E("min_code_length", "minCodeLength", int, is_required=True),
        E("max_code_length", "maxCodeLength", int, is_required=True),
        E(
            "disable_login_after_max_failed_login_attempts",
            "disableLoginAfterMaxFailedLoginAttempts", bool, is_required=True,
        ),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int),
        E("expire_password", "expirePassword", bool, is_required=True),
        E("passcode_expires_days", "passcodeExpiresDays", int),
        E(
            "send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool,
            is_required=True,
        ),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
    )

    disallow_repeated_digits: bool = Field(type=bool, required=True, mutable=False)
    number_of_repeated_digits: int = Field(type=int, required=True, mutable=False)
    disallow_repeated_patterns: bool = Field(type=bool, required=True, mutable=False)
    disallow_contiguous_sequences: bool = Field(type=bool, required=True, mutable=False)
    number_of_ascending_digits: int = Field(type=int, required=True, mutable=False)
    number_of_descending_digits: int = Field(type=int, required=True, mutable=False)
    disallow_user_number: bool = Field(type=bool, required=True, mutable=False)
    disallow_reversed_user_number: bool = Field(type=bool, required=True, mutable=False)
    disallow_old_passcode: bool = Field(type=bool, required=True, mutable=False)
    number_of_previous_passcodes: int = Field(type=int, required=True, mutable=False)
    disallow_reversed_old_passcode: bool = Field(type=bool, required=True, mutable=False)
    min_code_length: int = Field(type=int, required=True, mutable=False)
    max_code_length: int = Field(type=int, required=True, mutable=False)
    disable_login_after_max_failed_login_attempts: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_failed_login_attempts: int = Field(type=int, required=False, mutable=False)
    expire_password: bool = Field(type=bool, required=True, mutable=False)
    passcode_expires_days: int = Field(type=int, required=False, mutable=False)
    send_login_disabled_notify_email: bool = Field(type=bool, required=True, mutable=False)
    login_disabled_notify_email_address: str = Field(type=str, required=False, mutable=False)


class ServiceProviderPreferredCarrierGetAvailableCountryCodeListResponse(OCIResponse):
    """
    Response to a ``ServiceProviderPreferredCarrierGetAvailableCountryCodeListRequest()``.

    Contains the default country code and the list of unused country codes for a service
    provider / enterprise.

    Attributes:
        default_country_code: defaultCountryCode
        country_code: countryCode
    """

    _ELEMENTS = (
        E("default_country_code", "defaultCountryCode", str),
        E("country_code", "countryCode", str, is_array=True),
    )

    default_country_code: str = Field(type=str, required=False, mutable=False)
    country_code: "List[str]" = Field(type=list, required=False, mutable=False)


class ServiceProviderPreferredCarrierGetCarrierListResponse(OCIResponse):
    """
    Response to a ``ServiceProviderPreferredCarrierGetCarrierListRequest()``.

    Contains the lists of carriers for a specified country code for a service provider /
    enterprise.

    Attributes:
        intra_lata_carrier: intraLataCarrier
        inter_lata_carrier: interLataCarrier
        international_carrier: internationalCarrier
    """

    _ELEMENTS = (
        E("intra_lata_carrier", "intraLataCarrier", str, is_array=True),
        E("inter_lata_carrier", "interLataCarrier", str, is_array=True),
        E("international_carrier", "internationalCarrier", str, is_array=True),
    )

    intra_lata_carrier: "List[str]" = Field(type=list, required=False, mutable=False)
    inter_lata_carrier: "List[str]" = Field(type=list, required=False, mutable=False)
    international_carrier: "List[str]" = Field(type=list, required=False, mutable=False)


class ServiceProviderPreferredCarrierGetListResponse(OCIResponse):
    """
    Response to a ``ServiceProviderPreferredCarrierGetListRequest()``.

    Contains a table with one row per carrier.  The table columns are: "Country Code",
    "Intra-Lata PIC", "Inter-Lata PIC", "International PIC".

    Attributes:
        service_provider_carrier_table: serviceProviderCarrierTable
    """

    _ELEMENTS = (
        E(
            "service_provider_carrier_table", "serviceProviderCarrierTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    service_provider_carrier_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderPreferredCarrierGetResponse(OCIResponse):
    """
    Response to a ``ServiceProviderPreferredCarrierGetRequest()``.

    Contains the currently configured carriers for a specified country code for a service
    provider / enterprise.

    Attributes:
        intra_lata_carrier: intraLataCarrier
        inter_lata_carrier: interLataCarrier
        international_carrier: internationalCarrier
    """

    _ELEMENTS = (
        E("intra_lata_carrier", "intraLataCarrier", str),
        E("inter_lata_carrier", "interLataCarrier", str),
        E("international_carrier", "internationalCarrier", str),
    )

    intra_lata_carrier: str = Field(type=str, required=False, mutable=False)
    inter_lata_carrier: str = Field(type=str, required=False, mutable=False)
    international_carrier: str = Field(type=str, required=False, mutable=False)


class ServiceProviderRouteListEnterpriseTrunkNumberRangeGetAvailableListResponse(OCIResponse):
    """
    Response to
    ``ServiceProviderRouteListEnterpriseTrunkNumberRangeGetAvailableListRequest()``.

    Contains a list of available number ranges not yet assigned to any group.  The column
    headings are "Number Range Start", "Number Range End" and "Is Active".

    Attributes:
        available_number_range_table: availableNumberRangeTable
    """

    _ELEMENTS = (
        E(
            "available_number_range_table", "availableNumberRangeTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    available_number_range_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderRouteListEnterpriseTrunkNumberRangeGetSummaryListResponse(OCIResponse):
    """
    Response to
    ``ServiceProviderRouteListEnterpriseTrunkNumberRangeGetSummaryListRequest()``.

    The column headings are "Number Range Start", "Number Range End", "Group Id" and "Is
    Active".

    Attributes:
        number_range_summary_table: numberRangeSummaryTable
    """

    _ELEMENTS = (
        E(
            "number_range_summary_table", "numberRangeSummaryTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    number_range_summary_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderRoutePointExternalSystemGetAssignedGroupListResponse(OCIResponse):
    """
    Response to ``ServiceProviderRoutePointExternalSystemGetAssignedGroupListRequest()``.

    Contains a table with column headings: "Group Id", "Group Name" and a row for each
    group.

    Attributes:
        group_table: groupTable
    """

    _ELEMENTS = (
        E(
            "group_table", "groupTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    group_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderRoutePointExternalSystemGetAssignedListResponse(OCIResponse):
    """
    Response to the ``ServiceProviderRoutePointExternalSystemGetAssignedListRequest()``.

    Contains a table of all Route Point External Systems assigned to the service provider.
    The column headings are: "Name" and "Description".

    Attributes:
        external_system_table: externalSystemTable
    """

    _ELEMENTS = (
        E(
            "external_system_table", "externalSystemTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    external_system_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderRoutingProfileGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderRoutingProfileGetRequest()``.


    Attributes:
        routing_profile: routingProfile
    """

    _ELEMENTS = (
        E("routing_profile", "routingProfile", str),
    )

    routing_profile: str = Field(type=str, required=False, mutable=False)


class ServiceProviderSIPAuthenticationPasswordRulesGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderSIPAuthenticationPasswordRulesGetRequest()``.

    Contains the SIP authentication password rules for the service provider.

    Attributes:
        use_service_provider_settings: useServiceProviderSettings
        disallow_authentication_name: disallowAuthenticationName
        disallow_old_password: disallowOldPassword
        disallow_reversed_old_password: disallowReversedOldPassword
        restrict_min_digits: restrictMinDigits
        min_digits: minDigits
        restrict_min_upper_case_letters: restrictMinUpperCaseLetters
        min_upper_case_letters: minUpperCaseLetters
        restrict_min_lower_case_letters: restrictMinLowerCaseLetters
        min_lower_case_letters: minLowerCaseLetters
        restrict_min_non_alphanumeric_characters: restrictMinNonAlphanumericCharacters
        min_non_alphanumeric_characters: minNonAlphanumericCharacters
        min_length: minLength
        send_permanent_lockout_notification: sendPermanentLockoutNotification
        permanent_lockout_notify_email_address: permanentLockoutNotifyEmailAddress
        endpoint_authentication_lockout_type: endpointAuthenticationLockoutType
        endpoint_temporary_lockout_threshold: endpointTemporaryLockoutThreshold
        endpoint_wait_algorithm: endpointWaitAlgorithm
        endpoint_lockout_fixed_minutes: endpointLockoutFixedMinutes
        endpoint_permanent_lockout_threshold: endpointPermanentLockoutThreshold
        trunk_group_temporary_lockout_threshold: trunkGroupTemporaryLockoutThreshold
        trunk_group_authentication_lockout_type: trunkGroupAuthenticationLockoutType
        trunk_group_wait_algorithm: trunkGroupWaitAlgorithm
        trunk_group_lockout_fixed_minutes: trunkGroupLockoutFixedMinutes
        trunk_group_permanent_lockout_threshold: trunkGroupPermanentLockoutThreshold
    """

    _ELEMENTS = (
        E(
            "use_service_provider_settings", "useServiceProviderSettings", bool,
            is_required=True,
        ),
        E(
            "disallow_authentication_name", "disallowAuthenticationName", bool,
            is_required=True,
        ),
        E("disallow_old_password", "disallowOldPassword", bool, is_required=True),
        E(
            "disallow_reversed_old_password", "disallowReversedOldPassword", bool,
            is_required=True,
        ),
        E("restrict_min_digits", "restrictMinDigits", bool, is_required=True),
        E("min_digits", "minDigits", int, is_required=True),
        E(
            "restrict_min_upper_case_letters", "restrictMinUpperCaseLetters", bool,
            is_required=True,
        ),
        E("min_upper_case_letters", "minUpperCaseLetters", int, is_required=True),
        E(
            "restrict_min_lower_case_letters", "restrictMinLowerCaseLetters", bool,
            is_required=True,
        ),
        E("min_lower_case_letters", "minLowerCaseLetters", int, is_required=True),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters", bool, is_required=True,
        ),
        E(
            "min_non_alphanumeric_characters", "minNonAlphanumericCharacters", int,
            is_required=True,
        ),
        E("min_length", "minLength", int, is_required=True),
        E(
            "send_permanent_lockout_notification", "sendPermanentLockoutNotification",
            bool, is_required=True,
        ),
        E(
            "permanent_lockout_notify_email_address",
            "permanentLockoutNotifyEmailAddress", str,
        ),
        E(
            "endpoint_authentication_lockout_type", "endpointAuthenticationLockoutType",
            str, is_required=True,
        ),
        E(
            "endpoint_temporary_lockout_threshold", "endpointTemporaryLockoutThreshold",
            int, is_required=True,
        ),
        E("endpoint_wait_algorithm", "endpointWaitAlgorithm", str, is_required=True),
        E(
            "endpoint_lockout_fixed_minutes", "endpointLockoutFixedMinutes", str,
            is_required=True,
        ),
        E(
            "endpoint_permanent_lockout_threshold", "endpointPermanentLockoutThreshold",
            int, is_required=True,
        ),
        E(
            "trunk_group_temporary_lockout_threshold",
            "trunkGroupTemporaryLockoutThreshold", int, is_required=True,
        ),
        E(
            "trunk_group_authentication_lockout_type",
            "trunkGroupAuthenticationLockoutType", str, is_required=True,
        ),
        E("trunk_group_wait_algorithm", "trunkGroupWaitAlgorithm", str, is_required=True),
        E(
            "trunk_group_lockout_fixed_minutes", "trunkGroupLockoutFixedMinutes", str,
            is_required=True,
        ),
        E(
            "trunk_group_permanent_lockout_threshold",
            "trunkGroupPermanentLockoutThreshold", int, is_required=True,
        ),
    )

    use_service_provider_settings: bool = Field(type=bool, required=True, mutable=False)
    disallow_authentication_name: bool = Field(type=bool, required=True, mutable=False)
    disallow_old_password: bool = Field(type=bool, required=True, mutable=False)
    disallow_reversed_old_password: bool = Field(type=bool, required=True, mutable=False)
    restrict_min_digits: bool = Field(type=bool, required=True, mutable=False)
    min_digits: int = Field(type=int, required=True, mutable=False)
    restrict_min_upper_case_letters: bool = Field(type=bool, required=True, mutable=False)
    min_upper_case_letters: int = Field(type=int, required=True, mutable=False)
    restrict_min_lower_case_letters: bool = Field(type=bool, required=True, mutable=False)
    min_lower_case_letters: int = Field(type=int, required=True, mutable=False)
    restrict_min_non_alphanumeric_characters: bool = Field(
        type=bool, required=True, mutable=False,
    )
    min_non_alphanumeric_characters: int = Field(type=int, required=True, mutable=False)
    min_length: int = Field(type=int, required=True, mutable=False)
    send_permanent_lockout_notification: bool = Field(type=bool, required=True, mutable=False)
    permanent_lockout_notify_email_address: str = Field(
        type=str, required=False, mutable=False,
    )
    endpoint_authentication_lockout_type: str = Field(type=str, required=True, mutable=False)
    endpoint_temporary_lockout_threshold: int = Field(type=int, required=True, mutable=False)
    endpoint_wait_algorithm: str = Field(type=str, required=True, mutable=False)
    endpoint_lockout_fixed_minutes: str = Field(type=str, required=True, mutable=False)
    endpoint_permanent_lockout_threshold: int = Field(type=int, required=True, mutable=False)
    trunk_group_temporary_lockout_threshold: int = Field(
        type=int, required=True, mutable=False,
    )
    trunk_group_authentication_lockout_type: str = Field(
        type=str, required=True, mutable=False,
    )
    trunk_group_wait_algorithm: str = Field(type=str, required=True, mutable=False)
    trunk_group_lockout_fixed_minutes: str = Field(type=str, required=True, mutable=False)
    trunk_group_permanent_lockout_threshold: int = Field(
        type=int, required=True, mutable=False,
    )


class ServiceProviderScheduleGetEventListResponse(OCIResponse):
    """
    Response to ``ServiceProviderScheduleGetEventListRequest()``.

    The response contains a list of events.

    Attributes:
        event_name: eventName
    """

    _ELEMENTS = (
        E("event_name", "eventName", str, is_array=True),
    )

    event_name: "List[str]" = Field(type=list, required=False, mutable=False)


class ServiceProviderServiceGetAuthorizationListResponse(OCIResponse):
    """
    Response to ``ServiceProviderServiceGetAuthorizationListRequest()``.

    Contains two tables, one for the group services and one for the user services.  The
    Group Service table has column headings: "Service Name", "Authorized", "Assigned",
    "Limited", "Quantity", "Allocated", "Licensed", "Service Pack Allocation" The User
    Service table has column headings: "Service Name", "Authorized", "Assigned",
    "Limited", "Quantity", "Allocated", "Licensed", "Service Pack Allocation", "User
    Assignable", "Service Pack Assignable".

    Attributes:
        group_services_authorization_table: groupServicesAuthorizationTable
        user_services_authorization_table: userServicesAuthorizationTable
    """

    _ELEMENTS = (
        E(
            "group_services_authorization_table", "groupServicesAuthorizationTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
        E(
            "user_services_authorization_table", "userServicesAuthorizationTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    group_services_authorization_table: "list" = Field(
        type=list, required=True, mutable=False,
    )
    user_services_authorization_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderServiceGetUserAssignableListResponse(OCIResponse):
    """
    Response to ``ServiceProviderServiceGetUserAssignableListRequest()``.


    Attributes:
        service_name: serviceName
    """

    _ELEMENTS = (
        E("service_name", "serviceName", str, is_array=True),
    )

    service_name: "List[str]" = Field(type=list, required=False, mutable=False)


class ServiceProviderServicePackGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderServicePackGetListRequest()``.


    Attributes:
        service_pack_name: servicePackName
    """

    _ELEMENTS = (
        E("service_pack_name", "servicePackName", str, is_array=True),
    )

    service_pack_name: "List[str]" = Field(type=list, required=False, mutable=False)


class ServiceProviderServicePackGetServiceUsageListResponse(OCIResponse):
    """
    Response to ``ServiceProviderServicePackGetServiceUsageListRequest()``.

    The column headings are "Service Pack Name", "Total Packs" and "Allocated to Groups"

    Attributes:
        service_usage_table: serviceUsageTable
    """

    _ELEMENTS = (
        E(
            "service_usage_table", "serviceUsageTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    service_usage_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderServicePackGetUtilizationListResponse(OCIResponse):
    """
    Response to ``ServiceProviderServicePackGetUtilizationListRequest()``.

    For each service pack, a table of groups utilizing the pack is returned.  The
    utilization table column headings are "Group", "Total Packs" and "Assigned".

    Attributes:
        service_pack_name: servicePackName
        service_utilization_table: serviceUtilizationTable
    """

    _ELEMENTS = (
        E("service_pack_name", "servicePackName", str, is_array=True),
        E(
            "service_utilization_table", "serviceUtilizationTable", list, is_complex=True,
            is_array=True, is_table=True,
        ),
    )

    service_pack_name: "List[str]" = Field(type=list, required=False, mutable=False)
    service_utilization_table: "List[list]" = Field(type=list, required=False, mutable=False)


class ServiceProviderServicePackMigrationTaskGetAvailableGroupListResponse(OCIResponse):
    """
    Response to ``ServiceProviderServicePackMigrationTaskGetAvailableGroupListRequest()``.

    The groupTable column headings are: "Group Id", "Group Name", "User Count".

    Attributes:
        group_table: groupTable
    """

    _ELEMENTS = (
        E(
            "group_table", "groupTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    group_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderServicePackMigrationTaskGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderServicePackMigrationTaskGetListRequest()``.

    Contains a table with a row for each service pack migration task and column headings :
    "Start Timestamp Milliseconds", "Name", "Status", "Error Count", "Users Processed",
    "Users Total". The start timestamp column is the number of milliseconds since the
    standard base time known as "the epoch", namely January 1, 1970, 00:00:00 GMT.

    Attributes:
        task_table: taskTable
    """

    _ELEMENTS = (
        E("task_table", "taskTable", list, is_complex=True, is_required=True, is_table=True),
    )

    task_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderServicePackMigrationTaskGetListResponse21(OCIResponse):
    """
    Response to ``ServiceProviderServicePackMigrationTaskGetListRequest21()``.

    Contains a table with a row for each service pack migration task and column headings :
    "Start Timestamp Milliseconds", "Name", "Status", "Error Count", "Users Processed",
    "Users Total". The start timestamp column is the number of milliseconds since the
    standard base time known as "the epoch", namely January 1, 1970, 00:00:00 GMT. The
    status column is the task status which can be Awaiting edit, Pending, Processing,
    Terminating, Terminated, Stopped by system, Completed, or Expired.

    Attributes:
        task_table: taskTable
    """

    _ELEMENTS = (
        E("task_table", "taskTable", list, is_complex=True, is_required=True, is_table=True),
    )

    task_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderServicePackMigrationTaskGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderServicePackMigrationTaskGetRequest()``.

    The groupTable column headings are: "Migrate", "Group Id", "Group Name", "User Count".

    Replaced By: ``ServiceProviderServicePackMigrationTaskGetResponse14sp4()``

    Attributes:
        task_name: taskName
        start_timestamp: startTimestamp
        max_duration_hours: maxDurationHours
        send_report_email: sendReportEmail
        report_delivery_email_address: reportDeliveryEmailAddress
        abort_on_error: abortOnError
        abort_error_threshold: abortErrorThreshold
        report_all_users: reportAllUsers
        automatically_increment_service_quantity: automaticallyIncrementServiceQuantity
        error_count: errorCount
        status: status
        groups_processed: groupsProcessed
        groups_total: groupsTotal
        users_processed: usersProcessed
        users_total: usersTotal
        user_selection_type: userSelectionType
        report_file_path_name: reportFilePathName
        group_table: groupTable
        user_selection_service_pack_name: userSelectionServicePackName
        user_selection_service_name: userSelectionServiceName
        remove_service_pack_name: removeServicePackName
        remove_service_name: removeServiceName
        assign_service_pack_name: assignServicePackName
        assign_service_name: assignServiceName
    """

    _ELEMENTS = (
        E("task_name", "taskName", str, is_required=True),
        E("start_timestamp", "startTimestamp", str),
        E("max_duration_hours", "maxDurationHours", int, is_required=True),
        E("send_report_email", "sendReportEmail", bool, is_required=True),
        E("report_delivery_email_address", "reportDeliveryEmailAddress", str),
        E("abort_on_error", "abortOnError", bool, is_required=True),
        E("abort_error_threshold", "abortErrorThreshold", int),
        E("report_all_users", "reportAllUsers", bool, is_required=True),
        E(
            "automatically_increment_service_quantity",
            "automaticallyIncrementServiceQuantity", bool, is_required=True,
        ),
        E("error_count", "errorCount", int, is_required=True),
        E("status", "status", str, is_required=True),
        E("groups_processed", "groupsProcessed", int, is_required=True),
        E("groups_total", "groupsTotal", int, is_required=True),
        E("users_processed", "usersProcessed", int, is_required=True),
        E("users_total", "usersTotal", int, is_required=True),
        E("user_selection_type", "userSelectionType", str, is_required=True),
        E("report_file_path_name", "reportFilePathName", str, is_required=True),
        E(
            "group_table", "groupTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
        E(
            "user_selection_service_pack_name", "userSelectionServicePackName", str,
            is_array=True,
        ),
        E("user_selection_service_name", "userSelectionServiceName", str, is_array=True),
        E("remove_service_pack_name", "removeServicePackName", str, is_array=True),
        E("remove_service_name", "removeServiceName", str, is_array=True),
        E("assign_service_pack_name", "assignServicePackName", str, is_array=True),
        E("assign_service_name", "assignServiceName", str, is_array=True),
    )

    task_name: str = Field(type=str, required=True, mutable=False)
    start_timestamp: str = Field(type=str, required=False, mutable=False)
    max_duration_hours: int = Field(type=int, required=True, mutable=False)
    send_report_email: bool = Field(type=bool, required=True, mutable=False)
    report_delivery_email_address: str = Field(type=str, required=False, mutable=False)
    abort_on_error: bool = Field(type=bool, required=True, mutable=False)
    abort_error_threshold: int = Field(type=int, required=False, mutable=False)
    report_all_users: bool = Field(type=bool, required=True, mutable=False)
    automatically_increment_service_quantity: bool = Field(
        type=bool, required=True, mutable=False,
    )
    error_count: int = Field(type=int, required=True, mutable=False)
    status: str = Field(type=str, required=True, mutable=False)
    groups_processed: int = Field(type=int, required=True, mutable=False)
    groups_total: int = Field(type=int, required=True, mutable=False)
    users_processed: int = Field(type=int, required=True, mutable=False)
    users_total: int = Field(type=int, required=True, mutable=False)
    user_selection_type: str = Field(type=str, required=True, mutable=False)
    report_file_path_name: str = Field(type=str, required=True, mutable=False)
    group_table: "list" = Field(type=list, required=True, mutable=False)
    user_selection_service_pack_name: "List[str]" = Field(
        type=list, required=False, mutable=False,
    )
    user_selection_service_name: "List[str]" = Field(type=list, required=False, mutable=False)
    remove_service_pack_name: "List[str]" = Field(type=list, required=False, mutable=False)
    remove_service_name: "List[str]" = Field(type=list, required=False, mutable=False)
    assign_service_pack_name: "List[str]" = Field(type=list, required=False, mutable=False)
    assign_service_name: "List[str]" = Field(type=list, required=False, mutable=False)


class ServiceProviderServicePackMigrationTaskGetResponse14sp4(OCIResponse):
    """
    Response to ``ServiceProviderServicePackMigrationTaskGetRequest14sp4()``.

    The groupTable column headings are: "Group Id", "Group Name", "User Count".

    Attributes:
        task_name: taskName
        start_timestamp: startTimestamp
        max_duration_hours: maxDurationHours
        send_report_email: sendReportEmail
        report_delivery_email_address: reportDeliveryEmailAddress
        abort_on_error: abortOnError
        abort_error_threshold: abortErrorThreshold
        report_all_users: reportAllUsers
        automatically_increment_service_quantity: automaticallyIncrementServiceQuantity
        error_count: errorCount
        status: status
        groups_processed: groupsProcessed
        groups_total: groupsTotal
        users_processed: usersProcessed
        users_total: usersTotal
        user_selection_type: userSelectionType
        report_file_path_name: reportFilePathName
        migrate_all_groups: migrateAllGroups
        group_table: groupTable
        user_selection_service_pack_name: userSelectionServicePackName
        user_selection_service_name: userSelectionServiceName
        remove_service_pack_name: removeServicePackName
        remove_service_name: removeServiceName
        assign_service_pack_name: assignServicePackName
        assign_service_name: assignServiceName
    """

    _ELEMENTS = (
        E("task_name", "taskName", str, is_required=True),
        E("start_timestamp", "startTimestamp", str),
        E("max_duration_hours", "maxDurationHours", int, is_required=True),
        E("send_report_email", "sendReportEmail", bool, is_required=True),
        E("report_delivery_email_address", "reportDeliveryEmailAddress", str),
        E("abort_on_error", "abortOnError", bool, is_required=True),
        E("abort_error_threshold", "abortErrorThreshold", int),
        E("report_all_users", "reportAllUsers", bool, is_required=True),
        E(
            "automatically_increment_service_quantity",
            "automaticallyIncrementServiceQuantity", bool, is_required=True,
        ),
        E("error_count", "errorCount", int, is_required=True),
        E("status", "status", str, is_required=True),
        E("groups_processed", "groupsProcessed", int, is_required=True),
        E("groups_total", "groupsTotal", int, is_required=True),
        E("users_processed", "usersProcessed", int, is_required=True),
        E("users_total", "usersTotal", int, is_required=True),
        E("user_selection_type", "userSelectionType", str, is_required=True),
        E("report_file_path_name", "reportFilePathName", str, is_required=True),
        E("migrate_all_groups", "migrateAllGroups", bool),
        E("group_table", "groupTable", list, is_complex=True, is_table=True),
        E(
            "user_selection_service_pack_name", "userSelectionServicePackName", str,
            is_array=True,
        ),
        E("user_selection_service_name", "userSelectionServiceName", str, is_array=True),
        E("remove_service_pack_name", "removeServicePackName", str, is_array=True),
        E("remove_service_name", "removeServiceName", str, is_array=True),
        E("assign_service_pack_name", "assignServicePackName", str, is_array=True),
        E("assign_service_name", "assignServiceName", str, is_array=True),
    )

    task_name: str = Field(type=str, required=True, mutable=False)
    start_timestamp: str = Field(type=str, required=False, mutable=False)
    max_duration_hours: int = Field(type=int, required=True, mutable=False)
    send_report_email: bool = Field(type=bool, required=True, mutable=False)
    report_delivery_email_address: str = Field(type=str, required=False, mutable=False)
    abort_on_error: bool = Field(type=bool, required=True, mutable=False)
    abort_error_threshold: int = Field(type=int, required=False, mutable=False)
    report_all_users: bool = Field(type=bool, required=True, mutable=False)
    automatically_increment_service_quantity: bool = Field(
        type=bool, required=True, mutable=False,
    )
    error_count: int = Field(type=int, required=True, mutable=False)
    status: str = Field(type=str, required=True, mutable=False)
    groups_processed: int = Field(type=int, required=True, mutable=False)
    groups_total: int = Field(type=int, required=True, mutable=False)
    users_processed: int = Field(type=int, required=True, mutable=False)
    users_total: int = Field(type=int, required=True, mutable=False)
    user_selection_type: str = Field(type=str, required=True, mutable=False)
    report_file_path_name: str = Field(type=str, required=True, mutable=False)
    migrate_all_groups: bool = Field(type=bool, required=False, mutable=False)
    group_table: "list" = Field(type=list, required=False, mutable=False)
    user_selection_service_pack_name: "List[str]" = Field(
        type=list, required=False, mutable=False,
    )
    user_selection_service_name: "List[str]" = Field(type=list, required=False, mutable=False)
    remove_service_pack_name: "List[str]" = Field(type=list, required=False, mutable=False)
    remove_service_name: "List[str]" = Field(type=list, required=False, mutable=False)
    assign_service_pack_name: "List[str]" = Field(type=list, required=False, mutable=False)
    assign_service_name: "List[str]" = Field(type=list, required=False, mutable=False)


class ServiceProviderServicePackMigrationTaskGetResponse21(OCIResponse):
    """
    Response to ``ServiceProviderServicePackMigrationTaskGetRequest21()``.

    The groupTable column headings are: "Group Id", "Group Name", and "User Count".

    Attributes:
        task_name: taskName
        start_timestamp: startTimestamp
        actual_start_timestamp: actualStartTimestamp
        expire_after_num_hours: expireAfterNumHours
        max_duration_hours: maxDurationHours
        send_report_email: sendReportEmail
        report_delivery_email_address: reportDeliveryEmailAddress
        abort_on_error: abortOnError
        abort_error_threshold: abortErrorThreshold
        report_all_users: reportAllUsers
        automatically_increment_service_quantity: automaticallyIncrementServiceQuantity
        error_count: errorCount
        status: status
        groups_processed: groupsProcessed
        groups_total: groupsTotal
        users_processed: usersProcessed
        users_total: usersTotal
        user_selection_type: userSelectionType
        report_file_path_name: reportFilePathName
        migrate_all_groups: migrateAllGroups
        group_table: groupTable
        user_selection_service_pack_name: userSelectionServicePackName
        user_selection_service_name: userSelectionServiceName
        remove_service_pack_name: removeServicePackName
        remove_service_name: removeServiceName
        assign_service_pack_name: assignServicePackName
        assign_service_name: assignServiceName
    """

    _ELEMENTS = (
        E("task_name", "taskName", str, is_required=True),
        E("start_timestamp", "startTimestamp", str),
        E("actual_start_timestamp", "actualStartTimestamp", str),
        E("expire_after_num_hours", "expireAfterNumHours", int, is_required=True),
        E("max_duration_hours", "maxDurationHours", int, is_required=True),
        E("send_report_email", "sendReportEmail", bool, is_required=True),
        E("report_delivery_email_address", "reportDeliveryEmailAddress", str),
        E("abort_on_error", "abortOnError", bool, is_required=True),
        E("abort_error_threshold", "abortErrorThreshold", int),
        E("report_all_users", "reportAllUsers", bool, is_required=True),
        E(
            "automatically_increment_service_quantity",
            "automaticallyIncrementServiceQuantity", bool, is_required=True,
        ),
        E("error_count", "errorCount", int, is_required=True),
        E("status", "status", str, is_required=True),
        E("groups_processed", "groupsProcessed", int, is_required=True),
        E("groups_total", "groupsTotal", int, is_required=True),
        E("users_processed", "usersProcessed", int, is_required=True),
        E("users_total", "usersTotal", int, is_required=True),
        E("user_selection_type", "userSelectionType", str, is_required=True),
        E("report_file_path_name", "reportFilePathName", str, is_required=True),
        E("migrate_all_groups", "migrateAllGroups", bool),
        E("group_table", "groupTable", list, is_complex=True, is_table=True),
        E(
            "user_selection_service_pack_name", "userSelectionServicePackName", str,
            is_array=True,
        ),
        E("user_selection_service_name", "userSelectionServiceName", str, is_array=True),
        E("remove_service_pack_name", "removeServicePackName", str, is_array=True),
        E("remove_service_name", "removeServiceName", str, is_array=True),
        E("assign_service_pack_name", "assignServicePackName", str, is_array=True),
        E("assign_service_name", "assignServiceName", str, is_array=True),
    )

    task_name: str = Field(type=str, required=True, mutable=False)
    start_timestamp: str = Field(type=str, required=False, mutable=False)
    actual_start_timestamp: str = Field(type=str, required=False, mutable=False)
    expire_after_num_hours: int = Field(type=int, required=True, mutable=False)
    max_duration_hours: int = Field(type=int, required=True, mutable=False)
    send_report_email: bool = Field(type=bool, required=True, mutable=False)
    report_delivery_email_address: str = Field(type=str, required=False, mutable=False)
    abort_on_error: bool = Field(type=bool, required=True, mutable=False)
    abort_error_threshold: int = Field(type=int, required=False, mutable=False)
    report_all_users: bool = Field(type=bool, required=True, mutable=False)
    automatically_increment_service_quantity: bool = Field(
        type=bool, required=True, mutable=False,
    )
    error_count: int = Field(type=int, required=True, mutable=False)
    status: str = Field(type=str, required=True, mutable=False)
    groups_processed: int = Field(type=int, required=True, mutable=False)
    groups_total: int = Field(type=int, required=True, mutable=False)
    users_processed: int = Field(type=int, required=True, mutable=False)
    users_total: int = Field(type=int, required=True, mutable=False)
    user_selection_type: str = Field(type=str, required=True, mutable=False)
    report_file_path_name: str = Field(type=str, required=True, mutable=False)
    migrate_all_groups: bool = Field(type=bool, required=False, mutable=False)
    group_table: "list" = Field(type=list, required=False, mutable=False)
    user_selection_service_pack_name: "List[str]" = Field(
        type=list, required=False, mutable=False,
    )
    user_selection_service_name: "List[str]" = Field(type=list, required=False, mutable=False)
    remove_service_pack_name: "List[str]" = Field(type=list, required=False, mutable=False)
    remove_service_name: "List[str]" = Field(type=list, required=False, mutable=False)
    assign_service_pack_name: "List[str]" = Field(type=list, required=False, mutable=False)
    assign_service_name: "List[str]" = Field(type=list, required=False, mutable=False)


class ServiceProviderServicePhoneNumberLookupResponse(OCIResponse):
    """
    Response to the ``ServiceProviderServicePhoneNumberLookupRequest()``.

    The column headings for the userTable are: "Group Id", "User Id", "Last Name", "First
    Name", "Hiragana Last Name", "Hiragana First Name", "Phone Number", "Extension" and
    "Department".

    Attributes:
        user_table: userTable
    """

    _ELEMENTS = (
        E("user_table", "userTable", list, is_complex=True, is_required=True, is_table=True),
    )

    user_table: "list" = Field(type=list, required=True, mutable=False)


class ServiceProviderSessionAdmissionControlGetResponse(OCIResponse):
    """
    Response to the ``ServiceProviderSessionAdmissionControlGetRequest()``.

    The response contains the session admission control capacity allocated for the service
    provider.

    Attributes:
        restrict_aggregate_sessions: restrictAggregateSessions
        max_sessions: maxSessions
        max_user_originating_sessions: maxUserOriginatingSessions
        max_user_terminating_sessions: maxUserTerminatingSessions
        count_intra_service_provider_sessions: countIntraServiceProviderSessions
    """

    _ELEMENTS = (
        E("restrict_aggregate_sessions", "restrictAggregateSessions", bool, is_required=True),
        E("max_sessions", "maxSessions", int),
        E("max_user_originating_sessions", "maxUserOriginatingSessions", int),
        E("max_user_terminating_sessions", "maxUserTerminatingSessions", int),
        E(
            "count_intra_service_provider_sessions", "countIntraServiceProviderSessions",
            bool, is_required=True,
        ),
    )

    restrict_aggregate_sessions: bool = Field(type=bool, required=True, mutable=False)
    max_sessions: int = Field(type=int, required=False, mutable=False)
    max_user_originating_sessions: int = Field(type=int, required=False, mutable=False)
    max_user_terminating_sessions: int = Field(type=int, required=False, mutable=False)
    count_intra_service_provider_sessions: bool = Field(
        type=bool, required=True, mutable=False,
    )


class ServiceProviderSessionAdmissionControlWhiteListGetResponse(OCIResponse):
    """
    Response to the ``ServiceProviderSessionAdmissionControlWhiteListGetRequest()``.

    The response contains the White List information.

    Attributes:
        match_digit_pattern: matchDigitPattern
        enable_white_list: enableWhiteList
    """

    _ELEMENTS = (
        E("match_digit_pattern", "matchDigitPattern", str, is_array=True),
        E("enable_white_list", "enableWhiteList", bool, is_required=True),
    )

    match_digit_pattern: "List[str]" = Field(type=list, required=False, mutable=False)
    enable_white_list: bool = Field(type=bool, required=True, mutable=False)


class ServiceProviderVoiceMessagingGroupGetPasscodeRulesResponse(OCIResponse):
    """
    Response to ``ServiceProviderVoiceMessagingGroupGetPasscodeRulesRequest()``.

    Contains the service provider's voice portal passcode rules setting.

    Replaced By: ``ServiceProviderPortalPasscodeRulesGetResponse()``

    Attributes:
        disallow_repeated_digits: disallowRepeatedDigits
        disallow_user_number: disallowUserNumber
        disallow_reversed_user_number: disallowReversedUserNumber
        disallow_old_passcode: disallowOldPasscode
        disallow_reversed_old_passcode: disallowReversedOldPasscode
        min_code_length: minCodeLength
        max_code_length: maxCodeLength
        disable_login_after_max_failed_login_attempts:
            disableLoginAfterMaxFailedLoginAttempts
        max_failed_login_attempts: maxFailedLoginAttempts
        expire_password: expirePassword
        passcode_expires_days: passcodeExpiresDays
        send_login_disabled_notify_email: sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address: loginDisabledNotifyEmailAddress
    """

    _ELEMENTS = (
        E("disallow_repeated_digits", "disallowRepeatedDigits", bool, is_required=True),
        E("disallow_user_number", "disallowUserNumber", bool, is_required=True),
        E(
            "disallow_reversed_user_number", "disallowReversedUserNumber", bool,
            is_required=True,
        ),
        E("disallow_old_passcode", "disallowOldPasscode", bool, is_required=True),
        E(
            "disallow_reversed_old_passcode", "disallowReversedOldPasscode", bool,
            is_required=True,
        ),
        E("min_code_length", "minCodeLength", int, is_required=True),
        E("max_code_length", "maxCodeLength", int, is_required=True),
        E(
            "disable_login_after_max_failed_login_attempts",
            "disableLoginAfterMaxFailedLoginAttempts", bool, is_required=True,
        ),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int),
        E("expire_password", "expirePassword", bool, is_required=True),
        E("passcode_expires_days", "passcodeExpiresDays", int),
        E(
            "send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool,
            is_required=True,
        ),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
    )

    disallow_repeated_digits: bool = Field(type=bool, required=True, mutable=False)
    disallow_user_number: bool = Field(type=bool, required=True, mutable=False)
    disallow_reversed_user_number: bool = Field(type=bool, required=True, mutable=False)
    disallow_old_passcode: bool = Field(type=bool, required=True, mutable=False)
    disallow_reversed_old_passcode: bool = Field(type=bool, required=True, mutable=False)
    min_code_length: int = Field(type=int, required=True, mutable=False)
    max_code_length: int = Field(type=int, required=True, mutable=False)
    disable_login_after_max_failed_login_attempts: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_failed_login_attempts: int = Field(type=int, required=False, mutable=False)
    expire_password: bool = Field(type=bool, required=True, mutable=False)
    passcode_expires_days: int = Field(type=int, required=False, mutable=False)
    send_login_disabled_notify_email: bool = Field(type=bool, required=True, mutable=False)
    login_disabled_notify_email_address: str = Field(type=str, required=False, mutable=False)


class ServiceProviderVoiceMessagingGroupGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderVoiceMessagingGroupGetRequest()``.

    Contains the service provider's or enterprise's voice messaging settings.

    Attributes:
        delivery_from_address: deliveryFromAddress
        notification_from_address: notificationFromAddress
        voice_portal_lockout_from_address: voicePortalLockoutFromAddress
        use_system_default_delivery_from_address: useSystemDefaultDeliveryFromAddress
        use_system_default_notification_from_address:
            useSystemDefaultNotificationFromAddress
        use_system_default_voice_portal_lockout_from_address:
            useSystemDefaultVoicePortalLockoutFromAddress
    """

    _ELEMENTS = (
        E("delivery_from_address", "deliveryFromAddress", str),
        E("notification_from_address", "notificationFromAddress", str),
        E("voice_portal_lockout_from_address", "voicePortalLockoutFromAddress", str),
        E(
            "use_system_default_delivery_from_address",
            "useSystemDefaultDeliveryFromAddress", bool, is_required=True,
        ),
        E(
            "use_system_default_notification_from_address",
            "useSystemDefaultNotificationFromAddress", bool, is_required=True,
        ),
        E(
            "use_system_default_voice_portal_lockout_from_address",
            "useSystemDefaultVoicePortalLockoutFromAddress", bool, is_required=True,
        ),
    )

    delivery_from_address: str = Field(type=str, required=False, mutable=False)
    notification_from_address: str = Field(type=str, required=False, mutable=False)
    voice_portal_lockout_from_address: str = Field(type=str, required=False, mutable=False)
    use_system_default_delivery_from_address: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_system_default_notification_from_address: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_system_default_voice_portal_lockout_from_address: bool = Field(
        type=bool, required=True, mutable=False,
    )


class ServiceProviderVoiceMessagingGroupGetVoicePortalBrandingResponse(OCIResponse):
    """
    Response to the ``ServiceProviderVoiceMessagingGroupGetVoicePortalBrandingRequest()``.

    Replaced By: ``ServiceProviderVoiceMessagingGroupGetVoicePortalBrandingResponse16()``

    Attributes:
        voice_portal_greeting_selection: voicePortalGreetingSelection
        voice_portal_greeting_file_description: voicePortalGreetingFileDescription
        voice_messaging_greeting_selection: voiceMessagingGreetingSelection
        voice_messaging_greeting_file_description: voiceMessagingGreetingFileDescription
    """

    _ELEMENTS = (
        E(
            "voice_portal_greeting_selection", "voicePortalGreetingSelection", str,
            is_required=True,
        ),
        E(
            "voice_portal_greeting_file_description",
            "voicePortalGreetingFileDescription", str,
        ),
        E(
            "voice_messaging_greeting_selection", "voiceMessagingGreetingSelection", str,
            is_required=True,
        ),
        E(
            "voice_messaging_greeting_file_description",
            "voiceMessagingGreetingFileDescription", str,
        ),
    )

    voice_portal_greeting_selection: str = Field(type=str, required=True, mutable=False)
    voice_portal_greeting_file_description: str = Field(
        type=str, required=False, mutable=False,
    )
    voice_messaging_greeting_selection: str = Field(type=str, required=True, mutable=False)
    voice_messaging_greeting_file_description: str = Field(
        type=str, required=False, mutable=False,
    )


class ServiceProviderVoiceMessagingGroupGetVoicePortalBrandingResponse16(OCIResponse):
    """
    Response to the
    ``ServiceProviderVoiceMessagingGroupGetVoicePortalBrandingRequest16()``.


    Attributes:
        voice_portal_greeting_selection: voicePortalGreetingSelection
        voice_portal_greeting_file_description: voicePortalGreetingFileDescription
        voice_portal_greeting_media_file_type: voicePortalGreetingMediaFileType
        voice_messaging_greeting_selection: voiceMessagingGreetingSelection
        voice_messaging_greeting_file_description: voiceMessagingGreetingFileDescription
        voice_messaging_greeting_media_file_type: voiceMessagingGreetingMediaFileType
    """

    _ELEMENTS = (
        E(
            "voice_portal_greeting_selection", "voicePortalGreetingSelection", str,
            is_required=True,
        ),
        E(
            "voice_portal_greeting_file_description",
            "voicePortalGreetingFileDescription", str,
        ),
        E("voice_portal_greeting_media_file_type", "voicePortalGreetingMediaFileType", str),
        E(
            "voice_messaging_greeting_selection", "voiceMessagingGreetingSelection", str,
            is_required=True,
        ),
        E(
            "voice_messaging_greeting_file_description",
            "voiceMessagingGreetingFileDescription", str,
        ),
        E(
            "voice_messaging_greeting_media_file_type",
            "voiceMessagingGreetingMediaFileType", str,
        ),
    )

    voice_portal_greeting_selection: str = Field(type=str, required=True, mutable=False)
    voice_portal_greeting_file_description: str = Field(
        type=str, required=False, mutable=False,
    )
    voice_portal_greeting_media_file_type: str = Field(
        type=str, required=False, mutable=False,
    )
    voice_messaging_greeting_selection: str = Field(type=str, required=True, mutable=False)
    voice_messaging_greeting_file_description: str = Field(
        type=str, required=False, mutable=False,
    )
    voice_messaging_greeting_media_file_type: str = Field(
        type=str, required=False, mutable=False,
    )


class ServiceProviderVoiceMessagingGroupGetVoicePortalResponse(OCIResponse):
    """
    Response to ``ServiceProviderVoiceMessagingGroupGetVoicePortalRequest()``.


    Attributes:
        voice_portal_scope: voicePortalScope
    """

    _ELEMENTS = (
        E("voice_portal_scope", "voicePortalScope", str, is_required=True),
    )

    voice_portal_scope: str = Field(type=str, required=True, mutable=False)


class ServiceProviderZoneCallingRestrictionsGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderZoneCallingRestrictionsGetRequest()``

    Attributes:
        enable_zone_calling_restrictions: enableZoneCallingRestrictions
        enable_origination_roaming_restrictions: enableOriginationRoamingRestrictions
        enable_emergency_origination_roaming_restrictions:
            enableEmergencyOriginationRoamingRestrictions
        enable_termination_roaming_restrictions: enableTerminationRoamingRestrictions
    """

    _ELEMENTS = (
        E(
            "enable_zone_calling_restrictions", "enableZoneCallingRestrictions", bool,
            is_required=True,
        ),
        E(
            "enable_origination_roaming_restrictions",
            "enableOriginationRoamingRestrictions", bool, is_required=True,
        ),
        E(
            "enable_emergency_origination_roaming_restrictions",
            "enableEmergencyOriginationRoamingRestrictions", bool, is_required=True,
        ),
        E(
            "enable_termination_roaming_restrictions",
            "enableTerminationRoamingRestrictions", bool, is_required=True,
        ),
    )

    enable_zone_calling_restrictions: bool = Field(type=bool, required=True, mutable=False)
    enable_origination_roaming_restrictions: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_emergency_origination_roaming_restrictions: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_termination_roaming_restrictions: bool = Field(
        type=bool, required=True, mutable=False,
    )


class SystemASRParametersGetResponse(OCIResponse):
    """
    Response to ``SystemASRParametersGetRequest()``.

    Contains a list of system Application Server Registration parameters.

    Replaced By: ``SystemASRParametersGetResponse14sp5()``

    Attributes:
        max_transmissions: maxTransmissions
        retransmission_delay_milli_seconds: retransmissionDelayMilliSeconds
        listening_port: listeningPort
    """

    _ELEMENTS = (
        E("max_transmissions", "maxTransmissions", int, is_required=True),
        E(
            "retransmission_delay_milli_seconds", "retransmissionDelayMilliSeconds", int,
            is_required=True,
        ),
        E("listening_port", "listeningPort", int, is_required=True),
    )

    max_transmissions: int = Field(type=int, required=True, mutable=False)
    retransmission_delay_milli_seconds: int = Field(type=int, required=True, mutable=False)
    listening_port: int = Field(type=int, required=True, mutable=False)


class SystemASRParametersGetResponse14sp5(OCIResponse):
    """
    Response to ``SystemASRParametersGetRequest14sp5()``.

    Contains a list of system Application Server Registration parameters.

    Attributes:
        max_transmissions: maxTransmissions
        retransmission_delay_milli_seconds: retransmissionDelayMilliSeconds
        listening_port: listeningPort
        source_address: sourceAddress
    """

    _ELEMENTS = (
        E("max_transmissions", "maxTransmissions", int, is_required=True),
        E(
            "retransmission_delay_milli_seconds", "retransmissionDelayMilliSeconds", int,
            is_required=True,
        ),
        E("listening_port", "listeningPort", int, is_required=True),
        E("source_address", "sourceAddress", str),
    )

    max_transmissions: int = Field(type=int, required=True, mutable=False)
    retransmission_delay_milli_seconds: int = Field(type=int, required=True, mutable=False)
    listening_port: int = Field(type=int, required=True, mutable=False)
    source_address: str = Field(type=str, required=False, mutable=False)


class SystemASRParametersGetResponse14sp7(OCIResponse):
    """
    Response to ``SystemASRParametersGetRequest14sp7()``.

    Contains a list of system Application Server Registration parameters.

    Attributes:
        max_transmissions: maxTransmissions
        retransmission_delay_milli_seconds: retransmissionDelayMilliSeconds
        listening_port: listeningPort
    """

    _ELEMENTS = (
        E("max_transmissions", "maxTransmissions", int, is_required=True),
        E(
            "retransmission_delay_milli_seconds", "retransmissionDelayMilliSeconds", int,
            is_required=True,
        ),
        E("listening_port", "listeningPort", int, is_required=True),
    )

    max_transmissions: int = Field(type=int, required=True, mutable=False)
    retransmission_delay_milli_seconds: int = Field(type=int, required=True, mutable=False)
    listening_port: int = Field(type=int, required=True, mutable=False)


class SystemAccessDeviceCustomTagGetListResponse(OCIResponse):
    """
    Response to ``SystemAccessDeviceCustomTagGetListRequest()``.

    Contains a table of custom configuration tags managed by the Device Management System
    on a per-device profile basis.  The column headings are: "Tag Name", "Tag Value"

    Attributes:
        device_custom_tags_table: deviceCustomTagsTable
    """

    _ELEMENTS = (
        E(
            "device_custom_tags_table", "deviceCustomTagsTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    device_custom_tags_table: "list" = Field(type=list, required=True, mutable=False)


class SystemAccessDeviceFileGetListResponse(OCIResponse):
    """
    Response to ``SystemAccessDeviceFileGetListRequest()``.

    Contains a table of device files managed by the Device Management System on a per-
    device profile basis.  The column headings are: "File Type", "File Format", "Is
    Authenticated".

    Replaced By: ``SystemAccessDeviceFileGetListResponse14sp8()``

    Attributes:
        device_files_table: deviceFilesTable
    """

    _ELEMENTS = (
        E(
            "device_files_table", "deviceFilesTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    device_files_table: "list" = Field(type=list, required=True, mutable=False)


class SystemAccessDeviceFileGetListResponse14sp8(OCIResponse):
    """
    Response to ``SystemAccessDeviceFileGetListRequest14sp8()``.

    Contains a table of device files managed by the Device Management System on a per-
    device profile basis.  The column headings are: "File Format", "Is Authenticated",
    "Access URL", "Repository URL", "Template URL", "Extended Capture". The following
    columns are only used in AS data mode: "Extended Capture"

    Attributes:
        device_files_table: deviceFilesTable
    """

    _ELEMENTS = (
        E(
            "device_files_table", "deviceFilesTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    device_files_table: "list" = Field(type=list, required=True, mutable=False)


class SystemAccessDeviceFileGetResponse(OCIResponse):
    """
    Response to ``SystemAccessDeviceFileGetRequest()``.

    Replaced By: ``SystemAccessDeviceFileGetResponse14sp8()``

    Attributes:
        file_source: fileSource
        configuration_file_name: configurationFileName
    """

    _ELEMENTS = (
        E("file_source", "fileSource", str, is_required=True),
        E("configuration_file_name", "configurationFileName", str),
    )

    file_source: str = Field(type=str, required=True, mutable=False)
    configuration_file_name: str = Field(type=str, required=False, mutable=False)


class SystemAccessDeviceFileGetResponse14sp8(OCIResponse):
    """
    Response to ``SystemAccessDeviceFileGetRequest14sp8()``.

    Replaced by: ``SystemAccessDeviceFileGetResponse16sp1()``

    Attributes:
        file_source: fileSource
        configuration_file_name: configurationFileName
    """

    _ELEMENTS = (
        E("file_source", "fileSource", str, is_required=True),
        E("configuration_file_name", "configurationFileName", str),
    )

    file_source: str = Field(type=str, required=True, mutable=False)
    configuration_file_name: str = Field(type=str, required=False, mutable=False)


class SystemAccessDeviceFileGetResponse16sp1(OCIResponse):
    """
    Response to ``SystemAccessDeviceFileGetRequest16sp1()``.


    Attributes:
        file_source: fileSource
        configuration_file_name: configurationFileName
        access_url: accessUrl
        repository_url: repositoryUrl
        template_url: templateUrl
    """

    _ELEMENTS = (
        E("file_source", "fileSource", str, is_required=True),
        E("configuration_file_name", "configurationFileName", str),
        E("access_url", "accessUrl", str, is_required=True),
        E("repository_url", "repositoryUrl", str),
        E("template_url", "templateUrl", str),
    )

    file_source: str = Field(type=str, required=True, mutable=False)
    configuration_file_name: str = Field(type=str, required=False, mutable=False)
    access_url: str = Field(type=str, required=True, mutable=False)
    repository_url: str = Field(type=str, required=False, mutable=False)
    template_url: str = Field(type=str, required=False, mutable=False)


class SystemAccessDeviceFileGetResponse20(OCIResponse):
    """
    Response to ``SystemAccessDeviceFileGetRequest20()``.


    Attributes:
        file_source: fileSource
        configuration_file_name: configurationFileName
        access_url: accessUrl
        repository_url: repositoryUrl
        template_url: templateUrl
        extended_capture_enabled: extendedCaptureEnabled
        extended_capture_url: extendedCaptureURL
    """

    _ELEMENTS = (
        E("file_source", "fileSource", str, is_required=True),
        E("configuration_file_name", "configurationFileName", str),
        E("access_url", "accessUrl", str, is_required=True),
        E("repository_url", "repositoryUrl", str),
        E("template_url", "templateUrl", str),
        E("extended_capture_enabled", "extendedCaptureEnabled", bool),
        E("extended_capture_url", "extendedCaptureURL", str),
    )

    file_source: str = Field(type=str, required=True, mutable=False)
    configuration_file_name: str = Field(type=str, required=False, mutable=False)
    access_url: str = Field(type=str, required=True, mutable=False)
    repository_url: str = Field(type=str, required=False, mutable=False)
    template_url: str = Field(type=str, required=False, mutable=False)
    extended_capture_enabled: bool = Field(type=bool, required=False, mutable=False)
    extended_capture_url: str = Field(type=str, required=False, mutable=False)


class SystemAccessDeviceGetAllResponse(OCIResponse):
    """
    Response to ``SystemAccessDeviceGetAllRequest()``.

    Contains a table of devices configured in the entire system.  The column headings are:
    "Service Provider Id", "Is Enterprise", "Group Id", "Device Name", "Device Type", "Net
    Address", "MAC Address", "Status".

    Attributes:
        access_device_table: accessDeviceTable
    """

    _ELEMENTS = (
        E(
            "access_device_table", "accessDeviceTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    access_device_table: "list" = Field(type=list, required=True, mutable=False)


class SystemAccessDeviceGetListResponse14(OCIResponse):
    """
    Response to ``SystemAccessDeviceGetListRequest14()``.

    Contains a table of devices defined at the System-level.  The column headings are:
    "Device Name", "Device Type", "Available Ports", "Net Address" and "MAC Address",
    "Status", "Version".

    Attributes:
        access_device_table: accessDeviceTable
    """

    _ELEMENTS = (
        E(
            "access_device_table", "accessDeviceTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    access_device_table: "list" = Field(type=list, required=True, mutable=False)


class SystemAccessDeviceGetUserListResponse(OCIResponse):
    """
    Response to ``SystemAccessDeviceGetUserListRequest()``.

    The column headings for the deviceUserTable are: "Line/Port", "Last Name", "First
    Name", "Phone Number", "Service Provider Id", "Group Id", "User Id", "User Type",
    "Endpoint Type", "Primary Line/Port", "Order", "Extension", "Department", "Email
    Address", "Private Identity". If the identity/device profile is an identity, the table
    will contain a row for each TEL-URI in the Phone Number column.  If the
    identity/device profile is a real device, rows for the alternate numbers are not
    included.  The User Type column contains one of the enumerated UserType values.  The
    Endpoint Type column contains one of the enumerated EndpointType values.  The Private
    Identity column is empty is AS mode.

    Attributes:
        device_user_table: deviceUserTable
    """

    _ELEMENTS = (
        E(
            "device_user_table", "deviceUserTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    device_user_table: "list" = Field(type=list, required=True, mutable=False)


class SystemAccessDeviceMonitorGetDeviceTypeListResponse(OCIResponse):
    """
    Response to ``SystemAccessDeviceMonitorGetDeviceTypeListRequest()``.


    Attributes:
        device_type: deviceType
    """

    _ELEMENTS = (
        E("device_type", "deviceType", str, is_array=True),
    )

    device_type: "List[str]" = Field(type=list, required=False, mutable=False)


class SystemAccessDeviceMonitorParametersGetResponse(OCIResponse):
    """
    Response to ``SystemAccessDeviceMonitorParametersGetListRequest()``.

    Contains a list of system Access Device Monitor parameters.

    Attributes:
        polling_interval_minutes: pollingIntervalMinutes
    """

    _ELEMENTS = (
        E("polling_interval_minutes", "pollingIntervalMinutes", int, is_required=True),
    )

    polling_interval_minutes: int = Field(type=int, required=True, mutable=False)


class SystemAccessDeviceTypeGetEnhancedConfigurableListResponse(OCIResponse):
    """
    Response to ``SystemAccessDeviceTypeGetEnhancedConfigurableListRequest()``.

    Contains a table with columns: "Access Device Type", "Enhanced Configuration Type",
    "Supports Reset". The "Enhanced Configuration Type" column contains one of the
    AccessDeviceEnhancedConfigurationType14 enumerated values.  The "Supports Reset"
    column is a boolean flag indicating the device can be remotely reset.

    Attributes:
        device_type_table: deviceTypeTable
    """

    _ELEMENTS = (
        E(
            "device_type_table", "deviceTypeTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    device_type_table: "list" = Field(type=list, required=True, mutable=False)


class SystemAccessDeviceTypeGetListResponse(OCIResponse):
    """
    Response to ``SystemAccessDeviceTypeGetListRequest()``.


    Attributes:
        device_type: deviceType
    """

    _ELEMENTS = (
        E("device_type", "deviceType", str, is_required=True),
    )

    device_type: str = Field(type=str, required=True, mutable=False)


class SystemAccountingGetChargingFunctionElementServerListResponse(OCIResponse):
    """
    Response to ``SystemAccountingGetChargingFunctionElementServerListRequest()``.

    The accounting charging function element Server table column headings are: "Address",
    "Extended Net Address", "Type", "Description".

    Attributes:
        charging_function_element_server_table: chargingFunctionElementServerTable
    """

    _ELEMENTS = (
        E(
            "charging_function_element_server_table",
            "chargingFunctionElementServerTable", list, is_complex=True, is_required=True,
            is_table=True,
        ),
    )

    charging_function_element_server_table: "list" = Field(
        type=list, required=True, mutable=False,
    )


class SystemAccountingGetRadiusServerListResponse(OCIResponse):
    """
    Response to ``SystemAccountingGetRadiusServerListRequest()``.

    The Radius Server table column headings are: "Net Address", "Port", "Description"

    Attributes:
        radius_server_table: radiusServerTable
    """

    _ELEMENTS = (
        E(
            "radius_server_table", "radiusServerTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    radius_server_table: "list" = Field(type=list, required=True, mutable=False)


class SystemAccountingInhibitedAttributeValuePairCodeGetListResponse(OCIResponse):
    """
    Response to ``SystemAccountingInhibitedAttributeValuePairCodeGetListRequest()``.

    Contains a 2 column table with column headings "Attribute Value Pair Code" and "Vendor
    Id".

    Attributes:
        inhibited_attribute_value_pair_code_table: inhibitedAttributeValuePairCodeTable
    """

    _ELEMENTS = (
        E(
            "inhibited_attribute_value_pair_code_table",
            "inhibitedAttributeValuePairCodeTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    inhibited_attribute_value_pair_code_table: "list" = Field(
        type=list, required=True, mutable=False,
    )


class SystemAdminGetListResponse(OCIResponse):
    """
    Response to ``SystemAdminGetListRequest()``.

    Contains a 6 column table with column headings "Administrator ID", "Last Name", "First
    Name", "Type", "Read Only", "Language".

    Attributes:
        system_admin_table: systemAdminTable
    """

    _ELEMENTS = (
        E(
            "system_admin_table", "systemAdminTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    system_admin_table: "list" = Field(type=list, required=True, mutable=False)


class SystemAdminGetResponse(OCIResponse):
    """
    Response to the ``SystemAdminGetRequest()``.

    The response contains the system or provisioning administrators profile information.

    Attributes:
        first_name: firstName
        last_name: lastName
        language: language
        admin_type: adminType
        read_only: readOnly
    """

    _ELEMENTS = (
        E("first_name", "firstName", str),
        E("last_name", "lastName", str),
        E("language", "language", str, is_required=True),
        E("admin_type", "adminType", str, is_required=True),
        E("read_only", "readOnly", bool, is_required=True),
    )

    first_name: str = Field(type=str, required=False, mutable=False)
    last_name: str = Field(type=str, required=False, mutable=False)
    language: str = Field(type=str, required=True, mutable=False)
    admin_type: str = Field(type=str, required=True, mutable=False)
    read_only: bool = Field(type=bool, required=True, mutable=False)


class SystemAdviceOfChargeCostInformationSourceGetListResponse(OCIResponse):
    """
    Response to ``SystemAdviceOfChargeCostInformationSourceGetListRequest()``.

    Contains a table with column headings: "PeerIdentity", "Priority"

    Attributes:
        cost_information_source_table: costInformationSourceTable
    """

    _ELEMENTS = (
        E(
            "cost_information_source_table", "costInformationSourceTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    cost_information_source_table: "list" = Field(type=list, required=True, mutable=False)


class SystemAdviceOfChargeGetResponse(OCIResponse):
    """
    Response to ``SystemAdviceOfChargeGetRequest()``.

    Contains a list of system Advice of Charge parameters.

    Attributes:
        delay_between_notification_seconds: delayBetweenNotificationSeconds
        incoming_aoc_handling: incomingAocHandling
        cost_information_source: costInformationSource
    """

    _ELEMENTS = (
        E(
            "delay_between_notification_seconds", "delayBetweenNotificationSeconds", int,
            is_required=True,
        ),
        E("incoming_aoc_handling", "incomingAocHandling", str, is_required=True),
        E("cost_information_source", "costInformationSource", str),
    )

    delay_between_notification_seconds: int = Field(type=int, required=True, mutable=False)
    incoming_aoc_handling: str = Field(type=str, required=True, mutable=False)
    cost_information_source: str = Field(type=str, required=False, mutable=False)


class SystemAdviceOfChargeGetResponse19sp1(OCIResponse):
    """
    Response to ``SystemAdviceOfChargeGetRequest()``.

    Contains a list of system Advice of Charge parameters.

    Attributes:
        delay_between_notification_seconds: delayBetweenNotificationSeconds
        incoming_aoc_handling: incomingAocHandling
        use_ocs_enquiry: useOCSEnquiry
        ocs_enquiry_type: OCSEnquiryType
    """

    _ELEMENTS = (
        E(
            "delay_between_notification_seconds", "delayBetweenNotificationSeconds", int,
            is_required=True,
        ),
        E("incoming_aoc_handling", "incomingAocHandling", str, is_required=True),
        E("use_ocs_enquiry", "useOCSEnquiry", bool, is_required=True),
        E("ocs_enquiry_type", "OCSEnquiryType", str, is_required=True),
    )

    delay_between_notification_seconds: int = Field(type=int, required=True, mutable=False)
    incoming_aoc_handling: str = Field(type=str, required=True, mutable=False)
    use_ocs_enquiry: bool = Field(type=bool, required=True, mutable=False)
    ocs_enquiry_type: str = Field(type=str, required=True, mutable=False)


class SystemAliasGetListResponse(OCIResponse):
    """
    Response to ``SystemAliasGetListRequest()``.

    Contains the list of all network alias' for the Application Server.

    Attributes:
        alias_net_address: aliasNetAddress
    """

    _ELEMENTS = (
        E("alias_net_address", "aliasNetAddress", str, is_array=True),
    )

    alias_net_address: "List[str]" = Field(type=list, required=False, mutable=False)


class SystemAnonymousCallRejectionGetResponse(OCIResponse):
    """
    Response to the ``SystemAnonymousCallRejectionGetRequest()``.

    The response contains the anonymous call rejection system.".

    Attributes:
        pai_required: paiRequired
        screen_only_local_calls: screenOnlyLocalCalls
    """

    _ELEMENTS = (
        E("pai_required", "paiRequired", bool, is_required=True),
        E("screen_only_local_calls", "screenOnlyLocalCalls", bool, is_required=True),
    )

    pai_required: bool = Field(type=bool, required=True, mutable=False)
    screen_only_local_calls: bool = Field(type=bool, required=True, mutable=False)


class SystemApplicationControllerGetListResponse(OCIResponse):
    """
    Response to the ``SystemApplicationControllerGetListRequest()``.

    Contains a table with column headings: "Name", "Subscriber Id", "Channel Set Id",
    "Status". The column values for "Status" can either be "ready" or "notReady".

    Attributes:
        application_controller_table: applicationControllerTable
    """

    _ELEMENTS = (
        E(
            "application_controller_table", "applicationControllerTable", list,
            is_complex=True, is_required=True, is_table=True,
        ),
    )

    application_controller_table: "list" = Field(type=list, required=True, mutable=False)


class SystemAttendantConsoleGetResponse(OCIResponse):
    """
    Response to ``SystemAttendantConsoleGetRequest()``.

    Contains a list of Attendant Console parameters.

    Attributes:
        max_monitored_users: maxMonitoredUsers
    """

    _ELEMENTS = (
        E("max_monitored_users", "maxMonitoredUsers", int, is_required=True),
    )

    max_monitored_users: int = Field(type=int, required=True, mutable=False)


class SystemAuthenticationLockoutSettingsGetResponse(OCIResponse):
    """
    Response to ``SystemAuthenticationLockoutSettingsGetRequest()``.

    Contains the authentication lockout settings in the system.

    Attributes:
        counter_reset_interval_days: counterResetIntervalDays
        counter_reset_hour: counterResetHour
        counter_reset_minute: counterResetMinute
        emergency_sip_bypass_allowed: emergencySIPBypassAllowed
    """

    _ELEMENTS = (
        E("counter_reset_interval_days", "counterResetIntervalDays", int, is_required=True),
        E("counter_reset_hour", "counterResetHour", int, is_required=True),
        E("counter_reset_minute", "counterResetMinute", int, is_required=True),
        E(
            "emergency_sip_bypass_allowed", "emergencySIPBypassAllowed", bool,
            is_required=True,
        ),
    )

    counter_reset_interval_days: int = Field(type=int, required=True, mutable=False)
    counter_reset_hour: int = Field(type=int, required=True, mutable=False)
    counter_reset_minute: int = Field(type=int, required=True, mutable=False)
    emergency_sip_bypass_allowed: bool = Field(type=bool, required=True, mutable=False)


class SystemAutomaticCallbackGetReleaseCauseListResponse(OCIResponse):
    """
    Response to ``SystemAutomaticCallbackGetReleaseCauseListRequest()``.


    Attributes:
        release_cause: releaseCause
    """

    _ELEMENTS = (
        E("release_cause", "releaseCause", str, is_array=True),
    )

    release_cause: "List[str]" = Field(type=list, required=False, mutable=False)


class SystemAutomaticCallbackGetResponse(OCIResponse):
    """
    Response to ``SystemAutomaticCallbackGetRequest()``.

    Replaced By: ``SystemAutomaticCallbackGetResponse15()``

    Attributes:
        monitor_minutes: monitorMinutes
        wait_between_retry_originator_minutes: waitBetweenRetryOriginatorMinutes
        max_monitors_per_originator: maxMonitorsPerOriginator
        max_callback_rings: maxCallbackRings
        max_retry_originator_minutes: maxRetryOriginatorMinutes
    """

    _ELEMENTS = (
        E("monitor_minutes", "monitorMinutes", int, is_required=True),
        E(
            "wait_between_retry_originator_minutes", "waitBetweenRetryOriginatorMinutes",
            int, is_required=True,
        ),
        E("max_monitors_per_originator", "maxMonitorsPerOriginator", int, is_required=True),
        E("max_callback_rings", "maxCallbackRings", int, is_required=True),
        E("max_retry_originator_minutes", "maxRetryOriginatorMinutes", int, is_required=True),
    )

    monitor_minutes: int = Field(type=int, required=True, mutable=False)
    wait_between_retry_originator_minutes: int = Field(type=int, required=True, mutable=False)
    max_monitors_per_originator: int = Field(type=int, required=True, mutable=False)
    max_callback_rings: int = Field(type=int, required=True, mutable=False)
    max_retry_originator_minutes: int = Field(type=int, required=True, mutable=False)


class SystemAutomaticCallbackGetResponse15(OCIResponse):
    """
    Response to ``SystemAutomaticCallbackGetRequest15()``.

    Replaced By: ``SystemAutomaticCallbackGetResponse15sp2()``

    Attributes:
        monitor_minutes: monitorMinutes
        max_monitors_per_originator: maxMonitorsPerOriginator
        max_callback_rings: maxCallbackRings
        max_monitors_per_terminator: maxMonitorsPerTerminator
        terminator_idle_guard_seconds: terminatorIdleGuardSeconds
    """

    _ELEMENTS = (
        E("monitor_minutes", "monitorMinutes", int, is_required=True),
        E("max_monitors_per_originator", "maxMonitorsPerOriginator", int, is_required=True),
        E("max_callback_rings", "maxCallbackRings", int, is_required=True),
        E("max_monitors_per_terminator", "maxMonitorsPerTerminator", int, is_required=True),
        E(
            "terminator_idle_guard_seconds", "terminatorIdleGuardSeconds", int,
            is_required=True,
        ),
    )

    monitor_minutes: int = Field(type=int, required=True, mutable=False)
    max_monitors_per_originator: int = Field(type=int, required=True, mutable=False)
    max_callback_rings: int = Field(type=int, required=True, mutable=False)
    max_monitors_per_terminator: int = Field(type=int, required=True, mutable=False)
    terminator_idle_guard_seconds: int = Field(type=int, required=True, mutable=False)


class SystemAutomaticCallbackGetResponse15sp2(OCIResponse):
    """
    Response to ``SystemAutomaticCallbackGetRequest15sp2()``.


    Attributes:
        monitor_minutes: monitorMinutes
        max_monitors_per_originator: maxMonitorsPerOriginator
        max_callback_rings: maxCallbackRings
        max_monitors_per_terminator: maxMonitorsPerTerminator
        terminator_idle_guard_seconds: terminatorIdleGuardSeconds
        callback_method: callbackMethod
        polling_interval_seconds: pollingIntervalSeconds
    """

    _ELEMENTS = (
        E("monitor_minutes", "monitorMinutes", int, is_required=True),
        E("max_monitors_per_originator", "maxMonitorsPerOriginator", int, is_required=True),
        E("max_callback_rings", "maxCallbackRings", int, is_required=True),
        E("max_monitors_per_terminator", "maxMonitorsPerTerminator", int, is_required=True),
        E(
            "terminator_idle_guard_seconds", "terminatorIdleGuardSeconds", int,
            is_required=True,
        ),
        E("callback_method", "callbackMethod", str, is_required=True),
        E("polling_interval_seconds", "pollingIntervalSeconds", int, is_required=True),
    )

    monitor_minutes: int = Field(type=int, required=True, mutable=False)
    max_monitors_per_originator: int = Field(type=int, required=True, mutable=False)
    max_callback_rings: int = Field(type=int, required=True, mutable=False)
    max_monitors_per_terminator: int = Field(type=int, required=True, mutable=False)
    terminator_idle_guard_seconds: int = Field(type=int, required=True, mutable=False)
    callback_method: str = Field(type=str, required=True, mutable=False)
    polling_interval_seconds: int = Field(type=int, required=True, mutable=False)


class SystemAutomaticCallbackGetResponse17(OCIResponse):
    """
    Response to ``SystemAutomaticCallbackGetRequest17()``.


    Attributes:
        monitor_minutes: monitorMinutes
        max_monitors_per_originator: maxMonitorsPerOriginator
        max_callback_rings: maxCallbackRings
        max_monitors_per_terminator: maxMonitorsPerTerminator
        terminator_idle_guard_seconds: terminatorIdleGuardSeconds
        callback_method: callbackMethod
        polling_interval_seconds: pollingIntervalSeconds
        activation_digit: activationDigit
    """

    _ELEMENTS = (
        E("monitor_minutes", "monitorMinutes", int, is_required=True),
        E("max_monitors_per_originator", "maxMonitorsPerOriginator", int, is_required=True),
        E("max_callback_rings", "maxCallbackRings", int, is_required=True),
        E("max_monitors_per_terminator", "maxMonitorsPerTerminator", int, is_required=True),
        E(
            "terminator_idle_guard_seconds", "terminatorIdleGuardSeconds", int,
            is_required=True,
        ),
        E("callback_method", "callbackMethod", str, is_required=True),
        E("polling_interval_seconds", "pollingIntervalSeconds", int, is_required=True),
        E("activation_digit", "activationDigit", int, is_required=True),
    )

    monitor_minutes: int = Field(type=int, required=True, mutable=False)
    max_monitors_per_originator: int = Field(type=int, required=True, mutable=False)
    max_callback_rings: int = Field(type=int, required=True, mutable=False)
    max_monitors_per_terminator: int = Field(type=int, required=True, mutable=False)
    terminator_idle_guard_seconds: int = Field(type=int, required=True, mutable=False)
    callback_method: str = Field(type=str, required=True, mutable=False)
    polling_interval_seconds: int = Field(type=int, required=True, mutable=False)
    activation_digit: int = Field(type=int, required=True, mutable=False)


class SystemBCCTGetOCIInterfaceAddressListResponse(OCIResponse):
    """
    Response to ``SystemBCCTGetOCIInterfaceAddressListRequest()``.


    Attributes:
        interface_net_address: interfaceNetAddress
    """

    _ELEMENTS = (
        E("interface_net_address", "interfaceNetAddress", str, is_array=True),
    )

    interface_net_address: "List[str]" = Field(type=list, required=False, mutable=False)


class SystemBroadCloudGetResponse(OCIResponse):
    """
    Response to the ``SystemBroadCloudGetRequest()``.

    The response contains the system interface attributes for Messaging Server.

    Attributes:
        provisioning_url: provisioningUrl
        provisioning_user_id: provisioningUserId
        enable_synchronization: enableSynchronization
    """

    _ELEMENTS = (
        E("provisioning_url", "provisioningUrl", str),
        E("provisioning_user_id", "provisioningUserId", str),
        E("enable_synchronization", "enableSynchronization", bool, is_required=True),
    )

    provisioning_url: str = Field(type=str, required=False, mutable=False)
    provisioning_user_id: str = Field(type=str, required=False, mutable=False)
    enable_synchronization: bool = Field(type=bool, required=True, mutable=False)


class SystemBroadWorksMobileManagerGetResponse(OCIResponse):
    """
    Response to the ``SystemBroadWorksMobileManagerGetRequest()``

    Attributes:
        scf_api_net_address1: scfApiNetAddress1
        scf_api_net_address2: scfApiNetAddress2
        user_name: userName
        email_from_address: emailFromAddress
        scf_ims_only: scfIMSOnly
        signaling_ip_address: signalingIPAddress
        signaling_port: signalingPort
    """

    _ELEMENTS = (
        E("scf_api_net_address1", "scfApiNetAddress1", str),
        E("scf_api_net_address2", "scfApiNetAddress2", str),
        E("user_name", "userName", str),
        E("email_from_address", "emailFromAddress", str),
        E("scf_ims_only", "scfIMSOnly", bool, is_required=True),
        E("signaling_ip_address", "signalingIPAddress", str),
        E("signaling_port", "signalingPort", int),
    )

    scf_api_net_address1: str = Field(type=str, required=False, mutable=False)
    scf_api_net_address2: str = Field(type=str, required=False, mutable=False)
    user_name: str = Field(type=str, required=False, mutable=False)
    email_from_address: str = Field(type=str, required=False, mutable=False)
    scf_ims_only: bool = Field(type=bool, required=True, mutable=False)
    signaling_ip_address: str = Field(type=str, required=False, mutable=False)
    signaling_port: int = Field(type=int, required=False, mutable=False)


class SystemBroadWorksMobilityGetIMRNListResponse(OCIResponse):
    """
    Response to ``SystemBroadWorksMobilityDnGetListRequest()``.


    Attributes:
        imrn_number: imrnNumber
    """

    _ELEMENTS = (
        E("imrn_number", "imrnNumber", str, is_array=True),
    )

    imrn_number: "List[str]" = Field(type=list, required=False, mutable=False)


class SystemBroadWorksMobilityGetMobileNetworkIMRNListResponse(OCIResponse):
    """
    Response to ``SystemBroadWorksMobilityGetMobileNetworkIMRNListRequest()``.


    Attributes:
        imrn_number: imrnNumber
    """

    _ELEMENTS = (
        E("imrn_number", "imrnNumber", str, is_array=True),
    )

    imrn_number: "List[str]" = Field(type=list, required=False, mutable=False)


class SystemBroadWorksMobilityGetResponse(OCIResponse):
    """
    The response to a ``SystemBroadWorksMobilityGetRequest()``.

    Replaced by: ``SystemBroadWorksMobilityGetResponse17sp4()``.

    Attributes:
        enable_location_services: enableLocationServices
        enable_msrn_lookup: enableMSRNLookup
        enable_mobile_state_checking: enableMobileStateChecking
        deny_call_originations: denyCallOriginations
        deny_call_terminations: denyCallTerminations
        imrn_timeout_millisecnds: imrnTimeoutMillisecnds
        scf_signaling_ip_address: scfSignalingIPAddress
        scf_signaling_port: scfSignalingPort
    """

    _ELEMENTS = (
        E("enable_location_services", "enableLocationServices", bool, is_required=True),
        E("enable_msrn_lookup", "enableMSRNLookup", bool, is_required=True),
        E(
            "enable_mobile_state_checking", "enableMobileStateChecking", bool,
            is_required=True,
        ),
        E("deny_call_originations", "denyCallOriginations", bool, is_required=True),
        E("deny_call_terminations", "denyCallTerminations", bool, is_required=True),
        E("imrn_timeout_millisecnds", "imrnTimeoutMillisecnds", int, is_required=True),
        E("scf_signaling_ip_address", "scfSignalingIPAddress", str),
        E("scf_signaling_port", "scfSignalingPort", int),
    )

    enable_location_services: bool = Field(type=bool, required=True, mutable=False)
    enable_msrn_lookup: bool = Field(type=bool, required=True, mutable=False)
    enable_mobile_state_checking: bool = Field(type=bool, required=True, mutable=False)
    deny_call_originations: bool = Field(type=bool, required=True, mutable=False)
    deny_call_terminations: bool = Field(type=bool, required=True, mutable=False)
    imrn_timeout_millisecnds: int = Field(type=int, required=True, mutable=False)
    scf_signaling_ip_address: str = Field(type=str, required=False, mutable=False)
    scf_signaling_port: int = Field(type=int, required=False, mutable=False)


class SystemBroadWorksMobilityGetResponse17sp4(OCIResponse):
    """
    The response to a ``SystemBroadWorksMobilityGetRequest17sp4()``.


    Attributes:
        enable_location_services: enableLocationServices
        enable_msrn_lookup: enableMSRNLookup
        enable_mobile_state_checking: enableMobileStateChecking
        deny_call_originations: denyCallOriginations
        deny_call_terminations: denyCallTerminations
        imrn_timeout_millisecnds: imrnTimeoutMillisecnds
        scf_signaling_net_address: scfSignalingNetAddress
        scf_signaling_port: scfSignalingPort
        refresh_period_seconds: refreshPeriodSeconds
        max_consecutive_failures: maxConsecutiveFailures
        max_response_wait_time_milliseconds: maxResponseWaitTimeMilliseconds
    """

    _ELEMENTS = (
        E("enable_location_services", "enableLocationServices", bool, is_required=True),
        E("enable_msrn_lookup", "enableMSRNLookup", bool, is_required=True),
        E(
            "enable_mobile_state_checking", "enableMobileStateChecking", bool,
            is_required=True,
        ),
        E("deny_call_originations", "denyCallOriginations", bool, is_required=True),
        E("deny_call_terminations", "denyCallTerminations", bool, is_required=True),
        E("imrn_timeout_millisecnds", "imrnTimeoutMillisecnds", int, is_required=True),
        E("scf_signaling_net_address", "scfSignalingNetAddress", str),
        E("scf_signaling_port", "scfSignalingPort", int),
        E("refresh_period_seconds", "refreshPeriodSeconds", int, is_required=True),
        E("max_consecutive_failures", "maxConsecutiveFailures", int, is_required=True),
        E(
            "max_response_wait_time_milliseconds", "maxResponseWaitTimeMilliseconds", int,
            is_required=True,
        ),
    )

    enable_location_services: bool = Field(type=bool, required=True, mutable=False)
    enable_msrn_lookup: bool = Field(type=bool, required=True, mutable=False)
    enable_mobile_state_checking: bool = Field(type=bool, required=True, mutable=False)
    deny_call_originations: bool = Field(type=bool, required=True, mutable=False)
    deny_call_terminations: bool = Field(type=bool, required=True, mutable=False)
    imrn_timeout_millisecnds: int = Field(type=int, required=True, mutable=False)
    scf_signaling_net_address: str = Field(type=str, required=False, mutable=False)
    scf_signaling_port: int = Field(type=int, required=False, mutable=False)
    refresh_period_seconds: int = Field(type=int, required=True, mutable=False)
    max_consecutive_failures: int = Field(type=int, required=True, mutable=False)
    max_response_wait_time_milliseconds: int = Field(type=int, required=True, mutable=False)


class SystemBroadWorksMobilityGetResponse19sp1(OCIResponse):
    """
    The response to a ``SystemBroadWorksMobilityGetRequest19sp1()``.

    Replaced by ``SystemBroadWorksMobilityGetResponse21()``

    Attributes:
        enable_location_services: enableLocationServices
        enable_msrn_lookup: enableMSRNLookup
        enable_mobile_state_checking: enableMobileStateChecking
        deny_call_originations: denyCallOriginations
        deny_call_terminations: denyCallTerminations
        imrn_timeout_millisecnds: imrnTimeoutMillisecnds
        scf_signaling_net_address: scfSignalingNetAddress
        scf_signaling_port: scfSignalingPort
        refresh_period_seconds: refreshPeriodSeconds
        max_consecutive_failures: maxConsecutiveFailures
        max_response_wait_time_milliseconds: maxResponseWaitTimeMilliseconds
        enable_announcement_suppression: enableAnnouncementSuppression
    """

    _ELEMENTS = (
        E("enable_location_services", "enableLocationServices", bool, is_required=True),
        E("enable_msrn_lookup", "enableMSRNLookup", bool, is_required=True),
        E(
            "enable_mobile_state_checking", "enableMobileStateChecking", bool,
            is_required=True,
        ),
        E("deny_call_originations", "denyCallOriginations", bool, is_required=True),
        E("deny_call_terminations", "denyCallTerminations", bool, is_required=True),
        E("imrn_timeout_millisecnds", "imrnTimeoutMillisecnds", int, is_required=True),
        E("scf_signaling_net_address", "scfSignalingNetAddress", str),
        E("scf_signaling_port", "scfSignalingPort", int),
        E("refresh_period_seconds", "refreshPeriodSeconds", int, is_required=True),
        E("max_consecutive_failures", "maxConsecutiveFailures", int, is_required=True),
        E(
            "max_response_wait_time_milliseconds", "maxResponseWaitTimeMilliseconds", int,
            is_required=True,
        ),
        E(
            "enable_announcement_suppression", "enableAnnouncementSuppression", bool,
            is_required=True,
        ),
    )

    enable_location_services: bool = Field(type=bool, required=True, mutable=False)
    enable_msrn_lookup: bool = Field(type=bool, required=True, mutable=False)
    enable_mobile_state_checking: bool = Field(type=bool, required=True, mutable=False)
    deny_call_originations: bool = Field(type=bool, required=True, mutable=False)
    deny_call_terminations: bool = Field(type=bool, required=True, mutable=False)
    imrn_timeout_millisecnds: int = Field(type=int, required=True, mutable=False)
    scf_signaling_net_address: str = Field(type=str, required=False, mutable=False)
    scf_signaling_port: int = Field(type=int, required=False, mutable=False)
    refresh_period_seconds: int = Field(type=int, required=True, mutable=False)
    max_consecutive_failures: int = Field(type=int, required=True, mutable=False)
    max_response_wait_time_milliseconds: int = Field(type=int, required=True, mutable=False)
    enable_announcement_suppression: bool = Field(type=bool, required=True, mutable=False)


class SystemBroadWorksMobilityGetResponse21(OCIResponse):
    """
    The response to a ``SystemBroadWorksMobilityGetRequest21()``.


    Attributes:
        enable_location_services: enableLocationServices
        enable_msrn_lookup: enableMSRNLookup
        enable_mobile_state_checking: enableMobileStateChecking
        deny_call_originations: denyCallOriginations
        deny_call_terminations: denyCallTerminations
        imrn_timeout_millisecnds: imrnTimeoutMillisecnds
    """

    _ELEMENTS = (
        E("enable_location_services", "enableLocationServices", bool, is_required=True),
        E("enable_msrn_lookup", "enableMSRNLookup", bool, is_required=True),
        E(
            "enable_mobile_state_checking", "enableMobileStateChecking", bool,
            is_required=True,
        ),
        E("deny_call_originations", "denyCallOriginations", bool, is_required=True),
        E("deny_call_terminations", "denyCallTerminations", bool, is_required=True),
        E("imrn_timeout_millisecnds", "imrnTimeoutMillisecnds", int, is_required=True),
    )

    enable_location_services: bool = Field(type=bool, required=True, mutable=False)
    enable_msrn_lookup: bool = Field(type=bool, required=True, mutable=False)
    enable_mobile_state_checking: bool = Field(type=bool, required=True, mutable=False)
    deny_call_originations: bool = Field(type=bool, required=True, mutable=False)
    deny_call_terminations: bool = Field(type=bool, required=True, mutable=False)
    imrn_timeout_millisecnds: int = Field(type=int, required=True, mutable=False)


class SystemBroadWorksMobilityMobileNetworkGetListResponse(OCIResponse):
    """
    The response to a ``SystemBroadWorksMobilityMobileNetworkGetListRequest()``.

    Contains a table with column headings: "Name", "SCF Signaling Net Address", "SCF
    Signaling Port"

    Attributes:
        mobile_network_table: mobileNetworkTable
    """

    _ELEMENTS = (
        E(
            "mobile_network_table", "mobileNetworkTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    mobile_network_table: "list" = Field(type=list, required=True, mutable=False)


class SystemBroadWorksMobilityMobileNetworkGetResponse(OCIResponse):
    """
    The response to a ``SystemBroadWorksMobilityMobileNetworkGetRequest()``.


    Attributes:
        scf_signaling_net_address: scfSignalingNetAddress
        scf_signaling_port: scfSignalingPort
        refresh_period_seconds: refreshPeriodSeconds
        max_consecutive_failures: maxConsecutiveFailures
        max_response_wait_time_milliseconds: maxResponseWaitTimeMilliseconds
        enable_announcement_suppression: enableAnnouncementSuppression
        service_access_code_list_name: serviceAccessCodeListName
    """

    _ELEMENTS = (
        E("scf_signaling_net_address", "scfSignalingNetAddress", str),
        E("scf_signaling_port", "scfSignalingPort", int),
        E("refresh_period_seconds", "refreshPeriodSeconds", int, is_required=True),
        E("max_consecutive_failures", "maxConsecutiveFailures", int, is_required=True),
        E(
            "max_response_wait_time_milliseconds", "maxResponseWaitTimeMilliseconds", int,
            is_required=True,
        ),
        E(
            "enable_announcement_suppression", "enableAnnouncementSuppression", bool,
            is_required=True,
        ),
        E("service_access_code_list_name", "serviceAccessCodeListName", str),
    )

    scf_signaling_net_address: str = Field(type=str, required=False, mutable=False)
    scf_signaling_port: int = Field(type=int, required=False, mutable=False)
    refresh_period_seconds: int = Field(type=int, required=True, mutable=False)
    max_consecutive_failures: int = Field(type=int, required=True, mutable=False)
    max_response_wait_time_milliseconds: int = Field(type=int, required=True, mutable=False)
    enable_announcement_suppression: bool = Field(type=bool, required=True, mutable=False)
    service_access_code_list_name: str = Field(type=str, required=False, mutable=False)


class SystemBroadWorksMobilityMobileSubscriberDirectoryNumberGetSummaryListResponse(OCIResponse):
    """
    Response to
    ``SystemBroadWorksMobilityMobileSubscriberDirectoryNumberGetSummaryListRequest()``.

    The response contains a table with columns: "Mobile Number", "Mobile Network",
    "Service Provider Id", "Is Enterprise", "Group Id", "User Id", "Last Name", "First
    Name", "Hiragana Last Name", "Hiragana First Name", "Phone Number" and "Extension".

    Attributes:
        mobile_subscriber_directory_numbers_summary_table:
            mobileSubscriberDirectoryNumbersSummaryTable
    """

    _ELEMENTS = (
        E(
            "mobile_subscriber_directory_numbers_summary_table",
            "mobileSubscriberDirectoryNumbersSummaryTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    mobile_subscriber_directory_numbers_summary_table: "list" = Field(
        type=list, required=True, mutable=False,
    )


class SystemBroadWorksMobilityServiceAccessCodeGetListResponse(OCIResponse):
    """
    Response to ``SystemBroadWorksMobilityServiceAccessCodeGetListRequest()``.

    Contains a table with column headings: "Country Code", "Service Access Code",
    "Description". Replaced by SystemBroadWorksMobilityServiceAccessCodeGetListReponse21.

    Attributes:
        service_access_code_table: serviceAccessCodeTable
    """

    _ELEMENTS = (
        E(
            "service_access_code_table", "serviceAccessCodeTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    service_access_code_table: "list" = Field(type=list, required=True, mutable=False)


class SystemBroadWorksMobilityServiceAccessCodeGetListResponse21(OCIResponse):
    """
    Response to ``SystemBroadWorksMobilityServiceAccessCodeGetListRequest21()``.

    Contains a table with column headings: "Country Code", "Service Access Code",
    "Description"

    Attributes:
        service_access_code_table: serviceAccessCodeTable
    """

    _ELEMENTS = (
        E(
            "service_access_code_table", "serviceAccessCodeTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    service_access_code_table: "list" = Field(type=list, required=True, mutable=False)


class SystemBroadWorksMobilityServiceAccessCodeListGetListResponse(OCIResponse):
    """
    Response to ``SystemBroadWorksMobilityServiceAccessCodeListGetListRequest()``.


    Attributes:
        name: name
    """

    _ELEMENTS = (
        E("name", "name", str, is_array=True),
    )

    name: "List[str]" = Field(type=list, required=False, mutable=False)


class SystemBroadWorksMobilityServiceAccessCodeListUsageGetResponse(OCIResponse):
    """
    Response to ``SystemBroadWorksMobilityServiceAccessCodeListUsageGetRequest()``.


    Attributes:
        mobile_network_name: mobileNetworkName
    """

    _ELEMENTS = (
        E("mobile_network_name", "mobileNetworkName", str, is_array=True),
    )

    mobile_network_name: "List[str]" = Field(type=list, required=False, mutable=False)


class SystemBroadWorksReceptionistEnterpriseGetResponse(OCIResponse):
    """
    Response to ``SystemBroadWorksReceptionistEnterpriseGetRequest()``.

    Contains a list of BroadWorks Receptionist - Enterprise parameters.

    Attributes:
        max_monitored_users: maxMonitoredUsers
    """

    _ELEMENTS = (
        E("max_monitored_users", "maxMonitoredUsers", int, is_required=True),
    )

    max_monitored_users: int = Field(type=int, required=True, mutable=False)


class SystemBusyLampFieldGetResponse(OCIResponse):
    """
    Response to ``SystemBusyLampFieldGetRequest()``.


    Attributes:
        display_local_user_identity_last_name_first: displayLocalUserIdentityLastNameFirst
    """

    _ELEMENTS = (
        E(
            "display_local_user_identity_last_name_first",
            "displayLocalUserIdentityLastNameFirst", bool, is_required=True,
        ),
    )

    display_local_user_identity_last_name_first: bool = Field(
        type=bool, required=True, mutable=False,
    )


class SystemBusyLampFieldGetResponse18(OCIResponse):
    """
    Response to ``SystemBusyLampFieldGetRequest18()``.

    The following elements are only used in AS data mode: forceUseOfTCP

    Attributes:
        display_local_user_identity_last_name_first: displayLocalUserIdentityLastNameFirst
        force_use_of_tcp: forceUseOfTCP
    """

    _ELEMENTS = (
        E(
            "display_local_user_identity_last_name_first",
            "displayLocalUserIdentityLastNameFirst", bool, is_required=True,
        ),
        E("force_use_of_tcp", "forceUseOfTCP", bool, is_required=True),
    )

    display_local_user_identity_last_name_first: bool = Field(
        type=bool, required=True, mutable=False,
    )
    force_use_of_tcp: bool = Field(type=bool, required=True, mutable=False)


class SystemBwDiameterBaseDataGetResponse(OCIResponse):
    """
    Response to ``SystemBwDiameterBaseDataGetRequest()``.

    Contains a list of System Diameter base parameters.

    Attributes:
        xs_realm: xsRealm
        xs_listening_port: xsListeningPort
        ps_realm: psRealm
        ps_listening_port: psListeningPort
        ps_relay_through_xs: psRelayThroughXs
        xs_relay_listening_port: xsRelayListeningPort
        tc_timer_seconds: tcTimerSeconds
        tw_timer_seconds: twTimerSeconds
        request_timer_seconds: requestTimerSeconds
        busy_peer_detection_outstanding_txn_count: busyPeerDetectionOutstandingTxnCount
        busy_peer_restore_outstanding_txn_count: busyPeerRestoreOutstandingTxnCount
        dynamic_entry_inactivity_timer_hours: dynamicEntryInactivityTimerHours
    """

    _ELEMENTS = (
        E("xs_realm", "xsRealm", str),
        E("xs_listening_port", "xsListeningPort", int, is_required=True),
        E("ps_realm", "psRealm", str),
        E("ps_listening_port", "psListeningPort", int, is_required=True),
        E("ps_relay_through_xs", "psRelayThroughXs", bool, is_required=True),
        E("xs_relay_listening_port", "xsRelayListeningPort", int, is_required=True),
        E("tc_timer_seconds", "tcTimerSeconds", int, is_required=True),
        E("tw_timer_seconds", "twTimerSeconds", int, is_required=True),
        E("request_timer_seconds", "requestTimerSeconds", int, is_required=True),
        E(
            "busy_peer_detection_outstanding_txn_count",
            "busyPeerDetectionOutstandingTxnCount", int, is_required=True,
        ),
        E(
            "busy_peer_restore_outstanding_txn_count",
            "busyPeerRestoreOutstandingTxnCount", int, is_required=True,
        ),
        E(
            "dynamic_entry_inactivity_timer_hours", "dynamicEntryInactivityTimerHours",
            int, is_required=True,
        ),
    )

    xs_realm: str = Field(type=str, required=False, mutable=False)
    xs_listening_port: int = Field(type=int, required=True, mutable=False)
    ps_realm: str = Field(type=str, required=False, mutable=False)
    ps_listening_port: int = Field(type=int, required=True, mutable=False)
    ps_relay_through_xs: bool = Field(type=bool, required=True, mutable=False)
    xs_relay_listening_port: int = Field(type=int, required=True, mutable=False)
    tc_timer_seconds: int = Field(type=int, required=True, mutable=False)
    tw_timer_seconds: int = Field(type=int, required=True, mutable=False)
    request_timer_seconds: int = Field(type=int, required=True, mutable=False)
    busy_peer_detection_outstanding_txn_count: int = Field(
        type=int, required=True, mutable=False,
    )
    busy_peer_restore_outstanding_txn_count: int = Field(
        type=int, required=True, mutable=False,
    )
    dynamic_entry_inactivity_timer_hours: int = Field(type=int, required=True, mutable=False)


class SystemBwDiameterBaseDataGetResponse17sp3(OCIResponse):
    """
    Response to ``SystemBwDiameterBaseDataGetRequest17sp3()``.

    Contains a list of System Diameter base parameters.

    Attributes:
        xs_realm: xsRealm
        xs_listening_port: xsListeningPort
        ps_realm: psRealm
        ps_listening_port: psListeningPort
        ps_relay_through_xs: psRelayThroughXs
        xs_relay_listening_port: xsRelayListeningPort
        tc_timer_seconds: tcTimerSeconds
        tw_timer_seconds: twTimerSeconds
        request_timer_seconds: requestTimerSeconds
        busy_peer_detection_outstanding_txn_count: busyPeerDetectionOutstandingTxnCount
        busy_peer_restore_outstanding_txn_count: busyPeerRestoreOutstandingTxnCount
        dynamic_entry_inactivity_timer_hours: dynamicEntryInactivityTimerHours
        advertised_offline_billing_application: advertisedOfflineBillingApplication
        advertised_online_billing_application: advertisedOnlineBillingApplication
    """

    _ELEMENTS = (
        E("xs_realm", "xsRealm", str),
        E("xs_listening_port", "xsListeningPort", int, is_required=True),
        E("ps_realm", "psRealm", str),
        E("ps_listening_port", "psListeningPort", int, is_required=True),
        E("ps_relay_through_xs", "psRelayThroughXs", bool, is_required=True),
        E("xs_relay_listening_port", "xsRelayListeningPort", int, is_required=True),
        E("tc_timer_seconds", "tcTimerSeconds", int, is_required=True),
        E("tw_timer_seconds", "twTimerSeconds", int, is_required=True),
        E("request_timer_seconds", "requestTimerSeconds", int, is_required=True),
        E(
            "busy_peer_detection_outstanding_txn_count",
            "busyPeerDetectionOutstandingTxnCount", int, is_required=True,
        ),
        E(
            "busy_peer_restore_outstanding_txn_count",
            "busyPeerRestoreOutstandingTxnCount", int, is_required=True,
        ),
        E(
            "dynamic_entry_inactivity_timer_hours", "dynamicEntryInactivityTimerHours",
            int, is_required=True,
        ),
        E(
            "advertised_offline_billing_application",
            "advertisedOfflineBillingApplication", str, is_required=True,
        ),
        E(
            "advertised_online_billing_application", "advertisedOnlineBillingApplication",
            str, is_required=True,
        ),
    )

    xs_realm: str = Field(type=str, required=False, mutable=False)
    xs_listening_port: int = Field(type=int, required=True, mutable=False)
    ps_realm: str = Field(type=str, required=False, mutable=False)
    ps_listening_port: int = Field(type=int, required=True, mutable=False)
    ps_relay_through_xs: bool = Field(type=bool, required=True, mutable=False)
    xs_relay_listening_port: int = Field(type=int, required=True, mutable=False)
    tc_timer_seconds: int = Field(type=int, required=True, mutable=False)
    tw_timer_seconds: int = Field(type=int, required=True, mutable=False)
    request_timer_seconds: int = Field(type=int, required=True, mutable=False)
    busy_peer_detection_outstanding_txn_count: int = Field(
        type=int, required=True, mutable=False,
    )
    busy_peer_restore_outstanding_txn_count: int = Field(
        type=int, required=True, mutable=False,
    )
    dynamic_entry_inactivity_timer_hours: int = Field(type=int, required=True, mutable=False)
    advertised_offline_billing_application: str = Field(
        type=str, required=True, mutable=False,
    )
    advertised_online_billing_application: str = Field(type=str, required=True, mutable=False)


class SystemBwDiameterPeerGetListResponse(OCIResponse):
    """
    Contains a 5 column table with column headings 'Instance', 'Identity', 'IP Address',
    'Port', and 'Enabled'.

    One row is present for each peer.

    Attributes:
        peer_table: peerTable
    """

    _ELEMENTS = (
        E("peer_table", "peerTable", list, is_complex=True, is_required=True, is_table=True),
    )

    peer_table: "list" = Field(type=list, required=True, mutable=False)


class SystemBwDiameterRoutingPeerGetListResponse(OCIResponse):
    """
    Contains a 6 column table with column headings 'Instance', 'Realm', 'ApplicationID',
    'Identity, 'Priority', and 'Weight'.

    One row is present for each Diameter Routing Peer.

    Attributes:
        routing_peer_table: routingPeerTable
    """

    _ELEMENTS = (
        E(
            "routing_peer_table", "routingPeerTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    routing_peer_table: "list" = Field(type=list, required=True, mutable=False)


class SystemBwDiameterRoutingRealmGetListResponse(OCIResponse):
    """
    Contains a 4 column table with column headings 'Instance', 'Realm', 'ApplicationID',
    and 'Default'.

    One row is present for each Diameter routing realm.

    Attributes:
        routing_realm_table: routingRealmTable
    """

    _ELEMENTS = (
        E(
            "routing_realm_table", "routingRealmTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    routing_realm_table: "list" = Field(type=list, required=True, mutable=False)


class SystemCAPGetACLListResponse14(OCIResponse):
    """
    Response to ``SystemCAPGetACLListRequest14()``.

    The table columns are: "Net Address" and "Description".

    Attributes:
        acl_table: aclTable
    """

    _ELEMENTS = (
        E("acl_table", "aclTable", list, is_complex=True, is_required=True, is_table=True),
    )

    acl_table: "list" = Field(type=list, required=True, mutable=False)


class SystemCAPParametersGetResponse(OCIResponse):
    """
    Response to ``SystemCAPParametersGetRequest()``.

    Contains a list of system CAP parameters.

    Replaced By: ``SystemCAPParametersGetResponse14sp3()``

    Attributes:
        server_port: serverPort
        max_client_connections: maxClientConnections
        enable_connection_ping: enableConnectionPing
        connection_ping_interval_minutes: connectionPingIntervalMinutes
        ccc2_server_port: CCC2ServerPort
        ccc2_max_client_connections: CCC2MaxClientConnections
    """

    _ELEMENTS = (
        E("server_port", "serverPort", int, is_required=True),
        E("max_client_connections", "maxClientConnections", int, is_required=True),
        E("enable_connection_ping", "enableConnectionPing", bool, is_required=True),
        E(
            "connection_ping_interval_minutes", "connectionPingIntervalMinutes", int,
            is_required=True,
        ),
        E("ccc2_server_port", "CCC2ServerPort", int, is_required=True),
        E("ccc2_max_client_connections", "CCC2MaxClientConnections", int, is_required=True),
    )

    server_port: int = Field(type=int, required=True, mutable=False)
    max_client_connections: int = Field(type=int, required=True, mutable=False)
    enable_connection_ping: bool = Field(type=bool, required=True, mutable=False)
    connection_ping_interval_minutes: int = Field(type=int, required=True, mutable=False)
    ccc2_server_port: int = Field(type=int, required=True, mutable=False)
    ccc2_max_client_connections: int = Field(type=int, required=True, mutable=False)


class SystemCAPParametersGetResponse14sp3(OCIResponse):
    """
    Response to ``SystemCAPParametersGetListRequest14sp3()``.

    Contains a list of system CAP parameters.  Replaced by
    ``SystemCAPParametersGetResponse19()``

    Attributes:
        server_port: serverPort
        max_client_connections: maxClientConnections
        enable_connection_ping: enableConnectionPing
        connection_ping_interval_minutes: connectionPingIntervalMinutes
        ccc2_server_port: CCC2ServerPort
        ccc2_max_client_connections: CCC2MaxClientConnections
        cap_server_call_center_port: capServerCallCenterPort
        cap_server_call_center_max_client_connections:
            capServerCallCenterMaxClientConnections
    """

    _ELEMENTS = (
        E("server_port", "serverPort", int, is_required=True),
        E("max_client_connections", "maxClientConnections", int, is_required=True),
        E("enable_connection_ping", "enableConnectionPing", bool, is_required=True),
        E(
            "connection_ping_interval_minutes", "connectionPingIntervalMinutes", int,
            is_required=True,
        ),
        E("ccc2_server_port", "CCC2ServerPort", int, is_required=True),
        E("ccc2_max_client_connections", "CCC2MaxClientConnections", int, is_required=True),
        E("cap_server_call_center_port", "capServerCallCenterPort", int, is_required=True),
        E(
            "cap_server_call_center_max_client_connections",
            "capServerCallCenterMaxClientConnections", int, is_required=True,
        ),
    )

    server_port: int = Field(type=int, required=True, mutable=False)
    max_client_connections: int = Field(type=int, required=True, mutable=False)
    enable_connection_ping: bool = Field(type=bool, required=True, mutable=False)
    connection_ping_interval_minutes: int = Field(type=int, required=True, mutable=False)
    ccc2_server_port: int = Field(type=int, required=True, mutable=False)
    ccc2_max_client_connections: int = Field(type=int, required=True, mutable=False)
    cap_server_call_center_port: int = Field(type=int, required=True, mutable=False)
    cap_server_call_center_max_client_connections: int = Field(
        type=int, required=True, mutable=False,
    )


class SystemCAPParametersGetResponse19(OCIResponse):
    """
    Response to ``SystemCAPParametersGetRequest19()``.

    Contains a list of system CAP parameters.

    Attributes:
        server_port: serverPort
        max_client_connections: maxClientConnections
        enable_connection_ping: enableConnectionPing
        connection_ping_interval_minutes: connectionPingIntervalMinutes
        ccc2_server_port: CCC2ServerPort
        ccc2_max_client_connections: CCC2MaxClientConnections
    """

    _ELEMENTS = (
        E("server_port", "serverPort", int, is_required=True),
        E("max_client_connections", "maxClientConnections", int, is_required=True),
        E("enable_connection_ping", "enableConnectionPing", bool, is_required=True),
        E(
            "connection_ping_interval_minutes", "connectionPingIntervalMinutes", int,
            is_required=True,
        ),
        E("ccc2_server_port", "CCC2ServerPort", int, is_required=True),
        E("ccc2_max_client_connections", "CCC2MaxClientConnections", int, is_required=True),
    )

    server_port: int = Field(type=int, required=True, mutable=False)
    max_client_connections: int = Field(type=int, required=True, mutable=False)
    enable_connection_ping: bool = Field(type=bool, required=True, mutable=False)
    connection_ping_interval_minutes: int = Field(type=int, required=True, mutable=False)
    ccc2_server_port: int = Field(type=int, required=True, mutable=False)
    ccc2_max_client_connections: int = Field(type=int, required=True, mutable=False)


class SystemCPEConfigGetFileServerListResponse(OCIResponse):
    """
    Response to ``SystemCPEConfigGetFileServerListRequest()``.

    The table columns are: "Device Type", "FTP Host Net Address", "FTP User Id",
    "Directory" and "Passive FTP".

    Replaced By: ``SystemCPEConfigGetFileServerListResponse14sp6()``

    Attributes:
        file_server_table: fileServerTable
    """

    _ELEMENTS = (
        E(
            "file_server_table", "fileServerTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    file_server_table: "list" = Field(type=list, required=True, mutable=False)


class SystemCPEConfigGetFileServerListResponse14sp6(OCIResponse):
    """
    Response to ``SystemCPEConfigGetFileServerListRequest14sp6()``.

    The table columns are: "Device Type", "File Repository Name", "Directory", "Extended
    File Repository Name". The following columns are only used in AS data mode: "Extended
    File Repository Name"

    Attributes:
        file_server_table: fileServerTable
    """

    _ELEMENTS = (
        E(
            "file_server_table", "fileServerTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    file_server_table: "list" = Field(type=list, required=True, mutable=False)


class SystemCPEConfigParametersGetResponse(OCIResponse):
    """
    Response to ``SystemCPEConfigParametersGetListRequest()``.

    Contains a list of system CPE Config parameters.

    Replaced By: ``SystemCPEConfigParametersGetResponse14sp6()``

    Attributes:
        enable_ip_device_management: enableIPDeviceManagement
        ftp_connect_timeout_seconds: ftpConnectTimeoutSeconds
        ftp_file_transfer_timeout_seconds: ftpFileTransferTimeoutSeconds
    """

    _ELEMENTS = (
        E("enable_ip_device_management", "enableIPDeviceManagement", bool, is_required=True),
        E("ftp_connect_timeout_seconds", "ftpConnectTimeoutSeconds", int, is_required=True),
        E(
            "ftp_file_transfer_timeout_seconds", "ftpFileTransferTimeoutSeconds", int,
            is_required=True,
        ),
    )

    enable_ip_device_management: bool = Field(type=bool, required=True, mutable=False)
    ftp_connect_timeout_seconds: int = Field(type=int, required=True, mutable=False)
    ftp_file_transfer_timeout_seconds: int = Field(type=int, required=True, mutable=False)


class SystemCPEConfigParametersGetResponse14sp6(OCIResponse):
    """
    Response to ``SystemCPEConfigParametersGetListRequest14sp6()``.

    Contains a list of system CPE Config parameters.

    Attributes:
        enable_ip_device_management: enableIPDeviceManagement
        ftp_connect_timeout_seconds: ftpConnectTimeoutSeconds
        ftp_file_transfer_timeout_seconds: ftpFileTransferTimeoutSeconds
        pause_between_file_rebuild_milliseconds: pauseBetweenFileRebuildMilliseconds
        max_busy_time_minutes: maxBusyTimeMinutes
        device_access_app_server_cluster_name: deviceAccessAppServerClusterName
        file_rebuild_immediate: fileRebuildImmediate
        file_rebuild_daily: fileRebuildDaily
        file_rebuild_hourly: fileRebuildHourly
    """

    _ELEMENTS = (
        E("enable_ip_device_management", "enableIPDeviceManagement", bool, is_required=True),
        E("ftp_connect_timeout_seconds", "ftpConnectTimeoutSeconds", int, is_required=True),
        E(
            "ftp_file_transfer_timeout_seconds", "ftpFileTransferTimeoutSeconds", int,
            is_required=True,
        ),
        E(
            "pause_between_file_rebuild_milliseconds",
            "pauseBetweenFileRebuildMilliseconds", int, is_required=True,
        ),
        E("max_busy_time_minutes", "maxBusyTimeMinutes", int, is_required=True),
        E("device_access_app_server_cluster_name", "deviceAccessAppServerClusterName", str),
        E("file_rebuild_immediate", "fileRebuildImmediate", str, is_complex=True),  # unknown
        E("file_rebuild_daily", "fileRebuildDaily", str, is_complex=True),  # unknown
        E("file_rebuild_hourly", "fileRebuildHourly", str, is_complex=True),  # unknown
    )

    enable_ip_device_management: bool = Field(type=bool, required=True, mutable=False)
    ftp_connect_timeout_seconds: int = Field(type=int, required=True, mutable=False)
    ftp_file_transfer_timeout_seconds: int = Field(type=int, required=True, mutable=False)
    pause_between_file_rebuild_milliseconds: int = Field(
        type=int, required=True, mutable=False,
    )
    max_busy_time_minutes: int = Field(type=int, required=True, mutable=False)
    device_access_app_server_cluster_name: str = Field(
        type=str, required=False, mutable=False,
    )
    file_rebuild_immediate: str = Field(type=str, required=False, mutable=False)
    file_rebuild_daily: str = Field(type=str, required=False, mutable=False)
    file_rebuild_hourly: str = Field(type=str, required=False, mutable=False)


class SystemCPEConfigParametersGetResponse20(OCIResponse):
    """
    Response to ``SystemCPEConfigParametersGetListRequest20()``.

    Contains a list of system CPE Config parameters.  Replaced by:
    ``SystemCPEConfigParametersGetResponse21()``

    Attributes:
        enable_ip_device_management: enableIPDeviceManagement
        ftp_connect_timeout_seconds: ftpConnectTimeoutSeconds
        ftp_file_transfer_timeout_seconds: ftpFileTransferTimeoutSeconds
        pause_between_file_rebuild_milliseconds: pauseBetweenFileRebuildMilliseconds
        max_busy_time_minutes: maxBusyTimeMinutes
        device_access_app_server_cluster_name: deviceAccessAppServerClusterName
    """

    _ELEMENTS = (
        E("enable_ip_device_management", "enableIPDeviceManagement", bool, is_required=True),
        E("ftp_connect_timeout_seconds", "ftpConnectTimeoutSeconds", int, is_required=True),
        E(
            "ftp_file_transfer_timeout_seconds", "ftpFileTransferTimeoutSeconds", int,
            is_required=True,
        ),
        E(
            "pause_between_file_rebuild_milliseconds",
            "pauseBetweenFileRebuildMilliseconds", int, is_required=True,
        ),
        E("max_busy_time_minutes", "maxBusyTimeMinutes", int, is_required=True),
        E("device_access_app_server_cluster_name", "deviceAccessAppServerClusterName", str),
    )

    enable_ip_device_management: bool = Field(type=bool, required=True, mutable=False)
    ftp_connect_timeout_seconds: int = Field(type=int, required=True, mutable=False)
    ftp_file_transfer_timeout_seconds: int = Field(type=int, required=True, mutable=False)
    pause_between_file_rebuild_milliseconds: int = Field(
        type=int, required=True, mutable=False,
    )
    max_busy_time_minutes: int = Field(type=int, required=True, mutable=False)
    device_access_app_server_cluster_name: str = Field(
        type=str, required=False, mutable=False,
    )


class SystemCPEConfigParametersGetResponse21(OCIResponse):
    """
    Response to ``SystemCPEConfigParametersGetListRequest21()``.

    Contains a list of system CPE Config parameters.

    Attributes:
        enable_ip_device_management: enableIPDeviceManagement
        ftp_connect_timeout_seconds: ftpConnectTimeoutSeconds
        ftp_file_transfer_timeout_seconds: ftpFileTransferTimeoutSeconds
        pause_between_file_rebuild_milliseconds: pauseBetweenFileRebuildMilliseconds
        device_access_app_server_cluster_name: deviceAccessAppServerClusterName
        min_time_between_reset_milliseconds: minTimeBetweenResetMilliseconds
        always_push_files_on_rebuild: alwaysPushFilesOnRebuild
        max_file_operation_retry_attempts: maxFileOperationRetryAttempts
        enable_auto_rebuild_config: enableAutoRebuildConfig
        event_queue_size: eventQueueSize
        allow_device_credentials_retrieval: allowDeviceCredentialsRetrieval
    """

    _ELEMENTS = (
        E("enable_ip_device_management", "enableIPDeviceManagement", bool, is_required=True),
        E("ftp_connect_timeout_seconds", "ftpConnectTimeoutSeconds", int, is_required=True),
        E(
            "ftp_file_transfer_timeout_seconds", "ftpFileTransferTimeoutSeconds", int,
            is_required=True,
        ),
        E(
            "pause_between_file_rebuild_milliseconds",
            "pauseBetweenFileRebuildMilliseconds", int, is_required=True,
        ),
        E("device_access_app_server_cluster_name", "deviceAccessAppServerClusterName", str),
        E(
            "min_time_between_reset_milliseconds", "minTimeBetweenResetMilliseconds", int,
            is_required=True,
        ),
        E("always_push_files_on_rebuild", "alwaysPushFilesOnRebuild", bool, is_required=True),
        E(
            "max_file_operation_retry_attempts", "maxFileOperationRetryAttempts", int,
            is_required=True,
        ),
        E("enable_auto_rebuild_config", "enableAutoRebuildConfig", bool, is_required=True),
        E("event_queue_size", "eventQueueSize", int, is_required=True),
        E(
            "allow_device_credentials_retrieval", "allowDeviceCredentialsRetrieval", bool,
            is_required=True,
        ),
    )

    enable_ip_device_management: bool = Field(type=bool, required=True, mutable=False)
    ftp_connect_timeout_seconds: int = Field(type=int, required=True, mutable=False)
    ftp_file_transfer_timeout_seconds: int = Field(type=int, required=True, mutable=False)
    pause_between_file_rebuild_milliseconds: int = Field(
        type=int, required=True, mutable=False,
    )
    device_access_app_server_cluster_name: str = Field(
        type=str, required=False, mutable=False,
    )
    min_time_between_reset_milliseconds: int = Field(type=int, required=True, mutable=False)
    always_push_files_on_rebuild: bool = Field(type=bool, required=True, mutable=False)
    max_file_operation_retry_attempts: int = Field(type=int, required=True, mutable=False)
    enable_auto_rebuild_config: bool = Field(type=bool, required=True, mutable=False)
    event_queue_size: int = Field(type=int, required=True, mutable=False)
    allow_device_credentials_retrieval: bool = Field(type=bool, required=True, mutable=False)


class SystemCallCenterEnhancedReportingBrandingGetResponse(OCIResponse):
    """
    Response to the ``SystemCallCenterEnhancedReportingBrandingGetRequest()``.


    Attributes:
        branding_choice: brandingChoice
        custom_branding_file_description: customBrandingFileDescription
    """

    _ELEMENTS = (
        E("branding_choice", "brandingChoice", str, is_required=True),
        E("custom_branding_file_description", "customBrandingFileDescription", str),
    )

    branding_choice: str = Field(type=str, required=True, mutable=False)
    custom_branding_file_description: str = Field(type=str, required=False, mutable=False)


class SystemCallCenterEnhancedReportingGetResponse(OCIResponse):
    """
    Response to ``SystemCallCenterEnhancedReportingGetRequest()``.


    Attributes:
        archive_reports: archiveReports
        report_application_url: reportApplicationURL
        repository_application_url: repositoryApplicationURL
    """

    _ELEMENTS = (
        E("archive_reports", "archiveReports", bool, is_required=True),
        E("report_application_url", "reportApplicationURL", str),
        E("repository_application_url", "repositoryApplicationURL", str),
    )

    archive_reports: bool = Field(type=bool, required=True, mutable=False)
    report_application_url: str = Field(type=str, required=False, mutable=False)
    repository_application_url: str = Field(type=str, required=False, mutable=False)


class SystemCallCenterEnhancedReportingReportTemplateGetListResponse(OCIResponse):
    """
    Response to ``SystemCallCenterEnhancedReportingReportTemplateGetListRequest()``.

    Contains a table with column headings: "Name", "Description", "Is Custom", "Type" and
    "Enabled"

    Attributes:
        report_template_table: reportTemplateTable
    """

    _ELEMENTS = (
        E(
            "report_template_table", "reportTemplateTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    report_template_table: "list" = Field(type=list, required=True, mutable=False)


class SystemCallCenterEnhancedReportingReportTemplateGetResponse(OCIResponse):
    """
    Response to ``SystemCallCenterEnhancedReportingReportTemplateGetRequest()``.


    Attributes:
        description: description
        data_template: dataTemplate
        filter_number: filterNumber
        xslt_template_description: xsltTemplateDescription
        scope: scope
        is_enabled: isEnabled
        is_realtime_report: isRealtimeReport
        call_completion_threshold_param: callCompletionThresholdParam
        short_duration_threshold_param: shortDurationThresholdParam
        service_level_threshold_param: serviceLevelThresholdParam
        service_level_inclusions_param: serviceLevelInclusionsParam
        service_level_objective_threshold_param: serviceLevelObjectiveThresholdParam
        abandoned_call_threshold_param: abandonedCallThresholdParam
        service_level_threshold_param_number: serviceLevelThresholdParamNumber
        abandoned_call_threshold_param_number: abandonedCallThresholdParamNumber
        filter_value: filterValue
    """

    _ELEMENTS = (
        E("description", "description", str),
        E("data_template", "dataTemplate", str, is_required=True),
        E("filter_number", "filterNumber", int),
        E("xslt_template_description", "xsltTemplateDescription", str, is_required=True),
        E("scope", "scope", str, is_required=True),
        E("is_enabled", "isEnabled", bool, is_required=True),
        E("is_realtime_report", "isRealtimeReport", bool),
        E("call_completion_threshold_param", "callCompletionThresholdParam", str),
        E("short_duration_threshold_param", "shortDurationThresholdParam", str),
        E("service_level_threshold_param", "serviceLevelThresholdParam", str),
        E("service_level_inclusions_param", "serviceLevelInclusionsParam", str),
        E(
            "service_level_objective_threshold_param",
            "serviceLevelObjectiveThresholdParam", str,
        ),
        E("abandoned_call_threshold_param", "abandonedCallThresholdParam", str),
        E("service_level_threshold_param_number", "serviceLevelThresholdParamNumber", int),
        E("abandoned_call_threshold_param_number", "abandonedCallThresholdParamNumber", int),
        E("filter_value", "filterValue", str),
    )

    description: str = Field(type=str, required=False, mutable=False)
    data_template: str = Field(type=str, required=True, mutable=False)
    filter_number: int = Field(type=int, required=False, mutable=False)
    xslt_template_description: str = Field(type=str, required=True, mutable=False)
    scope: str = Field(type=str, required=True, mutable=False)
    is_enabled: bool = Field(type=bool, required=True, mutable=False)
    is_realtime_report: bool = Field(type=bool, required=False, mutable=False)
    call_completion_threshold_param: str = Field(type=str, required=False, mutable=False)
    short_duration_threshold_param: str = Field(type=str, required=False, mutable=False)
    service_level_threshold_param: str = Field(type=str, required=False, mutable=False)
    service_level_inclusions_param: str = Field(type=str, required=False, mutable=False)
    service_level_objective_threshold_param: str = Field(
        type=str, required=False, mutable=False,
    )
    abandoned_call_threshold_param: str = Field(type=str, required=False, mutable=False)
    service_level_threshold_param_number: int = Field(type=int, required=False, mutable=False)
    abandoned_call_threshold_param_number: int = Field(
        type=int, required=False, mutable=False,
    )
    filter_value: str = Field(type=str, required=False, mutable=False)


class SystemCallCenterEnhancedReportingScheduledReportGetActiveListResponse(OCIResponse):
    """
    Response to ``SystemCallCenterEnhancedReportingScheduledReportGetActiveListRequest()``
    Contains a table with column headings : "Scheduled Report Name", "Description",
    "Service Provider Id", "Is Enterprise", "Group Id", "Created By", "Is Supervisor
    Report", "Report Template Name", "Report Template Level" and "Recurring".

    The "Created By" can be either "Administrator" or user id if created by supervisor.
    The possible values for "Recurring" are "None", "Daily", "Weekly", "Monthly" and
    "Yearly". The possible values for "Report Template Level" are "System", "Enterprise"
    and "Group". For the rows with "Is Enterprise" column value "true", the "Group Id"
    column will be empty.

    Attributes:
        scheduled_report_table: scheduledReportTable
    """

    _ELEMENTS = (
        E(
            "scheduled_report_table", "scheduledReportTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    scheduled_report_table: "list" = Field(type=list, required=True, mutable=False)


class SystemCallCenterEnhancedReportingScheduledReportGetCompletedListResponse(OCIResponse):
    """
    Response to
    ``SystemCallCenterEnhancedReportingScheduledReportGetCompletedListRequest()`` Contains
    a table with column headings : "Scheduled Report Name", "Description", "Service
    Provider Id", "Is Enterprise", "Group Id", "Created By", "Is Supervisor Report",
    "Report Template Name", "Report Template Level" and "Recurring".

    The "Created By" can be either "Administrator" or user id if created by supervisor.
    The possible values for "Recurring" are "None", "Daily", "Weekly", "Monthly" and
    "Yearly". The possible values for "Report Template Level" are "System", "Enterprise"
    and "Group". For the rows with "Is Enterprise" column value "true", the "Group Id"
    column will be empty.

    Attributes:
        scheduled_report_table: scheduledReportTable
    """

    _ELEMENTS = (
        E(
            "scheduled_report_table", "scheduledReportTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    scheduled_report_table: "list" = Field(type=list, required=True, mutable=False)


class SystemCallCenterEnhancedReportingScheduledReportGetListResponse(OCIResponse):
    """
    Response to ``SystemCallCenterEnhancedReportingScheduledReportGetListRequest()``.

    Contains a table with column headings : "Scheduled Report Name", "Description",
    "Service Provider Id", "Is Enterprise", "Group Id", "Created By", "Is Supervisor
    Report", "Status", "Report Template Name", "Report Template Level" and "Recurring".
    The "Created By" can be either "Administrator" or user id if created by supervisor.
    The possible values for "Status" are "Active", and "Completed". The possible values
    for "Recurring" are "None", "Daily", "Weekly", "Monthly" and "Yearly". The possible
    values for "Report Template Level" are "System", "Enterprise" and "Group". For the
    rows with "Is Enterprise" column value "true", the "Group Id" column will be empty.

    Attributes:
        scheduled_report_table: scheduledReportTable
    """

    _ELEMENTS = (
        E(
            "scheduled_report_table", "scheduledReportTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    scheduled_report_table: "list" = Field(type=list, required=True, mutable=False)


class SystemCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListResponse(OCIResponse):
    """
    Response to
    ``SystemCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListRequest()``.

    Contains a table with column headings: "Schedule Name", "Organization Type", "Service
    Provider Id", "Group Id", "Created By", "Created By Supervisor", and "Is Active". The
    "Organization Type" is either "Service Provider" or "Enterprise". The "Created By" can
    be either "Administrator" or user id if created by supervisor.  The possible values
    for "Created By Supervisor" are "true" and "false".

    Attributes:
        schedule_report_table: scheduleReportTable
    """

    _ELEMENTS = (
        E(
            "schedule_report_table", "scheduleReportTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    schedule_report_table: "list" = Field(type=list, required=True, mutable=False)


class SystemCallCenterEnhancedReportingScheduledTaskParametersGetResponse(OCIResponse):
    """
    Response to ``SystemCallCenterEnhancedReportingScheduledTaskParametersGetRequest()``

    Attributes:
        scheduled_report_search_interval_minutes: scheduledReportSearchIntervalMinutes
        maximum_scheduled_reports_per_interval: maximumScheduledReportsPerInterval
        delete_scheduled_report_days_after_completion:
            deleteScheduledReportDaysAfterCompletion
    """

    _ELEMENTS = (
        E(
            "scheduled_report_search_interval_minutes",
            "scheduledReportSearchIntervalMinutes", int, is_required=True,
        ),
        E(
            "maximum_scheduled_reports_per_interval",
            "maximumScheduledReportsPerInterval", int, is_required=True,
        ),
        E(
            "delete_scheduled_report_days_after_completion",
            "deleteScheduledReportDaysAfterCompletion", int, is_required=True,
        ),
    )

    scheduled_report_search_interval_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    maximum_scheduled_reports_per_interval: int = Field(
        type=int, required=True, mutable=False,
    )
    delete_scheduled_report_days_after_completion: int = Field(
        type=int, required=True, mutable=False,
    )


class SystemCallCenterGetResponse(OCIResponse):
    """
    Response to ``SystemCallCenterGetRequest()``.

    Replaced By: ``SystemCallCenterGetResponse14sp9()``

    Attributes:
        default_from_address: defaultFromAddress
    """

    _ELEMENTS = (
        E("default_from_address", "defaultFromAddress", str, is_required=True),
    )

    default_from_address: str = Field(type=str, required=True, mutable=False)


class SystemCallCenterGetResponse14sp9(OCIResponse):
    """
    Response to ``SystemCallCenterGetRequest14sp9()``.


    Attributes:
        default_from_address: defaultFromAddress
        statistics_sampling_period_minutes: statisticsSamplingPeriodMinutes
    """

    _ELEMENTS = (
        E("default_from_address", "defaultFromAddress", str, is_required=True),
        E(
            "statistics_sampling_period_minutes", "statisticsSamplingPeriodMinutes", int,
            is_required=True,
        ),
    )

    default_from_address: str = Field(type=str, required=True, mutable=False)
    statistics_sampling_period_minutes: int = Field(type=int, required=True, mutable=False)


class SystemCallCenterGetResponse16(OCIResponse):
    """
    Response to ``SystemCallCenterGetRequest16()``.


    Attributes:
        default_from_address: defaultFromAddress
        statistics_sampling_period_minutes: statisticsSamplingPeriodMinutes
        default_enable_guard_timer: defaultEnableGuardTimer
        default_guard_timer_seconds: defaultGuardTimerSeconds
        force_agent_unavailable_on_dnd_activation: forceAgentUnavailableOnDNDActivation
        force_agent_unavailable_on_personal_calls: forceAgentUnavailableOnPersonalCalls
        force_agent_unavailable_on_bounced_call_limit:
            forceAgentUnavailableOnBouncedCallLimit
        number_consecutive_bounced_calls_to_force_agent_unavailable:
            numberConsecutiveBouncedCallsToForceAgentUnavailable
    """

    _ELEMENTS = (
        E("default_from_address", "defaultFromAddress", str, is_required=True),
        E(
            "statistics_sampling_period_minutes", "statisticsSamplingPeriodMinutes", int,
            is_required=True,
        ),
        E("default_enable_guard_timer", "defaultEnableGuardTimer", bool, is_required=True),
        E("default_guard_timer_seconds", "defaultGuardTimerSeconds", int, is_required=True),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation", bool, is_required=True,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls", bool, is_required=True,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit", bool, is_required=True,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable", int, is_required=True,
        ),
    )

    default_from_address: str = Field(type=str, required=True, mutable=False)
    statistics_sampling_period_minutes: int = Field(type=int, required=True, mutable=False)
    default_enable_guard_timer: bool = Field(type=bool, required=True, mutable=False)
    default_guard_timer_seconds: int = Field(type=int, required=True, mutable=False)
    force_agent_unavailable_on_dnd_activation: bool = Field(
        type=bool, required=True, mutable=False,
    )
    force_agent_unavailable_on_personal_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    force_agent_unavailable_on_bounced_call_limit: bool = Field(
        type=bool, required=True, mutable=False,
    )
    number_consecutive_bounced_calls_to_force_agent_unavailable: int = Field(
        type=int, required=True, mutable=False,
    )


class SystemCallCenterGetResponse17(OCIResponse):
    """
    Response to ``SystemCallCenterGetRequest17()``.

    Replaced by ``SystemCallCenterGetResponse17sp4()``.

    Attributes:
        default_from_address: defaultFromAddress
        statistics_sampling_period_minutes: statisticsSamplingPeriodMinutes
        default_enable_guard_timer: defaultEnableGuardTimer
        default_guard_timer_seconds: defaultGuardTimerSeconds
        force_agent_unavailable_on_dnd_activation: forceAgentUnavailableOnDNDActivation
        force_agent_unavailable_on_personal_calls: forceAgentUnavailableOnPersonalCalls
        force_agent_unavailable_on_bounced_call_limit:
            forceAgentUnavailableOnBouncedCallLimit
        number_consecutive_bounced_calls_to_force_agent_unavailable:
            numberConsecutiveBouncedCallsToForceAgentUnavailable
        default_play_ring_when_offer_call: defaultPlayRingWhenOfferCall
        uniform_call_distribution_policy_scope: uniformCallDistributionPolicyScope
        call_handling_sampling_period_minutes: callHandlingSamplingPeriodMinutes
        call_handling_minimum_sampling_size: callHandlingMinimumSamplingSize
        play_tone_to_agent_for_emergency_call: playToneToAgentForEmergencyCall
        emergency_call_clid_prefix: emergencyCallCLIDPrefix
    """

    _ELEMENTS = (
        E("default_from_address", "defaultFromAddress", str, is_required=True),
        E(
            "statistics_sampling_period_minutes", "statisticsSamplingPeriodMinutes", int,
            is_required=True,
        ),
        E("default_enable_guard_timer", "defaultEnableGuardTimer", bool, is_required=True),
        E("default_guard_timer_seconds", "defaultGuardTimerSeconds", int, is_required=True),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation", bool, is_required=True,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls", bool, is_required=True,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit", bool, is_required=True,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable", int, is_required=True,
        ),
        E(
            "default_play_ring_when_offer_call", "defaultPlayRingWhenOfferCall", bool,
            is_required=True,
        ),
        E(
            "uniform_call_distribution_policy_scope",
            "uniformCallDistributionPolicyScope", str, is_required=True,
        ),
        E(
            "call_handling_sampling_period_minutes", "callHandlingSamplingPeriodMinutes",
            int, is_required=True,
        ),
        E(
            "call_handling_minimum_sampling_size", "callHandlingMinimumSamplingSize", int,
            is_required=True,
        ),
        E(
            "play_tone_to_agent_for_emergency_call", "playToneToAgentForEmergencyCall",
            bool, is_required=True,
        ),
        E("emergency_call_clid_prefix", "emergencyCallCLIDPrefix", str, is_required=True),
    )

    default_from_address: str = Field(type=str, required=True, mutable=False)
    statistics_sampling_period_minutes: int = Field(type=int, required=True, mutable=False)
    default_enable_guard_timer: bool = Field(type=bool, required=True, mutable=False)
    default_guard_timer_seconds: int = Field(type=int, required=True, mutable=False)
    force_agent_unavailable_on_dnd_activation: bool = Field(
        type=bool, required=True, mutable=False,
    )
    force_agent_unavailable_on_personal_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    force_agent_unavailable_on_bounced_call_limit: bool = Field(
        type=bool, required=True, mutable=False,
    )
    number_consecutive_bounced_calls_to_force_agent_unavailable: int = Field(
        type=int, required=True, mutable=False,
    )
    default_play_ring_when_offer_call: bool = Field(type=bool, required=True, mutable=False)
    uniform_call_distribution_policy_scope: str = Field(
        type=str, required=True, mutable=False,
    )
    call_handling_sampling_period_minutes: int = Field(type=int, required=True, mutable=False)
    call_handling_minimum_sampling_size: int = Field(type=int, required=True, mutable=False)
    play_tone_to_agent_for_emergency_call: bool = Field(
        type=bool, required=True, mutable=False,
    )
    emergency_call_clid_prefix: str = Field(type=str, required=True, mutable=False)


class SystemCallCenterGetResponse17sp4(OCIResponse):
    """
    Response to ``SystemCallCenterGetRequest17sp4()``.

    Replaced by: ``SystemCallCenterGetResponse19()``.

    Attributes:
        default_from_address: defaultFromAddress
        statistics_sampling_period_minutes: statisticsSamplingPeriodMinutes
        default_enable_guard_timer: defaultEnableGuardTimer
        default_guard_timer_seconds: defaultGuardTimerSeconds
        force_agent_unavailable_on_dnd_activation: forceAgentUnavailableOnDNDActivation
        force_agent_unavailable_on_personal_calls: forceAgentUnavailableOnPersonalCalls
        force_agent_unavailable_on_bounced_call_limit:
            forceAgentUnavailableOnBouncedCallLimit
        number_consecutive_bounced_calls_to_force_agent_unavailable:
            numberConsecutiveBouncedCallsToForceAgentUnavailable
        force_agent_unavailable_on_not_reachable: forceAgentUnavailableOnNotReachable
        default_play_ring_when_offer_call: defaultPlayRingWhenOfferCall
        uniform_call_distribution_policy_scope: uniformCallDistributionPolicyScope
        call_handling_sampling_period_minutes: callHandlingSamplingPeriodMinutes
        call_handling_minimum_sampling_size: callHandlingMinimumSamplingSize
        play_tone_to_agent_for_emergency_call: playToneToAgentForEmergencyCall
        emergency_call_clid_prefix: emergencyCallCLIDPrefix
    """

    _ELEMENTS = (
        E("default_from_address", "defaultFromAddress", str, is_required=True),
        E(
            "statistics_sampling_period_minutes", "statisticsSamplingPeriodMinutes", int,
            is_required=True,
        ),
        E("default_enable_guard_timer", "defaultEnableGuardTimer", bool, is_required=True),
        E("default_guard_timer_seconds", "defaultGuardTimerSeconds", int, is_required=True),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation", bool, is_required=True,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls", bool, is_required=True,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit", bool, is_required=True,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable", int, is_required=True,
        ),
        E(
            "force_agent_unavailable_on_not_reachable",
            "forceAgentUnavailableOnNotReachable", bool, is_required=True,
        ),
        E(
            "default_play_ring_when_offer_call", "defaultPlayRingWhenOfferCall", bool,
            is_required=True,
        ),
        E(
            "uniform_call_distribution_policy_scope",
            "uniformCallDistributionPolicyScope", str, is_required=True,
        ),
        E(
            "call_handling_sampling_period_minutes", "callHandlingSamplingPeriodMinutes",
            int, is_required=True,
        ),
        E(
            "call_handling_minimum_sampling_size", "callHandlingMinimumSamplingSize", int,
            is_required=True,
        ),
        E(
            "play_tone_to_agent_for_emergency_call", "playToneToAgentForEmergencyCall",
            bool, is_required=True,
        ),
        E("emergency_call_clid_prefix", "emergencyCallCLIDPrefix", str, is_required=True),
    )

    default_from_address: str = Field(type=str, required=True, mutable=False)
    statistics_sampling_period_minutes: int = Field(type=int, required=True, mutable=False)
    default_enable_guard_timer: bool = Field(type=bool, required=True, mutable=False)
    default_guard_timer_seconds: int = Field(type=int, required=True, mutable=False)
    force_agent_unavailable_on_dnd_activation: bool = Field(
        type=bool, required=True, mutable=False,
    )
    force_agent_unavailable_on_personal_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    force_agent_unavailable_on_bounced_call_limit: bool = Field(
        type=bool, required=True, mutable=False,
    )
    number_consecutive_bounced_calls_to_force_agent_unavailable: int = Field(
        type=int, required=True, mutable=False,
    )
    force_agent_unavailable_on_not_reachable: bool = Field(
        type=bool, required=True, mutable=False,
    )
    default_play_ring_when_offer_call: bool = Field(type=bool, required=True, mutable=False)
    uniform_call_distribution_policy_scope: str = Field(
        type=str, required=True, mutable=False,
    )
    call_handling_sampling_period_minutes: int = Field(type=int, required=True, mutable=False)
    call_handling_minimum_sampling_size: int = Field(type=int, required=True, mutable=False)
    play_tone_to_agent_for_emergency_call: bool = Field(
        type=bool, required=True, mutable=False,
    )
    emergency_call_clid_prefix: str = Field(type=str, required=True, mutable=False)


class SystemCallCenterGetResponse19(OCIResponse):
    """
    Response to ``SystemCallCenterGetRequest19()``.

    Replaced by ``SystemCallCenterGetRequest21()``.

    Attributes:
        default_from_address: defaultFromAddress
        statistics_sampling_period_minutes: statisticsSamplingPeriodMinutes
        default_enable_guard_timer: defaultEnableGuardTimer
        default_guard_timer_seconds: defaultGuardTimerSeconds
        force_agent_unavailable_on_dnd_activation: forceAgentUnavailableOnDNDActivation
        force_agent_unavailable_on_personal_calls: forceAgentUnavailableOnPersonalCalls
        force_agent_unavailable_on_bounced_call_limit:
            forceAgentUnavailableOnBouncedCallLimit
        number_consecutive_bounced_calls_to_force_agent_unavailable:
            numberConsecutiveBouncedCallsToForceAgentUnavailable
        force_agent_unavailable_on_not_reachable: forceAgentUnavailableOnNotReachable
        default_play_ring_when_offer_call: defaultPlayRingWhenOfferCall
        uniform_call_distribution_policy_scope: uniformCallDistributionPolicyScope
        call_handling_sampling_period_minutes: callHandlingSamplingPeriodMinutes
        call_handling_minimum_sampling_size: callHandlingMinimumSamplingSize
        play_tone_to_agent_for_emergency_call: playToneToAgentForEmergencyCall
        emergency_call_clid_prefix: emergencyCallCLIDPrefix
        threshold_crossing_notification_email_guard_timer_seconds:
            thresholdCrossingNotificationEmailGuardTimerSeconds
    """

    _ELEMENTS = (
        E("default_from_address", "defaultFromAddress", str, is_required=True),
        E(
            "statistics_sampling_period_minutes", "statisticsSamplingPeriodMinutes", int,
            is_required=True,
        ),
        E("default_enable_guard_timer", "defaultEnableGuardTimer", bool, is_required=True),
        E("default_guard_timer_seconds", "defaultGuardTimerSeconds", int, is_required=True),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation", bool, is_required=True,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls", bool, is_required=True,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit", bool, is_required=True,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable", int, is_required=True,
        ),
        E(
            "force_agent_unavailable_on_not_reachable",
            "forceAgentUnavailableOnNotReachable", bool, is_required=True,
        ),
        E(
            "default_play_ring_when_offer_call", "defaultPlayRingWhenOfferCall", bool,
            is_required=True,
        ),
        E(
            "uniform_call_distribution_policy_scope",
            "uniformCallDistributionPolicyScope", str, is_required=True,
        ),
        E(
            "call_handling_sampling_period_minutes", "callHandlingSamplingPeriodMinutes",
            int, is_required=True,
        ),
        E(
            "call_handling_minimum_sampling_size", "callHandlingMinimumSamplingSize", int,
            is_required=True,
        ),
        E(
            "play_tone_to_agent_for_emergency_call", "playToneToAgentForEmergencyCall",
            bool, is_required=True,
        ),
        E("emergency_call_clid_prefix", "emergencyCallCLIDPrefix", str, is_required=True),
        E(
            "threshold_crossing_notification_email_guard_timer_seconds",
            "thresholdCrossingNotificationEmailGuardTimerSeconds", int, is_required=True,
        ),
    )

    default_from_address: str = Field(type=str, required=True, mutable=False)
    statistics_sampling_period_minutes: int = Field(type=int, required=True, mutable=False)
    default_enable_guard_timer: bool = Field(type=bool, required=True, mutable=False)
    default_guard_timer_seconds: int = Field(type=int, required=True, mutable=False)
    force_agent_unavailable_on_dnd_activation: bool = Field(
        type=bool, required=True, mutable=False,
    )
    force_agent_unavailable_on_personal_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    force_agent_unavailable_on_bounced_call_limit: bool = Field(
        type=bool, required=True, mutable=False,
    )
    number_consecutive_bounced_calls_to_force_agent_unavailable: int = Field(
        type=int, required=True, mutable=False,
    )
    force_agent_unavailable_on_not_reachable: bool = Field(
        type=bool, required=True, mutable=False,
    )
    default_play_ring_when_offer_call: bool = Field(type=bool, required=True, mutable=False)
    uniform_call_distribution_policy_scope: str = Field(
        type=str, required=True, mutable=False,
    )
    call_handling_sampling_period_minutes: int = Field(type=int, required=True, mutable=False)
    call_handling_minimum_sampling_size: int = Field(type=int, required=True, mutable=False)
    play_tone_to_agent_for_emergency_call: bool = Field(
        type=bool, required=True, mutable=False,
    )
    emergency_call_clid_prefix: str = Field(type=str, required=True, mutable=False)
    threshold_crossing_notification_email_guard_timer_seconds: int = Field(
        type=int, required=True, mutable=False,
    )


class SystemCallCenterGetResponse21(OCIResponse):
    """
    Response to ``SystemCallCenterGetRequest21()``.


    Attributes:
        default_from_address: defaultFromAddress
        statistics_sampling_period_minutes: statisticsSamplingPeriodMinutes
        default_enable_guard_timer: defaultEnableGuardTimer
        default_guard_timer_seconds: defaultGuardTimerSeconds
        force_agent_unavailable_on_dnd_activation: forceAgentUnavailableOnDNDActivation
        force_agent_unavailable_on_personal_calls: forceAgentUnavailableOnPersonalCalls
        force_agent_unavailable_on_bounced_call_limit:
            forceAgentUnavailableOnBouncedCallLimit
        number_consecutive_bounced_calls_to_force_agent_unavailable:
            numberConsecutiveBouncedCallsToForceAgentUnavailable
        force_agent_unavailable_on_not_reachable: forceAgentUnavailableOnNotReachable
        default_play_ring_when_offer_call: defaultPlayRingWhenOfferCall
        uniform_call_distribution_policy_scope: uniformCallDistributionPolicyScope
        call_handling_sampling_period_minutes: callHandlingSamplingPeriodMinutes
        call_handling_minimum_sampling_size: callHandlingMinimumSamplingSize
        play_tone_to_agent_for_emergency_call: playToneToAgentForEmergencyCall
        emergency_call_clid_prefix: emergencyCallCLIDPrefix
        threshold_crossing_notification_email_guard_timer_seconds:
            thresholdCrossingNotificationEmailGuardTimerSeconds
        allow_agent_device_initiated_forward: allowAgentDeviceInitiatedForward
    """

    _ELEMENTS = (
        E("default_from_address", "defaultFromAddress", str, is_required=True),
        E(
            "statistics_sampling_period_minutes", "statisticsSamplingPeriodMinutes", int,
            is_required=True,
        ),
        E("default_enable_guard_timer", "defaultEnableGuardTimer", bool, is_required=True),
        E("default_guard_timer_seconds", "defaultGuardTimerSeconds", int, is_required=True),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation", bool, is_required=True,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls", bool, is_required=True,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit", bool, is_required=True,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable", int, is_required=True,
        ),
        E(
            "force_agent_unavailable_on_not_reachable",
            "forceAgentUnavailableOnNotReachable", bool, is_required=True,
        ),
        E(
            "default_play_ring_when_offer_call", "defaultPlayRingWhenOfferCall", bool,
            is_required=True,
        ),
        E(
            "uniform_call_distribution_policy_scope",
            "uniformCallDistributionPolicyScope", str, is_required=True,
        ),
        E(
            "call_handling_sampling_period_minutes", "callHandlingSamplingPeriodMinutes",
            int, is_required=True,
        ),
        E(
            "call_handling_minimum_sampling_size", "callHandlingMinimumSamplingSize", int,
            is_required=True,
        ),
        E(
            "play_tone_to_agent_for_emergency_call", "playToneToAgentForEmergencyCall",
            bool, is_required=True,
        ),
        E("emergency_call_clid_prefix", "emergencyCallCLIDPrefix", str, is_required=True),
        E(
            "threshold_crossing_notification_email_guard_timer_seconds",
            "thresholdCrossingNotificationEmailGuardTimerSeconds", int, is_required=True,
        ),
        E(
            "allow_agent_device_initiated_forward", "allowAgentDeviceInitiatedForward",
            bool, is_required=True,
        ),
    )

    default_from_address: str = Field(type=str, required=True, mutable=False)
    statistics_sampling_period_minutes: int = Field(type=int, required=True, mutable=False)
    default_enable_guard_timer: bool = Field(type=bool, required=True, mutable=False)
    default_guard_timer_seconds: int = Field(type=int, required=True, mutable=False)
    force_agent_unavailable_on_dnd_activation: bool = Field(
        type=bool, required=True, mutable=False,
    )
    force_agent_unavailable_on_personal_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    force_agent_unavailable_on_bounced_call_limit: bool = Field(
        type=bool, required=True, mutable=False,
    )
    number_consecutive_bounced_calls_to_force_agent_unavailable: int = Field(
        type=int, required=True, mutable=False,
    )
    force_agent_unavailable_on_not_reachable: bool = Field(
        type=bool, required=True, mutable=False,
    )
    default_play_ring_when_offer_call: bool = Field(type=bool, required=True, mutable=False)
    uniform_call_distribution_policy_scope: str = Field(
        type=str, required=True, mutable=False,
    )
    call_handling_sampling_period_minutes: int = Field(type=int, required=True, mutable=False)
    call_handling_minimum_sampling_size: int = Field(type=int, required=True, mutable=False)
    play_tone_to_agent_for_emergency_call: bool = Field(
        type=bool, required=True, mutable=False,
    )
    emergency_call_clid_prefix: str = Field(type=str, required=True, mutable=False)
    threshold_crossing_notification_email_guard_timer_seconds: int = Field(
        type=int, required=True, mutable=False,
    )
    allow_agent_device_initiated_forward: bool = Field(
        type=bool, required=True, mutable=False,
    )


class SystemCallCenterReportingServerGetListResponse(OCIResponse):
    """
    Response to ``SystemCallCenterReportingServerGetListRequest()``.

    The table columns are: "Name", "URL", "Net Address", and "Description".

    Attributes:
        reporting_server_table: reportingServerTable
    """

    _ELEMENTS = (
        E(
            "reporting_server_table", "reportingServerTable", list, is_complex=True,
            is_required=True, is_table=True,
        ),
    )

    reporting_server_table: "list" = Field(type=list, required=True, mutable=False)


class SystemCallMeNowGetResponse(OCIResponse):
    """
    Response to ``SystemCallMeNowGetRequest()``.


    Attributes:
        passcode_length: passcodeLength
        passcode_timeout_seconds: passcodeTimeoutSeconds
    """

    _ELEMENTS = (
        E("passcode_length", "passcodeLength", int, is_required=True),
        E("passcode_timeout_seconds", "passcodeTimeoutSeconds", int, is_required=True),
    )

    passcode_length: int = Field(type=int, required=True, mutable=False)
    passcode_timeout_seconds: int = Field(type=int, required=True, mutable=False)


class SystemCallNotifyGetResponse(OCIResponse):
    """
    Response to ``SystemCallNotifyGetRequest()``.


    Attributes:
        default_from_address: defaultFromAddress
        use_short_subject_line: useShortSubjectLine
        use_dn_in_mail_body: useDnInMailBody
    """

    _ELEMENTS = (
        E("default_from_address", "defaultFromAddress", str, is_required=True),
        E("use_short_subject_line", "useShortSubjectLine", bool, is_required=True),
        E("use_dn_in_mail_body", "useDnInMailBody", bool, is_required=True),
    )

    default_from_address: str = Field(type=str, required=True, mutable=False)
    use_short_subject_line: bool = Field(type=bool, required=True, mutable=False)
    use_dn_in_mail_body: bool = Field(type=bool, required=True, mutable=False)


class SystemCallProcessingGetPolicyResponse14(OCIResponse):
    """
    Response to ``SystemCallProcessingGetPolicyRequest14()``.


    Attributes:
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        enforce_enterprise_calling_line_identity_restriction:
            enforceEnterpriseCallingLineIdentityRestriction
        conference_uri: conferenceURI
        max_conference_parties: maxConferenceParties
    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("conference_uri", "conferenceURI", str),
        E("max_conference_parties", "maxConferenceParties", int, is_required=True),
    )

    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enforce_enterprise_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    conference_uri: str = Field(type=str, required=False, mutable=False)
    max_conference_parties: int = Field(type=int, required=True, mutable=False)


class SystemCallProcessingGetPolicyResponse14sp1(OCIResponse):
    """
    Response to ``SystemCallProcessingGetPolicyRequest14sp1()``.


    Attributes:
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        enforce_enterprise_calling_line_identity_restriction:
            enforceEnterpriseCallingLineIdentityRestriction
        conference_uri: conferenceURI
        max_conference_parties: maxConferenceParties
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E("conference_uri", "conferenceURI", str),
        E("max_conference_parties", "maxConferenceParties", int, is_required=True),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
    )

    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enforce_enterprise_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    conference_uri: str = Field(type=str, required=False, mutable=False)
    max_conference_parties: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )


class SystemCallProcessingGetPolicyResponse14sp4(OCIResponse):
    """
    Response to ``SystemCallProcessingGetPolicyRequest14sp4()``.

    Replaced By : ``SystemCallProcessingGetPolicyResponse15()``

    Attributes:
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        enforce_enterprise_calling_line_identity_restriction:
            enforceEnterpriseCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_external_calls_via_private_dialing_plan:
            overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        conference_uri: conferenceURI
        max_conference_parties: maxConferenceParties
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_external_calls_via_private_dialing_plan",
            "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan", bool,
            is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E("conference_uri", "conferenceURI", str),
        E("max_conference_parties", "maxConferenceParties", int, is_required=True),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
    )

    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enforce_enterprise_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    override_clid_restriction_for_external_calls_via_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(type=bool, required=True, mutable=False)
    conference_uri: str = Field(type=str, required=False, mutable=False)
    max_conference_parties: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )


class SystemCallProcessingGetPolicyResponse14sp7(OCIResponse):
    """
    Response to ``SystemCallProcessingGetPolicyRequest14sp7()``.


    Attributes:
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        enforce_enterprise_calling_line_identity_restriction:
            enforceEnterpriseCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_external_calls_via_private_dialing_plan:
            overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        conference_uri: conferenceURI
        max_conference_parties: maxConferenceParties
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
        clid_policy: clidPolicy
        emergency_clid_policy: emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity:
            allowAlternateNumbersForRedirectingIdentity
    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_external_calls_via_private_dialing_plan",
            "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan", bool,
            is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E("conference_uri", "conferenceURI", str),
        E("max_conference_parties", "maxConferenceParties", int, is_required=True),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
    )

    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enforce_enterprise_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    override_clid_restriction_for_external_calls_via_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(type=bool, required=True, mutable=False)
    conference_uri: str = Field(type=str, required=False, mutable=False)
    max_conference_parties: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )
    clid_policy: str = Field(type=str, required=True, mutable=False)
    emergency_clid_policy: str = Field(type=str, required=True, mutable=False)
    allow_alternate_numbers_for_redirecting_identity: bool = Field(
        type=bool, required=True, mutable=False,
    )


class SystemCallProcessingGetPolicyResponse15(OCIResponse):
    """
    Response to ``SystemCallProcessingGetPolicyRequest15()``.


    Attributes:
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        enforce_enterprise_calling_line_identity_restriction:
            enforceEnterpriseCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category:
            overrideCLIDRestrictionForPrivateCallCategory
        use_enterprise_clid_for_private_call_category:
            useEnterpriseCLIDForPrivateCallCategory
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        conference_uri: conferenceURI
        max_conference_parties: maxConferenceParties
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E("conference_uri", "conferenceURI", str),
        E("max_conference_parties", "maxConferenceParties", int, is_required=True),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
    )

    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enforce_enterprise_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    override_clid_restriction_for_private_call_category: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_enterprise_clid_for_private_call_category: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(type=bool, required=True, mutable=False)
    conference_uri: str = Field(type=str, required=False, mutable=False)
    max_conference_parties: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(type=bool, required=True, mutable=False)
    max_concurrent_redirected_calls: int = Field(type=int, required=True, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=True, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=True, mutable=False)
    max_redirection_depth: int = Field(type=int, required=True, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=True, mutable=False,
    )


class SystemCallProcessingGetPolicyResponse15sp2(OCIResponse):
    """
    Response to ``SystemCallProcessingGetPolicyRequest15sp2()``.


    Attributes:
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        enforce_enterprise_calling_line_identity_restriction:
            enforceEnterpriseCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category:
            overrideCLIDRestrictionForPrivateCallCategory
        use_enterprise_clid_for_private_call_category:
            useEnterpriseCLIDForPrivateCallCategory
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        conference_uri: conferenceURI
        max_conference_parties: maxConferenceParties
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
        clid_policy: clidPolicy
        emergency_clid_policy: emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity:
            allowAlternateNumbersForRedirectingIdentity
    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool, is_required=True),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int, is_required=True),
        E(
            "use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool,
            is_required=True,
        ),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int, is_required=True),
        E(
            "use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int, is_required=True,
        ),
        E(
            "use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls",
            bool, is_required=True,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int, is_required=True,
        ),
        E("media_policy_selection", "mediaPolicySelection", str, is_required=True),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str, is_required=True),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool, is_required=True,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool, is_required=True,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool, is_required=True,
        ),
        E(
            "enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing",
            bool, is_required=True,
        ),
        E("conference_uri", "conferenceURI", str),
        E("max_conference_parties", "maxConferenceParties", int, is_required=True),
        E(
            "use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls",
            bool, is_required=True,
        ),
        E(
            "max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int,
            is_required=True,
        ),
        E(
            "use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool,
            is_required=True,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int, is_required=True),
        E("max_redirection_depth", "maxRedirectionDepth", int, is_required=True),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool, is_required=True,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int, is_required=True,
        ),
        E("clid_policy", "clidPolicy", str, is_required=True),
        E("emergency_clid_policy", "emergencyClidPolicy", str, is_required=True),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool, is_required=True,
        ),
    )

    use_max_simultaneous_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=True, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=True, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=True, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=True, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=True, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=True, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=True, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enforce_enterprise_calling_line_identity_restriction: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=True, mutable=False,
    )
    override_clid_restriction_for_private_call_category: bool = Field(
        type=bool, required=True, mutable=False,
    )
    use_enterprise_clid_for_private_call_category: bool = Field(
        type=bool, required=True, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(type=bool, required=True, mutable=False)
    conference_uri: str = Field(type=str, required=False, mutable=False)
    max_conference_parties: int = Field(type=int, required=True, mutable=Fals