#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['sherpa_streamlit']

package_data = \
{'': ['*']}

package_dir = \
{'': 'src'}

install_requires = \
['pandas==1.2.3',
 'openpyxl==3.0.7',
 'streamlit~=1.2.0',
 'st-annotated-text',
 'requests',
 'plac==0.9.6',
 'collections-extended>=1.0.2',
 'python-multipart',
 'Pillow']

extras_require = \
{'dev': ['flit', 'pre-commit', 'bump2version'],
 'docs': ['sphinx',
          'sphinx-rtd-theme',
          'm2r2',
          'sphinxcontrib.apidoc',
          'jupyter_sphinx'],
 'test': ['pytest',
          'pytest-cov',
          'pytest-flake8',
          'types-requests',
          'flake8==3.9.2',
          'pytest-mypy',
          'pytest-black',
          'tox']}

setup(name='sherpa-streamlit',
      version='0.1.0',
      description='Kairntech Sherpa building blocks for Streamlit apps',
      author='Olivier Terrier',
      author_email='oterrier@gmail.com',
      url='https://github.com/oterrier/sherpa_streamlit/',
      packages=packages,
      package_data=package_data,
      package_dir=package_dir,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.8',
     )
