"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const aws_dynamodb_1 = require("@aws-cdk/aws-dynamodb");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const app = new core_1.App();
const stack = new core_1.Stack(app, 'Default');
new lib_1.GlobalTable(stack, 'globdynamodbinteg', {
    partitionKey: { name: 'hashKey', type: aws_dynamodb_1.AttributeType.STRING },
    tableName: 'integrationtest',
    regions: ["us-east-1", "us-east-2", "us-west-2"],
    removalPolicy: core_1.RemovalPolicy.DESTROY,
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZHluYW1vZGIuZ2xvYmFsLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcuZHluYW1vZGIuZ2xvYmFsLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsZ0JBQWdCO0FBQ2hCLHdEQUFzRDtBQUN0RCx3Q0FBMEQ7QUFDMUQsZ0NBQXFDO0FBRXJDLE1BQU0sR0FBRyxHQUFHLElBQUksVUFBRyxFQUFFLENBQUM7QUFDdEIsTUFBTSxLQUFLLEdBQUcsSUFBSSxZQUFLLENBQUMsR0FBRyxFQUFFLFNBQVMsQ0FBQyxDQUFDO0FBQ3hDLElBQUksaUJBQVcsQ0FBQyxLQUFLLEVBQUUsbUJBQW1CLEVBQUU7SUFDMUMsWUFBWSxFQUFFLEVBQUUsSUFBSSxFQUFFLFNBQVMsRUFBRSxJQUFJLEVBQUUsNEJBQWEsQ0FBQyxNQUFNLEVBQUU7SUFDN0QsU0FBUyxFQUFFLGlCQUFpQjtJQUM1QixPQUFPLEVBQUUsQ0FBQyxXQUFXLEVBQUUsV0FBVyxFQUFFLFdBQVcsQ0FBQztJQUNoRCxhQUFhLEVBQUUsb0JBQWEsQ0FBQyxPQUFPO0NBQ3JDLENBQUMsQ0FBQztBQUNILEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vLyAhY2RrLWludGVnICpcbmltcG9ydCB7IEF0dHJpYnV0ZVR5cGUgfSBmcm9tICdAYXdzLWNkay9hd3MtZHluYW1vZGInO1xuaW1wb3J0IHsgQXBwLCBSZW1vdmFsUG9saWN5LCBTdGFjayB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgR2xvYmFsVGFibGUgfSBmcm9tICcuLi9saWInO1xuXG5jb25zdCBhcHAgPSBuZXcgQXBwKCk7XG5jb25zdCBzdGFjayA9IG5ldyBTdGFjayhhcHAsICdEZWZhdWx0Jyk7XG5uZXcgR2xvYmFsVGFibGUoc3RhY2ssICdnbG9iZHluYW1vZGJpbnRlZycsIHtcbiAgcGFydGl0aW9uS2V5OiB7IG5hbWU6ICdoYXNoS2V5JywgdHlwZTogQXR0cmlidXRlVHlwZS5TVFJJTkcgfSxcbiAgdGFibGVOYW1lOiAnaW50ZWdyYXRpb250ZXN0JyxcbiAgcmVnaW9uczogW1widXMtZWFzdC0xXCIsIFwidXMtZWFzdC0yXCIsIFwidXMtd2VzdC0yXCJdLFxuICByZW1vdmFsUG9saWN5OiBSZW1vdmFsUG9saWN5LkRFU1RST1ksXG59KTtcbmFwcC5zeW50aCgpO1xuIl19