"use strict";
const assert_1 = require("@aws-cdk/assert");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
class FakeDestination {
    bind(_scope, _sourceLogGroup) {
        return {
            arn: 'arn:bogus',
        };
    }
}
module.exports = {
    'trivial instantiation'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        const logGroup = new lib_1.LogGroup(stack, 'LogGroup');
        // WHEN
        new lib_1.SubscriptionFilter(stack, 'Subscription', {
            logGroup,
            destination: new FakeDestination(),
            filterPattern: lib_1.FilterPattern.literal('some pattern'),
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::Logs::SubscriptionFilter', {
            DestinationArn: 'arn:bogus',
            FilterPattern: 'some pattern',
            LogGroupName: { Ref: 'LogGroupF5B46931' },
        }));
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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