import os

from hasura_metadata_manager import Supergraph
from hasura_metadata_manager.load import create_engine_config
from hasura_metadata_manager.utilities import managed_session, SchemaHelper, rdf_to_advanced_graph

logger = __import__("logging").getLogger(__name__)


def export_rdf(center_node=None, hops=None):
    engine = None
    try:
        Supergraph.configure_neo4j()

        engine = create_engine_config(os.environ.get("DATABASE_URL"))
        with managed_session(engine) as session:
            si = SchemaHelper(session)
            graph = si.generate_rdf_definitions_for_classes()
            Supergraph.sync_all_to_neo4j(session=session, source_graph=graph)

            # Serialize the graph to Turtle format
            rdf_output = graph.serialize(format="turtle").decode("utf-8")

            # Call rdf_to_advanced_graph only if center_node and hops are not None
            if center_node is not None and hops is not None:
                rdf_to_advanced_graph(turtle_data=rdf_output, center_node=center_node, max_hops=hops)

            # Print/log the output
            logger.debug(rdf_output)

            # Return the serialized RDF graph as a string
            return rdf_output

    finally:
        # Ensure engine disposal regardless of whether an exception occurred
        engine.dispose()
