/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import javax.xml.transform.Templates;
import javax.xml.transform.sax.TemplatesHandler;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.CommentStripper;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.StylesheetStripper;
import net.sf.saxon.style.UseWhenFilter;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.TreeBuilder;

public class TemplatesHandlerImpl
extends ReceivingContentHandler
implements TemplatesHandler {
    private TreeBuilder builder;
    private StyleNodeFactory nodeFactory;
    private Templates templates;
    private String systemId;

    protected TemplatesHandlerImpl(Configuration config) {
        this.setPipelineConfiguration(config.makePipelineConfiguration());
        this.nodeFactory = new StyleNodeFactory(config, this.getPipelineConfiguration().getErrorListener());
        this.builder = new TreeBuilder();
        this.builder.setPipelineConfiguration(this.getPipelineConfiguration());
        this.builder.setNodeFactory(this.nodeFactory);
        this.builder.setLineNumbering(true);
        StartTagBuffer startTagBuffer = new StartTagBuffer();
        UseWhenFilter useWhenFilter = new UseWhenFilter(startTagBuffer);
        useWhenFilter.setUnderlyingReceiver(this.builder);
        useWhenFilter.setPipelineConfiguration(this.getPipelineConfiguration());
        startTagBuffer.setUnderlyingReceiver(useWhenFilter);
        startTagBuffer.setPipelineConfiguration(this.getPipelineConfiguration());
        StylesheetStripper styleStripper = new StylesheetStripper();
        styleStripper.setStylesheetRules(config.getNamePool());
        styleStripper.setUnderlyingReceiver(startTagBuffer);
        styleStripper.setPipelineConfiguration(this.getPipelineConfiguration());
        CommentStripper commentStripper = new CommentStripper();
        commentStripper.setUnderlyingReceiver(styleStripper);
        commentStripper.setPipelineConfiguration(this.getPipelineConfiguration());
        this.setReceiver(commentStripper);
    }

    public Templates getTemplates() {
        if (this.templates == null) {
            DocumentImpl doc = (DocumentImpl)this.builder.getCurrentRoot();
            if (doc == null) {
                return null;
            }
            Configuration config = this.getConfiguration();
            CompilerInfo info = new CompilerInfo();
            info.setURIResolver(config.getURIResolver());
            info.setErrorListener(config.getErrorListener());
            info.setCompileWithTracing(config.isCompileWithTracing());
            PreparedStylesheet sheet = new PreparedStylesheet(config, info);
            try {
                sheet.setStylesheetDocument(doc, this.nodeFactory);
                this.templates = sheet;
            }
            catch (XPathException tce) {
                throw new UnsupportedOperationException(tce.getMessage());
            }
        }
        return this.templates;
    }

    public void setSystemId(String url) {
        this.systemId = url;
        this.builder.setSystemId(url);
    }

    public String getSystemId() {
        return this.systemId;
    }
}

