import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudSnapshotConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/snapshot#id DataIonoscloudSnapshot#id}
    */
    readonly id?: string;
    /**
    * Location of that image/snapshot
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/snapshot#location DataIonoscloudSnapshot#location}
    */
    readonly location?: string;
    /**
    * A name of that resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/snapshot#name DataIonoscloudSnapshot#name}
    */
    readonly name?: string;
    /**
    * The size of the image in GB
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/snapshot#size DataIonoscloudSnapshot#size}
    */
    readonly size?: number;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/snapshot#timeouts DataIonoscloudSnapshot#timeouts}
    */
    readonly timeouts?: DataIonoscloudSnapshotTimeouts;
}
export interface DataIonoscloudSnapshotTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/snapshot#create DataIonoscloudSnapshot#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/snapshot#default DataIonoscloudSnapshot#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/snapshot#delete DataIonoscloudSnapshot#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/snapshot#update DataIonoscloudSnapshot#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudSnapshotTimeoutsToTerraform(struct?: DataIonoscloudSnapshotTimeoutsOutputReference | DataIonoscloudSnapshotTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudSnapshotTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudSnapshotTimeouts | undefined;
    set internalValue(value: DataIonoscloudSnapshotTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/snapshot ionoscloud_snapshot}
*/
export declare class DataIonoscloudSnapshot extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_snapshot";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/snapshot ionoscloud_snapshot} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudSnapshotConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataIonoscloudSnapshotConfig);
    get cpuHotPlug(): cdktf.IResolvable;
    get cpuHotUnplug(): cdktf.IResolvable;
    get description(): string;
    get discScsiHotPlug(): cdktf.IResolvable;
    get discScsiHotUnplug(): cdktf.IResolvable;
    get discVirtioHotPlug(): cdktf.IResolvable;
    get discVirtioHotUnplug(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get licenceType(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get nicHotPlug(): cdktf.IResolvable;
    get nicHotUnplug(): cdktf.IResolvable;
    get ramHotPlug(): cdktf.IResolvable;
    get ramHotUnplug(): cdktf.IResolvable;
    get secAuthProtection(): cdktf.IResolvable;
    private _size?;
    get size(): number;
    set size(value: number);
    resetSize(): void;
    get sizeInput(): number | undefined;
    private _timeouts;
    get timeouts(): DataIonoscloudSnapshotTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudSnapshotTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataIonoscloudSnapshotTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
